// SPDX-License-Identifier: GPL-2.0
#include <linux/suspend.h>
#include <linux/syscore_ops.h>
#include <linux/acpi.h>

#include <asm/suspend.h>

struct syscore_ops io_syscore_ops;

static int __init sw64_pm_init(void)
{
#ifdef CONFIG_SUSPEND
	if (!acpi_disabled && acpi_sleep_state_supported(ACPI_STATE_S3))
		acpi_suspend_lowlevel = sw64_suspend_enter;
	else
		suspend_set_ops(&native_suspend_ops);
#endif
	register_syscore_ops(&io_syscore_ops);

	return 0;
}
device_initcall(sw64_pm_init);
