; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=aarch64-unknown-linux-gnu -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @extaddv1(i8 %i8, i16 %i16, i32 %i32, i64 %i64)  {
; CHECK-LABEL: 'extaddv1'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = add i16 %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = add i16 %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = add i16 %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = add i16 %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = add i32 %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = add i32 %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = add i32 %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = add i32 %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_64 = add i64 %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_64 = add i64 %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_64 = add i64 %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_64 = add i64 %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = add i32 %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = add i32 %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = add i32 %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = add i32 %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_64 = add i64 %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_64 = add i64 %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_64 = add i64 %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_64 = add i64 %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_32_64 = add i64 %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_32_64 = add i64 %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_32_64 = add i64 %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_32_64 = add i64 %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext i8 %i8 to i16
  %asw_8_16 = add i16 %i16, %sw_8_16
  %sl1_8_16 = sext i8 %i8 to i16
  %sl2_8_16 = sext i8 %i8 to i16
  %asl_8_16 = add i16 %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext i8 %i8 to i16
  %azw_8_16 = add i16 %i16, %zw_8_16
  %zl1_8_16 = zext i8 %i8 to i16
  %zl2_8_16 = zext i8 %i8 to i16
  %azl_8_16 = add i16 %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext i8 %i8 to i32
  %asw_8_32 = add i32 %i32, %sw_8_32
  %sl1_8_32 = sext i8 %i8 to i32
  %sl2_8_32 = sext i8 %i8 to i32
  %asl_8_32 = add i32 %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext i8 %i8 to i32
  %azw_8_32 = add i32 %i32, %zw_8_32
  %zl1_8_32 = zext i8 %i8 to i32
  %zl2_8_32 = zext i8 %i8 to i32
  %azl_8_32 = add i32 %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext i8 %i8 to i64
  %asw_8_64 = add i64 %i64, %sw_8_64
  %sl1_8_64 = sext i8 %i8 to i64
  %sl2_8_64 = sext i8 %i8 to i64
  %asl_8_64 = add i64 %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext i8 %i8 to i64
  %azw_8_64 = add i64 %i64, %zw_8_64
  %zl1_8_64 = zext i8 %i8 to i64
  %zl2_8_64 = zext i8 %i8 to i64
  %azl_8_64 = add i64 %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext i16 %i16 to i32
  %asw_16_32 = add i32 %i32, %sw_16_32
  %sl1_16_32 = sext i16 %i16 to i32
  %sl2_16_32 = sext i16 %i16 to i32
  %asl_16_32 = add i32 %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext i16 %i16 to i32
  %azw_16_32 = add i32 %i32, %zw_16_32
  %zl1_16_32 = zext i16 %i16 to i32
  %zl2_16_32 = zext i16 %i16 to i32
  %azl_16_32 = add i32 %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext i16 %i16 to i64
  %asw_16_64 = add i64 %i64, %sw_16_64
  %sl1_16_64 = sext i16 %i16 to i64
  %sl2_16_64 = sext i16 %i16 to i64
  %asl_16_64 = add i64 %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext i16 %i16 to i64
  %azw_16_64 = add i64 %i64, %zw_16_64
  %zl1_16_64 = zext i16 %i16 to i64
  %zl2_16_64 = zext i16 %i16 to i64
  %azl_16_64 = add i64 %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext i32 %i32 to i64
  %asw_32_64 = add i64 %i64, %sw_32_64
  %sl1_32_64 = sext i32 %i32 to i64
  %sl2_32_64 = sext i32 %i32 to i64
  %asl_32_64 = add i64 %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext i32 %i32 to i64
  %azw_32_64 = add i64 %i64, %zw_32_64
  %zl1_32_64 = zext i32 %i32 to i64
  %zl2_32_64 = zext i32 %i32 to i64
  %azl_32_64 = add i64 %zl1_32_64, %zl2_32_64

  ret void
}

define void @extaddv2(<2 x i8> %i8, <2 x i16> %i16, <2 x i32> %i32, <2 x i64> %i64)  {
; CHECK-LABEL: 'extaddv2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = add <2 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = add <2 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = add <2 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = add <2 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = add <2 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = add <2 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = add <2 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = add <2 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_64 = add <2 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_64 = add <2 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_64 = add <2 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_64 = add <2 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = add <2 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = add <2 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = add <2 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = add <2 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_64 = add <2 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_64 = add <2 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_64 = add <2 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_64 = add <2 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_32_64 = add <2 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_32_64 = add <2 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_32_64 = add <2 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_32_64 = add <2 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %asw_8_16 = add <2 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %sl2_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %asl_8_16 = add <2 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %azw_8_16 = add <2 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %zl2_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %azl_8_16 = add <2 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %asw_8_32 = add <2 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %sl2_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %asl_8_32 = add <2 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %azw_8_32 = add <2 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %zl2_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %azl_8_32 = add <2 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %asw_8_64 = add <2 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %sl2_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %asl_8_64 = add <2 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %azw_8_64 = add <2 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %zl2_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %azl_8_64 = add <2 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %asw_16_32 = add <2 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %sl2_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %asl_16_32 = add <2 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %azw_16_32 = add <2 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %zl2_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %azl_16_32 = add <2 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %asw_16_64 = add <2 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %sl2_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %asl_16_64 = add <2 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %azw_16_64 = add <2 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %zl2_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %azl_16_64 = add <2 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %asw_32_64 = add <2 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %sl2_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %asl_32_64 = add <2 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %azw_32_64 = add <2 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %zl2_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %azl_32_64 = add <2 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extaddv4(<4 x i8> %i8, <4 x i16> %i16, <4 x i32> %i32, <4 x i64> %i64)  {
; CHECK-LABEL: 'extaddv4'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = add <4 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = add <4 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = add <4 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = add <4 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = add <4 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = add <4 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = add <4 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = add <4 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_64 = add <4 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_64 = add <4 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_64 = add <4 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_64 = add <4 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = add <4 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = add <4 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = add <4 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = add <4 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_16_64 = add <4 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_16_64 = add <4 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_16_64 = add <4 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_16_64 = add <4 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_32_64 = add <4 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_32_64 = add <4 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_32_64 = add <4 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_32_64 = add <4 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %asw_8_16 = add <4 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %sl2_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %asl_8_16 = add <4 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %azw_8_16 = add <4 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %zl2_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %azl_8_16 = add <4 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %asw_8_32 = add <4 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %sl2_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %asl_8_32 = add <4 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %azw_8_32 = add <4 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %zl2_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %azl_8_32 = add <4 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %asw_8_64 = add <4 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %sl2_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %asl_8_64 = add <4 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %azw_8_64 = add <4 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %zl2_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %azl_8_64 = add <4 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %asw_16_32 = add <4 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %sl2_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %asl_16_32 = add <4 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %azw_16_32 = add <4 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %zl2_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %azl_16_32 = add <4 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %asw_16_64 = add <4 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %sl2_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %asl_16_64 = add <4 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %azw_16_64 = add <4 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %zl2_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %azl_16_64 = add <4 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %asw_32_64 = add <4 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %sl2_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %asl_32_64 = add <4 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %azw_32_64 = add <4 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %zl2_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %azl_32_64 = add <4 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extaddv8(<8 x i8> %i8, <8 x i16> %i16, <8 x i32> %i32, <8 x i64> %i64)  {
; CHECK-LABEL: 'extaddv8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = add <8 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = add <8 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = add <8 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = add <8 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_32 = add <8 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_32 = add <8 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_32 = add <8 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_32 = add <8 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sw_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_8_64 = add <8 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sl1_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sl2_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_8_64 = add <8 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zw_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_8_64 = add <8 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zl1_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zl2_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_8_64 = add <8 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_16_32 = add <8 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_16_32 = add <8 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_16_32 = add <8 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_16_32 = add <8 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sw_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_16_64 = add <8 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl1_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl2_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_16_64 = add <8 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zw_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_16_64 = add <8 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl1_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl2_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_16_64 = add <8 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_32_64 = add <8 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_32_64 = add <8 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_32_64 = add <8 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_32_64 = add <8 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %asw_8_16 = add <8 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %sl2_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %asl_8_16 = add <8 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %azw_8_16 = add <8 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %zl2_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %azl_8_16 = add <8 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %asw_8_32 = add <8 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %sl2_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %asl_8_32 = add <8 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %azw_8_32 = add <8 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %zl2_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %azl_8_32 = add <8 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %asw_8_64 = add <8 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %sl2_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %asl_8_64 = add <8 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %azw_8_64 = add <8 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %zl2_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %azl_8_64 = add <8 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %asw_16_32 = add <8 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %sl2_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %asl_16_32 = add <8 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %azw_16_32 = add <8 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %zl2_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %azl_16_32 = add <8 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %asw_16_64 = add <8 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %sl2_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %asl_16_64 = add <8 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %azw_16_64 = add <8 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %zl2_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %azl_16_64 = add <8 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %asw_32_64 = add <8 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %sl2_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %asl_32_64 = add <8 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %azw_32_64 = add <8 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %zl2_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %azl_32_64 = add <8 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extaddv16(<16 x i8> %i8, <16 x i16> %i16, <16 x i32> %i32, <16 x i64> %i64)  {
; CHECK-LABEL: 'extaddv16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_16 = add <16 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_16 = add <16 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_16 = add <16 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_16 = add <16 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sw_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_8_32 = add <16 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl1_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl2_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_8_32 = add <16 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zw_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_8_32 = add <16 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl1_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl2_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_8_32 = add <16 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sw_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asw_8_64 = add <16 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sl1_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sl2_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asl_8_64 = add <16 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zw_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azw_8_64 = add <16 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zl1_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zl2_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azl_8_64 = add <16 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_16_32 = add <16 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_16_32 = add <16 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_16_32 = add <16 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_16_32 = add <16 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sw_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asw_16_64 = add <16 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sl1_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sl2_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asl_16_64 = add <16 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zw_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azw_16_64 = add <16 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zl1_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zl2_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azl_16_64 = add <16 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asw_32_64 = add <16 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asl_32_64 = add <16 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azw_32_64 = add <16 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azl_32_64 = add <16 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %asw_8_16 = add <16 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %sl2_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %asl_8_16 = add <16 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %azw_8_16 = add <16 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %zl2_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %azl_8_16 = add <16 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %asw_8_32 = add <16 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %sl2_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %asl_8_32 = add <16 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %azw_8_32 = add <16 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %zl2_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %azl_8_32 = add <16 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %asw_8_64 = add <16 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %sl2_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %asl_8_64 = add <16 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %azw_8_64 = add <16 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %zl2_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %azl_8_64 = add <16 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %asw_16_32 = add <16 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %sl2_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %asl_16_32 = add <16 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %azw_16_32 = add <16 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %zl2_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %azl_16_32 = add <16 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %asw_16_64 = add <16 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %sl2_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %asl_16_64 = add <16 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %azw_16_64 = add <16 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %zl2_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %azl_16_64 = add <16 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %asw_32_64 = add <16 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %sl2_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %asl_32_64 = add <16 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %azw_32_64 = add <16 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %zl2_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %azl_32_64 = add <16 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extsubv1(i8 %i8, i16 %i16, i32 %i32, i64 %i64)  {
; CHECK-LABEL: 'extsubv1'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = sub i16 %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = sub i16 %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = sub i16 %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = sub i16 %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = sub i32 %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = sub i32 %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = sub i32 %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = sub i32 %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_64 = sub i64 %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_64 = sub i64 %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_64 = sub i64 %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_64 = sub i64 %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = sub i32 %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = sub i32 %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = sub i32 %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = sub i32 %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_64 = sub i64 %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_64 = sub i64 %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_64 = sub i64 %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_64 = sub i64 %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_32_64 = sub i64 %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_32_64 = sub i64 %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_32_64 = sub i64 %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_32_64 = sub i64 %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext i8 %i8 to i16
  %asw_8_16 = sub i16 %i16, %sw_8_16
  %sl1_8_16 = sext i8 %i8 to i16
  %sl2_8_16 = sext i8 %i8 to i16
  %asl_8_16 = sub i16 %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext i8 %i8 to i16
  %azw_8_16 = sub i16 %i16, %zw_8_16
  %zl1_8_16 = zext i8 %i8 to i16
  %zl2_8_16 = zext i8 %i8 to i16
  %azl_8_16 = sub i16 %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext i8 %i8 to i32
  %asw_8_32 = sub i32 %i32, %sw_8_32
  %sl1_8_32 = sext i8 %i8 to i32
  %sl2_8_32 = sext i8 %i8 to i32
  %asl_8_32 = sub i32 %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext i8 %i8 to i32
  %azw_8_32 = sub i32 %i32, %zw_8_32
  %zl1_8_32 = zext i8 %i8 to i32
  %zl2_8_32 = zext i8 %i8 to i32
  %azl_8_32 = sub i32 %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext i8 %i8 to i64
  %asw_8_64 = sub i64 %i64, %sw_8_64
  %sl1_8_64 = sext i8 %i8 to i64
  %sl2_8_64 = sext i8 %i8 to i64
  %asl_8_64 = sub i64 %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext i8 %i8 to i64
  %azw_8_64 = sub i64 %i64, %zw_8_64
  %zl1_8_64 = zext i8 %i8 to i64
  %zl2_8_64 = zext i8 %i8 to i64
  %azl_8_64 = sub i64 %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext i16 %i16 to i32
  %asw_16_32 = sub i32 %i32, %sw_16_32
  %sl1_16_32 = sext i16 %i16 to i32
  %sl2_16_32 = sext i16 %i16 to i32
  %asl_16_32 = sub i32 %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext i16 %i16 to i32
  %azw_16_32 = sub i32 %i32, %zw_16_32
  %zl1_16_32 = zext i16 %i16 to i32
  %zl2_16_32 = zext i16 %i16 to i32
  %azl_16_32 = sub i32 %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext i16 %i16 to i64
  %asw_16_64 = sub i64 %i64, %sw_16_64
  %sl1_16_64 = sext i16 %i16 to i64
  %sl2_16_64 = sext i16 %i16 to i64
  %asl_16_64 = sub i64 %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext i16 %i16 to i64
  %azw_16_64 = sub i64 %i64, %zw_16_64
  %zl1_16_64 = zext i16 %i16 to i64
  %zl2_16_64 = zext i16 %i16 to i64
  %azl_16_64 = sub i64 %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext i32 %i32 to i64
  %asw_32_64 = sub i64 %i64, %sw_32_64
  %sl1_32_64 = sext i32 %i32 to i64
  %sl2_32_64 = sext i32 %i32 to i64
  %asl_32_64 = sub i64 %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext i32 %i32 to i64
  %azw_32_64 = sub i64 %i64, %zw_32_64
  %zl1_32_64 = zext i32 %i32 to i64
  %zl2_32_64 = zext i32 %i32 to i64
  %azl_32_64 = sub i64 %zl1_32_64, %zl2_32_64

  ret void
}

define void @extsubv2(<2 x i8> %i8, <2 x i16> %i16, <2 x i32> %i32, <2 x i64> %i64)  {
; CHECK-LABEL: 'extsubv2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = sub <2 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = sub <2 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = sub <2 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = sub <2 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = sub <2 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = sub <2 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = sub <2 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = sub <2 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_64 = sub <2 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_64 = sub <2 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_64 = sub <2 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_64 = sub <2 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = sub <2 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = sub <2 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = sub <2 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = sub <2 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_64 = sub <2 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_64 = sub <2 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_64 = sub <2 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_64 = sub <2 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_32_64 = sub <2 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_32_64 = sub <2 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_32_64 = sub <2 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_32_64 = sub <2 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %asw_8_16 = sub <2 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %sl2_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %asl_8_16 = sub <2 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %azw_8_16 = sub <2 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %zl2_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %azl_8_16 = sub <2 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %asw_8_32 = sub <2 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %sl2_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %asl_8_32 = sub <2 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %azw_8_32 = sub <2 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %zl2_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %azl_8_32 = sub <2 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %asw_8_64 = sub <2 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %sl2_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %asl_8_64 = sub <2 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %azw_8_64 = sub <2 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %zl2_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %azl_8_64 = sub <2 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %asw_16_32 = sub <2 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %sl2_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %asl_16_32 = sub <2 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %azw_16_32 = sub <2 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %zl2_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %azl_16_32 = sub <2 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %asw_16_64 = sub <2 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %sl2_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %asl_16_64 = sub <2 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %azw_16_64 = sub <2 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %zl2_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %azl_16_64 = sub <2 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %asw_32_64 = sub <2 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %sl2_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %asl_32_64 = sub <2 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %azw_32_64 = sub <2 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %zl2_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %azl_32_64 = sub <2 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extsubv4(<4 x i8> %i8, <4 x i16> %i16, <4 x i32> %i32, <4 x i64> %i64)  {
; CHECK-LABEL: 'extsubv4'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = sub <4 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = sub <4 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = sub <4 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = sub <4 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = sub <4 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = sub <4 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = sub <4 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = sub <4 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_64 = sub <4 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_64 = sub <4 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_64 = sub <4 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_64 = sub <4 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = sub <4 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = sub <4 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = sub <4 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = sub <4 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_16_64 = sub <4 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_16_64 = sub <4 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_16_64 = sub <4 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_16_64 = sub <4 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_32_64 = sub <4 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_32_64 = sub <4 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_32_64 = sub <4 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_32_64 = sub <4 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %asw_8_16 = sub <4 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %sl2_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %asl_8_16 = sub <4 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %azw_8_16 = sub <4 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %zl2_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %azl_8_16 = sub <4 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %asw_8_32 = sub <4 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %sl2_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %asl_8_32 = sub <4 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %azw_8_32 = sub <4 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %zl2_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %azl_8_32 = sub <4 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %asw_8_64 = sub <4 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %sl2_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %asl_8_64 = sub <4 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %azw_8_64 = sub <4 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %zl2_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %azl_8_64 = sub <4 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %asw_16_32 = sub <4 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %sl2_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %asl_16_32 = sub <4 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %azw_16_32 = sub <4 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %zl2_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %azl_16_32 = sub <4 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %asw_16_64 = sub <4 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %sl2_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %asl_16_64 = sub <4 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %azw_16_64 = sub <4 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %zl2_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %azl_16_64 = sub <4 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %asw_32_64 = sub <4 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %sl2_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %asl_32_64 = sub <4 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %azw_32_64 = sub <4 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %zl2_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %azl_32_64 = sub <4 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extsubv8(<8 x i8> %i8, <8 x i16> %i16, <8 x i32> %i32, <8 x i64> %i64)  {
; CHECK-LABEL: 'extsubv8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = sub <8 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = sub <8 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = sub <8 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = sub <8 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_32 = sub <8 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_32 = sub <8 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_32 = sub <8 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_32 = sub <8 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sw_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_8_64 = sub <8 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sl1_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sl2_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_8_64 = sub <8 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zw_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_8_64 = sub <8 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zl1_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zl2_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_8_64 = sub <8 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_16_32 = sub <8 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_16_32 = sub <8 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_16_32 = sub <8 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_16_32 = sub <8 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sw_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_16_64 = sub <8 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl1_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl2_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_16_64 = sub <8 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zw_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_16_64 = sub <8 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl1_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl2_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_16_64 = sub <8 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_32_64 = sub <8 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_32_64 = sub <8 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_32_64 = sub <8 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_32_64 = sub <8 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %asw_8_16 = sub <8 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %sl2_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %asl_8_16 = sub <8 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %azw_8_16 = sub <8 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %zl2_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %azl_8_16 = sub <8 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %asw_8_32 = sub <8 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %sl2_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %asl_8_32 = sub <8 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %azw_8_32 = sub <8 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %zl2_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %azl_8_32 = sub <8 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %asw_8_64 = sub <8 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %sl2_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %asl_8_64 = sub <8 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %azw_8_64 = sub <8 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %zl2_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %azl_8_64 = sub <8 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %asw_16_32 = sub <8 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %sl2_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %asl_16_32 = sub <8 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %azw_16_32 = sub <8 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %zl2_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %azl_16_32 = sub <8 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %asw_16_64 = sub <8 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %sl2_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %asl_16_64 = sub <8 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %azw_16_64 = sub <8 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %zl2_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %azl_16_64 = sub <8 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %asw_32_64 = sub <8 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %sl2_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %asl_32_64 = sub <8 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %azw_32_64 = sub <8 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %zl2_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %azl_32_64 = sub <8 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extsubv16(<16 x i8> %i8, <16 x i16> %i16, <16 x i32> %i32, <16 x i64> %i64)  {
; CHECK-LABEL: 'extsubv16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_16 = sub <16 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_16 = sub <16 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_16 = sub <16 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_16 = sub <16 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sw_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_8_32 = sub <16 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl1_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl2_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_8_32 = sub <16 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zw_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_8_32 = sub <16 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl1_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl2_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_8_32 = sub <16 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sw_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asw_8_64 = sub <16 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sl1_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sl2_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asl_8_64 = sub <16 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zw_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azw_8_64 = sub <16 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zl1_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zl2_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azl_8_64 = sub <16 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_16_32 = sub <16 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_16_32 = sub <16 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_16_32 = sub <16 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_16_32 = sub <16 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sw_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asw_16_64 = sub <16 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sl1_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sl2_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asl_16_64 = sub <16 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zw_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azw_16_64 = sub <16 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zl1_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zl2_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azl_16_64 = sub <16 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sw_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asw_32_64 = sub <16 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asl_32_64 = sub <16 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azw_32_64 = sub <16 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azl_32_64 = sub <16 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %asw_8_16 = sub <16 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %sl2_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %asl_8_16 = sub <16 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %azw_8_16 = sub <16 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %zl2_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %azl_8_16 = sub <16 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %asw_8_32 = sub <16 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %sl2_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %asl_8_32 = sub <16 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %azw_8_32 = sub <16 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %zl2_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %azl_8_32 = sub <16 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %asw_8_64 = sub <16 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %sl2_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %asl_8_64 = sub <16 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %azw_8_64 = sub <16 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %zl2_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %azl_8_64 = sub <16 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %asw_16_32 = sub <16 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %sl2_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %asl_16_32 = sub <16 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %azw_16_32 = sub <16 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %zl2_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %azl_16_32 = sub <16 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %asw_16_64 = sub <16 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %sl2_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %asl_16_64 = sub <16 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %azw_16_64 = sub <16 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %zl2_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %azl_16_64 = sub <16 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %asw_32_64 = sub <16 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %sl2_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %asl_32_64 = sub <16 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %azw_32_64 = sub <16 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %zl2_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %azl_32_64 = sub <16 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extmulv1(i8 %i8, i16 %i16, i32 %i32, i64 %i64)  {
; CHECK-LABEL: 'extmulv1'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = mul i16 %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = mul i16 %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = mul i16 %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext i8 %i8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = mul i16 %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = mul i32 %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = mul i32 %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = mul i32 %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext i8 %i8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = mul i32 %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_64 = mul i64 %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_64 = sext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_64 = mul i64 %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_64 = mul i64 %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_64 = zext i8 %i8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_64 = mul i64 %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = mul i32 %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_32 = sext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = mul i32 %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = mul i32 %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_32 = zext i16 %i16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = mul i32 %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_64 = mul i64 %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_64 = sext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_64 = mul i64 %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_64 = mul i64 %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_64 = zext i16 %i16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_64 = mul i64 %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_32_64 = mul i64 %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_32_64 = sext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_32_64 = mul i64 %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zw_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_32_64 = mul i64 %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext i32 %i32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_32_64 = mul i64 %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext i8 %i8 to i16
  %asw_8_16 = mul i16 %i16, %sw_8_16
  %sl1_8_16 = sext i8 %i8 to i16
  %sl2_8_16 = sext i8 %i8 to i16
  %asl_8_16 = mul i16 %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext i8 %i8 to i16
  %azw_8_16 = mul i16 %i16, %zw_8_16
  %zl1_8_16 = zext i8 %i8 to i16
  %zl2_8_16 = zext i8 %i8 to i16
  %azl_8_16 = mul i16 %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext i8 %i8 to i32
  %asw_8_32 = mul i32 %i32, %sw_8_32
  %sl1_8_32 = sext i8 %i8 to i32
  %sl2_8_32 = sext i8 %i8 to i32
  %asl_8_32 = mul i32 %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext i8 %i8 to i32
  %azw_8_32 = mul i32 %i32, %zw_8_32
  %zl1_8_32 = zext i8 %i8 to i32
  %zl2_8_32 = zext i8 %i8 to i32
  %azl_8_32 = mul i32 %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext i8 %i8 to i64
  %asw_8_64 = mul i64 %i64, %sw_8_64
  %sl1_8_64 = sext i8 %i8 to i64
  %sl2_8_64 = sext i8 %i8 to i64
  %asl_8_64 = mul i64 %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext i8 %i8 to i64
  %azw_8_64 = mul i64 %i64, %zw_8_64
  %zl1_8_64 = zext i8 %i8 to i64
  %zl2_8_64 = zext i8 %i8 to i64
  %azl_8_64 = mul i64 %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext i16 %i16 to i32
  %asw_16_32 = mul i32 %i32, %sw_16_32
  %sl1_16_32 = sext i16 %i16 to i32
  %sl2_16_32 = sext i16 %i16 to i32
  %asl_16_32 = mul i32 %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext i16 %i16 to i32
  %azw_16_32 = mul i32 %i32, %zw_16_32
  %zl1_16_32 = zext i16 %i16 to i32
  %zl2_16_32 = zext i16 %i16 to i32
  %azl_16_32 = mul i32 %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext i16 %i16 to i64
  %asw_16_64 = mul i64 %i64, %sw_16_64
  %sl1_16_64 = sext i16 %i16 to i64
  %sl2_16_64 = sext i16 %i16 to i64
  %asl_16_64 = mul i64 %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext i16 %i16 to i64
  %azw_16_64 = mul i64 %i64, %zw_16_64
  %zl1_16_64 = zext i16 %i16 to i64
  %zl2_16_64 = zext i16 %i16 to i64
  %azl_16_64 = mul i64 %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext i32 %i32 to i64
  %asw_32_64 = mul i64 %i64, %sw_32_64
  %sl1_32_64 = sext i32 %i32 to i64
  %sl2_32_64 = sext i32 %i32 to i64
  %asl_32_64 = mul i64 %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext i32 %i32 to i64
  %azw_32_64 = mul i64 %i64, %zw_32_64
  %zl1_32_64 = zext i32 %i32 to i64
  %zl2_32_64 = zext i32 %i32 to i64
  %azl_32_64 = mul i64 %zl1_32_64, %zl2_32_64

  ret void
}

define void @extmulv2(<2 x i8> %i8, <2 x i16> %i16, <2 x i32> %i32, <2 x i64> %i64)  {
; CHECK-LABEL: 'extmulv2'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = mul <2 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = mul <2 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = mul <2 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext <2 x i8> %i8 to <2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = mul <2 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = mul <2 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = mul <2 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = mul <2 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext <2 x i8> %i8 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = mul <2 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %asw_8_64 = mul <2 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_64 = sext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %asl_8_64 = mul <2 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %azw_8_64 = mul <2 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_64 = zext <2 x i8> %i8 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %azl_8_64 = mul <2 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = mul <2 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_32 = sext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = mul <2 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = mul <2 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_32 = zext <2 x i16> %i16 to <2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = mul <2 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %asw_16_64 = mul <2 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_16_64 = sext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %asl_16_64 = mul <2 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %azw_16_64 = mul <2 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_16_64 = zext <2 x i16> %i16 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %azl_16_64 = mul <2 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %asw_32_64 = mul <2 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_32_64 = mul <2 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %azw_32_64 = mul <2 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <2 x i32> %i32 to <2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_32_64 = mul <2 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %asw_8_16 = mul <2 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %sl2_8_16 = sext <2 x i8> %i8 to <2 x i16>
  %asl_8_16 = mul <2 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %azw_8_16 = mul <2 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %zl2_8_16 = zext <2 x i8> %i8 to <2 x i16>
  %azl_8_16 = mul <2 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %asw_8_32 = mul <2 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %sl2_8_32 = sext <2 x i8> %i8 to <2 x i32>
  %asl_8_32 = mul <2 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %azw_8_32 = mul <2 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %zl2_8_32 = zext <2 x i8> %i8 to <2 x i32>
  %azl_8_32 = mul <2 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %asw_8_64 = mul <2 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %sl2_8_64 = sext <2 x i8> %i8 to <2 x i64>
  %asl_8_64 = mul <2 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %azw_8_64 = mul <2 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %zl2_8_64 = zext <2 x i8> %i8 to <2 x i64>
  %azl_8_64 = mul <2 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %asw_16_32 = mul <2 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %sl2_16_32 = sext <2 x i16> %i16 to <2 x i32>
  %asl_16_32 = mul <2 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %azw_16_32 = mul <2 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %zl2_16_32 = zext <2 x i16> %i16 to <2 x i32>
  %azl_16_32 = mul <2 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %asw_16_64 = mul <2 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %sl2_16_64 = sext <2 x i16> %i16 to <2 x i64>
  %asl_16_64 = mul <2 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %azw_16_64 = mul <2 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %zl2_16_64 = zext <2 x i16> %i16 to <2 x i64>
  %azl_16_64 = mul <2 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %asw_32_64 = mul <2 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %sl2_32_64 = sext <2 x i32> %i32 to <2 x i64>
  %asl_32_64 = mul <2 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %azw_32_64 = mul <2 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %zl2_32_64 = zext <2 x i32> %i32 to <2 x i64>
  %azl_32_64 = mul <2 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extmulv4(<4 x i8> %i8, <4 x i16> %i16, <4 x i32> %i32, <4 x i64> %i64)  {
; CHECK-LABEL: 'extmulv4'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = mul <4 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_16 = sext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = mul <4 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = mul <4 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_16 = zext <4 x i8> %i8 to <4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = mul <4 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_32 = mul <4 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl2_8_32 = sext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_32 = mul <4 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_32 = mul <4 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl1_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zl2_8_32 = zext <4 x i8> %i8 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_32 = mul <4 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %asw_8_64 = mul <4 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_8_64 = sext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %asl_8_64 = mul <4 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %azw_8_64 = mul <4 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_8_64 = zext <4 x i8> %i8 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %azl_8_64 = mul <4 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_16_32 = mul <4 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_16_32 = mul <4 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_16_32 = mul <4 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <4 x i16> %i16 to <4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_16_32 = mul <4 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %asw_16_64 = mul <4 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_16_64 = sext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %asl_16_64 = mul <4 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %azw_16_64 = mul <4 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_16_64 = zext <4 x i16> %i16 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %azl_16_64 = mul <4 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %sw_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %asw_32_64 = mul <4 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_32_64 = mul <4 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %zw_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %azw_32_64 = mul <4 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <4 x i32> %i32 to <4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_32_64 = mul <4 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %asw_8_16 = mul <4 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %sl2_8_16 = sext <4 x i8> %i8 to <4 x i16>
  %asl_8_16 = mul <4 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %azw_8_16 = mul <4 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %zl2_8_16 = zext <4 x i8> %i8 to <4 x i16>
  %azl_8_16 = mul <4 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %asw_8_32 = mul <4 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %sl2_8_32 = sext <4 x i8> %i8 to <4 x i32>
  %asl_8_32 = mul <4 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %azw_8_32 = mul <4 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %zl2_8_32 = zext <4 x i8> %i8 to <4 x i32>
  %azl_8_32 = mul <4 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %asw_8_64 = mul <4 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %sl2_8_64 = sext <4 x i8> %i8 to <4 x i64>
  %asl_8_64 = mul <4 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %azw_8_64 = mul <4 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %zl2_8_64 = zext <4 x i8> %i8 to <4 x i64>
  %azl_8_64 = mul <4 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %asw_16_32 = mul <4 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %sl2_16_32 = sext <4 x i16> %i16 to <4 x i32>
  %asl_16_32 = mul <4 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %azw_16_32 = mul <4 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %zl2_16_32 = zext <4 x i16> %i16 to <4 x i32>
  %azl_16_32 = mul <4 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %asw_16_64 = mul <4 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %sl2_16_64 = sext <4 x i16> %i16 to <4 x i64>
  %asl_16_64 = mul <4 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %azw_16_64 = mul <4 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %zl2_16_64 = zext <4 x i16> %i16 to <4 x i64>
  %azl_16_64 = mul <4 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %asw_32_64 = mul <4 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %sl2_32_64 = sext <4 x i32> %i32 to <4 x i64>
  %asl_32_64 = mul <4 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %azw_32_64 = mul <4 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %zl2_32_64 = zext <4 x i32> %i32 to <4 x i64>
  %azl_32_64 = mul <4 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extmulv8(<8 x i8> %i8, <8 x i16> %i16, <8 x i32> %i32, <8 x i64> %i64)  {
; CHECK-LABEL: 'extmulv8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sw_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asw_8_16 = mul <8 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = mul <8 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %zw_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azw_8_16 = mul <8 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = mul <8 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sw_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_32 = mul <8 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl1_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %sl2_8_32 = sext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_32 = mul <8 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zw_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_32 = mul <8 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl1_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %zl2_8_32 = zext <8 x i8> %i8 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_32 = mul <8 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sw_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %asw_8_64 = mul <8 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sl1_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %sl2_8_64 = sext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %asl_8_64 = mul <8 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zw_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %azw_8_64 = mul <8 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zl1_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %zl2_8_64 = zext <8 x i8> %i8 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %azl_8_64 = mul <8 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %sw_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_16_32 = mul <8 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_16_32 = mul <8 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %zw_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_16_32 = mul <8 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <8 x i16> %i16 to <8 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_16_32 = mul <8 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sw_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %asw_16_64 = mul <8 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl1_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl2_16_64 = sext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %asl_16_64 = mul <8 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zw_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %azw_16_64 = mul <8 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl1_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl2_16_64 = zext <8 x i16> %i16 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %azl_16_64 = mul <8 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %sw_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %asw_32_64 = mul <8 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_32_64 = mul <8 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zw_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %azw_32_64 = mul <8 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <8 x i32> %i32 to <8 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_32_64 = mul <8 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %asw_8_16 = mul <8 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %sl2_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %asl_8_16 = mul <8 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %azw_8_16 = mul <8 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %zl2_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %azl_8_16 = mul <8 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %asw_8_32 = mul <8 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %sl2_8_32 = sext <8 x i8> %i8 to <8 x i32>
  %asl_8_32 = mul <8 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %azw_8_32 = mul <8 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %zl2_8_32 = zext <8 x i8> %i8 to <8 x i32>
  %azl_8_32 = mul <8 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %asw_8_64 = mul <8 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %sl2_8_64 = sext <8 x i8> %i8 to <8 x i64>
  %asl_8_64 = mul <8 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %azw_8_64 = mul <8 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %zl2_8_64 = zext <8 x i8> %i8 to <8 x i64>
  %azl_8_64 = mul <8 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %asw_16_32 = mul <8 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %sl2_16_32 = sext <8 x i16> %i16 to <8 x i32>
  %asl_16_32 = mul <8 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %azw_16_32 = mul <8 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %zl2_16_32 = zext <8 x i16> %i16 to <8 x i32>
  %azl_16_32 = mul <8 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %asw_16_64 = mul <8 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %sl2_16_64 = sext <8 x i16> %i16 to <8 x i64>
  %asl_16_64 = mul <8 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %azw_16_64 = mul <8 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %zl2_16_64 = zext <8 x i16> %i16 to <8 x i64>
  %azl_16_64 = mul <8 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %asw_32_64 = mul <8 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %sl2_32_64 = sext <8 x i32> %i32 to <8 x i64>
  %asl_32_64 = mul <8 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %azw_32_64 = mul <8 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %zl2_32_64 = zext <8 x i32> %i32 to <8 x i64>
  %azl_32_64 = mul <8 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extmulv16(<16 x i8> %i8, <16 x i16> %i16, <16 x i32> %i32, <16 x i64> %i64)  {
; CHECK-LABEL: 'extmulv16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %sw_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asw_8_16 = mul <16 x i16> %i16, %sw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_8_16 = sext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %asl_8_16 = mul <16 x i16> %sl1_8_16, %sl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %zw_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azw_8_16 = mul <16 x i16> %i16, %zw_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_8_16 = zext <16 x i8> %i8 to <16 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %azl_8_16 = mul <16 x i16> %zl1_8_16, %zl2_8_16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sw_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_8_32 = mul <16 x i32> %i32, %sw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl1_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %sl2_8_32 = sext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_8_32 = mul <16 x i32> %sl1_8_32, %sl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zw_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_8_32 = mul <16 x i32> %i32, %zw_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl1_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %zl2_8_32 = zext <16 x i8> %i8 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_8_32 = mul <16 x i32> %zl1_8_32, %zl2_8_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sw_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %asw_8_64 = mul <16 x i64> %i64, %sw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sl1_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %sl2_8_64 = sext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %asl_8_64 = mul <16 x i64> %sl1_8_64, %sl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zw_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %azw_8_64 = mul <16 x i64> %i64, %zw_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zl1_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %zl2_8_64 = zext <16 x i8> %i8 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %azl_8_64 = mul <16 x i64> %zl1_8_64, %zl2_8_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %sw_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asw_16_32 = mul <16 x i32> %i32, %sw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_16_32 = sext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %asl_16_32 = mul <16 x i32> %sl1_16_32, %sl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %zw_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azw_16_32 = mul <16 x i32> %i32, %zw_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_16_32 = zext <16 x i16> %i16 to <16 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %azl_16_32 = mul <16 x i32> %zl1_16_32, %zl2_16_32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sw_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %asw_16_64 = mul <16 x i64> %i64, %sw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sl1_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %sl2_16_64 = sext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %asl_16_64 = mul <16 x i64> %sl1_16_64, %sl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zw_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %azw_16_64 = mul <16 x i64> %i64, %zw_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zl1_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %zl2_16_64 = zext <16 x i16> %i16 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %azl_16_64 = mul <16 x i64> %zl1_16_64, %zl2_16_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %sw_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %asw_32_64 = mul <16 x i64> %i64, %sw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl1_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %sl2_32_64 = sext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %asl_32_64 = mul <16 x i64> %sl1_32_64, %sl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %zw_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %azw_32_64 = mul <16 x i64> %i64, %zw_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl2_32_64 = zext <16 x i32> %i32 to <16 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %azl_32_64 = mul <16 x i64> %zl1_32_64, %zl2_32_64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sw_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %asw_8_16 = mul <16 x i16> %i16, %sw_8_16
  %sl1_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %sl2_8_16 = sext <16 x i8> %i8 to <16 x i16>
  %asl_8_16 = mul <16 x i16> %sl1_8_16, %sl2_8_16

  %zw_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %azw_8_16 = mul <16 x i16> %i16, %zw_8_16
  %zl1_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %zl2_8_16 = zext <16 x i8> %i8 to <16 x i16>
  %azl_8_16 = mul <16 x i16> %zl1_8_16, %zl2_8_16

  %sw_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %asw_8_32 = mul <16 x i32> %i32, %sw_8_32
  %sl1_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %sl2_8_32 = sext <16 x i8> %i8 to <16 x i32>
  %asl_8_32 = mul <16 x i32> %sl1_8_32, %sl2_8_32

  %zw_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %azw_8_32 = mul <16 x i32> %i32, %zw_8_32
  %zl1_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %zl2_8_32 = zext <16 x i8> %i8 to <16 x i32>
  %azl_8_32 = mul <16 x i32> %zl1_8_32, %zl2_8_32

  %sw_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %asw_8_64 = mul <16 x i64> %i64, %sw_8_64
  %sl1_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %sl2_8_64 = sext <16 x i8> %i8 to <16 x i64>
  %asl_8_64 = mul <16 x i64> %sl1_8_64, %sl2_8_64

  %zw_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %azw_8_64 = mul <16 x i64> %i64, %zw_8_64
  %zl1_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %zl2_8_64 = zext <16 x i8> %i8 to <16 x i64>
  %azl_8_64 = mul <16 x i64> %zl1_8_64, %zl2_8_64

  %sw_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %asw_16_32 = mul <16 x i32> %i32, %sw_16_32
  %sl1_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %sl2_16_32 = sext <16 x i16> %i16 to <16 x i32>
  %asl_16_32 = mul <16 x i32> %sl1_16_32, %sl2_16_32

  %zw_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %azw_16_32 = mul <16 x i32> %i32, %zw_16_32
  %zl1_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %zl2_16_32 = zext <16 x i16> %i16 to <16 x i32>
  %azl_16_32 = mul <16 x i32> %zl1_16_32, %zl2_16_32

  %sw_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %asw_16_64 = mul <16 x i64> %i64, %sw_16_64
  %sl1_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %sl2_16_64 = sext <16 x i16> %i16 to <16 x i64>
  %asl_16_64 = mul <16 x i64> %sl1_16_64, %sl2_16_64

  %zw_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %azw_16_64 = mul <16 x i64> %i64, %zw_16_64
  %zl1_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %zl2_16_64 = zext <16 x i16> %i16 to <16 x i64>
  %azl_16_64 = mul <16 x i64> %zl1_16_64, %zl2_16_64

  %sw_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %asw_32_64 = mul <16 x i64> %i64, %sw_32_64
  %sl1_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %sl2_32_64 = sext <16 x i32> %i32 to <16 x i64>
  %asl_32_64 = mul <16 x i64> %sl1_32_64, %sl2_32_64

  %zw_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %azw_32_64 = mul <16 x i64> %i64, %zw_32_64
  %zl1_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %zl2_32_64 = zext <16 x i32> %i32 to <16 x i64>
  %azl_32_64 = mul <16 x i64> %zl1_32_64, %zl2_32_64

  ret void
}

define void @extmul_const(<8 x i8> %i8, <8 x i16> %i16, <8 x i32> %i32, <8 x i64> %i64)  {
; CHECK-LABEL: 'extmul_const'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %asl_8_16 = mul <8 x i16> %sl1_8_16, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %azl_8_16 = mul <8 x i16> %zl1_8_16, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %zl1_8_16b = zext <8 x i8> %i8 to <8 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %and = and <8 x i16> %sl1_8_16, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %aal_8_16 = mul <8 x i16> %zl1_8_16b, %and
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %sl1_8_16 = sext <8 x i8> %i8 to <8 x i16>
  %asl_8_16 = mul <8 x i16> %sl1_8_16, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>

  %zl1_8_16 = zext <8 x i8> %i8 to <8 x i16>
  %azl_8_16 = mul <8 x i16> %zl1_8_16, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>

  %zl1_8_16b = zext <8 x i8> %i8 to <8 x i16>
  %and = and <8 x i16> %sl1_8_16, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %aal_8_16 = mul <8 x i16> %zl1_8_16b, %and

  ret void
}
