
// aes_ctr_vectors.js

// The following function returns an array of test vectors
// for the subtleCrypto encrypt method.
//
// Each test vector has the following fields:
//     name - a unique name for this vector
//     keyBuffer - an arrayBuffer with the key data in raw form
//     key - a CryptoKey object for the keyBuffer. INITIALLY null! You must fill this in first to use it!
//     algorithm - the value of the AlgorithmIdentifier parameter to provide to encrypt
//     plaintext - the text to encrypt
//     result - the expected result (usually just ciphertext, sometimes with added authentication)
function getTestVectors() {
    // Before we can really start, we need to fill a bunch of buffers with data
    var plaintext = new Uint8Array([84, 104, 105, 115, 32, 115,
        112, 101, 99, 105, 102, 105, 99, 97, 116, 105, 111, 110,
        32, 100, 101, 115, 99, 114, 105, 98, 101, 115, 32, 97, 32,
        74, 97, 118, 97, 83, 99, 114, 105, 112, 116, 32, 65, 80,
        73, 32, 102, 111, 114, 32, 112, 101, 114, 102, 111, 114,
        109, 105, 110, 103, 32, 98, 97, 115, 105, 99, 32, 99, 114,
        121, 112, 116, 111, 103, 114, 97, 112, 104, 105, 99, 32,
        111, 112, 101, 114, 97, 116, 105, 111, 110, 115, 32, 105,
        110, 32, 119, 101, 98, 32, 97, 112, 112, 108, 105, 99, 97,
        116, 105, 111, 110, 115, 44, 32, 115, 117, 99, 104, 32, 97,
        115, 32, 104, 97, 115, 104, 105, 110, 103, 44, 32, 115,
        105, 103, 110, 97, 116, 117, 114, 101, 32, 103, 101, 110,
        101, 114, 97, 116, 105, 111, 110, 32, 97, 110, 100, 32,
        118, 101, 114, 105, 102, 105, 99, 97, 116, 105, 111, 110,
        44, 32, 97, 110, 100, 32, 101, 110, 99, 114, 121, 112,
        116, 105, 111, 110, 32, 97, 110, 100, 32, 100, 101, 99,
        114, 121, 112, 116, 105, 111, 110, 46, 32, 65, 100, 100,
        105, 116, 105, 111, 110, 97, 108, 108, 121, 44, 32, 105,
        116, 32, 100, 101, 115, 99, 114, 105, 98, 101, 115, 32, 97,
        110, 32, 65, 80, 73, 32, 102, 111, 114, 32, 97, 112, 112,
        108, 105, 99, 97, 116, 105, 111, 110, 115, 32, 116, 111,
        32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 110,
        100, 47, 111, 114, 32, 109, 97, 110, 97, 103, 101, 32, 116,
        104, 101, 32, 107, 101, 121, 105, 110, 103, 32, 109, 97,
        116, 101, 114, 105, 97, 108, 32, 110, 101, 99, 101, 115,
        115, 97, 114, 121, 32, 116, 111, 32, 112, 101, 114, 102,
        111, 114, 109, 32, 116, 104, 101, 115, 101, 32, 111, 112,
        101, 114, 97, 116, 105, 111, 110, 115, 46, 32, 85, 115,
        101, 115, 32, 102, 111, 114, 32, 116, 104, 105, 115, 32,
        65, 80, 73, 32, 114, 97, 110, 103, 101, 32, 102, 114, 111,
        109, 32, 117, 115, 101, 114, 32, 111, 114, 32, 115, 101,
        114, 118, 105, 99, 101, 32, 97, 117, 116, 104, 101, 110,
        116, 105, 99, 97, 116, 105, 111, 110, 44, 32, 100, 111,
        99, 117, 109, 101, 110, 116, 32, 111, 114, 32, 99, 111,
        100, 101, 32, 115, 105, 103, 110, 105, 110, 103, 44, 32,
        97, 110, 100, 32, 116, 104, 101, 32, 99, 111, 110, 102,
        105, 100, 101, 110, 116, 105, 97, 108, 105, 116, 121, 32,
        97, 110, 100, 32, 105, 110, 116, 101, 103, 114, 105, 116,
        121, 32, 111, 102, 32, 99, 111, 109, 109, 117, 110, 105,
        99, 97, 116, 105, 111, 110, 115, 46]);

    // We want some random key bytes of various sizes.
    // These were randomly generated from a script.
    var keyBytes = {
        128: new Uint8Array([222, 192, 212, 252, 191, 60, 71,
            65, 200, 146, 218, 189, 28, 212, 192, 78]),
        192: new Uint8Array([208, 238, 131, 65, 63, 68, 196, 63, 186, 208,
            61, 207, 166, 18, 99, 152, 29, 109, 221, 95, 240, 30, 28, 246]),
        256: new Uint8Array([103, 105, 56, 35, 251, 29, 88, 7, 63, 145, 236,
            233, 204, 58, 249, 16, 229, 83, 38, 22, 164, 210, 123, 19, 235, 123, 116,
            216, 0, 11, 191, 48])
    }

    // AES-CTR needs a 16 byte (128 bit) counter.
    var counter = new Uint8Array([85, 170, 248, 155, 168, 148, 19, 213, 78, 167, 39,
        167, 108, 39, 162, 132]);


    // Results. These were created using the Python cryptography module.

    // AES-CTR produces ciphertext
    var ciphertext = {
        128: new Uint8Array([233, 17, 117, 253, 164, 245, 234, 87, 197, 43, 13, 0, 11, 190, 152, 175, 104, 192, 165, 144, 88, 174, 237, 138, 181, 183, 6, 53, 3, 161, 206, 71, 13, 121, 218, 209, 116, 249, 10, 170, 250, 165, 68, 157, 132, 141, 200, 178, 197, 87, 209, 231, 250, 75, 154, 65, 162, 251, 30, 159, 234, 20, 20, 181, 147, 218, 180, 12, 4, 241, 75, 79, 129, 64, 15, 228, 60, 147, 153, 1, 129, 176, 150, 161, 85, 97, 22, 154, 234, 23, 127, 16, 4, 22, 226, 11, 104, 16, 176, 14, 225, 176, 79, 239, 103, 243, 190, 222, 40, 186, 244, 212, 29, 57, 125, 175, 21, 17, 233, 2, 13, 119, 102, 233, 230, 4, 16, 222, 56, 225, 67, 45, 191, 250, 15, 153, 45, 193, 240, 212, 117, 101, 68, 232, 199, 101, 175, 125, 247, 6, 249, 14, 0, 157, 185, 56, 76, 51, 228, 77, 234, 84, 60, 42, 119, 187, 213, 32, 34, 222, 65, 231, 215, 26, 73, 141, 231, 254, 185, 118, 14, 180, 126, 80, 51, 102, 200, 141, 204, 45, 26, 56, 119, 136, 222, 45, 143, 120, 231, 44, 43, 221, 136, 21, 188, 138, 84, 232, 208, 238, 226, 117, 104, 60, 165, 4, 18, 144, 240, 49, 173, 90, 68, 84, 239, 161, 124, 196, 144, 119, 24, 243, 239, 75, 117, 254, 219, 209, 53, 131, 37, 79, 68, 26, 21, 168, 163, 50, 59, 18, 244, 11, 143, 190, 188, 129, 108, 249, 180, 104, 216, 215, 165, 160, 251, 84, 132, 152, 195, 154, 110, 216, 70, 21, 248, 148, 146, 152, 56, 174, 248, 227, 1, 102, 15, 118, 182, 50, 73, 63, 35, 112, 159, 237, 253, 94, 16, 127, 120, 38, 127, 51, 27, 96, 163, 140, 20, 111, 151, 16, 72, 74, 74, 205, 239, 241, 16, 179, 183, 116, 95, 248, 58, 168, 203, 93, 233, 225, 91, 17, 226, 10, 120, 85, 114, 4, 31, 40, 82, 161, 152, 17, 86, 237, 207, 7, 228, 110, 182, 65, 68, 68, 156, 206, 116, 185, 204, 148, 22, 58, 111, 218, 138, 225, 146, 25, 114, 29, 96, 183, 87, 181, 181, 236, 113, 141, 171, 213, 9, 84, 182, 230, 163, 147, 246, 86, 246, 52, 111, 64, 34, 157, 12, 80, 224, 28, 21, 112, 31, 42, 79, 229, 210, 90, 23, 78, 223, 155, 144, 238, 12, 14, 191, 158, 6, 181, 254, 0, 85, 134, 56, 161, 234, 55, 129, 64, 59, 12, 146, 6, 217, 232, 20, 214, 167, 159, 183, 165, 96, 96, 225, 199, 23, 106, 243, 108, 106, 26, 214, 53, 152, 26, 155, 253, 128, 7, 216, 207, 109, 159, 147, 240, 232, 226, 43, 147, 169, 162, 204, 215, 9, 10, 177, 223, 99, 206, 163, 240, 64]),

        192: new Uint8Array([98, 123, 235, 65, 14, 86, 80, 133, 88, 104, 244, 125, 165, 185, 163, 4, 3, 230, 62, 58, 113, 222, 46, 210, 17, 155, 95, 19, 125, 125, 70, 234, 105, 54, 23, 246, 114, 9, 237, 191, 9, 194, 34, 254, 156, 11, 50, 216, 80, 178, 185, 221, 132, 154, 27, 85, 82, 49, 241, 123, 23, 106, 119, 134, 203, 0, 151, 66, 149, 218, 124, 247, 227, 233, 236, 184, 88, 234, 174, 250, 83, 168, 33, 15, 122, 26, 96, 213, 210, 4, 52, 92, 20, 12, 64, 12, 209, 197, 69, 100, 15, 56, 60, 63, 241, 52, 18, 189, 93, 146, 47, 60, 33, 200, 218, 243, 43, 169, 17, 108, 19, 199, 174, 33, 107, 186, 57, 95, 167, 138, 180, 187, 53, 113, 208, 148, 190, 48, 167, 53, 209, 52, 153, 184, 231, 63, 168, 54, 179, 238, 93, 130, 125, 3, 149, 119, 60, 25, 142, 150, 183, 193, 29, 18, 3, 219, 235, 219, 26, 116, 217, 196, 108, 6, 96, 103, 212, 48, 227, 91, 124, 77, 181, 169, 18, 111, 123, 83, 26, 169, 230, 88, 103, 185, 153, 93, 143, 152, 142, 231, 41, 226, 226, 156, 179, 206, 212, 67, 18, 193, 187, 53, 252, 214, 15, 228, 246, 131, 170, 101, 134, 212, 100, 170, 146, 47, 57, 125, 50, 230, 51, 246, 74, 175, 129, 196, 178, 206, 176, 52, 153, 39, 77, 24, 186, 99, 137, 83, 105, 111, 168, 35, 176, 24, 29, 170, 223, 74, 160, 138, 247, 12, 102, 233, 136, 59, 172, 228, 242, 84, 13, 34, 155, 80, 80, 87, 180, 143, 129, 61, 213, 54, 41, 8, 183, 102, 126, 179, 127, 77, 55, 176, 152, 41, 131, 85, 86, 225, 87, 216, 139, 226, 196, 195, 210, 34, 33, 161, 249, 153, 205, 197, 128, 41, 28, 121, 6, 159, 25, 211, 168, 137, 26, 217, 249, 113, 81, 141, 18, 1, 250, 228, 68, 238, 74, 54, 99, 167, 236, 176, 199, 148, 161, 143, 156, 51, 189, 204, 59, 240, 151, 170, 85, 63, 23, 38, 152, 199, 12, 81, 217, 244, 178, 231, 249, 159, 224, 107, 214, 58, 127, 116, 143, 219, 155, 80, 55, 213, 171, 80, 127, 235, 20, 247, 12, 104, 228, 147, 202, 124, 143, 110, 223, 76, 221, 154, 175, 143, 185, 237, 222, 189, 104, 218, 72, 244, 55, 253, 138, 183, 92, 231, 68, 176, 239, 171, 100, 10, 63, 61, 194, 228, 15, 133, 216, 45, 60, 135, 203, 142, 127, 153, 172, 223, 213, 230, 220, 189, 223, 234, 156, 134, 238, 220, 251, 104, 209, 117, 175, 47, 46, 148, 6, 61, 216, 215, 39, 30, 116, 212, 45, 112, 202, 227, 198, 98, 253, 97, 177, 120, 74, 238, 68, 99, 240, 96, 43, 88, 166]),

        256: new Uint8Array([55, 82, 154, 67, 47, 80, 186, 78, 83, 56, 95, 130, 102, 236, 61, 236, 204, 236, 234, 222, 122, 226, 147, 149, 233, 41, 16, 118, 201, 91, 185, 162, 79, 71, 146, 252, 221, 110, 165, 137, 75, 129, 94, 219, 93, 94, 64, 34, 250, 190, 5, 90, 6, 177, 167, 224, 25, 121, 85, 91, 87, 152, 56, 100, 191, 35, 1, 156, 177, 179, 127, 253, 173, 176, 87, 247, 40, 207, 178, 175, 10, 51, 209, 70, 52, 76, 251, 160, 172, 203, 77, 191, 97, 58, 123, 238, 82, 60, 166, 214, 134, 14, 71, 74, 156, 15, 77, 6, 141, 76, 10, 205, 148, 204, 85, 203, 242, 30, 66, 133, 202, 21, 17, 108, 151, 2, 15, 44, 51, 180, 88, 80, 8, 248, 254, 151, 201, 226, 156, 6, 39, 197, 212, 124, 72, 217, 75, 232, 139, 155, 22, 199, 242, 223, 116, 10, 141, 42, 7, 85, 99, 5, 184, 43, 145, 159, 122, 135, 202, 46, 209, 157, 178, 114, 98, 194, 119, 194, 19, 242, 167, 236, 162, 94, 90, 106, 219, 234, 67, 11, 162, 225, 6, 17, 152, 23, 16, 84, 40, 90, 255, 158, 8, 105, 198, 56, 220, 213, 36, 203, 241, 242, 85, 218, 103, 90, 202, 214, 215, 134, 121, 169, 149, 139, 122, 143, 155, 178, 29, 217, 197, 128, 173, 25, 111, 154, 14, 76, 106, 101, 0, 215, 187, 33, 223, 116, 205, 89, 52, 206, 60, 77, 141, 31, 57, 211, 74, 42, 219, 88, 210, 36, 196, 128, 151, 136, 124, 222, 157, 59, 225, 70, 163, 234, 59, 173, 228, 198, 134, 76, 249, 228, 69, 181, 196, 194, 179, 239, 78, 43, 143, 94, 234, 10, 177, 192, 185, 171, 231, 164, 254, 91, 44, 11, 29, 148, 223, 107, 18, 149, 61, 50, 115, 38, 14, 128, 189, 9, 77, 236, 151, 163, 23, 122, 156, 236, 11, 80, 66, 190, 24, 4, 4, 12, 148, 57, 64, 59, 143, 114, 247, 66, 111, 167, 86, 173, 98, 102, 207, 44, 134, 89, 231, 64, 50, 157, 208, 210, 79, 159, 133, 73, 118, 98, 202, 215, 57, 247, 29, 97, 116, 1, 28, 119, 248, 243, 31, 180, 66, 38, 40, 141, 251, 134, 129, 126, 241, 113, 22, 50, 28, 113, 187, 158, 217, 125, 182, 233, 144, 246, 32, 88, 88, 15, 0, 102, 131, 67, 31, 34, 150, 98, 241, 213, 227, 205, 175, 254, 3, 53, 70, 124, 167, 38, 53, 104, 140, 147, 158, 200, 179, 45, 100, 101, 246, 81, 166, 53, 247, 60, 10, 78, 127, 10, 173, 176, 232, 31, 91, 203, 250, 236, 38, 113, 172, 151, 253, 194, 253, 50, 242, 76, 148, 23, 117, 195, 122, 104, 16, 212, 177, 113, 188, 138, 186, 144, 168, 102, 3])
    };

    var keyLengths = [128, 192, 256];

    // All the scenarios that should succeed, if the key has "encrypt" usage
    var passing = [];
    keyLengths.forEach(function(keyLength) {
        passing.push({
            name: "AES-CTR " + keyLength.toString() + "-bit key",
            keyBuffer: keyBytes[keyLength],
            key: null,
            algorithm: {name: "AES-CTR", counter: counter, length: 64},
            plaintext: plaintext,
            result: ciphertext[keyLength]
        });
    });

    // Scenarios that should fail because of a bad length parameter, causing an OperationError
    var failing = [];
    keyLengths.forEach(function(keyLength) {
        failing.push({
            name: "AES-CTR " + keyLength.toString() + "-bit key, 0-bit counter",
            keyBuffer: keyBytes[keyLength],
            key: null,
            algorithm: {name: "AES-CTR", counter: counter, length: 0},
            plaintext: plaintext,
            result: ciphertext[keyLength]
        });

        failing.push({
            name: "AES-CTR " + keyLength.toString() + "-bit key, 129-bit counter",
            keyBuffer: keyBytes[keyLength],
            key: null,
            algorithm: {name: "AES-CTR", counter: counter, length: 129},
            plaintext: plaintext,
            result: ciphertext[keyLength]
        });
    });

    return {passing: passing, failing: failing, decryptionFailing: []};
}
