
// DO NOT EDIT. This file is automatically generated from `ob_errno.def'.

// Copyright 2016 Alibaba Inc. All Rights Reserved.
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// version 2 as published by the Free Software Foundation.
// ob_errno.h
//   Author:
//   Normalizer:

#define USING_LOG_PREFIX LIB_MYSQLC

// DO NOT DELETE `#include <iostream>` !!!
// fix: ob_error.cpp file requires at least 20g memory for release(-O2) compilation
// and will jam when asan turned on
// it can be solved by introducing <iostream> header file currently
// TODO: it is clang bug and the specific reason to be further located
// issue:
#include <iostream>

#include "ob_errno.h"
#ifndef __ERROR_CODE_PARSER_
#include "ob_define.h"
#include "lib/utility/ob_edit_distance.h"
#else
#define OB_LIKELY
#define OB_UNLIKELY
#include <string.h>
#endif
using namespace oceanbase::common;

namespace oceanbase
{
namespace common
{
int g_enable_ob_error_msg_style;
}
}

struct _error {
  public:
    const char *error_name;
    const char *error_cause;
    const char *error_solution;
    int         mysql_errno;
    const char *sqlstate;
    const char *str_error;
    const char *str_user_error;
    int         oracle_errno;
    const char *oracle_str_error;
    const char *oracle_str_user_error;
    const char *ob_str_error;
    const char *ob_str_user_error;
};
static _error _error_default;
static _error const *_errors[OB_MAX_ERROR_CODE] = {NULL};
static const _error _error_OB_ERROR = {
      .error_name            = "OB_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Common error",
      .str_user_error        = "Common error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4000, Common error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4000, Common error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4000, Common error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4000, Common error"
};
static const _error _error_OB_OBJ_TYPE_ERROR = {
      .error_name            = "OB_OBJ_TYPE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY004",
      .str_error             = "Object type error",
      .str_user_error        = "Object type error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4001, Object type error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4001, Object type error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4001, Object type error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4001, Object type error"
};
static const _error _error_OB_INVALID_ARGUMENT = {
      .error_name            = "OB_INVALID_ARGUMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_ARGUMENTS,
      .sqlstate              = "HY000",
      .str_error             = "Invalid argument",
      .str_user_error        = "Incorrect arguments to %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4002, Invalid argument",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4002, Incorrect arguments to %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4002, Invalid argument",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4002, Incorrect arguments to %s"
};
static const _error _error_OB_ARRAY_OUT_OF_RANGE = {
      .error_name            = "OB_ARRAY_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Array index out of range",
      .str_user_error        = "Array index out of range",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4003, Array index out of range",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4003, Array index out of range",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4003, Array index out of range",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4003, Array index out of range"
};
static const _error _error_OB_SERVER_LISTEN_ERROR = {
      .error_name            = "OB_SERVER_LISTEN_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "08S01",
      .str_error             = "Failed to listen to the port",
      .str_user_error        = "Failed to listen to the port",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4004, Failed to listen to the port",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4004, Failed to listen to the port",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4004, Failed to listen to the port",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4004, Failed to listen to the port"
};
static const _error _error_OB_INIT_TWICE = {
      .error_name            = "OB_INIT_TWICE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The object is initialized twice",
      .str_user_error        = "The object is initialized twice",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4005, The object is initialized twice",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4005, The object is initialized twice",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4005, The object is initialized twice",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4005, The object is initialized twice"
};
static const _error _error_OB_NOT_INIT = {
      .error_name            = "OB_NOT_INIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The object is not initialized",
      .str_user_error        = "The object is not initialized",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4006, The object is not initialized",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4006, The object is not initialized",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4006, The object is not initialized",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4006, The object is not initialized"
};
static const _error _error_OB_NOT_SUPPORTED = {
      .error_name            = "OB_NOT_SUPPORTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NOT_SUPPORTED_YET,
      .sqlstate              = "0A000",
      .str_error             = "Not supported feature or function",
      .str_user_error        = "%s not supported",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4007, Not supported feature or function",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4007, %s not supported",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4007, Not supported feature or function",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4007, %s not supported"
};
static const _error _error_OB_ITER_END = {
      .error_name            = "OB_ITER_END",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "End of iteration",
      .str_user_error        = "End of iteration",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4008, End of iteration",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4008, End of iteration",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4008, End of iteration",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4008, End of iteration"
};
static const _error _error_OB_IO_ERROR = {
      .error_name            = "OB_IO_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "58030",
      .str_error             = "IO error",
      .str_user_error        = "IO error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4009, IO error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4009, IO error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4009, IO error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4009, IO error"
};
static const _error _error_OB_ERROR_FUNC_VERSION = {
      .error_name            = "OB_ERROR_FUNC_VERSION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Wrong RPC command version",
      .str_user_error        = "Wrong RPC command version",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4010, Wrong RPC command version",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4010, Wrong RPC command version",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4010, Wrong RPC command version",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4010, Wrong RPC command version"
};
static const _error _error_OB_PACKET_NOT_SENT = {
      .error_name            = "OB_PACKET_NOT_SENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Can not send packet",
      .str_user_error        = "Can not send packet",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4011, Can not send packet",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4011, Can not send packet",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4011, Can not send packet",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4011, Can not send packet"
};
static const _error _error_OB_TIMEOUT = {
      .error_name            = "OB_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Timeout",
      .str_user_error        = "Timeout, query has reached the maximum query timeout: %ld(us), maybe you can adjust the session variable ob_query_timeout or query_timeout hint, and try again.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4012, Timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4012, Timeout, query has reached the maximum query timeout: %ld(us), maybe you can adjust the session variable ob_query_timeout or query_timeout hint, and try again.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4012, Timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4012, Timeout, query has reached the maximum query timeout: %ld(us), maybe you can adjust the session variable ob_query_timeout or query_timeout hint, and try again."
};
static const _error _error_OB_ALLOCATE_MEMORY_FAILED = {
      .error_name            = "OB_ALLOCATE_MEMORY_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY001",
      .str_error             = "No memory or reach tenant memory limit",
      .str_user_error        = "No memory or reach tenant memory limit",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4013, No memory or reach tenant memory limit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4013, No memory or reach tenant memory limit",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4013, No memory or reach tenant memory limit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4013, No memory or reach tenant memory limit"
};
static const _error _error_OB_INNER_STAT_ERROR = {
      .error_name            = "OB_INNER_STAT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Inner state error",
      .str_user_error        = "Inner state error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4014, Inner state error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4014, Inner state error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4014, Inner state error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4014, Inner state error"
};
static const _error _error_OB_ERR_SYS = {
      .error_name            = "OB_ERR_SYS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "System error",
      .str_user_error        = "System error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4015, System error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4015, System error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4015, System error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4015, System error"
};
static const _error _error_OB_ERR_UNEXPECTED = {
      .error_name            = "OB_ERR_UNEXPECTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Internal error",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4016, Internal error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4016, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4016, Internal error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4016, %s"
};
static const _error _error_OB_ENTRY_EXIST = {
      .error_name            = "OB_ENTRY_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Entry already exist",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4017, Entry already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4017, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4017, Entry already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4017, %s"
};
static const _error _error_OB_ENTRY_NOT_EXIST = {
      .error_name            = "OB_ENTRY_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Entry not exist",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4018, Entry not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4018, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4018, Entry not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4018, %s"
};
static const _error _error_OB_SIZE_OVERFLOW = {
      .error_name            = "OB_SIZE_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Size overflow",
      .str_user_error        = "Size overflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4019, Size overflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4019, Size overflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4019, Size overflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4019, Size overflow"
};
static const _error _error_OB_REF_NUM_NOT_ZERO = {
      .error_name            = "OB_REF_NUM_NOT_ZERO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Reference count is not zero",
      .str_user_error        = "Reference count is not zero",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4020, Reference count is not zero",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4020, Reference count is not zero",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4020, Reference count is not zero",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4020, Reference count is not zero"
};
static const _error _error_OB_CONFLICT_VALUE = {
      .error_name            = "OB_CONFLICT_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Conflict value",
      .str_user_error        = "Conflict value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4021, Conflict value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4021, Conflict value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4021, Conflict value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4021, Conflict value"
};
static const _error _error_OB_ITEM_NOT_SETTED = {
      .error_name            = "OB_ITEM_NOT_SETTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Item not set",
      .str_user_error        = "Item not set",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4022, Item not set",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4022, Item not set",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4022, Item not set",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4022, Item not set"
};
static const _error _error_OB_EAGAIN = {
      .error_name            = "OB_EAGAIN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Try again",
      .str_user_error        = "Try again",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4023, Try again",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4023, Try again",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4023, Try again",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4023, Try again"
};
static const _error _error_OB_BUF_NOT_ENOUGH = {
      .error_name            = "OB_BUF_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Buffer not enough",
      .str_user_error        = "Buffer not enough",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4024, Buffer not enough",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4024, Buffer not enough",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4024, Buffer not enough",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4024, Buffer not enough"
};
static const _error _error_OB_PARTIAL_FAILED = {
      .error_name            = "OB_PARTIAL_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Partial failed",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4025, Partial failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4025, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4025, Partial failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4025, %s"
};
static const _error _error_OB_READ_NOTHING = {
      .error_name            = "OB_READ_NOTHING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SP_FETCH_NO_DATA,
      .sqlstate              = "02000",
      .str_error             = "No data - zero rows fetched, selected, or processed",
      .str_user_error        = "No data - zero rows fetched, selected, or processed",
      .oracle_errno          = 1403,
      .oracle_str_error      = "ORA-01403: no data found",
      .oracle_str_user_error = "ORA-01403: no data found",
      .ob_str_error          = "OBE-01403: no data found",
      .ob_str_user_error     = "OBE-01403: no data found"
};
static const _error _error_OB_FILE_NOT_EXIST = {
      .error_name            = "OB_FILE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FILE_NOT_FOUND,
      .sqlstate              = "HY000",
      .str_error             = "File not exist",
      .str_user_error        = "File not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4027, File not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4027, File not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4027, File not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4027, File not exist"
};
static const _error _error_OB_DISCONTINUOUS_LOG = {
      .error_name            = "OB_DISCONTINUOUS_LOG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Log entry not continuous",
      .str_user_error        = "Log entry not continuous",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4028, Log entry not continuous",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4028, Log entry not continuous",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4028, Log entry not continuous",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4028, Log entry not continuous"
};
static const _error _error_OB_SCHEMA_ERROR = {
      .error_name            = "OB_SCHEMA_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Schema error",
      .str_user_error        = "Schema error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4029, Schema error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4029, Schema error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4029, Schema error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4029, Schema error"
};
static const _error _error_OB_TENANT_OUT_OF_MEM = {
      .error_name            = "OB_TENANT_OUT_OF_MEM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Over tenant memory limits",
      .str_user_error        = "Over tenant memory limits",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4030, Over tenant memory limits",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4030, Over tenant memory limits",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4030, Over tenant memory limits",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4030, Over tenant memory limits"
};
static const _error _error_OB_UNKNOWN_OBJ = {
      .error_name            = "OB_UNKNOWN_OBJ",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY004",
      .str_error             = "Unknown object",
      .str_user_error        = "Unknown object",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4031, Unknown object",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4031, Unknown object",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4031, Unknown object",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4031, Unknown object"
};
static const _error _error_OB_NO_MONITOR_DATA = {
      .error_name            = "OB_NO_MONITOR_DATA",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "02000",
      .str_error             = "No monitor data",
      .str_user_error        = "No monitor data",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4032, No monitor data",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4032, No monitor data",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4032, No monitor data",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4032, No monitor data"
};
static const _error _error_OB_SERIALIZE_ERROR = {
      .error_name            = "OB_SERIALIZE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Serialize error",
      .str_user_error        = "Serialize error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4033, Serialize error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4033, Serialize error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4033, Serialize error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4033, Serialize error"
};
static const _error _error_OB_DESERIALIZE_ERROR = {
      .error_name            = "OB_DESERIALIZE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Deserialize error",
      .str_user_error        = "Deserialize error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4034, Deserialize error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4034, Deserialize error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4034, Deserialize error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4034, Deserialize error"
};
static const _error _error_OB_AIO_TIMEOUT = {
      .error_name            = "OB_AIO_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Asynchronous IO error",
      .str_user_error        = "Asynchronous IO error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4035, Asynchronous IO error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4035, Asynchronous IO error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4035, Asynchronous IO error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4035, Asynchronous IO error"
};
static const _error _error_OB_NEED_RETRY = {
      .error_name            = "OB_NEED_RETRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Need retry",
      .str_user_error        = "Need retry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4036, Need retry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4036, Need retry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4036, Need retry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4036, Need retry"
};
static const _error _error_OB_TOO_MANY_SSTABLE = {
      .error_name            = "OB_TOO_MANY_SSTABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Too many sstable",
      .str_user_error        = "Too many sstable",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4037, Too many sstable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4037, Too many sstable",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4037, Too many sstable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4037, Too many sstable"
};
static const _error _error_OB_NOT_MASTER = {
      .error_name            = "OB_NOT_MASTER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The observer or zone is not the master",
      .str_user_error        = "The observer or zone is not the master",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4038, The observer or zone is not the master",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4038, The observer or zone is not the master",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4038, The observer or zone is not the master",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4038, The observer or zone is not the master"
};
static const _error _error_OB_KILLED_BY_THROTTLING = {
      .error_name            = "OB_KILLED_BY_THROTTLING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Request has killed by sql throttle",
      .str_user_error        = "Request has killed by sql throttle",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4039, Request has killed by sql throttle",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4039, Request has killed by sql throttle",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4039, Request has killed by sql throttle",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4039, Request has killed by sql throttle"
};
static const _error _error_OB_DECRYPT_FAILED = {
      .error_name            = "OB_DECRYPT_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Decrypt error",
      .str_user_error        = "Decrypt error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4041, Decrypt error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4041, Decrypt error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4041, Decrypt error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4041, Decrypt error"
};
static const _error _error_OB_USER_NOT_EXIST = {
      .error_name            = "OB_USER_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PASSWORD_NO_MATCH,
      .sqlstate              = "42000",
      .str_error             = "Can not find any matching row in the user table",
      .str_user_error        = "Can not find any matching row in the user table'%.*s'",
      .oracle_errno          = 1918,
      .oracle_str_error      = "ORA-01918: user does not exist",
      .oracle_str_user_error = "ORA-01918: user '%.*s' does not exist",
      .ob_str_error          = "OBE-01918: user does not exist",
      .ob_str_user_error     = "OBE-01918: user '%.*s' does not exist"
};
static const _error _error_OB_PASSWORD_WRONG = {
      .error_name            = "OB_PASSWORD_WRONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ACCESS_DENIED_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Access denied for user",
      .str_user_error        = "Access denied for user '%.*s'@'%.*s' (using password: %s)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4043, Access denied for user",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4043, Access denied for user '%.*s'@'%.*s' (using password: %s)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4043, Access denied for user",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4043, Access denied for user '%.*s'@'%.*s' (using password: %s)"
};
static const _error _error_OB_SKEY_VERSION_WRONG = {
      .error_name            = "OB_SKEY_VERSION_WRONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Wrong skey version",
      .str_user_error        = "Wrong skey version",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4044, Wrong skey version",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4044, Wrong skey version",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4044, Wrong skey version",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4044, Wrong skey version"
};
static const _error _error_OB_PUSHDOWN_STATUS_CHANGED = {
      .error_name            = "OB_PUSHDOWN_STATUS_CHANGED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "pushdown status changed",
      .str_user_error        = "pushdown status changed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4045, pushdown status changed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4045, pushdown status changed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4045, pushdown status changed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4045, pushdown status changed"
};
static const _error _error_OB_STORAGE_SCHEMA_INVALID = {
      .error_name            = "OB_STORAGE_SCHEMA_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Storage schema is not valid",
      .str_user_error        = "Storage schema is not valid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4046, Storage schema is not valid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4046, Storage schema is not valid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4046, Storage schema is not valid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4046, Storage schema is not valid"
};
static const _error _error_OB_MEDIUM_COMPACTION_INFO_INVALID = {
      .error_name            = "OB_MEDIUM_COMPACTION_INFO_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Medium compaction info is not valid",
      .str_user_error        = "Medium compaction info is not valid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4047, Medium compaction info is not valid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4047, Medium compaction info is not valid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4047, Medium compaction info is not valid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4047, Medium compaction info is not valid"
};
static const _error _error_OB_NOT_REGISTERED = {
      .error_name            = "OB_NOT_REGISTERED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not registered",
      .str_user_error        = "Not registered",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4048, Not registered",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4048, Not registered",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4048, Not registered",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4048, Not registered"
};
static const _error _error_OB_WAITQUEUE_TIMEOUT = {
      .error_name            = "OB_WAITQUEUE_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4012,
      .sqlstate              = "HY000",
      .str_error             = "Task timeout and not executed",
      .str_user_error        = "Task timeout and not executed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4049, Task timeout and not executed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4049, Task timeout and not executed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4049, Task timeout and not executed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4049, Task timeout and not executed"
};
static const _error _error_OB_NOT_THE_OBJECT = {
      .error_name            = "OB_NOT_THE_OBJECT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not the object",
      .str_user_error        = "Not the object",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4050, Not the object",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4050, Not the object",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4050, Not the object",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4050, Not the object"
};
static const _error _error_OB_ALREADY_REGISTERED = {
      .error_name            = "OB_ALREADY_REGISTERED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Already registered",
      .str_user_error        = "Already registered",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4051, Already registered",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4051, Already registered",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4051, Already registered",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4051, Already registered"
};
static const _error _error_OB_LAST_LOG_RUINNED = {
      .error_name            = "OB_LAST_LOG_RUINNED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Corrupted log entry",
      .str_user_error        = "Corrupted log entry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4052, Corrupted log entry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4052, Corrupted log entry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4052, Corrupted log entry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4052, Corrupted log entry"
};
static const _error _error_OB_NO_CS_SELECTED = {
      .error_name            = "OB_NO_CS_SELECTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No Server selected",
      .str_user_error        = "No Server selected",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4053, No Server selected",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4053, No Server selected",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4053, No Server selected",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4053, No Server selected"
};
static const _error _error_OB_NO_TABLETS_CREATED = {
      .error_name            = "OB_NO_TABLETS_CREATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No tablets created",
      .str_user_error        = "No tablets created",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4054, No tablets created",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4054, No tablets created",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4054, No tablets created",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4054, No tablets created"
};
static const _error _error_OB_INVALID_ERROR = {
      .error_name            = "OB_INVALID_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid entry",
      .str_user_error        = "Invalid entry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4055, Invalid entry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4055, Invalid entry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4055, Invalid entry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4055, Invalid entry"
};
static const _error _error_OB_DECIMAL_OVERFLOW_WARN = {
      .error_name            = "OB_DECIMAL_OVERFLOW_WARN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Decimal overflow warning",
      .str_user_error        = "Decimal overflow warning",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4057, Decimal overflow warning",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4057, Decimal overflow warning",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4057, Decimal overflow warning",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4057, Decimal overflow warning"
};
static const _error _error_OB_DECIMAL_UNLEGAL_ERROR = {
      .error_name            = "OB_DECIMAL_UNLEGAL_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Decimal overflow error",
      .str_user_error        = "Decimal overflow error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4058, Decimal overflow error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4058, Decimal overflow error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4058, Decimal overflow error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4058, Decimal overflow error"
};
static const _error _error_OB_OBJ_DIVIDE_ERROR = {
      .error_name            = "OB_OBJ_DIVIDE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Divide error",
      .str_user_error        = "Divide error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4060, Divide error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4060, Divide error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4060, Divide error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4060, Divide error"
};
static const _error _error_OB_NOT_A_DECIMAL = {
      .error_name            = "OB_NOT_A_DECIMAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not a decimal",
      .str_user_error        = "Not a decimal",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4061, Not a decimal",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4061, Not a decimal",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4061, Not a decimal",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4061, Not a decimal"
};
static const _error _error_OB_DECIMAL_PRECISION_NOT_EQUAL = {
      .error_name            = "OB_DECIMAL_PRECISION_NOT_EQUAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY104",
      .str_error             = "Decimal precision error",
      .str_user_error        = "Decimal precision error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4062, Decimal precision error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4062, Decimal precision error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4062, Decimal precision error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4062, Decimal precision error"
};
static const _error _error_OB_EMPTY_RANGE = {
      .error_name            = "OB_EMPTY_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Empty range",
      .str_user_error        = "Empty range",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4063, Empty range",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4063, Empty range",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4063, Empty range",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4063, Empty range"
};
static const _error _error_OB_SESSION_KILLED = {
      .error_name            = "OB_SESSION_KILLED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Session killed",
      .str_user_error        = "Session killed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4064, Session killed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4064, Session killed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4064, Session killed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4064, Session killed"
};
static const _error _error_OB_LOG_NOT_SYNC = {
      .error_name            = "OB_LOG_NOT_SYNC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Log not sync",
      .str_user_error        = "Log not sync",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4065, Log not sync",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4065, Log not sync",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4065, Log not sync",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4065, Log not sync"
};
static const _error _error_OB_DIR_NOT_EXIST = {
      .error_name            = "OB_DIR_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_READ_DIR,
      .sqlstate              = "HY000",
      .str_error             = "Directory not exist",
      .str_user_error        = "Directory not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4066, Directory not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4066, Directory not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4066, Directory not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4066, Directory not exist"
};
static const _error _error_OB_SESSION_NOT_FOUND = {
      .error_name            = "OB_SESSION_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4012,
      .sqlstate              = "HY000",
      .str_error             = "RPC session not found",
      .str_user_error        = "RPC session not found",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4067, RPC session not found",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4067, RPC session not found",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4067, RPC session not found",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4067, RPC session not found"
};
static const _error _error_OB_INVALID_LOG = {
      .error_name            = "OB_INVALID_LOG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid log",
      .str_user_error        = "Invalid log",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4068, Invalid log",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4068, Invalid log",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4068, Invalid log",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4068, Invalid log"
};
static const _error _error_OB_INVALID_DATA = {
      .error_name            = "OB_INVALID_DATA",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid data",
      .str_user_error        = "Invalid data",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4070, Invalid data",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4070, Invalid data",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4070, Invalid data",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4070, Invalid data"
};
static const _error _error_OB_ALREADY_DONE = {
      .error_name            = "OB_ALREADY_DONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Already done",
      .str_user_error        = "Already done",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4071, Already done",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4071, Already done",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4071, Already done",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4071, Already done"
};
static const _error _error_OB_CANCELED = {
      .error_name            = "OB_CANCELED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Operation canceled",
      .str_user_error        = "Operation canceled",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4072, Operation canceled",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4072, Operation canceled",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4072, Operation canceled",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4072, Operation canceled"
};
static const _error _error_OB_LOG_SRC_CHANGED = {
      .error_name            = "OB_LOG_SRC_CHANGED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Log source changed",
      .str_user_error        = "Log source changed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4073, Log source changed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4073, Log source changed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4073, Log source changed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4073, Log source changed"
};
static const _error _error_OB_LOG_NOT_ALIGN = {
      .error_name            = "OB_LOG_NOT_ALIGN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Log not aligned",
      .str_user_error        = "Log not aligned",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4074, Log not aligned",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4074, Log not aligned",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4074, Log not aligned",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4074, Log not aligned"
};
static const _error _error_OB_LOG_MISSING = {
      .error_name            = "OB_LOG_MISSING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Log entry missed",
      .str_user_error        = "Log entry missed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4075, Log entry missed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4075, Log entry missed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4075, Log entry missed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4075, Log entry missed"
};
static const _error _error_OB_NEED_WAIT = {
      .error_name            = "OB_NEED_WAIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Need wait",
      .str_user_error        = "Need wait",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4076, Need wait",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4076, Need wait",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4076, Need wait",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4076, Need wait"
};
static const _error _error_OB_NOT_IMPLEMENT = {
      .error_name            = "OB_NOT_IMPLEMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "0A000",
      .str_error             = "Not implemented feature",
      .str_user_error        = "Not implemented feature",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4077, Not implemented feature",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4077, Not implemented feature",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4077, Not implemented feature",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4077, Not implemented feature"
};
static const _error _error_OB_DIVISION_BY_ZERO = {
      .error_name            = "OB_DIVISION_BY_ZERO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DIVISION_BY_ZERO,
      .sqlstate              = "22012",
      .str_error             = "Divided by zero",
      .str_user_error        = "Divided by zero",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4078, Divided by zero",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4078, Divided by zero",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4078, Divided by zero",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4078, Divided by zero"
};
static const _error _error_OB_EXCEED_MEM_LIMIT = {
      .error_name            = "OB_EXCEED_MEM_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY013",
      .str_error             = "exceed memory limit",
      .str_user_error        = "exceed memory limit",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4080, exceed memory limit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4080, exceed memory limit",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4080, exceed memory limit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4080, exceed memory limit"
};
static const _error _error_OB_RESULT_UNKNOWN = {
      .error_name            = "OB_RESULT_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unknown result",
      .str_user_error        = "Unknown result",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4081, Unknown result",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4081, Unknown result",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4081, Unknown result",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4081, Unknown result"
};
static const _error _error_OB_NO_RESULT = {
      .error_name            = "OB_NO_RESULT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "02000",
      .str_error             = "No result",
      .str_user_error        = "No result",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4084, No result",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4084, No result",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4084, No result",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4084, No result"
};
static const _error _error_OB_QUEUE_OVERFLOW = {
      .error_name            = "OB_QUEUE_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Queue overflow",
      .str_user_error        = "Queue overflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4085, Queue overflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4085, Queue overflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4085, Queue overflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4085, Queue overflow"
};
static const _error _error_OB_LOG_ID_RANGE_NOT_CONTINUOUS = {
      .error_name            = "OB_LOG_ID_RANGE_NOT_CONTINUOUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Table log_id range no continuous",
      .str_user_error        = "Table log_id range no continuous",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4090, Table log_id range no continuous",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4090, Table log_id range no continuous",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4090, Table log_id range no continuous",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4090, Table log_id range no continuous"
};
static const _error _error_OB_TERM_LAGGED = {
      .error_name            = "OB_TERM_LAGGED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Term lagged",
      .str_user_error        = "Term lagged",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4097, Term lagged",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4097, Term lagged",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4097, Term lagged",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4097, Term lagged"
};
static const _error _error_OB_TERM_NOT_MATCH = {
      .error_name            = "OB_TERM_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Term not match",
      .str_user_error        = "Term not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4098, Term not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4098, Term not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4098, Term not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4098, Term not match"
};
static const _error _error_OB_START_LOG_CURSOR_INVALID = {
      .error_name            = "OB_START_LOG_CURSOR_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid log cursor",
      .str_user_error        = "Invalid log cursor",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4099, Invalid log cursor",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4099, Invalid log cursor",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4099, Invalid log cursor",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4099, Invalid log cursor"
};
static const _error _error_OB_LOCK_NOT_MATCH = {
      .error_name            = "OB_LOCK_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Lock not match",
      .str_user_error        = "Lock not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4100, Lock not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4100, Lock not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4100, Lock not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4100, Lock not match"
};
static const _error _error_OB_DEAD_LOCK = {
      .error_name            = "OB_DEAD_LOCK",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_LOCK_DEADLOCK,
      .sqlstate              = "HY000",
      .str_error             = "Deadlock",
      .str_user_error        = "Deadlock",
      .oracle_errno          = 60,
      .oracle_str_error      = "ORA-00060: deadlock detected while waiting for resource",
      .oracle_str_user_error = "ORA-00060: deadlock detected while waiting for resource",
      .ob_str_error          = "OBE-00060: deadlock detected while waiting for resource",
      .ob_str_user_error     = "OBE-00060: deadlock detected while waiting for resource"
};
static const _error _error_OB_PARTIAL_LOG = {
      .error_name            = "OB_PARTIAL_LOG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Incomplete log entry",
      .str_user_error        = "Incomplete log entry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4102, Incomplete log entry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4102, Incomplete log entry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4102, Incomplete log entry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4102, Incomplete log entry"
};
static const _error _error_OB_CHECKSUM_ERROR = {
      .error_name            = "OB_CHECKSUM_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Data checksum error",
      .str_user_error        = "Data checksum error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4103, Data checksum error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4103, Data checksum error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4103, Data checksum error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4103, Data checksum error"
};
static const _error _error_OB_INIT_FAIL = {
      .error_name            = "OB_INIT_FAIL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Initialize error",
      .str_user_error        = "Initialize error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4104, Initialize error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4104, Initialize error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4104, Initialize error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4104, Initialize error"
};
static const _error _error_OB_ROWKEY_ORDER_ERROR = {
      .error_name            = "OB_ROWKEY_ORDER_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Rowkey order error",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4105, Rowkey order error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4105, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4105, Rowkey order error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4105, %s"
};
static const _error _error_OB_NOT_ENOUGH_STORE = {
      .error_name            = "OB_NOT_ENOUGH_STORE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "not enough commitlog store",
      .str_user_error        = "not enough commitlog store",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4106, not enough commitlog store",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4106, not enough commitlog store",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4106, not enough commitlog store",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4106, not enough commitlog store"
};
static const _error _error_OB_BLOCK_SWITCHED = {
      .error_name            = "OB_BLOCK_SWITCHED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "block switched when fill commitlog",
      .str_user_error        = "block switched when fill commitlog",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4107, block switched when fill commitlog",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4107, block switched when fill commitlog",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4107, block switched when fill commitlog",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4107, block switched when fill commitlog"
};
static const _error _error_OB_PHYSIC_CHECKSUM_ERROR = {
      .error_name            = "OB_PHYSIC_CHECKSUM_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Physic data checksum error",
      .str_user_error        = "Physic data checksum error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4108, Physic data checksum error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4108, Physic data checksum error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4108, Physic data checksum error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4108, Physic data checksum error"
};
static const _error _error_OB_STATE_NOT_MATCH = {
      .error_name            = "OB_STATE_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Server state or role not the same as expected",
      .str_user_error        = "Server state or role not the same as expected",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4109, Server state or role not the same as expected",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4109, Server state or role not the same as expected",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4109, Server state or role not the same as expected",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4109, Server state or role not the same as expected"
};
static const _error _error_OB_READ_ZERO_LOG = {
      .error_name            = "OB_READ_ZERO_LOG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Read zero log",
      .str_user_error        = "Read zero log",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4110, Read zero log",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4110, Read zero log",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4110, Read zero log",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4110, Read zero log"
};
static const _error _error_OB_BLOCK_NEED_FREEZE = {
      .error_name            = "OB_BLOCK_NEED_FREEZE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "block need freeze",
      .str_user_error        = "block need freeze",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4111, block need freeze",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4111, block need freeze",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4111, block need freeze",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4111, block need freeze"
};
static const _error _error_OB_BLOCK_FROZEN = {
      .error_name            = "OB_BLOCK_FROZEN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "block frozen",
      .str_user_error        = "block frozen",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4112, block frozen",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4112, block frozen",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4112, block frozen",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4112, block frozen"
};
static const _error _error_OB_IN_FATAL_STATE = {
      .error_name            = "OB_IN_FATAL_STATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "In FATAL state",
      .str_user_error        = "In FATAL state",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4113, In FATAL state",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4113, In FATAL state",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4113, In FATAL state",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4113, In FATAL state"
};
static const _error _error_OB_IN_STOP_STATE = {
      .error_name            = "OB_IN_STOP_STATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "08S01",
      .str_error             = "In STOP state",
      .str_user_error        = "In STOP state",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4114, In STOP state",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4114, In STOP state",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4114, In STOP state",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4114, In STOP state"
};
static const _error _error_OB_UPS_MASTER_EXISTS = {
      .error_name            = "OB_UPS_MASTER_EXISTS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Master UpdateServer already exists",
      .str_user_error        = "Master UpdateServer already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4115, Master UpdateServer already exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4115, Master UpdateServer already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4115, Master UpdateServer already exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4115, Master UpdateServer already exists"
};
static const _error _error_OB_LOG_NOT_CLEAR = {
      .error_name            = "OB_LOG_NOT_CLEAR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Log not clear",
      .str_user_error        = "Log not clear",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4116, Log not clear",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4116, Log not clear",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4116, Log not clear",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4116, Log not clear"
};
static const _error _error_OB_FILE_ALREADY_EXIST = {
      .error_name            = "OB_FILE_ALREADY_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FILE_EXISTS_ERROR,
      .sqlstate              = "58000",
      .str_error             = "File already exist",
      .str_user_error        = "File already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4117, File already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4117, File already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4117, File already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4117, File already exist"
};
static const _error _error_OB_UNKNOWN_PACKET = {
      .error_name            = "OB_UNKNOWN_PACKET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_COM_ERROR,
      .sqlstate              = "HY001",
      .str_error             = "Unknown packet",
      .str_user_error        = "Unknown packet",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4118, Unknown packet",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4118, Unknown packet",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4118, Unknown packet",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4118, Unknown packet"
};
static const _error _error_OB_RPC_PACKET_TOO_LONG = {
      .error_name            = "OB_RPC_PACKET_TOO_LONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "08000",
      .str_error             = "RPC packet to send too long",
      .str_user_error        = "RPC packet to send too long",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4119, RPC packet to send too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4119, RPC packet to send too long",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4119, RPC packet to send too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4119, RPC packet to send too long"
};
static const _error _error_OB_LOG_TOO_LARGE = {
      .error_name            = "OB_LOG_TOO_LARGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Log too large",
      .str_user_error        = "Log too large",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4120, Log too large",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4120, Log too large",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4120, Log too large",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4120, Log too large"
};
static const _error _error_OB_RPC_SEND_ERROR = {
      .error_name            = "OB_RPC_SEND_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4012,
      .sqlstate              = "HY000",
      .str_error             = "RPC send error",
      .str_user_error        = "RPC send error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4121, RPC send error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4121, RPC send error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4121, RPC send error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4121, RPC send error"
};
static const _error _error_OB_RPC_POST_ERROR = {
      .error_name            = "OB_RPC_POST_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4012,
      .sqlstate              = "HY000",
      .str_error             = "RPC post error",
      .str_user_error        = "RPC post error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4122, RPC post error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4122, RPC post error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4122, RPC post error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4122, RPC post error"
};
static const _error _error_OB_LIBEASY_ERROR = {
      .error_name            = "OB_LIBEASY_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "08000",
      .str_error             = "Libeasy error",
      .str_user_error        = "Libeasy error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4123, Libeasy error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4123, Libeasy error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4123, Libeasy error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4123, Libeasy error"
};
static const _error _error_OB_CONNECT_ERROR = {
      .error_name            = "OB_CONNECT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Connect error",
      .str_user_error        = "Connect error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4124, Connect error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4124, Connect error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4124, Connect error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4124, Connect error"
};
static const _error _error_OB_NOT_FREE = {
      .error_name            = "OB_NOT_FREE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not free",
      .str_user_error        = "Not free",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4125, Not free",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4125, Not free",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4125, Not free",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4125, Not free"
};
static const _error _error_OB_INIT_SQL_CONTEXT_ERROR = {
      .error_name            = "OB_INIT_SQL_CONTEXT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Init SQL context error",
      .str_user_error        = "Init SQL context error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4126, Init SQL context error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4126, Init SQL context error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4126, Init SQL context error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4126, Init SQL context error"
};
static const _error _error_OB_SKIP_INVALID_ROW = {
      .error_name            = "OB_SKIP_INVALID_ROW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Skip invalid row",
      .str_user_error        = "Skip invalid row",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4127, Skip invalid row",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4127, Skip invalid row",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4127, Skip invalid row",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4127, Skip invalid row"
};
static const _error _error_OB_RPC_PACKET_INVALID = {
      .error_name            = "OB_RPC_PACKET_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "RPC packet is invalid",
      .str_user_error        = "RPC packet is invalid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4128, RPC packet is invalid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4128, RPC packet is invalid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4128, RPC packet is invalid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4128, RPC packet is invalid"
};
static const _error _error_OB_NO_TABLET = {
      .error_name            = "OB_NO_TABLET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No tablets",
      .str_user_error        = "No tablets",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4133, No tablets",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4133, No tablets",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4133, No tablets",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4133, No tablets"
};
static const _error _error_OB_SNAPSHOT_DISCARDED = {
      .error_name            = "OB_SNAPSHOT_DISCARDED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Request to read too old versioned data",
      .str_user_error        = "Request to read too old versioned data",
      .oracle_errno          = 1555,
      .oracle_str_error      = "ORA-01555: snapshot too old",
      .oracle_str_user_error = "ORA-01555: snapshot too old",
      .ob_str_error          = "OBE-01555: snapshot too old",
      .ob_str_user_error     = "OBE-01555: snapshot too old"
};
static const _error _error_OB_DATA_NOT_UPTODATE = {
      .error_name            = "OB_DATA_NOT_UPTODATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "State is stale",
      .str_user_error        = "State is stale",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4139, State is stale",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4139, State is stale",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4139, State is stale",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4139, State is stale"
};
static const _error _error_OB_ROW_MODIFIED = {
      .error_name            = "OB_ROW_MODIFIED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Row modified",
      .str_user_error        = "Row modified",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4142, Row modified",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4142, Row modified",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4142, Row modified",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4142, Row modified"
};
static const _error _error_OB_VERSION_NOT_MATCH = {
      .error_name            = "OB_VERSION_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Version not match",
      .str_user_error        = "Version not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4143, Version not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4143, Version not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4143, Version not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4143, Version not match"
};
static const _error _error_OB_BAD_ADDRESS = {
      .error_name            = "OB_BAD_ADDRESS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Bad address",
      .str_user_error        = "Bad address",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4144, Bad address",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4144, Bad address",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4144, Bad address",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4144, Bad address"
};
static const _error _error_OB_ENQUEUE_FAILED = {
      .error_name            = "OB_ENQUEUE_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Enqueue error",
      .str_user_error        = "Enqueue error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4146, Enqueue error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4146, Enqueue error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4146, Enqueue error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4146, Enqueue error"
};
static const _error _error_OB_INVALID_CONFIG = {
      .error_name            = "OB_INVALID_CONFIG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid config",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4147, Invalid config",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4147, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4147, Invalid config",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4147, %s"
};
static const _error _error_OB_STMT_EXPIRED = {
      .error_name            = "OB_STMT_EXPIRED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Expired statement",
      .str_user_error        = "Expired statement",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4149, Expired statement",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4149, Expired statement",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4149, Expired statement",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4149, Expired statement"
};
static const _error _error_OB_ERR_MIN_VALUE = {
      .error_name            = "OB_ERR_MIN_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Min value",
      .str_user_error        = "Min value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4150, Min value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4150, Min value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4150, Min value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4150, Min value"
};
static const _error _error_OB_ERR_MAX_VALUE = {
      .error_name            = "OB_ERR_MAX_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Max value",
      .str_user_error        = "Max value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4151, Max value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4151, Max value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4151, Max value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4151, Max value"
};
static const _error _error_OB_ERR_NULL_VALUE = {
      .error_name            = "OB_ERR_NULL_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Null value",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4152, Null value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4152, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4152, Null value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4152, %s"
};
static const _error _error_OB_RESOURCE_OUT = {
      .error_name            = "OB_RESOURCE_OUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_OUT_OF_RESOURCES,
      .sqlstate              = "53000",
      .str_error             = "Out of resource",
      .str_user_error        = "Out of resource",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4153, Out of resource",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4153, Out of resource",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4153, Out of resource",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4153, Out of resource"
};
static const _error _error_OB_ERR_SQL_CLIENT = {
      .error_name            = "OB_ERR_SQL_CLIENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Internal SQL client error",
      .str_user_error        = "Internal SQL client error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4154, Internal SQL client error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4154, Internal SQL client error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4154, Internal SQL client error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4154, Internal SQL client error"
};
static const _error _error_OB_META_TABLE_WITHOUT_USE_TABLE = {
      .error_name            = "OB_META_TABLE_WITHOUT_USE_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Meta table without use table",
      .str_user_error        = "Meta table without use table",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4155, Meta table without use table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4155, Meta table without use table",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4155, Meta table without use table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4155, Meta table without use table"
};
static const _error _error_OB_DISCARD_PACKET = {
      .error_name            = "OB_DISCARD_PACKET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Discard packet",
      .str_user_error        = "Discard packet",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4156, Discard packet",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4156, Discard packet",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4156, Discard packet",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4156, Discard packet"
};
static const _error _error_OB_OPERATE_OVERFLOW = {
      .error_name            = "OB_OPERATE_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DATA_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "value is out of range",
      .str_user_error        = "%s value is out of range in '%s'",
      .oracle_errno          = 25137,
      .oracle_str_error      = "ORA-25137: Data value out of range",
      .oracle_str_user_error = "ORA-25137: Data value %s out of range in '%s'",
      .ob_str_error          = "OBE-25137: Data value out of range",
      .ob_str_user_error     = "OBE-25137: Data value %s out of range in '%s'"
};
static const _error _error_OB_INVALID_DATE_FORMAT = {
      .error_name            = "OB_INVALID_DATE_FORMAT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TRUNCATED_WRONG_VALUE,
      .sqlstate              = "22007",
      .str_error             = "Incorrect value",
      .str_user_error        = "%s=%d must between %d and %d",
      .oracle_errno          = 1821,
      .oracle_str_error      = "ORA-01821: date format not recognized",
      .oracle_str_user_error = "ORA-01821: date format not recognized, %s=%d must between %d and %d",
      .ob_str_error          = "OBE-01821: date format not recognized",
      .ob_str_user_error     = "OBE-01821: date format not recognized, %s=%d must between %d and %d"
};
static const _error _error_OB_POOL_REGISTERED_FAILED = {
      .error_name            = "OB_POOL_REGISTERED_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "register pool failed",
      .str_user_error        = "register pool failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4159, register pool failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4159, register pool failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4159, register pool failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4159, register pool failed"
};
static const _error _error_OB_POOL_UNREGISTERED_FAILED = {
      .error_name            = "OB_POOL_UNREGISTERED_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unregister pool failed",
      .str_user_error        = "unregister pool failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4160, unregister pool failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4160, unregister pool failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4160, unregister pool failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4160, unregister pool failed"
};
static const _error _error_OB_INVALID_ARGUMENT_NUM = {
      .error_name            = "OB_INVALID_ARGUMENT_NUM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument num",
      .str_user_error        = "Invalid argument num",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4161, Invalid argument num",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4161, Invalid argument num",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4161, Invalid argument num",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4161, Invalid argument num"
};
static const _error _error_OB_LEASE_NOT_ENOUGH = {
      .error_name            = "OB_LEASE_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "reserved lease not enough",
      .str_user_error        = "reserved lease not enough",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4162, reserved lease not enough",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4162, reserved lease not enough",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4162, reserved lease not enough",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4162, reserved lease not enough"
};
static const _error _error_OB_LEASE_NOT_MATCH = {
      .error_name            = "OB_LEASE_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ups lease not match with rs",
      .str_user_error        = "ups lease not match with rs",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4163, ups lease not match with rs",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4163, ups lease not match with rs",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4163, ups lease not match with rs",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4163, ups lease not match with rs"
};
static const _error _error_OB_UPS_SWITCH_NOT_HAPPEN = {
      .error_name            = "OB_UPS_SWITCH_NOT_HAPPEN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ups switch not happen",
      .str_user_error        = "ups switch not happen",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4164, ups switch not happen",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4164, ups switch not happen",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4164, ups switch not happen",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4164, ups switch not happen"
};
static const _error _error_OB_EMPTY_RESULT = {
      .error_name            = "OB_EMPTY_RESULT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Empty result",
      .str_user_error        = "Empty result",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4165, Empty result",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4165, Empty result",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4165, Empty result",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4165, Empty result"
};
static const _error _error_OB_CACHE_NOT_HIT = {
      .error_name            = "OB_CACHE_NOT_HIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Cache not hit",
      .str_user_error        = "Cache not hit",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4166, Cache not hit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4166, Cache not hit",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4166, Cache not hit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4166, Cache not hit"
};
static const _error _error_OB_NESTED_LOOP_NOT_SUPPORT = {
      .error_name            = "OB_NESTED_LOOP_NOT_SUPPORT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Nested loop not support",
      .str_user_error        = "Nested loop not support",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4167, Nested loop not support",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4167, Nested loop not support",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4167, Nested loop not support",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4167, Nested loop not support"
};
static const _error _error_OB_LOG_INVALID_MOD_ID = {
      .error_name            = "OB_LOG_INVALID_MOD_ID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid log module id",
      .str_user_error        = "Invalid log module id",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4168, Invalid log module id",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4168, Invalid log module id",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4168, Invalid log module id",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4168, Invalid log module id"
};
static const _error _error_OB_LOG_MODULE_UNKNOWN = {
      .error_name            = "OB_LOG_MODULE_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unknown module name",
      .str_user_error        = "Unknown module name. Invalid Setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4169, Unknown module name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4169, Unknown module name. Invalid Setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4169, Unknown module name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4169, Unknown module name. Invalid Setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level"
};
static const _error _error_OB_LOG_LEVEL_INVALID = {
      .error_name            = "OB_LOG_LEVEL_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid level",
      .str_user_error        = "Invalid level. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4170, Invalid level",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4170, Invalid level. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4170, Invalid level",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4170, Invalid level. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level"
};
static const _error _error_OB_LOG_PARSER_SYNTAX_ERR = {
      .error_name            = "OB_LOG_PARSER_SYNTAX_ERR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Syntax to set log_level error",
      .str_user_error        = "Syntax to set log_level error. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4171, Syntax to set log_level error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4171, Syntax to set log_level error. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4171, Syntax to set log_level error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4171, Syntax to set log_level error. Invalid setting:'%.*s'. Syntax:parMod.subMod:level, parMod.subMod:level"
};
static const _error _error_OB_INDEX_OUT_OF_RANGE = {
      .error_name            = "OB_INDEX_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Index out of range",
      .str_user_error        = "Index out of range",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4172, Index out of range",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4172, Index out of range",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4172, Index out of range",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4172, Index out of range"
};
static const _error _error_OB_INT_UNDERFLOW = {
      .error_name            = "OB_INT_UNDERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Int underflow",
      .str_user_error        = "Int underflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4173, Int underflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4173, Int underflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4173, Int underflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4173, Int underflow"
};
static const _error _error_OB_UNKNOWN_CONNECTION = {
      .error_name            = "OB_UNKNOWN_CONNECTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_SUCH_THREAD,
      .sqlstate              = "HY000",
      .str_error             = "Unknown thread id",
      .str_user_error        = "Unknown thread id: %lu",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4174, Unknown thread id",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4174, Unknown thread id: %lu",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4174, Unknown thread id",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4174, Unknown thread id: %lu"
};
static const _error _error_OB_ERROR_OUT_OF_RANGE = {
      .error_name            = "OB_ERROR_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Out of range",
      .str_user_error        = "Out of range",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4175, Out of range",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4175, Out of range",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4175, Out of range",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4175, Out of range"
};
static const _error _error_OB_CACHE_SHRINK_FAILED = {
      .error_name            = "OB_CACHE_SHRINK_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY001",
      .str_error             = "shrink cache failed, no available cache",
      .str_user_error        = "shrink cache failed, no available cache",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4176, shrink cache failed, no available cache",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4176, shrink cache failed, no available cache",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4176, shrink cache failed, no available cache",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4176, shrink cache failed, no available cache"
};
static const _error _error_OB_OLD_SCHEMA_VERSION = {
      .error_name            = "OB_OLD_SCHEMA_VERSION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Schema version too old",
      .str_user_error        = "Schema version too old",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4177, Schema version too old",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4177, Schema version too old",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4177, Schema version too old",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4177, Schema version too old"
};
static const _error _error_OB_RELEASE_SCHEMA_ERROR = {
      .error_name            = "OB_RELEASE_SCHEMA_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Release schema error",
      .str_user_error        = "Release schema error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4178, Release schema error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4178, Release schema error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4178, Release schema error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4178, Release schema error"
};
static const _error _error_OB_OP_NOT_ALLOW = {
      .error_name            = "OB_OP_NOT_ALLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Operation not allowed now",
      .str_user_error        = "%s not allowed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4179, Operation not allowed now",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4179, %s not allowed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4179, Operation not allowed now",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4179, %s not allowed"
};
static const _error _error_OB_NO_EMPTY_ENTRY = {
      .error_name            = "OB_NO_EMPTY_ENTRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No empty entry",
      .str_user_error        = "No empty entry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4180, No empty entry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4180, No empty entry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4180, No empty entry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4180, No empty entry"
};
static const _error _error_OB_ERR_ALREADY_EXISTS = {
      .error_name            = "OB_ERR_ALREADY_EXISTS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42S01",
      .str_error             = "Already exist",
      .str_user_error        = "Already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4181, Already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4181, Already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4181, Already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4181, Already exist"
};
static const _error _error_OB_SEARCH_NOT_FOUND = {
      .error_name            = "OB_SEARCH_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Value not found",
      .str_user_error        = "Value not found",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4182, Value not found",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4182, Value not found",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4182, Value not found",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4182, Value not found"
};
static const _error _error_OB_BEYOND_THE_RANGE = {
      .error_name            = "OB_BEYOND_THE_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Key out of range",
      .str_user_error        = "Key out of range",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4183, Key out of range",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4183, Key out of range",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4183, Key out of range",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4183, Key out of range"
};
static const _error _error_OB_SERVER_OUTOF_DISK_SPACE = {
      .error_name            = "OB_SERVER_OUTOF_DISK_SPACE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "53100",
      .str_error             = "Server out of disk space",
      .str_user_error        = "Server out of disk space",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4184, Server out of disk space",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4184, Server out of disk space",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4184, Server out of disk space",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4184, Server out of disk space"
};
static const _error _error_OB_COLUMN_GROUP_NOT_FOUND = {
      .error_name            = "OB_COLUMN_GROUP_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Column group \'%.*s\' not found",
      .str_user_error        = "Column group \'%.*s\' not found",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4185, Column group \'%.*s\' not found",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4185, Column group \'%.*s\' not found",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4185, Column group \'%.*s\' not found",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4185, Column group \'%.*s\' not found"
};
static const _error _error_OB_CS_COMPRESS_LIB_ERROR = {
      .error_name            = "OB_CS_COMPRESS_LIB_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Server failed to get compress library",
      .str_user_error        = "Server failed to get compress library",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4186, Server failed to get compress library",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4186, Server failed to get compress library",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4186, Server failed to get compress library",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4186, Server failed to get compress library"
};
static const _error _error_OB_ITEM_NOT_MATCH = {
      .error_name            = "OB_ITEM_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Item not match",
      .str_user_error        = "Item not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4187, Item not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4187, Item not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4187, Item not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4187, Item not match"
};
static const _error _error_OB_SCHEDULER_TASK_CNT_MISMATCH = {
      .error_name            = "OB_SCHEDULER_TASK_CNT_MISMATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Running task cnt and unfinished task cnt not consistent",
      .str_user_error        = "Running task cnt and unfinished task cnt not consistent",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4188, Running task cnt and unfinished task cnt not consistent",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4188, Running task cnt and unfinished task cnt not consistent",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4188, Running task cnt and unfinished task cnt not consistent",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4188, Running task cnt and unfinished task cnt not consistent"
};
static const _error _error_OB_INVALID_MACRO_BLOCK_TYPE = {
      .error_name            = "OB_INVALID_MACRO_BLOCK_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the macro block type does not exist",
      .str_user_error        = "the macro block type does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4189, the macro block type does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4189, the macro block type does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4189, the macro block type does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4189, the macro block type does not exist"
};
static const _error _error_OB_INVALID_DATE_FORMAT_END = {
      .error_name            = "OB_INVALID_DATE_FORMAT_END",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TRUNCATED_WRONG_VALUE,
      .sqlstate              = "22007",
      .str_error             = "Incorrect value",
      .str_user_error        = "Incorrect value",
      .oracle_errno          = 1830,
      .oracle_str_error      = "ORA-01830: date format picture ends before converting entire input string",
      .oracle_str_user_error = "ORA-01830: date format picture ends before converting entire input string",
      .ob_str_error          = "OBE-01830: date format picture ends before converting entire input string",
      .ob_str_user_error     = "OBE-01830: date format picture ends before converting entire input string"
};
static const _error _error_OB_PG_IS_REMOVED = {
      .error_name            = "OB_PG_IS_REMOVED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "partition group is removed",
      .str_user_error        = "partition group is removed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4191, partition group is removed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4191, partition group is removed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4191, partition group is removed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4191, partition group is removed"
};
static const _error _error_OB_DDL_TASK_EXECUTE_TOO_MUCH_TIME = {
      .error_name            = "OB_DDL_TASK_EXECUTE_TOO_MUCH_TIME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "ddl task executes too much time",
      .str_user_error        = "ddl task executes too much time",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4192, ddl task executes too much time",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4192, ddl task executes too much time",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4192, ddl task executes too much time",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4192, ddl task executes too much time"
};
static const _error _error_OB_HASH_EXIST = {
      .error_name            = "OB_HASH_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "hash map/set entry exist",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4200, hash map/set entry exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4200, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4200, hash map/set entry exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4200, %s"
};
static const _error _error_OB_HASH_NOT_EXIST = {
      .error_name            = "OB_HASH_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "hash map/set entry not exist",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4201, hash map/set entry not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4201, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4201, hash map/set entry not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4201, %s"
};
static const _error _error_OB_HASH_GET_TIMEOUT = {
      .error_name            = "OB_HASH_GET_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "hash map/set get timeout",
      .str_user_error        = "hash map/set get timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4204, hash map/set get timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4204, hash map/set get timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4204, hash map/set get timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4204, hash map/set get timeout"
};
static const _error _error_OB_HASH_PLACEMENT_RETRY = {
      .error_name            = "OB_HASH_PLACEMENT_RETRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "hash map/set retry",
      .str_user_error        = "hash map/set retry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4205, hash map/set retry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4205, hash map/set retry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4205, hash map/set retry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4205, hash map/set retry"
};
static const _error _error_OB_HASH_FULL = {
      .error_name            = "OB_HASH_FULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "hash map/set full",
      .str_user_error        = "hash map/set full",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4206, hash map/set full",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4206, hash map/set full",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4206, hash map/set full",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4206, hash map/set full"
};
static const _error _error_OB_PACKET_PROCESSED = {
      .error_name            = "OB_PACKET_PROCESSED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "packet processed",
      .str_user_error        = "packet processed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4207, packet processed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4207, packet processed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4207, packet processed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4207, packet processed"
};
static const _error _error_OB_WAIT_NEXT_TIMEOUT = {
      .error_name            = "OB_WAIT_NEXT_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "wait next packet timeout",
      .str_user_error        = "wait next packet timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4208, wait next packet timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4208, wait next packet timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4208, wait next packet timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4208, wait next packet timeout"
};
static const _error _error_OB_LEADER_NOT_EXIST = {
      .error_name            = "OB_LEADER_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "partition has not leader",
      .str_user_error        = "partition has not leader",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4209, partition has not leader",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4209, partition has not leader",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4209, partition has not leader",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4209, partition has not leader"
};
static const _error _error_OB_PREPARE_MAJOR_FREEZE_FAILED = {
      .error_name            = "OB_PREPARE_MAJOR_FREEZE_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "prepare major freeze failed",
      .str_user_error        = "prepare major freeze failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4210, prepare major freeze failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4210, prepare major freeze failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4210, prepare major freeze failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4210, prepare major freeze failed"
};
static const _error _error_OB_COMMIT_MAJOR_FREEZE_FAILED = {
      .error_name            = "OB_COMMIT_MAJOR_FREEZE_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "commit major freeze failed",
      .str_user_error        = "commit major freeze failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4211, commit major freeze failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4211, commit major freeze failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4211, commit major freeze failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4211, commit major freeze failed"
};
static const _error _error_OB_ABORT_MAJOR_FREEZE_FAILED = {
      .error_name            = "OB_ABORT_MAJOR_FREEZE_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "abort major freeze failed",
      .str_user_error        = "abort major freeze failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4212, abort major freeze failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4212, abort major freeze failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4212, abort major freeze failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4212, abort major freeze failed"
};
static const _error _error_OB_MAJOR_FREEZE_NOT_FINISHED = {
      .error_name            = "OB_MAJOR_FREEZE_NOT_FINISHED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "last major freeze not finish",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4213, last major freeze not finish",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4213, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4213, last major freeze not finish",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4213, %s"
};
static const _error _error_OB_PARTITION_NOT_LEADER = {
      .error_name            = "OB_PARTITION_NOT_LEADER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "partition is not leader partition",
      .str_user_error        = "partition is not leader partition",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4214, partition is not leader partition",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4214, partition is not leader partition",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4214, partition is not leader partition",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4214, partition is not leader partition"
};
static const _error _error_OB_WAIT_MAJOR_FREEZE_RESPONSE_TIMEOUT = {
      .error_name            = "OB_WAIT_MAJOR_FREEZE_RESPONSE_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "wait major freeze response timeout",
      .str_user_error        = "wait major freeze response timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4215, wait major freeze response timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4215, wait major freeze response timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4215, wait major freeze response timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4215, wait major freeze response timeout"
};
static const _error _error_OB_CURL_ERROR = {
      .error_name            = "OB_CURL_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "curl error",
      .str_user_error        = "curl error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4216, curl error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4216, curl error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4216, curl error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4216, curl error"
};
static const _error _error_OB_MAJOR_FREEZE_NOT_ALLOW = {
      .error_name            = "OB_MAJOR_FREEZE_NOT_ALLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Major freeze not allowed now",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4217, Major freeze not allowed now",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4217, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4217, Major freeze not allowed now",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4217, %s"
};
static const _error _error_OB_PREPARE_FREEZE_FAILED = {
      .error_name            = "OB_PREPARE_FREEZE_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "prepare freeze failed",
      .str_user_error        = "prepare freeze failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4218, prepare freeze failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4218, prepare freeze failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4218, prepare freeze failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4218, prepare freeze failed"
};
static const _error _error_OB_INVALID_DATE_VALUE = {
      .error_name            = "OB_INVALID_DATE_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TRUNCATED_WRONG_VALUE,
      .sqlstate              = "22007",
      .str_error             = "Incorrect value",
      .str_user_error        = "Incorrect datetime value: '%.*s' for column '%s'",
      .oracle_errno          = 1861,
      .oracle_str_error      = "ORA-01861: literal does not match format string",
      .oracle_str_user_error = "ORA-01861: literal does not match format string: '%.*s' for column '%s'",
      .ob_str_error          = "OBE-01861: literal does not match format string",
      .ob_str_user_error     = "OBE-01861: literal does not match format string: '%.*s' for column '%s'"
};
static const _error _error_OB_INACTIVE_SQL_CLIENT = {
      .error_name            = "OB_INACTIVE_SQL_CLIENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Inactive sql client, only read allowed",
      .str_user_error        = "Inactive sql client, only read allowed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4220, Inactive sql client, only read allowed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4220, Inactive sql client, only read allowed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4220, Inactive sql client, only read allowed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4220, Inactive sql client, only read allowed"
};
static const _error _error_OB_INACTIVE_RPC_PROXY = {
      .error_name            = "OB_INACTIVE_RPC_PROXY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Inactive rpc proxy, can not send RPC request",
      .str_user_error        = "Inactive rpc proxy, can not send RPC request",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4221, Inactive rpc proxy, can not send RPC request",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4221, Inactive rpc proxy, can not send RPC request",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4221, Inactive rpc proxy, can not send RPC request",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4221, Inactive rpc proxy, can not send RPC request"
};
static const _error _error_OB_INTERVAL_WITH_MONTH = {
      .error_name            = "OB_INTERVAL_WITH_MONTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Interval with year or month can not be converted to microseconds",
      .str_user_error        = "Interval with year or month can not be converted to microseconds",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4222, Interval with year or month can not be converted to microseconds",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4222, Interval with year or month can not be converted to microseconds",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4222, Interval with year or month can not be converted to microseconds",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4222, Interval with year or month can not be converted to microseconds"
};
static const _error _error_OB_TOO_MANY_DATETIME_PARTS = {
      .error_name            = "OB_TOO_MANY_DATETIME_PARTS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Interval has too many datetime parts",
      .str_user_error        = "Interval has too many datetime parts",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4223, Interval has too many datetime parts",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4223, Interval has too many datetime parts",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4223, Interval has too many datetime parts",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4223, Interval has too many datetime parts"
};
static const _error _error_OB_DATA_OUT_OF_RANGE = {
      .error_name            = "OB_DATA_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DATA_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "Out of range value for column",
      .str_user_error        = "Out of range value for column '%.*s' at row %ld",
      .oracle_errno          = 1438,
      .oracle_str_error      = "ORA-01438: value larger than specified precision allowed for this column",
      .oracle_str_user_error = "ORA-01438: value larger than specified precision allowed for this column '%.*s' at row %ld",
      .ob_str_error          = "OBE-01438: value larger than specified precision allowed for this column",
      .ob_str_user_error     = "OBE-01438: value larger than specified precision allowed for this column '%.*s' at row %ld"
};
static const _error _error_OB_PARTITION_NOT_EXIST = {
      .error_name            = "OB_PARTITION_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Partition entry not exists",
      .str_user_error        = "Partition entry not exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4225, Partition entry not exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4225, Partition entry not exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4225, Partition entry not exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4225, Partition entry not exists"
};
static const _error _error_OB_ERR_TRUNCATED_WRONG_VALUE_FOR_FIELD = {
      .error_name            = "OB_ERR_TRUNCATED_WRONG_VALUE_FOR_FIELD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TRUNCATED_WRONG_VALUE_FOR_FIELD,
      .sqlstate              = "HY000",
      .str_error             = "Incorrect integer value",
      .str_user_error        = "Incorrect integer value for column '%.*s' at row %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4226, Incorrect integer value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4226, Incorrect integer value for column '%.*s' at row %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4226, Incorrect integer value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4226, Incorrect integer value for column '%.*s' at row %ld"
};
static const _error _error_OB_ERR_NO_DEFAULT_FOR_FIELD = {
      .error_name            = "OB_ERR_NO_DEFAULT_FOR_FIELD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_DEFAULT_FOR_FIELD,
      .sqlstate              = "HY000",
      .str_error             = "Field doesn\'t have a default value",
      .str_user_error        = "Field \'%s\' doesn't have a default value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4227, Field doesn\'t have a default value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4227, Field \'%s\' doesn't have a default value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4227, Field doesn\'t have a default value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4227, Field \'%s\' doesn't have a default value"
};
static const _error _error_OB_ERR_FIELD_SPECIFIED_TWICE = {
      .error_name            = "OB_ERR_FIELD_SPECIFIED_TWICE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FIELD_SPECIFIED_TWICE,
      .sqlstate              = "42000",
      .str_error             = "Column specified twice",
      .str_user_error        = "Column \'%s\' specified twice",
      .oracle_errno          = 957,
      .oracle_str_error      = "ORA-00957: duplicate column name",
      .oracle_str_user_error = "ORA-00957: duplicate column name \'%s\'",
      .ob_str_error          = "OBE-00957: duplicate column name",
      .ob_str_user_error     = "OBE-00957: duplicate column name \'%s\'"
};
static const _error _error_OB_ERR_TOO_LONG_TABLE_COMMENT = {
      .error_name            = "OB_ERR_TOO_LONG_TABLE_COMMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_LONG_TABLE_COMMENT,
      .sqlstate              = "HY000",
      .str_error             = "Comment for table is too long",
      .str_user_error        = "Comment for table is too long (max = %ld)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4229, Comment for table is too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4229, Comment for table is too long (max = %ld)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4229, Comment for table is too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4229, Comment for table is too long (max = %ld)"
};
static const _error _error_OB_ERR_TOO_LONG_FIELD_COMMENT = {
      .error_name            = "OB_ERR_TOO_LONG_FIELD_COMMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_LONG_FIELD_COMMENT,
      .sqlstate              = "HY000",
      .str_error             = "Comment for field is too long",
      .str_user_error        = "Comment for field is too long (max = %ld)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4230, Comment for field is too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4230, Comment for field is too long (max = %ld)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4230, Comment for field is too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4230, Comment for field is too long (max = %ld)"
};
static const _error _error_OB_ERR_TOO_LONG_INDEX_COMMENT = {
      .error_name            = "OB_ERR_TOO_LONG_INDEX_COMMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_LONG_INDEX_COMMENT,
      .sqlstate              = "HY000",
      .str_error             = "Comment for index is too long",
      .str_user_error        = "Comment for index is too long (max = %ld)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4231, Comment for index is too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4231, Comment for index is too long (max = %ld)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4231, Comment for index is too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4231, Comment for index is too long (max = %ld)"
};
static const _error _error_OB_NOT_FOLLOWER = {
      .error_name            = "OB_NOT_FOLLOWER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The observer or zone is not a follower",
      .str_user_error        = "The observer or zone is not a follower",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4232, The observer or zone is not a follower",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4232, The observer or zone is not a follower",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4232, The observer or zone is not a follower",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4232, The observer or zone is not a follower"
};
static const _error _error_OB_ERR_OUT_OF_LOWER_BOUND = {
      .error_name            = "OB_ERR_OUT_OF_LOWER_BOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "smaller than container lower bound",
      .str_user_error        = "smaller than container lower bound",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4233, smaller than container lower bound",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4233, smaller than container lower bound",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4233, smaller than container lower bound",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4233, smaller than container lower bound"
};
static const _error _error_OB_ERR_OUT_OF_UPPER_BOUND = {
      .error_name            = "OB_ERR_OUT_OF_UPPER_BOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "bigger than container upper bound",
      .str_user_error        = "bigger than container upper bound",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4234, bigger than container upper bound",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4234, bigger than container upper bound",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4234, bigger than container upper bound",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4234, bigger than container upper bound"
};
static const _error _error_OB_BAD_NULL_ERROR = {
      .error_name            = "OB_BAD_NULL_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_BAD_NULL_ERROR,
      .sqlstate              = "23000",
      .str_error             = "Column cannot be null",
      .str_user_error        = "Column '%.*s' cannot be null",
      .oracle_errno          = 1400,
      .oracle_str_error      = "ORA-01400: cannot insert NULL",
      .oracle_str_user_error = "ORA-01400: cannot insert NULL into '(%.*s)'",
      .ob_str_error          = "OBE-01400: cannot insert NULL",
      .ob_str_user_error     = "OBE-01400: cannot insert NULL into '(%.*s)'"
};
static const _error _error_OB_OBCONFIG_RETURN_ERROR = {
      .error_name            = "OB_OBCONFIG_RETURN_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ObConfig return error code",
      .str_user_error        = "ObConfig return error code",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4236, ObConfig return error code",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4236, ObConfig return error code",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4236, ObConfig return error code",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4236, ObConfig return error code"
};
static const _error _error_OB_OBCONFIG_APPNAME_MISMATCH = {
      .error_name            = "OB_OBCONFIG_APPNAME_MISMATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Appname mismatch with obconfig result",
      .str_user_error        = "Appname mismatch with obconfig result",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4237, Appname mismatch with obconfig result",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4237, Appname mismatch with obconfig result",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4237, Appname mismatch with obconfig result",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4237, Appname mismatch with obconfig result"
};
static const _error _error_OB_ERR_VIEW_SELECT_DERIVED = {
      .error_name            = "OB_ERR_VIEW_SELECT_DERIVED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_VIEW_SELECT_DERIVED,
      .sqlstate              = "HY000",
      .str_error             = "View's SELECT contains a subquery in the FROM clause",
      .str_user_error        = "View's SELECT contains a subquery in the FROM clause",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4238, View's SELECT contains a subquery in the FROM clause",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4238, View's SELECT contains a subquery in the FROM clause",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4238, View's SELECT contains a subquery in the FROM clause",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4238, View's SELECT contains a subquery in the FROM clause"
};
static const _error _error_OB_CANT_MJ_PATH = {
      .error_name            = "OB_CANT_MJ_PATH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Can not use merge-join to join the tables without join conditions",
      .str_user_error        = "Can not use merge-join to join the tables without join conditions",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4239, Can not use merge-join to join the tables without join conditions",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4239, Can not use merge-join to join the tables without join conditions",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4239, Can not use merge-join to join the tables without join conditions",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4239, Can not use merge-join to join the tables without join conditions"
};
static const _error _error_OB_ERR_NO_JOIN_ORDER_GENERATED = {
      .error_name            = "OB_ERR_NO_JOIN_ORDER_GENERATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No join order generated",
      .str_user_error        = "No join order generated",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4240, No join order generated",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4240, No join order generated",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4240, No join order generated",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4240, No join order generated"
};
static const _error _error_OB_ERR_NO_PATH_GENERATED = {
      .error_name            = "OB_ERR_NO_PATH_GENERATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No join path generated",
      .str_user_error        = "No join path generated",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4241, No join path generated",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4241, No join path generated",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4241, No join path generated",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4241, No join path generated"
};
static const _error _error_OB_ERR_WAIT_REMOTE_SCHEMA_REFRESH = {
      .error_name            = "OB_ERR_WAIT_REMOTE_SCHEMA_REFRESH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Schema error",
      .str_user_error        = "Schema error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4242, Schema error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4242, Schema error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4242, Schema error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4242, Schema error"
};
static const _error _error_OB_FILE_NOT_OPENED = {
      .error_name            = "OB_FILE_NOT_OPENED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "file not opened",
      .str_user_error        = "file not opened",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4243, file not opened",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4243, file not opened",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4243, file not opened",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4243, file not opened"
};
static const _error _error_OB_TIMER_TASK_HAS_SCHEDULED = {
      .error_name            = "OB_TIMER_TASK_HAS_SCHEDULED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Timer task has been scheduled",
      .str_user_error        = "Timer task has been scheduled",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4244, Timer task has been scheduled",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4244, Timer task has been scheduled",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4244, Timer task has been scheduled",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4244, Timer task has been scheduled"
};
static const _error _error_OB_TIMER_TASK_HAS_NOT_SCHEDULED = {
      .error_name            = "OB_TIMER_TASK_HAS_NOT_SCHEDULED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Timer task has not been scheduled",
      .str_user_error        = "Timer task has not been scheduled",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4245, Timer task has not been scheduled",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4245, Timer task has not been scheduled",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4245, Timer task has not been scheduled",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4245, Timer task has not been scheduled"
};
static const _error _error_OB_PARSE_DEBUG_SYNC_ERROR = {
      .error_name            = "OB_PARSE_DEBUG_SYNC_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "parse debug sync string error",
      .str_user_error        = "parse debug sync string error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4246, parse debug sync string error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4246, parse debug sync string error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4246, parse debug sync string error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4246, parse debug sync string error"
};
static const _error _error_OB_UNKNOWN_DEBUG_SYNC_POINT = {
      .error_name            = "OB_UNKNOWN_DEBUG_SYNC_POINT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unknown debug sync point",
      .str_user_error        = "unknown debug sync point",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4247, unknown debug sync point",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4247, unknown debug sync point",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4247, unknown debug sync point",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4247, unknown debug sync point"
};
static const _error _error_OB_ERR_INTERRUPTED = {
      .error_name            = "OB_ERR_INTERRUPTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "task is interrupted while running",
      .str_user_error        = "task is interrupted while running",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4248, task is interrupted while running",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4248, task is interrupted while running",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4248, task is interrupted while running",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4248, task is interrupted while running"
};
static const _error _error_OB_ERR_DATA_TRUNCATED = {
      .error_name            = "OB_ERR_DATA_TRUNCATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = WARN_DATA_TRUNCATED,
      .sqlstate              = "01000",
      .str_error             = "Data truncated for argument",
      .str_user_error        = "Data truncated for column '%.*s' at row %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4249, Data truncated for argument",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4249, Data truncated for column '%.*s' at row %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4249, Data truncated for argument",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4249, Data truncated for column '%.*s' at row %ld"
};
static const _error _error_OB_NOT_RUNNING = {
      .error_name            = "OB_NOT_RUNNING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "module is not running",
      .str_user_error        = "module is not running",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4250, module is not running",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4250, module is not running",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4250, module is not running",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4250, module is not running"
};
static const _error _error_OB_INVALID_PARTITION = {
      .error_name            = "OB_INVALID_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "partition not valid",
      .str_user_error        = "partition not valid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4251, partition not valid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4251, partition not valid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4251, partition not valid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4251, partition not valid"
};
static const _error _error_OB_ERR_TIMEOUT_TRUNCATED = {
      .error_name            = "OB_ERR_TIMEOUT_TRUNCATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = WARN_DATA_TRUNCATED,
      .sqlstate              = "01000",
      .str_error             = "Timeout value truncated to 102 years",
      .str_user_error        = "Timeout value truncated to 102 years",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4252, Timeout value truncated to 102 years",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4252, Timeout value truncated to 102 years",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4252, Timeout value truncated to 102 years",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4252, Timeout value truncated to 102 years"
};
static const _error _error_OB_ERR_TOO_LONG_TENANT_COMMENT = {
      .error_name            = "OB_ERR_TOO_LONG_TENANT_COMMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Comment for tenant is too long",
      .str_user_error        = "Comment for tenant is too long (max = %ld)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4253, Comment for tenant is too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4253, Comment for tenant is too long (max = %ld)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4253, Comment for tenant is too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4253, Comment for tenant is too long (max = %ld)"
};
static const _error _error_OB_ERR_NET_PACKET_TOO_LARGE = {
      .error_name            = "OB_ERR_NET_PACKET_TOO_LARGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NET_PACKET_TOO_LARGE,
      .sqlstate              = "08S01",
      .str_error             = "Got a packet bigger than \'max_allowed_packet\' bytes",
      .str_user_error        = "Got a packet bigger than \'max_allowed_packet\' bytes",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4254, Got a packet bigger than \'max_allowed_packet\' bytes",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4254, Got a packet bigger than \'max_allowed_packet\' bytes",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4254, Got a packet bigger than \'max_allowed_packet\' bytes",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4254, Got a packet bigger than \'max_allowed_packet\' bytes"
};
static const _error _error_OB_TRACE_DESC_NOT_EXIST = {
      .error_name            = "OB_TRACE_DESC_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "trace log title or key not exist describe",
      .str_user_error        = "trace log title or key not exist describe",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4255, trace log title or key not exist describe",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4255, trace log title or key not exist describe",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4255, trace log title or key not exist describe",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4255, trace log title or key not exist describe"
};
static const _error _error_OB_ERR_NO_DEFAULT = {
      .error_name            = "OB_ERR_NO_DEFAULT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_DEFAULT,
      .sqlstate              = "42000",
      .str_error             = "Variable doesn't have a default value",
      .str_user_error        = "Variable '%.*s' doesn't have a default value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4256, Variable doesn't have a default value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4256, Variable '%.*s' doesn't have a default value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4256, Variable doesn't have a default value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4256, Variable '%.*s' doesn't have a default value"
};
static const _error _error_OB_ERR_COMPRESS_DECOMPRESS_DATA = {
      .error_name            = "OB_ERR_COMPRESS_DECOMPRESS_DATA",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "compress data or decompress data failed",
      .str_user_error        = "compress data or decompress data failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4257, compress data or decompress data failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4257, compress data or decompress data failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4257, compress data or decompress data failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4257, compress data or decompress data failed"
};
static const _error _error_OB_ERR_INCORRECT_STRING_VALUE = {
      .error_name            = "OB_ERR_INCORRECT_STRING_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TRUNCATED_WRONG_VALUE_FOR_FIELD,
      .sqlstate              = "HY000",
      .str_error             = "Incorrect string value",
      .str_user_error        = "Incorrect string value for column '%.*s' at row %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4258, Incorrect string value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4258, Incorrect string value for column '%.*s' at row %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4258, Incorrect string value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4258, Incorrect string value for column '%.*s' at row %ld"
};
static const _error _error_OB_IS_CHANGING_LEADER = {
      .error_name            = "OB_IS_CHANGING_LEADER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the partition is changing leader",
      .str_user_error        = "the partition is changing leader",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4260, the partition is changing leader",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4260, the partition is changing leader",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4260, the partition is changing leader",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4260, the partition is changing leader"
};
static const _error _error_OB_DATETIME_FUNCTION_OVERFLOW = {
      .error_name            = "OB_DATETIME_FUNCTION_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DATETIME_FUNCTION_OVERFLOW,
      .sqlstate              = "22008",
      .str_error             = "Datetime overflow",
      .str_user_error        = "Datetime overflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4261, Datetime overflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4261, Datetime overflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4261, Datetime overflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4261, Datetime overflow"
};
static const _error _error_OB_ERR_DOUBLE_TRUNCATED = {
      .error_name            = "OB_ERR_DOUBLE_TRUNCATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TRUNCATED_WRONG_VALUE,
      .sqlstate              = "01000",
      .str_error             = "Truncated incorrect DOUBLE value",
      .str_user_error        = "Truncated incorrect DOUBLE value: '%.*s'",
      .oracle_errno          = 1722,
      .oracle_str_error      = "ORA-01722: invalid number",
      .oracle_str_user_error = "ORA-01722: invalid number: '%.*s'",
      .ob_str_error          = "OBE-01722: invalid number",
      .ob_str_user_error     = "OBE-01722: invalid number: '%.*s'"
};
static const _error _error_OB_MINOR_FREEZE_NOT_ALLOW = {
      .error_name            = "OB_MINOR_FREEZE_NOT_ALLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Minor freeze not allowed now",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4263, Minor freeze not allowed now",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4263, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4263, Minor freeze not allowed now",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4263, %s"
};
static const _error _error_OB_LOG_OUTOF_DISK_SPACE = {
      .error_name            = "OB_LOG_OUTOF_DISK_SPACE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Log out of disk space",
      .str_user_error        = "Log out of disk space",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4264, Log out of disk space",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4264, Log out of disk space",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4264, Log out of disk space",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4264, Log out of disk space"
};
static const _error _error_OB_RPC_CONNECT_ERROR = {
      .error_name            = "OB_RPC_CONNECT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Rpc connect error",
      .str_user_error        = "Rpc connect error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4265, Rpc connect error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4265, Rpc connect error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4265, Rpc connect error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4265, Rpc connect error"
};
static const _error _error_OB_MINOR_MERGE_NOT_ALLOW = {
      .error_name            = "OB_MINOR_MERGE_NOT_ALLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "minor merge not allow",
      .str_user_error        = "minor merge not allow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4266, minor merge not allow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4266, minor merge not allow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4266, minor merge not allow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4266, minor merge not allow"
};
static const _error _error_OB_CACHE_INVALID = {
      .error_name            = "OB_CACHE_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Cache invalid",
      .str_user_error        = "Cache invalid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4267, Cache invalid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4267, Cache invalid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4267, Cache invalid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4267, Cache invalid"
};
static const _error _error_OB_REACH_SERVER_DATA_COPY_IN_CONCURRENCY_LIMIT = {
      .error_name            = "OB_REACH_SERVER_DATA_COPY_IN_CONCURRENCY_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "reach server data copy in concurrency",
      .str_user_error        = "reach server data copy in concurrency",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4268, reach server data copy in concurrency",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4268, reach server data copy in concurrency",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4268, reach server data copy in concurrency",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4268, reach server data copy in concurrency"
};
static const _error _error_OB_WORKING_PARTITION_EXIST = {
      .error_name            = "OB_WORKING_PARTITION_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Working partition entry already exists",
      .str_user_error        = "Working partition entry already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4269, Working partition entry already exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4269, Working partition entry already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4269, Working partition entry already exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4269, Working partition entry already exists"
};
static const _error _error_OB_WORKING_PARTITION_NOT_EXIST = {
      .error_name            = "OB_WORKING_PARTITION_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Working partition entry does not exists",
      .str_user_error        = "Working partition entry does not exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4270, Working partition entry does not exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4270, Working partition entry does not exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4270, Working partition entry does not exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4270, Working partition entry does not exists"
};
static const _error _error_OB_LIBEASY_REACH_MEM_LIMIT = {
      .error_name            = "OB_LIBEASY_REACH_MEM_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "LIBEASY reach memory limit",
      .str_user_error        = "LIBEASY reach memory limit",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4271, LIBEASY reach memory limit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4271, LIBEASY reach memory limit",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4271, LIBEASY reach memory limit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4271, LIBEASY reach memory limit"
};
static const _error _error_OB_CACHE_FREE_BLOCK_NOT_ENOUGH = {
      .error_name            = "OB_CACHE_FREE_BLOCK_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "free memblock in cache is not enough",
      .str_user_error        = "free memblock in cache is not enough",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4273, free memblock in cache is not enough",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4273, free memblock in cache is not enough",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4273, free memblock in cache is not enough",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4273, free memblock in cache is not enough"
};
static const _error _error_OB_SYNC_WASH_MB_TIMEOUT = {
      .error_name            = "OB_SYNC_WASH_MB_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sync wash memblock timeout",
      .str_user_error        = "sync wash memblock timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4274, sync wash memblock timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4274, sync wash memblock timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4274, sync wash memblock timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4274, sync wash memblock timeout"
};
static const _error _error_OB_NOT_ALLOW_MIGRATE_IN = {
      .error_name            = "OB_NOT_ALLOW_MIGRATE_IN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "not allow migrate in",
      .str_user_error        = "not allow migrate in",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4275, not allow migrate in",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4275, not allow migrate in",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4275, not allow migrate in",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4275, not allow migrate in"
};
static const _error _error_OB_SCHEDULER_TASK_CNT_MISTACH = {
      .error_name            = "OB_SCHEDULER_TASK_CNT_MISTACH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Scheduler task cnt does not match",
      .str_user_error        = "Scheduler task cnt does not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4276, Scheduler task cnt does not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4276, Scheduler task cnt does not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4276, Scheduler task cnt does not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4276, Scheduler task cnt does not match"
};
static const _error _error_OB_MISS_ARGUMENT = {
      .error_name            = "OB_MISS_ARGUMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_ARGUMENTS,
      .sqlstate              = "HY000",
      .str_error             = "Miss argument",
      .str_user_error        = "Miss argument for %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4277, Miss argument",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4277, Miss argument for %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4277, Miss argument",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4277, Miss argument for %s"
};
static const _error _error_OB_LAST_LOG_NOT_COMPLETE = {
      .error_name            = "OB_LAST_LOG_NOT_COMPLETE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "last log is not complete",
      .str_user_error        = "last log is not complete",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4278, last log is not complete",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4278, last log is not complete",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4278, last log is not complete",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4278, last log is not complete"
};
static const _error _error_OB_TABLE_IS_DELETED = {
      .error_name            = "OB_TABLE_IS_DELETED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "table is deleted",
      .str_user_error        = "table is deleted",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4279, table is deleted",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4279, table is deleted",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4279, table is deleted",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4279, table is deleted"
};
static const _error _error_OB_VERSION_RANGE_NOT_CONTINUES = {
      .error_name            = "OB_VERSION_RANGE_NOT_CONTINUES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "version range not continues",
      .str_user_error        = "version range not continues",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4280, version range not continues",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4280, version range not continues",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4280, version range not continues",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4280, version range not continues"
};
static const _error _error_OB_INVALID_IO_BUFFER = {
      .error_name            = "OB_INVALID_IO_BUFFER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "io buffer is invalid",
      .str_user_error        = "io buffer is invalid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4281, io buffer is invalid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4281, io buffer is invalid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4281, io buffer is invalid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4281, io buffer is invalid"
};
static const _error _error_OB_PARTITION_IS_REMOVED = {
      .error_name            = "OB_PARTITION_IS_REMOVED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "partition is removed",
      .str_user_error        = "partition is removed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4282, partition is removed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4282, partition is removed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4282, partition is removed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4282, partition is removed"
};
static const _error _error_OB_GTS_NOT_READY = {
      .error_name            = "OB_GTS_NOT_READY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "gts is not ready",
      .str_user_error        = "gts is not ready",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4283, gts is not ready",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4283, gts is not ready",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4283, gts is not ready",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4283, gts is not ready"
};
static const _error _error_OB_MAJOR_SSTABLE_NOT_EXIST = {
      .error_name            = "OB_MAJOR_SSTABLE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "major sstable not exist",
      .str_user_error        = "major sstable not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4284, major sstable not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4284, major sstable not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4284, major sstable not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4284, major sstable not exist"
};
static const _error _error_OB_VERSION_RANGE_DISCARDED = {
      .error_name            = "OB_VERSION_RANGE_DISCARDED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Request to read too old version range data",
      .str_user_error        = "Request to read too old version range data",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4285, Request to read too old version range data",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4285, Request to read too old version range data",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4285, Request to read too old version range data",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4285, Request to read too old version range data"
};
static const _error _error_OB_MAJOR_SSTABLE_HAS_MERGED = {
      .error_name            = "OB_MAJOR_SSTABLE_HAS_MERGED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "major sstable may has been merged",
      .str_user_error        = "major sstable may has been merged",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4286, major sstable may has been merged",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4286, major sstable may has been merged",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4286, major sstable may has been merged",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4286, major sstable may has been merged"
};
static const _error _error_OB_MINOR_SSTABLE_RANGE_CROSS = {
      .error_name            = "OB_MINOR_SSTABLE_RANGE_CROSS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "minor sstable version range cross",
      .str_user_error        = "minor sstable version range cross",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4287, minor sstable version range cross",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4287, minor sstable version range cross",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4287, minor sstable version range cross",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4287, minor sstable version range cross"
};
static const _error _error_OB_MEMTABLE_CANNOT_MINOR_MERGE = {
      .error_name            = "OB_MEMTABLE_CANNOT_MINOR_MERGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "memtable cannot minor merge",
      .str_user_error        = "memtable cannot minor merge",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4288, memtable cannot minor merge",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4288, memtable cannot minor merge",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4288, memtable cannot minor merge",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4288, memtable cannot minor merge"
};
static const _error _error_OB_TASK_EXIST = {
      .error_name            = "OB_TASK_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "task exist",
      .str_user_error        = "task exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4289, task exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4289, task exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4289, task exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4289, task exist"
};
static const _error _error_OB_ALLOCATE_DISK_SPACE_FAILED = {
      .error_name            = "OB_ALLOCATE_DISK_SPACE_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cannot allocate disk space",
      .str_user_error        = "cannot allocate disk space",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4290, cannot allocate disk space",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4290, cannot allocate disk space",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4290, cannot allocate disk space",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4290, cannot allocate disk space"
};
static const _error _error_OB_CANT_FIND_UDF = {
      .error_name            = "OB_CANT_FIND_UDF",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_FIND_UDF,
      .sqlstate              = "HY000",
      .str_error             = "Can't load function",
      .str_user_error        = "Can not load function %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4291, Can't load function",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4291, Can not load function %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4291, Can't load function",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4291, Can not load function %s"
};
static const _error _error_OB_CANT_INITIALIZE_UDF = {
      .error_name            = "OB_CANT_INITIALIZE_UDF",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_INITIALIZE_UDF,
      .sqlstate              = "HY000",
      .str_error             = "Can't initialize function",
      .str_user_error        = "Can not initialize function '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4292, Can't initialize function",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4292, Can not initialize function '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4292, Can't initialize function",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4292, Can not initialize function '%.*s'"
};
static const _error _error_OB_UDF_NO_PATHS = {
      .error_name            = "OB_UDF_NO_PATHS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UDF_NO_PATHS,
      .sqlstate              = "HY000",
      .str_error             = "No paths allowed for shared library",
      .str_user_error        = "No paths allowed for shared library",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4293, No paths allowed for shared library",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4293, No paths allowed for shared library",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4293, No paths allowed for shared library",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4293, No paths allowed for shared library"
};
static const _error _error_OB_UDF_EXISTS = {
      .error_name            = "OB_UDF_EXISTS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UDF_EXISTS,
      .sqlstate              = "HY000",
      .str_error             = "Function already exists",
      .str_user_error        = "Function %.*s already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4294, Function already exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4294, Function %.*s already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4294, Function already exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4294, Function %.*s already exists"
};
static const _error _error_OB_CANT_OPEN_LIBRARY = {
      .error_name            = "OB_CANT_OPEN_LIBRARY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_OPEN_LIBRARY,
      .sqlstate              = "HY000",
      .str_error             = "Can't open shared library",
      .str_user_error        = "Can not open shared library '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4295, Can't open shared library",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4295, Can not open shared library '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4295, Can't open shared library",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4295, Can not open shared library '%.*s'"
};
static const _error _error_OB_CANT_FIND_DL_ENTRY = {
      .error_name            = "OB_CANT_FIND_DL_ENTRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_FIND_DL_ENTRY,
      .sqlstate              = "HY000",
      .str_error             = "Can't find symbol",
      .str_user_error        = "Can't find symbol %.*s in library",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4296, Can't find symbol",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4296, Can't find symbol %.*s in library",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4296, Can't find symbol",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4296, Can't find symbol %.*s in library"
};
static const _error _error_OB_OBJECT_NAME_EXIST = {
      .error_name            = "OB_OBJECT_NAME_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "name is already used by an existing object",
      .str_user_error        = "name is already used by an existing object",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4297, name is already used by an existing object",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4297, name is already used by an existing object",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4297, name is already used by an existing object",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4297, name is already used by an existing object"
};
static const _error _error_OB_OBJECT_NAME_NOT_EXIST = {
      .error_name            = "OB_OBJECT_NAME_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4298,
      .sqlstate              = "HY000",
      .str_error             = "object does not exist",
      .str_user_error        = "%s does not exist",
      .oracle_errno          = 2289,
      .oracle_str_error      = "ORA-02289: object does not exist",
      .oracle_str_user_error = "ORA-02289: %s does not exist",
      .ob_str_error          = "OBE-02289: object does not exist",
      .ob_str_user_error     = "OBE-02289: %s does not exist"
};
static const _error _error_OB_ERR_DUP_ARGUMENT = {
      .error_name            = "OB_ERR_DUP_ARGUMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DUP_ARGUMENT,
      .sqlstate              = "HY000",
      .str_error             = "Option used twice in statement",
      .str_user_error        = "Option '%s' used twice in statement",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4299, Option used twice in statement",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4299, Option '%s' used twice in statement",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4299, Option used twice in statement",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4299, Option '%s' used twice in statement"
};
static const _error _error_OB_ERR_INVALID_SEQUENCE_NAME = {
      .error_name            = "OB_ERR_INVALID_SEQUENCE_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid sequence name",
      .str_user_error        = "invalid sequence name",
      .oracle_errno          = 2277,
      .oracle_str_error      = "ORA-02277: invalid sequence name",
      .oracle_str_user_error = "ORA-02277: invalid sequence name",
      .ob_str_error          = "OBE-02277: invalid sequence name",
      .ob_str_user_error     = "OBE-02277: invalid sequence name"
};
static const _error _error_OB_ERR_DUP_MAXVALUE_SPEC = {
      .error_name            = "OB_ERR_DUP_MAXVALUE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate MAXVALUE/NOMAXVALUE specifications",
      .str_user_error        = "duplicate MAXVALUE/NOMAXVALUE specifications",
      .oracle_errno          = 2278,
      .oracle_str_error      = "ORA-02278: duplicate MAXVALUE/NOMAXVALUE specifications",
      .oracle_str_user_error = "ORA-02278: duplicate MAXVALUE/NOMAXVALUE specifications",
      .ob_str_error          = "OBE-02278: duplicate MAXVALUE/NOMAXVALUE specifications",
      .ob_str_user_error     = "OBE-02278: duplicate MAXVALUE/NOMAXVALUE specifications"
};
static const _error _error_OB_ERR_DUP_MINVALUE_SPEC = {
      .error_name            = "OB_ERR_DUP_MINVALUE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate MINVALUE/NOMINVALUE specifications",
      .str_user_error        = "duplicate MINVALUE/NOMINVALUE specifications",
      .oracle_errno          = 2279,
      .oracle_str_error      = "ORA-02279: duplicate MINVALUE/NOMINVALUE specifications",
      .oracle_str_user_error = "ORA-02279: duplicate MINVALUE/NOMINVALUE specifications",
      .ob_str_error          = "OBE-02279: duplicate MINVALUE/NOMINVALUE specifications",
      .ob_str_user_error     = "OBE-02279: duplicate MINVALUE/NOMINVALUE specifications"
};
static const _error _error_OB_ERR_DUP_CYCLE_SPEC = {
      .error_name            = "OB_ERR_DUP_CYCLE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate CYCLE/NOCYCLE specifications",
      .str_user_error        = "duplicate CYCLE/NOCYCLE specifications",
      .oracle_errno          = 2280,
      .oracle_str_error      = "ORA-02280: duplicate CYCLE/NOCYCLE specifications",
      .oracle_str_user_error = "ORA-02280: duplicate CYCLE/NOCYCLE specifications",
      .ob_str_error          = "OBE-02280: duplicate CYCLE/NOCYCLE specifications",
      .ob_str_user_error     = "OBE-02280: duplicate CYCLE/NOCYCLE specifications"
};
static const _error _error_OB_ERR_DUP_CACHE_SPEC = {
      .error_name            = "OB_ERR_DUP_CACHE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate CACHE/NOCACHE specifications",
      .str_user_error        = "duplicate CACHE/NOCACHE specifications",
      .oracle_errno          = 2281,
      .oracle_str_error      = "ORA-02281: duplicate CACHE/NOCACHE specifications",
      .oracle_str_user_error = "ORA-02281: duplicate CACHE/NOCACHE specifications",
      .ob_str_error          = "OBE-02281: duplicate CACHE/NOCACHE specifications",
      .ob_str_user_error     = "OBE-02281: duplicate CACHE/NOCACHE specifications"
};
static const _error _error_OB_ERR_DUP_ORDER_SPEC = {
      .error_name            = "OB_ERR_DUP_ORDER_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate ORDER/NOORDER specifications",
      .str_user_error        = "duplicate ORDER/NOORDER specifications",
      .oracle_errno          = 2282,
      .oracle_str_error      = "ORA-02282: duplicate ORDER/NOORDER specifications",
      .oracle_str_user_error = "ORA-02282: duplicate ORDER/NOORDER specifications",
      .ob_str_error          = "OBE-02282: duplicate ORDER/NOORDER specifications",
      .ob_str_user_error     = "OBE-02282: duplicate ORDER/NOORDER specifications"
};
static const _error _error_OB_ERR_CONFL_MAXVALUE_SPEC = {
      .error_name            = "OB_ERR_CONFL_MAXVALUE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "conflicting MAXVALUE/NOMAXVALUE specifications",
      .str_user_error        = "conflicting MAXVALUE/NOMAXVALUE specifications",
      .oracle_errno          = 2278,
      .oracle_str_error      = "ORA-02278: conflicting MAXVALUE/NOMAXVALUE specifications",
      .oracle_str_user_error = "ORA-02278: conflicting MAXVALUE/NOMAXVALUE specifications",
      .ob_str_error          = "OBE-02278: conflicting MAXVALUE/NOMAXVALUE specifications",
      .ob_str_user_error     = "OBE-02278: conflicting MAXVALUE/NOMAXVALUE specifications"
};
static const _error _error_OB_ERR_CONFL_MINVALUE_SPEC = {
      .error_name            = "OB_ERR_CONFL_MINVALUE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "conflicting MINVALUE/NOMINVALUE specifications",
      .str_user_error        = "conflicting MINVALUE/NOMINVALUE specifications",
      .oracle_errno          = 2279,
      .oracle_str_error      = "ORA-02279: conflicting MINVALUE/NOMINVALUE specifications",
      .oracle_str_user_error = "ORA-02279: conflicting MINVALUE/NOMINVALUE specifications",
      .ob_str_error          = "OBE-02279: conflicting MINVALUE/NOMINVALUE specifications",
      .ob_str_user_error     = "OBE-02279: conflicting MINVALUE/NOMINVALUE specifications"
};
static const _error _error_OB_ERR_CONFL_CYCLE_SPEC = {
      .error_name            = "OB_ERR_CONFL_CYCLE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "conflicting CYCLE/NOCYCLE specifications",
      .str_user_error        = "conflicting CYCLE/NOCYCLE specifications",
      .oracle_errno          = 2280,
      .oracle_str_error      = "ORA-02280: conflicting CYCLE/NOCYCLE specifications",
      .oracle_str_user_error = "ORA-02280: conflicting CYCLE/NOCYCLE specifications",
      .ob_str_error          = "OBE-02280: conflicting CYCLE/NOCYCLE specifications",
      .ob_str_user_error     = "OBE-02280: conflicting CYCLE/NOCYCLE specifications"
};
static const _error _error_OB_ERR_CONFL_CACHE_SPEC = {
      .error_name            = "OB_ERR_CONFL_CACHE_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "conflicting CACHE/NOCACHE specifications",
      .str_user_error        = "conflicting CACHE/NOCACHE specifications",
      .oracle_errno          = 2281,
      .oracle_str_error      = "ORA-02281: conflicting CACHE/NOCACHE specifications",
      .oracle_str_user_error = "ORA-02281: conflicting CACHE/NOCACHE specifications",
      .ob_str_error          = "OBE-02281: conflicting CACHE/NOCACHE specifications",
      .ob_str_user_error     = "OBE-02281: conflicting CACHE/NOCACHE specifications"
};
static const _error _error_OB_ERR_CONFL_ORDER_SPEC = {
      .error_name            = "OB_ERR_CONFL_ORDER_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "conflicting ORDER/NOORDER specifications",
      .str_user_error        = "conflicting ORDER/NOORDER specifications",
      .oracle_errno          = 2282,
      .oracle_str_error      = "ORA-02282: conflicting ORDER/NOORDER specifications",
      .oracle_str_user_error = "ORA-02282: conflicting ORDER/NOORDER specifications",
      .ob_str_error          = "OBE-02282: conflicting ORDER/NOORDER specifications",
      .ob_str_user_error     = "OBE-02282: conflicting ORDER/NOORDER specifications"
};
static const _error _error_OB_ERR_ALTER_START_SEQ_NUMBER_NOT_ALLOWED = {
      .error_name            = "OB_ERR_ALTER_START_SEQ_NUMBER_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cannot alter starting sequence number",
      .str_user_error        = "cannot alter starting sequence number",
      .oracle_errno          = 2283,
      .oracle_str_error      = "ORA-02283: cannot alter starting sequence number",
      .oracle_str_user_error = "ORA-02283: cannot alter starting sequence number",
      .ob_str_error          = "OBE-02283: cannot alter starting sequence number",
      .ob_str_user_error     = "OBE-02283: cannot alter starting sequence number"
};
static const _error _error_OB_ERR_DUP_INCREMENT_BY_SPEC = {
      .error_name            = "OB_ERR_DUP_INCREMENT_BY_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate INCREMENT BY specifications",
      .str_user_error        = "duplicate INCREMENT BY specifications",
      .oracle_errno          = 2284,
      .oracle_str_error      = "ORA-02284: duplicate INCREMENT BY specifications",
      .oracle_str_user_error = "ORA-02284: duplicate INCREMENT BY specifications",
      .ob_str_error          = "OBE-02284: duplicate INCREMENT BY specifications",
      .ob_str_user_error     = "OBE-02284: duplicate INCREMENT BY specifications"
};
static const _error _error_OB_ERR_DUP_START_WITH_SPEC = {
      .error_name            = "OB_ERR_DUP_START_WITH_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate START WITH specifications",
      .str_user_error        = "duplicate START WITH specifications",
      .oracle_errno          = 2285,
      .oracle_str_error      = "ORA-02285: duplicate START WITH specifications",
      .oracle_str_user_error = "ORA-02285: duplicate START WITH specifications",
      .ob_str_error          = "OBE-02285: duplicate START WITH specifications",
      .ob_str_user_error     = "OBE-02285: duplicate START WITH specifications"
};
static const _error _error_OB_ERR_REQUIRE_ALTER_SEQ_OPTION = {
      .error_name            = "OB_ERR_REQUIRE_ALTER_SEQ_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "no options specified for ALTER SEQUENCE",
      .str_user_error        = "no options specified for ALTER SEQUENCE",
      .oracle_errno          = 2286,
      .oracle_str_error      = "ORA-02286: no options specified for ALTER SEQUENCE",
      .oracle_str_user_error = "ORA-02286: no options specified for ALTER SEQUENCE",
      .ob_str_error          = "OBE-02286: no options specified for ALTER SEQUENCE",
      .ob_str_user_error     = "OBE-02286: no options specified for ALTER SEQUENCE"
};
static const _error _error_OB_ERR_SEQ_NOT_ALLOWED_HERE = {
      .error_name            = "OB_ERR_SEQ_NOT_ALLOWED_HERE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sequence number not allowed here",
      .str_user_error        = "sequence number not allowed here",
      .oracle_errno          = 2287,
      .oracle_str_error      = "ORA-02287: sequence number not allowed here",
      .oracle_str_user_error = "ORA-02287: sequence number not allowed here",
      .ob_str_error          = "OBE-02287: sequence number not allowed here",
      .ob_str_user_error     = "OBE-02287: sequence number not allowed here"
};
static const _error _error_OB_ERR_SEQ_NOT_EXIST = {
      .error_name            = "OB_ERR_SEQ_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sequence does not exist",
      .str_user_error        = "sequence does not exist",
      .oracle_errno          = 2289,
      .oracle_str_error      = "ORA-02289: sequence does not exist",
      .oracle_str_user_error = "ORA-02289: sequence does not exist",
      .ob_str_error          = "OBE-02289: sequence does not exist",
      .ob_str_user_error     = "OBE-02289: sequence does not exist"
};
static const _error _error_OB_ERR_SEQ_OPTION_MUST_BE_INTEGER = {
      .error_name            = "OB_ERR_SEQ_OPTION_MUST_BE_INTEGER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sequence parameter must be an integer",
      .str_user_error        = "sequence parameter %s must be an integer",
      .oracle_errno          = 4001,
      .oracle_str_error      = "ORA-04001: sequence parameter must be an integer",
      .oracle_str_user_error = "ORA-04001: sequence parameter %s must be an integer",
      .ob_str_error          = "OBE-04001: sequence parameter must be an integer",
      .ob_str_user_error     = "OBE-04001: sequence parameter %s must be an integer"
};
static const _error _error_OB_ERR_SEQ_INCREMENT_CAN_NOT_BE_ZERO = {
      .error_name            = "OB_ERR_SEQ_INCREMENT_CAN_NOT_BE_ZERO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "INCREMENT must be a nonzero integer",
      .str_user_error        = "INCREMENT must be a nonzero integer",
      .oracle_errno          = 4002,
      .oracle_str_error      = "ORA-04002: INCREMENT must be a nonzero integer",
      .oracle_str_user_error = "ORA-04002: INCREMENT must be a nonzero integer",
      .ob_str_error          = "OBE-04002: INCREMENT must be a nonzero integer",
      .ob_str_user_error     = "OBE-04002: INCREMENT must be a nonzero integer"
};
static const _error _error_OB_ERR_SEQ_OPTION_EXCEED_RANGE = {
      .error_name            = "OB_ERR_SEQ_OPTION_EXCEED_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sequence parameter exceeds maximum size allowed",
      .str_user_error        = "sequence parameter exceeds maximum size allowed",
      .oracle_errno          = 4003,
      .oracle_str_error      = "ORA-04003: sequence parameter exceeds maximum size allowed",
      .oracle_str_user_error = "ORA-04003: sequence parameter exceeds maximum size allowed",
      .ob_str_error          = "OBE-04003: sequence parameter exceeds maximum size allowed",
      .ob_str_user_error     = "OBE-04003: sequence parameter exceeds maximum size allowed"
};
static const _error _error_OB_ERR_MINVALUE_LARGER_THAN_MAXVALUE = {
      .error_name            = "OB_ERR_MINVALUE_LARGER_THAN_MAXVALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "MINVALUE must be less than MAXVALUE",
      .str_user_error        = "MINVALUE must be less than MAXVALUE",
      .oracle_errno          = 4004,
      .oracle_str_error      = "ORA-04004: MINVALUE must be less than MAXVALUE",
      .oracle_str_user_error = "ORA-04004: MINVALUE must be less than MAXVALUE",
      .ob_str_error          = "OBE-04004: MINVALUE must be less than MAXVALUE",
      .ob_str_user_error     = "OBE-04004: MINVALUE must be less than MAXVALUE"
};
static const _error _error_OB_ERR_SEQ_INCREMENT_TOO_LARGE = {
      .error_name            = "OB_ERR_SEQ_INCREMENT_TOO_LARGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "INCREMENT must be less than MAXVALUE minus MINVALUE",
      .str_user_error        = "INCREMENT must be less than MAXVALUE minus MINVALUE",
      .oracle_errno          = 4005,
      .oracle_str_error      = "ORA-04005: INCREMENT must be less than MAXVALUE minus MINVALUE",
      .oracle_str_user_error = "ORA-04005: INCREMENT must be less than MAXVALUE minus MINVALUE",
      .ob_str_error          = "OBE-04005: INCREMENT must be less than MAXVALUE minus MINVALUE",
      .ob_str_user_error     = "OBE-04005: INCREMENT must be less than MAXVALUE minus MINVALUE"
};
static const _error _error_OB_ERR_START_WITH_LESS_THAN_MINVALUE = {
      .error_name            = "OB_ERR_START_WITH_LESS_THAN_MINVALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "START WITH cannot be less than MINVALUE",
      .str_user_error        = "START WITH cannot be less than MINVALUE",
      .oracle_errno          = 4006,
      .oracle_str_error      = "ORA-04006: START WITH cannot be less than MINVALUE",
      .oracle_str_user_error = "ORA-04006: START WITH cannot be less than MINVALUE",
      .ob_str_error          = "OBE-04006: START WITH cannot be less than MINVALUE",
      .ob_str_user_error     = "OBE-04006: START WITH cannot be less than MINVALUE"
};
static const _error _error_OB_ERR_MINVALUE_EXCEED_CURRVAL = {
      .error_name            = "OB_ERR_MINVALUE_EXCEED_CURRVAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "MINVALUE cannot be made to exceed the current value",
      .str_user_error        = "MINVALUE cannot be made to exceed the current value",
      .oracle_errno          = 4007,
      .oracle_str_error      = "ORA-04007: MINVALUE cannot be made to exceed the current value",
      .oracle_str_user_error = "ORA-04007: MINVALUE cannot be made to exceed the current value",
      .ob_str_error          = "OBE-04007: MINVALUE cannot be made to exceed the current value",
      .ob_str_user_error     = "OBE-04007: MINVALUE cannot be made to exceed the current value"
};
static const _error _error_OB_ERR_START_WITH_EXCEED_MAXVALUE = {
      .error_name            = "OB_ERR_START_WITH_EXCEED_MAXVALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "START WITH cannot be more than MAXVALUE",
      .str_user_error        = "START WITH cannot be more than MAXVALUE",
      .oracle_errno          = 4008,
      .oracle_str_error      = "ORA-04008: START WITH cannot be more than MAXVALUE",
      .oracle_str_user_error = "ORA-04008: START WITH cannot be more than MAXVALUE",
      .ob_str_error          = "OBE-04008: START WITH cannot be more than MAXVALUE",
      .ob_str_user_error     = "OBE-04008: START WITH cannot be more than MAXVALUE"
};
static const _error _error_OB_ERR_MAXVALUE_EXCEED_CURRVAL = {
      .error_name            = "OB_ERR_MAXVALUE_EXCEED_CURRVAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "MAXVALUE cannot be made to be less than the current value",
      .str_user_error        = "MAXVALUE cannot be made to be less than the current value",
      .oracle_errno          = 4009,
      .oracle_str_error      = "ORA-04009: MAXVALUE cannot be made to be less than the current value",
      .oracle_str_user_error = "ORA-04009: MAXVALUE cannot be made to be less than the current value",
      .ob_str_error          = "OBE-04009: MAXVALUE cannot be made to be less than the current value",
      .ob_str_user_error     = "OBE-04009: MAXVALUE cannot be made to be less than the current value"
};
static const _error _error_OB_ERR_SEQ_CACHE_TOO_SMALL = {
      .error_name            = "OB_ERR_SEQ_CACHE_TOO_SMALL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the number of values to CACHE must be greater than 1",
      .str_user_error        = "the number of values to CACHE must be greater than 1",
      .oracle_errno          = 4010,
      .oracle_str_error      = "ORA-04010: the number of values to CACHE must be greater than 1",
      .oracle_str_user_error = "ORA-04010: the number of values to CACHE must be greater than 1",
      .ob_str_error          = "OBE-04010: the number of values to CACHE must be greater than 1",
      .ob_str_user_error     = "OBE-04010: the number of values to CACHE must be greater than 1"
};
static const _error _error_OB_ERR_SEQ_OPTION_OUT_OF_RANGE = {
      .error_name            = "OB_ERR_SEQ_OPTION_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sequence option value out of range",
      .str_user_error        = "sequence option value out of range",
      .oracle_errno          = 4011,
      .oracle_str_error      = "ORA-04011: sequence option value out of range",
      .oracle_str_user_error = "ORA-04011: sequence option value out of range",
      .ob_str_error          = "OBE-04011: sequence option value out of range",
      .ob_str_user_error     = "OBE-04011: sequence option value out of range"
};
static const _error _error_OB_ERR_SEQ_CACHE_TOO_LARGE = {
      .error_name            = "OB_ERR_SEQ_CACHE_TOO_LARGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "number to CACHE must be less than one cycle",
      .str_user_error        = "number to CACHE must be less than one cycle",
      .oracle_errno          = 4013,
      .oracle_str_error      = "ORA-04013: number to CACHE must be less than one cycle",
      .oracle_str_user_error = "ORA-04013: number to CACHE must be less than one cycle",
      .ob_str_error          = "OBE-04013: number to CACHE must be less than one cycle",
      .ob_str_user_error     = "OBE-04013: number to CACHE must be less than one cycle"
};
static const _error _error_OB_ERR_SEQ_REQUIRE_MINVALUE = {
      .error_name            = "OB_ERR_SEQ_REQUIRE_MINVALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "descending sequences that CYCLE must specify MINVALUE",
      .str_user_error        = "descending sequences that CYCLE must specify MINVALUE",
      .oracle_errno          = 4014,
      .oracle_str_error      = "ORA-04014: descending sequences that CYCLE must specify MINVALUE",
      .oracle_str_user_error = "ORA-04014: descending sequences that CYCLE must specify MINVALUE",
      .ob_str_error          = "OBE-04014: descending sequences that CYCLE must specify MINVALUE",
      .ob_str_user_error     = "OBE-04014: descending sequences that CYCLE must specify MINVALUE"
};
static const _error _error_OB_ERR_SEQ_REQUIRE_MAXVALUE = {
      .error_name            = "OB_ERR_SEQ_REQUIRE_MAXVALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ascending sequences that CYCLE must specify MAXVALUE",
      .str_user_error        = "ascending sequences that CYCLE must specify MAXVALUE",
      .oracle_errno          = 4015,
      .oracle_str_error      = "ORA-04015: ascending sequences that CYCLE must specify MAXVALUE",
      .oracle_str_user_error = "ORA-04015: ascending sequences that CYCLE must specify MAXVALUE",
      .ob_str_error          = "OBE-04015: ascending sequences that CYCLE must specify MAXVALUE",
      .ob_str_user_error     = "OBE-04015: ascending sequences that CYCLE must specify MAXVALUE"
};
static const _error _error_OB_ERR_SEQ_NO_LONGER_EXIST = {
      .error_name            = "OB_ERR_SEQ_NO_LONGER_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sequence no longer exists",
      .str_user_error        = "sequence %s no longer exists",
      .oracle_errno          = 4015,
      .oracle_str_error      = "ORA-04015: sequence no longer exists",
      .oracle_str_user_error = "ORA-04015: sequence %s no longer exists",
      .ob_str_error          = "OBE-04015: sequence no longer exists",
      .ob_str_user_error     = "OBE-04015: sequence %s no longer exists"
};
static const _error _error_OB_ERR_SEQ_VALUE_EXCEED_LIMIT = {
      .error_name            = "OB_ERR_SEQ_VALUE_EXCEED_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sequence exceeds limit and cannot be instantiated",
      .str_user_error        = "sequence exceeds %s and cannot be instantiated",
      .oracle_errno          = 8004,
      .oracle_str_error      = "ORA-08004: sequence exceeds limit and cannot be instantiated",
      .oracle_str_user_error = "ORA-08004: sequence exceeds %s and cannot be instantiated",
      .ob_str_error          = "OBE-08004: sequence exceeds limit and cannot be instantiated",
      .ob_str_user_error     = "OBE-08004: sequence exceeds %s and cannot be instantiated"
};
static const _error _error_OB_ERR_DIVISOR_IS_ZERO = {
      .error_name            = "OB_ERR_DIVISOR_IS_ZERO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "divisor is equal to zero",
      .str_user_error        = "divisor is equal to zero",
      .oracle_errno          = 1476,
      .oracle_str_error      = "ORA-01476: divisor is equal to zero",
      .oracle_str_user_error = "ORA-01476: divisor is equal to zero",
      .ob_str_error          = "OBE-01476: divisor is equal to zero",
      .ob_str_user_error     = "OBE-01476: divisor is equal to zero"
};
static const _error _error_OB_ERR_AES_DECRYPT = {
      .error_name            = "OB_ERR_AES_DECRYPT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to decrypt data",
      .str_user_error        = "fail to decrypt data",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4334, fail to decrypt data",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4334, fail to decrypt data",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4334, fail to decrypt data",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4334, fail to decrypt data"
};
static const _error _error_OB_ERR_AES_ENCRYPT = {
      .error_name            = "OB_ERR_AES_ENCRYPT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to encrypt data",
      .str_user_error        = "fail to encrypt data",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4335, fail to encrypt data",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4335, fail to encrypt data",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4335, fail to encrypt data",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4335, fail to encrypt data"
};
static const _error _error_OB_ERR_AES_IV_LENGTH = {
      .error_name            = "OB_ERR_AES_IV_LENGTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_AES_INVALID_IV,
      .sqlstate              = "HY000",
      .str_error             = "The initialization vector supplied is too short. Must be at least 16 bytes long",
      .str_user_error        = "The initialization vector supplied is too short. Must be at least 16 bytes long",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4336, The initialization vector supplied is too short. Must be at least 16 bytes long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4336, The initialization vector supplied is too short. Must be at least 16 bytes long",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4336, The initialization vector supplied is too short. Must be at least 16 bytes long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4336, The initialization vector supplied is too short. Must be at least 16 bytes long"
};
static const _error _error_OB_STORE_DIR_ERROR = {
      .error_name            = "OB_STORE_DIR_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "store directory structure error",
      .str_user_error        = "store directory structure error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4337, store directory structure error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4337, store directory structure error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4337, store directory structure error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4337, store directory structure error"
};
static const _error _error_OB_OPEN_TWICE = {
      .error_name            = "OB_OPEN_TWICE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "open twice",
      .str_user_error        = "open twice",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4338, open twice",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4338, open twice",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4338, open twice",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4338, open twice"
};
static const _error _error_OB_RAID_SUPER_BLOCK_NOT_MACTH = {
      .error_name            = "OB_RAID_SUPER_BLOCK_NOT_MACTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "raid super block not match",
      .str_user_error        = "raid super block not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4339, raid super block not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4339, raid super block not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4339, raid super block not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4339, raid super block not match"
};
static const _error _error_OB_NOT_OPEN = {
      .error_name            = "OB_NOT_OPEN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "not opened",
      .str_user_error        = "not opened",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4340, not opened",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4340, not opened",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4340, not opened",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4340, not opened"
};
static const _error _error_OB_NOT_IN_SERVICE = {
      .error_name            = "OB_NOT_IN_SERVICE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "target module is not in service",
      .str_user_error        = "target module is not in service",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4341, target module is not in service",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4341, target module is not in service",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4341, target module is not in service",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4341, target module is not in service"
};
static const _error _error_OB_RAID_DISK_NOT_NORMAL = {
      .error_name            = "OB_RAID_DISK_NOT_NORMAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "raid disk not in normal status",
      .str_user_error        = "raid disk not in normal status",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4342, raid disk not in normal status",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4342, raid disk not in normal status",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4342, raid disk not in normal status",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4342, raid disk not in normal status"
};
static const _error _error_OB_TENANT_SCHEMA_NOT_FULL = {
      .error_name            = "OB_TENANT_SCHEMA_NOT_FULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tenant schema is not full",
      .str_user_error        = "tenant schema is not full",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4343, tenant schema is not full",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4343, tenant schema is not full",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4343, tenant schema is not full",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4343, tenant schema is not full"
};
static const _error _error_OB_INVALID_QUERY_TIMESTAMP = {
      .error_name            = "OB_INVALID_QUERY_TIMESTAMP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid timestamp",
      .str_user_error        = "invalid timestamp",
      .oracle_errno          = 8186,
      .oracle_str_error      = "ORA-08186: invalid timestamp",
      .oracle_str_user_error = "ORA-08186: invalid timestamp",
      .ob_str_error          = "OBE-08186: invalid timestamp",
      .ob_str_user_error     = "OBE-08186: invalid timestamp"
};
static const _error _error_OB_DIR_NOT_EMPTY = {
      .error_name            = "OB_DIR_NOT_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "dir not empty",
      .str_user_error        = "dir not empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4345, dir not empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4345, dir not empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4345, dir not empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4345, dir not empty"
};
static const _error _error_OB_SCHEMA_NOT_UPTODATE = {
      .error_name            = "OB_SCHEMA_NOT_UPTODATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "schema is not up to date for read",
      .str_user_error        = "schema is not up to date for read",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4346, schema is not up to date for read",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4346, schema is not up to date for read",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4346, schema is not up to date for read",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4346, schema is not up to date for read"
};
static const _error _error_OB_ROLE_NOT_EXIST = {
      .error_name            = "OB_ROLE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "role does not exist",
      .str_user_error        = "role '%.*s' does not exist",
      .oracle_errno          = 1919,
      .oracle_str_error      = "ORA-01919: role does not exist",
      .oracle_str_user_error = "ORA-01919: role '%.*s' does not exist",
      .ob_str_error          = "OBE-01919: role does not exist",
      .ob_str_user_error     = "OBE-01919: role '%.*s' does not exist"
};
static const _error _error_OB_ROLE_EXIST = {
      .error_name            = "OB_ROLE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "role exists",
      .str_user_error        = "role '%.*s' exists",
      .oracle_errno          = 1921,
      .oracle_str_error      = "ORA-01921: role name conflicts with another user or role name",
      .oracle_str_user_error = "ORA-01921: role name '%.*s' conflicts with another user or role name",
      .ob_str_error          = "OBE-01921: role name conflicts with another user or role name",
      .ob_str_user_error     = "OBE-01921: role name '%.*s' conflicts with another user or role name"
};
static const _error _error_OB_PRIV_DUP = {
      .error_name            = "OB_PRIV_DUP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate privilege listed",
      .str_user_error        = "duplicate privilege listed",
      .oracle_errno          = 1711,
      .oracle_str_error      = "ORA-01711: duplicate privilege listed",
      .oracle_str_user_error = "ORA-01711: duplicate privilege listed",
      .ob_str_error          = "OBE-01711: duplicate privilege listed",
      .ob_str_user_error     = "OBE-01711: duplicate privilege listed"
};
static const _error _error_OB_KEYSTORE_EXIST = {
      .error_name            = "OB_KEYSTORE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the keystore already exists and each tenant can only have at most one",
      .str_user_error        = "the keystore already exists and each tenant can only have at most one",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4350, the keystore already exists and each tenant can only have at most one",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4350, the keystore already exists and each tenant can only have at most one",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4350, the keystore already exists and each tenant can only have at most one",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4350, the keystore already exists and each tenant can only have at most one"
};
static const _error _error_OB_KEYSTORE_NOT_EXIST = {
      .error_name            = "OB_KEYSTORE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the keystore is not exist",
      .str_user_error        = "the keystore is not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4351, the keystore is not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4351, the keystore is not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4351, the keystore is not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4351, the keystore is not exist"
};
static const _error _error_OB_KEYSTORE_WRONG_PASSWORD = {
      .error_name            = "OB_KEYSTORE_WRONG_PASSWORD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the password is wrong for keystore",
      .str_user_error        = "the password is wrong for keystore",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4352, the password is wrong for keystore",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4352, the password is wrong for keystore",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4352, the password is wrong for keystore",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4352, the password is wrong for keystore"
};
static const _error _error_OB_TABLESPACE_EXIST = {
      .error_name            = "OB_TABLESPACE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tablespace already exists",
      .str_user_error        = "tablespace '%.*s' already exists",
      .oracle_errno          = 1543,
      .oracle_str_error      = "ORA-01543: tablespace already exists",
      .oracle_str_user_error = "ORA-01543: tablespace '%.*s' already exists",
      .ob_str_error          = "OBE-01543: tablespace already exists",
      .ob_str_user_error     = "OBE-01543: tablespace '%.*s' already exists"
};
static const _error _error_OB_TABLESPACE_NOT_EXIST = {
      .error_name            = "OB_TABLESPACE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TABLESPACE_NOT_EXIST,
      .sqlstate              = "HY000",
      .str_error             = "Tablespace does not exist",
      .str_user_error        = "Tablespace '%.*s' does not exist",
      .oracle_errno          = 959,
      .oracle_str_error      = "ORA-00959: Tablespace does not exist",
      .oracle_str_user_error = "ORA-00959: Tablespace '%.*s' does not exist",
      .ob_str_error          = "OBE-00959: Tablespace does not exist",
      .ob_str_user_error     = "OBE-00959: Tablespace '%.*s' does not exist"
};
static const _error _error_OB_TABLESPACE_DELETE_NOT_EMPTY = {
      .error_name            = "OB_TABLESPACE_DELETE_NOT_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cannot delete a tablespace which is not empty",
      .str_user_error        = "cannot delete a tablespace which is not empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4355, cannot delete a tablespace which is not empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4355, cannot delete a tablespace which is not empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4355, cannot delete a tablespace which is not empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4355, cannot delete a tablespace which is not empty"
};
static const _error _error_OB_FLOAT_PRECISION_OUT_RANGE = {
      .error_name            = "OB_FLOAT_PRECISION_OUT_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "floating point precision is out of range (1 to 126)",
      .str_user_error        = "floating point precision is out of range (1 to 126)",
      .oracle_errno          = 1724,
      .oracle_str_error      = "ORA-01724: floating point precision is out of range (1 to 126)",
      .oracle_str_user_error = "ORA-01724: floating point precision is out of range (1 to 126)",
      .ob_str_error          = "OBE-01724: floating point precision is out of range (1 to 126)",
      .ob_str_user_error     = "OBE-01724: floating point precision is out of range (1 to 126)"
};
static const _error _error_OB_NUMERIC_PRECISION_OUT_RANGE = {
      .error_name            = "OB_NUMERIC_PRECISION_OUT_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "numeric precision specifier is out of range (1 to 38)",
      .str_user_error        = "numeric precision specifier is out of range (1 to 38)",
      .oracle_errno          = 1727,
      .oracle_str_error      = "ORA-01727: numeric precision specifier is out of range (1 to 38)",
      .oracle_str_user_error = "ORA-01727: numeric precision specifier is out of range (1 to 38)",
      .ob_str_error          = "OBE-01727: numeric precision specifier is out of range (1 to 38)",
      .ob_str_user_error     = "OBE-01727: numeric precision specifier is out of range (1 to 38)"
};
static const _error _error_OB_NUMERIC_SCALE_OUT_RANGE = {
      .error_name            = "OB_NUMERIC_SCALE_OUT_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "numeric scale specifier is out of range (-84 to 127)",
      .str_user_error        = "numeric scale specifier is out of range (-84 to 127)",
      .oracle_errno          = 1728,
      .oracle_str_error      = "ORA-01728: numeric scale specifier is out of range (-84 to 127)",
      .oracle_str_user_error = "ORA-01728: numeric scale specifier is out of range (-84 to 127)",
      .ob_str_error          = "OBE-01728: numeric scale specifier is out of range (-84 to 127)",
      .ob_str_user_error     = "OBE-01728: numeric scale specifier is out of range (-84 to 127)"
};
static const _error _error_OB_KEYSTORE_NOT_OPEN = {
      .error_name            = "OB_KEYSTORE_NOT_OPEN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the keystore is not open",
      .str_user_error        = "the keystore is not open",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4359, the keystore is not open",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4359, the keystore is not open",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4359, the keystore is not open",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4359, the keystore is not open"
};
static const _error _error_OB_KEYSTORE_OPEN_NO_MASTER_KEY = {
      .error_name            = "OB_KEYSTORE_OPEN_NO_MASTER_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the keystore opened with dont have a master key",
      .str_user_error        = "the keystore opened with dont have a master key",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4360, the keystore opened with dont have a master key",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4360, the keystore opened with dont have a master key",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4360, the keystore opened with dont have a master key",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4360, the keystore opened with dont have a master key"
};
static const _error _error_OB_SLOG_REACH_MAX_CONCURRENCY = {
      .error_name            = "OB_SLOG_REACH_MAX_CONCURRENCY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "slog active transaction entries reach maximum",
      .str_user_error        = "slog active transaction entries reach maximum",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4361, slog active transaction entries reach maximum",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4361, slog active transaction entries reach maximum",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4361, slog active transaction entries reach maximum",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4361, slog active transaction entries reach maximum"
};
static const _error _error_OB_ERR_BY_ACCESS_OR_SESSION_CLAUSE_NOT_ALLOWED_FOR_NOAUDIT = {
      .error_name            = "OB_ERR_BY_ACCESS_OR_SESSION_CLAUSE_NOT_ALLOWED_FOR_NOAUDIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "BY ACCESS | SESSION clause not allowed for NOAUDIT",
      .str_user_error        = "BY ACCESS | SESSION clause not allowed for NOAUDIT",
      .oracle_errno          = 1718,
      .oracle_str_error      = "ORA-01718: BY ACCESS | SESSION clause not allowed for NOAUDIT",
      .oracle_str_user_error = "ORA-01718: BY ACCESS | SESSION clause not allowed for NOAUDIT",
      .ob_str_error          = "OBE-01718: BY ACCESS | SESSION clause not allowed for NOAUDIT",
      .ob_str_user_error     = "OBE-01718: BY ACCESS | SESSION clause not allowed for NOAUDIT"
};
static const _error _error_OB_ERR_AUDITING_THE_OBJECT_IS_NOT_SUPPORTED = {
      .error_name            = "OB_ERR_AUDITING_THE_OBJECT_IS_NOT_SUPPORTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "auditing the object is not supported",
      .str_user_error        = "auditing the object is not supported",
      .oracle_errno          = 1930,
      .oracle_str_error      = "ORA-01930: auditing the object is not supported",
      .oracle_str_user_error = "ORA-01930: auditing the object is not supported",
      .ob_str_error          = "OBE-01930: auditing the object is not supported",
      .ob_str_user_error     = "OBE-01930: auditing the object is not supported"
};
static const _error _error_OB_ERR_DDL_STATEMENT_CANNOT_BE_AUDITED_WITH_BY_SESSION_SPECIFIED = {
      .error_name            = "OB_ERR_DDL_STATEMENT_CANNOT_BE_AUDITED_WITH_BY_SESSION_SPECIFIED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "DDL statement cannot be audited with BY SESSION specified",
      .str_user_error        = "DDL statement cannot be audited with BY SESSION specified",
      .oracle_errno          = 32595,
      .oracle_str_error      = "ORA-32595: DDL statement cannot be audited with BY SESSION specified",
      .oracle_str_user_error = "ORA-32595: DDL statement cannot be audited with BY SESSION specified",
      .ob_str_error          = "OBE-32595: DDL statement cannot be audited with BY SESSION specified",
      .ob_str_user_error     = "OBE-32595: DDL statement cannot be audited with BY SESSION specified"
};
static const _error _error_OB_ERR_NOT_VALID_PASSWORD = {
      .error_name            = "OB_ERR_NOT_VALID_PASSWORD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NOT_VALID_PASSWORD,
      .sqlstate              = "HY000",
      .str_error             = "Your password does not satisfy the current policy requirements",
      .str_user_error        = "Your password does not satisfy the current policy requirements",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4365, Your password does not satisfy the current policy requirements",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4365, Your password does not satisfy the current policy requirements",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4365, Your password does not satisfy the current policy requirements",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4365, Your password does not satisfy the current policy requirements"
};
static const _error _error_OB_ERR_MUST_CHANGE_PASSWORD = {
      .error_name            = "OB_ERR_MUST_CHANGE_PASSWORD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_MUST_CHANGE_PASSWORD,
      .sqlstate              = "HY000",
      .str_error             = "You must reset your password using ALTER USER statement before executing this statement",
      .str_user_error        = "You must reset your password using ALTER USER statement before executing this statement",
      .oracle_errno          = 28001,
      .oracle_str_error      = "ORA-28001: the password has expired",
      .oracle_str_user_error = "ORA-28001: the password has expired",
      .ob_str_error          = "OBE-28001: the password has expired",
      .ob_str_user_error     = "OBE-28001: the password has expired"
};
static const _error _error_OB_OVERSIZE_NEED_RETRY = {
      .error_name            = "OB_OVERSIZE_NEED_RETRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_OVERSIZE_NEED_RETRY,
      .sqlstate              = "HY000",
      .str_error             = "The data more than 64M(rpc limit), split into smaller task and retry",
      .str_user_error        = "The data more than 64M(rpc limit), split into smaller task and retry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4367, The data more than 64M(rpc limit), split into smaller task and retry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4367, The data more than 64M(rpc limit), split into smaller task and retry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4367, The data more than 64M(rpc limit), split into smaller task and retry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4367, The data more than 64M(rpc limit), split into smaller task and retry"
};
static const _error _error_OB_OBCONFIG_CLUSTER_NOT_EXIST = {
      .error_name            = "OB_OBCONFIG_CLUSTER_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cluster not exists",
      .str_user_error        = "cluster not exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4368, cluster not exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4368, cluster not exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4368, cluster not exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4368, cluster not exists"
};
static const _error _error_OB_ERR_GET_MASTER_KEY = {
      .error_name            = "OB_ERR_GET_MASTER_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to get master key",
      .str_user_error        = "fail to get master key",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4369, fail to get master key",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4369, fail to get master key",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4369, fail to get master key",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4369, fail to get master key"
};
static const _error _error_OB_ERR_TDE_METHOD = {
      .error_name            = "OB_ERR_TDE_METHOD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tde_method parameter is invalid",
      .str_user_error        = "tde_method parameter is invalid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4370, tde_method parameter is invalid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4370, tde_method parameter is invalid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4370, tde_method parameter is invalid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4370, tde_method parameter is invalid"
};
static const _error _error_OB_KMS_SERVER_CONNECT_ERROR = {
      .error_name            = "OB_KMS_SERVER_CONNECT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "kms server connect failed, may be kms server is down",
      .str_user_error        = "kms server connect failed, may be kms server is down",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4371, kms server connect failed, may be kms server is down",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4371, kms server connect failed, may be kms server is down",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4371, kms server connect failed, may be kms server is down",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4371, kms server connect failed, may be kms server is down"
};
static const _error _error_OB_KMS_SERVER_IS_BUSY = {
      .error_name            = "OB_KMS_SERVER_IS_BUSY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "kms server is busy, try again",
      .str_user_error        = "kms server is busy, try again",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4372, kms server is busy, try again",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4372, kms server is busy, try again",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4372, kms server is busy, try again",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4372, kms server is busy, try again"
};
static const _error _error_OB_KMS_SERVER_UPDATE_KEY_CONFLICT = {
      .error_name            = "OB_KMS_SERVER_UPDATE_KEY_CONFLICT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "kms server update key conflict at the same time, please try again",
      .str_user_error        = "kms server update key conflict at the same time, please try again",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4373, kms server update key conflict at the same time, please try again",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4373, kms server update key conflict at the same time, please try again",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4373, kms server update key conflict at the same time, please try again",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4373, kms server update key conflict at the same time, please try again"
};
static const _error _error_OB_ERR_VALUE_LARGER_THAN_ALLOWED = {
      .error_name            = "OB_ERR_VALUE_LARGER_THAN_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "value larger than specified precision allowed for this column",
      .str_user_error        = "value larger than specified precision allowed for this column",
      .oracle_errno          = 1438,
      .oracle_str_error      = "ORA-01438: value larger than specified precision allowed for this column",
      .oracle_str_user_error = "ORA-01438: value larger than specified precision allowed for this column",
      .ob_str_error          = "OBE-01438: value larger than specified precision allowed for this column",
      .ob_str_user_error     = "OBE-01438: value larger than specified precision allowed for this column"
};
static const _error _error_OB_DISK_ERROR = {
      .error_name            = "OB_DISK_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "observer has disk error",
      .str_user_error        = "observer has disk error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4375, observer has disk error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4375, observer has disk error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4375, observer has disk error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4375, observer has disk error"
};
static const _error _error_OB_UNIMPLEMENTED_FEATURE = {
      .error_name            = "OB_UNIMPLEMENTED_FEATURE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unimplemented feature",
      .str_user_error        = "unimplemented feature",
      .oracle_errno          = 3001,
      .oracle_str_error      = "ORA-03001: unimplemented feature",
      .oracle_str_user_error = "ORA-03001: unimplemented feature",
      .ob_str_error          = "OBE-03001: unimplemented feature",
      .ob_str_user_error     = "OBE-03001: unimplemented feature"
};
static const _error _error_OB_ERR_DEFENSIVE_CHECK = {
      .error_name            = "OB_ERR_DEFENSIVE_CHECK",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fatal internal error",
      .str_user_error        = "fatal internal error in [%.*s]",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4377, fatal internal error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4377, fatal internal error in [%.*s]",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4377, fatal internal error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4377, fatal internal error in [%.*s]"
};
static const _error _error_OB_CLUSTER_NAME_HASH_CONFLICT = {
      .error_name            = "OB_CLUSTER_NAME_HASH_CONFLICT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cluster name conflict",
      .str_user_error        = "cluster name conflict",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4378, cluster name conflict",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4378, cluster name conflict",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4378, cluster name conflict",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4378, cluster name conflict"
};
static const _error _error_OB_HEAP_TABLE_EXAUSTED = {
      .error_name            = "OB_HEAP_TABLE_EXAUSTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "heap table has reached max row size, cannot insert anymore",
      .str_user_error        = "heap table has reached max row size, cannot insert anymore",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4379, heap table has reached max row size, cannot insert anymore",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4379, heap table has reached max row size, cannot insert anymore",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4379, heap table has reached max row size, cannot insert anymore",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4379, heap table has reached max row size, cannot insert anymore"
};
static const _error _error_OB_ERR_INDEX_KEY_NOT_FOUND = {
      .error_name            = "OB_ERR_INDEX_KEY_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "index key not found",
      .str_user_error        = "index key not found",
      .oracle_errno          = 8102,
      .oracle_str_error      = "ORA-08102: index key not found",
      .oracle_str_user_error = "ORA-08102: index key not found",
      .ob_str_error          = "OBE-08102: index key not found",
      .ob_str_user_error     = "OBE-08102: index key not found"
};
static const _error _error_OB_UNSUPPORTED_DEPRECATED_FEATURE = {
      .error_name            = "OB_UNSUPPORTED_DEPRECATED_FEATURE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not supported, deprecated %s feature",
      .str_user_error        = "Not supported, deprecated %s feature",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4381, Not supported, deprecated %s feature",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4381, Not supported, deprecated %s feature",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4381, Not supported, deprecated %s feature",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4381, Not supported, deprecated %s feature"
};
static const _error _error_OB_ERR_DUP_RESTART_SPEC = {
      .error_name            = "OB_ERR_DUP_RESTART_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate RESTART specified",
      .str_user_error        = "duplicate RESTART specified",
      .oracle_errno          = 64601,
      .oracle_str_error      = "ORA-64601: duplicate RESTART specified",
      .oracle_str_user_error = "ORA-64601: duplicate RESTART specified",
      .ob_str_error          = "OBE-64601: duplicate RESTART specified",
      .ob_str_user_error     = "OBE-64601: duplicate RESTART specified"
};
static const _error _error_OB_GTI_NOT_READY = {
      .error_name            = "OB_GTI_NOT_READY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "transaction id is not ready",
      .str_user_error        = "transaction id is not ready",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4383, transaction id is not ready",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4383, transaction id is not ready",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4383, transaction id is not ready",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4383, transaction id is not ready"
};
static const _error _error_OB_STACK_OVERFLOW = {
      .error_name            = "OB_STACK_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "stack overflow",
      .str_user_error        = "stack overflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4385, stack overflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4385, stack overflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4385, stack overflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4385, stack overflow"
};
static const _error _error_OB_NOT_ALLOW_REMOVING_LEADER = {
      .error_name            = "OB_NOT_ALLOW_REMOVING_LEADER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Do not allow removing leader",
      .str_user_error        = "Do not allow removing leader",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4386, Do not allow removing leader",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4386, Do not allow removing leader",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4386, Do not allow removing leader",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4386, Do not allow removing leader"
};
static const _error _error_OB_NEED_SWITCH_CONSUMER_GROUP = {
      .error_name            = "OB_NEED_SWITCH_CONSUMER_GROUP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 13937,
      .sqlstate              = "HY000",
      .str_error             = "Failed to switch resource group",
      .str_user_error        = "Failed to switch resource group",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4387, Failed to switch resource group",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4387, Failed to switch resource group",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4387, Failed to switch resource group",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4387, Failed to switch resource group"
};
static const _error _error_OB_UNEXPECT_INTERNAL_ERROR = {
      .error_name            = "OB_UNEXPECT_INTERNAL_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unexpected internal error happen, please checkout the internal errcode",
      .str_user_error        = "Unexpected internal error happen, please checkout the internal errcode",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4388, Unexpected internal error happen, please checkout the internal errcode",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4388, Unexpected internal error happen, please checkout the internal errcode",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4388, Unexpected internal error happen, please checkout the internal errcode",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4388, Unexpected internal error happen, please checkout the internal errcode"
};
static const _error _error_OB_ERR_TOO_MUCH_TIME = {
      .error_name            = "OB_ERR_TOO_MUCH_TIME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Processing time is too long",
      .str_user_error        = "Processing time is too long",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4389, Processing time is too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4389, Processing time is too long",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4389, Processing time is too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4389, Processing time is too long"
};
static const _error _error_OB_ERR_REMOTE_SCHEMA_NOT_FULL = {
      .error_name            = "OB_ERR_REMOTE_SCHEMA_NOT_FULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Schema of remote server is not refreshed yet",
      .str_user_error        = "Schema of remote server is not refreshed yet",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4390, Schema of remote server is not refreshed yet",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4390, Schema of remote server is not refreshed yet",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4390, Schema of remote server is not refreshed yet",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4390, Schema of remote server is not refreshed yet"
};
static const _error _error_OB_DDL_SSTABLE_RANGE_CROSS = {
      .error_name            = "OB_DDL_SSTABLE_RANGE_CROSS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ddl sstable version range cross",
      .str_user_error        = "ddl sstable version range cross",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4391, ddl sstable version range cross",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4391, ddl sstable version range cross",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4391, ddl sstable version range cross",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4391, ddl sstable version range cross"
};
static const _error _error_OB_DISK_HUNG = {
      .error_name            = "OB_DISK_HUNG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "disk is hung",
      .str_user_error        = "disk is hung",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4392, disk is hung",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4392, disk is hung",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4392, disk is hung",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4392, disk is hung"
};
static const _error _error_OB_ERR_OBSERVER_START = {
      .error_name            = "OB_ERR_OBSERVER_START",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "observer start process failure",
      .str_user_error        = "observer start process failure",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4393, observer start process failure",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4393, observer start process failure",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4393, observer start process failure",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4393, observer start process failure"
};
static const _error _error_OB_ERR_OBSERVER_STOP = {
      .error_name            = "OB_ERR_OBSERVER_STOP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "observer stop process failure",
      .str_user_error        = "observer stop process failure",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4394, observer stop process failure",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4394, observer stop process failure",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4394, observer stop process failure",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4394, observer stop process failure"
};
static const _error _error_OB_ERR_OBSERVICE_START = {
      .error_name            = "OB_ERR_OBSERVICE_START",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "observice start process has failure",
      .str_user_error        = "observice start process has failure",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4395, observice start process has failure",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4395, observice start process has failure",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4395, observice start process has failure",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4395, observice start process has failure"
};
static const _error _error_OB_ERR_THREAD_PANIC = {
      .error_name            = "OB_ERR_THREAD_PANIC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Worker thread panic, thread may be terminated or hung",
      .str_user_error        = "Worker thread panic, thread may be terminated or hung",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4396, Worker thread panic, thread may be terminated or hung",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4396, Worker thread panic, thread may be terminated or hung",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4396, Worker thread panic, thread may be terminated or hung",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4396, Worker thread panic, thread may be terminated or hung"
};
static const _error _error_OB_ENCODING_EST_SIZE_OVERFLOW = {
      .error_name            = "OB_ENCODING_EST_SIZE_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Encoding estimated size overflow",
      .str_user_error        = "Encoding estimated size overflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4397, Encoding estimated size overflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4397, Encoding estimated size overflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4397, Encoding estimated size overflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4397, Encoding estimated size overflow"
};
static const _error _error_OB_INVALID_SUB_PARTITION_TYPE = {
      .error_name            = "OB_INVALID_SUB_PARTITION_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 1500,
      .sqlstate              = "HY000",
      .str_error             = "It is only possible to mix RANGE/LIST partitioning with HASH/KEY partitioning for subpartitioning",
      .str_user_error        = "It is only possible to mix RANGE/LIST partitioning with HASH/KEY partitioning for subpartitioning",
      .oracle_errno          = 14020,
      .oracle_str_error      = "ORA-14020: this physical attribute may not be specified for a table partition",
      .oracle_str_user_error = "ORA-14020: this physical attribute may not be specified for a table partition",
      .ob_str_error          = "OBE-14020: this physical attribute may not be specified for a table partition",
      .ob_str_user_error     = "OBE-14020: this physical attribute may not be specified for a table partition"
};
static const _error _error_OB_ERR_UNEXPECTED_UNIT_STATUS = {
      .error_name            = "OB_ERR_UNEXPECTED_UNIT_STATUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unit status is not expected",
      .str_user_error        = "Unit status is not expected",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4399, Unit status is not expected",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4399, Unit status is not expected",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4399, Unit status is not expected",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4399, Unit status is not expected"
};
static const _error _error_OB_AUTOINC_CACHE_NOT_EQUAL = {
      .error_name            = "OB_AUTOINC_CACHE_NOT_EQUAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Autoinc cache's autoinc version is not equal to request's autoinc version",
      .str_user_error        = "Autoinc cache's autoinc version is not equal to request's autoinc version",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4400, Autoinc cache's autoinc version is not equal to request's autoinc version",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4400, Autoinc cache's autoinc version is not equal to request's autoinc version",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4400, Autoinc cache's autoinc version is not equal to request's autoinc version",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4400, Autoinc cache's autoinc version is not equal to request's autoinc version"
};
static const _error _error_OB_ERR_KILL_CLIENT_SESSION = {
      .error_name            = "OB_ERR_KILL_CLIENT_SESSION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4401,
      .sqlstate              = "HY000",
      .str_error             = "Client Session need be killed",
      .str_user_error        = "Client Session need be killed",
      .oracle_errno          = 4401,
      .oracle_str_error      = "ORA-04401: Client Session need be killed",
      .oracle_str_user_error = "ORA-04401: Client Session need be killed",
      .ob_str_error          = "OBE-04401: Client Session need be killed",
      .ob_str_user_error     = "OBE-04401: Client Session need be killed"
};
static const _error _error_OB_ERR_KILL_CLIENT_SESSION_FAILED = {
      .error_name            = "OB_ERR_KILL_CLIENT_SESSION_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Kill Client Session failed",
      .str_user_error        = "Kill Client Session failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4402, Kill Client Session failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4402, Kill Client Session failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4402, Kill Client Session failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4402, Kill Client Session failed"
};
static const _error _error_OB_IMPROPER_OS_PARAM = {
      .error_name            = "OB_IMPROPER_OS_PARAM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "OS params check failed, because the operating system has improper parameter configurations",
      .str_user_error        = "OS params check failed, because the operating system has improper parameter configurations",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4403, OS params check failed, because the operating system has improper parameter configurations",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4403, OS params check failed, because the operating system has improper parameter configurations",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4403, OS params check failed, because the operating system has improper parameter configurations",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4403, OS params check failed, because the operating system has improper parameter configurations"
};
static const _error _error_OB_IO_TIMEOUT = {
      .error_name            = "OB_IO_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4012,
      .sqlstate              = "HY000",
      .str_error             = "IO timeout",
      .str_user_error        = "IO timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4404, IO timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4404, IO timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4404, IO timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4404, IO timeout"
};
static const _error _error_OB_INVALID_LICENSE = {
      .error_name            = "OB_INVALID_LICENSE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "license is invalid",
      .str_user_error        = "license is invalid because: %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4405, license is invalid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4405, license is invalid because: %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4405, license is invalid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4405, license is invalid because: %s"
};
static const _error _error_OB_LICENSE_EXPIRED = {
      .error_name            = "OB_LICENSE_EXPIRED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "license is expired",
      .str_user_error        = "license is expired",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4406, license is expired",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4406, license is expired",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4406, license is expired",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4406, license is expired"
};
static const _error _error_OB_LICENSE_SCOPE_EXCEEDED = {
      .error_name            = "OB_LICENSE_SCOPE_EXCEEDED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "current license does not allow this operation",
      .str_user_error        = "current license does not allow this operation: %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4407, current license does not allow this operation",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4407, current license does not allow this operation: %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4407, current license does not allow this operation",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4407, current license does not allow this operation: %s"
};
static const _error _error_OB_IMPORT_NOT_IN_SERVER = {
      .error_name            = "OB_IMPORT_NOT_IN_SERVER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Import not in service",
      .str_user_error        = "Import not in service",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4505, Import not in service",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4505, Import not in service",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4505, Import not in service",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4505, Import not in service"
};
static const _error _error_OB_CONVERT_ERROR = {
      .error_name            = "OB_CONVERT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Convert error",
      .str_user_error        = "Convert error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4507, Convert error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4507, Convert error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4507, Convert error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4507, Convert error"
};
static const _error _error_OB_BYPASS_TIMEOUT = {
      .error_name            = "OB_BYPASS_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Bypass timeout",
      .str_user_error        = "Bypass timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4510, Bypass timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4510, Bypass timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4510, Bypass timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4510, Bypass timeout"
};
static const _error _error_OB_RS_STATE_NOT_ALLOW = {
      .error_name            = "OB_RS_STATE_NOT_ALLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "RootServer state error",
      .str_user_error        = "RootServer state error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4512, RootServer state error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4512, RootServer state error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4512, RootServer state error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4512, RootServer state error"
};
static const _error _error_OB_NO_REPLICA_VALID = {
      .error_name            = "OB_NO_REPLICA_VALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No replica is valid",
      .str_user_error        = "No replica is valid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4515, No replica is valid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4515, No replica is valid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4515, No replica is valid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4515, No replica is valid"
};
static const _error _error_OB_NO_NEED_UPDATE = {
      .error_name            = "OB_NO_NEED_UPDATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No need to update",
      .str_user_error        = "No need to update",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4517, No need to update",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4517, No need to update",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4517, No need to update",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4517, No need to update"
};
static const _error _error_OB_CACHE_TIMEOUT = {
      .error_name            = "OB_CACHE_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Cache timeout",
      .str_user_error        = "Cache timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4518, Cache timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4518, Cache timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4518, Cache timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4518, Cache timeout"
};
static const _error _error_OB_ITER_STOP = {
      .error_name            = "OB_ITER_STOP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Iteration was stopped",
      .str_user_error        = "Iteration was stopped",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4519, Iteration was stopped",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4519, Iteration was stopped",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4519, Iteration was stopped",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4519, Iteration was stopped"
};
static const _error _error_OB_ZONE_ALREADY_MASTER = {
      .error_name            = "OB_ZONE_ALREADY_MASTER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The zone is the master already",
      .str_user_error        = "The zone is the master already",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4523, The zone is the master already",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4523, The zone is the master already",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4523, The zone is the master already",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4523, The zone is the master already"
};
static const _error _error_OB_IP_PORT_IS_NOT_SLAVE_ZONE = {
      .error_name            = "OB_IP_PORT_IS_NOT_SLAVE_ZONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not slave zone",
      .str_user_error        = "Not slave zone",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4524, Not slave zone",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4524, Not slave zone",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4524, Not slave zone",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4524, Not slave zone"
};
static const _error _error_OB_ZONE_IS_NOT_SLAVE = {
      .error_name            = "OB_ZONE_IS_NOT_SLAVE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not slave zone",
      .str_user_error        = "Not slave zone",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4525, Not slave zone",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4525, Not slave zone",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4525, Not slave zone",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4525, Not slave zone"
};
static const _error _error_OB_ZONE_IS_NOT_MASTER = {
      .error_name            = "OB_ZONE_IS_NOT_MASTER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not master zone",
      .str_user_error        = "Not master zone",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4526, Not master zone",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4526, Not master zone",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4526, Not master zone",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4526, Not master zone"
};
static const _error _error_OB_CONFIG_NOT_SYNC = {
      .error_name            = "OB_CONFIG_NOT_SYNC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "F0000",
      .str_error             = "Configuration not sync",
      .str_user_error        = "Configuration not sync",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4527, Configuration not sync",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4527, Configuration not sync",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4527, Configuration not sync",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4527, Configuration not sync"
};
static const _error _error_OB_IP_PORT_IS_NOT_ZONE = {
      .error_name            = "OB_IP_PORT_IS_NOT_ZONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Not a zone address",
      .str_user_error        = "Not a zone address",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4528, Not a zone address",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4528, Not a zone address",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4528, Not a zone address",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4528, Not a zone address"
};
static const _error _error_OB_MASTER_ZONE_NOT_EXIST = {
      .error_name            = "OB_MASTER_ZONE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Master zone not exist",
      .str_user_error        = "Master zone not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4529, Master zone not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4529, Master zone not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4529, Master zone not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4529, Master zone not exist"
};
static const _error _error_OB_ZONE_INFO_NOT_EXIST = {
      .error_name            = "OB_ZONE_INFO_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Zone info not exist",
      .str_user_error        = "Zone info \'%s\' not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4530, Zone info not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4530, Zone info \'%s\' not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4530, Zone info not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4530, Zone info \'%s\' not exist"
};
static const _error _error_OB_GET_ZONE_MASTER_UPS_FAILED = {
      .error_name            = "OB_GET_ZONE_MASTER_UPS_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Failed to get master UpdateServer",
      .str_user_error        = "Failed to get master UpdateServer",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4531, Failed to get master UpdateServer",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4531, Failed to get master UpdateServer",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4531, Failed to get master UpdateServer",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4531, Failed to get master UpdateServer"
};
static const _error _error_OB_MULTIPLE_MASTER_ZONES_EXIST = {
      .error_name            = "OB_MULTIPLE_MASTER_ZONES_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Multiple master zones",
      .str_user_error        = "Multiple master zones",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4532, Multiple master zones",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4532, Multiple master zones",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4532, Multiple master zones",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4532, Multiple master zones"
};
static const _error _error_OB_INDEXING_ZONE_INVALID = {
      .error_name            = "OB_INDEXING_ZONE_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "indexing zone is not exist anymore or not active",
      .str_user_error        = "indexing zone is not exist anymore or not active",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4533, indexing zone is not exist anymore or not active",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4533, indexing zone is not exist anymore or not active",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4533, indexing zone is not exist anymore or not active",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4533, indexing zone is not exist anymore or not active"
};
static const _error _error_OB_ROOT_TABLE_RANGE_NOT_EXIST = {
      .error_name            = "OB_ROOT_TABLE_RANGE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Tablet range not exist",
      .str_user_error        = "Tablet range not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4537, Tablet range not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4537, Tablet range not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4537, Tablet range not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4537, Tablet range not exist"
};
static const _error _error_OB_ROOT_MIGRATE_CONCURRENCY_FULL = {
      .error_name            = "OB_ROOT_MIGRATE_CONCURRENCY_FULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Migrate concurrency full",
      .str_user_error        = "Migrate concurrency full",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4538, Migrate concurrency full",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4538, Migrate concurrency full",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4538, Migrate concurrency full",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4538, Migrate concurrency full"
};
static const _error _error_OB_ROOT_MIGRATE_INFO_NOT_FOUND = {
      .error_name            = "OB_ROOT_MIGRATE_INFO_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Migrate info not found",
      .str_user_error        = "Migrate info not found",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4539, Migrate info not found",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4539, Migrate info not found",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4539, Migrate info not found",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4539, Migrate info not found"
};
static const _error _error_OB_NOT_DATA_LOAD_TABLE = {
      .error_name            = "OB_NOT_DATA_LOAD_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No data to load",
      .str_user_error        = "No data to load",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4540, No data to load",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4540, No data to load",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4540, No data to load",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4540, No data to load"
};
static const _error _error_OB_DATA_LOAD_TABLE_DUPLICATED = {
      .error_name            = "OB_DATA_LOAD_TABLE_DUPLICATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Duplicated table data to load",
      .str_user_error        = "Duplicated table data to load",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4541, Duplicated table data to load",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4541, Duplicated table data to load",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4541, Duplicated table data to load",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4541, Duplicated table data to load"
};
static const _error _error_OB_ROOT_TABLE_ID_EXIST = {
      .error_name            = "OB_ROOT_TABLE_ID_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Table ID exist",
      .str_user_error        = "Table ID exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4542, Table ID exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4542, Table ID exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4542, Table ID exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4542, Table ID exist"
};
static const _error _error_OB_INDEX_TIMEOUT = {
      .error_name            = "OB_INDEX_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Building index timeout",
      .str_user_error        = "Building index timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4543, Building index timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4543, Building index timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4543, Building index timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4543, Building index timeout"
};
static const _error _error_OB_ROOT_NOT_INTEGRATED = {
      .error_name            = "OB_ROOT_NOT_INTEGRATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Root not integrated",
      .str_user_error        = "Root not integrated",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4544, Root not integrated",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4544, Root not integrated",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4544, Root not integrated",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4544, Root not integrated"
};
static const _error _error_OB_INDEX_INELIGIBLE = {
      .error_name            = "OB_INDEX_INELIGIBLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "index data not unique",
      .str_user_error        = "index data not unique",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4545, index data not unique",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4545, index data not unique",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4545, index data not unique",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4545, index data not unique"
};
static const _error _error_OB_REBALANCE_EXEC_TIMEOUT = {
      .error_name            = "OB_REBALANCE_EXEC_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "execute replication or migration task timeout",
      .str_user_error        = "execute replication or migration task timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4546, execute replication or migration task timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4546, execute replication or migration task timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4546, execute replication or migration task timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4546, execute replication or migration task timeout"
};
static const _error _error_OB_MERGE_NOT_STARTED = {
      .error_name            = "OB_MERGE_NOT_STARTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "global merge not started",
      .str_user_error        = "global merge not started",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4547, global merge not started",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4547, global merge not started",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4547, global merge not started",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4547, global merge not started"
};
static const _error _error_OB_MERGE_ALREADY_STARTED = {
      .error_name            = "OB_MERGE_ALREADY_STARTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "merge already started",
      .str_user_error        = "merge already started",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4548, merge already started",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4548, merge already started",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4548, merge already started",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4548, merge already started"
};
static const _error _error_OB_ROOTSERVICE_EXIST = {
      .error_name            = "OB_ROOTSERVICE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rootservice already exist",
      .str_user_error        = "rootservice already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4549, rootservice already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4549, rootservice already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4549, rootservice already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4549, rootservice already exist"
};
static const _error _error_OB_RS_SHUTDOWN = {
      .error_name            = "OB_RS_SHUTDOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rootservice is shutdown",
      .str_user_error        = "rootservice is shutdown",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4550, rootservice is shutdown",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4550, rootservice is shutdown",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4550, rootservice is shutdown",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4550, rootservice is shutdown"
};
static const _error _error_OB_SERVER_MIGRATE_IN_DENIED = {
      .error_name            = "OB_SERVER_MIGRATE_IN_DENIED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server migrate in denied",
      .str_user_error        = "server migrate in denied",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4551, server migrate in denied",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4551, server migrate in denied",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4551, server migrate in denied",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4551, server migrate in denied"
};
static const _error _error_OB_REBALANCE_TASK_CANT_EXEC = {
      .error_name            = "OB_REBALANCE_TASK_CANT_EXEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rebalance task can not executing now",
      .str_user_error        = "rebalance task can not executing now",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4552, rebalance task can not executing now",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4552, rebalance task can not executing now",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4552, rebalance task can not executing now",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4552, rebalance task can not executing now"
};
static const _error _error_OB_PARTITION_CNT_REACH_ROOTSERVER_LIMIT = {
      .error_name            = "OB_PARTITION_CNT_REACH_ROOTSERVER_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rootserver can not hold more partition",
      .str_user_error        = "rootserver can not hold more partition",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4553, rootserver can not hold more partition",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4553, rootserver can not hold more partition",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4553, rootserver can not hold more partition",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4553, rootserver can not hold more partition"
};
static const _error _error_OB_REBALANCE_TASK_NOT_IN_PROGRESS = {
      .error_name            = "OB_REBALANCE_TASK_NOT_IN_PROGRESS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rebalance task not in progress on observer",
      .str_user_error        = "rebalance task not in progress on observer",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4554, rebalance task not in progress on observer",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4554, rebalance task not in progress on observer",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4554, rebalance task not in progress on observer",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4554, rebalance task not in progress on observer"
};
static const _error _error_OB_DATA_SOURCE_NOT_EXIST = {
      .error_name            = "OB_DATA_SOURCE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Data source not exist",
      .str_user_error        = "Data source not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4600, Data source not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4600, Data source not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4600, Data source not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4600, Data source not exist"
};
static const _error _error_OB_DATA_SOURCE_TABLE_NOT_EXIST = {
      .error_name            = "OB_DATA_SOURCE_TABLE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Data source table not exist",
      .str_user_error        = "Data source table not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4601, Data source table not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4601, Data source table not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4601, Data source table not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4601, Data source table not exist"
};
static const _error _error_OB_DATA_SOURCE_RANGE_NOT_EXIST = {
      .error_name            = "OB_DATA_SOURCE_RANGE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Data source range not exist",
      .str_user_error        = "Data source range not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4602, Data source range not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4602, Data source range not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4602, Data source range not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4602, Data source range not exist"
};
static const _error _error_OB_DATA_SOURCE_DATA_NOT_EXIST = {
      .error_name            = "OB_DATA_SOURCE_DATA_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Data source data not exist",
      .str_user_error        = "Data source data not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4603, Data source data not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4603, Data source data not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4603, Data source data not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4603, Data source data not exist"
};
static const _error _error_OB_DATA_SOURCE_SYS_ERROR = {
      .error_name            = "OB_DATA_SOURCE_SYS_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Data source sys error",
      .str_user_error        = "Data source sys error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4604, Data source sys error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4604, Data source sys error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4604, Data source sys error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4604, Data source sys error"
};
static const _error _error_OB_DATA_SOURCE_TIMEOUT = {
      .error_name            = "OB_DATA_SOURCE_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Data source timeout",
      .str_user_error        = "Data source timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4605, Data source timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4605, Data source timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4605, Data source timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4605, Data source timeout"
};
static const _error _error_OB_DATA_SOURCE_CONCURRENCY_FULL = {
      .error_name            = "OB_DATA_SOURCE_CONCURRENCY_FULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "53000",
      .str_error             = "Data source concurrency full",
      .str_user_error        = "Data source concurrency full",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4606, Data source concurrency full",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4606, Data source concurrency full",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4606, Data source concurrency full",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4606, Data source concurrency full"
};
static const _error _error_OB_DATA_SOURCE_WRONG_URI_FORMAT = {
      .error_name            = "OB_DATA_SOURCE_WRONG_URI_FORMAT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Data source wrong URI format",
      .str_user_error        = "Data source wrong URI format",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4607, Data source wrong URI format",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4607, Data source wrong URI format",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4607, Data source wrong URI format",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4607, Data source wrong URI format"
};
static const _error _error_OB_SSTABLE_VERSION_UNEQUAL = {
      .error_name            = "OB_SSTABLE_VERSION_UNEQUAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "SSTable version not equal",
      .str_user_error        = "SSTable version not equal",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4608, SSTable version not equal",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4608, SSTable version not equal",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4608, SSTable version not equal",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4608, SSTable version not equal"
};
static const _error _error_OB_UPS_RENEW_LEASE_NOT_ALLOWED = {
      .error_name            = "OB_UPS_RENEW_LEASE_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ups should not renew its lease",
      .str_user_error        = "ups should not renew its lease",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4609, ups should not renew its lease",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4609, ups should not renew its lease",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4609, ups should not renew its lease",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4609, ups should not renew its lease"
};
static const _error _error_OB_UPS_COUNT_OVER_LIMIT = {
      .error_name            = "OB_UPS_COUNT_OVER_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ups count over limit",
      .str_user_error        = "ups count over limit",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4610, ups count over limit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4610, ups count over limit",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4610, ups count over limit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4610, ups count over limit"
};
static const _error _error_OB_NO_UPS_MAJORITY = {
      .error_name            = "OB_NO_UPS_MAJORITY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ups not form a majority",
      .str_user_error        = "ups not form a majority",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4611, ups not form a majority",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4611, ups not form a majority",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4611, ups not form a majority",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4611, ups not form a majority"
};
static const _error _error_OB_INDEX_COUNT_REACH_THE_LIMIT = {
      .error_name            = "OB_INDEX_COUNT_REACH_THE_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "created index tables count has reach the limit:128",
      .str_user_error        = "created index tables count has reach the limit:128",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4613, created index tables count has reach the limit:128",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4613, created index tables count has reach the limit:128",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4613, created index tables count has reach the limit:128",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4613, created index tables count has reach the limit:128"
};
static const _error _error_OB_TASK_EXPIRED = {
      .error_name            = "OB_TASK_EXPIRED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "task expired",
      .str_user_error        = "task expired",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4614, task expired",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4614, task expired",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4614, task expired",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4614, task expired"
};
static const _error _error_OB_TABLEGROUP_NOT_EMPTY = {
      .error_name            = "OB_TABLEGROUP_NOT_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tablegroup is not empty",
      .str_user_error        = "tablegroup is not empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4615, tablegroup is not empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4615, tablegroup is not empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4615, tablegroup is not empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4615, tablegroup is not empty"
};
static const _error _error_OB_INVALID_SERVER_STATUS = {
      .error_name            = "OB_INVALID_SERVER_STATUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server status is not valid",
      .str_user_error        = "server status is not valid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4620, server status is not valid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4620, server status is not valid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4620, server status is not valid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4620, server status is not valid"
};
static const _error _error_OB_WAIT_ELEC_LEADER_TIMEOUT = {
      .error_name            = "OB_WAIT_ELEC_LEADER_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "wait elect partition leader timeout",
      .str_user_error        = "wait elect partition leader timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4621, wait elect partition leader timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4621, wait elect partition leader timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4621, wait elect partition leader timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4621, wait elect partition leader timeout"
};
static const _error _error_OB_WAIT_ALL_RS_ONLINE_TIMEOUT = {
      .error_name            = "OB_WAIT_ALL_RS_ONLINE_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "wait all rs online timeout",
      .str_user_error        = "wait all rs online timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4622, wait all rs online timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4622, wait all rs online timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4622, wait all rs online timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4622, wait all rs online timeout"
};
static const _error _error_OB_ALL_REPLICAS_ON_MERGE_ZONE = {
      .error_name            = "OB_ALL_REPLICAS_ON_MERGE_ZONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "all replicas of partition group are on zones to merge",
      .str_user_error        = "all replicas of partition group are on zones to merge",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4623, all replicas of partition group are on zones to merge",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4623, all replicas of partition group are on zones to merge",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4623, all replicas of partition group are on zones to merge",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4623, all replicas of partition group are on zones to merge"
};
static const _error _error_OB_MACHINE_RESOURCE_NOT_ENOUGH = {
      .error_name            = "OB_MACHINE_RESOURCE_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "machine resource is not enough to hold a new unit",
      .str_user_error        = "zone '%s' server \'%s\' %s resource is not enough to hold a new unit",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4624, machine resource is not enough to hold a new unit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4624, zone '%s' server \'%s\' %s resource is not enough to hold a new unit",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4624, machine resource is not enough to hold a new unit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4624, zone '%s' server \'%s\' %s resource is not enough to hold a new unit"
};
static const _error _error_OB_NOT_SERVER_CAN_HOLD_SOFTLY = {
      .error_name            = "OB_NOT_SERVER_CAN_HOLD_SOFTLY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "not server can hold the unit and not over soft limit",
      .str_user_error        = "not server can hold the unit and not over soft limit",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4625, not server can hold the unit and not over soft limit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4625, not server can hold the unit and not over soft limit",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4625, not server can hold the unit and not over soft limit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4625, not server can hold the unit and not over soft limit"
};
static const _error _error_OB_RESOURCE_POOL_ALREADY_GRANTED = {
      .error_name            = "OB_RESOURCE_POOL_ALREADY_GRANTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource pool has already been granted to a tenant",
      .str_user_error        = "resource pool \'%s\' has already been granted to a tenant",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4626, resource pool has already been granted to a tenant",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4626, resource pool \'%s\' has already been granted to a tenant",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4626, resource pool has already been granted to a tenant",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4626, resource pool \'%s\' has already been granted to a tenant"
};
static const _error _error_OB_SERVER_ALREADY_DELETED = {
      .error_name            = "OB_SERVER_ALREADY_DELETED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server has already been deleted",
      .str_user_error        = "server has already been deleted",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4628, server has already been deleted",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4628, server has already been deleted",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4628, server has already been deleted",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4628, server has already been deleted"
};
static const _error _error_OB_SERVER_NOT_DELETING = {
      .error_name            = "OB_SERVER_NOT_DELETING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server is not in deleting status",
      .str_user_error        = "server is not in deleting status",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4629, server is not in deleting status",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4629, server is not in deleting status",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4629, server is not in deleting status",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4629, server is not in deleting status"
};
static const _error _error_OB_SERVER_NOT_IN_WHITE_LIST = {
      .error_name            = "OB_SERVER_NOT_IN_WHITE_LIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server not in server white list",
      .str_user_error        = "server not in server white list",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4630, server not in server white list",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4630, server not in server white list",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4630, server not in server white list",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4630, server not in server white list"
};
static const _error _error_OB_SERVER_ZONE_NOT_MATCH = {
      .error_name            = "OB_SERVER_ZONE_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server zone not match",
      .str_user_error        = "server zone not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4631, server zone not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4631, server zone not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4631, server zone not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4631, server zone not match"
};
static const _error _error_OB_OVER_ZONE_NUM_LIMIT = {
      .error_name            = "OB_OVER_ZONE_NUM_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "zone num has reach max zone num",
      .str_user_error        = "zone num has reach max zone num",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4632, zone num has reach max zone num",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4632, zone num has reach max zone num",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4632, zone num has reach max zone num",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4632, zone num has reach max zone num"
};
static const _error _error_OB_ZONE_STATUS_NOT_MATCH = {
      .error_name            = "OB_ZONE_STATUS_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "zone status not match",
      .str_user_error        = "zone status not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4633, zone status not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4633, zone status not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4633, zone status not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4633, zone status not match"
};
static const _error _error_OB_RESOURCE_UNIT_IS_REFERENCED = {
      .error_name            = "OB_RESOURCE_UNIT_IS_REFERENCED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource unit is referenced by resource pool",
      .str_user_error        = "resource unit \'%s\' is referenced by some resource pool",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4634, resource unit is referenced by resource pool",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4634, resource unit \'%s\' is referenced by some resource pool",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4634, resource unit is referenced by resource pool",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4634, resource unit \'%s\' is referenced by some resource pool"
};
static const _error _error_OB_DIFFERENT_PRIMARY_ZONE = {
      .error_name            = "OB_DIFFERENT_PRIMARY_ZONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "table schema primary zone different with other table in same tablegroup",
      .str_user_error        = "table schema primary zone different with other table in same tablegroup",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4636, table schema primary zone different with other table in same tablegroup",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4636, table schema primary zone different with other table in same tablegroup",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4636, table schema primary zone different with other table in same tablegroup",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4636, table schema primary zone different with other table in same tablegroup"
};
static const _error _error_OB_SERVER_NOT_ACTIVE = {
      .error_name            = "OB_SERVER_NOT_ACTIVE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server is not active",
      .str_user_error        = "server is not active",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4637, server is not active",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4637, server is not active",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4637, server is not active",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4637, server is not active"
};
static const _error _error_OB_RS_NOT_MASTER = {
      .error_name            = "OB_RS_NOT_MASTER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The RootServer is not the master",
      .str_user_error        = "The RootServer is not the master",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4638, The RootServer is not the master",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4638, The RootServer is not the master",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4638, The RootServer is not the master",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4638, The RootServer is not the master"
};
static const _error _error_OB_CANDIDATE_LIST_ERROR = {
      .error_name            = "OB_CANDIDATE_LIST_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The candidate list is invalid",
      .str_user_error        = "The candidate list is invalid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4639, The candidate list is invalid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4639, The candidate list is invalid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4639, The candidate list is invalid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4639, The candidate list is invalid"
};
static const _error _error_OB_PARTITION_ZONE_DUPLICATED = {
      .error_name            = "OB_PARTITION_ZONE_DUPLICATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The chosen partition servers belong to same zone.",
      .str_user_error        = "The chosen partition servers belong to same zone.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4640, The chosen partition servers belong to same zone.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4640, The chosen partition servers belong to same zone.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4640, The chosen partition servers belong to same zone.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4640, The chosen partition servers belong to same zone."
};
static const _error _error_OB_ZONE_DUPLICATED = {
      .error_name            = "OB_ZONE_DUPLICATED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Duplicated zone in zone list",
      .str_user_error        = "Duplicated zone \'%s\' in zone list %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4641, Duplicated zone in zone list",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4641, Duplicated zone \'%s\' in zone list %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4641, Duplicated zone in zone list",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4641, Duplicated zone \'%s\' in zone list %s"
};
static const _error _error_OB_NOT_ALL_ZONE_ACTIVE = {
      .error_name            = "OB_NOT_ALL_ZONE_ACTIVE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not all zone in zone list are active",
      .str_user_error        = "Not all zone in zone list are active",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4642, Not all zone in zone list are active",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4642, Not all zone in zone list are active",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4642, Not all zone in zone list are active",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4642, Not all zone in zone list are active"
};
static const _error _error_OB_PRIMARY_ZONE_NOT_IN_ZONE_LIST = {
      .error_name            = "OB_PRIMARY_ZONE_NOT_IN_ZONE_LIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "primary zone not in zone list",
      .str_user_error        = "primary zone \'%s\' not in zone list %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4643, primary zone not in zone list",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4643, primary zone \'%s\' not in zone list %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4643, primary zone not in zone list",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4643, primary zone \'%s\' not in zone list %s"
};
static const _error _error_OB_REPLICA_NUM_NOT_MATCH = {
      .error_name            = "OB_REPLICA_NUM_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "replica num not same with zone count",
      .str_user_error        = "replica num not same with zone count",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4644, replica num not same with zone count",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4644, replica num not same with zone count",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4644, replica num not same with zone count",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4644, replica num not same with zone count"
};
static const _error _error_OB_ZONE_LIST_POOL_LIST_NOT_MATCH = {
      .error_name            = "OB_ZONE_LIST_POOL_LIST_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "zone list not a subset of  resource pool list",
      .str_user_error        = "zone list %s not a subset of resource pool zone list %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4645, zone list not a subset of  resource pool list",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4645, zone list %s not a subset of resource pool zone list %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4645, zone list not a subset of  resource pool list",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4645, zone list %s not a subset of resource pool zone list %s"
};
static const _error _error_OB_INVALID_TENANT_NAME = {
      .error_name            = "OB_INVALID_TENANT_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tenant name is too long",
      .str_user_error        = "tenant name \'%s\' over max_tenant_name_length %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4646, tenant name is too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4646, tenant name \'%s\' over max_tenant_name_length %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4646, tenant name is too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4646, tenant name \'%s\' over max_tenant_name_length %ld"
};
static const _error _error_OB_EMPTY_RESOURCE_POOL_LIST = {
      .error_name            = "OB_EMPTY_RESOURCE_POOL_LIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource pool list is empty",
      .str_user_error        = "resource pool list is empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4647, resource pool list is empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4647, resource pool list is empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4647, resource pool list is empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4647, resource pool list is empty"
};
static const _error _error_OB_RESOURCE_UNIT_NOT_EXIST = {
      .error_name            = "OB_RESOURCE_UNIT_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource unit not exist",
      .str_user_error        = "resource unit \'%s\' not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4648, resource unit not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4648, resource unit \'%s\' not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4648, resource unit not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4648, resource unit \'%s\' not exist"
};
static const _error _error_OB_RESOURCE_UNIT_EXIST = {
      .error_name            = "OB_RESOURCE_UNIT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource unit already exist",
      .str_user_error        = "resource unit \'%s\' already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4649, resource unit already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4649, resource unit \'%s\' already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4649, resource unit already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4649, resource unit \'%s\' already exist"
};
static const _error _error_OB_RESOURCE_POOL_NOT_EXIST = {
      .error_name            = "OB_RESOURCE_POOL_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource pool not exist",
      .str_user_error        = "resource pool \'%s\' not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4650, resource pool not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4650, resource pool \'%s\' not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4650, resource pool not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4650, resource pool \'%s\' not exist"
};
static const _error _error_OB_RESOURCE_POOL_EXIST = {
      .error_name            = "OB_RESOURCE_POOL_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource pool already exist",
      .str_user_error        = "resource pool \'%s\' exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4651, resource pool already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4651, resource pool \'%s\' exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4651, resource pool already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4651, resource pool \'%s\' exist"
};
static const _error _error_OB_WAIT_LEADER_SWITCH_TIMEOUT = {
      .error_name            = "OB_WAIT_LEADER_SWITCH_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "wait leader switch timeout",
      .str_user_error        = "wait leader switch timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4652, wait leader switch timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4652, wait leader switch timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4652, wait leader switch timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4652, wait leader switch timeout"
};
static const _error _error_OB_LOCATION_NOT_EXIST = {
      .error_name            = "OB_LOCATION_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "location not exist",
      .str_user_error        = "location not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4653, location not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4653, location not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4653, location not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4653, location not exist"
};
static const _error _error_OB_LOCATION_LEADER_NOT_EXIST = {
      .error_name            = "OB_LOCATION_LEADER_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "location leader not exist",
      .str_user_error        = "location leader not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4654, location leader not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4654, location leader not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4654, location leader not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4654, location leader not exist"
};
static const _error _error_OB_ZONE_NOT_ACTIVE = {
      .error_name            = "OB_ZONE_NOT_ACTIVE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "zone not active",
      .str_user_error        = "zone not active",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4655, zone not active",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4655, zone not active",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4655, zone not active",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4655, zone not active"
};
static const _error _error_OB_UNIT_NUM_OVER_SERVER_COUNT = {
      .error_name            = "OB_UNIT_NUM_OVER_SERVER_COUNT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource pool unit num is bigger than zone server count",
      .str_user_error        = "resource pool unit num is bigger than zone server count",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4656, resource pool unit num is bigger than zone server count",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4656, resource pool unit num is bigger than zone server count",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4656, resource pool unit num is bigger than zone server count",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4656, resource pool unit num is bigger than zone server count"
};
static const _error _error_OB_POOL_SERVER_INTERSECT = {
      .error_name            = "OB_POOL_SERVER_INTERSECT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource pool list unit server intersect",
      .str_user_error        = "resource pool list %s unit servers intersect",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4657, resource pool list unit server intersect",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4657, resource pool list %s unit servers intersect",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4657, resource pool list unit server intersect",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4657, resource pool list %s unit servers intersect"
};
static const _error _error_OB_NOT_SINGLE_RESOURCE_POOL = {
      .error_name            = "OB_NOT_SINGLE_RESOURCE_POOL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "create tenant only support single resource pool now",
      .str_user_error        = "create tenant only support single resource pool now, but pool list is %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4658, create tenant only support single resource pool now",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4658, create tenant only support single resource pool now, but pool list is %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4658, create tenant only support single resource pool now",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4658, create tenant only support single resource pool now, but pool list is %s"
};
static const _error _error_OB_RESOURCE_UNIT_VALUE_BELOW_LIMIT = {
      .error_name            = "OB_RESOURCE_UNIT_VALUE_BELOW_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource unit value is below limit",
      .str_user_error        = "invalid %s value, min value is %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4659, resource unit value is below limit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4659, invalid %s value, min value is %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4659, resource unit value is below limit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4659, invalid %s value, min value is %s"
};
static const _error _error_OB_STOP_SERVER_IN_MULTIPLE_ZONES = {
      .error_name            = "OB_STOP_SERVER_IN_MULTIPLE_ZONES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Can not stop server in multiple zones",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4660, Can not stop server in multiple zones",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4660, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4660, Can not stop server in multiple zones",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4660, %s"
};
static const _error _error_OB_SESSION_ENTRY_EXIST = {
      .error_name            = "OB_SESSION_ENTRY_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Session already exist",
      .str_user_error        = "Session already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4661, Session already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4661, Session already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4661, Session already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4661, Session already exist"
};
static const _error _error_OB_GOT_SIGNAL_ABORTING = {
      .error_name            = "OB_GOT_SIGNAL_ABORTING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_GOT_SIGNAL,
      .sqlstate              = "01000",
      .str_error             = "Got signal. Aborting!",
      .str_user_error        = "%s: Got signal %d. Aborting!",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4662, Got signal. Aborting!",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4662, %s: Got signal %d. Aborting!",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4662, Got signal. Aborting!",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4662, %s: Got signal %d. Aborting!"
};
static const _error _error_OB_SERVER_NOT_ALIVE = {
      .error_name            = "OB_SERVER_NOT_ALIVE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "server is not alive",
      .str_user_error        = "server is not alive",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4663, server is not alive",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4663, server is not alive",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4663, server is not alive",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4663, server is not alive"
};
static const _error _error_OB_GET_LOCATION_TIME_OUT = {
      .error_name            = "OB_GET_LOCATION_TIME_OUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = 4012,
      .sqlstate              = "HY000",
      .str_error             = "Timeout",
      .str_user_error        = "Timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4664, Timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4664, Timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4664, Timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4664, Timeout"
};
static const _error _error_OB_UNIT_IS_MIGRATING = {
      .error_name            = "OB_UNIT_IS_MIGRATING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unit is migrating, can not migrate again",
      .str_user_error        = "Unit is migrating, can not migrate again",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4665, Unit is migrating, can not migrate again",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4665, Unit is migrating, can not migrate again",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4665, Unit is migrating, can not migrate again",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4665, Unit is migrating, can not migrate again"
};
static const _error _error_OB_CLUSTER_NO_MATCH = {
      .error_name            = "OB_CLUSTER_NO_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cluster name does not match",
      .str_user_error        = "cluster name does not match to \'%s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4666, cluster name does not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4666, cluster name does not match to \'%s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4666, cluster name does not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4666, cluster name does not match to \'%s\'"
};
static const _error _error_OB_CHECK_ZONE_MERGE_ORDER = {
      .error_name            = "OB_CHECK_ZONE_MERGE_ORDER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'",
      .str_user_error        = "Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4667, Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4667, Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4667, Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4667, Please check new zone in zone_merge_order. You can show parameters like 'zone_merge_order'"
};
static const _error _error_OB_ERR_ZONE_NOT_EMPTY = {
      .error_name            = "OB_ERR_ZONE_NOT_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "zone not empty",
      .str_user_error        = "The zone is not empty and can not be deleted. You should delete the servers of the zone. There are %ld servers alive and %ld not alive.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4668, zone not empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4668, The zone is not empty and can not be deleted. You should delete the servers of the zone. There are %ld servers alive and %ld not alive.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4668, zone not empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4668, The zone is not empty and can not be deleted. You should delete the servers of the zone. There are %ld servers alive and %ld not alive."
};
static const _error _error_OB_DIFFERENT_LOCALITY = {
      .error_name            = "OB_DIFFERENT_LOCALITY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "locality not match, check it",
      .str_user_error        = "locality not match, check it",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4669, locality not match, check it",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4669, locality not match, check it",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4669, locality not match, check it",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4669, locality not match, check it"
};
static const _error _error_OB_EMPTY_LOCALITY = {
      .error_name            = "OB_EMPTY_LOCALITY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "locality is empty",
      .str_user_error        = "locality is empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4670, locality is empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4670, locality is empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4670, locality is empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4670, locality is empty"
};
static const _error _error_OB_FULL_REPLICA_NUM_NOT_ENOUGH = {
      .error_name            = "OB_FULL_REPLICA_NUM_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "full replica num not enough",
      .str_user_error        = "full replica num not enough",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4671, full replica num not enough",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4671, full replica num not enough",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4671, full replica num not enough",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4671, full replica num not enough"
};
static const _error _error_OB_REPLICA_NUM_NOT_ENOUGH = {
      .error_name            = "OB_REPLICA_NUM_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "replica num not enough",
      .str_user_error        = "replica num not enough",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4672, replica num not enough",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4672, replica num not enough",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4672, replica num not enough",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4672, replica num not enough"
};
static const _error _error_OB_DATA_SOURCE_NOT_VALID = {
      .error_name            = "OB_DATA_SOURCE_NOT_VALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Data source not valid",
      .str_user_error        = "Data source not valid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4673, Data source not valid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4673, Data source not valid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4673, Data source not valid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4673, Data source not valid"
};
static const _error _error_OB_RUN_JOB_NOT_SUCCESS = {
      .error_name            = "OB_RUN_JOB_NOT_SUCCESS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "run job not success yet",
      .str_user_error        = "run job not success yet",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4674, run job not success yet",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4674, run job not success yet",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4674, run job not success yet",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4674, run job not success yet"
};
static const _error _error_OB_NO_NEED_REBUILD = {
      .error_name            = "OB_NO_NEED_REBUILD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "no need to rebuild",
      .str_user_error        = "no need to rebuild",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4675, no need to rebuild",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4675, no need to rebuild",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4675, no need to rebuild",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4675, no need to rebuild"
};
static const _error _error_OB_NEED_REMOVE_UNNEED_TABLE = {
      .error_name            = "OB_NEED_REMOVE_UNNEED_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "need remove unneed table",
      .str_user_error        = "need remove unneed table",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4676, need remove unneed table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4676, need remove unneed table",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4676, need remove unneed table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4676, need remove unneed table"
};
static const _error _error_OB_NO_NEED_MERGE = {
      .error_name            = "OB_NO_NEED_MERGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "no need to merge",
      .str_user_error        = "no need to merge",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4677, no need to merge",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4677, no need to merge",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4677, no need to merge",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4677, no need to merge"
};
static const _error _error_OB_CONFLICT_OPTION = {
      .error_name            = "OB_CONFLICT_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "conflicting specifications",
      .str_user_error        = "conflicting %.*s specifications",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4678, conflicting specifications",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4678, conflicting %.*s specifications",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4678, conflicting specifications",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4678, conflicting %.*s specifications"
};
static const _error _error_OB_DUPLICATE_OPTION = {
      .error_name            = "OB_DUPLICATE_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate specifications",
      .str_user_error        = "duplicate %.*s specifications",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4679, duplicate specifications",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4679, duplicate %.*s specifications",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4679, duplicate specifications",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4679, duplicate %.*s specifications"
};
static const _error _error_OB_INVALID_OPTION = {
      .error_name            = "OB_INVALID_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid specifications",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4680, invalid specifications",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4680, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4680, invalid specifications",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4680, %s"
};
static const _error _error_OB_RPC_NEED_RECONNECT = {
      .error_name            = "OB_RPC_NEED_RECONNECT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rpc need reconnect",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4681, rpc need reconnect",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4681, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4681, rpc need reconnect",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4681, %s"
};
static const _error _error_OB_CANNOT_COPY_MAJOR_SSTABLE = {
      .error_name            = "OB_CANNOT_COPY_MAJOR_SSTABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cannot copy major sstable now",
      .str_user_error        = "cannot copy major sstable now",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4682, cannot copy major sstable now",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4682, cannot copy major sstable now",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4682, cannot copy major sstable now",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4682, cannot copy major sstable now"
};
static const _error _error_OB_SRC_DO_NOT_ALLOWED_MIGRATE = {
      .error_name            = "OB_SRC_DO_NOT_ALLOWED_MIGRATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "src do not allowed migrate",
      .str_user_error        = "src do not allowed migrate",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4683, src do not allowed migrate",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4683, src do not allowed migrate",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4683, src do not allowed migrate",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4683, src do not allowed migrate"
};
static const _error _error_OB_TOO_MANY_TENANT_PARTITIONS_ERROR = {
      .error_name            = "OB_TOO_MANY_TENANT_PARTITIONS_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Too many partitions were defined for this tenant",
      .str_user_error        = "Too many partitions were defined for this tenant",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4684, Too many partitions were defined for this tenant",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4684, Too many partitions were defined for this tenant",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4684, Too many partitions were defined for this tenant",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4684, Too many partitions were defined for this tenant"
};
static const _error _error_OB_ACTIVE_MEMTBALE_NOT_EXSIT = {
      .error_name            = "OB_ACTIVE_MEMTBALE_NOT_EXSIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "active memtable not exist",
      .str_user_error        = "active memtable not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4685, active memtable not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4685, active memtable not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4685, active memtable not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4685, active memtable not exist"
};
static const _error _error_OB_USE_DUP_FOLLOW_AFTER_DML = {
      .error_name            = "OB_USE_DUP_FOLLOW_AFTER_DML",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Should use leader replica for duplicate table after DML operator",
      .str_user_error        = "Should use leader replica for duplicate table after DML operator",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4686, Should use leader replica for duplicate table after DML operator",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4686, Should use leader replica for duplicate table after DML operator",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4686, Should use leader replica for duplicate table after DML operator",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4686, Should use leader replica for duplicate table after DML operator"
};
static const _error _error_OB_NO_DISK_NEED_REBUILD = {
      .error_name            = "OB_NO_DISK_NEED_REBUILD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "no disk need rebuild",
      .str_user_error        = "no disk need rebuild",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4687, no disk need rebuild",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4687, no disk need rebuild",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4687, no disk need rebuild",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4687, no disk need rebuild"
};
static const _error _error_OB_STANDBY_READ_ONLY = {
      .error_name            = "OB_STANDBY_READ_ONLY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "standby tenant is read only",
      .str_user_error        = "standby tenant is read only",
      .oracle_errno          = 16000,
      .oracle_str_error      = "ORA-16000: standby tenant is read only",
      .oracle_str_user_error = "ORA-16000: standby tenant is read only",
      .ob_str_error          = "OBE-16000: standby tenant is read only",
      .ob_str_user_error     = "OBE-16000: standby tenant is read only"
};
static const _error _error_OB_INVALD_WEB_SERVICE_CONTENT = {
      .error_name            = "OB_INVALD_WEB_SERVICE_CONTENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "web service content not valid",
      .str_user_error        = "web service content not valid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4689, web service content not valid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4689, web service content not valid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4689, web service content not valid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4689, web service content not valid"
};
static const _error _error_OB_PRIMARY_CLUSTER_EXIST = {
      .error_name            = "OB_PRIMARY_CLUSTER_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "other primary cluster already exist, can not start as primary",
      .str_user_error        = "other primary cluster already exist, can not start as primary",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4690, other primary cluster already exist, can not start as primary",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4690, other primary cluster already exist, can not start as primary",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4690, other primary cluster already exist, can not start as primary",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4690, other primary cluster already exist, can not start as primary"
};
static const _error _error_OB_ARRAY_BINDING_SWITCH_ITERATOR = {
      .error_name            = "OB_ARRAY_BINDING_SWITCH_ITERATOR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "array binding needs to switch iterator",
      .str_user_error        = "array binding needs to switch iterator",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4691, array binding needs to switch iterator",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4691, array binding needs to switch iterator",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4691, array binding needs to switch iterator",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4691, array binding needs to switch iterator"
};
static const _error _error_OB_ERR_STANDBY_CLUSTER_NOT_EMPTY = {
      .error_name            = "OB_ERR_STANDBY_CLUSTER_NOT_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "standby cluster not empty",
      .str_user_error        = "standby cluster not empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4692, standby cluster not empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4692, standby cluster not empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4692, standby cluster not empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4692, standby cluster not empty"
};
static const _error _error_OB_NOT_PRIMARY_CLUSTER = {
      .error_name            = "OB_NOT_PRIMARY_CLUSTER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "not primary cluster",
      .str_user_error        = "not primary cluster",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4693, not primary cluster",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4693, not primary cluster",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4693, not primary cluster",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4693, not primary cluster"
};
static const _error _error_OB_ERR_CHECK_DROP_COLUMN_FAILED = {
      .error_name            = "OB_ERR_CHECK_DROP_COLUMN_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "check drop column failed",
      .str_user_error        = "check drop column failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4694, check drop column failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4694, check drop column failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4694, check drop column failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4694, check drop column failed"
};
static const _error _error_OB_NOT_STANDBY_CLUSTER = {
      .error_name            = "OB_NOT_STANDBY_CLUSTER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "not standby cluster",
      .str_user_error        = "not standby cluster",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4695, not standby cluster",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4695, not standby cluster",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4695, not standby cluster",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4695, not standby cluster"
};
static const _error _error_OB_CLUSTER_VERSION_NOT_COMPATIBLE = {
      .error_name            = "OB_CLUSTER_VERSION_NOT_COMPATIBLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cluster version not compatible",
      .str_user_error        = "cluster version not compatible",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4696, cluster version not compatible",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4696, cluster version not compatible",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4696, cluster version not compatible",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4696, cluster version not compatible"
};
static const _error _error_OB_WAIT_TRANS_TABLE_MERGE_TIMEOUT = {
      .error_name            = "OB_WAIT_TRANS_TABLE_MERGE_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "wait trans table merge finish timeout",
      .str_user_error        = "wait trans table merge finish timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4697, wait trans table merge finish timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4697, wait trans table merge finish timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4697, wait trans table merge finish timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4697, wait trans table merge finish timeout"
};
static const _error _error_OB_SKIP_RENEW_LOCATION_BY_RPC = {
      .error_name            = "OB_SKIP_RENEW_LOCATION_BY_RPC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "skip renew location by rpc",
      .str_user_error        = "skip renew location by rpc",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4698, skip renew location by rpc",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4698, skip renew location by rpc",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4698, skip renew location by rpc",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4698, skip renew location by rpc"
};
static const _error _error_OB_RENEW_LOCATION_BY_RPC_FAILED = {
      .error_name            = "OB_RENEW_LOCATION_BY_RPC_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "renew location by rpc failed",
      .str_user_error        = "renew location by rpc failed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4699, renew location by rpc failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4699, renew location by rpc failed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4699, renew location by rpc failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4699, renew location by rpc failed"
};
static const _error _error_OB_CLUSTER_ID_NO_MATCH = {
      .error_name            = "OB_CLUSTER_ID_NO_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cluster id does not match",
      .str_user_error        = "cluster id does not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4700, cluster id does not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4700, cluster id does not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4700, cluster id does not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4700, cluster id does not match"
};
static const _error _error_OB_ERR_PARAM_INVALID = {
      .error_name            = "OB_ERR_PARAM_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "parameter cannot be modified because specified value is invalid",
      .str_user_error        = "parameter cannot be modified because specified value is invalid",
      .oracle_errno          = 2097,
      .oracle_str_error      = "ORA-02097: parameter cannot be modified because specified value is invalid",
      .oracle_str_user_error = "ORA-02097: parameter cannot be modified because specified value is invalid",
      .ob_str_error          = "OBE-02097: parameter cannot be modified because specified value is invalid",
      .ob_str_user_error     = "OBE-02097: parameter cannot be modified because specified value is invalid"
};
static const _error _error_OB_ERR_RES_OBJ_ALREADY_EXIST = {
      .error_name            = "OB_ERR_RES_OBJ_ALREADY_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource object already exists",
      .str_user_error        = "%s %.*s already exists",
      .oracle_errno          = 29357,
      .oracle_str_error      = "ORA-29357: resource object already exists",
      .oracle_str_user_error = "ORA-29357: %s %.*s already exists",
      .ob_str_error          = "OBE-29357: resource object already exists",
      .ob_str_user_error     = "OBE-29357: %s %.*s already exists"
};
static const _error _error_OB_ERR_RES_PLAN_NOT_EXIST = {
      .error_name            = "OB_ERR_RES_PLAN_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource plan does not exist",
      .str_user_error        = "resource plan %.*s does not exist",
      .oracle_errno          = 29358,
      .oracle_str_error      = "ORA-29358: resource plan does not exist",
      .oracle_str_user_error = "ORA-29358: resource plan %.*s does not exist",
      .ob_str_error          = "OBE-29358: resource plan does not exist",
      .ob_str_user_error     = "OBE-29358: resource plan %.*s does not exist"
};
static const _error _error_OB_ERR_PERCENTAGE_OUT_OF_RANGE = {
      .error_name            = "OB_ERR_PERCENTAGE_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "value is outside valid range of 0 to 100",
      .str_user_error        = "value %ld for %s is outside valid range of 0 to 100",
      .oracle_errno          = 29361,
      .oracle_str_error      = "ORA-29361: value is outside valid range of 0 to 100",
      .oracle_str_user_error = "ORA-29361: value %ld for %s is outside valid range of 0 to 100",
      .ob_str_error          = "OBE-29361: value is outside valid range of 0 to 100",
      .ob_str_user_error     = "OBE-29361: value %ld for %s is outside valid range of 0 to 100"
};
static const _error _error_OB_ERR_PLAN_DIRECTIVE_NOT_EXIST = {
      .error_name            = "OB_ERR_PLAN_DIRECTIVE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan directive does not exist",
      .str_user_error        = "plan directive %.*s, %.*s does not exist",
      .oracle_errno          = 29362,
      .oracle_str_error      = "ORA-29362: plan directive does not exist",
      .oracle_str_user_error = "ORA-29362: plan directive %.*s, %.*s does not exist",
      .ob_str_error          = "OBE-29362: plan directive does not exist",
      .ob_str_user_error     = "OBE-29362: plan directive %.*s, %.*s does not exist"
};
static const _error _error_OB_ERR_PLAN_DIRECTIVE_ALREADY_EXIST = {
      .error_name            = "OB_ERR_PLAN_DIRECTIVE_ALREADY_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan directive already exists",
      .str_user_error        = "plan directive %.*s, %.*s already exists",
      .oracle_errno          = 29364,
      .oracle_str_error      = "ORA-29364: plan directive already exists",
      .oracle_str_user_error = "ORA-29364: plan directive %.*s, %.*s already exists",
      .ob_str_error          = "OBE-29364: plan directive already exists",
      .ob_str_user_error     = "OBE-29364: plan directive %.*s, %.*s already exists"
};
static const _error _error_OB_ERR_INVALID_PLAN_DIRECTIVE_NAME = {
      .error_name            = "OB_ERR_INVALID_PLAN_DIRECTIVE_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan directive name not supported.",
      .str_user_error        = "plan directive name '%.*s' not supported.",
      .oracle_errno          = 29366,
      .oracle_str_error      = "ORA-29366: plan directive name not supported.",
      .oracle_str_user_error = "ORA-29366: plan directive name '%.*s' not supported.",
      .ob_str_error          = "OBE-29366: plan directive name not supported.",
      .ob_str_user_error     = "OBE-29366: plan directive name '%.*s' not supported."
};
static const _error _error_OB_FAILOVER_NOT_ALLOW = {
      .error_name            = "OB_FAILOVER_NOT_ALLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Failover is not allowed",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4708, Failover is not allowed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4708, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4708, Failover is not allowed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4708, %s"
};
static const _error _error_OB_ADD_CLUSTER_NOT_ALLOWED = {
      .error_name            = "OB_ADD_CLUSTER_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Add cluster not allowed.",
      .str_user_error        = "Add cluster not allowed. Actions: %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4709, Add cluster not allowed.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4709, Add cluster not allowed. Actions: %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4709, Add cluster not allowed.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4709, Add cluster not allowed. Actions: %s"
};
static const _error _error_OB_ERR_CONSUMER_GROUP_NOT_EXIST = {
      .error_name            = "OB_ERR_CONSUMER_GROUP_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "consumer group does not exist",
      .str_user_error        = "consumer group %.*s does not exist",
      .oracle_errno          = 29368,
      .oracle_str_error      = "ORA-29368: consumer group does not exist",
      .oracle_str_user_error = "ORA-29368: consumer group %.*s does not exist",
      .ob_str_error          = "OBE-29368: consumer group does not exist",
      .ob_str_user_error     = "OBE-29368: consumer group %.*s does not exist"
};
static const _error _error_OB_CLUSTER_NOT_ACCESSIBLE = {
      .error_name            = "OB_CLUSTER_NOT_ACCESSIBLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cluster is not accessible",
      .str_user_error        = "cluster is not accessible, cluster_id: %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4711, cluster is not accessible",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4711, cluster is not accessible, cluster_id: %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4711, cluster is not accessible",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4711, cluster is not accessible, cluster_id: %ld"
};
static const _error _error_OB_TENANT_RESOURCE_UNIT_EXIST = {
      .error_name            = "OB_TENANT_RESOURCE_UNIT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tenant already has resource unit configured",
      .str_user_error        = "tenant already has resource unit configured, tenant_id: %ld, observer: \'%s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4712, tenant already has resource unit configured",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4712, tenant already has resource unit configured, tenant_id: %ld, observer: \'%s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4712, tenant already has resource unit configured",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4712, tenant already has resource unit configured, tenant_id: %ld, observer: \'%s\'"
};
static const _error _error_OB_ERR_DROP_TRUNCATE_PARTITION_REBUILD_INDEX = {
      .error_name            = "OB_ERR_DROP_TRUNCATE_PARTITION_REBUILD_INDEX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rebuild global index failed when drop/truncate partitions",
      .str_user_error        = "rebuild global index:'%.*s' failed when drop/truncate partitions",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4713, rebuild global index failed when drop/truncate partitions",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4713, rebuild global index:'%.*s' failed when drop/truncate partitions",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4713, rebuild global index failed when drop/truncate partitions",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4713, rebuild global index:'%.*s' failed when drop/truncate partitions"
};
static const _error _error_OB_ERR_ATLER_TABLE_ILLEGAL_FK = {
      .error_name            = "OB_ERR_ATLER_TABLE_ILLEGAL_FK",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unique/primary keys in table referenced by enabled foreign keys",
      .str_user_error        = "unique/primary keys in table referenced by enabled foreign keys",
      .oracle_errno          = 02266,
      .oracle_str_error      = "ORA-02266: unique/primary keys in table referenced by enabled foreign keys",
      .oracle_str_user_error = "ORA-02266: unique/primary keys in table referenced by enabled foreign keys",
      .ob_str_error          = "OBE-02266: unique/primary keys in table referenced by enabled foreign keys",
      .ob_str_user_error     = "OBE-02266: unique/primary keys in table referenced by enabled foreign keys"
};
static const _error _error_OB_ERR_NO_RESOURCE_MANAGER_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_RESOURCE_MANAGER_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "insufficient Resource Manager privileges",
      .str_user_error        = "insufficient Resource Manager privileges",
      .oracle_errno          = 56713,
      .oracle_str_error      = "ORA-56713: insufficient Resource Manager privileges",
      .oracle_str_user_error = "ORA-56713: insufficient Resource Manager privileges",
      .ob_str_error          = "OBE-56713: insufficient Resource Manager privileges",
      .ob_str_user_error     = "OBE-56713: insufficient Resource Manager privileges"
};
static const _error _error_OB_LEADER_COORDINATOR_NEED_RETRY = {
      .error_name            = "OB_LEADER_COORDINATOR_NEED_RETRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "leader coordinator needs retry",
      .str_user_error        = "leader coordinator needs retry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4716, leader coordinator needs retry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4716, leader coordinator needs retry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4716, leader coordinator needs retry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4716, leader coordinator needs retry"
};
static const _error _error_OB_REBALANCE_TASK_NEED_RETRY = {
      .error_name            = "OB_REBALANCE_TASK_NEED_RETRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rebalance task needs retry",
      .str_user_error        = "rebalance task needs retry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4717, rebalance task needs retry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4717, rebalance task needs retry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4717, rebalance task needs retry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4717, rebalance task needs retry"
};
static const _error _error_OB_ERR_RES_MGR_PLAN_NOT_EXIST = {
      .error_name            = "OB_ERR_RES_MGR_PLAN_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "specified resource manager plan does not exist in the data dictionary",
      .str_user_error        = "specified resource manager plan does not exist in the data dictionary",
      .oracle_errno          = 7452,
      .oracle_str_error      = "ORA-07452: specified resource manager plan does not exist in the data dictionary",
      .oracle_str_user_error = "ORA-07452: specified resource manager plan does not exist in the data dictionary",
      .ob_str_error          = "OBE-07452: specified resource manager plan does not exist in the data dictionary",
      .ob_str_user_error     = "OBE-07452: specified resource manager plan does not exist in the data dictionary"
};
static const _error _error_OB_LS_NOT_EXIST = {
      .error_name            = "OB_LS_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream does not exist",
      .str_user_error        = "log stream does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4719, log stream does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4719, log stream does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4719, log stream does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4719, log stream does not exist"
};
static const _error _error_OB_TOO_MANY_TENANT_LS = {
      .error_name            = "OB_TOO_MANY_TENANT_LS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "too many log streams were defined for this tenant",
      .str_user_error        = "too many log streams were defined for this tenant",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4720, too many log streams were defined for this tenant",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4720, too many log streams were defined for this tenant",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4720, too many log streams were defined for this tenant",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4720, too many log streams were defined for this tenant"
};
static const _error _error_OB_LS_LOCATION_NOT_EXIST = {
      .error_name            = "OB_LS_LOCATION_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream location does not exist",
      .str_user_error        = "log stream location does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4721, log stream location does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4721, log stream location does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4721, log stream location does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4721, log stream location does not exist"
};
static const _error _error_OB_LS_LOCATION_LEADER_NOT_EXIST = {
      .error_name            = "OB_LS_LOCATION_LEADER_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream location leader does not exist",
      .str_user_error        = "log stream location leader does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4722, log stream location leader does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4722, log stream location leader does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4722, log stream location leader does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4722, log stream location leader does not exist"
};
static const _error _error_OB_MAPPING_BETWEEN_TABLET_AND_LS_NOT_EXIST = {
      .error_name            = "OB_MAPPING_BETWEEN_TABLET_AND_LS_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "mapping between tablet and log stream does not exist",
      .str_user_error        = "mapping between tablet and log stream does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4723, mapping between tablet and log stream does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4723, mapping between tablet and log stream does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4723, mapping between tablet and log stream does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4723, mapping between tablet and log stream does not exist"
};
static const _error _error_OB_TABLET_EXIST = {
      .error_name            = "OB_TABLET_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unexpected tablet existence",
      .str_user_error        = "unexpected tablet existence",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4724, unexpected tablet existence",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4724, unexpected tablet existence",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4724, unexpected tablet existence",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4724, unexpected tablet existence"
};
static const _error _error_OB_TABLET_NOT_EXIST = {
      .error_name            = "OB_TABLET_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tablet does not exist",
      .str_user_error        = "tablet does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4725, tablet does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4725, tablet does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4725, tablet does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4725, tablet does not exist"
};
static const _error _error_OB_ERR_STANDBY_STATUS = {
      .error_name            = "OB_ERR_STANDBY_STATUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "check standby cluster status",
      .str_user_error        = "check standby cluster status",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4726, check standby cluster status",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4726, check standby cluster status",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4726, check standby cluster status",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4726, check standby cluster status"
};
static const _error _error_OB_LS_NEED_REVOKE = {
      .error_name            = "OB_LS_NEED_REVOKE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ls need revoke",
      .str_user_error        = "ls need revoke",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4727, ls need revoke",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4727, ls need revoke",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4727, ls need revoke",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4727, ls need revoke"
};
static const _error _error_OB_ERR_INTERVAL_PARTITION_EXIST = {
      .error_name            = "OB_ERR_INTERVAL_PARTITION_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "interval partition already exists",
      .str_user_error        = "interval partition already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4728, interval partition already exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4728, interval partition already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4728, interval partition already exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4728, interval partition already exists"
};
static const _error _error_OB_ERR_INTERVAL_PARTITION_ERROR = {
      .error_name            = "OB_ERR_INTERVAL_PARTITION_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the property of interval partition is changed",
      .str_user_error        = "the property of interval partition is changed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4729, the property of interval partition is changed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4729, the property of interval partition is changed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4729, the property of interval partition is changed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4729, the property of interval partition is changed"
};
static const _error _error_OB_ERR_LAST_PARTITION_IN_THE_RANGE_SECTION_CANNOT_BE_DROPPED = {
      .error_name            = "OB_ERR_LAST_PARTITION_IN_THE_RANGE_SECTION_CANNOT_BE_DROPPED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Last partition in the range section cannot be dropped",
      .str_user_error        = "Last partition in the range section cannot be dropped",
      .oracle_errno          = 14758,
      .oracle_str_error      = "ORA-14758: Last partition in the range section cannot be dropped",
      .oracle_str_user_error = "ORA-14758: Last partition in the range section cannot be dropped",
      .ob_str_error          = "OBE-14758: Last partition in the range section cannot be dropped",
      .ob_str_user_error     = "OBE-14758: Last partition in the range section cannot be dropped"
};
static const _error _error_OB_ERR_SET_INTERVAL_IS_NOT_LEGAL_ON_THIS_TABLE = {
      .error_name            = "OB_ERR_SET_INTERVAL_IS_NOT_LEGAL_ON_THIS_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "SET INTERVAL is not legal on this table.",
      .str_user_error        = "SET INTERVAL is not legal on this table.",
      .oracle_errno          = 14759,
      .oracle_str_error      = "ORA-14759: SET INTERVAL is not legal on this table.",
      .oracle_str_user_error = "ORA-14759: SET INTERVAL is not legal on this table.",
      .ob_str_error          = "OBE-14759: SET INTERVAL is not legal on this table.",
      .ob_str_user_error     = "OBE-14759: SET INTERVAL is not legal on this table."
};
static const _error _error_OB_CHECK_CLUSTER_STATUS = {
      .error_name            = "OB_CHECK_CLUSTER_STATUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "check cluster status",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4732, check cluster status",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4732, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4732, check cluster status",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4732, %s"
};
static const _error _error_OB_ZONE_RESOURCE_NOT_ENOUGH = {
      .error_name            = "OB_ZONE_RESOURCE_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "zone resource is not enough to hold new units",
      .str_user_error        = "zone '%s' resource not enough to hold %ld unit. You can check resource info by views: DBA_OB_UNITS, GV$OB_UNITS, GV$OB_SERVERS.\n%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4733, zone resource is not enough to hold new units",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4733, zone '%s' resource not enough to hold %ld unit. You can check resource info by views: DBA_OB_UNITS, GV$OB_UNITS, GV$OB_SERVERS.\n%s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4733, zone resource is not enough to hold new units",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4733, zone '%s' resource not enough to hold %ld unit. You can check resource info by views: DBA_OB_UNITS, GV$OB_UNITS, GV$OB_SERVERS.\n%s"
};
static const _error _error_OB_ZONE_SERVER_NOT_ENOUGH = {
      .error_name            = "OB_ZONE_SERVER_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "zone server not enough to hold all units",
      .str_user_error        = "zone '%s' server not enough to hold %ld new unit, please check zone valid servers",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4734, zone server not enough to hold all units",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4734, zone '%s' server not enough to hold %ld new unit, please check zone valid servers",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4734, zone server not enough to hold all units",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4734, zone '%s' server not enough to hold %ld new unit, please check zone valid servers"
};
static const _error _error_OB_SSTABLE_NOT_EXIST = {
      .error_name            = "OB_SSTABLE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sstable not exist",
      .str_user_error        = "sstable not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4735, sstable not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4735, sstable not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4735, sstable not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4735, sstable not exist"
};
static const _error _error_OB_RESOURCE_UNIT_VALUE_INVALID = {
      .error_name            = "OB_RESOURCE_UNIT_VALUE_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resource unit value is invalid",
      .str_user_error        = "resource unit value is invalid",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4736, resource unit value is invalid",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4736, resource unit value is invalid",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4736, resource unit value is invalid",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4736, resource unit value is invalid"
};
static const _error _error_OB_LS_EXIST = {
      .error_name            = "OB_LS_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream already exist",
      .str_user_error        = "log stream already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4737, log stream already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4737, log stream already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4737, log stream already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4737, log stream already exist"
};
static const _error _error_OB_DEVICE_EXIST = {
      .error_name            = "OB_DEVICE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unexpected device existence",
      .str_user_error        = "Unexpected device existence",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4738, Unexpected device existence",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4738, Unexpected device existence",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4738, Unexpected device existence",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4738, Unexpected device existence"
};
static const _error _error_OB_DEVICE_NOT_EXIST = {
      .error_name            = "OB_DEVICE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Device does not exist",
      .str_user_error        = "Device does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4739, Device does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4739, Device does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4739, Device does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4739, Device does not exist"
};
static const _error _error_OB_LS_REPLICA_TASK_RESULT_UNCERTAIN = {
      .error_name            = "OB_LS_REPLICA_TASK_RESULT_UNCERTAIN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream replica task result is uncertain",
      .str_user_error        = "log stream replica task result is uncertain",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4740, log stream replica task result is uncertain",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4740, log stream replica task result is uncertain",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4740, log stream replica task result is uncertain",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4740, log stream replica task result is uncertain"
};
static const _error _error_OB_WAIT_REPLAY_TIMEOUT = {
      .error_name            = "OB_WAIT_REPLAY_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream wait log replay timeout",
      .str_user_error        = "log stream wait log replay timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4741, log stream wait log replay timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4741, log stream wait log replay timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4741, log stream wait log replay timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4741, log stream wait log replay timeout"
};
static const _error _error_OB_WAIT_TABLET_READY_TIMEOUT = {
      .error_name            = "OB_WAIT_TABLET_READY_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream wait tablet ready timeout",
      .str_user_error        = "log stream wait tablet ready timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4742, log stream wait tablet ready timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4742, log stream wait tablet ready timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4742, log stream wait tablet ready timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4742, log stream wait tablet ready timeout"
};
static const _error _error_OB_FREEZE_SERVICE_EPOCH_MISMATCH = {
      .error_name            = "OB_FREEZE_SERVICE_EPOCH_MISMATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "freeze service epoch is not expected",
      .str_user_error        = "freeze service epoch is not expected",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4743, freeze service epoch is not expected",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4743, freeze service epoch is not expected",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4743, freeze service epoch is not expected",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4743, freeze service epoch is not expected"
};
static const _error _error_OB_FROZEN_INFO_ALREADY_EXIST = {
      .error_name            = "OB_FROZEN_INFO_ALREADY_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "already exist larger frozen_scn in __all_freeze_info",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4744, already exist larger frozen_scn in __all_freeze_info",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4744, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4744, already exist larger frozen_scn in __all_freeze_info",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4744, %s"
};
static const _error _error_OB_DELETE_SERVER_NOT_ALLOWED = {
      .error_name            = "OB_DELETE_SERVER_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "delete server not allowed",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4745, delete server not allowed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4745, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4745, delete server not allowed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4745, %s"
};
static const _error _error_OB_PACKET_STATUS_UNKNOWN = {
      .error_name            = "OB_PACKET_STATUS_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Network error and packet status unknown. Abort auto retry.",
      .str_user_error        = "Network error and packet status unknown. Abort auto retry.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4746, Network error and packet status unknown. Abort auto retry.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4746, Network error and packet status unknown. Abort auto retry.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4746, Network error and packet status unknown. Abort auto retry.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4746, Network error and packet status unknown. Abort auto retry."
};
static const _error _error_OB_ARBITRATION_SERVICE_NOT_EXIST = {
      .error_name            = "OB_ARBITRATION_SERVICE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "arbitration service does not exist",
      .str_user_error        = "arbitration service does not exist, %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4747, arbitration service does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4747, arbitration service does not exist, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4747, arbitration service does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4747, arbitration service does not exist, %s"
};
static const _error _error_OB_ARBITRATION_SERVICE_ALREADY_EXIST = {
      .error_name            = "OB_ARBITRATION_SERVICE_ALREADY_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "arbitration service already exist",
      .str_user_error        = "arbitration service already exist, %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4748, arbitration service already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4748, arbitration service already exist, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4748, arbitration service already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4748, arbitration service already exist, %s"
};
static const _error _error_OB_UNEXPECTED_TABLET_STATUS = {
      .error_name            = "OB_UNEXPECTED_TABLET_STATUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unexpected tablet status",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4749, unexpected tablet status",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4749, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4749, unexpected tablet status",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4749, %s"
};
static const _error _error_OB_INVALID_TABLE_STORE = {
      .error_name            = "OB_INVALID_TABLE_STORE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid table store",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4750, invalid table store",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4750, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4750, invalid table store",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4750, %s"
};
static const _error _error_OB_WAIT_DEGRATION_TIMEOUT = {
      .error_name            = "OB_WAIT_DEGRATION_TIMEOUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "wait degration finished timeout",
      .str_user_error        = "wait degration finished timeout",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4751, wait degration finished timeout",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4751, wait degration finished timeout",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4751, wait degration finished timeout",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4751, wait degration finished timeout"
};
static const _error _error_OB_ERR_ROOTSERVICE_START = {
      .error_name            = "OB_ERR_ROOTSERVICE_START",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rootservice start process has failure",
      .str_user_error        = "rootservice start process has failure",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4752, rootservice start process has failure",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4752, rootservice start process has failure",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4752, rootservice start process has failure",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4752, rootservice start process has failure"
};
static const _error _error_OB_ERR_ROOTSERVICE_STOP = {
      .error_name            = "OB_ERR_ROOTSERVICE_STOP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rootservice stop process has failure",
      .str_user_error        = "rootservice stop process has failure",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4753, rootservice stop process has failure",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4753, rootservice stop process has failure",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4753, rootservice stop process has failure",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4753, rootservice stop process has failure"
};
static const _error _error_OB_ERR_ROOT_INSPECTION = {
      .error_name            = "OB_ERR_ROOT_INSPECTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "root inspection is not passed",
      .str_user_error        = "root inspection is not passed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4754, root inspection is not passed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4754, root inspection is not passed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4754, root inspection is not passed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4754, root inspection is not passed"
};
static const _error _error_OB_ERR_ROOTSERVICE_THREAD_HUNG = {
      .error_name            = "OB_ERR_ROOTSERVICE_THREAD_HUNG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rootservice background thread may be hung",
      .str_user_error        = "rootservice background thread may be hung",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4755, rootservice background thread may be hung",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4755, rootservice background thread may be hung",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4755, rootservice background thread may be hung",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4755, rootservice background thread may be hung"
};
static const _error _error_OB_MIGRATE_NOT_COMPATIBLE = {
      .error_name            = "OB_MIGRATE_NOT_COMPATIBLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Migration src and dest version is not compatible.",
      .str_user_error        = "Migration src and dest version is not compatible.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4756, Migration src and dest version is not compatible.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4756, Migration src and dest version is not compatible.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4756, Migration src and dest version is not compatible.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4756, Migration src and dest version is not compatible."
};
static const _error _error_OB_CLUSTER_INFO_MAYBE_REMAINED = {
      .error_name            = "OB_CLUSTER_INFO_MAYBE_REMAINED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Cluster info may remain on arbitration server '%.*s', please make sure whether to use ob_admin to clean it.",
      .str_user_error        = "Cluster info may remain on arbitration server '%.*s', please make sure whether to use ob_admin to clean it.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4757, Cluster info may remain on arbitration server '%.*s', please make sure whether to use ob_admin to clean it.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4757, Cluster info may remain on arbitration server '%.*s', please make sure whether to use ob_admin to clean it.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4757, Cluster info may remain on arbitration server '%.*s', please make sure whether to use ob_admin to clean it.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4757, Cluster info may remain on arbitration server '%.*s', please make sure whether to use ob_admin to clean it."
};
static const _error _error_OB_ARBITRATION_INFO_QUERY_FAILED = {
      .error_name            = "OB_ARBITRATION_INFO_QUERY_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "the arbitration service may be unavailable, please check and retry",
      .str_user_error        = "the arbitration service may be unavailable, please check and retry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4758, the arbitration service may be unavailable, please check and retry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4758, the arbitration service may be unavailable, please check and retry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4758, the arbitration service may be unavailable, please check and retry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4758, the arbitration service may be unavailable, please check and retry"
};
static const _error _error_OB_IGNORE_ERR_ACCESS_VIRTUAL_TABLE = {
      .error_name            = "OB_IGNORE_ERR_ACCESS_VIRTUAL_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "An error was ignored when accessing virtual table, actual error code: %d",
      .str_user_error        = "An error was ignored when accessing virtual table, actual error code: %d",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4759, An error was ignored when accessing virtual table, actual error code: %d",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4759, An error was ignored when accessing virtual table, actual error code: %d",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4759, An error was ignored when accessing virtual table, actual error code: %d",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4759, An error was ignored when accessing virtual table, actual error code: %d"
};
static const _error _error_OB_LS_OFFLINE = {
      .error_name            = "OB_LS_OFFLINE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream is offline",
      .str_user_error        = "log stream is offline",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4760, log stream is offline",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4760, log stream is offline",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4760, log stream is offline",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4760, log stream is offline"
};
static const _error _error_OB_LS_IS_DELETED = {
      .error_name            = "OB_LS_IS_DELETED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream is deleted",
      .str_user_error        = "log stream is deleted",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4761, log stream is deleted",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4761, log stream is deleted",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4761, log stream is deleted",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4761, log stream is deleted"
};
static const _error _error_OB_SKIP_CHECKING_LS_STATUS = {
      .error_name            = "OB_SKIP_CHECKING_LS_STATUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "This operation has been finished without checking ls status",
      .str_user_error        = "This operation has been finished without checking ls status",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4762, This operation has been finished without checking ls status",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4762, This operation has been finished without checking ls status",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4762, This operation has been finished without checking ls status",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4762, This operation has been finished without checking ls status"
};
static const _error _error_OB_ERR_USE_ROWID_FOR_UPDATE = {
      .error_name            = "OB_ERR_USE_ROWID_FOR_UPDATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid user.table.column, table.column, or column specification",
      .str_user_error        = "invalid user.table.column, table.column, or column specification",
      .oracle_errno          = 1747,
      .oracle_str_error      = "ORA-01747: invalid user.table.column, table.column, or column specification",
      .oracle_str_user_error = "ORA-01747: invalid user.table.column, table.column, or column specification",
      .ob_str_error          = "OBE-01747: invalid user.table.column, table.column, or column specification",
      .ob_str_user_error     = "OBE-01747: invalid user.table.column, table.column, or column specification"
};
static const _error _error_OB_ERR_UNKNOWN_SET_OPTION = {
      .error_name            = "OB_ERR_UNKNOWN_SET_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unknown SET option",
      .str_user_error        = "unknown SET option \'%s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: unknown SET option",
      .oracle_str_user_error = "ORA-00600: unknown SET option \'%s\'",
      .ob_str_error          = "OBE-00600: unknown SET option",
      .ob_str_user_error     = "OBE-00600: unknown SET option \'%s\'"
};
static const _error _error_OB_CREATE_STANDBY_TENANT_FAILED = {
      .error_name            = "OB_CREATE_STANDBY_TENANT_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "create standby tenant may fail",
      .str_user_error        = "create standby tenant may fail, %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4765, create standby tenant may fail",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4765, create standby tenant may fail, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4765, create standby tenant may fail",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4765, create standby tenant may fail, %s"
};
static const _error _error_OB_LS_WAITING_SAFE_DESTROY = {
      .error_name            = "OB_LS_WAITING_SAFE_DESTROY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ls waiting safe destory",
      .str_user_error        = "ls waiting safe destory, %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4766, ls waiting safe destory",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4766, ls waiting safe destory, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4766, ls waiting safe destory",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4766, ls waiting safe destory, %s"
};
static const _error _error_OB_LS_NOT_LEADER = {
      .error_name            = "OB_LS_NOT_LEADER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "log stream is not leader log stream",
      .str_user_error        = "log stream is not leader log stream",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4767, log stream is not leader log stream",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4767, log stream is not leader log stream",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4767, log stream is not leader log stream",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4767, log stream is not leader log stream"
};
static const _error _error_OB_LS_LOCK_CONFLICT = {
      .error_name            = "OB_LS_LOCK_CONFLICT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ls lock conflict",
      .str_user_error        = "ls lock conflict, %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4768, ls lock conflict",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4768, ls lock conflict, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4768, ls lock conflict",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4768, ls lock conflict, %s"
};
static const _error _error_OB_INVALID_ROOT_KEY = {
      .error_name            = "OB_INVALID_ROOT_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid root key",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4769, invalid root key",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4769, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4769, invalid root key",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4769, %s"
};
static const _error _error_OB_CONFLICT_WITH_CLONE = {
      .error_name            = "OB_CONFLICT_WITH_CLONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "conflict case with clone operation",
      .str_user_error        = "Tenant (%ld) is in %s procedure, %s not allowed now",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4770, conflict case with clone operation",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4770, Tenant (%ld) is in %s procedure, %s not allowed now",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4770, conflict case with clone operation",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4770, Tenant (%ld) is in %s procedure, %s not allowed now"
};
static const _error _error_OB_BREAK_BY_TEST = {
      .error_name            = "OB_BREAK_BY_TEST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "process is breaked by test case",
      .str_user_error        = "process is breaked by test case",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4771, process is breaked by test case",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4771, process is breaked by test case",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4771, process is breaked by test case",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4771, process is breaked by test case"
};
static const _error _error_OB_TABLES_DIFFERENT_DEFINITIONS = {
      .error_name            = "OB_TABLES_DIFFERENT_DEFINITIONS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TABLES_DIFFERENT_METADATA,
      .sqlstate              = "HY000",
      .str_error             = "Tables have different definitions",
      .str_user_error        = "Tables have different definitions",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4772, Tables have different definitions",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4772, Tables have different definitions",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4772, Tables have different definitions",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4772, Tables have different definitions"
};
static const _error _error_OB_ERR_PARTITION_EXCHANGE_DIFFERENT_OPTION = {
      .error_name            = "OB_ERR_PARTITION_EXCHANGE_DIFFERENT_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_EXCHANGE_DIFFERENT_OPTION,
      .sqlstate              = "HY000",
      .str_error             = "Non matching attribute between partition and table",
      .str_user_error        = "Non matching attribute '%s' between partition and table",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4773, Non matching attribute between partition and table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4773, Non matching attribute '%s' between partition and table",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4773, Non matching attribute between partition and table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4773, Non matching attribute '%s' between partition and table"
};
static const _error _error_OB_ERR_COLUMNS_NUMBER_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION = {
      .error_name            = "OB_ERR_COLUMNS_NUMBER_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tables in ALTER TABLE EXCHANGE PARTITION must have the same number of columns",
      .str_user_error        = "tables in ALTER TABLE EXCHANGE PARTITION must have the same number of columns",
      .oracle_errno          = 14096,
      .oracle_str_error      = "ORA-14096: tables in ALTER TABLE EXCHANGE PARTITION must have the same number of columns",
      .oracle_str_user_error = "ORA-14096: tables in ALTER TABLE EXCHANGE PARTITION must have the same number of columns",
      .ob_str_error          = "OBE-14096: tables in ALTER TABLE EXCHANGE PARTITION must have the same number of columns",
      .ob_str_user_error     = "OBE-14096: tables in ALTER TABLE EXCHANGE PARTITION must have the same number of columns"
};
static const _error _error_OB_ERR_COLUMN_TYPE_OR_SIZE_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION = {
      .error_name            = "OB_ERR_COLUMN_TYPE_OR_SIZE_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "column type or size mismatch in ALTER TABLE EXCHANGE PARTITION",
      .str_user_error        = "column type or size mismatch in ALTER TABLE EXCHANGE PARTITION",
      .oracle_errno          = 14097,
      .oracle_str_error      = "ORA-14097: column type or size mismatch in ALTER TABLE EXCHANGE PARTITION",
      .oracle_str_user_error = "ORA-14097: column type or size mismatch in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_error          = "OBE-14097: column type or size mismatch in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_user_error     = "OBE-14097: column type or size mismatch in ALTER TABLE EXCHANGE PARTITION"
};
static const _error _error_OB_ERR_INDEX_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION = {
      .error_name            = "OB_ERR_INDEX_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "index mismatch for tables in ALTER TABLE EXCHANGE PARTITION",
      .str_user_error        = "index mismatch for tables in ALTER TABLE EXCHANGE PARTITION",
      .oracle_errno          = 14098,
      .oracle_str_error      = "ORA-14098: index mismatch for tables in ALTER TABLE EXCHANGE PARTITION",
      .oracle_str_user_error = "ORA-14098: index mismatch for tables in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_error          = "OBE-14098: index mismatch for tables in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_user_error     = "OBE-14098: index mismatch for tables in ALTER TABLE EXCHANGE PARTITION"
};
static const _error _error_OB_ERR_CHECK_CONSTRAINT_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION = {
      .error_name            = "OB_ERR_CHECK_CONSTRAINT_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "CHECK constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .str_user_error        = "CHECK constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .oracle_errno          = 14118,
      .oracle_str_error      = "ORA-14118: CHECK constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .oracle_str_user_error = "ORA-14118: CHECK constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_error          = "OBE-14118: CHECK constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_user_error     = "OBE-14118: CHECK constraint mismatch in ALTER TABLE EXCHANGE PARTITION"
};
static const _error _error_OB_ERR_FOREIGN_KEY_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION = {
      .error_name            = "OB_ERR_FOREIGN_KEY_MISMATCH_ALTER_TABLE_EXCHANGE_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "FOREIGN KEY constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .str_user_error        = "FOREIGN KEY constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .oracle_errno          = 14128,
      .oracle_str_error      = "ORA-14128: FOREIGN KEY constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .oracle_str_user_error = "ORA-14128: FOREIGN KEY constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_error          = "OBE-14128: FOREIGN KEY constraint mismatch in ALTER TABLE EXCHANGE PARTITION",
      .ob_str_user_error     = "OBE-14128: FOREIGN KEY constraint mismatch in ALTER TABLE EXCHANGE PARTITION"
};
static const _error _error_OB_ERR_EXCHANGE_COMPOSITE_PARTITION = {
      .error_name            = "OB_ERR_EXCHANGE_COMPOSITE_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_INSTEAD_OF_SUBPARTITION,
      .sqlstate              = "HY000",
      .str_error             = "Subpartitioned table, use subpartition instead of partition",
      .str_user_error        = "Subpartitioned table, use subpartition instead of partition",
      .oracle_errno          = 14291,
      .oracle_str_error      = "ORA-14291: cannot EXCHANGE a composite partition with a non-partitioned table",
      .oracle_str_user_error = "ORA-14291: cannot EXCHANGE a composite partition with a non-partitioned table",
      .ob_str_error          = "OBE-14291: cannot EXCHANGE a composite partition with a non-partitioned table",
      .ob_str_user_error     = "OBE-14291: cannot EXCHANGE a composite partition with a non-partitioned table"
};
static const _error _error_OB_SERVICE_NAME_NOT_FOUND = {
      .error_name            = "OB_SERVICE_NAME_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "This service_name is not found in the tenant",
      .str_user_error        = "This service_name is not found in the tenant",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4780, This service_name is not found in the tenant",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4780, This service_name is not found in the tenant",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4780, This service_name is not found in the tenant",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4780, This service_name is not found in the tenant"
};
static const _error _error_OB_SERVICE_NOT_FULLY_STARTED = {
      .error_name            = "OB_SERVICE_NOT_FULLY_STARTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The service has not started on all servers",
      .str_user_error        = "The service has not started on all servers",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4781, The service has not started on all servers",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4781, The service has not started on all servers",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4781, The service has not started on all servers",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4781, The service has not started on all servers"
};
static const _error _error_OB_NOT_PRIMARY_TENANT = {
      .error_name            = "OB_NOT_PRIMARY_TENANT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The tenant is not PRIMARY",
      .str_user_error        = "The tenant is not PRIMARY",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4782, The tenant is not PRIMARY",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4782, The tenant is not PRIMARY",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4782, The tenant is not PRIMARY",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4782, The tenant is not PRIMARY"
};
static const _error _error_OB_SERVICE_STOPPED = {
      .error_name            = "OB_SERVICE_STOPPED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The service has stopped",
      .str_user_error        = "The service has stopped",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4783, The service has stopped",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4783, The service has stopped",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4783, The service has stopped",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4783, The service has stopped"
};
static const _error _error_OB_SERVER_CONNECTION_ERROR = {
      .error_name            = "OB_SERVER_CONNECTION_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Server '%s' connection error",
      .str_user_error        = "Server '%s' connection error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4784, Server '%s' connection error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4784, Server '%s' connection error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4784, Server '%s' connection error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4784, Server '%s' connection error"
};
static const _error _error_OB_ERR_ATLER_TABLE_ILLEGAL_FK_DROP_INDEX = {
      .error_name            = "OB_ERR_ATLER_TABLE_ILLEGAL_FK_DROP_INDEX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DROP_INDEX_FK,
      .sqlstate              = "HY000",
      .str_error             = "Cannot drop index: needed in a foreign key constraint",
      .str_user_error        = "Cannot drop index '%.*s': needed in a foreign key constraint",
      .oracle_errno          = 02266,
      .oracle_str_error      = "ORA-02266: Cannot drop index: needed in a foreign key constraint",
      .oracle_str_user_error = "ORA-02266: Cannot drop index '%.*s': needed in a foreign key constraint",
      .ob_str_error          = "OBE-02266: Cannot drop index: needed in a foreign key constraint",
      .ob_str_user_error     = "OBE-02266: Cannot drop index '%.*s': needed in a foreign key constraint"
};
static const _error _error_OB_ERR_FLASHBACK_QUERY_EXP_NULL = {
      .error_name            = "OB_ERR_FLASHBACK_QUERY_EXP_NULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "NULL snapshot expression not allowed here",
      .str_user_error        = "NULL snapshot expression not allowed here",
      .oracle_errno          = 30055,
      .oracle_str_error      = "ORA-30055: NULL snapshot expression not allowed here",
      .oracle_str_user_error = "ORA-30055: NULL snapshot expression not allowed here",
      .ob_str_error          = "OBE-30055: NULL snapshot expression not allowed here",
      .ob_str_user_error     = "OBE-30055: NULL snapshot expression not allowed here"
};
static const _error _error_OB_RELEASE_MDS_NODE_ERROR = {
      .error_name            = "OB_RELEASE_MDS_NODE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Release mds node error",
      .str_user_error        = "Release mds node error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -4787, Release mds node error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -4787, Release mds node error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -4787, Release mds node error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -4787, Release mds node error"
};
static const _error _error_OB_ERR_PARSER_INIT = {
      .error_name            = "OB_ERR_PARSER_INIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARSE_ERROR,
      .sqlstate              = "0B000",
      .str_error             = "Failed to init SQL parser",
      .str_user_error        = "Failed to init SQL parser",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5000, Failed to init SQL parser",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5000, Failed to init SQL parser",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5000, Failed to init SQL parser",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5000, Failed to init SQL parser"
};
static const _error _error_OB_ERR_PARSE_SQL = {
      .error_name            = "OB_ERR_PARSE_SQL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARSE_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Parse error",
      .str_user_error        = "%s near \'%.*s\' at line %d",
      .oracle_errno          = 900,
      .oracle_str_error      = "ORA-00900: invalid SQL statement",
      .oracle_str_user_error = "ORA-00900: %s near \'%.*s\' at line %d",
      .ob_str_error          = "OBE-00900: invalid SQL statement",
      .ob_str_user_error     = "OBE-00900: %s near \'%.*s\' at line %d"
};
static const _error _error_OB_ERR_RESOLVE_SQL = {
      .error_name            = "OB_ERR_RESOLVE_SQL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Resolve error",
      .str_user_error        = "Resolve error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5002, Resolve error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5002, Resolve error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5002, Resolve error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5002, Resolve error"
};
static const _error _error_OB_ERR_GEN_PLAN = {
      .error_name            = "OB_ERR_GEN_PLAN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Generate plan error",
      .str_user_error        = "Generate plan error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5003, Generate plan error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5003, Generate plan error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5003, Generate plan error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5003, Generate plan error"
};
static const _error _error_OB_ERR_PARSER_SYNTAX = {
      .error_name            = "OB_ERR_PARSER_SYNTAX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SYNTAX_ERROR,
      .sqlstate              = "42000",
      .str_error             = "You have an error in your SQL syntax; check the manual that corresponds to your OceanBase version for the right syntax to use",
      .str_user_error        = "You have an error in your SQL syntax; check the manual that corresponds to your OceanBase version for the right syntax to use",
      .oracle_errno          = 900,
      .oracle_str_error      = "ORA-00900: You have an error in your SQL syntax; check the manual that corresponds to your OceanBase version for the right syntax to use",
      .oracle_str_user_error = "ORA-00900: You have an error in your SQL syntax; check the manual that corresponds to your OceanBase version for the right syntax to use",
      .ob_str_error          = "OBE-00900: You have an error in your SQL syntax; check the manual that corresponds to your OceanBase version for the right syntax to use",
      .ob_str_user_error     = "OBE-00900: You have an error in your SQL syntax; check the manual that corresponds to your OceanBase version for the right syntax to use"
};
static const _error _error_OB_ERR_COLUMN_SIZE = {
      .error_name            = "OB_ERR_COLUMN_SIZE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT,
      .sqlstate              = "21000",
      .str_error             = "The used SELECT statements have a different number of columns",
      .str_user_error        = "The used SELECT statements have a different number of columns",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5007, The used SELECT statements have a different number of columns",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5007, The used SELECT statements have a different number of columns",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5007, The used SELECT statements have a different number of columns",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5007, The used SELECT statements have a different number of columns"
};
static const _error _error_OB_ERR_COLUMN_DUPLICATE = {
      .error_name            = "OB_ERR_COLUMN_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DUP_FIELDNAME,
      .sqlstate              = "42S21",
      .str_error             = "Duplicate column name",
      .str_user_error        = "Duplicate column name '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5008, Duplicate column name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5008, Duplicate column name '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5008, Duplicate column name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5008, Duplicate column name '%.*s'"
};
static const _error _error_OB_ERR_OPERATOR_UNKNOWN = {
      .error_name            = "OB_ERR_OPERATOR_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "21000",
      .str_error             = "Unknown operator",
      .str_user_error        = "Unknown operator",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5010, Unknown operator",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5010, Unknown operator",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5010, Unknown operator",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5010, Unknown operator"
};
static const _error _error_OB_ERR_STAR_DUPLICATE = {
      .error_name            = "OB_ERR_STAR_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Duplicated star",
      .str_user_error        = "Duplicated star",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5011, Duplicated star",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5011, Duplicated star",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5011, Duplicated star",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5011, Duplicated star"
};
static const _error _error_OB_ERR_ILLEGAL_ID = {
      .error_name            = "OB_ERR_ILLEGAL_ID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Illegal ID",
      .str_user_error        = "%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5012, Illegal ID",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5012, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5012, Illegal ID",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5012, %s"
};
static const _error _error_OB_ERR_ILLEGAL_VALUE = {
      .error_name            = "OB_ERR_ILLEGAL_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Illegal value",
      .str_user_error        = "Illegal value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5014, Illegal value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5014, Illegal value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5014, Illegal value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5014, Illegal value"
};
static const _error _error_OB_ERR_COLUMN_AMBIGUOUS = {
      .error_name            = "OB_ERR_COLUMN_AMBIGUOUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_AMBIGUOUS_FIELD_TERM,
      .sqlstate              = "42000",
      .str_error             = "Ambiguous column",
      .str_user_error        = "Ambiguous column",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5015, Ambiguous column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5015, Ambiguous column",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5015, Ambiguous column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5015, Ambiguous column"
};
static const _error _error_OB_ERR_LOGICAL_PLAN_FAILD = {
      .error_name            = "OB_ERR_LOGICAL_PLAN_FAILD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Generate logical plan error",
      .str_user_error        = "Generate logical plan error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5016, Generate logical plan error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5016, Generate logical plan error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5016, Generate logical plan error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5016, Generate logical plan error"
};
static const _error _error_OB_ERR_SCHEMA_UNSET = {
      .error_name            = "OB_ERR_SCHEMA_UNSET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Schema not set",
      .str_user_error        = "Schema not set",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5017, Schema not set",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5017, Schema not set",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5017, Schema not set",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5017, Schema not set"
};
static const _error _error_OB_ERR_ILLEGAL_NAME = {
      .error_name            = "OB_ERR_ILLEGAL_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Illegal name",
      .str_user_error        = "Illegal name",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5018, Illegal name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5018, Illegal name",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5018, Illegal name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5018, Illegal name"
};
static const _error _error_OB_TABLE_NOT_EXIST = {
      .error_name            = "OB_TABLE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_SUCH_TABLE,
      .sqlstate              = "42S02",
      .str_error             = "Table doesn\'t exist",
      .str_user_error        = "Table \'%s.%s\' doesn\'t exist",
      .oracle_errno          = 942,
      .oracle_str_error      = "ORA-00942: table or view does not exist",
      .oracle_str_user_error = "ORA-00942: table or view \'%s.%s\' does not exist",
      .ob_str_error          = "OBE-00942: table or view does not exist",
      .ob_str_user_error     = "OBE-00942: table or view \'%s.%s\' does not exist"
};
static const _error _error_OB_ERR_TABLE_EXIST = {
      .error_name            = "OB_ERR_TABLE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TABLE_EXISTS_ERROR,
      .sqlstate              = "42S01",
      .str_error             = "Table already exists",
      .str_user_error        = "Table '%.*s' already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5020, Table already exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5020, Table '%.*s' already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5020, Table already exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5020, Table '%.*s' already exists"
};
static const _error _error_OB_ERR_EXPR_UNKNOWN = {
      .error_name            = "OB_ERR_EXPR_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Unknown expression",
      .str_user_error        = "Unknown expression",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5022, Unknown expression",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5022, Unknown expression",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5022, Unknown expression",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5022, Unknown expression"
};
static const _error _error_OB_ERR_ILLEGAL_TYPE = {
      .error_name            = "OB_ERR_ILLEGAL_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "S1004",
      .str_error             = "Illegal type",
      .str_user_error        = "unsupport MySQL type %d. Maybe you should use java.sql.Timestamp instead of java.util.Date.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5023, Illegal type",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5023, unsupport MySQL type %d. Maybe you should use java.sql.Timestamp instead of java.util.Date.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5023, Illegal type",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5023, unsupport MySQL type %d. Maybe you should use java.sql.Timestamp instead of java.util.Date."
};
static const _error _error_OB_ERR_PRIMARY_KEY_DUPLICATE = {
      .error_name            = "OB_ERR_PRIMARY_KEY_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DUP_ENTRY,
      .sqlstate              = "23000",
      .str_error             = "Duplicated primary key",
      .str_user_error        = "Duplicate entry \'%s\' for key \'%.*s\'",
      .oracle_errno          = 1,
      .oracle_str_error      = "ORA-00001: unique constraint violated",
      .oracle_str_user_error = "ORA-00001: unique constraint \'%s\' for key \'%.*s\' violated",
      .ob_str_error          = "OBE-00001: unique constraint violated",
      .ob_str_user_error     = "OBE-00001: unique constraint \'%s\' for key \'%.*s\' violated"
};
static const _error _error_OB_ERR_KEY_NAME_DUPLICATE = {
      .error_name            = "OB_ERR_KEY_NAME_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DUP_KEYNAME,
      .sqlstate              = "42000",
      .str_error             = "Duplicated key name",
      .str_user_error        = "Duplicate key name \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5025, Duplicated key name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5025, Duplicate key name \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5025, Duplicated key name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5025, Duplicate key name \'%.*s\'"
};
static const _error _error_OB_ERR_CREATETIME_DUPLICATE = {
      .error_name            = "OB_ERR_CREATETIME_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Duplicated createtime",
      .str_user_error        = "Duplicated createtime",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5026, Duplicated createtime",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5026, Duplicated createtime",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5026, Duplicated createtime",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5026, Duplicated createtime"
};
static const _error _error_OB_ERR_MODIFYTIME_DUPLICATE = {
      .error_name            = "OB_ERR_MODIFYTIME_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Duplicated modifytime",
      .str_user_error        = "Duplicated modifytime",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5027, Duplicated modifytime",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5027, Duplicated modifytime",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5027, Duplicated modifytime",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5027, Duplicated modifytime"
};
static const _error _error_OB_ERR_ILLEGAL_INDEX = {
      .error_name            = "OB_ERR_ILLEGAL_INDEX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_SUCH_INDEX,
      .sqlstate              = "42S12",
      .str_error             = "Illegal index",
      .str_user_error        = "Illegal index",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5028, Illegal index",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5028, Illegal index",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5028, Illegal index",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5028, Illegal index"
};
static const _error _error_OB_ERR_INVALID_SCHEMA = {
      .error_name            = "OB_ERR_INVALID_SCHEMA",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid schema",
      .str_user_error        = "Invalid schema",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5029, Invalid schema",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5029, Invalid schema",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5029, Invalid schema",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5029, Invalid schema"
};
static const _error _error_OB_ERR_INSERT_NULL_ROWKEY = {
      .error_name            = "OB_ERR_INSERT_NULL_ROWKEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PRIMARY_CANT_HAVE_NULL,
      .sqlstate              = "42000",
      .str_error             = "Insert null rowkey",
      .str_user_error        = "Insert null into %.*s",
      .oracle_errno          = 1400,
      .oracle_str_error      = "ORA-01400: cannot insert NULL into",
      .oracle_str_user_error = "ORA-01400: cannot insert NULL into (%.*s)",
      .ob_str_error          = "OBE-01400: cannot insert NULL into",
      .ob_str_user_error     = "OBE-01400: cannot insert NULL into (%.*s)"
};
static const _error _error_OB_ERR_COLUMN_NOT_FOUND = {
      .error_name            = "OB_ERR_COLUMN_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Column not found",
      .str_user_error        = "Column not found",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5031, Column not found",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5031, Column not found",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5031, Column not found",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5031, Column not found"
};
static const _error _error_OB_ERR_DELETE_NULL_ROWKEY = {
      .error_name            = "OB_ERR_DELETE_NULL_ROWKEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "23000",
      .str_error             = "Delete null rowkey",
      .str_user_error        = "Delete null rowkey",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5032, Delete null rowkey",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5032, Delete null rowkey",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5032, Delete null rowkey",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5032, Delete null rowkey"
};
static const _error _error_OB_ERR_USER_EMPTY = {
      .error_name            = "OB_ERR_USER_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "01007",
      .str_error             = "No user",
      .str_user_error        = "No user",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5034, No user",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5034, No user",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5034, No user",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5034, No user"
};
static const _error _error_OB_ERR_USER_NOT_EXIST = {
      .error_name            = "OB_ERR_USER_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_SUCH_USER,
      .sqlstate              = "HY000",
      .str_error             = "User not exist",
      .str_user_error        = "User %.*s not exist",
      .oracle_errno          = 1918,
      .oracle_str_error      = "ORA-01918: user does not exist",
      .oracle_str_user_error = "ORA-01918: user '%.*s' does not exist",
      .ob_str_error          = "OBE-01918: user does not exist",
      .ob_str_user_error     = "OBE-01918: user '%.*s' does not exist"
};
static const _error _error_OB_ERR_NO_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SPECIFIC_ACCESS_DENIED_ERROR,
      .sqlstate              = "42501",
      .str_error             = "Access denied",
      .str_user_error        = "Access denied; you need (at least one of) the %s privilege(s) for this operation",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5036, Access denied",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5036, Access denied; you need (at least one of) the %s privilege(s) for this operation",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5036, Access denied",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5036, Access denied; you need (at least one of) the %s privilege(s) for this operation"
};
static const _error _error_OB_ERR_NO_AVAILABLE_PRIVILEGE_ENTRY = {
      .error_name            = "OB_ERR_NO_AVAILABLE_PRIVILEGE_ENTRY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "No privilege entry",
      .str_user_error        = "No privilege entry",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5037, No privilege entry",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5037, No privilege entry",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5037, No privilege entry",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5037, No privilege entry"
};
static const _error _error_OB_ERR_WRONG_PASSWORD = {
      .error_name            = "OB_ERR_WRONG_PASSWORD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PASSWORD_NO_MATCH,
      .sqlstate              = "42000",
      .str_error             = "Incorrect password",
      .str_user_error        = "Incorrect password",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5038, Incorrect password",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5038, Incorrect password",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5038, Incorrect password",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5038, Incorrect password"
};
static const _error _error_OB_ERR_USER_IS_LOCKED = {
      .error_name            = "OB_ERR_USER_IS_LOCKED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ACCOUNT_HAS_BEEN_LOCKED,
      .sqlstate              = "HY000",
      .str_error             = "User locked",
      .str_user_error        = "User locked",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5039, User locked",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5039, User locked",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5039, User locked",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5039, User locked"
};
static const _error _error_OB_ERR_UPDATE_ROWKEY_COLUMN = {
      .error_name            = "OB_ERR_UPDATE_ROWKEY_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Can not update rowkey column",
      .str_user_error        = "Can not update rowkey column",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5040, Can not update rowkey column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5040, Can not update rowkey column",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5040, Can not update rowkey column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5040, Can not update rowkey column"
};
static const _error _error_OB_ERR_UPDATE_JOIN_COLUMN = {
      .error_name            = "OB_ERR_UPDATE_JOIN_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Can not update join column",
      .str_user_error        = "Can not update join column",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5041, Can not update join column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5041, Can not update join column",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5041, Can not update join column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5041, Can not update join column"
};
static const _error _error_OB_ERR_INVALID_COLUMN_NUM = {
      .error_name            = "OB_ERR_INVALID_COLUMN_NUM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_OPERAND_COLUMNS,
      .sqlstate              = "21000",
      .str_error             = "Invalid column number",
      .str_user_error        = "Operand should contain %ld column(s)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5042, Invalid column number",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5042, Operand should contain %ld column(s)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5042, Invalid column number",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5042, Operand should contain %ld column(s)"
};
static const _error _error_OB_ERR_PREPARE_STMT_NOT_FOUND = {
      .error_name            = "OB_ERR_PREPARE_STMT_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_STMT_HANDLER,
      .sqlstate              = "HY007",
      .str_error             = "Unknown prepared statement",
      .str_user_error        = "statement not prepared, stmt_id=%u",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5043, Unknown prepared statement",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5043, statement not prepared, stmt_id=%u",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5043, Unknown prepared statement",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5043, statement not prepared, stmt_id=%u"
};
static const _error _error_OB_ERR_SYS_VARIABLE_UNKNOWN = {
      .error_name            = "OB_ERR_SYS_VARIABLE_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_SYSTEM_VARIABLE,
      .sqlstate              = "HY000",
      .str_error             = "Unknown system variable",
      .str_user_error        = "Unknown system variable '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5044, Unknown system variable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5044, Unknown system variable '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5044, Unknown system variable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5044, Unknown system variable '%.*s'"
};
static const _error _error_OB_ERR_OLDER_PRIVILEGE_VERSION = {
      .error_name            = "OB_ERR_OLDER_PRIVILEGE_VERSION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Older privilege version",
      .str_user_error        = "Older privilege version",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5046, Older privilege version",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5046, Older privilege version",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5046, Older privilege version",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5046, Older privilege version"
};
static const _error _error_OB_ERR_LACK_OF_ROWKEY_COL = {
      .error_name            = "OB_ERR_LACK_OF_ROWKEY_COL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_REQUIRES_PRIMARY_KEY,
      .sqlstate              = "42000",
      .str_error             = "No rowkey column specified",
      .str_user_error        = "Primary key column(s) not specified in the WHERE clause",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5047, No rowkey column specified",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5047, Primary key column(s) not specified in the WHERE clause",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5047, No rowkey column specified",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5047, Primary key column(s) not specified in the WHERE clause"
};
static const _error _error_OB_ERR_USER_EXIST = {
      .error_name            = "OB_ERR_USER_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42710",
      .str_error             = "User exists",
      .str_user_error        = "User exists",
      .oracle_errno          = 1920,
      .oracle_str_error      = "ORA-01920: user name conflicts with another user or role name",
      .oracle_str_user_error = "ORA-01920: user name conflicts with another user or role name",
      .ob_str_error          = "OBE-01920: user name conflicts with another user or role name",
      .ob_str_user_error     = "OBE-01920: user name conflicts with another user or role name"
};
static const _error _error_OB_ERR_PASSWORD_EMPTY = {
      .error_name            = "OB_ERR_PASSWORD_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Empty password",
      .str_user_error        = "Empty password",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5051, Empty password",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5051, Empty password",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5051, Empty password",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5051, Empty password"
};
static const _error _error_OB_ERR_GRANT_PRIVILEGES_TO_CREATE_TABLE = {
      .error_name            = "OB_ERR_GRANT_PRIVILEGES_TO_CREATE_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Failed to grant privelege",
      .str_user_error        = "Failed to grant privelege",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5052, Failed to grant privelege",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5052, Failed to grant privelege",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5052, Failed to grant privelege",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5052, Failed to grant privelege"
};
static const _error _error_OB_ERR_WRONG_DYNAMIC_PARAM = {
      .error_name            = "OB_ERR_WRONG_DYNAMIC_PARAM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY093",
      .str_error             = "Wrong dynamic parameters",
      .str_user_error        = "Incorrect arguments number to EXECUTE, need %ld arguments but give %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5053, Wrong dynamic parameters",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5053, Incorrect arguments number to EXECUTE, need %ld arguments but give %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5053, Wrong dynamic parameters",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5053, Incorrect arguments number to EXECUTE, need %ld arguments but give %ld"
};
static const _error _error_OB_ERR_PARAM_SIZE = {
      .error_name            = "OB_ERR_PARAM_SIZE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT,
      .sqlstate              = "42000",
      .str_error             = "Incorrect parameter count",
      .str_user_error        = "Incorrect parameter count in the call to native function '%.*s'",
      .oracle_errno          = 909,
      .oracle_str_error      = "ORA-00909: invalid number of arguments",
      .oracle_str_user_error = "ORA-00909: invalid number of arguments in the call to native function '%.*s'",
      .ob_str_error          = "OBE-00909: invalid number of arguments",
      .ob_str_user_error     = "OBE-00909: invalid number of arguments in the call to native function '%.*s'"
};
static const _error _error_OB_ERR_FUNCTION_UNKNOWN = {
      .error_name            = "OB_ERR_FUNCTION_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SP_DOES_NOT_EXIST,
      .sqlstate              = "42000",
      .str_error             = "FUNCTION does not exist",
      .str_user_error        = "%s %.*s does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5055, FUNCTION does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5055, %s %.*s does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5055, FUNCTION does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5055, %s %.*s does not exist"
};
static const _error _error_OB_ERR_CREAT_MODIFY_TIME_COLUMN = {
      .error_name            = "OB_ERR_CREAT_MODIFY_TIME_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "23000",
      .str_error             = "CreateTime or ModifyTime column cannot be modified",
      .str_user_error        = "CreateTime or ModifyTime column cannot be modified",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5056, CreateTime or ModifyTime column cannot be modified",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5056, CreateTime or ModifyTime column cannot be modified",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5056, CreateTime or ModifyTime column cannot be modified",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5056, CreateTime or ModifyTime column cannot be modified"
};
static const _error _error_OB_ERR_MODIFY_PRIMARY_KEY = {
      .error_name            = "OB_ERR_MODIFY_PRIMARY_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "23000",
      .str_error             = "Primary key cannot be modified",
      .str_user_error        = "Primary key cannot be modified",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5057, Primary key cannot be modified",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5057, Primary key cannot be modified",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5057, Primary key cannot be modified",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5057, Primary key cannot be modified"
};
static const _error _error_OB_ERR_PARAM_DUPLICATE = {
      .error_name            = "OB_ERR_PARAM_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Duplicated parameters",
      .str_user_error        = "Duplicated parameters",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5058, Duplicated parameters",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5058, Duplicated parameters",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5058, Duplicated parameters",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5058, Duplicated parameters"
};
static const _error _error_OB_ERR_TOO_MANY_SESSIONS = {
      .error_name            = "OB_ERR_TOO_MANY_SESSIONS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_USER_CONNECTIONS,
      .sqlstate              = "42000",
      .str_error             = "Too many sessions",
      .str_user_error        = "Too many sessions",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5059, Too many sessions",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5059, Too many sessions",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5059, Too many sessions",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5059, Too many sessions"
};
static const _error _error_OB_ERR_TOO_MANY_PS = {
      .error_name            = "OB_ERR_TOO_MANY_PS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "54023",
      .str_error             = "Too many prepared statements",
      .str_user_error        = "Too many prepared statements",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5061, Too many prepared statements",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5061, Too many prepared statements",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5061, Too many prepared statements",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5061, Too many prepared statements"
};
static const _error _error_OB_ERR_HINT_UNKNOWN = {
      .error_name            = "OB_ERR_HINT_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Unknown hint",
      .str_user_error        = "Unknown hint",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5063, Unknown hint",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5063, Unknown hint",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5063, Unknown hint",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5063, Unknown hint"
};
static const _error _error_OB_ERR_WHEN_UNSATISFIED = {
      .error_name            = "OB_ERR_WHEN_UNSATISFIED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "23000",
      .str_error             = "When condition not satisfied",
      .str_user_error        = "When condition not satisfied",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5064, When condition not satisfied",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5064, When condition not satisfied",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5064, When condition not satisfied",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5064, When condition not satisfied"
};
static const _error _error_OB_ERR_QUERY_INTERRUPTED = {
      .error_name            = "OB_ERR_QUERY_INTERRUPTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_QUERY_INTERRUPTED,
      .sqlstate              = "70100",
      .str_error             = "Query execution was interrupted",
      .str_user_error        = "Query execution was interrupted, %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5065, Query execution was interrupted",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5065, Query execution was interrupted, %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5065, Query execution was interrupted",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5065, Query execution was interrupted, %s"
};
static const _error _error_OB_ERR_SESSION_INTERRUPTED = {
      .error_name            = "OB_ERR_SESSION_INTERRUPTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Session interrupted",
      .str_user_error        = "Session interrupted",
      .oracle_errno          = 1092,
      .oracle_str_error      = "ORA-01092: OceanBase instance terminated. Disconnection forced",
      .oracle_str_user_error = "ORA-01092: OceanBase instance terminated. Disconnection forced",
      .ob_str_error          = "OBE-01092: OceanBase instance terminated. Disconnection forced",
      .ob_str_user_error     = "OBE-01092: OceanBase instance terminated. Disconnection forced"
};
static const _error _error_OB_ERR_UNKNOWN_SESSION_ID = {
      .error_name            = "OB_ERR_UNKNOWN_SESSION_ID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unknown session ID",
      .str_user_error        = "Unknown session ID",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5067, Unknown session ID",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5067, Unknown session ID",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5067, Unknown session ID",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5067, Unknown session ID"
};
static const _error _error_OB_ERR_PROTOCOL_NOT_RECOGNIZE = {
      .error_name            = "OB_ERR_PROTOCOL_NOT_RECOGNIZE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Incorrect protocol",
      .str_user_error        = "Incorrect protocol",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5068, Incorrect protocol",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5068, Incorrect protocol",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5068, Incorrect protocol",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5068, Incorrect protocol"
};
static const _error _error_OB_ERR_WRITE_AUTH_ERROR = {
      .error_name            = "OB_ERR_WRITE_AUTH_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Write auth packet error",
      .str_user_error        = "Write auth packet error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5069, Write auth packet error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5069, Write auth packet error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5069, Write auth packet error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5069, Write auth packet error"
};
static const _error _error_OB_ERR_PARSE_JOIN_INFO = {
      .error_name            = "OB_ERR_PARSE_JOIN_INFO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Wrong join info",
      .str_user_error        = "Wrong join info",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5070, Wrong join info",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5070, Wrong join info",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5070, Wrong join info",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5070, Wrong join info"
};
static const _error _error_OB_ERR_ALTER_INDEX_COLUMN = {
      .error_name            = "OB_ERR_ALTER_INDEX_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Cannot alter index column",
      .str_user_error        = "Cannot alter index column",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5071, Cannot alter index column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5071, Cannot alter index column",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5071, Cannot alter index column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5071, Cannot alter index column"
};
static const _error _error_OB_ERR_MODIFY_INDEX_TABLE = {
      .error_name            = "OB_ERR_MODIFY_INDEX_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Cannot modify index table",
      .str_user_error        = "Cannot modify index table",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5072, Cannot modify index table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5072, Cannot modify index table",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5072, Cannot modify index table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5072, Cannot modify index table"
};
static const _error _error_OB_ERR_INDEX_UNAVAILABLE = {
      .error_name            = "OB_ERR_INDEX_UNAVAILABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_SUCH_INDEX,
      .sqlstate              = "42000",
      .str_error             = "Index unavailable",
      .str_user_error        = "Index unavailable",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5073, Index unavailable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5073, Index unavailable",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5073, Index unavailable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5073, Index unavailable"
};
static const _error _error_OB_ERR_NOP_VALUE = {
      .error_name            = "OB_ERR_NOP_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "23000",
      .str_error             = "NOP cannot be used here",
      .str_user_error        = "NOP cannot be used here",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5074, NOP cannot be used here",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5074, NOP cannot be used here",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5074, NOP cannot be used here",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5074, NOP cannot be used here"
};
static const _error _error_OB_ERR_PS_TOO_MANY_PARAM = {
      .error_name            = "OB_ERR_PS_TOO_MANY_PARAM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PS_MANY_PARAM,
      .sqlstate              = "54000",
      .str_error             = "Prepared statement contains too many placeholders",
      .str_user_error        = "Prepared statement contains too many placeholders",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5080, Prepared statement contains too many placeholders",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5080, Prepared statement contains too many placeholders",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5080, Prepared statement contains too many placeholders",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5080, Prepared statement contains too many placeholders"
};
static const _error _error_OB_ERR_READ_ONLY = {
      .error_name            = "OB_ERR_READ_ONLY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "25000",
      .str_error             = "The server is read only now",
      .str_user_error        = "The server is read only now",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5081, The server is read only now",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5081, The server is read only now",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5081, The server is read only now",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5081, The server is read only now"
};
static const _error _error_OB_ERR_INVALID_TYPE_FOR_OP = {
      .error_name            = "OB_ERR_INVALID_TYPE_FOR_OP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "Invalid data type for the operation",
      .str_user_error        = "invalid obj type for type promotion: left_type=%s right_type=%s",
      .oracle_errno          = 932,
      .oracle_str_error      = "ORA-00932: inconsistent datatypes",
      .oracle_str_user_error = "ORA-00932: inconsistent datatypes: left_type=%s right_type=%s",
      .ob_str_error          = "OBE-00932: inconsistent datatypes",
      .ob_str_user_error     = "OBE-00932: inconsistent datatypes: left_type=%s right_type=%s"
};
static const _error _error_OB_ERR_CAST_VARCHAR_TO_BOOL = {
      .error_name            = "OB_ERR_CAST_VARCHAR_TO_BOOL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "Can not cast varchar value to bool type",
      .str_user_error        = "Can not cast varchar value to bool type",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5084, Can not cast varchar value to bool type",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5084, Can not cast varchar value to bool type",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5084, Can not cast varchar value to bool type",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5084, Can not cast varchar value to bool type"
};
static const _error _error_OB_ERR_CAST_VARCHAR_TO_NUMBER = {
      .error_name            = "OB_ERR_CAST_VARCHAR_TO_NUMBER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "Not a number Can not cast varchar value to number type",
      .str_user_error        = "Not a number Can not cast varchar value to number type",
      .oracle_errno          = 1722,
      .oracle_str_error      = "ORA-01722: invalid number",
      .oracle_str_user_error = "ORA-01722: invalid number",
      .ob_str_error          = "OBE-01722: invalid number",
      .ob_str_user_error     = "OBE-01722: invalid number"
};
static const _error _error_OB_ERR_CAST_VARCHAR_TO_TIME = {
      .error_name            = "OB_ERR_CAST_VARCHAR_TO_TIME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "Not timestamp Can not cast varchar value to timestamp type",
      .str_user_error        = "Not timestamp Can not cast varchar value to timestamp type",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5086, Not timestamp Can not cast varchar value to timestamp type",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5086, Not timestamp Can not cast varchar value to timestamp type",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5086, Not timestamp Can not cast varchar value to timestamp type",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5086, Not timestamp Can not cast varchar value to timestamp type"
};
static const _error _error_OB_ERR_CAST_NUMBER_OVERFLOW = {
      .error_name            = "OB_ERR_CAST_NUMBER_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "Result value was out of range when cast to number",
      .str_user_error        = "Result value was out of range when cast to number",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5087, Result value was out of range when cast to number",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5087, Result value was out of range when cast to number",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5087, Result value was out of range when cast to number",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5087, Result value was out of range when cast to number"
};
static const _error _error_OB_INTEGER_PRECISION_OVERFLOW = {
      .error_name            = "OB_INTEGER_PRECISION_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DATA_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "Result value was out of range when casting varchar to number",
      .str_user_error        = "value larger than specified precision(%ld,%ld) allowed for this column",
      .oracle_errno          = 1426,
      .oracle_str_error      = "ORA-01426: numeric overflow",
      .oracle_str_user_error = "ORA-01426: numeric overflow, value larger than specified precision(%ld,%ld) allowed for this column",
      .ob_str_error          = "OBE-01426: numeric overflow",
      .ob_str_user_error     = "OBE-01426: numeric overflow, value larger than specified precision(%ld,%ld) allowed for this column"
};
static const _error _error_OB_DECIMAL_PRECISION_OVERFLOW = {
      .error_name            = "OB_DECIMAL_PRECISION_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DATA_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "Result value was out of range when casting varchar to number",
      .str_user_error        = "value(%s) larger than specified precision(%ld,%ld) allowed for this column",
      .oracle_errno          = 1426,
      .oracle_str_error      = "ORA-01426: numeric overflow",
      .oracle_str_user_error = "ORA-01426: numeric overflow, value(%s) larger than specified precision(%ld,%ld) allowed for this column",
      .ob_str_error          = "OBE-01426: numeric overflow",
      .ob_str_user_error     = "OBE-01426: numeric overflow, value(%s) larger than specified precision(%ld,%ld) allowed for this column"
};
static const _error _error_OB_SCHEMA_NUMBER_PRECISION_OVERFLOW = {
      .error_name            = "OB_SCHEMA_NUMBER_PRECISION_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "Precision was out of range",
      .str_user_error        = "Precision was out of range",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5090, Precision was out of range",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5090, Precision was out of range",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5090, Precision was out of range",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5090, Precision was out of range"
};
static const _error _error_OB_SCHEMA_NUMBER_SCALE_OVERFLOW = {
      .error_name            = "OB_SCHEMA_NUMBER_SCALE_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "Scale value was out of range",
      .str_user_error        = "Scale value was out of range",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5091, Scale value was out of range",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5091, Scale value was out of range",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5091, Scale value was out of range",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5091, Scale value was out of range"
};
static const _error _error_OB_ERR_INDEX_UNKNOWN = {
      .error_name            = "OB_ERR_INDEX_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Unknown index",
      .str_user_error        = "Unknown index",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5092, Unknown index",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5092, Unknown index",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5092, Unknown index",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5092, Unknown index"
};
static const _error _error_OB_NUMERIC_OVERFLOW = {
      .error_name            = "OB_NUMERIC_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DATA_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "Result value was out of range when casting varchar to number",
      .str_user_error        = "Result value was out of range when casting varchar to number",
      .oracle_errno          = 1426,
      .oracle_str_error      = "ORA-01426: numeric overflow",
      .oracle_str_user_error = "ORA-01426: numeric overflow",
      .ob_str_error          = "OBE-01426: numeric overflow",
      .ob_str_user_error     = "OBE-01426: numeric overflow"
};
static const _error _error_OB_ERR_TOO_MANY_JOIN_TABLES = {
      .error_name            = "OB_ERR_TOO_MANY_JOIN_TABLES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "too many joined tables",
      .str_user_error        = "too many joined tables",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5094, too many joined tables",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5094, too many joined tables",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5094, too many joined tables",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5094, too many joined tables"
};
static const _error _error_OB_ERR_DDL_ON_REMOTE_DATABASE = {
      .error_name            = "OB_ERR_DDL_ON_REMOTE_DATABASE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "DDL operations are not allowed on a remote database",
      .str_user_error        = "DDL operations are not allowed on a remote database",
      .oracle_errno          = 2021,
      .oracle_str_error      = "ORA-02021: DDL operations are not allowed on a remote database",
      .oracle_str_user_error = "ORA-02021: DDL operations are not allowed on a remote database",
      .ob_str_error          = "OBE-02021: DDL operations are not allowed on a remote database",
      .ob_str_user_error     = "OBE-02021: DDL operations are not allowed on a remote database"
};
static const _error _error_OB_ERR_MISSING_KEYWORD = {
      .error_name            = "OB_ERR_MISSING_KEYWORD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "missing keyword",
      .str_user_error        = "missing keyword",
      .oracle_errno          = 905,
      .oracle_str_error      = "ORA-00905: missing keyword",
      .oracle_str_user_error = "ORA-00905: missing keyword",
      .ob_str_error          = "OBE-00905: missing keyword",
      .ob_str_user_error     = "OBE-00905: missing keyword"
};
static const _error _error_OB_ERR_DATABASE_LINK_EXPECTED = {
      .error_name            = "OB_ERR_DATABASE_LINK_EXPECTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "database link name expected",
      .str_user_error        = "database link name expected",
      .oracle_errno          = 1729,
      .oracle_str_error      = "ORA-01729: database link name expected",
      .oracle_str_user_error = "ORA-01729: database link name expected",
      .ob_str_error          = "OBE-01729: database link name expected",
      .ob_str_user_error     = "OBE-01729: database link name expected"
};
static const _error _error_OB_ERR_VARCHAR_TOO_LONG = {
      .error_name            = "OB_ERR_VARCHAR_TOO_LONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22001",
      .str_error             = "Varchar value is too long for the column",
      .str_user_error        = "Data too long(%d>%ld) for column '%s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5098, Varchar value is too long for the column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5098, Data too long(%d>%ld) for column '%s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5098, Varchar value is too long for the column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5098, Data too long(%d>%ld) for column '%s'"
};
static const _error _error_OB_ERR_SYS_CONFIG_UNKNOWN = {
      .error_name            = "OB_ERR_SYS_CONFIG_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "System config unknown",
      .str_user_error        = "System config unknown",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5099, System config unknown",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5099, System config unknown",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5099, System config unknown",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5099, System config unknown"
};
static const _error _error_OB_ERR_LOCAL_VARIABLE = {
      .error_name            = "OB_ERR_LOCAL_VARIABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_LOCAL_VARIABLE,
      .sqlstate              = "HY000",
      .str_error             = "Local variable",
      .str_user_error        = "Variable \'%.*s\' is a SESSION variable and can't be used with SET GLOBAL",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5100, Local variable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5100, Variable \'%.*s\' is a SESSION variable and can't be used with SET GLOBAL",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5100, Local variable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5100, Variable \'%.*s\' is a SESSION variable and can't be used with SET GLOBAL"
};
static const _error _error_OB_ERR_GLOBAL_VARIABLE = {
      .error_name            = "OB_ERR_GLOBAL_VARIABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_GLOBAL_VARIABLE,
      .sqlstate              = "HY000",
      .str_error             = "Global variable",
      .str_user_error        = "Variable \'%.*s\' is a GLOBAL variable and should be set with SET GLOBAL",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5101, Global variable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5101, Variable \'%.*s\' is a GLOBAL variable and should be set with SET GLOBAL",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5101, Global variable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5101, Variable \'%.*s\' is a GLOBAL variable and should be set with SET GLOBAL"
};
static const _error _error_OB_ERR_VARIABLE_IS_READONLY = {
      .error_name            = "OB_ERR_VARIABLE_IS_READONLY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_VARIABLE_IS_READONLY,
      .sqlstate              = "HY000",
      .str_error             = "variable is read only",
      .str_user_error        = "%.*s variable '%.*s' is read-only. Use SET %.*s to assign the value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5102, variable is read only",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5102, %.*s variable '%.*s' is read-only. Use SET %.*s to assign the value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5102, variable is read only",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5102, %.*s variable '%.*s' is read-only. Use SET %.*s to assign the value"
};
static const _error _error_OB_ERR_INCORRECT_GLOBAL_LOCAL_VAR = {
      .error_name            = "OB_ERR_INCORRECT_GLOBAL_LOCAL_VAR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INCORRECT_GLOBAL_LOCAL_VAR,
      .sqlstate              = "HY000",
      .str_error             = "incorrect global or local variable",
      .str_user_error        = "Variable '%.*s' is a %.*s variable",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5103, incorrect global or local variable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5103, Variable '%.*s' is a %.*s variable",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5103, incorrect global or local variable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5103, Variable '%.*s' is a %.*s variable"
};
static const _error _error_OB_ERR_EXPIRE_INFO_TOO_LONG = {
      .error_name            = "OB_ERR_EXPIRE_INFO_TOO_LONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Expire expression too long",
      .str_user_error        = "length(%d) of expire_info is larger than the max allowed(%ld)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5104, Expire expression too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5104, length(%d) of expire_info is larger than the max allowed(%ld)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5104, Expire expression too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5104, length(%d) of expire_info is larger than the max allowed(%ld)"
};
static const _error _error_OB_ERR_EXPIRE_COND_TOO_LONG = {
      .error_name            = "OB_ERR_EXPIRE_COND_TOO_LONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Expire condition too long",
      .str_user_error        = "total length(%ld) of expire_info and its expression is larger than the max allowed(%ld)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5105, Expire condition too long",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5105, total length(%ld) of expire_info and its expression is larger than the max allowed(%ld)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5105, Expire condition too long",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5105, total length(%ld) of expire_info and its expression is larger than the max allowed(%ld)"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_EXTRACT = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_EXTRACT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for extract()",
      .str_user_error        = "EXTRACT() expected timestamp or a string as date argument",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5106, Invalid argument for extract()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5106, EXTRACT() expected timestamp or a string as date argument",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5106, Invalid argument for extract()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5106, EXTRACT() expected timestamp or a string as date argument"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_IS = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_IS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for IS operator",
      .str_user_error        = "Invalid operand type for IS operator, lval=%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5107, Invalid argument for IS operator",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5107, Invalid operand type for IS operator, lval=%s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5107, Invalid argument for IS operator",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5107, Invalid operand type for IS operator, lval=%s"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_LENGTH = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_LENGTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for length()",
      .str_user_error        = "function LENGTH() expected a varchar argument",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5108, Invalid argument for length()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5108, function LENGTH() expected a varchar argument",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5108, Invalid argument for length()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5108, function LENGTH() expected a varchar argument"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_SUBSTR = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_SUBSTR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for substr()",
      .str_user_error        = "invalid input format. ret=%d text=%s start=%s length=%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5109, Invalid argument for substr()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5109, invalid input format. ret=%d text=%s start=%s length=%s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5109, Invalid argument for substr()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5109, invalid input format. ret=%d text=%s start=%s length=%s"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_TIME_TO_USEC = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_TIME_TO_USEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for time_to_usec()",
      .str_user_error        = "TIME_TO_USEC() expected timestamp or a string as date argument",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5110, Invalid argument for time_to_usec()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5110, TIME_TO_USEC() expected timestamp or a string as date argument",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5110, Invalid argument for time_to_usec()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5110, TIME_TO_USEC() expected timestamp or a string as date argument"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_USEC_TO_TIME = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_USEC_TO_TIME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for usec_to_time()",
      .str_user_error        = "USEC_TO_TIME expected a integer number as usec argument",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5111, Invalid argument for usec_to_time()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5111, USEC_TO_TIME expected a integer number as usec argument",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5111, Invalid argument for usec_to_time()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5111, USEC_TO_TIME expected a integer number as usec argument"
};
static const _error _error_OB_ERR_USER_VARIABLE_UNKNOWN = {
      .error_name            = "OB_ERR_USER_VARIABLE_UNKNOWN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42P01",
      .str_error             = "Unknown user variable",
      .str_user_error        = "Variable %.*s does not exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5112, Unknown user variable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5112, Variable %.*s does not exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5112, Unknown user variable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5112, Variable %.*s does not exists"
};
static const _error _error_OB_ILLEGAL_USAGE_OF_MERGING_FROZEN_TIME = {
      .error_name            = "OB_ILLEGAL_USAGE_OF_MERGING_FROZEN_TIME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Illegal usage of merging_frozen_time()",
      .str_user_error        = "MERGING_FROZEN_TIME() system function only be used in daily merging.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5113, Illegal usage of merging_frozen_time()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5113, MERGING_FROZEN_TIME() system function only be used in daily merging.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5113, Illegal usage of merging_frozen_time()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5113, MERGING_FROZEN_TIME() system function only be used in daily merging."
};
static const _error _error_OB_INVALID_NUMERIC = {
      .error_name            = "OB_INVALID_NUMERIC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid numeric",
      .str_user_error        = "Invalid numeric char '%c'",
      .oracle_errno          = 1722,
      .oracle_str_error      = "ORA-01722: invalid number",
      .oracle_str_user_error = "ORA-01722: invalid number char '%c'",
      .ob_str_error          = "OBE-01722: invalid number",
      .ob_str_user_error     = "OBE-01722: invalid number char '%c'"
};
static const _error _error_OB_ERR_REGEXP_ERROR = {
      .error_name            = "OB_ERR_REGEXP_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_REGEXP_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Got error from regexp",
      .str_user_error        = "Got error '%s' from regexp",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5115, Got error from regexp",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5115, Got error '%s' from regexp",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5115, Got error from regexp",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5115, Got error '%s' from regexp"
};
static const _error _error_OB_SQL_LOG_OP_SETCHILD_OVERFLOW = {
      .error_name            = "OB_SQL_LOG_OP_SETCHILD_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Logical operator child index overflow",
      .str_user_error        = "Logical operator child index overflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5116, Logical operator child index overflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5116, Logical operator child index overflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5116, Logical operator child index overflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5116, Logical operator child index overflow"
};
static const _error _error_OB_SQL_EXPLAIN_FAILED = {
      .error_name            = "OB_SQL_EXPLAIN_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to explain plan",
      .str_user_error        = "fail to explain plan",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5117, fail to explain plan",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5117, fail to explain plan",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5117, fail to explain plan",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5117, fail to explain plan"
};
static const _error _error_OB_SQL_OPT_COPY_OP_FAILED = {
      .error_name            = "OB_SQL_OPT_COPY_OP_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to copy logical operator",
      .str_user_error        = "fail to copy logical operator",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5118, fail to copy logical operator",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5118, fail to copy logical operator",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5118, fail to copy logical operator",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5118, fail to copy logical operator"
};
static const _error _error_OB_SQL_OPT_GEN_PLAN_FALIED = {
      .error_name            = "OB_SQL_OPT_GEN_PLAN_FALIED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to generate plan",
      .str_user_error        = "fail to generate plan",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5119, fail to generate plan",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5119, fail to generate plan",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5119, fail to generate plan",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5119, fail to generate plan"
};
static const _error _error_OB_SQL_OPT_CREATE_RAWEXPR_FAILED = {
      .error_name            = "OB_SQL_OPT_CREATE_RAWEXPR_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to create raw expr",
      .str_user_error        = "fail to create raw expr",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5120, fail to create raw expr",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5120, fail to create raw expr",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5120, fail to create raw expr",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5120, fail to create raw expr"
};
static const _error _error_OB_SQL_OPT_JOIN_ORDER_FAILED = {
      .error_name            = "OB_SQL_OPT_JOIN_ORDER_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "fail to generate join order",
      .str_user_error        = "fail to generate join order",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5121, fail to generate join order",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5121, fail to generate join order",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5121, fail to generate join order",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5121, fail to generate join order"
};
static const _error _error_OB_SQL_OPT_ERROR = {
      .error_name            = "OB_SQL_OPT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "optimizer general error",
      .str_user_error        = "optimizer general error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5122, optimizer general error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5122, optimizer general error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5122, optimizer general error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5122, optimizer general error"
};
static const _error _error_OB_ERR_OCI_INIT_TIMEZONE = {
      .error_name            = "OB_ERR_OCI_INIT_TIMEZONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "failure to initialize timezone information",
      .str_user_error        = "failure to initialize timezone information",
      .oracle_errno          = 1804,
      .oracle_str_error      = "ORA-01804: failure to initialize timezone information",
      .oracle_str_user_error = "ORA-01804: failure to initialize timezone information",
      .ob_str_error          = "OBE-01804: failure to initialize timezone information",
      .ob_str_user_error     = "OBE-01804: failure to initialize timezone information"
};
static const _error _error_OB_ERR_ZLIB_DATA = {
      .error_name            = "OB_ERR_ZLIB_DATA",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ZLIB_Z_DATA_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "ZLIB: Input data corrupted",
      .str_user_error        = "ZLIB: Input data corrupted",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5124, ZLIB: Input data corrupted",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5124, ZLIB: Input data corrupted",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5124, ZLIB: Input data corrupted",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5124, ZLIB: Input data corrupted"
};
static const _error _error_OB_ERR_DBLINK_SESSION_KILLED = {
      .error_name            = "OB_ERR_DBLINK_SESSION_KILLED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "your session has been killed",
      .str_user_error        = "your session has been killed",
      .oracle_errno          = 28,
      .oracle_str_error      = "ORA-00028: your session has been killed",
      .oracle_str_user_error = "ORA-00028: your session has been killed",
      .ob_str_error          = "OBE-00028: your session has been killed",
      .ob_str_user_error     = "OBE-00028: your session has been killed"
};
static const _error _error_OB_SQL_RESOLVER_NO_MEMORY = {
      .error_name            = "OB_SQL_RESOLVER_NO_MEMORY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "sql resolver no memory",
      .str_user_error        = "sql resolver no memory",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5130, sql resolver no memory",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5130, sql resolver no memory",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5130, sql resolver no memory",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5130, sql resolver no memory"
};
static const _error _error_OB_SQL_DML_ONLY = {
      .error_name            = "OB_SQL_DML_ONLY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan cache support dml only",
      .str_user_error        = "plan cache support dml only",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5131, plan cache support dml only",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5131, plan cache support dml only",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5131, plan cache support dml only",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5131, plan cache support dml only"
};
static const _error _error_OB_ERR_NO_GRANT = {
      .error_name            = "OB_ERR_NO_GRANT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "No such grant defined",
      .str_user_error        = "No such grant defined",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5133, No such grant defined",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5133, No such grant defined",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5133, No such grant defined",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5133, No such grant defined"
};
static const _error _error_OB_ERR_NO_DB_SELECTED = {
      .error_name            = "OB_ERR_NO_DB_SELECTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_DB_ERROR,
      .sqlstate              = "3D000",
      .str_error             = "No database selected",
      .str_user_error        = "No database selected",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5134, No database selected",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5134, No database selected",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5134, No database selected",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5134, No database selected"
};
static const _error _error_OB_SQL_PC_OVERFLOW = {
      .error_name            = "OB_SQL_PC_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan cache is overflow",
      .str_user_error        = "plan cache is overflow",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5135, plan cache is overflow",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5135, plan cache is overflow",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5135, plan cache is overflow",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5135, plan cache is overflow"
};
static const _error _error_OB_SQL_PC_PLAN_DUPLICATE = {
      .error_name            = "OB_SQL_PC_PLAN_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan exists in plan cache already",
      .str_user_error        = "plan exists in plan cache already",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5136, plan exists in plan cache already",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5136, plan exists in plan cache already",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5136, plan exists in plan cache already",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5136, plan exists in plan cache already"
};
static const _error _error_OB_SQL_PC_PLAN_EXPIRE = {
      .error_name            = "OB_SQL_PC_PLAN_EXPIRE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan is expired",
      .str_user_error        = "plan is expired",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5137, plan is expired",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5137, plan is expired",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5137, plan is expired",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5137, plan is expired"
};
static const _error _error_OB_SQL_PC_NOT_EXIST = {
      .error_name            = "OB_SQL_PC_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "no plan exist",
      .str_user_error        = "no plan exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5138, no plan exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5138, no plan exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5138, no plan exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5138, no plan exist"
};
static const _error _error_OB_SQL_PARAMS_LIMIT = {
      .error_name            = "OB_SQL_PARAMS_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "too many params, plan cache not support",
      .str_user_error        = "too many params, plan cache not support",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5139, too many params, plan cache not support",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5139, too many params, plan cache not support",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5139, too many params, plan cache not support",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5139, too many params, plan cache not support"
};
static const _error _error_OB_SQL_PC_PLAN_SIZE_LIMIT = {
      .error_name            = "OB_SQL_PC_PLAN_SIZE_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "plan is too big to add to plan cache",
      .str_user_error        = "plan is too big to add to plan cache",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5140, plan is too big to add to plan cache",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5140, plan is too big to add to plan cache",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5140, plan is too big to add to plan cache",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5140, plan is too big to add to plan cache"
};
static const _error _error_OB_ERR_UNKNOWN_CHARSET = {
      .error_name            = "OB_ERR_UNKNOWN_CHARSET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_CHARACTER_SET,
      .sqlstate              = "42000",
      .str_error             = "Unknown character set",
      .str_user_error        = "Unknown character set: '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5142, Unknown character set",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5142, Unknown character set: '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5142, Unknown character set",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5142, Unknown character set: '%.*s'"
};
static const _error _error_OB_ERR_UNKNOWN_COLLATION = {
      .error_name            = "OB_ERR_UNKNOWN_COLLATION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_COLLATION,
      .sqlstate              = "HY000",
      .str_error             = "Unknown collation",
      .str_user_error        = "Unknown collation: '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5143, Unknown collation",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5143, Unknown collation: '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5143, Unknown collation",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5143, Unknown collation: '%.*s'"
};
static const _error _error_OB_ERR_COLLATION_MISMATCH = {
      .error_name            = "OB_ERR_COLLATION_MISMATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_COLLATION_CHARSET_MISMATCH,
      .sqlstate              = "42000",
      .str_error             = "The collation is not valid for the character set",
      .str_user_error        = "COLLATION '%.*s' is not valid for CHARACTER SET '%.*s'",
      .oracle_errno          = 12704,
      .oracle_str_error      = "ORA-12704: character set mismatch",
      .oracle_str_user_error = "ORA-12704: COLLATION '%.*s' is not valid for CHARACTER SET '%.*s'",
      .ob_str_error          = "OBE-12704: character set mismatch",
      .ob_str_user_error     = "OBE-12704: COLLATION '%.*s' is not valid for CHARACTER SET '%.*s'"
};
static const _error _error_OB_ERR_WRONG_VALUE_FOR_VAR = {
      .error_name            = "OB_ERR_WRONG_VALUE_FOR_VAR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_VALUE_FOR_VAR,
      .sqlstate              = "42000",
      .str_error             = "Variable can't be set to the value",
      .str_user_error        = "Variable \'%.*s\' can't be set to the value of \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5145, Variable can't be set to the value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5145, Variable \'%.*s\' can't be set to the value of \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5145, Variable can't be set to the value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5145, Variable \'%.*s\' can't be set to the value of \'%.*s\'"
};
static const _error _error_OB_UNKNOWN_PARTITION = {
      .error_name            = "OB_UNKNOWN_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_PARTITION,
      .sqlstate              = "HY000",
      .str_error             = "Unknown partition",
      .str_user_error        = "Unkown partition '%.*s' in table '%.*s'",
      .oracle_errno          = 2149,
      .oracle_str_error      = "ORA-02149: Specified partition does not exist",
      .oracle_str_user_error = "ORA-02149: Specified partition does not exist '%.*s' in table '%.*s'",
      .ob_str_error          = "OBE-02149: Specified partition does not exist",
      .ob_str_user_error     = "OBE-02149: Specified partition does not exist '%.*s' in table '%.*s'"
};
static const _error _error_OB_PARTITION_NOT_MATCH = {
      .error_name            = "OB_PARTITION_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET,
      .sqlstate              = "HY000",
      .str_error             = "Found a row not matching the given partition set",
      .str_user_error        = "Found a row not matching the given partition set",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5147, Found a row not matching the given partition set",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5147, Found a row not matching the given partition set",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5147, Found a row not matching the given partition set",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5147, Found a row not matching the given partition set"
};
static const _error _error_OB_ER_PASSWD_LENGTH = {
      .error_name            = "OB_ER_PASSWD_LENGTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = " Password hash should be a 40-digit hexadecimal number",
      .str_user_error        = " Password hash should be a 40-digit hexadecimal number",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5148,  Password hash should be a 40-digit hexadecimal number",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5148,  Password hash should be a 40-digit hexadecimal number",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5148,  Password hash should be a 40-digit hexadecimal number",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5148,  Password hash should be a 40-digit hexadecimal number"
};
static const _error _error_OB_ERR_INSERT_INNER_JOIN_COLUMN = {
      .error_name            = "OB_ERR_INSERT_INNER_JOIN_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "07000",
      .str_error             = "Insert inner join column error",
      .str_user_error        = "Insert inner join column error",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5149, Insert inner join column error",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5149, Insert inner join column error",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5149, Insert inner join column error",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5149, Insert inner join column error"
};
static const _error _error_OB_TENANT_NOT_IN_SERVER = {
      .error_name            = "OB_TENANT_NOT_IN_SERVER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Tenant not in this server",
      .str_user_error        = "Tenant not in this server",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5150, Tenant not in this server",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5150, Tenant not in this server",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5150, Tenant not in this server",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5150, Tenant not in this server"
};
static const _error _error_OB_TABLEGROUP_NOT_EXIST = {
      .error_name            = "OB_TABLEGROUP_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42P01",
      .str_error             = "tablegroup not exist",
      .str_user_error        = "tablegroup not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5151, tablegroup not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5151, tablegroup not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5151, tablegroup not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5151, tablegroup not exist"
};
static const _error _error_OB_SUBQUERY_TOO_MANY_ROW = {
      .error_name            = "OB_SUBQUERY_TOO_MANY_ROW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SUBQUERY_NO_1_ROW,
      .sqlstate              = "21000",
      .str_error             = "Subquery returns more than 1 row",
      .str_user_error        = "Subquery returns more than 1 row",
      .oracle_errno          = 1427,
      .oracle_str_error      = "ORA-01427: single-row subquery returns more than one row",
      .oracle_str_user_error = "ORA-01427: single-row subquery returns more than one row",
      .ob_str_error          = "OBE-01427: single-row subquery returns more than one row",
      .ob_str_user_error     = "OBE-01427: single-row subquery returns more than one row"
};
static const _error _error_OB_ERR_BAD_DATABASE = {
      .error_name            = "OB_ERR_BAD_DATABASE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_BAD_DB_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Unknown database",
      .str_user_error        = "Unknown database '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5154, Unknown database",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5154, Unknown database '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5154, Unknown database",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5154, Unknown database '%.*s'"
};
static const _error _error_OB_CANNOT_USER = {
      .error_name            = "OB_CANNOT_USER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANNOT_USER,
      .sqlstate              = "HY000",
      .str_error             = "User operation failed",
      .str_user_error        = "Operation %.*s failed for %.*s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5155, User operation failed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5155, Operation %.*s failed for %.*s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5155, User operation failed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5155, Operation %.*s failed for %.*s"
};
static const _error _error_OB_TENANT_EXIST = {
      .error_name            = "OB_TENANT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tenant already exist",
      .str_user_error        = "tenant \'%s\' already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5156, tenant already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5156, tenant \'%s\' already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5156, tenant already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5156, tenant \'%s\' already exist"
};
static const _error _error_OB_TENANT_NOT_EXIST = {
      .error_name            = "OB_TENANT_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Unknown tenant",
      .str_user_error        = "Unknown tenant '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5157, Unknown tenant",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5157, Unknown tenant '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5157, Unknown tenant",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5157, Unknown tenant '%.*s'"
};
static const _error _error_OB_DATABASE_EXIST = {
      .error_name            = "OB_DATABASE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DB_CREATE_EXISTS,
      .sqlstate              = "HY000",
      .str_error             = "Can't create database;database exists",
      .str_user_error        = "Can't create database '%.*s'; database exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5158, Can't create database;database exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5158, Can't create database '%.*s'; database exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5158, Can't create database;database exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5158, Can't create database '%.*s'; database exists"
};
static const _error _error_OB_TABLEGROUP_EXIST = {
      .error_name            = "OB_TABLEGROUP_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tablegroup already exist",
      .str_user_error        = "tablegroup already exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5159, tablegroup already exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5159, tablegroup already exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5159, tablegroup already exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5159, tablegroup already exist"
};
static const _error _error_OB_ERR_INVALID_TENANT_NAME = {
      .error_name            = "OB_ERR_INVALID_TENANT_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid tenant name specified in connection string",
      .str_user_error        = "invalid tenant name specified in connection string",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5160, invalid tenant name specified in connection string",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5160, invalid tenant name specified in connection string",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5160, invalid tenant name specified in connection string",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5160, invalid tenant name specified in connection string"
};
static const _error _error_OB_EMPTY_TENANT = {
      .error_name            = "OB_EMPTY_TENANT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "tenant is empty",
      .str_user_error        = "tenant is empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5161, tenant is empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5161, tenant is empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5161, tenant is empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5161, tenant is empty"
};
static const _error _error_OB_WRONG_DB_NAME = {
      .error_name            = "OB_WRONG_DB_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_DB_NAME,
      .sqlstate              = "42000",
      .str_error             = "Incorrect database name",
      .str_user_error        = "Incorrect database name '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5162, Incorrect database name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5162, Incorrect database name '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5162, Incorrect database name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5162, Incorrect database name '%.*s'"
};
static const _error _error_OB_WRONG_TABLE_NAME = {
      .error_name            = "OB_WRONG_TABLE_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_TABLE_NAME,
      .sqlstate              = "42000",
      .str_error             = "Incorrect table name",
      .str_user_error        = "Incorrect table name '%.*s'",
      .oracle_errno          = 903,
      .oracle_str_error      = "ORA-00903: invalid table name",
      .oracle_str_user_error = "ORA-00903: invalid table name '%.*s'",
      .ob_str_error          = "OBE-00903: invalid table name",
      .ob_str_user_error     = "OBE-00903: invalid table name '%.*s'"
};
static const _error _error_OB_WRONG_COLUMN_NAME = {
      .error_name            = "OB_WRONG_COLUMN_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_COLUMN_NAME,
      .sqlstate              = "42000",
      .str_error             = "Incorrect column name",
      .str_user_error        = "Incorrect column name '%.*s'",
      .oracle_errno          = 904,
      .oracle_str_error      = "ORA-00904: invalid identifier",
      .oracle_str_user_error = "ORA-00904: invalid identifier '%.*s'",
      .ob_str_error          = "OBE-00904: invalid identifier",
      .ob_str_user_error     = "OBE-00904: invalid identifier '%.*s'"
};
static const _error _error_OB_ERR_COLUMN_SPEC = {
      .error_name            = "OB_ERR_COLUMN_SPEC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_FIELD_SPEC,
      .sqlstate              = "42000",
      .str_error             = "Incorrect column specifier",
      .str_user_error        = "Incorrect column specifier for column '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5165, Incorrect column specifier",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5165, Incorrect column specifier for column '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5165, Incorrect column specifier",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5165, Incorrect column specifier for column '%.*s'"
};
static const _error _error_OB_ERR_DB_DROP_EXISTS = {
      .error_name            = "OB_ERR_DB_DROP_EXISTS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DB_DROP_EXISTS,
      .sqlstate              = "HY000",
      .str_error             = "Can't drop database;database doesn't exist",
      .str_user_error        = "Can't drop database '%.*s'; database doesn't exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5166, Can't drop database;database doesn't exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5166, Can't drop database '%.*s'; database doesn't exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5166, Can't drop database;database doesn't exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5166, Can't drop database '%.*s'; database doesn't exist"
};
static const _error _error_OB_ERR_DATA_TOO_LONG = {
      .error_name            = "OB_ERR_DATA_TOO_LONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DATA_TOO_LONG,
      .sqlstate              = "22001",
      .str_error             = "Data too long for column",
      .str_user_error        = "Data too long for column '%.*s' at row %ld",
      .oracle_errno          = 12899,
      .oracle_str_error      = "ORA-12899: value too large for column",
      .oracle_str_user_error = "ORA-12899: value too large for column '%.*s' at row %ld",
      .ob_str_error          = "OBE-12899: value too large for column",
      .ob_str_user_error     = "OBE-12899: value too large for column '%.*s' at row %ld"
};
static const _error _error_OB_ERR_WRONG_VALUE_COUNT_ON_ROW = {
      .error_name            = "OB_ERR_WRONG_VALUE_COUNT_ON_ROW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_VALUE_COUNT_ON_ROW,
      .sqlstate              = "21S01",
      .str_error             = "column count does not match value count",
      .str_user_error        = "column count does not match value count at row '%d'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5168, column count does not match value count",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5168, column count does not match value count at row '%d'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5168, column count does not match value count",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5168, column count does not match value count at row '%d'"
};
static const _error _error_OB_ERR_CREATE_USER_WITH_GRANT = {
      .error_name            = "OB_ERR_CREATE_USER_WITH_GRANT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_CREATE_USER_WITH_GRANT,
      .sqlstate              = "42000",
      .str_error             = "You are not allowed to create a user with GRANT",
      .str_user_error        = "You are not allowed to create a user with GRANT",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5169, You are not allowed to create a user with GRANT",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5169, You are not allowed to create a user with GRANT",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5169, You are not allowed to create a user with GRANT",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5169, You are not allowed to create a user with GRANT"
};
static const _error _error_OB_ERR_NO_DB_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_DB_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DBACCESS_DENIED_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Access denied for user to database",
      .str_user_error        = "Access denied for user '%.*s'@'%.*s' to database '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5170, Access denied for user to database",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5170, Access denied for user '%.*s'@'%.*s' to database '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5170, Access denied for user to database",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5170, Access denied for user '%.*s'@'%.*s' to database '%.*s'"
};
static const _error _error_OB_ERR_NO_TABLE_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_TABLE_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TABLEACCESS_DENIED_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Command denied to user for table",
      .str_user_error        = "%.*s command denied to user '%.*s'@'%.*s' for table '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5171, Command denied to user for table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5171, %.*s command denied to user '%.*s'@'%.*s' for table '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5171, Command denied to user for table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5171, %.*s command denied to user '%.*s'@'%.*s' for table '%.*s'"
};
static const _error _error_OB_INVALID_ON_UPDATE = {
      .error_name            = "OB_INVALID_ON_UPDATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_ON_UPDATE,
      .sqlstate              = "HY000",
      .str_error             = "Invalid ON UPDATE clause",
      .str_user_error        = "Invalid ON UPDATE clause for \'%s\' column",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5172, Invalid ON UPDATE clause",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5172, Invalid ON UPDATE clause for \'%s\' column",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5172, Invalid ON UPDATE clause",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5172, Invalid ON UPDATE clause for \'%s\' column"
};
static const _error _error_OB_INVALID_DEFAULT = {
      .error_name            = "OB_INVALID_DEFAULT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_DEFAULT,
      .sqlstate              = "42000",
      .str_error             = "Invalid default value",
      .str_user_error        = "Invalid default value for \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5173, Invalid default value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5173, Invalid default value for \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5173, Invalid default value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5173, Invalid default value for \'%.*s\'"
};
static const _error _error_OB_ERR_UPDATE_TABLE_USED = {
      .error_name            = "OB_ERR_UPDATE_TABLE_USED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UPDATE_TABLE_USED,
      .sqlstate              = "HY000",
      .str_error             = "Update table used",
      .str_user_error        = "You can\'t specify target table \'%s\' for update in FROM clause",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5174, Update table used",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5174, You can\'t specify target table \'%s\' for update in FROM clause",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5174, Update table used",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5174, You can\'t specify target table \'%s\' for update in FROM clause"
};
static const _error _error_OB_ERR_COULUMN_VALUE_NOT_MATCH = {
      .error_name            = "OB_ERR_COULUMN_VALUE_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_VALUE_COUNT_ON_ROW,
      .sqlstate              = "21S01",
      .str_error             = "Column count doesn\'t match value count",
      .str_user_error        = "Column count doesn\'t match value count at row %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5175, Column count doesn\'t match value count",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5175, Column count doesn\'t match value count at row %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5175, Column count doesn\'t match value count",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5175, Column count doesn\'t match value count at row %ld"
};
static const _error _error_OB_ERR_INVALID_GROUP_FUNC_USE = {
      .error_name            = "OB_ERR_INVALID_GROUP_FUNC_USE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_GROUP_FUNC_USE,
      .sqlstate              = "HY000",
      .str_error             = "Invalid use of group function",
      .str_user_error        = "Invalid use of group function",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5176, Invalid use of group function",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5176, Invalid use of group function",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5176, Invalid use of group function",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5176, Invalid use of group function"
};
static const _error _error_OB_CANT_AGGREGATE_2COLLATIONS = {
      .error_name            = "OB_CANT_AGGREGATE_2COLLATIONS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_AGGREGATE_2COLLATIONS,
      .sqlstate              = "HY000",
      .str_error             = "Illegal mix of collations",
      .str_user_error        = "Illegal mix of collations (%s,%s), (%s,%s)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5177, Illegal mix of collations",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5177, Illegal mix of collations (%s,%s), (%s,%s)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5177, Illegal mix of collations",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5177, Illegal mix of collations (%s,%s), (%s,%s)"
};
static const _error _error_OB_ERR_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD = {
      .error_name            = "OB_ERR_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD,
      .sqlstate              = "HY000",
      .str_error             = "Field is of a not allowed type for this type of partitioning",
      .str_user_error        = "Field \'%.*s\' is of a not allowed type for this type of partitioning",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5178, Field is of a not allowed type for this type of partitioning",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5178, Field \'%.*s\' is of a not allowed type for this type of partitioning",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5178, Field is of a not allowed type for this type of partitioning",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5178, Field \'%.*s\' is of a not allowed type for this type of partitioning"
};
static const _error _error_OB_ERR_TOO_LONG_IDENT = {
      .error_name            = "OB_ERR_TOO_LONG_IDENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_LONG_IDENT,
      .sqlstate              = "42000",
      .str_error             = "Identifier name is too long",
      .str_user_error        = "Identifier name \'%.*s\' is too long",
      .oracle_errno          = 972,
      .oracle_str_error      = "ORA-00972: identifier is too long",
      .oracle_str_user_error = "ORA-00972: identifier \'%.*s\' is too long",
      .ob_str_error          = "OBE-00972: identifier is too long",
      .ob_str_user_error     = "OBE-00972: identifier \'%.*s\' is too long"
};
static const _error _error_OB_ERR_WRONG_TYPE_FOR_VAR = {
      .error_name            = "OB_ERR_WRONG_TYPE_FOR_VAR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_TYPE_FOR_VAR,
      .sqlstate              = "42000",
      .str_error             = "Incorrect argument type to variable",
      .str_user_error        = "Incorrect argument type to variable '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5180, Incorrect argument type to variable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5180, Incorrect argument type to variable '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5180, Incorrect argument type to variable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5180, Incorrect argument type to variable '%.*s'"
};
static const _error _error_OB_WRONG_USER_NAME_LENGTH = {
      .error_name            = "OB_WRONG_USER_NAME_LENGTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_STRING_LENGTH,
      .sqlstate              = "HY000",
      .str_error             = "String is too long for user_name (should be no longer than 64)",
      .str_user_error        = "String '%.*s' is too long for user name (should be no longer than 64)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5181, String is too long for user_name (should be no longer than 64)",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5181, String '%.*s' is too long for user name (should be no longer than 64)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5181, String is too long for user_name (should be no longer than 64)",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5181, String '%.*s' is too long for user name (should be no longer than 64)"
};
static const _error _error_OB_ERR_PRIV_USAGE = {
      .error_name            = "OB_ERR_PRIV_USAGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_USAGE,
      .sqlstate              = "HY000",
      .str_error             = "Incorrect usage of DB GRANT and GLOBAL PRIVILEGES",
      .str_user_error        = "Incorrect usage of DB GRANT and GLOBAL PRIVILEGES",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5182, Incorrect usage of DB GRANT and GLOBAL PRIVILEGES",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5182, Incorrect usage of DB GRANT and GLOBAL PRIVILEGES",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5182, Incorrect usage of DB GRANT and GLOBAL PRIVILEGES",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5182, Incorrect usage of DB GRANT and GLOBAL PRIVILEGES"
};
static const _error _error_OB_ILLEGAL_GRANT_FOR_TABLE = {
      .error_name            = "OB_ILLEGAL_GRANT_FOR_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ILLEGAL_GRANT_FOR_TABLE,
      .sqlstate              = "42000",
      .str_error             = "Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used",
      .str_user_error        = "Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5183, Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5183, Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5183, Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5183, Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used"
};
static const _error _error_OB_ERR_REACH_AUTOINC_MAX = {
      .error_name            = "OB_ERR_REACH_AUTOINC_MAX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_AUTOINC_READ_FAILED,
      .sqlstate              = "HY000",
      .str_error             = "Failed to read auto-increment value from storage engine",
      .str_user_error        = "Failed to read auto-increment value from storage engine",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5184, Failed to read auto-increment value from storage engine",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5184, Failed to read auto-increment value from storage engine",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5184, Failed to read auto-increment value from storage engine",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5184, Failed to read auto-increment value from storage engine"
};
static const _error _error_OB_ERR_NO_TABLES_USED = {
      .error_name            = "OB_ERR_NO_TABLES_USED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_TABLES_USED,
      .sqlstate              = "HY000",
      .str_error             = "No tables used",
      .str_user_error        = "No tables used",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5185, No tables used",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5185, No tables used",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5185, No tables used",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5185, No tables used"
};
static const _error _error_OB_CANT_REMOVE_ALL_FIELDS = {
      .error_name            = "OB_CANT_REMOVE_ALL_FIELDS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_REMOVE_ALL_FIELDS,
      .sqlstate              = "42000",
      .str_error             = "You can't delete all columns with ALTER TABLE; use DROP TABLE instead",
      .str_user_error        = "You can't delete all columns with ALTER TABLE; use DROP TABLE instead",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5187, You can't delete all columns with ALTER TABLE; use DROP TABLE instead",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5187, You can't delete all columns with ALTER TABLE; use DROP TABLE instead",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5187, You can't delete all columns with ALTER TABLE; use DROP TABLE instead",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5187, You can't delete all columns with ALTER TABLE; use DROP TABLE instead"
};
static const _error _error_OB_TOO_MANY_PARTITIONS_ERROR = {
      .error_name            = "OB_TOO_MANY_PARTITIONS_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_PARTITIONS_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Too many partitions (including subpartitions) were defined",
      .str_user_error        = "Too many partitions (including subpartitions) were defined",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5188, Too many partitions (including subpartitions) were defined",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5188, Too many partitions (including subpartitions) were defined",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5188, Too many partitions (including subpartitions) were defined",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5188, Too many partitions (including subpartitions) were defined"
};
static const _error _error_OB_NO_PARTS_ERROR = {
      .error_name            = "OB_NO_PARTS_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_PARTS_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Number of partitions = 0 is not an allowed value",
      .str_user_error        = "Number of partitions = 0 is not an allowed value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5189, Number of partitions = 0 is not an allowed value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5189, Number of partitions = 0 is not an allowed value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5189, Number of partitions = 0 is not an allowed value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5189, Number of partitions = 0 is not an allowed value"
};
static const _error _error_OB_WRONG_SUB_KEY = {
      .error_name            = "OB_WRONG_SUB_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_SUB_KEY,
      .sqlstate              = "HY000",
      .str_error             = "Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys",
      .str_user_error        = "Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5190, Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5190, Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5190, Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5190, Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys"
};
static const _error _error_OB_KEY_PART_0 = {
      .error_name            = "OB_KEY_PART_0",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_KEY_PART_0,
      .sqlstate              = "HY000",
      .str_error             = "Key part length cannot be 0",
      .str_user_error        = "Key part \'%.*s\' length cannot be 0",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5191, Key part length cannot be 0",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5191, Key part \'%.*s\' length cannot be 0",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5191, Key part length cannot be 0",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5191, Key part \'%.*s\' length cannot be 0"
};
static const _error _error_OB_ERR_UNKNOWN_TIME_ZONE = {
      .error_name            = "OB_ERR_UNKNOWN_TIME_ZONE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_TIME_ZONE,
      .sqlstate              = "HY000",
      .str_error             = "Unknown or incorrect time zone",
      .str_user_error        = "Unknown or incorrect time zone: \'%.*s\'",
      .oracle_errno          = 1882,
      .oracle_str_error      = "ORA-01882: timezone region string not found",
      .oracle_str_user_error = "ORA-01882: timezone region \'%.*s\' not found",
      .ob_str_error          = "OBE-01882: timezone region string not found",
      .ob_str_user_error     = "OBE-01882: timezone region \'%.*s\' not found"
};
static const _error _error_OB_ERR_WRONG_AUTO_KEY = {
      .error_name            = "OB_ERR_WRONG_AUTO_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_AUTO_KEY,
      .sqlstate              = "42000",
      .str_error             = "Incorrect table definition; there can be only one auto column",
      .str_user_error        = "Incorrect table definition; there can be only one auto column",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5193, Incorrect table definition; there can be only one auto column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5193, Incorrect table definition; there can be only one auto column",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5193, Incorrect table definition; there can be only one auto column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5193, Incorrect table definition; there can be only one auto column"
};
static const _error _error_OB_ERR_TOO_MANY_KEYS = {
      .error_name            = "OB_ERR_TOO_MANY_KEYS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_KEYS,
      .sqlstate              = "42000",
      .str_error             = "Too many keys specified",
      .str_user_error        = "Too many keys specified; max %ld keys allowed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5194, Too many keys specified",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5194, Too many keys specified; max %ld keys allowed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5194, Too many keys specified",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5194, Too many keys specified; max %ld keys allowed"
};
static const _error _error_OB_ERR_TOO_MANY_ROWKEY_COLUMNS = {
      .error_name            = "OB_ERR_TOO_MANY_ROWKEY_COLUMNS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_KEY_PARTS,
      .sqlstate              = "42000",
      .str_error             = "Too many key parts specified",
      .str_user_error        = "Too many key parts specified; max %ld parts allowed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5195, Too many key parts specified",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5195, Too many key parts specified; max %ld parts allowed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5195, Too many key parts specified",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5195, Too many key parts specified; max %ld parts allowed"
};
static const _error _error_OB_ERR_TOO_LONG_KEY_LENGTH = {
      .error_name            = "OB_ERR_TOO_LONG_KEY_LENGTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_LONG_KEY,
      .sqlstate              = "42000",
      .str_error             = "Specified key was too long",
      .str_user_error        = "Specified key was too long; max key length is %ld bytes",
      .oracle_errno          = 1450,
      .oracle_str_error      = "ORA-01450: maximum key length exceeded",
      .oracle_str_user_error = "ORA-01450: maximum key length (%ld) exceeded",
      .ob_str_error          = "OBE-01450: maximum key length exceeded",
      .ob_str_user_error     = "OBE-01450: maximum key length (%ld) exceeded"
};
static const _error _error_OB_ERR_TOO_MANY_COLUMNS = {
      .error_name            = "OB_ERR_TOO_MANY_COLUMNS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_FIELDS,
      .sqlstate              = "42000",
      .str_error             = "Too many columns",
      .str_user_error        = "Too many columns",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5197, Too many columns",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5197, Too many columns",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5197, Too many columns",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5197, Too many columns"
};
static const _error _error_OB_ERR_TOO_LONG_COLUMN_LENGTH = {
      .error_name            = "OB_ERR_TOO_LONG_COLUMN_LENGTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_BIG_FIELDLENGTH,
      .sqlstate              = "42000",
      .str_error             = "Column length too big",
      .str_user_error        = "Column length too big for column '%s' (max = %d)",
      .oracle_errno          = 910,
      .oracle_str_error      = "ORA-00910: specified length too long for its datatype",
      .oracle_str_user_error = "ORA-00910: specified length too long for column '%s' (max = %d byte)",
      .ob_str_error          = "OBE-00910: specified length too long for its datatype",
      .ob_str_user_error     = "OBE-00910: specified length too long for column '%s' (max = %d byte)"
};
static const _error _error_OB_ERR_TOO_BIG_ROWSIZE = {
      .error_name            = "OB_ERR_TOO_BIG_ROWSIZE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_BIG_ROWSIZE,
      .sqlstate              = "42000",
      .str_error             = "Row size too large",
      .str_user_error        = "Row size too large",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5199, Row size too large",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5199, Row size too large",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5199, Row size too large",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5199, Row size too large"
};
static const _error _error_OB_ERR_UNKNOWN_TABLE = {
      .error_name            = "OB_ERR_UNKNOWN_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_TABLE,
      .sqlstate              = "42S02",
      .str_error             = "Unknown table",
      .str_user_error        = "Unknown table '%.*s' in %.*s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5200, Unknown table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5200, Unknown table '%.*s' in %.*s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5200, Unknown table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5200, Unknown table '%.*s' in %.*s"
};
static const _error _error_OB_ERR_BAD_TABLE = {
      .error_name            = "OB_ERR_BAD_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_BAD_TABLE_ERROR,
      .sqlstate              = "42S02",
      .str_error             = "Unknown table",
      .str_user_error        = "Unknown table '%.*s'",
      .oracle_errno          = 942,
      .oracle_str_error      = "ORA-00942: table or view does not exist",
      .oracle_str_user_error = "ORA-00942: table or view '%.*s' does not exist",
      .ob_str_error          = "OBE-00942: table or view does not exist",
      .ob_str_user_error     = "OBE-00942: table or view '%.*s' does not exist"
};
static const _error _error_OB_ERR_TOO_BIG_SCALE = {
      .error_name            = "OB_ERR_TOO_BIG_SCALE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_BIG_SCALE,
      .sqlstate              = "42000",
      .str_error             = "Too big scale specified for column",
      .str_user_error        = "Too big scale %d specified for column '%s'. Maximum is %ld.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5202, Too big scale specified for column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5202, Too big scale %d specified for column '%s'. Maximum is %ld.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5202, Too big scale specified for column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5202, Too big scale %d specified for column '%s'. Maximum is %ld."
};
static const _error _error_OB_ERR_TOO_BIG_PRECISION = {
      .error_name            = "OB_ERR_TOO_BIG_PRECISION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_BIG_PRECISION,
      .sqlstate              = "42000",
      .str_error             = "Too big precision specified for column",
      .str_user_error        = "Too big precision %d specified for column '%s'. Maximum is %ld.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5203, Too big precision specified for column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5203, Too big precision %d specified for column '%s'. Maximum is %ld.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5203, Too big precision specified for column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5203, Too big precision %d specified for column '%s'. Maximum is %ld."
};
static const _error _error_OB_ERR_M_BIGGER_THAN_D = {
      .error_name            = "OB_ERR_M_BIGGER_THAN_D",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_M_BIGGER_THAN_D,
      .sqlstate              = "42000",
      .str_error             = "precision must be >= scale",
      .str_user_error        = "For float(M,D), double(M,D) or decimal(M,D), M must be >= D (column '%s').",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5204, precision must be >= scale",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5204, For float(M,D), double(M,D) or decimal(M,D), M must be >= D (column '%s').",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5204, precision must be >= scale",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5204, For float(M,D), double(M,D) or decimal(M,D), M must be >= D (column '%s')."
};
static const _error _error_OB_ERR_TOO_BIG_DISPLAYWIDTH = {
      .error_name            = "OB_ERR_TOO_BIG_DISPLAYWIDTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_BIG_DISPLAYWIDTH,
      .sqlstate              = "42000",
      .str_error             = "Display width out of range for column",
      .str_user_error        = "Display width out of range for column '%s' (max = %ld)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5205, Display width out of range for column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5205, Display width out of range for column '%s' (max = %ld)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5205, Display width out of range for column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5205, Display width out of range for column '%s' (max = %ld)"
};
static const _error _error_OB_WRONG_GROUP_FIELD = {
      .error_name            = "OB_WRONG_GROUP_FIELD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_GROUP_FIELD,
      .sqlstate              = "42000",
      .str_error             = "Can't group on column",
      .str_user_error        = "Can't group on '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5206, Can't group on column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5206, Can't group on '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5206, Can't group on column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5206, Can't group on '%.*s'"
};
static const _error _error_OB_NON_UNIQ_ERROR = {
      .error_name            = "OB_NON_UNIQ_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NON_UNIQ_ERROR,
      .sqlstate              = "23000",
      .str_error             = "Column is ambiguous",
      .str_user_error        = "Column '%.*s' in %.*s is ambiguous",
      .oracle_errno          = 918,
      .oracle_str_error      = "ORA-00918: Column is ambiguous",
      .oracle_str_user_error = "ORA-00918: column '%.*s' in %.*s ambiguously defined",
      .ob_str_error          = "OBE-00918: Column is ambiguous",
      .ob_str_user_error     = "OBE-00918: column '%.*s' in %.*s ambiguously defined"
};
static const _error _error_OB_ERR_NONUNIQ_TABLE = {
      .error_name            = "OB_ERR_NONUNIQ_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NONUNIQ_TABLE,
      .sqlstate              = "42000",
      .str_error             = "Not unique table/alias",
      .str_user_error        = "Not unique table/alias: \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5208, Not unique table/alias",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5208, Not unique table/alias: \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5208, Not unique table/alias",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5208, Not unique table/alias: \'%.*s\'"
};
static const _error _error_OB_ERR_CANT_DROP_FIELD_OR_KEY = {
      .error_name            = "OB_ERR_CANT_DROP_FIELD_OR_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_DROP_FIELD_OR_KEY,
      .sqlstate              = "42000",
      .str_error             = "Can't DROP Column; check that column/key exists",
      .str_user_error        = "Can't DROP '%.*s'; check that column/key exists",
      .oracle_errno          = 1418,
      .oracle_str_error      = "ORA-01418: specified index does not exist",
      .oracle_str_user_error = "ORA-01418: specified index '%.*s' does not exist",
      .ob_str_error          = "OBE-01418: specified index does not exist",
      .ob_str_user_error     = "OBE-01418: specified index '%.*s' does not exist"
};
static const _error _error_OB_ERR_MULTIPLE_PRI_KEY = {
      .error_name            = "OB_ERR_MULTIPLE_PRI_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_MULTIPLE_PRI_KEY,
      .sqlstate              = "42000",
      .str_error             = "Multiple primary key defined",
      .str_user_error        = "Multiple primary key defined",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5210, Multiple primary key defined",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5210, Multiple primary key defined",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5210, Multiple primary key defined",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5210, Multiple primary key defined"
};
static const _error _error_OB_ERR_KEY_COLUMN_DOES_NOT_EXITS = {
      .error_name            = "OB_ERR_KEY_COLUMN_DOES_NOT_EXITS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_KEY_COLUMN_DOES_NOT_EXITS,
      .sqlstate              = "42000",
      .str_error             = "Key column doesn't exist in table",
      .str_user_error        = "Key column '%.*s' doesn't exist in table",
      .oracle_errno          = 904,
      .oracle_str_error      = "ORA-00904: invalid identifier",
      .oracle_str_user_error = "ORA-00904: '%.*s': invalid identifier",
      .ob_str_error          = "OBE-00904: invalid identifier",
      .ob_str_user_error     = "OBE-00904: '%.*s': invalid identifier"
};
static const _error _error_OB_ERR_AUTO_PARTITION_KEY = {
      .error_name            = "OB_ERR_AUTO_PARTITION_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "auto-increment column should not be part of partition key",
      .str_user_error        = "auto-increment column '%.*s' should not be part of partition key",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5212, auto-increment column should not be part of partition key",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5212, auto-increment column '%.*s' should not be part of partition key",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5212, auto-increment column should not be part of partition key",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5212, auto-increment column '%.*s' should not be part of partition key"
};
static const _error _error_OB_ERR_CANT_USE_OPTION_HERE = {
      .error_name            = "OB_ERR_CANT_USE_OPTION_HERE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_USE_OPTION_HERE,
      .sqlstate              = "42000",
      .str_error             = "Incorrect usage/placement",
      .str_user_error        = "Incorrect usage/placement of '%s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5213, Incorrect usage/placement",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5213, Incorrect usage/placement of '%s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5213, Incorrect usage/placement",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5213, Incorrect usage/placement of '%s'"
};
static const _error _error_OB_ERR_WRONG_OBJECT = {
      .error_name            = "OB_ERR_WRONG_OBJECT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_OBJECT,
      .sqlstate              = "HY000",
      .str_error             = "Wrong object",
      .str_user_error        = "\'%s.%s\' is not %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5214, Wrong object",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5214, \'%s.%s\' is not %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5214, Wrong object",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5214, \'%s.%s\' is not %s"
};
static const _error _error_OB_ERR_ON_RENAME = {
      .error_name            = "OB_ERR_ON_RENAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ERROR_ON_RENAME,
      .sqlstate              = "HY000",
      .str_error             = "Error on rename table",
      .str_user_error        = "Error on rename of \'%s.%s\' to \'%s.%s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5215, Error on rename table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5215, Error on rename of \'%s.%s\' to \'%s.%s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5215, Error on rename table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5215, Error on rename of \'%s.%s\' to \'%s.%s\'"
};
static const _error _error_OB_ERR_WRONG_KEY_COLUMN = {
      .error_name            = "OB_ERR_WRONG_KEY_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_KEY_COLUMN,
      .sqlstate              = "42000",
      .str_error             = "The used storage engine can't index column",
      .str_user_error        = "The used storage engine can't index column '%.*s'",
      .oracle_errno          = 2329,
      .oracle_str_error      = "ORA-02329: column of datatype string cannot be unique or a primary key",
      .oracle_str_user_error = "ORA-02329: column '%.*s' of datatype string cannot be unique or a primary key",
      .ob_str_error          = "OBE-02329: column of datatype string cannot be unique or a primary key",
      .ob_str_user_error     = "OBE-02329: column '%.*s' of datatype string cannot be unique or a primary key"
};
static const _error _error_OB_ERR_BAD_FIELD_ERROR = {
      .error_name            = "OB_ERR_BAD_FIELD_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_BAD_FIELD_ERROR,
      .sqlstate              = "42S22",
      .str_error             = "Unknown column",
      .str_user_error        = "Unknown column '%.*s' in '%.*s'",
      .oracle_errno          = 904,
      .oracle_str_error      = "ORA-00904: invalid identifier",
      .oracle_str_user_error = "ORA-00904: invalid identifier '%.*s' in '%.*s'",
      .ob_str_error          = "OBE-00904: invalid identifier",
      .ob_str_user_error     = "OBE-00904: invalid identifier '%.*s' in '%.*s'"
};
static const _error _error_OB_ERR_WRONG_FIELD_WITH_GROUP = {
      .error_name            = "OB_ERR_WRONG_FIELD_WITH_GROUP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_FIELD_WITH_GROUP,
      .sqlstate              = "42000",
      .str_error             = "nonaggregated column is not functionally dependent on columns in GROUP BY clause; this is incompatible with sql_mode=only_full_group_by",
      .str_user_error        = "nonaggregated column \'%.*s\' is not functionally dependent on columns in GROUP BY clause; this is incompatible with sql_mode=only_full_group_by",
      .oracle_errno          = 979,
      .oracle_str_error      = "ORA-00979: not a GROUP BY expression",
      .oracle_str_user_error = "ORA-00979: \'%.*s\' not a GROUP BY expression",
      .ob_str_error          = "OBE-00979: not a GROUP BY expression",
      .ob_str_user_error     = "OBE-00979: \'%.*s\' not a GROUP BY expression"
};
static const _error _error_OB_ERR_CANT_CHANGE_TX_CHARACTERISTICS = {
      .error_name            = "OB_ERR_CANT_CHANGE_TX_CHARACTERISTICS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_CHANGE_TX_CHARACTERISTICS,
      .sqlstate              = "25001",
      .str_error             = "Transaction characteristics can't be changed while a transaction is in progress",
      .str_user_error        = "Transaction characteristics can't be changed while a transaction is in progress",
      .oracle_errno          = 1453,
      .oracle_str_error      = "ORA-01453: SET TRANSACTION must be first statement of transaction",
      .oracle_str_user_error = "ORA-01453: SET TRANSACTION must be first statement of transaction",
      .ob_str_error          = "OBE-01453: SET TRANSACTION must be first statement of transaction",
      .ob_str_user_error     = "OBE-01453: SET TRANSACTION must be first statement of transaction"
};
static const _error _error_OB_ERR_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION = {
      .error_name            = "OB_ERR_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION,
      .sqlstate              = "25006",
      .str_error             = "Cannot execute statement in a READ ONLY transaction.",
      .str_user_error        = "Cannot execute statement in a READ ONLY transaction.",
      .oracle_errno          = 1456,
      .oracle_str_error      = "ORA-01456: may not perform insert/delete/update operation inside a READ ONLY transaction",
      .oracle_str_user_error = "ORA-01456: may not perform insert/delete/update operation inside a READ ONLY transaction",
      .ob_str_error          = "OBE-01456: may not perform insert/delete/update operation inside a READ ONLY transaction",
      .ob_str_user_error     = "OBE-01456: may not perform insert/delete/update operation inside a READ ONLY transaction"
};
static const _error _error_OB_ERR_MIX_OF_GROUP_FUNC_AND_FIELDS = {
      .error_name            = "OB_ERR_MIX_OF_GROUP_FUNC_AND_FIELDS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_MIX_OF_GROUP_FUNC_AND_FIELDS,
      .sqlstate              = "42000",
      .str_error             = "Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause",
      .str_user_error        = "Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5221, Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5221, Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5221, Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5221, Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause"
};
static const _error _error_OB_ERR_TRUNCATED_WRONG_VALUE = {
      .error_name            = "OB_ERR_TRUNCATED_WRONG_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TRUNCATED_WRONG_VALUE,
      .sqlstate              = "22007",
      .str_error             = "Incorrect value",
      .str_user_error        = "Truncated incorrect %.*s value: '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5222, Incorrect value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5222, Truncated incorrect %.*s value: '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5222, Incorrect value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5222, Truncated incorrect %.*s value: '%.*s'"
};
static const _error _error_OB_ERR_WRONG_IDENT_NAME = {
      .error_name            = "OB_ERR_WRONG_IDENT_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "wrong ident name",
      .str_user_error        = "wrong ident name",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5223, wrong ident name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5223, wrong ident name",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5223, wrong ident name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5223, wrong ident name"
};
static const _error _error_OB_WRONG_NAME_FOR_INDEX = {
      .error_name            = "OB_WRONG_NAME_FOR_INDEX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_NAME_FOR_INDEX,
      .sqlstate              = "42000",
      .str_error             = "Incorrect index name",
      .str_user_error        = "Incorrect index name '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5224, Incorrect index name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5224, Incorrect index name '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5224, Incorrect index name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5224, Incorrect index name '%.*s'"
};
static const _error _error_OB_ILLEGAL_REFERENCE = {
      .error_name            = "OB_ILLEGAL_REFERENCE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ILLEGAL_REFERENCE,
      .sqlstate              = "42S22",
      .str_error             = "Reference not supported (reference to group function)",
      .str_user_error        = "Reference '%.*s' not supported (reference to group function)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5225, Reference not supported (reference to group function)",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5225, Reference '%.*s' not supported (reference to group function)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5225, Reference not supported (reference to group function)",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5225, Reference '%.*s' not supported (reference to group function)"
};
static const _error _error_OB_REACH_MEMORY_LIMIT = {
      .error_name            = "OB_REACH_MEMORY_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "plan cache memory used reach the high water mark.",
      .str_user_error        = "plan cache memory used reach the high water mark.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5226, plan cache memory used reach the high water mark.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5226, plan cache memory used reach the high water mark.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5226, plan cache memory used reach the high water mark.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5226, plan cache memory used reach the high water mark."
};
static const _error _error_OB_ERR_PASSWORD_FORMAT = {
      .error_name            = "OB_ERR_PASSWORD_FORMAT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PASSWORD_FORMAT,
      .sqlstate              = "42000",
      .str_error             = "The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.",
      .str_user_error        = "The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5227, The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5227, The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5227, The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5227, The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function."
};
static const _error _error_OB_ERR_NON_UPDATABLE_TABLE = {
      .error_name            = "OB_ERR_NON_UPDATABLE_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NON_UPDATABLE_TABLE,
      .sqlstate              = "HY000",
      .str_error             = "The target table is not updatable",
      .str_user_error        = "The target table %.*s of the %.*s is not updatable",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5228, The target table is not updatable",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5228, The target table %.*s of the %.*s is not updatable",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5228, The target table is not updatable",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5228, The target table %.*s of the %.*s is not updatable"
};
static const _error _error_OB_ERR_WARN_DATA_OUT_OF_RANGE = {
      .error_name            = "OB_ERR_WARN_DATA_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DATA_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "Out of range value for column",
      .str_user_error        = "Out of range value for column '%.*s' at row %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5229, Out of range value for column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5229, Out of range value for column '%.*s' at row %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5229, Out of range value for column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5229, Out of range value for column '%.*s' at row %ld"
};
static const _error _error_OB_ERR_WRONG_EXPR_IN_PARTITION_FUNC_ERROR = {
      .error_name            = "OB_ERR_WRONG_EXPR_IN_PARTITION_FUNC_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed",
      .str_user_error        = "Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5230, Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5230, Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5230, Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5230, Constant or random or timezone-dependent expressions in (sub)partitioning function are not allowed"
};
static const _error _error_OB_ERR_VIEW_INVALID = {
      .error_name            = "OB_ERR_VIEW_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_VIEW_INVALID,
      .sqlstate              = "42S22",
      .str_error             = "view invalid",
      .str_user_error        = "View \'%.*s.%.*s\' references invalid table(s) or column(s) or function(s) or definer/invoker of view lack rights to use them",
      .oracle_errno          = 4063,
      .oracle_str_error      = "ORA-04063: view invalid",
      .oracle_str_user_error = "ORA-04063: view '%.*s.%.*s' has errors",
      .ob_str_error          = "OBE-04063: view invalid",
      .ob_str_user_error     = "OBE-04063: view '%.*s.%.*s' has errors"
};
static const _error _error_OB_ERR_OPTION_PREVENTS_STATEMENT = {
      .error_name            = "OB_ERR_OPTION_PREVENTS_STATEMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_OPTION_PREVENTS_STATEMENT,
      .sqlstate              = "HY000",
      .str_error             = "The MySQL server is running with the --read-only option so it cannot execute this statement",
      .str_user_error        = "The MySQL server is running with the --read-only option so it cannot execute this statement",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5233, The MySQL server is running with the --read-only option so it cannot execute this statement",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5233, The MySQL server is running with the --read-only option so it cannot execute this statement",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5233, The MySQL server is running with the --read-only option so it cannot execute this statement",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5233, The MySQL server is running with the --read-only option so it cannot execute this statement"
};
static const _error _error_OB_ERR_DB_READ_ONLY = {
      .error_name            = "OB_ERR_DB_READ_ONLY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The database is read only so it cannot execute this statement",
      .str_user_error        = "The database \'%.*s\' is read only so it cannot execute this statement",
      .oracle_errno          = 16000,
      .oracle_str_error      = "ORA-16000: database open for read-only access",
      .oracle_str_user_error = "ORA-16000: database \'%.*s\' open for read-only access",
      .ob_str_error          = "OBE-16000: database open for read-only access",
      .ob_str_user_error     = "OBE-16000: database \'%.*s\' open for read-only access"
};
static const _error _error_OB_ERR_TABLE_READ_ONLY = {
      .error_name            = "OB_ERR_TABLE_READ_ONLY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The table is read only so it cannot execute this statement",
      .str_user_error        = "The table \'%.*s.%.*s\' is read only so it cannot execute this statement",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5235, The table is read only so it cannot execute this statement",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5235, The table \'%.*s.%.*s\' is read only so it cannot execute this statement",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5235, The table is read only so it cannot execute this statement",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5235, The table \'%.*s.%.*s\' is read only so it cannot execute this statement"
};
static const _error _error_OB_ERR_LOCK_OR_ACTIVE_TRANSACTION = {
      .error_name            = "OB_ERR_LOCK_OR_ACTIVE_TRANSACTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_LOCK_OR_ACTIVE_TRANSACTION,
      .sqlstate              = "HY000",
      .str_error             = "Can't execute the given command because you have active locked tables or an active transaction",
      .str_user_error        = "Can't execute the given command because you have active locked tables or an active transaction",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5236, Can't execute the given command because you have active locked tables or an active transaction",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5236, Can't execute the given command because you have active locked tables or an active transaction",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5236, Can't execute the given command because you have active locked tables or an active transaction",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5236, Can't execute the given command because you have active locked tables or an active transaction"
};
static const _error _error_OB_ERR_SAME_NAME_PARTITION_FIELD = {
      .error_name            = "OB_ERR_SAME_NAME_PARTITION_FIELD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SAME_NAME_PARTITION_FIELD,
      .sqlstate              = "HY000",
      .str_error             = "Duplicate partition field name",
      .str_user_error        = "Duplicate partition field name '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5237, Duplicate partition field name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5237, Duplicate partition field name '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5237, Duplicate partition field name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5237, Duplicate partition field name '%.*s'"
};
static const _error _error_OB_ERR_TABLENAME_NOT_ALLOWED_HERE = {
      .error_name            = "OB_ERR_TABLENAME_NOT_ALLOWED_HERE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TABLENAME_NOT_ALLOWED_HERE,
      .sqlstate              = "42000",
      .str_error             = "Table from one of the SELECTs cannot be used in global ORDER clause",
      .str_user_error        = "Table \'%.*s\' from one of the SELECTs cannot be used in global ORDER clause",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5238, Table from one of the SELECTs cannot be used in global ORDER clause",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5238, Table \'%.*s\' from one of the SELECTs cannot be used in global ORDER clause",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5238, Table from one of the SELECTs cannot be used in global ORDER clause",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5238, Table \'%.*s\' from one of the SELECTs cannot be used in global ORDER clause"
};
static const _error _error_OB_ERR_VIEW_RECURSIVE = {
      .error_name            = "OB_ERR_VIEW_RECURSIVE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_VIEW_RECURSIVE,
      .sqlstate              = "42S02",
      .str_error             = "view contains recursion",
      .str_user_error        = "\'%.*s.%.*s\' contains view recursion",
      .oracle_errno          = 1731,
      .oracle_str_error      = "ORA-01731: circular view definition encountered",
      .oracle_str_user_error = "ORA-01731: view '%.*s.%.*s' encounters circular definition",
      .ob_str_error          = "OBE-01731: circular view definition encountered",
      .ob_str_user_error     = "OBE-01731: view '%.*s.%.*s' encounters circular definition"
};
static const _error _error_OB_ERR_QUALIFIER = {
      .error_name            = "OB_ERR_QUALIFIER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Column part of USING clause cannot have qualifier",
      .str_user_error        = "Column part of USING clause cannot have qualifier",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5240, Column part of USING clause cannot have qualifier",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5240, Column part of USING clause cannot have qualifier",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5240, Column part of USING clause cannot have qualifier",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5240, Column part of USING clause cannot have qualifier"
};
static const _error _error_OB_ERR_WRONG_VALUE = {
      .error_name            = "OB_ERR_WRONG_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_VALUE,
      .sqlstate              = "HY000",
      .str_error             = "Incorrect value",
      .str_user_error        = "Incorrect %s value: '%s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5241, Incorrect value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5241, Incorrect %s value: '%s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5241, Incorrect value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5241, Incorrect %s value: '%s'"
};
static const _error _error_OB_ERR_VIEW_WRONG_LIST = {
      .error_name            = "OB_ERR_VIEW_WRONG_LIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_VIEW_WRONG_LIST,
      .sqlstate              = "HY000",
      .str_error             = "View's SELECT and view's field list have different column counts",
      .str_user_error        = "View's SELECT and view's field list have different column counts",
      .oracle_errno          = 1730,
      .oracle_str_error      = "ORA-01730: invalid number of column names specified",
      .oracle_str_user_error = "ORA-01730: invalid number of column names specified",
      .ob_str_error          = "OBE-01730: invalid number of column names specified",
      .ob_str_user_error     = "OBE-01730: invalid number of column names specified"
};
static const _error _error_OB_SYS_VARS_MAYBE_DIFF_VERSION = {
      .error_name            = "OB_SYS_VARS_MAYBE_DIFF_VERSION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "system variables' version maybe different",
      .str_user_error        = "system variables' version maybe different",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5243, system variables' version maybe different",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5243, system variables' version maybe different",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5243, system variables' version maybe different",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5243, system variables' version maybe different"
};
static const _error _error_OB_ERR_AUTO_INCREMENT_CONFLICT = {
      .error_name            = "OB_ERR_AUTO_INCREMENT_CONFLICT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_AUTO_INCREMENT_CONFLICT,
      .sqlstate              = "HY000",
      .str_error             = "Auto-increment value in UPDATE conflicts with internally generated values",
      .str_user_error        = "Auto-increment value in UPDATE conflicts with internally generated values",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5244, Auto-increment value in UPDATE conflicts with internally generated values",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5244, Auto-increment value in UPDATE conflicts with internally generated values",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5244, Auto-increment value in UPDATE conflicts with internally generated values",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5244, Auto-increment value in UPDATE conflicts with internally generated values"
};
static const _error _error_OB_ERR_TASK_SKIPPED = {
      .error_name            = "OB_ERR_TASK_SKIPPED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "some tasks are skipped",
      .str_user_error        = "some tasks are skipped, skipped server addr is '%s', the orginal error code is %d",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5245, some tasks are skipped",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5245, some tasks are skipped, skipped server addr is '%s', the orginal error code is %d",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5245, some tasks are skipped",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5245, some tasks are skipped, skipped server addr is '%s', the orginal error code is %d"
};
static const _error _error_OB_ERR_NAME_BECOMES_EMPTY = {
      .error_name            = "OB_ERR_NAME_BECOMES_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NAME_BECOMES_EMPTY,
      .sqlstate              = "HY000",
      .str_error             = "Name has become ''",
      .str_user_error        = "Name \'%.*s\' has become ''",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5246, Name has become ''",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5246, Name \'%.*s\' has become ''",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5246, Name has become ''",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5246, Name \'%.*s\' has become ''"
};
static const _error _error_OB_ERR_REMOVED_SPACES = {
      .error_name            = "OB_ERR_REMOVED_SPACES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_REMOVED_SPACES,
      .sqlstate              = "HY000",
      .str_error             = "Leading spaces are removed from name ",
      .str_user_error        = "Leading spaces are removed from name \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5247, Leading spaces are removed from name ",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5247, Leading spaces are removed from name \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5247, Leading spaces are removed from name ",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5247, Leading spaces are removed from name \'%.*s\'"
};
static const _error _error_OB_WARN_ADD_AUTOINCREMENT_COLUMN = {
      .error_name            = "OB_WARN_ADD_AUTOINCREMENT_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Alter table add auto_increment column is dangerous",
      .str_user_error        = "Alter table add auto_increment column is dangerous, table_name=\'%.*s\', column_name=\'%s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5248, Alter table add auto_increment column is dangerous",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5248, Alter table add auto_increment column is dangerous, table_name=\'%.*s\', column_name=\'%s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5248, Alter table add auto_increment column is dangerous",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5248, Alter table add auto_increment column is dangerous, table_name=\'%.*s\', column_name=\'%s\'"
};
static const _error _error_OB_WARN_CHAMGE_NULL_ATTRIBUTE = {
      .error_name            = "OB_WARN_CHAMGE_NULL_ATTRIBUTE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Alter table change nullable column to not nullable is dangerous",
      .str_user_error        = "Alter table change nullable column to not nullable is dangerous, table_name=\'%.*s\', column_name=\'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5249, Alter table change nullable column to not nullable is dangerous",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5249, Alter table change nullable column to not nullable is dangerous, table_name=\'%.*s\', column_name=\'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5249, Alter table change nullable column to not nullable is dangerous",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5249, Alter table change nullable column to not nullable is dangerous, table_name=\'%.*s\', column_name=\'%.*s\'"
};
static const _error _error_OB_ERR_INVALID_CHARACTER_STRING = {
      .error_name            = "OB_ERR_INVALID_CHARACTER_STRING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_CHARACTER_STRING,
      .sqlstate              = "HY000",
      .str_error             = "Invalid character string",
      .str_user_error        = "Invalid %.*s character string: \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5250, Invalid character string",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5250, Invalid %.*s character string: \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5250, Invalid character string",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5250, Invalid %.*s character string: \'%.*s\'"
};
static const _error _error_OB_ERR_KILL_DENIED = {
      .error_name            = "OB_ERR_KILL_DENIED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_KILL_DENIED_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "You are not owner of thread",
      .str_user_error        = "You are not owner of thread %lu",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5251, You are not owner of thread",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5251, You are not owner of thread %lu",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5251, You are not owner of thread",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5251, You are not owner of thread %lu"
};
static const _error _error_OB_ERR_COLUMN_DEFINITION_AMBIGUOUS = {
      .error_name            = "OB_ERR_COLUMN_DEFINITION_AMBIGUOUS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Column definition is ambiguous. Column has both NULL and NOT NULL attributes",
      .str_user_error        = "Column \'%.*s\' definition is ambiguous. Column has both NULL and NOT NULL attributes",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5252, Column definition is ambiguous. Column has both NULL and NOT NULL attributes",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5252, Column \'%.*s\' definition is ambiguous. Column has both NULL and NOT NULL attributes",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5252, Column definition is ambiguous. Column has both NULL and NOT NULL attributes",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5252, Column \'%.*s\' definition is ambiguous. Column has both NULL and NOT NULL attributes"
};
static const _error _error_OB_ERR_EMPTY_QUERY = {
      .error_name            = "OB_ERR_EMPTY_QUERY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_EMPTY_QUERY,
      .sqlstate              = "42000",
      .str_error             = "Query was empty",
      .str_user_error        = "Query was empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5253, Query was empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5253, Query was empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5253, Query was empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5253, Query was empty"
};
static const _error _error_OB_ERR_CUT_VALUE_GROUP_CONCAT = {
      .error_name            = "OB_ERR_CUT_VALUE_GROUP_CONCAT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CUT_VALUE_GROUP_CONCAT,
      .sqlstate              = "42000",
      .str_error             = "Row was cut by GROUP_CONCAT()",
      .str_user_error        = "Row %ld was cut by GROUP_CONCAT()",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5254, Row was cut by GROUP_CONCAT()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5254, Row %ld was cut by GROUP_CONCAT()",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5254, Row was cut by GROUP_CONCAT()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5254, Row %ld was cut by GROUP_CONCAT()"
};
static const _error _error_OB_ERR_FIELD_NOT_FOUND_PART = {
      .error_name            = "OB_ERR_FIELD_NOT_FOUND_PART",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FIELD_NOT_FOUND_PART_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Field in list of fields for partition function not found in table",
      .str_user_error        = "Field in list of fields for partition function not found in table",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5255, Field in list of fields for partition function not found in table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5255, Field in list of fields for partition function not found in table",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5255, Field in list of fields for partition function not found in table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5255, Field in list of fields for partition function not found in table"
};
static const _error _error_OB_ERR_PRIMARY_CANT_HAVE_NULL = {
      .error_name            = "OB_ERR_PRIMARY_CANT_HAVE_NULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PRIMARY_CANT_HAVE_NULL,
      .sqlstate              = "42000",
      .str_error             = "All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead",
      .str_user_error        = "All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5256, All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5256, All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5256, All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5256, All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead"
};
static const _error _error_OB_ERR_PARTITION_FUNC_NOT_ALLOWED_ERROR = {
      .error_name            = "OB_ERR_PARTITION_FUNC_NOT_ALLOWED_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_FUNC_NOT_ALLOWED_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "The PARTITION function returns the wrong type",
      .str_user_error        = "The PARTITION function returns the wrong type",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5257, The PARTITION function returns the wrong type",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5257, The PARTITION function returns the wrong type",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5257, The PARTITION function returns the wrong type",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5257, The PARTITION function returns the wrong type"
};
static const _error _error_OB_ERR_INVALID_BLOCK_SIZE = {
      .error_name            = "OB_ERR_INVALID_BLOCK_SIZE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid block size, block size should between 1024 and 1048576",
      .str_user_error        = "Invalid block size, block size should between 1024 and 1048576",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5258, Invalid block size, block size should between 1024 and 1048576",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5258, Invalid block size, block size should between 1024 and 1048576",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5258, Invalid block size, block size should between 1024 and 1048576",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5258, Invalid block size, block size should between 1024 and 1048576"
};
static const _error _error_OB_ERR_UNKNOWN_STORAGE_ENGINE = {
      .error_name            = "OB_ERR_UNKNOWN_STORAGE_ENGINE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNKNOWN_STORAGE_ENGINE,
      .sqlstate              = "42000",
      .str_error             = "Unknown storage engine",
      .str_user_error        = "Unknown storage engine \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5259, Unknown storage engine",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5259, Unknown storage engine \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5259, Unknown storage engine",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5259, Unknown storage engine \'%.*s\'"
};
static const _error _error_OB_ERR_TENANT_IS_LOCKED = {
      .error_name            = "OB_ERR_TENANT_IS_LOCKED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Tenant is locked",
      .str_user_error        = "Tenant \'%.*s\' is locked",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5260, Tenant is locked",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5260, Tenant \'%.*s\' is locked",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5260, Tenant is locked",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5260, Tenant \'%.*s\' is locked"
};
static const _error _error_OB_EER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF = {
      .error_name            = "OB_EER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF,
      .sqlstate              = "HY000",
      .str_error             = "A UNIQUE INDEX/PRIMARY KEY must include all columns in the table's partitioning function",
      .str_user_error        = "A %s must include all columns in the table's partitioning function",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5261, A UNIQUE INDEX/PRIMARY KEY must include all columns in the table's partitioning function",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5261, A %s must include all columns in the table's partitioning function",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5261, A UNIQUE INDEX/PRIMARY KEY must include all columns in the table's partitioning function",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5261, A %s must include all columns in the table's partitioning function"
};
static const _error _error_OB_ERR_PARTITION_FUNCTION_IS_NOT_ALLOWED = {
      .error_name            = "OB_ERR_PARTITION_FUNCTION_IS_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_FUNCTION_IS_NOT_ALLOWED,
      .sqlstate              = "HY000",
      .str_error             = "This partition function is not allowed",
      .str_user_error        = "This partition function is not allowed",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5262, This partition function is not allowed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5262, This partition function is not allowed",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5262, This partition function is not allowed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5262, This partition function is not allowed"
};
static const _error _error_OB_ERR_AGGREGATE_ORDER_FOR_UNION = {
      .error_name            = "OB_ERR_AGGREGATE_ORDER_FOR_UNION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_AGGREGATE_ORDER_FOR_UNION,
      .sqlstate              = "HY000",
      .str_error             = "aggregate order for union",
      .str_user_error        = "Expression #%d of ORDER BY contains aggregate function and applies to a UNION",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5263, aggregate order for union",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5263, Expression #%d of ORDER BY contains aggregate function and applies to a UNION",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5263, aggregate order for union",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5263, Expression #%d of ORDER BY contains aggregate function and applies to a UNION"
};
static const _error _error_OB_ERR_OUTLINE_EXIST = {
      .error_name            = "OB_ERR_OUTLINE_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Outline exists",
      .str_user_error        = "Outline '%.*s' already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5264, Outline exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5264, Outline '%.*s' already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5264, Outline exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5264, Outline '%.*s' already exists"
};
static const _error _error_OB_OUTLINE_NOT_EXIST = {
      .error_name            = "OB_OUTLINE_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Outline not exists",
      .str_user_error        = "Outline \'%.*s.%.*s\' doesn\'t exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5265, Outline not exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5265, Outline \'%.*s.%.*s\' doesn\'t exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5265, Outline not exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5265, Outline \'%.*s.%.*s\' doesn\'t exist"
};
static const _error _error_OB_WARN_OPTION_BELOW_LIMIT = {
      .error_name            = "OB_WARN_OPTION_BELOW_LIMIT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = WARN_OPTION_BELOW_LIMIT,
      .sqlstate              = "HY000",
      .str_error             = "The value should be no less than the limit",
      .str_user_error        = "The value of \'%s\' should be no less than the value of \'%s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5266, The value should be no less than the limit",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5266, The value of \'%s\' should be no less than the value of \'%s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5266, The value should be no less than the limit",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5266, The value of \'%s\' should be no less than the value of \'%s\'"
};
static const _error _error_OB_INVALID_OUTLINE = {
      .error_name            = "OB_INVALID_OUTLINE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid outline",
      .str_user_error        = "invalid outline ,error info:%s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5267, invalid outline",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5267, invalid outline ,error info:%s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5267, invalid outline",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5267, invalid outline ,error info:%s"
};
static const _error _error_OB_REACH_MAX_CONCURRENT_NUM = {
      .error_name            = "OB_REACH_MAX_CONCURRENT_NUM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "SQL reach max concurrent num",
      .str_user_error        = "SQL reach max concurrent num %ld",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5268, SQL reach max concurrent num",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5268, SQL reach max concurrent num %ld",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5268, SQL reach max concurrent num",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5268, SQL reach max concurrent num %ld"
};
static const _error _error_OB_ERR_OPERATION_ON_RECYCLE_OBJECT = {
      .error_name            = "OB_ERR_OPERATION_ON_RECYCLE_OBJECT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "can not perform DDL/DML over objects in Recycle Bin",
      .str_user_error        = "can not perform DDL/DML over objects in Recycle Bin",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5269, can not perform DDL/DML over objects in Recycle Bin",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5269, can not perform DDL/DML over objects in Recycle Bin",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5269, can not perform DDL/DML over objects in Recycle Bin",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5269, can not perform DDL/DML over objects in Recycle Bin"
};
static const _error _error_OB_ERR_OBJECT_NOT_IN_RECYCLEBIN = {
      .error_name            = "OB_ERR_OBJECT_NOT_IN_RECYCLEBIN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "object not in RECYCLE BIN",
      .str_user_error        = "object not in RECYCLE BIN",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5270, object not in RECYCLE BIN",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5270, object not in RECYCLE BIN",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5270, object not in RECYCLE BIN",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5270, object not in RECYCLE BIN"
};
static const _error _error_OB_ERR_CON_COUNT_ERROR = {
      .error_name            = "OB_ERR_CON_COUNT_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CON_COUNT_ERROR,
      .sqlstate              = "08004",
      .str_error             = "Too many connections",
      .str_user_error        = "Too many connections",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5271, Too many connections",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5271, Too many connections",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5271, Too many connections",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5271, Too many connections"
};
static const _error _error_OB_ERR_OUTLINE_CONTENT_EXIST = {
      .error_name            = "OB_ERR_OUTLINE_CONTENT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Outline content already exists when added",
      .str_user_error        = "Outline content '%.*s' of outline '%.*s' already exists when added",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5272, Outline content already exists when added",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5272, Outline content '%.*s' of outline '%.*s' already exists when added",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5272, Outline content already exists when added",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5272, Outline content '%.*s' of outline '%.*s' already exists when added"
};
static const _error _error_OB_ERR_OUTLINE_MAX_CONCURRENT_EXIST = {
      .error_name            = "OB_ERR_OUTLINE_MAX_CONCURRENT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Max concurrent already exists when added",
      .str_user_error        = "Max concurrent in outline '%.*s' already exists when added",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5273, Max concurrent already exists when added",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5273, Max concurrent in outline '%.*s' already exists when added",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5273, Max concurrent already exists when added",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5273, Max concurrent in outline '%.*s' already exists when added"
};
static const _error _error_OB_ERR_VALUES_IS_NOT_INT_TYPE_ERROR = {
      .error_name            = "OB_ERR_VALUES_IS_NOT_INT_TYPE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_VALUES_IS_NOT_INT_TYPE_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "VALUES value for partition must have type INT",
      .str_user_error        = "VALUES value for partition \'%.*s\' must have type INT",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5274, VALUES value for partition must have type INT",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5274, VALUES value for partition \'%.*s\' must have type INT",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5274, VALUES value for partition must have type INT",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5274, VALUES value for partition \'%.*s\' must have type INT"
};
static const _error _error_OB_ERR_WRONG_TYPE_COLUMN_VALUE_ERROR = {
      .error_name            = "OB_ERR_WRONG_TYPE_COLUMN_VALUE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_TYPE_COLUMN_VALUE_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Partition column values of incorrect type",
      .str_user_error        = "Partition column values of incorrect type",
      .oracle_errno          = 14019,
      .oracle_str_error      = "ORA-14019: partition bound element must be one of: string, datetime or interval literal, number, or MAXVALUE",
      .oracle_str_user_error = "ORA-14019: partition bound element must be one of: string, datetime or interval literal, number, or MAXVALUE",
      .ob_str_error          = "OBE-14019: partition bound element must be one of: string, datetime or interval literal, number, or MAXVALUE",
      .ob_str_user_error     = "OBE-14019: partition bound element must be one of: string, datetime or interval literal, number, or MAXVALUE"
};
static const _error _error_OB_ERR_PARTITION_COLUMN_LIST_ERROR = {
      .error_name            = "OB_ERR_PARTITION_COLUMN_LIST_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_COLUMN_LIST_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Inconsistency in usage of column lists for partitioning",
      .str_user_error        = "Inconsistency in usage of column lists for partitioning",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5276, Inconsistency in usage of column lists for partitioning",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5276, Inconsistency in usage of column lists for partitioning",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5276, Inconsistency in usage of column lists for partitioning",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5276, Inconsistency in usage of column lists for partitioning"
};
static const _error _error_OB_ERR_TOO_MANY_VALUES_ERROR = {
      .error_name            = "OB_ERR_TOO_MANY_VALUES_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_VALUES_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Cannot have more than one value for this type of RANGE partitioning",
      .str_user_error        = "Cannot have more than one value for this type of RANGE partitioning",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5277, Cannot have more than one value for this type of RANGE partitioning",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5277, Cannot have more than one value for this type of RANGE partitioning",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5277, Cannot have more than one value for this type of RANGE partitioning",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5277, Cannot have more than one value for this type of RANGE partitioning"
};
static const _error _error_OB_ERR_PARTITION_VALUE_ERROR = {
      .error_name            = "OB_ERR_PARTITION_VALUE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "This partition value with incorrect charset type",
      .str_user_error        = "This partition value with incorrect charset type",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5278, This partition value with incorrect charset type",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5278, This partition value with incorrect charset type",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5278, This partition value with incorrect charset type",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5278, This partition value with incorrect charset type"
};
static const _error _error_OB_ERR_PARTITION_INTERVAL_ERROR = {
      .error_name            = "OB_ERR_PARTITION_INTERVAL_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Partition interval must have type INT",
      .str_user_error        = "Partition interval must have type INT",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5279, Partition interval must have type INT",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5279, Partition interval must have type INT",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5279, Partition interval must have type INT",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5279, Partition interval must have type INT"
};
static const _error _error_OB_ERR_SAME_NAME_PARTITION = {
      .error_name            = "OB_ERR_SAME_NAME_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SAME_NAME_PARTITION,
      .sqlstate              = "HY000",
      .str_error             = "Duplicate partition name",
      .str_user_error        = "Duplicate partition name \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5280, Duplicate partition name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5280, Duplicate partition name \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5280, Duplicate partition name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5280, Duplicate partition name \'%.*s\'"
};
static const _error _error_OB_ERR_RANGE_NOT_INCREASING_ERROR = {
      .error_name            = "OB_ERR_RANGE_NOT_INCREASING_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_RANGE_NOT_INCREASING_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "VALUES LESS THAN value must be strictly increasing for each partition",
      .str_user_error        = "VALUES LESS THAN value must be strictly increasing for each partition%.*s",
      .oracle_errno          = 14037,
      .oracle_str_error      = "ORA-14037: partition bound is too high",
      .oracle_str_user_error = "ORA-14037: partition bound of partition '%.*s' is too high",
      .ob_str_error          = "OBE-14037: partition bound is too high",
      .ob_str_user_error     = "OBE-14037: partition bound of partition '%.*s' is too high"
};
static const _error _error_OB_ERR_PARSE_PARTITION_RANGE = {
      .error_name            = "OB_ERR_PARSE_PARTITION_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARSE_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Wrong number of partitions defined, mismatch with previous setting",
      .str_user_error        = "Wrong number of partitions defined, mismatch with previous setting",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5282, Wrong number of partitions defined, mismatch with previous setting",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5282, Wrong number of partitions defined, mismatch with previous setting",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5282, Wrong number of partitions defined, mismatch with previous setting",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5282, Wrong number of partitions defined, mismatch with previous setting"
};
static const _error _error_OB_ERR_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF = {
      .error_name            = "OB_ERR_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF,
      .sqlstate              = "HY000",
      .str_error             = "A PRIMARY KEY must include all columns in the table\'s partitioning function",
      .str_user_error        = "A PRIMARY KEY must include all columns in the table\'s partitioning function",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5283, A PRIMARY KEY must include all columns in the table\'s partitioning function",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5283, A PRIMARY KEY must include all columns in the table\'s partitioning function",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5283, A PRIMARY KEY must include all columns in the table\'s partitioning function",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5283, A PRIMARY KEY must include all columns in the table\'s partitioning function"
};
static const _error _error_OB_NO_PARTITION_FOR_GIVEN_VALUE = {
      .error_name            = "OB_NO_PARTITION_FOR_GIVEN_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_PARTITION_FOR_GIVEN_VALUE,
      .sqlstate              = "HY000",
      .str_error             = "Table has no partition for value",
      .str_user_error        = "Table has no partition for value",
      .oracle_errno          = 14400,
      .oracle_str_error      = "ORA-14400: inserted partition key does not map to any partition",
      .oracle_str_user_error = "ORA-14400: inserted partition key does not map to any partition",
      .ob_str_error          = "OBE-14400: inserted partition key does not map to any partition",
      .ob_str_user_error     = "OBE-14400: inserted partition key does not map to any partition"
};
static const _error _error_OB_EER_NULL_IN_VALUES_LESS_THAN = {
      .error_name            = "OB_EER_NULL_IN_VALUES_LESS_THAN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NULL_IN_VALUES_LESS_THAN,
      .sqlstate              = "HY000",
      .str_error             = "Not allowed to use NULL value in VALUES LESS THAN",
      .str_user_error        = "Not allowed to use NULL value in VALUES LESS THAN",
      .oracle_errno          = 14019,
      .oracle_str_error      = "ORA-14019: partition bound element must be one of: datetime or interval literal, number, or MAXVALUE",
      .oracle_str_user_error = "ORA-14019: partition bound element must be one of: datetime or interval literal, number, or MAXVALUE",
      .ob_str_error          = "OBE-14019: partition bound element must be one of: datetime or interval literal, number, or MAXVALUE",
      .ob_str_user_error     = "OBE-14019: partition bound element must be one of: datetime or interval literal, number, or MAXVALUE"
};
static const _error _error_OB_ERR_PARTITION_CONST_DOMAIN_ERROR = {
      .error_name            = "OB_ERR_PARTITION_CONST_DOMAIN_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_CONST_DOMAIN_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Partition constant is out of partition function domain",
      .str_user_error        = "Partition constant is out of partition function domain",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5286, Partition constant is out of partition function domain",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5286, Partition constant is out of partition function domain",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5286, Partition constant is out of partition function domain",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5286, Partition constant is out of partition function domain"
};
static const _error _error_OB_ERR_TOO_MANY_PARTITION_FUNC_FIELDS = {
      .error_name            = "OB_ERR_TOO_MANY_PARTITION_FUNC_FIELDS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Too many fields in \'list of partition fields\'",
      .str_user_error        = "Too many fields in \'list of partition fields\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5287, Too many fields in \'list of partition fields\'",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5287, Too many fields in \'list of partition fields\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5287, Too many fields in \'list of partition fields\'",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5287, Too many fields in \'list of partition fields\'"
};
static const _error _error_OB_ERR_BAD_FT_COLUMN = {
      .error_name            = "OB_ERR_BAD_FT_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_BAD_FT_COLUMN,
      .sqlstate              = "HY000",
      .str_error             = "Column cannot be part of FULLTEXT index",
      .str_user_error        = "Column '%.*s' cannot be part of FULLTEXT index",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5288, Column cannot be part of FULLTEXT index",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5288, Column '%.*s' cannot be part of FULLTEXT index",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5288, Column cannot be part of FULLTEXT index",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5288, Column '%.*s' cannot be part of FULLTEXT index"
};
static const _error _error_OB_ERR_KEY_DOES_NOT_EXISTS = {
      .error_name            = "OB_ERR_KEY_DOES_NOT_EXISTS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_KEY_DOES_NOT_EXITS,
      .sqlstate              = "42000",
      .str_error             = "key does not exist in table",
      .str_user_error        = "Key '%.*s' doesn't exist in table '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5289, key does not exist in table",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5289, Key '%.*s' doesn't exist in table '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5289, key does not exist in table",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5289, Key '%.*s' doesn't exist in table '%.*s'"
};
static const _error _error_OB_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN = {
      .error_name            = "OB_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN,
      .sqlstate              = "HY000",
      .str_error             = "non-default value for generated column is not allowed",
      .str_user_error        = "The value specified for generated column '%.*s' in table '%.*s' is not allowed",
      .oracle_errno          = 54013,
      .oracle_str_error      = "ORA-54013: INSERT operation disallowed on virtual columns",
      .oracle_str_user_error = "ORA-54013: INSERT operation disallowed on virtual columns '%.*s'.'%.*s'",
      .ob_str_error          = "OBE-54013: INSERT operation disallowed on virtual columns",
      .ob_str_user_error     = "OBE-54013: INSERT operation disallowed on virtual columns '%.*s'.'%.*s'"
};
static const _error _error_OB_ERR_BAD_CTXCAT_COLUMN = {
      .error_name            = "OB_ERR_BAD_CTXCAT_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The CTXCAT column must be contiguous in the index column list",
      .str_user_error        = "The CTXCAT column must be contiguous in the index column list",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5291, The CTXCAT column must be contiguous in the index column list",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5291, The CTXCAT column must be contiguous in the index column list",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5291, The CTXCAT column must be contiguous in the index column list",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5291, The CTXCAT column must be contiguous in the index column list"
};
static const _error _error_OB_ERR_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN = {
      .error_name            = "OB_ERR_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN,
      .sqlstate              = "HY000",
      .str_error             = "not supported for generated columns",
      .str_user_error        = "'%s' is not supported for generated columns.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5292, not supported for generated columns",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5292, '%s' is not supported for generated columns.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5292, not supported for generated columns",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5292, '%s' is not supported for generated columns."
};
static const _error _error_OB_ERR_DEPENDENT_BY_GENERATED_COLUMN = {
      .error_name            = "OB_ERR_DEPENDENT_BY_GENERATED_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DEPENDENT_BY_GENERATED_COLUMN,
      .sqlstate              = "HY000",
      .str_error             = "Column has a generated column dependency",
      .str_user_error        = "Column '%.*s' has a generated column dependency",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5293, Column has a generated column dependency",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5293, Column '%.*s' has a generated column dependency",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5293, Column has a generated column dependency",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5293, Column '%.*s' has a generated column dependency"
};
static const _error _error_OB_ERR_TOO_MANY_ROWS = {
      .error_name            = "OB_ERR_TOO_MANY_ROWS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_MANY_ROWS,
      .sqlstate              = "42000",
      .str_error             = "Result consisted of more than one row",
      .str_user_error        = "Result consisted of more than one row",
      .oracle_errno          = 1422,
      .oracle_str_error      = "ORA-01422: exact fetch returns more than requested number of rows",
      .oracle_str_user_error = "ORA-01422: exact fetch returns more than requested number of rows",
      .ob_str_error          = "OBE-01422: exact fetch returns more than requested number of rows",
      .ob_str_user_error     = "OBE-01422: exact fetch returns more than requested number of rows"
};
static const _error _error_OB_WRONG_FIELD_TERMINATORS = {
      .error_name            = "OB_WRONG_FIELD_TERMINATORS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_FIELD_TERMINATORS,
      .sqlstate              = "42000",
      .str_error             = "Field separator argument is not what is expected; check the manual",
      .str_user_error        = "Field separator argument is not what is expected; check the manual",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5295, Field separator argument is not what is expected; check the manual",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5295, Field separator argument is not what is expected; check the manual",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5295, Field separator argument is not what is expected; check the manual",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5295, Field separator argument is not what is expected; check the manual"
};
static const _error _error_OB_NO_READABLE_REPLICA = {
      .error_name            = "OB_NO_READABLE_REPLICA",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "there has no readable replica",
      .str_user_error        = "there has no readable replica",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5296, there has no readable replica",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5296, there has no readable replica",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5296, there has no readable replica",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5296, there has no readable replica"
};
static const _error _error_OB_ERR_UNEXPECTED_TZ_TRANSITION = {
      .error_name            = "OB_ERR_UNEXPECTED_TZ_TRANSITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "unexpected time zone info transition",
      .str_user_error        = "unexpected time zone info transition",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5297, unexpected time zone info transition",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5297, unexpected time zone info transition",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5297, unexpected time zone info transition",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5297, unexpected time zone info transition"
};
static const _error _error_OB_ERR_SYNONYM_EXIST = {
      .error_name            = "OB_ERR_SYNONYM_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "synonym exists",
      .str_user_error        = "synonym '%.*s' already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5298, synonym exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5298, synonym '%.*s' already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5298, synonym exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5298, synonym '%.*s' already exists"
};
static const _error _error_OB_SYNONYM_NOT_EXIST = {
      .error_name            = "OB_SYNONYM_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "synonym not exists",
      .str_user_error        = "synonym \'%.*s.%.*s\' doesn\'t exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5299, synonym not exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5299, synonym \'%.*s.%.*s\' doesn\'t exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5299, synonym not exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5299, synonym \'%.*s.%.*s\' doesn\'t exist"
};
static const _error _error_OB_ERR_MISS_ORDER_BY_EXPR = {
      .error_name            = "OB_ERR_MISS_ORDER_BY_EXPR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "missing ORDER BY expression in the window specification",
      .str_user_error        = "missing ORDER BY expression in the window specification",
      .oracle_errno          = 30485,
      .oracle_str_error      = "ORA-30485: missing ORDER BY expression in the window specification",
      .oracle_str_user_error = "ORA-30485: missing ORDER BY expression in the window specification",
      .ob_str_error          = "OBE-30485: missing ORDER BY expression in the window specification",
      .ob_str_user_error     = "OBE-30485: missing ORDER BY expression in the window specification"
};
static const _error _error_OB_ERR_NOT_CONST_EXPR = {
      .error_name            = "OB_ERR_NOT_CONST_EXPR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "The argument of the window function should be a constant for a partition",
      .str_user_error        = "The argument of the window function should be a constant for a partition",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5301, The argument of the window function should be a constant for a partition",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5301, The argument of the window function should be a constant for a partition",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5301, The argument of the window function should be a constant for a partition",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5301, The argument of the window function should be a constant for a partition"
};
static const _error _error_OB_ERR_PARTITION_MGMT_ON_NONPARTITIONED = {
      .error_name            = "OB_ERR_PARTITION_MGMT_ON_NONPARTITIONED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_MGMT_ON_NONPARTITIONED,
      .sqlstate              = "HY000",
      .str_error             = "Partition management on a not partitioned table is not possible",
      .str_user_error        = "Partition management on a not partitioned table is not possible",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5302, Partition management on a not partitioned table is not possible",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5302, Partition management on a not partitioned table is not possible",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5302, Partition management on a not partitioned table is not possible",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5302, Partition management on a not partitioned table is not possible"
};
static const _error _error_OB_ERR_DROP_PARTITION_NON_EXISTENT = {
      .error_name            = "OB_ERR_DROP_PARTITION_NON_EXISTENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DROP_PARTITION_NON_EXISTENT,
      .sqlstate              = "HY000",
      .str_error             = "Error in list of partitions to DROP",
      .str_user_error        = "Error in list of partitions to DROP",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5303, Error in list of partitions to DROP",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5303, Error in list of partitions to DROP",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5303, Error in list of partitions to DROP",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5303, Error in list of partitions to DROP"
};
static const _error _error_OB_ERR_PARTITION_MGMT_ON_TWOPART_TABLE = {
      .error_name            = "OB_ERR_PARTITION_MGMT_ON_TWOPART_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Partition management on a two-part table is not possible",
      .str_user_error        = "Partition management on a two-part table is not possible",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5304, Partition management on a two-part table is not possible",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5304, Partition management on a two-part table is not possible",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5304, Partition management on a two-part table is not possible",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5304, Partition management on a two-part table is not possible"
};
static const _error _error_OB_ERR_ONLY_ON_RANGE_LIST_PARTITION = {
      .error_name            = "OB_ERR_ONLY_ON_RANGE_LIST_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ONLY_ON_RANGE_LIST_PARTITION,
      .sqlstate              = "HY000",
      .str_error             = "can only be used on RANGE/LIST partitions",
      .str_user_error        = "%s PARTITION can only be used on RANGE/LIST partitions",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5305, can only be used on RANGE/LIST partitions",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5305, %s PARTITION can only be used on RANGE/LIST partitions",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5305, can only be used on RANGE/LIST partitions",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5305, %s PARTITION can only be used on RANGE/LIST partitions"
};
static const _error _error_OB_ERR_DROP_LAST_PARTITION = {
      .error_name            = "OB_ERR_DROP_LAST_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DROP_LAST_PARTITION,
      .sqlstate              = "HY000",
      .str_error             = "Cannot remove all partitions, use DROP TABLE instead",
      .str_user_error        = "Cannot remove all partitions, use DROP TABLE instead",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5306, Cannot remove all partitions, use DROP TABLE instead",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5306, Cannot remove all partitions, use DROP TABLE instead",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5306, Cannot remove all partitions, use DROP TABLE instead",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5306, Cannot remove all partitions, use DROP TABLE instead"
};
static const _error _error_OB_ERR_PARALLEL_SERVERS_TARGET_NOT_ENOUGH = {
      .error_name            = "OB_ERR_PARALLEL_SERVERS_TARGET_NOT_ENOUGH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Not enough thread resource to execute the query. Maybe parallel_servers_target was set too low.",
      .str_user_error        = "Not enough thread resource to execute the query. Require setting parallel_servers_target to a value no less than %ld for this query",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5307, Not enough thread resource to execute the query. Maybe parallel_servers_target was set too low.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5307, Not enough thread resource to execute the query. Require setting parallel_servers_target to a value no less than %ld for this query",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5307, Not enough thread resource to execute the query. Maybe parallel_servers_target was set too low.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5307, Not enough thread resource to execute the query. Require setting parallel_servers_target to a value no less than %ld for this query"
};
static const _error _error_OB_ERR_IGNORE_USER_HOST_NAME = {
      .error_name            = "OB_ERR_IGNORE_USER_HOST_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Ignore the host name",
      .str_user_error        = "Ignore the host name",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5308, Ignore the host name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5308, Ignore the host name",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5308, Ignore the host name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5308, Ignore the host name"
};
static const _error _error_OB_IGNORE_SQL_IN_RESTORE = {
      .error_name            = "OB_IGNORE_SQL_IN_RESTORE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Ignore sql in restore process",
      .str_user_error        = "Ignore sql in restore process",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5309, Ignore sql in restore process",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5309, Ignore sql in restore process",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5309, Ignore sql in restore process",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5309, Ignore sql in restore process"
};
static const _error _error_OB_ERR_TEMPORARY_TABLE_WITH_PARTITION = {
      .error_name            = "OB_ERR_TEMPORARY_TABLE_WITH_PARTITION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PARTITION_NO_TEMPORARY,
      .sqlstate              = "HY000",
      .str_error             = "Cannot create temporary table with partitions",
      .str_user_error        = "Cannot create temporary table with partitions",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5310, Cannot create temporary table with partitions",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5310, Cannot create temporary table with partitions",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5310, Cannot create temporary table with partitions",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5310, Cannot create temporary table with partitions"
};
static const _error _error_OB_ERR_INVALID_COLUMN_ID = {
      .error_name            = "OB_ERR_INVALID_COLUMN_ID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid column id",
      .str_user_error        = "Invalid column id for %.*s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5311, Invalid column id",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5311, Invalid column id for %.*s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5311, Invalid column id",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5311, Invalid column id for %.*s"
};
static const _error _error_OB_SYNC_DDL_DUPLICATE = {
      .error_name            = "OB_SYNC_DDL_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Duplicated ddl id",
      .str_user_error        = "Duplicated ddl id '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5312, Duplicated ddl id",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5312, Duplicated ddl id '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5312, Duplicated ddl id",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5312, Duplicated ddl id '%.*s'"
};
static const _error _error_OB_SYNC_DDL_ERROR = {
      .error_name            = "OB_SYNC_DDL_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Failed to sync ddl",
      .str_user_error        = "Failed to sync ddl '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5313, Failed to sync ddl",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5313, Failed to sync ddl '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5313, Failed to sync ddl",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5313, Failed to sync ddl '%.*s'"
};
static const _error _error_OB_ERR_ROW_IS_REFERENCED = {
      .error_name            = "OB_ERR_ROW_IS_REFERENCED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ROW_IS_REFERENCED_2,
      .sqlstate              = "23000",
      .str_error             = "Cannot delete or update a parent row: a foreign key constraint fails",
      .str_user_error        = "Cannot delete or update a parent row: a foreign key constraint fails",
      .oracle_errno          = 2292,
      .oracle_str_error      = "ORA-02292: integrity constraint violated - child record found",
      .oracle_str_user_error = "ORA-02292: integrity constraint violated - child record found",
      .ob_str_error          = "OBE-02292: integrity constraint violated - child record found",
      .ob_str_user_error     = "OBE-02292: integrity constraint violated - child record found"
};
static const _error _error_OB_ERR_NO_REFERENCED_ROW = {
      .error_name            = "OB_ERR_NO_REFERENCED_ROW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NO_REFERENCED_ROW_2,
      .sqlstate              = "23000",
      .str_error             = "Cannot add or update a child row: a foreign key constraint fails",
      .str_user_error        = "Cannot add or update a child row: a foreign key constraint fails",
      .oracle_errno          = 2291,
      .oracle_str_error      = "ORA-02291: integrity constraint violated - parent key not found",
      .oracle_str_user_error = "ORA-02291: integrity constraint violated - parent key not found",
      .ob_str_error          = "OBE-02291: integrity constraint violated - parent key not found",
      .ob_str_user_error     = "OBE-02291: integrity constraint violated - parent key not found"
};
static const _error _error_OB_ERR_FUNC_RESULT_TOO_LARGE = {
      .error_name            = "OB_ERR_FUNC_RESULT_TOO_LARGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_ALLOWED_PACKET_OVERFLOWED,
      .sqlstate              = "HY000",
      .str_error             = "Result of function was larger than max_allowed_packet - truncated",
      .str_user_error        = "Result of %s() was larger than max_allowed_packet (%d) - truncated",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5316, Result of function was larger than max_allowed_packet - truncated",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5316, Result of %s() was larger than max_allowed_packet (%d) - truncated",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5316, Result of function was larger than max_allowed_packet - truncated",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5316, Result of %s() was larger than max_allowed_packet (%d) - truncated"
};
static const _error _error_OB_ERR_CANNOT_ADD_FOREIGN = {
      .error_name            = "OB_ERR_CANNOT_ADD_FOREIGN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANNOT_ADD_FOREIGN,
      .sqlstate              = "HY000",
      .str_error             = "Cannot add foreign key constraint",
      .str_user_error        = "Cannot add foreign key constraint",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5317, Cannot add foreign key constraint",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5317, Cannot add foreign key constraint",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5317, Cannot add foreign key constraint",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5317, Cannot add foreign key constraint"
};
static const _error _error_OB_ERR_WRONG_FK_DEF = {
      .error_name            = "OB_ERR_WRONG_FK_DEF",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_FK_DEF,
      .sqlstate              = "42000",
      .str_error             = "Incorrect foreign key definition: Key reference and table reference don't match",
      .str_user_error        = "Incorrect foreign key definition: Key reference and table reference don't match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5318, Incorrect foreign key definition: Key reference and table reference don't match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5318, Incorrect foreign key definition: Key reference and table reference don't match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5318, Incorrect foreign key definition: Key reference and table reference don't match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5318, Incorrect foreign key definition: Key reference and table reference don't match"
};
static const _error _error_OB_ERR_INVALID_CHILD_COLUMN_LENGTH_FK = {
      .error_name            = "OB_ERR_INVALID_CHILD_COLUMN_LENGTH_FK",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Invalid child column length",
      .str_user_error        = "Child column \'%.*s\' data length cannot be less than parent column \'%.*s\' data length",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5319, Invalid child column length",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5319, Child column \'%.*s\' data length cannot be less than parent column \'%.*s\' data length",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5319, Invalid child column length",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5319, Child column \'%.*s\' data length cannot be less than parent column \'%.*s\' data length"
};
static const _error _error_OB_ERR_ALTER_COLUMN_FK = {
      .error_name            = "OB_ERR_ALTER_COLUMN_FK",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Cannot alter foreign key column",
      .str_user_error        = "\'%.*s\': used in a foreign key constraint",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5320, Cannot alter foreign key column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5320, \'%.*s\': used in a foreign key constraint",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5320, Cannot alter foreign key column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5320, \'%.*s\': used in a foreign key constraint"
};
static const _error _error_OB_ERR_CONNECT_BY_REQUIRED = {
      .error_name            = "OB_ERR_CONNECT_BY_REQUIRED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "CONNECT BY clause required in this query block",
      .str_user_error        = "CONNECT BY clause required in this query block",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5321, CONNECT BY clause required in this query block",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5321, CONNECT BY clause required in this query block",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5321, CONNECT BY clause required in this query block",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5321, CONNECT BY clause required in this query block"
};
static const _error _error_OB_ERR_INVALID_PSEUDO_COLUMN_PLACE = {
      .error_name            = "OB_ERR_INVALID_PSEUDO_COLUMN_PLACE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Specified pseudocolumn, operator or function not allowed here",
      .str_user_error        = "Specified pseudocolumn, operator or function not allowed here",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5322, Specified pseudocolumn, operator or function not allowed here",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5322, Specified pseudocolumn, operator or function not allowed here",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5322, Specified pseudocolumn, operator or function not allowed here",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5322, Specified pseudocolumn, operator or function not allowed here"
};
static const _error _error_OB_ERR_NOCYCLE_REQUIRED = {
      .error_name            = "OB_ERR_NOCYCLE_REQUIRED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "NOCYCLE keyword is required with CONNECT_BY_ISCYCLE pseudocolumn",
      .str_user_error        = "NOCYCLE keyword is required with CONNECT_BY_ISCYCLE pseudocolumn",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5323, NOCYCLE keyword is required with CONNECT_BY_ISCYCLE pseudocolumn",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5323, NOCYCLE keyword is required with CONNECT_BY_ISCYCLE pseudocolumn",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5323, NOCYCLE keyword is required with CONNECT_BY_ISCYCLE pseudocolumn",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5323, NOCYCLE keyword is required with CONNECT_BY_ISCYCLE pseudocolumn"
};
static const _error _error_OB_ERR_CONNECT_BY_LOOP = {
      .error_name            = "OB_ERR_CONNECT_BY_LOOP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "CONNECT BY loop in user data",
      .str_user_error        = "CONNECT BY loop in user data",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5324, CONNECT BY loop in user data",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5324, CONNECT BY loop in user data",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5324, CONNECT BY loop in user data",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5324, CONNECT BY loop in user data"
};
static const _error _error_OB_ERR_INVALID_SIBLINGS = {
      .error_name            = "OB_ERR_INVALID_SIBLINGS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ORDER SIBLINGS BY clause not allowed here",
      .str_user_error        = "ORDER SIBLINGS BY clause not allowed here",
      .oracle_errno          = 30929,
      .oracle_str_error      = "ORA-30929: ORDER SIBLINGS BY clause not allowed here",
      .oracle_str_user_error = "ORA-30929: ORDER SIBLINGS BY clause not allowed here",
      .ob_str_error          = "OBE-30929: ORDER SIBLINGS BY clause not allowed here",
      .ob_str_user_error     = "OBE-30929: ORDER SIBLINGS BY clause not allowed here"
};
static const _error _error_OB_ERR_INVALID_SEPARATOR = {
      .error_name            = "OB_ERR_INVALID_SEPARATOR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "when using SYS_CONNECT_BY_PATH function, cannot have separator as part of column value",
      .str_user_error        = "when using SYS_CONNECT_BY_PATH function, cannot have separator as part of column value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5326, when using SYS_CONNECT_BY_PATH function, cannot have separator as part of column value",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5326, when using SYS_CONNECT_BY_PATH function, cannot have separator as part of column value",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5326, when using SYS_CONNECT_BY_PATH function, cannot have separator as part of column value",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5326, when using SYS_CONNECT_BY_PATH function, cannot have separator as part of column value"
};
static const _error _error_OB_ERR_INVALID_SYNONYM_NAME = {
      .error_name            = "OB_ERR_INVALID_SYNONYM_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Database can not be specified in public synonym",
      .str_user_error        = "Database can not be specified in public synonym",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5327, Database can not be specified in public synonym",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5327, Database can not be specified in public synonym",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5327, Database can not be specified in public synonym",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5327, Database can not be specified in public synonym"
};
static const _error _error_OB_ERR_LOOP_OF_SYNONYM = {
      .error_name            = "OB_ERR_LOOP_OF_SYNONYM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Looping chain of synonyms",
      .str_user_error        = "Looping chain of synonyms",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5328, Looping chain of synonyms",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5328, Looping chain of synonyms",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5328, Looping chain of synonyms",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5328, Looping chain of synonyms"
};
static const _error _error_OB_ERR_SYNONYM_SAME_AS_OBJECT = {
      .error_name            = "OB_ERR_SYNONYM_SAME_AS_OBJECT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Cannot create a synonym with same name as object",
      .str_user_error        = "Cannot create a synonym with same name as object",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5329, Cannot create a synonym with same name as object",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5329, Cannot create a synonym with same name as object",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5329, Cannot create a synonym with same name as object",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5329, Cannot create a synonym with same name as object"
};
static const _error _error_OB_ERR_SYNONYM_TRANSLATION_INVALID = {
      .error_name            = "OB_ERR_SYNONYM_TRANSLATION_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Synonym translation is no longer valid",
      .str_user_error        = "Synonym %s translation is no longer valid",
      .oracle_errno          = 980,
      .oracle_str_error      = "ORA-00980: synonym translation is no longer valid",
      .oracle_str_user_error = "ORA-00980: synonym %s translation is no longer valid",
      .ob_str_error          = "OBE-00980: synonym translation is no longer valid",
      .ob_str_user_error     = "OBE-00980: synonym %s translation is no longer valid"
};
static const _error _error_OB_ERR_EXIST_OBJECT = {
      .error_name            = "OB_ERR_EXIST_OBJECT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "name is already used by an existing object",
      .str_user_error        = "name is already used by an existing object",
      .oracle_errno          = 955,
      .oracle_str_error      = "ORA-00955: name is already used by an existing object",
      .oracle_str_user_error = "ORA-00955: name is already used by an existing object",
      .ob_str_error          = "OBE-00955: name is already used by an existing object",
      .ob_str_user_error     = "OBE-00955: name is already used by an existing object"
};
static const _error _error_OB_ERR_ILLEGAL_VALUE_FOR_TYPE = {
      .error_name            = "OB_ERR_ILLEGAL_VALUE_FOR_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ILLEGAL_VALUE_FOR_TYPE,
      .sqlstate              = "22007",
      .str_error             = "Illegal value found during parsing",
      .str_user_error        = "Illegal %s '%.*s' value found during parsing",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5332, Illegal value found during parsing",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5332, Illegal %s '%.*s' value found during parsing",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5332, Illegal value found during parsing",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5332, Illegal %s '%.*s' value found during parsing"
};
static const _error _error_OB_ER_TOO_LONG_SET_ENUM_VALUE = {
      .error_name            = "OB_ER_TOO_LONG_SET_ENUM_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_LONG_SET_ENUM_VALUE,
      .sqlstate              = "HY000",
      .str_error             = "Too long enumeration/set value for column.",
      .str_user_error        = "Too long enumeration/set value for column %.*s.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5333, Too long enumeration/set value for column.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5333, Too long enumeration/set value for column %.*s.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5333, Too long enumeration/set value for column.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5333, Too long enumeration/set value for column %.*s."
};
static const _error _error_OB_ER_DUPLICATED_VALUE_IN_TYPE = {
      .error_name            = "OB_ER_DUPLICATED_VALUE_IN_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DUPLICATED_VALUE_IN_TYPE,
      .sqlstate              = "HY000",
      .str_error             = "Column has duplicated value",
      .str_user_error        = "Column '%.*s' has duplicated value '%.*s' in %s ",
      .oracle_errno          = 1,
      .oracle_str_error      = "ORA-00001: unique constraint violated",
      .oracle_str_user_error = "ORA-00001: unique constraint violated, column '%.*s' with value '%.*s' in %s",
      .ob_str_error          = "OBE-00001: unique constraint violated",
      .ob_str_user_error     = "OBE-00001: unique constraint violated, column '%.*s' with value '%.*s' in %s"
};
static const _error _error_OB_ER_TOO_BIG_ENUM = {
      .error_name            = "OB_ER_TOO_BIG_ENUM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_BIG_ENUM,
      .sqlstate              = "HY000",
      .str_error             = "Too many enumeration values for column",
      .str_user_error        = "Too many enumeration values for column %.*s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5335, Too many enumeration values for column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5335, Too many enumeration values for column %.*s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5335, Too many enumeration values for column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5335, Too many enumeration values for column %.*s"
};
static const _error _error_OB_ERR_TOO_BIG_SET = {
      .error_name            = "OB_ERR_TOO_BIG_SET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TOO_BIG_SET,
      .sqlstate              = "HY000",
      .str_error             = "Too many strings for column",
      .str_user_error        = "Too many strings for column %.*s and SET",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5336, Too many strings for column",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5336, Too many strings for column %.*s and SET",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5336, Too many strings for column",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5336, Too many strings for column %.*s and SET"
};
static const _error _error_OB_ERR_WRONG_ROWID = {
      .error_name            = "OB_ERR_WRONG_ROWID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "rowid is wrong",
      .str_user_error        = "rowid is wrong",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5337, rowid is wrong",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5337, rowid is wrong",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5337, rowid is wrong",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5337, rowid is wrong"
};
static const _error _error_OB_ERR_INVALID_WINDOW_FUNCTION_PLACE = {
      .error_name            = "OB_ERR_INVALID_WINDOW_FUNCTION_PLACE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Window Function not allowed here",
      .str_user_error        = "Window Function not allowed here",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5338, Window Function not allowed here",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5338, Window Function not allowed here",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5338, Window Function not allowed here",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5338, Window Function not allowed here"
};
static const _error _error_OB_ERR_PARSE_PARTITION_LIST = {
      .error_name            = "OB_ERR_PARSE_PARTITION_LIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Fail to parse list partition",
      .str_user_error        = "Fail to parse list partition",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5339, Fail to parse list partition",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5339, Fail to parse list partition",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5339, Fail to parse list partition",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5339, Fail to parse list partition"
};
static const _error _error_OB_ERR_MULTIPLE_DEF_CONST_IN_LIST_PART = {
      .error_name            = "OB_ERR_MULTIPLE_DEF_CONST_IN_LIST_PART",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Multiple definition of same constant in list partitioning",
      .str_user_error        = "Multiple definition of same constant in list partitioning",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5340, Multiple definition of same constant in list partitioning",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5340, Multiple definition of same constant in list partitioning",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5340, Multiple definition of same constant in list partitioning",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5340, Multiple definition of same constant in list partitioning"
};
static const _error _error_OB_ERR_INVALID_TIMEZONE_REGION_ID = {
      .error_name            = "OB_ERR_INVALID_TIMEZONE_REGION_ID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "timezone region ID is invalid",
      .str_user_error        = "timezone region ID is invalid",
      .oracle_errno          = 1881,
      .oracle_str_error      = "ORA-01881: timezone region ID is invalid",
      .oracle_str_user_error = "ORA-01881: timezone region ID is invalid",
      .ob_str_error          = "OBE-01881: timezone region ID is invalid",
      .ob_str_user_error     = "OBE-01881: timezone region ID is invalid"
};
static const _error _error_OB_ERR_INVALID_HEX_NUMBER = {
      .error_name            = "OB_ERR_INVALID_HEX_NUMBER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid hex number",
      .str_user_error        = "invalid hex number",
      .oracle_errno          = 1465,
      .oracle_str_error      = "ORA-01465: invalid hex number",
      .oracle_str_user_error = "ORA-01465: invalid hex number",
      .ob_str_error          = "OBE-01465: invalid hex number",
      .ob_str_user_error     = "OBE-01465: invalid hex number"
};
static const _error _error_OB_ERR_WRONG_FUNC_ARGUMENTS_TYPE = {
      .error_name            = "OB_ERR_WRONG_FUNC_ARGUMENTS_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "wrong number or types of arguments in function",
      .str_user_error        = "wrong number or types of arguments in call to '%.*s'",
      .oracle_errno          = 6553,
      .oracle_str_error      = "ORA-06553: wrong number or types of arguments in function",
      .oracle_str_user_error = "ORA-06553: wrong number or types of arguments in call to '%.*s'",
      .ob_str_error          = "OBE-06553: wrong number or types of arguments in function",
      .ob_str_user_error     = "OBE-06553: wrong number or types of arguments in call to '%.*s'"
};
static const _error _error_OB_ERR_MULTI_UPDATE_KEY_CONFLICT = {
      .error_name            = "OB_ERR_MULTI_UPDATE_KEY_CONFLICT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_MULTI_UPDATE_KEY_CONFLICT,
      .sqlstate              = "HY000",
      .str_error             = "Primary key/index key/partition key update is not allowed",
      .str_user_error        = "Primary key/index key/partition key update is not allowed since the table is updated both as '%.*s' and '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5344, Primary key/index key/partition key update is not allowed",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5344, Primary key/index key/partition key update is not allowed since the table is updated both as '%.*s' and '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5344, Primary key/index key/partition key update is not allowed",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5344, Primary key/index key/partition key update is not allowed since the table is updated both as '%.*s' and '%.*s'"
};
static const _error _error_OB_ERR_INSUFFICIENT_PX_WORKER = {
      .error_name            = "OB_ERR_INSUFFICIENT_PX_WORKER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "insufficient parallel query worker available",
      .str_user_error        = "insufficient parallel query worker available",
      .oracle_errno          = 12827,
      .oracle_str_error      = "ORA-12827: insufficient parallel query worker available",
      .oracle_str_user_error = "ORA-12827: insufficient parallel query worker available",
      .ob_str_error          = "OBE-12827: insufficient parallel query worker available",
      .ob_str_user_error     = "OBE-12827: insufficient parallel query worker available"
};
static const _error _error_OB_ERR_FOR_UPDATE_EXPR_NOT_ALLOWED = {
      .error_name            = "OB_ERR_FOR_UPDATE_EXPR_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "FOR UPDATE of this query expression is not allowed",
      .str_user_error        = "FOR UPDATE of this query expression is not allowed",
      .oracle_errno          = 1786,
      .oracle_str_error      = "ORA-01786: FOR UPDATE of this query expression is not allowed",
      .oracle_str_user_error = "ORA-01786: FOR UPDATE of this query expression is not allowed",
      .ob_str_error          = "OBE-01786: FOR UPDATE of this query expression is not allowed",
      .ob_str_user_error     = "OBE-01786: FOR UPDATE of this query expression is not allowed"
};
static const _error _error_OB_ERR_WIN_FUNC_ARG_NOT_IN_PARTITION_BY = {
      .error_name            = "OB_ERR_WIN_FUNC_ARG_NOT_IN_PARTITION_BY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "argument should be a function of expressions in PARTITION BY",
      .str_user_error        = "argument should be a function of expressions in PARTITION BY",
      .oracle_errno          = 30488,
      .oracle_str_error      = "ORA-30488: argument should be a function of expressions in PARTITION BY",
      .oracle_str_user_error = "ORA-30488: argument should be a function of expressions in PARTITION BY",
      .ob_str_error          = "OBE-30488: argument should be a function of expressions in PARTITION BY",
      .ob_str_user_error     = "OBE-30488: argument should be a function of expressions in PARTITION BY"
};
static const _error _error_OB_ERR_TOO_LONG_STRING_IN_CONCAT = {
      .error_name            = "OB_ERR_TOO_LONG_STRING_IN_CONCAT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "result of string concatenation is too long",
      .str_user_error        = "result of string concatenation is too long",
      .oracle_errno          = 1489,
      .oracle_str_error      = "ORA-01489: result of string concatenation is too long",
      .oracle_str_user_error = "ORA-01489: result of string concatenation is too long",
      .ob_str_error          = "OBE-01489: result of string concatenation is too long",
      .ob_str_user_error     = "OBE-01489: result of string concatenation is too long"
};
static const _error _error_OB_ERR_WRONG_TIMESTAMP_LTZ_COLUMN_VALUE_ERROR = {
      .error_name            = "OB_ERR_WRONG_TIMESTAMP_LTZ_COLUMN_VALUE_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_TYPE_COLUMN_VALUE_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Partition column values of incorrect type",
      .str_user_error        = "Partition column values of incorrect type",
      .oracle_errno          = 30078,
      .oracle_str_error      = "ORA-30078: partition bound must be TIME/TIMESTAMP WITH TIME ZONE literals",
      .oracle_str_user_error = "ORA-30078: partition bound must be TIME/TIMESTAMP WITH TIME ZONE literals",
      .ob_str_error          = "OBE-30078: partition bound must be TIME/TIMESTAMP WITH TIME ZONE literals",
      .ob_str_user_error     = "OBE-30078: partition bound must be TIME/TIMESTAMP WITH TIME ZONE literals"
};
static const _error _error_OB_ERR_UPD_CAUSE_PART_CHANGE = {
      .error_name            = "OB_ERR_UPD_CAUSE_PART_CHANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "updating partition key column would cause a partition change",
      .str_user_error        = "updating partition key column would cause a partition change",
      .oracle_errno          = 14402,
      .oracle_str_error      = "ORA-14402: updating partition key column would cause a partition change",
      .oracle_str_user_error = "ORA-14402: updating partition key column would cause a partition change",
      .ob_str_error          = "OBE-14402: updating partition key column would cause a partition change",
      .ob_str_user_error     = "OBE-14402: updating partition key column would cause a partition change"
};
static const _error _error_OB_ERR_INVALID_TYPE_FOR_ARGUMENT = {
      .error_name            = "OB_ERR_INVALID_TYPE_FOR_ARGUMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INCORRECT_TYPE,
      .sqlstate              = "HY000",
      .str_error             = "invalid type given for an argument",
      .str_user_error        = "invalid type given for an argument",
      .oracle_errno          = 30175,
      .oracle_str_error      = "ORA-30175: invalid type given for an argument",
      .oracle_str_user_error = "ORA-30175: invalid type given for an argument",
      .ob_str_error          = "OBE-30175: invalid type given for an argument",
      .ob_str_user_error     = "OBE-30175: invalid type given for an argument"
};
static const _error _error_OB_ERR_FIELD_NOT_FOUND_IN_DATETIME_OR_INTERVAL = {
      .error_name            = "OB_ERR_FIELD_NOT_FOUND_IN_DATETIME_OR_INTERVAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "specified field not found in datetime or interval",
      .str_user_error        = "specified field not found in datetime or interval",
      .oracle_errno          = 1878,
      .oracle_str_error      = "ORA-01878: specified field not found in datetime or interval",
      .oracle_str_user_error = "ORA-01878: specified field not found in datetime or interval",
      .ob_str_error          = "OBE-01878: specified field not found in datetime or interval",
      .ob_str_user_error     = "OBE-01878: specified field not found in datetime or interval"
};
static const _error _error_OB_ERR_ADD_PART_BOUN_NOT_INC = {
      .error_name            = "OB_ERR_ADD_PART_BOUN_NOT_INC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_RANGE_NOT_INCREASING_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "VALUES LESS THAN value must be strictly increasing for each partition",
      .str_user_error        = "VALUES LESS THAN value must be strictly increasing for each partition",
      .oracle_errno          = 14074,
      .oracle_str_error      = "ORA-14074: partition bound must collate higher than that of the last partition",
      .oracle_str_user_error = "ORA-14074: partition bound must collate higher than that of the last partition",
      .ob_str_error          = "OBE-14074: partition bound must collate higher than that of the last partition",
      .ob_str_user_error     = "OBE-14074: partition bound must collate higher than that of the last partition"
};
static const _error _error_OB_ERR_DATA_TOO_LONG_IN_PART_CHECK = {
      .error_name            = "OB_ERR_DATA_TOO_LONG_IN_PART_CHECK",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DATA_TOO_LONG,
      .sqlstate              = "22001",
      .str_error             = "Data too long for column",
      .str_user_error        = "Data too long for column",
      .oracle_errno          = 14036,
      .oracle_str_error      = "ORA-14036: partition bound value too large for column",
      .oracle_str_user_error = "ORA-14036: partition bound value too large for column",
      .ob_str_error          = "OBE-14036: partition bound value too large for column",
      .ob_str_user_error     = "OBE-14036: partition bound value too large for column"
};
static const _error _error_OB_ERR_WRONG_TYPE_COLUMN_VALUE_V2_ERROR = {
      .error_name            = "OB_ERR_WRONG_TYPE_COLUMN_VALUE_V2_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_TYPE_COLUMN_VALUE_ERROR,
      .sqlstate              = "HY000",
      .str_error             = "Partition column values of incorrect type",
      .str_user_error        = "Partition column values of incorrect type",
      .oracle_errno          = 14308,
      .oracle_str_error      = "ORA-14308: partition bound element must be one of: string, datetime or interval literal, number, or NULL",
      .oracle_str_user_error = "ORA-14308: partition bound element must be one of: string, datetime or interval literal, number, or NULL",
      .ob_str_error          = "OBE-14308: partition bound element must be one of: string, datetime or interval literal, number, or NULL",
      .ob_str_user_error     = "OBE-14308: partition bound element must be one of: string, datetime or interval literal, number, or NULL"
};
static const _error _error_OB_CANT_AGGREGATE_3COLLATIONS = {
      .error_name            = "OB_CANT_AGGREGATE_3COLLATIONS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_AGGREGATE_3COLLATIONS,
      .sqlstate              = "HY000",
      .str_error             = "Illegal mix of collations",
      .str_user_error        = "Illegal mix of collations (%s, %s),(%s, %s),(%s, %s)",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5356, Illegal mix of collations",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5356, Illegal mix of collations (%s, %s),(%s, %s),(%s, %s)",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5356, Illegal mix of collations",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5356, Illegal mix of collations (%s, %s),(%s, %s),(%s, %s)"
};
static const _error _error_OB_CANT_AGGREGATE_NCOLLATIONS = {
      .error_name            = "OB_CANT_AGGREGATE_NCOLLATIONS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CANT_AGGREGATE_NCOLLATIONS,
      .sqlstate              = "HY000",
      .str_error             = "Illegal mix of collations",
      .str_user_error        = "Illegal mix of collations",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5357, Illegal mix of collations",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5357, Illegal mix of collations",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5357, Illegal mix of collations",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5357, Illegal mix of collations"
};
static const _error _error_OB_ERR_DUPLICATED_UNIQUE_KEY = {
      .error_name            = "OB_ERR_DUPLICATED_UNIQUE_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DUP_ENTRY,
      .sqlstate              = "23000",
      .str_error             = "Duplicated primary key",
      .str_user_error        = "Duplicate entry \'%s\' for key \'%.*s\'",
      .oracle_errno          = 1452,
      .oracle_str_error      = "ORA-01452: cannot CREATE UNIQUE INDEX; duplicate keys found",
      .oracle_str_user_error = "ORA-01452: cannot CREATE UNIQUE INDEX; duplicate keys found",
      .ob_str_error          = "OBE-01452: cannot CREATE UNIQUE INDEX; duplicate keys found",
      .ob_str_user_error     = "OBE-01452: cannot CREATE UNIQUE INDEX; duplicate keys found"
};
static const _error _error_OB_DOUBLE_OVERFLOW = {
      .error_name            = "OB_DOUBLE_OVERFLOW",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DATA_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "result Double value is out of range",
      .str_user_error        = "result Double value is out of range",
      .oracle_errno          = 1426,
      .oracle_str_error      = "ORA-01426: Double value overflow",
      .oracle_str_user_error = "ORA-01426: Double value overflow",
      .ob_str_error          = "OBE-01426: Double value overflow",
      .ob_str_user_error     = "OBE-01426: Double value overflow"
};
static const _error _error_OB_ERR_NO_SYS_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_SYS_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "insufficient privileges",
      .str_user_error        = "insufficient privileges",
      .oracle_errno          = 1031,
      .oracle_str_error      = "ORA-01031: insufficient privileges",
      .oracle_str_user_error = "ORA-01031: insufficient privileges",
      .ob_str_error          = "OBE-01031: insufficient privileges",
      .ob_str_user_error     = "OBE-01031: insufficient privileges"
};
static const _error _error_OB_ERR_NO_LOGIN_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_LOGIN_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "user lacks CREATE SESSION privilege logon denied",
      .str_user_error        = "user %.*s lacks CREATE SESSION privilege; logon denied",
      .oracle_errno          = 1045,
      .oracle_str_error      = "ORA-01045: user lacks CREATE SESSION privilege; logon denied",
      .oracle_str_user_error = "ORA-01045: user %.*s lacks CREATE SESSION privilege; logon denied",
      .ob_str_error          = "OBE-01045: user lacks CREATE SESSION privilege; logon denied",
      .ob_str_user_error     = "OBE-01045: user %.*s lacks CREATE SESSION privilege; logon denied"
};
static const _error _error_OB_ERR_CANNOT_REVOKE_PRIVILEGES_YOU_DID_NOT_GRANT = {
      .error_name            = "OB_ERR_CANNOT_REVOKE_PRIVILEGES_YOU_DID_NOT_GRANT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = OB_ERR_NO_GRANT,
      .sqlstate              = "42000",
      .str_error             = "No such grant defined",
      .str_user_error        = "No such grant defined",
      .oracle_errno          = 1927,
      .oracle_str_error      = "ORA-01927: cannot REVOKE privileges you did not grant",
      .oracle_str_user_error = "ORA-01927: cannot REVOKE privileges you did not grant",
      .ob_str_error          = "OBE-01927: cannot REVOKE privileges you did not grant",
      .ob_str_user_error     = "OBE-01927: cannot REVOKE privileges you did not grant"
};
static const _error _error_OB_ERR_SYSTEM_PRIVILEGES_NOT_GRANTED_TO = {
      .error_name            = "OB_ERR_SYSTEM_PRIVILEGES_NOT_GRANTED_TO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "system privileges not granted to",
      .str_user_error        = "system privileges not granted to '%.*s'",
      .oracle_errno          = 1952,
      .oracle_str_error      = "ORA-01952: system privileges not granted to",
      .oracle_str_user_error = "ORA-01952: system privileges not granted to '%.*s'",
      .ob_str_error          = "OBE-01952: system privileges not granted to",
      .ob_str_user_error     = "OBE-01952: system privileges not granted to '%.*s'"
};
static const _error _error_OB_ERR_ONLY_SELECT_AND_ALTER_PRIVILEGES_ARE_VALID_FOR_SEQUENCES = {
      .error_name            = "OB_ERR_ONLY_SELECT_AND_ALTER_PRIVILEGES_ARE_VALID_FOR_SEQUENCES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "only SELECT and ALTER privileges are valid for sequences",
      .str_user_error        = "only SELECT and ALTER privileges are valid for sequences",
      .oracle_errno          = 2205,
      .oracle_str_error      = "ORA-02205: only SELECT and ALTER privileges are valid for sequences",
      .oracle_str_user_error = "ORA-02205: only SELECT and ALTER privileges are valid for sequences",
      .ob_str_error          = "OBE-02205: only SELECT and ALTER privileges are valid for sequences",
      .ob_str_user_error     = "OBE-02205: only SELECT and ALTER privileges are valid for sequences"
};
static const _error _error_OB_ERR_EXECUTE_PRIVILEGE_NOT_ALLOWED_FOR_TABLES = {
      .error_name            = "OB_ERR_EXECUTE_PRIVILEGE_NOT_ALLOWED_FOR_TABLES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "EXECUTE privilege not allowed for tables",
      .str_user_error        = "EXECUTE privilege not allowed for tables",
      .oracle_errno          = 2224,
      .oracle_str_error      = "ORA-02224: EXECUTE privilege not allowed for tables",
      .oracle_str_user_error = "ORA-02224: EXECUTE privilege not allowed for tables",
      .ob_str_error          = "OBE-02224: EXECUTE privilege not allowed for tables",
      .ob_str_user_error     = "OBE-02224: EXECUTE privilege not allowed for tables"
};
static const _error _error_OB_ERR_ONLY_EXECUTE_AND_DEBUG_PRIVILEGES_ARE_VALID_FOR_PROCEDURES = {
      .error_name            = "OB_ERR_ONLY_EXECUTE_AND_DEBUG_PRIVILEGES_ARE_VALID_FOR_PROCEDURES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "only EXECUTE and DEBUG privileges are valid for procedures",
      .str_user_error        = "only EXECUTE and DEBUG privileges are valid for procedures",
      .oracle_errno          = 2225,
      .oracle_str_error      = "ORA-02225: only EXECUTE and DEBUG privileges are valid for procedures",
      .oracle_str_user_error = "ORA-02225: only EXECUTE and DEBUG privileges are valid for procedures",
      .ob_str_error          = "OBE-02225: only EXECUTE and DEBUG privileges are valid for procedures",
      .ob_str_user_error     = "OBE-02225: only EXECUTE and DEBUG privileges are valid for procedures"
};
static const _error _error_OB_ERR_ONLY_EXECUTE_DEBUG_AND_UNDER_PRIVILEGES_ARE_VALID_FOR_TYPES = {
      .error_name            = "OB_ERR_ONLY_EXECUTE_DEBUG_AND_UNDER_PRIVILEGES_ARE_VALID_FOR_TYPES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "only EXECUTE, DEBUG, and UNDER privileges are valid for types",
      .str_user_error        = "only EXECUTE, DEBUG, and UNDER privileges are valid for types",
      .oracle_errno          = 2305,
      .oracle_str_error      = "ORA-02305: only EXECUTE, DEBUG, and UNDER privileges are valid for types",
      .oracle_str_user_error = "ORA-02305: only EXECUTE, DEBUG, and UNDER privileges are valid for types",
      .ob_str_error          = "OBE-02305: only EXECUTE, DEBUG, and UNDER privileges are valid for types",
      .ob_str_user_error     = "OBE-02305: only EXECUTE, DEBUG, and UNDER privileges are valid for types"
};
static const _error _error_OB_ERR_ADMIN_OPTION_NOT_GRANTED_FOR_ROLE = {
      .error_name            = "OB_ERR_ADMIN_OPTION_NOT_GRANTED_FOR_ROLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ADMIN option not granted for role",
      .str_user_error        = "ADMIN option not granted for role '%.*s'",
      .oracle_errno          = 1932,
      .oracle_str_error      = "ORA-01932: ADMIN option not granted for role",
      .oracle_str_user_error = "ORA-01932: ADMIN option not granted for role '%.*s'",
      .ob_str_error          = "OBE-01932: ADMIN option not granted for role",
      .ob_str_user_error     = "OBE-01932: ADMIN option not granted for role '%.*s'"
};
static const _error _error_OB_ERR_USER_OR_ROLE_DOES_NOT_EXIST = {
      .error_name            = "OB_ERR_USER_OR_ROLE_DOES_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "user or role does not exist",
      .str_user_error        = "user or role '%.*s' does not exist",
      .oracle_errno          = 1917,
      .oracle_str_error      = "ORA-01917: user or role does not exist",
      .oracle_str_user_error = "ORA-01917: user or role '%.*s' does not exist",
      .ob_str_error          = "OBE-01917: user or role does not exist",
      .ob_str_user_error     = "OBE-01917: user or role '%.*s' does not exist"
};
static const _error _error_OB_ERR_MISSING_ON_KEYWORD = {
      .error_name            = "OB_ERR_MISSING_ON_KEYWORD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "missing ON keyword",
      .str_user_error        = "missing ON keyword",
      .oracle_errno          = 969,
      .oracle_str_error      = "ORA-00969: missing ON keyword",
      .oracle_str_user_error = "ORA-00969: missing ON keyword",
      .ob_str_error          = "OBE-00969: missing ON keyword",
      .ob_str_user_error     = "OBE-00969: missing ON keyword"
};
static const _error _error_OB_ERR_NO_GRANT_OPTION = {
      .error_name            = "OB_ERR_NO_GRANT_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "grant option does not exists",
      .str_user_error        = "grant option does not exist for '%.*s.%.*s'",
      .oracle_errno          = 1720,
      .oracle_str_error      = "ORA-01720: grant option does not exist",
      .oracle_str_user_error = "ORA-01720: grant option does not exist for '%.*s.%.*s'",
      .ob_str_error          = "OBE-01720: grant option does not exist",
      .ob_str_user_error     = "OBE-01720: grant option does not exist for '%.*s.%.*s'"
};
static const _error _error_OB_ERR_ALTER_INDEX_AND_EXECUTE_NOT_ALLOWED_FOR_VIEWS = {
      .error_name            = "OB_ERR_ALTER_INDEX_AND_EXECUTE_NOT_ALLOWED_FOR_VIEWS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ALTER, INDEX and EXECUTE not allowed for views",
      .str_user_error        = "ALTER, INDEX and EXECUTE not allowed for views",
      .oracle_errno          = 2204,
      .oracle_str_error      = "ORA-02204: ALTER, INDEX and EXECUTE not allowed for views",
      .oracle_str_user_error = "ORA-02204: ALTER, INDEX and EXECUTE not allowed for views",
      .ob_str_error          = "OBE-02204: ALTER, INDEX and EXECUTE not allowed for views",
      .ob_str_user_error     = "OBE-02204: ALTER, INDEX and EXECUTE not allowed for views"
};
static const _error _error_OB_ERR_CIRCULAR_ROLE_GRANT_DETECTED = {
      .error_name            = "OB_ERR_CIRCULAR_ROLE_GRANT_DETECTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ROLE_GRANTED_TO_ITSELF,
      .sqlstate              = "HY000",
      .str_error             = "The GRANT would create a loop",
      .str_user_error        = "User account `%.*s`@`%.*s` is directly or indirectly granted to the role `%.*s`@`%.*s`. The GRANT would create a loop",
      .oracle_errno          = 1934,
      .oracle_str_error      = "ORA-01934: circular role grant detected",
      .oracle_str_user_error = "ORA-01934: User account `%.*s`@`%.*s` is directly or indirectly granted to the role `%.*s`@`%.*s`. The GRANT would create a loop",
      .ob_str_error          = "OBE-01934: circular role grant detected",
      .ob_str_user_error     = "OBE-01934: User account `%.*s`@`%.*s` is directly or indirectly granted to the role `%.*s`@`%.*s`. The GRANT would create a loop"
};
static const _error _error_OB_ERR_INVALID_PRIVILEGE_ON_DIRECTORIES = {
      .error_name            = "OB_ERR_INVALID_PRIVILEGE_ON_DIRECTORIES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid privilege on directories",
      .str_user_error        = "invalid privilege on directories",
      .oracle_errno          = 22928,
      .oracle_str_error      = "ORA-22928: invalid privilege on directories",
      .oracle_str_user_error = "ORA-22928: invalid privilege on directories",
      .ob_str_error          = "OBE-22928: invalid privilege on directories",
      .ob_str_user_error     = "OBE-22928: invalid privilege on directories"
};
static const _error _error_OB_ERR_DIRECTORY_ACCESS_DENIED = {
      .error_name            = "OB_ERR_DIRECTORY_ACCESS_DENIED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "directory access denied",
      .str_user_error        = "directory access denied",
      .oracle_errno          = 29289,
      .oracle_str_error      = "ORA-29289: directory access denied",
      .oracle_str_user_error = "ORA-29289: directory access denied",
      .ob_str_error          = "OBE-29289: directory access denied",
      .ob_str_user_error     = "OBE-29289: directory access denied"
};
static const _error _error_OB_ERR_MISSING_OR_INVALID_ROLE_NAME = {
      .error_name            = "OB_ERR_MISSING_OR_INVALID_ROLE_NAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "missing or invalid role name",
      .str_user_error        = "missing or invalid role name",
      .oracle_errno          = 1937,
      .oracle_str_error      = "ORA-01937: missing or invalid role name",
      .oracle_str_user_error = "ORA-01937: missing or invalid role name",
      .ob_str_error          = "OBE-01937: missing or invalid role name",
      .ob_str_user_error     = "OBE-01937: missing or invalid role name"
};
static const _error _error_OB_ERR_ROLE_NOT_GRANTED_OR_DOES_NOT_EXIST = {
      .error_name            = "OB_ERR_ROLE_NOT_GRANTED_OR_DOES_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ROLE_NOT_GRANTED,
      .sqlstate              = "HY000",
      .str_error             = "role not granted or does not exist",
      .str_user_error        = "role '%.*s' not granted or does not exist",
      .oracle_errno          = 1924,
      .oracle_str_error      = "ORA-01924: role not granted or does not exist",
      .oracle_str_user_error = "ORA-01924: role '%.*s' not granted or does not exist",
      .ob_str_error          = "OBE-01924: role not granted or does not exist",
      .ob_str_user_error     = "OBE-01924: role '%.*s' not granted or does not exist"
};
static const _error _error_OB_ERR_DEFAULT_ROLE_NOT_GRANTED_TO_USER = {
      .error_name            = "OB_ERR_DEFAULT_ROLE_NOT_GRANTED_TO_USER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "DEFAULT ROLE not granted to user",
      .str_user_error        = "DEFAULT ROLE '%.*s' not granted to user",
      .oracle_errno          = 1955,
      .oracle_str_error      = "ORA-01955: DEFAULT ROLE not granted to user",
      .oracle_str_user_error = "ORA-01955: DEFAULT ROLE '%.*s' not granted to user",
      .ob_str_error          = "OBE-01955: DEFAULT ROLE not granted to user",
      .ob_str_user_error     = "OBE-01955: DEFAULT ROLE '%.*s' not granted to user"
};
static const _error _error_OB_ERR_ROLE_NOT_GRANTED_TO = {
      .error_name            = "OB_ERR_ROLE_NOT_GRANTED_TO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ROLE_NOT_GRANTED,
      .sqlstate              = "HY000",
      .str_error             = "ROLE not granted to",
      .str_user_error        = "`%.*s`@`%.*s` is not granted to `%.*s`@`%.*s`",
      .oracle_errno          = 1951,
      .oracle_str_error      = "ORA-01951: ROLE not granted to",
      .oracle_str_user_error = "ORA-01951: ROLE '%.*s%.*s' not granted to '%.*s%.*s'",
      .ob_str_error          = "OBE-01951: ROLE not granted to",
      .ob_str_user_error     = "OBE-01951: ROLE '%.*s%.*s' not granted to '%.*s%.*s'"
};
static const _error _error_OB_ERR_CANNOT_GRANT_TO_A_ROLE_WITH_GRANT_OPTION = {
      .error_name            = "OB_ERR_CANNOT_GRANT_TO_A_ROLE_WITH_GRANT_OPTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cannot GRANT to a role WITH GRANT OPTION",
      .str_user_error        = "cannot GRANT to a role WITH GRANT OPTION",
      .oracle_errno          = 1926,
      .oracle_str_error      = "ORA-01926: cannot GRANT to a role WITH GRANT OPTION",
      .oracle_str_user_error = "ORA-01926: cannot GRANT to a role WITH GRANT OPTION",
      .ob_str_error          = "OBE-01926: cannot GRANT to a role WITH GRANT OPTION",
      .ob_str_user_error     = "OBE-01926: cannot GRANT to a role WITH GRANT OPTION"
};
static const _error _error_OB_ERR_DUPLICATE_USERNAME_IN_LIST = {
      .error_name            = "OB_ERR_DUPLICATE_USERNAME_IN_LIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "duplicate username in list",
      .str_user_error        = "duplicate username in list",
      .oracle_errno          = 1700,
      .oracle_str_error      = "ORA-01700: duplicate username in list",
      .oracle_str_user_error = "ORA-01700: duplicate username in list",
      .ob_str_error          = "OBE-01700: duplicate username in list",
      .ob_str_user_error     = "OBE-01700: duplicate username in list"
};
static const _error _error_OB_ERR_CANNOT_GRANT_STRING_TO_A_ROLE = {
      .error_name            = "OB_ERR_CANNOT_GRANT_STRING_TO_A_ROLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cannot grant string to a role",
      .str_user_error        = "cannot grant %.*s to a role",
      .oracle_errno          = 1931,
      .oracle_str_error      = "ORA-01931: cannot grant string to a role",
      .oracle_str_user_error = "ORA-01931: cannot grant %.*s to a role",
      .ob_str_error          = "OBE-01931: cannot grant string to a role",
      .ob_str_user_error     = "OBE-01931: cannot grant %.*s to a role"
};
static const _error _error_OB_ERR_CASCADE_CONSTRAINTS_MUST_BE_SPECIFIED_TO_PERFORM_THIS_REVOKE = {
      .error_name            = "OB_ERR_CASCADE_CONSTRAINTS_MUST_BE_SPECIFIED_TO_PERFORM_THIS_REVOKE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "CASCADE CONSTRAINTS must be specified to perform this revoke",
      .str_user_error        = "CASCADE CONSTRAINTS must be specified to perform this revoke",
      .oracle_errno          = 1981,
      .oracle_str_error      = "ORA-01981: CASCADE CONSTRAINTS must be specified to perform this revoke",
      .oracle_str_user_error = "ORA-01981: CASCADE CONSTRAINTS must be specified to perform this revoke",
      .ob_str_error          = "OBE-01981: CASCADE CONSTRAINTS must be specified to perform this revoke",
      .ob_str_user_error     = "OBE-01981: CASCADE CONSTRAINTS must be specified to perform this revoke"
};
static const _error _error_OB_ERR_YOU_MAY_NOT_REVOKE_PRIVILEGES_FROM_YOURSELF = {
      .error_name            = "OB_ERR_YOU_MAY_NOT_REVOKE_PRIVILEGES_FROM_YOURSELF",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "you may not GRANT/REVOKE privileges to/from yourself",
      .str_user_error        = "you may not GRANT/REVOKE privileges to/from yourself",
      .oracle_errno          = 1749,
      .oracle_str_error      = "ORA-01749: you may not GRANT/REVOKE privileges to/from yourself",
      .oracle_str_user_error = "ORA-01749: you may not GRANT/REVOKE privileges to/from yourself",
      .ob_str_error          = "OBE-01749: you may not GRANT/REVOKE privileges to/from yourself",
      .ob_str_user_error     = "OBE-01749: you may not GRANT/REVOKE privileges to/from yourself"
};
static const _error _error_OB_ERR_MISS_ERR_LOG_MANDATORY_COLUMN = {
      .error_name            = "OB_ERR_MISS_ERR_LOG_MANDATORY_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "miss mandatory column of error log table",
      .str_user_error        = "miss mandatory column %.*s of error log table",
      .oracle_errno          = 38900,
      .oracle_str_error      = "ORA-38900: miss mandatory column of error log table",
      .oracle_str_user_error = "ORA-38900: miss mandatory column %.*s of error log table",
      .ob_str_error          = "OBE-38900: miss mandatory column of error log table",
      .ob_str_user_error     = "OBE-38900: miss mandatory column %.*s of error log table"
};
static const _error _error_OB_TABLE_DEFINITION_CHANGED = {
      .error_name            = "OB_TABLE_DEFINITION_CHANGED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TABLE_DEF_CHANGED,
      .sqlstate              = "HY000",
      .str_error             = "Unable to read data -- Table definition has changed",
      .str_user_error        = "Unable to read data -- Table definition has changed",
      .oracle_errno          = 1466,
      .oracle_str_error      = "ORA-01466: Unable to read data -- Table definition has changed",
      .oracle_str_user_error = "ORA-01466: Unable to read data -- Table definition has changed",
      .ob_str_error          = "OBE-01466: Unable to read data -- Table definition has changed",
      .ob_str_user_error     = "OBE-01466: Unable to read data -- Table definition has changed"
};
static const _error _error_OB_ERR_NO_ROUTINE_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_ROUTINE_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_PROCACCESS_DENIED_ERROR,
      .sqlstate              = "42000",
      .str_error             = "Command denied to user for routine",
      .str_user_error        = "%.*s command denied to user '%.*s'@'%.*s' for routine '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5387, Command denied to user for routine",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5387, %.*s command denied to user '%.*s'@'%.*s' for routine '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5387, Command denied to user for routine",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5387, %.*s command denied to user '%.*s'@'%.*s' for routine '%.*s'"
};
static const _error _error_OB_ERR_USER_REFFERD_AS_DEFINER = {
      .error_name            = "OB_ERR_USER_REFFERD_AS_DEFINER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_USER_REFERRED_AS_DEFINER,
      .sqlstate              = "HY000",
      .str_error             = "User '%.*s'@'%.*s' is referenced as a definer account in a stored routine.",
      .str_user_error        = "User '%.*s'@'%.*s' is referenced as a definer account in a stored routine.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5388, User '%.*s'@'%.*s' is referenced as a definer account in a stored routine.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5388, User '%.*s'@'%.*s' is referenced as a definer account in a stored routine.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5388, User '%.*s'@'%.*s' is referenced as a definer account in a stored routine.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5388, User '%.*s'@'%.*s' is referenced as a definer account in a stored routine."
};
static const _error _error_OB_ERR_OPERATION_ON_USER_REFERRED_AS_DEFINER = {
      .error_name            = "OB_ERR_OPERATION_ON_USER_REFERRED_AS_DEFINER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_OPERATION_ON_USER_REFERRED_AS_DEFINER,
      .sqlstate              = "HY000",
      .str_error             = "Operation %.*s failed for '%.*s'@'%.*s' as it is referenced as a definer account in a stored routine.",
      .str_user_error        = "Operation %.*s failed for '%.*s'@'%.*s' as it is referenced as a definer account in a stored routine.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5389, Operation %.*s failed for '%.*s'@'%.*s' as it is referenced as a definer account in a stored routine.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5389, Operation %.*s failed for '%.*s'@'%.*s' as it is referenced as a definer account in a stored routine.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5389, Operation %.*s failed for '%.*s'@'%.*s' as it is referenced as a definer account in a stored routine.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5389, Operation %.*s failed for '%.*s'@'%.*s' as it is referenced as a definer account in a stored routine."
};
static const _error _error_OB_ERR_NO_COLUMN_PRIVILEGE = {
      .error_name            = "OB_ERR_NO_COLUMN_PRIVILEGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_COLUMNACCESS_DENIED_ERROR,
      .sqlstate              = "42000",
      .str_error             = "%.*s command denied to user '%.*s'@'%.*s' for column '%.*s' in table '%.*s'",
      .str_user_error        = "%.*s command denied to user '%.*s'@'%.*s' for column '%.*s' in table '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5390, %.*s command denied to user '%.*s'@'%.*s' for column '%.*s' in table '%.*s'",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5390, %.*s command denied to user '%.*s'@'%.*s' for column '%.*s' in table '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5390, %.*s command denied to user '%.*s'@'%.*s' for column '%.*s' in table '%.*s'",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5390, %.*s command denied to user '%.*s'@'%.*s' for column '%.*s' in table '%.*s'"
};
static const _error _error_OB_ERR_OBJECT_STRING_DOES_NOT_EXIST = {
      .error_name            = "OB_ERR_OBJECT_STRING_DOES_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "object string does not exist",
      .str_user_error        = "object %.*s does not exist",
      .oracle_errno          = 4043,
      .oracle_str_error      = "ORA-04043: object string does not exist",
      .oracle_str_user_error = "ORA-04043: object %.*s does not exist",
      .ob_str_error          = "OBE-04043: object string does not exist",
      .ob_str_user_error     = "OBE-04043: object %.*s does not exist"
};
static const _error _error_OB_ERR_RESULTANT_DATA_TYPE_OF_VIRTUAL_COLUMN_IS_NOT_SUPPORTED = {
      .error_name            = "OB_ERR_RESULTANT_DATA_TYPE_OF_VIRTUAL_COLUMN_IS_NOT_SUPPORTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "resultant data type of virtual column is not supported",
      .str_user_error        = "resultant data type of virtual column is not supported",
      .oracle_errno          = 54004,
      .oracle_str_error      = "ORA-54004: resultant data type of virtual column is not supported",
      .oracle_str_user_error = "ORA-54004: resultant data type of virtual column is not supported",
      .ob_str_error          = "OBE-54004: resultant data type of virtual column is not supported",
      .ob_str_user_error     = "OBE-54004: resultant data type of virtual column is not supported"
};
static const _error _error_OB_ERR_GET_STACKED_DIAGNOSTICS = {
      .error_name            = "OB_ERR_GET_STACKED_DIAGNOSTICS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_GET_STACKED_DIAGNOSTICS_INACTIVE,
      .sqlstate              = "0Z002",
      .str_error             = "GET STACKED DIAGNOSTICS when handler not active",
      .str_user_error        = "GET STACKED DIAGNOSTICS when handler not active",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5402, GET STACKED DIAGNOSTICS when handler not active",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5402, GET STACKED DIAGNOSTICS when handler not active",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5402, GET STACKED DIAGNOSTICS when handler not active",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5402, GET STACKED DIAGNOSTICS when handler not active"
};
static const _error _error_OB_DDL_SCHEMA_VERSION_NOT_MATCH = {
      .error_name            = "OB_DDL_SCHEMA_VERSION_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "ddl schema version not match",
      .str_user_error        = "ddl schema version not match",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5403, ddl schema version not match",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5403, ddl schema version not match",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5403, ddl schema version not match",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5403, ddl schema version not match"
};
static const _error _error_OB_ERR_COLUMN_GROUP_DUPLICATE = {
      .error_name            = "OB_ERR_COLUMN_GROUP_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DUP_FIELDNAME,
      .sqlstate              = "42S21",
      .str_error             = "Duplicate column group name",
      .str_user_error        = "Duplicate column group name '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5404, Duplicate column group name",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5404, Duplicate column group name '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5404, Duplicate column group name",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5404, Duplicate column group name '%.*s'"
};
static const _error _error_OB_ERR_RESERVED_SYNTAX = {
      .error_name            = "OB_ERR_RESERVED_SYNTAX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_RESERVED_SYNTAX,
      .sqlstate              = "HY000",
      .str_error             = "The \'%.*s\' syntax is reserved for purposes internal to the OceanBase Server",
      .str_user_error        = "The \'%.*s\' syntax is reserved for purposes internal to the OceanBase Server",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5405, The \'%.*s\' syntax is reserved for purposes internal to the OceanBase Server",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5405, The \'%.*s\' syntax is reserved for purposes internal to the OceanBase Server",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5405, The \'%.*s\' syntax is reserved for purposes internal to the OceanBase Server",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5405, The \'%.*s\' syntax is reserved for purposes internal to the OceanBase Server"
};
static const _error _error_OB_ERR_INVALID_PARAM_TO_PROCEDURE = {
      .error_name            = "OB_ERR_INVALID_PARAM_TO_PROCEDURE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_PARAMETERS_TO_PROCEDURE,
      .sqlstate              = "HY000",
      .str_error             = "Incorrect parameters to procedure \'%.*s\'",
      .str_user_error        = "Incorrect parameters to procedure \'%.*s\'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5406, Incorrect parameters to procedure \'%.*s\'",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5406, Incorrect parameters to procedure \'%.*s\'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5406, Incorrect parameters to procedure \'%.*s\'",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5406, Incorrect parameters to procedure \'%.*s\'"
};
static const _error _error_OB_ERR_WRONG_PARAMETERS_TO_NATIVE_FCT = {
      .error_name            = "OB_ERR_WRONG_PARAMETERS_TO_NATIVE_FCT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_PARAMETERS_TO_NATIVE_FCT,
      .sqlstate              = "42000",
      .str_error             = "Incorrect parameters in the call to native function",
      .str_user_error        = "Incorrect parameters in the call to native function '%.*s'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5407, Incorrect parameters in the call to native function",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5407, Incorrect parameters in the call to native function '%.*s'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5407, Incorrect parameters in the call to native function",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5407, Incorrect parameters in the call to native function '%.*s'"
};
static const _error _error_OB_ERR_CTE_MAX_RECURSION_DEPTH = {
      .error_name            = "OB_ERR_CTE_MAX_RECURSION_DEPTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CTE_MAX_RECURSION_DEPTH,
      .sqlstate              = "HY000",
      .str_error             = "Recursive query aborted after multiple iterations. Try increasing @@cte_max_recursion_depth to a larger value.",
      .str_user_error        = "Recursive query aborted after %lu iterations. Try increasing @@cte_max_recursion_depth to a larger value.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5408, Recursive query aborted after multiple iterations. Try increasing @@cte_max_recursion_depth to a larger value.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5408, Recursive query aborted after %lu iterations. Try increasing @@cte_max_recursion_depth to a larger value.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5408, Recursive query aborted after multiple iterations. Try increasing @@cte_max_recursion_depth to a larger value.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5408, Recursive query aborted after %lu iterations. Try increasing @@cte_max_recursion_depth to a larger value."
};
static const _error _error_OB_DUPLICATE_OBJECT_NAME_EXIST = {
      .error_name            = "OB_DUPLICATE_OBJECT_NAME_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Duplicate object name exists, schema refreshing may be hung",
      .str_user_error        = "Duplicate object name exists, schema refreshing may be hung",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5409, Duplicate object name exists, schema refreshing may be hung",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5409, Duplicate object name exists, schema refreshing may be hung",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5409, Duplicate object name exists, schema refreshing may be hung",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5409, Duplicate object name exists, schema refreshing may be hung"
};
static const _error _error_OB_ERR_REFRESH_SCHEMA_TOO_LONG = {
      .error_name            = "OB_ERR_REFRESH_SCHEMA_TOO_LONG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Refresh schema failed continuously, ddl may be hung",
      .str_user_error        = "Refresh schema failed continuously, ddl may be hung",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5410, Refresh schema failed continuously, ddl may be hung",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5410, Refresh schema failed continuously, ddl may be hung",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5410, Refresh schema failed continuously, ddl may be hung",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5410, Refresh schema failed continuously, ddl may be hung"
};
static const _error _error_OB_ERR_INVALID_JSON_TEXT = {
      .error_name            = "OB_ERR_INVALID_JSON_TEXT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_TEXT,
      .sqlstate              = "22032",
      .str_error             = "Invalid JSON text.",
      .str_user_error        = "Invalid JSON text.",
      .oracle_errno          = 40441,
      .oracle_str_error      = "ORA-40441: JSON syntax error.",
      .oracle_str_user_error = "ORA-40441: JSON syntax error.",
      .ob_str_error          = "OBE-40441: JSON syntax error.",
      .ob_str_user_error     = "OBE-40441: JSON syntax error."
};
static const _error _error_OB_ERR_INVALID_JSON_TEXT_IN_PARAM = {
      .error_name            = "OB_ERR_INVALID_JSON_TEXT_IN_PARAM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_TEXT_IN_PARAM,
      .sqlstate              = "22032",
      .str_error             = "Invalid JSON text in argument.",
      .str_user_error        = "Invalid JSON text in argument.",
      .oracle_errno          = 40441,
      .oracle_str_error      = "ORA-40441: JSON syntax error",
      .oracle_str_user_error = "ORA-40441: JSON syntax error",
      .ob_str_error          = "OBE-40441: JSON syntax error",
      .ob_str_user_error     = "OBE-40441: JSON syntax error"
};
static const _error _error_OB_ERR_INVALID_JSON_BINARY_DATA = {
      .error_name            = "OB_ERR_INVALID_JSON_BINARY_DATA",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_BINARY_DATA,
      .sqlstate              = "42000",
      .str_error             = "The JSON binary value contains invalid data.",
      .str_user_error        = "The JSON binary value contains invalid data.",
      .oracle_errno          = 40783,
      .oracle_str_error      = "ORA-40783: invalid binary JSON data\nstring",
      .oracle_str_user_error = "ORA-40783: invalid binary JSON data\nstring",
      .ob_str_error          = "OBE-40783: invalid binary JSON data\nstring",
      .ob_str_user_error     = "OBE-40783: invalid binary JSON data\nstring"
};
static const _error _error_OB_ERR_INVALID_JSON_PATH = {
      .error_name            = "OB_ERR_INVALID_JSON_PATH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_PATH,
      .sqlstate              = "42000",
      .str_error             = "Invalid JSON path expression.",
      .str_user_error        = "Invalid JSON path expression.",
      .oracle_errno          = 40442,
      .oracle_str_error      = "ORA-40442: JSON path expression syntax error ('INT')",
      .oracle_str_user_error = "ORA-40442: JSON path expression syntax error ('INT')",
      .ob_str_error          = "OBE-40442: JSON path expression syntax error ('INT')",
      .ob_str_user_error     = "OBE-40442: JSON path expression syntax error ('INT')"
};
static const _error _error_OB_ERR_INVALID_JSON_CHARSET = {
      .error_name            = "OB_ERR_INVALID_JSON_CHARSET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_CHARSET,
      .sqlstate              = "22032",
      .str_error             = "Cannot create a JSON value from a string.",
      .str_user_error        = "Cannot create a JSON value from a string.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: Cannot create a JSON value from a string.",
      .oracle_str_user_error = "ORA-00600: Cannot create a JSON value from a string.",
      .ob_str_error          = "OBE-00600: Cannot create a JSON value from a string.",
      .ob_str_user_error     = "OBE-00600: Cannot create a JSON value from a string."
};
static const _error _error_OB_ERR_INVALID_JSON_CHARSET_IN_FUNCTION = {
      .error_name            = "OB_ERR_INVALID_JSON_CHARSET_IN_FUNCTION",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_CHARSET_IN_FUNCTION,
      .sqlstate              = "22032",
      .str_error             = "Invalid JSON character data provided to function.",
      .str_user_error        = "Invalid JSON character data provided to function.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: Invalid JSON character data provided to function.",
      .oracle_str_user_error = "ORA-00600: Invalid JSON character data provided to function.",
      .ob_str_error          = "OBE-00600: Invalid JSON character data provided to function.",
      .ob_str_user_error     = "OBE-00600: Invalid JSON character data provided to function."
};
static const _error _error_OB_ERR_INVALID_TYPE_FOR_JSON = {
      .error_name            = "OB_ERR_INVALID_TYPE_FOR_JSON",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_TYPE_FOR_JSON,
      .sqlstate              = "22032",
      .str_error             = "Invalid data type for JSON data in argument %u to function %s; a JSON string or JSON type is required.",
      .str_user_error        = "Invalid data type for JSON data in argument %u to function %s; a JSON string or JSON type is required.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: Invalid data type for JSON data in argument %u to function %s; a JSON string or JSON type is required.",
      .oracle_str_user_error = "ORA-00600: Invalid data type for JSON data in argument %u to function %s; a JSON string or JSON type is required.",
      .ob_str_error          = "OBE-00600: Invalid data type for JSON data in argument %u to function %s; a JSON string or JSON type is required.",
      .ob_str_user_error     = "OBE-00600: Invalid data type for JSON data in argument %u to function %s; a JSON string or JSON type is required."
};
static const _error _error_OB_ERR_INVALID_CAST_TO_JSON = {
      .error_name            = "OB_ERR_INVALID_CAST_TO_JSON",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_CAST_TO_JSON,
      .sqlstate              = "22032",
      .str_error             = "Cannot CAST value to JSON.",
      .str_user_error        = "Cannot CAST value to JSON.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: Cannot CAST value to JSON.",
      .oracle_str_user_error = "ORA-00600: Cannot CAST value to JSON.",
      .ob_str_error          = "OBE-00600: Cannot CAST value to JSON.",
      .ob_str_user_error     = "OBE-00600: Cannot CAST value to JSON."
};
static const _error _error_OB_ERR_INVALID_JSON_PATH_CHARSET = {
      .error_name            = "OB_ERR_INVALID_JSON_PATH_CHARSET",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_PATH_CHARSET,
      .sqlstate              = "42000",
      .str_error             = "A path expression must be encoded in the utf8 character set.",
      .str_user_error        = "A path expression must be encoded in the utf8 character set.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: A path expression must be encoded in the utf8 character set.",
      .oracle_str_user_error = "ORA-00600: A path expression must be encoded in the utf8 character set.",
      .ob_str_error          = "OBE-00600: A path expression must be encoded in the utf8 character set.",
      .ob_str_user_error     = "OBE-00600: A path expression must be encoded in the utf8 character set."
};
static const _error _error_OB_ERR_INVALID_JSON_PATH_WILDCARD = {
      .error_name            = "OB_ERR_INVALID_JSON_PATH_WILDCARD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_PATH_WILDCARD,
      .sqlstate              = "42000",
      .str_error             = "In this situation, path expressions may not contain the * and ** tokens.",
      .str_user_error        = "In this situation, path expressions may not contain the * and ** tokens.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: In this situation, path expressions may not contain the * and ** tokens.",
      .oracle_str_user_error = "ORA-00600: In this situation, path expressions may not contain the * and ** tokens.",
      .ob_str_error          = "OBE-00600: In this situation, path expressions may not contain the * and ** tokens.",
      .ob_str_user_error     = "OBE-00600: In this situation, path expressions may not contain the * and ** tokens."
};
static const _error _error_OB_ERR_JSON_VALUE_TOO_BIG = {
      .error_name            = "OB_ERR_JSON_VALUE_TOO_BIG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_JSON_VALUE_TOO_BIG,
      .sqlstate              = "22032",
      .str_error             = "The JSON value is too big to be stored in a JSON column.",
      .str_user_error        = "The JSON value is too big to be stored in a JSON column.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: The JSON value is too big to be stored in a JSON column.",
      .oracle_str_user_error = "ORA-00600: The JSON value is too big to be stored in a JSON column.",
      .ob_str_error          = "OBE-00600: The JSON value is too big to be stored in a JSON column.",
      .ob_str_user_error     = "OBE-00600: The JSON value is too big to be stored in a JSON column."
};
static const _error _error_OB_ERR_JSON_KEY_TOO_BIG = {
      .error_name            = "OB_ERR_JSON_KEY_TOO_BIG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_JSON_KEY_TOO_BIG,
      .sqlstate              = "22032",
      .str_error             = "The JSON object contains a key name that is too long.",
      .str_user_error        = "The JSON object contains a key name that is too long.",
      .oracle_errno          = 40476,
      .oracle_str_error      = "ORA-40476: JSON key too long.",
      .oracle_str_user_error = "ORA-40476: JSON key too long.",
      .ob_str_error          = "OBE-40476: JSON key too long.",
      .ob_str_user_error     = "OBE-40476: JSON key too long."
};
static const _error _error_OB_ERR_JSON_USED_AS_KEY = {
      .error_name            = "OB_ERR_JSON_USED_AS_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_JSON_USED_AS_KEY,
      .sqlstate              = "42000",
      .str_error             = "JSON column cannot be used in key specification.",
      .str_user_error        = "JSON column '%.*s' cannot be used in key specification.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: JSON column cannot be used in key specification.",
      .oracle_str_user_error = "ORA-00600: JSON column '%.*s' cannot be used in key specification.",
      .ob_str_error          = "OBE-00600: JSON column cannot be used in key specification.",
      .ob_str_user_error     = "OBE-00600: JSON column '%.*s' cannot be used in key specification."
};
static const _error _error_OB_ERR_JSON_VACUOUS_PATH = {
      .error_name            = "OB_ERR_JSON_VACUOUS_PATH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_JSON_VACUOUS_PATH,
      .sqlstate              = "42000",
      .str_error             = "The path expression is not allowed in this context.",
      .str_user_error        = "The path expression is not allowed in this context.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: The path expression is not allowed in this context.",
      .oracle_str_user_error = "ORA-00600: The path expression is not allowed in this context.",
      .ob_str_error          = "OBE-00600: The path expression is not allowed in this context.",
      .ob_str_user_error     = "OBE-00600: The path expression is not allowed in this context."
};
static const _error _error_OB_ERR_JSON_BAD_ONE_OR_ALL_ARG = {
      .error_name            = "OB_ERR_JSON_BAD_ONE_OR_ALL_ARG",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_JSON_BAD_ONE_OR_ALL_ARG,
      .sqlstate              = "42000",
      .str_error             = "The oneOrAll argument may take these values: \'one\' or \'all\'.",
      .str_user_error        = "The oneOrAll argument may take these values: \'one\' or \'all\'.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: The oneOrAll argument may take these values: \'one\' or \'all\'.",
      .oracle_str_user_error = "ORA-00600: The oneOrAll argument may take these values: \'one\' or \'all\'.",
      .ob_str_error          = "OBE-00600: The oneOrAll argument may take these values: \'one\' or \'all\'.",
      .ob_str_user_error     = "OBE-00600: The oneOrAll argument may take these values: \'one\' or \'all\'."
};
static const _error _error_OB_ERR_NUMERIC_JSON_VALUE_OUT_OF_RANGE = {
      .error_name            = "OB_ERR_NUMERIC_JSON_VALUE_OUT_OF_RANGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NUMERIC_JSON_VALUE_OUT_OF_RANGE,
      .sqlstate              = "22003",
      .str_error             = "Out of range JSON value for CAST",
      .str_user_error        = "Out of range JSON value for CAST",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: Out of range JSON value for CAST",
      .oracle_str_user_error = "ORA-00600: Out of range JSON value for CAST",
      .ob_str_error          = "OBE-00600: Out of range JSON value for CAST",
      .ob_str_user_error     = "OBE-00600: Out of range JSON value for CAST"
};
static const _error _error_OB_ERR_INVALID_JSON_VALUE_FOR_CAST = {
      .error_name            = "OB_ERR_INVALID_JSON_VALUE_FOR_CAST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_VALUE_FOR_CAST,
      .sqlstate              = "22018",
      .str_error             = "Invalid JSON value for CAST",
      .str_user_error        = "Invalid JSON value for CAST",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: Invalid JSON value for CAST",
      .oracle_str_user_error = "ORA-00600: Invalid JSON value for CAST",
      .ob_str_error          = "OBE-00600: Invalid JSON value for CAST",
      .ob_str_user_error     = "OBE-00600: Invalid JSON value for CAST"
};
static const _error _error_OB_ERR_JSON_OUT_OF_DEPTH = {
      .error_name            = "OB_ERR_JSON_OUT_OF_DEPTH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_JSON_DOCUMENT_TOO_DEEP,
      .sqlstate              = "22032",
      .str_error             = "The JSON document exceeds the maximum depth.",
      .str_user_error        = "The JSON document exceeds the maximum depth.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: The JSON document exceeds the maximum depth.",
      .oracle_str_user_error = "ORA-00600: The JSON document exceeds the maximum depth.",
      .ob_str_error          = "OBE-00600: The JSON document exceeds the maximum depth.",
      .ob_str_user_error     = "OBE-00600: The JSON document exceeds the maximum depth."
};
static const _error _error_OB_ERR_JSON_DOCUMENT_NULL_KEY = {
      .error_name            = "OB_ERR_JSON_DOCUMENT_NULL_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_JSON_DOCUMENT_NULL_KEY,
      .sqlstate              = "22032",
      .str_error             = "JSON documents may not contain NULL member names.",
      .str_user_error        = "JSON documents may not contain NULL member names.",
      .oracle_errno          = 40595,
      .oracle_str_error      = "ORA-40595: Name input to JSON generation function cannot be null",
      .oracle_str_user_error = "ORA-40595: Name input to JSON generation function cannot be null",
      .ob_str_error          = "OBE-40595: Name input to JSON generation function cannot be null",
      .ob_str_user_error     = "OBE-40595: Name input to JSON generation function cannot be null"
};
static const _error _error_OB_ERR_BLOB_CANT_HAVE_DEFAULT = {
      .error_name            = "OB_ERR_BLOB_CANT_HAVE_DEFAULT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_BLOB_CANT_HAVE_DEFAULT,
      .sqlstate              = "42000",
      .str_error             = "BLOB, TEXT, GEOMETRY or JSON column can't have a default value",
      .str_user_error        = "BLOB, TEXT, GEOMETRY or JSON column '%.*s' can't have a default value",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: Invalid default value",
      .oracle_str_user_error = "ORA-00600: Invalid default value for \'%.*s\'",
      .ob_str_error          = "OBE-00600: Invalid default value",
      .ob_str_user_error     = "OBE-00600: Invalid default value for \'%.*s\'"
};
static const _error _error_OB_ERR_INVALID_JSON_PATH_ARRAY_CELL = {
      .error_name            = "OB_ERR_INVALID_JSON_PATH_ARRAY_CELL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_INVALID_JSON_PATH_ARRAY_CELL,
      .sqlstate              = "42000",
      .str_error             = "A path expression is not a path to a cell in an array",
      .str_user_error        = "A path expression is not a path to a cell in an array",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: A path expression is not a path to a cell in an array",
      .oracle_str_user_error = "ORA-00600: A path expression is not a path to a cell in an array",
      .ob_str_error          = "OBE-00600: A path expression is not a path to a cell in an array",
      .ob_str_user_error     = "OBE-00600: A path expression is not a path to a cell in an array"
};
static const _error _error_OB_ERR_MISSING_JSON_VALUE = {
      .error_name            = "OB_ERR_MISSING_JSON_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_MISSING_JSON_VALUE,
      .sqlstate              = "22035",
      .str_error             = "No value was found by '%.*s' on the specified path.",
      .str_user_error        = "No value was found by '%.192s' on the specified path.",
      .oracle_errno          = 40462,
      .oracle_str_error      = "ORA-40462: JSON_VALUE evaluated to no value",
      .oracle_str_user_error = "ORA-40462: '%.192s' evaluated to no value",
      .ob_str_error          = "OBE-40462: JSON_VALUE evaluated to no value",
      .ob_str_user_error     = "OBE-40462: '%.192s' evaluated to no value"
};
static const _error _error_OB_ERR_MULTIPLE_JSON_VALUES = {
      .error_name            = "OB_ERR_MULTIPLE_JSON_VALUES",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_MULTIPLE_JSON_VALUES,
      .sqlstate              = "22034",
      .str_error             = "More than one value was found by '%.*s' on the specified path.",
      .str_user_error        = "More than one value was found by '%.192s' on the specified path.",
      .oracle_errno          = 40470,
      .oracle_str_error      = "ORA-40470: More than one value was found by '%.192s' on the specified path.",
      .oracle_str_user_error = "ORA-40470: More than one value was found by '%.192s' on the specified path.",
      .ob_str_error          = "OBE-40470: More than one value was found by '%.192s' on the specified path.",
      .ob_str_user_error     = "OBE-40470: More than one value was found by '%.192s' on the specified path."
};
static const _error _error_OB_SQL_RETRY_SPM = {
      .error_name            = "OB_SQL_RETRY_SPM",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "retry sql due to spm",
      .str_user_error        = "retry sql due to spm",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5434, retry sql due to spm",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5434, retry sql due to spm",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5434, retry sql due to spm",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5434, retry sql due to spm"
};
static const _error _error_OB_OUTLINE_NOT_REPRODUCIBLE = {
      .error_name            = "OB_OUTLINE_NOT_REPRODUCIBLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "outline not reproducible",
      .str_user_error        = "outline not reproducible",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5435, outline not reproducible",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5435, outline not reproducible",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5435, outline not reproducible",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5435, outline not reproducible"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_TIMESTAMP_TO_SCN = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_TIMESTAMP_TO_SCN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for timestamp_to_scn()",
      .str_user_error        = " TIMESTAMP_TO_SCN expected timestamp argument",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5436, Invalid argument for timestamp_to_scn()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5436,  TIMESTAMP_TO_SCN expected timestamp argument",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5436, Invalid argument for timestamp_to_scn()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5436,  TIMESTAMP_TO_SCN expected timestamp argument"
};
static const _error _error_OB_INVALID_ARGUMENT_FOR_SCN_TO_TIMESTAMP = {
      .error_name            = "OB_INVALID_ARGUMENT_FOR_SCN_TO_TIMESTAMP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid argument for scn_to_timestamp()",
      .str_user_error        = "SCN_TO_TIMESTAMP expected a integer number as nsec argument",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5437, Invalid argument for scn_to_timestamp()",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5437, SCN_TO_TIMESTAMP expected a integer number as nsec argument",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5437, Invalid argument for scn_to_timestamp()",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5437, SCN_TO_TIMESTAMP expected a integer number as nsec argument"
};
static const _error _error_OB_EER_WINDOW_NO_CHILD_PARTITIONING = {
      .error_name            = "OB_EER_WINDOW_NO_CHILD_PARTITIONING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WINDOW_NO_CHILD_PARTITIONING,
      .sqlstate              = "HY000",
      .str_error             = "Named window cann't be modified by another partitioning property",
      .str_user_error        = "A window which depends on another cannot define partitioning",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5438, Named window cann't be modified by another partitioning property",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5438, A window which depends on another cannot define partitioning",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5438, Named window cann't be modified by another partitioning property",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5438, A window which depends on another cannot define partitioning"
};
static const _error _error_OB_EER_WINDOW_NO_INHERIT_FRAME = {
      .error_name            = "OB_EER_WINDOW_NO_INHERIT_FRAME",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WINDOW_NO_INHERIT_FRAME,
      .sqlstate              = "HY000",
      .str_error             = "Named window cann't be modified by another framing property",
      .str_user_error        = "Window '%.*s' has a frame definition, so cannot be referenced by another window",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5439, Named window cann't be modified by another framing property",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5439, Window '%.*s' has a frame definition, so cannot be referenced by another window",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5439, Named window cann't be modified by another framing property",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5439, Window '%.*s' has a frame definition, so cannot be referenced by another window"
};
static const _error _error_OB_EER_WINDOW_NO_REDEFINE_ORDER_BY = {
      .error_name            = "OB_EER_WINDOW_NO_REDEFINE_ORDER_BY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WINDOW_NO_REDEFINE_ORDER_BY,
      .sqlstate              = "HY000",
      .str_error             = "Named window cann't be modified by another ordering property",
      .str_user_error        = "Window '%.*s' cannot inherit '%.*s' since both contain an ORDER BY clause",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5440, Named window cann't be modified by another ordering property",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5440, Window '%.*s' cannot inherit '%.*s' since both contain an ORDER BY clause",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5440, Named window cann't be modified by another ordering property",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5440, Window '%.*s' cannot inherit '%.*s' since both contain an ORDER BY clause"
};
static const _error _error_OB_ERR_INVALID_JSON_TYPE = {
      .error_name            = "OB_ERR_INVALID_JSON_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "invalid JSON type.",
      .str_user_error        = "invalid JSON type.",
      .oracle_errno          = 40587,
      .oracle_str_error      = "ORA-40587: invalid JSON type.",
      .oracle_str_user_error = "ORA-40587: invalid JSON type.",
      .ob_str_error          = "OBE-40587: invalid JSON type.",
      .ob_str_user_error     = "OBE-40587: invalid JSON type."
};
static const _error _error_OB_ERR_JSON_PATH_SYNTAX_ERROR = {
      .error_name            = "OB_ERR_JSON_PATH_SYNTAX_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON path expression syntax error ('INT')",
      .str_user_error        = "JSON path expression syntax error ('%s')",
      .oracle_errno          = 40442,
      .oracle_str_error      = "ORA-40442: JSON path expression syntax error ('INT')",
      .oracle_str_user_error = "ORA-40442: JSON path expression syntax error ('%s')",
      .ob_str_error          = "OBE-40442: JSON path expression syntax error ('INT')",
      .ob_str_user_error     = "OBE-40442: JSON path expression syntax error ('%s')"
};
static const _error _error_OB_ERR_INVALID_DATA_TYPE_RETURNING = {
      .error_name            = "OB_ERR_INVALID_DATA_TYPE_RETURNING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "invalid data type for return value",
      .str_user_error        = "invalid data type for return value",
      .oracle_errno          = 40449,
      .oracle_str_error      = "ORA-40449: invalid data type for return value",
      .oracle_str_user_error = "ORA-40449: invalid data type for return value",
      .ob_str_error          = "OBE-40449: invalid data type for return value",
      .ob_str_user_error     = "OBE-40449: invalid data type for return value"
};
static const _error _error_OB_ERR_JSON_VALUE_NO_SCALAR = {
      .error_name            = "OB_ERR_JSON_VALUE_NO_SCALAR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WRONG_JSON_TABLE_VALUE,
      .sqlstate              = "42000",
      .str_error             = "Can't store an array or an object in the scalar %s column 'jpath'",
      .str_user_error        = "Can't store an array or an object in the scalar %s column 'jpath'",
      .oracle_errno          = 40456,
      .oracle_str_error      = "ORA-40456: JSON_VALUE evaluated to non-scalar value",
      .oracle_str_user_error = "ORA-40456: JSON_VALUE evaluated to non-scalar value",
      .ob_str_error          = "OBE-40456: JSON_VALUE evaluated to non-scalar value",
      .ob_str_user_error     = "OBE-40456: JSON_VALUE evaluated to non-scalar value"
};
static const _error _error_OB_ERR_JSON_VALUE_NO_VALUE = {
      .error_name            = "OB_ERR_JSON_VALUE_NO_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON_VALUE evaluated to no value",
      .str_user_error        = "JSON_VALUE evaluated to no value",
      .oracle_errno          = 40462,
      .oracle_str_error      = "ORA-40462: JSON_VALUE evaluated to no value",
      .oracle_str_user_error = "ORA-40462: JSON_VALUE evaluated to no value",
      .ob_str_error          = "OBE-40462: JSON_VALUE evaluated to no value",
      .ob_str_user_error     = "OBE-40462: JSON_VALUE evaluated to no value"
};
static const _error _error_OB_ERR_DEFAULT_VALUE_NOT_LITERAL = {
      .error_name            = "OB_ERR_DEFAULT_VALUE_NOT_LITERAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "default value not a literal",
      .str_user_error        = "default value not a literal",
      .oracle_errno          = 40455,
      .oracle_str_error      = "ORA-40455: default value not a literal",
      .oracle_str_user_error = "ORA-40455: default value not a literal",
      .ob_str_error          = "OBE-40455: default value not a literal",
      .ob_str_user_error     = "OBE-40455: default value not a literal"
};
static const _error _error_OB_ERR_JSON_SYNTAX_ERROR = {
      .error_name            = "OB_ERR_JSON_SYNTAX_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON syntax error",
      .str_user_error        = "JSON syntax error",
      .oracle_errno          = 40441,
      .oracle_str_error      = "ORA-40441: JSON syntax error",
      .oracle_str_user_error = "ORA-40441: JSON syntax error",
      .ob_str_error          = "OBE-40441: JSON syntax error",
      .ob_str_user_error     = "OBE-40441: JSON syntax error"
};
static const _error _error_OB_ERR_JSON_EQUAL_OUTSIDE_PREDICATE = {
      .error_name            = "OB_ERR_JSON_EQUAL_OUTSIDE_PREDICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON_EQUAL used outside predicate",
      .str_user_error        = "JSON_EQUAL used outside predicate",
      .oracle_errno          = 40600,
      .oracle_str_error      = "ORA-40600: JSON_EQUAL used outside predicate",
      .oracle_str_user_error = "ORA-40600: JSON_EQUAL used outside predicate",
      .ob_str_error          = "OBE-40600: JSON_EQUAL used outside predicate",
      .ob_str_user_error     = "OBE-40600: JSON_EQUAL used outside predicate"
};
static const _error _error_OB_ERR_WITHOUT_ARR_WRAPPER = {
      .error_name            = "OB_ERR_WITHOUT_ARR_WRAPPER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "result cannot be returned without array wrapper",
      .str_user_error        = "result cannot be returned without array wrapper",
      .oracle_errno          = 40480,
      .oracle_str_error      = "ORA-40480: result cannot be returned without array wrapper",
      .oracle_str_user_error = "ORA-40480: result cannot be returned without array wrapper",
      .ob_str_error          = "OBE-40480: result cannot be returned without array wrapper",
      .ob_str_user_error     = "OBE-40480: result cannot be returned without array wrapper"
};
static const _error _error_OB_ERR_JSON_PATCH_INVALID = {
      .error_name            = "OB_ERR_JSON_PATCH_INVALID",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Patch specification is not valid JSON",
      .str_user_error        = "Patch specification is not valid JSON",
      .oracle_errno          = 40629,
      .oracle_str_error      = "ORA-40629: Patch specification is not valid JSON",
      .oracle_str_user_error = "ORA-40629: Patch specification is not valid JSON",
      .ob_str_error          = "OBE-40629: Patch specification is not valid JSON",
      .ob_str_user_error     = "OBE-40629: Patch specification is not valid JSON"
};
static const _error _error_OB_ERR_ORDER_SIBLINGS_BY_NOT_ALLOWED = {
      .error_name            = "OB_ERR_ORDER_SIBLINGS_BY_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "ORDER SIBLINGS BY clause not allowed here",
      .str_user_error        = "ORDER SIBLINGS BY clause not allowed here",
      .oracle_errno          = 30929,
      .oracle_str_error      = "ORA-30929: ORDER SIBLINGS BY clause not allowed here",
      .oracle_str_user_error = "ORA-30929: ORDER SIBLINGS BY clause not allowed here",
      .ob_str_error          = "OBE-30929: ORDER SIBLINGS BY clause not allowed here",
      .ob_str_user_error     = "OBE-30929: ORDER SIBLINGS BY clause not allowed here"
};
static const _error _error_OB_ERR_LOB_TYPE_NOT_SORTING = {
      .error_name            = "OB_ERR_LOB_TYPE_NOT_SORTING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Column of LOB type cannot be used for sorting",
      .str_user_error        = "Column of LOB type cannot be used for sorting",
      .oracle_errno          = 40750,
      .oracle_str_error      = "ORA-40750: Column of LOB type cannot be used for sorting",
      .oracle_str_user_error = "ORA-40750: Column of LOB type cannot be used for sorting",
      .ob_str_error          = "OBE-40750: Column of LOB type cannot be used for sorting",
      .ob_str_user_error     = "OBE-40750: Column of LOB type cannot be used for sorting"
};
static const _error _error_OB_ERR_DUPLICATE_KEY = {
      .error_name            = "OB_ERR_DUPLICATE_KEY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "duplicate key names in JSON object",
      .str_user_error        = "duplicate key names in JSON object",
      .oracle_errno          = 40473,
      .oracle_str_error      = "ORA-40473: duplicate key names in JSON object",
      .oracle_str_user_error = "ORA-40473: duplicate key names in JSON object",
      .ob_str_error          = "OBE-40473: duplicate key names in JSON object",
      .ob_str_user_error     = "OBE-40473: duplicate key names in JSON object"
};
static const _error _error_OB_ERR_JSON_PATH_EXPRESSION_SYNTAX_ERROR = {
      .error_name            = "OB_ERR_JSON_PATH_EXPRESSION_SYNTAX_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON path expression syntax error ('')",
      .str_user_error        = "JSON path expression syntax error ('%.*s')",
      .oracle_errno          = 40597,
      .oracle_str_error      = "ORA-40597: JSON path expression syntax error ('')",
      .oracle_str_user_error = "ORA-40597: JSON path expression syntax error ('%.*s')",
      .ob_str_error          = "OBE-40597: JSON path expression syntax error ('')",
      .ob_str_user_error     = "OBE-40597: JSON path expression syntax error ('%.*s')"
};
static const _error _error_OB_ERR_JSON_ILLEGAL_ZERO_LENGTH_IDENTIFIER_ERROR = {
      .error_name            = "OB_ERR_JSON_ILLEGAL_ZERO_LENGTH_IDENTIFIER_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "illegal zero-length identifier",
      .str_user_error        = "illegal zero-length identifier",
      .oracle_errno          = 01741,
      .oracle_str_error      = "ORA-01741: illegal zero-length identifier",
      .oracle_str_user_error = "ORA-01741: illegal zero-length identifier",
      .ob_str_error          = "OBE-01741: illegal zero-length identifier",
      .ob_str_user_error     = "OBE-01741: illegal zero-length identifier"
};
static const _error _error_OB_ERR_NO_VALUE_IN_PASSING = {
      .error_name            = "OB_ERR_NO_VALUE_IN_PASSING",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Variable in JSON path expression has no value in PASSING clause.",
      .str_user_error        = "Variable in JSON path expression has no value in PASSING clause.",
      .oracle_errno          = 40656,
      .oracle_str_error      = "ORA-40656: Variable in JSON path expression has no value in PASSING clause.",
      .oracle_str_user_error = "ORA-40656: Variable in JSON path expression has no value in PASSING clause.",
      .ob_str_error          = "OBE-40656: Variable in JSON path expression has no value in PASSING clause.",
      .ob_str_user_error     = "OBE-40656: Variable in JSON path expression has no value in PASSING clause."
};
static const _error _error_OB_ERR_INVALID_COLUMN_SPE = {
      .error_name            = "OB_ERR_INVALID_COLUMN_SPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON syntax error",
      .str_user_error        = "JSON syntax error",
      .oracle_errno          = 1747,
      .oracle_str_error      = "ORA-01747: invalid user.table.column, table.column, or column specification",
      .oracle_str_user_error = "ORA-01747: invalid user.table.column, table.column, or column specification",
      .ob_str_error          = "OBE-01747: invalid user.table.column, table.column, or column specification",
      .ob_str_user_error     = "OBE-01747: invalid user.table.column, table.column, or column specification"
};
static const _error _error_OB_ERR_INPUT_JSON_NOT_BE_NULL = {
      .error_name            = "OB_ERR_INPUT_JSON_NOT_BE_NULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON syntax error",
      .str_user_error        = "JSON syntax error",
      .oracle_errno          = 40595,
      .oracle_str_error      = "ORA-40595: Name input to JSON generation function cannot be null",
      .oracle_str_user_error = "ORA-40595: Name input to JSON generation function cannot be null",
      .ob_str_error          = "OBE-40595: Name input to JSON generation function cannot be null",
      .ob_str_user_error     = "OBE-40595: Name input to JSON generation function cannot be null"
};
static const _error _error_OB_ERR_INVALID_DATA_TYPE = {
      .error_name            = "OB_ERR_INVALID_DATA_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "invalid data type for '%s' column",
      .str_user_error        = "invalid data type for '%s' column",
      .oracle_errno          = 40484,
      .oracle_str_error      = "ORA-40484: invalid data type for '%s' column",
      .oracle_str_user_error = "ORA-40484: invalid data type for '%s' column",
      .ob_str_error          = "OBE-40484: invalid data type for '%s' column",
      .ob_str_user_error     = "OBE-40484: invalid data type for '%s' column"
};
static const _error _error_OB_ERR_INVALID_CLAUSE = {
      .error_name            = "OB_ERR_INVALID_CLAUSE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "invalid '%s' clause",
      .str_user_error        = "invalid '%s' clause",
      .oracle_errno          = 40450,
      .oracle_str_error      = "ORA-40450: invalid '%s' clause",
      .oracle_str_user_error = "ORA-40450: invalid '%s' clause",
      .ob_str_error          = "OBE-40450: invalid '%s' clause",
      .ob_str_user_error     = "OBE-40450: invalid '%s' clause"
};
static const _error _error_OB_ERR_INVALID_CMP_OP = {
      .error_name            = "OB_ERR_INVALID_CMP_OP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "invalid comparison operation involving JSON type value",
      .str_user_error        = "invalid comparison operation involving JSON type value",
      .oracle_errno          = 40796,
      .oracle_str_error      = "ORA-40796: invalid comparison operation involving JSON type value",
      .oracle_str_user_error = "ORA-40796: invalid comparison operation involving JSON type value",
      .ob_str_error          = "OBE-40796: invalid comparison operation involving JSON type value",
      .ob_str_user_error     = "OBE-40796: invalid comparison operation involving JSON type value"
};
static const _error _error_OB_ERR_INVALID_INPUT = {
      .error_name            = "OB_ERR_INVALID_INPUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid Input",
      .str_user_error        = "Invalid Input",
      .oracle_errno          = 30980,
      .oracle_str_error      = "ORA-30980: Invalid Input",
      .oracle_str_user_error = "ORA-30980: Invalid Input",
      .ob_str_error          = "OBE-30980: Invalid Input",
      .ob_str_user_error     = "OBE-30980: Invalid Input"
};
static const _error _error_OB_ERR_EMPTY_INPUT_TO_JSON_OPERATOR = {
      .error_name            = "OB_ERR_EMPTY_INPUT_TO_JSON_OPERATOR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "empty input to JSON operator",
      .str_user_error        = "empty input to JSON operator",
      .oracle_errno          = 40833,
      .oracle_str_error      = "ORA-40833: empty input to JSON operator",
      .oracle_str_user_error = "ORA-40833: empty input to JSON operator",
      .ob_str_error          = "OBE-40833: empty input to JSON operator",
      .ob_str_user_error     = "OBE-40833: empty input to JSON operator"
};
static const _error _error_OB_ERR_ADDITIONAL_IS_JSON = {
      .error_name            = "OB_ERR_ADDITIONAL_IS_JSON",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "cannot add additional IS jSON check constraint",
      .str_user_error        = "cannot add additional IS jSON check constraint",
      .oracle_errno          = 40664,
      .oracle_str_error      = "ORA-40664: cannot add additional IS jSON check constraint",
      .oracle_str_user_error = "ORA-40664: cannot add additional IS jSON check constraint",
      .ob_str_error          = "OBE-40664: cannot add additional IS jSON check constraint",
      .ob_str_user_error     = "OBE-40664: cannot add additional IS jSON check constraint"
};
static const _error _error_OB_ERR_FUNCTION_INVALID_STATE = {
      .error_name            = "OB_ERR_FUNCTION_INVALID_STATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Package or function PRO is in an invalid state",
      .str_user_error        = "Package or function PRO is in an invalid state",
      .oracle_errno          = 6575,
      .oracle_str_error      = "ORA-06575: Package or function PRO is in an invalid state",
      .oracle_str_user_error = "ORA-06575: Package or function PRO is in an invalid state",
      .ob_str_error          = "OBE-06575: Package or function PRO is in an invalid state",
      .ob_str_user_error     = "OBE-06575: Package or function PRO is in an invalid state"
};
static const _error _error_OB_ERR_MISS_VALUE = {
      .error_name            = "OB_ERR_MISS_VALUE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "missing VALUE keyword",
      .str_user_error        = "missing VALUE keyword",
      .oracle_errno          = 2000,
      .oracle_str_error      = "ORA-02000: missing VALUE keyword",
      .oracle_str_user_error = "ORA-02000: missing VALUE keyword",
      .ob_str_error          = "OBE-02000: missing VALUE keyword",
      .ob_str_user_error     = "OBE-02000: missing VALUE keyword"
};
static const _error _error_OB_ERR_DIFFERENT_TYPE_SELECTED = {
      .error_name            = "OB_ERR_DIFFERENT_TYPE_SELECTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON path expression selected a value of different data type",
      .str_user_error        = "JSON path expression selected a value of different data type",
      .oracle_errno          = 40566,
      .oracle_str_error      = "ORA-40566: JSON path expression selected a value of different data type",
      .oracle_str_user_error = "ORA-40566: JSON path expression selected a value of different data type",
      .ob_str_error          = "OBE-40566: JSON path expression selected a value of different data type",
      .ob_str_user_error     = "OBE-40566: JSON path expression selected a value of different data type"
};
static const _error _error_OB_ERR_NO_VALUE_SELECTED = {
      .error_name            = "OB_ERR_NO_VALUE_SELECTED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON path expression did not select a value.",
      .str_user_error        = "JSON path expression did not select a value.",
      .oracle_errno          = 40565,
      .oracle_str_error      = "ORA-40565: JSON path expression did not select a value.",
      .oracle_str_user_error = "ORA-40565: JSON path expression did not select a value.",
      .ob_str_error          = "OBE-40565: JSON path expression did not select a value.",
      .ob_str_user_error     = "OBE-40565: JSON path expression did not select a value."
};
static const _error _error_OB_ERR_NON_TEXT_RET_NOTSUPPORT = {
      .error_name            = "OB_ERR_NON_TEXT_RET_NOTSUPPORT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "ASCII or PRETTY not supported for non-textual return data type",
      .str_user_error        = "ASCII or PRETTY not supported for non-textual return data type",
      .oracle_errno          = 40481,
      .oracle_str_error      = "ORA-40481: ASCII or PRETTY not supported for non-textual return data type",
      .oracle_str_user_error = "ORA-40481: ASCII or PRETTY not supported for non-textual return data type",
      .ob_str_error          = "OBE-40481: ASCII or PRETTY not supported for non-textual return data type",
      .ob_str_user_error     = "OBE-40481: ASCII or PRETTY not supported for non-textual return data type"
};
static const _error _error_OB_ERR_PL_JSONTYPE_USAGE = {
      .error_name            = "OB_ERR_PL_JSONTYPE_USAGE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid use of PL/SQL JSON object type",
      .str_user_error        = "Invalid use of PL/SQL JSON object type",
      .oracle_errno          = 40573,
      .oracle_str_error      = "ORA-40573: Invalid use of PL/SQL JSON object type",
      .oracle_str_user_error = "ORA-40573: Invalid use of PL/SQL JSON object type",
      .ob_str_error          = "OBE-40573: Invalid use of PL/SQL JSON object type",
      .ob_str_user_error     = "OBE-40573: Invalid use of PL/SQL JSON object type"
};
static const _error _error_OB_ERR_NULL_INPUT = {
      .error_name            = "OB_ERR_NULL_INPUT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Input cannot be null",
      .str_user_error        = "Input cannot be null",
      .oracle_errno          = 64403,
      .oracle_str_error      = "ORA-64403: Input cannot be null",
      .oracle_str_user_error = "ORA-64403: Input cannot be null",
      .ob_str_error          = "OBE-64403: Input cannot be null",
      .ob_str_user_error     = "OBE-64403: Input cannot be null"
};
static const _error _error_OB_ERR_NOT_ISO_8601_FORMAT = {
      .error_name            = "OB_ERR_NOT_ISO_8601_FORMAT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "date or time stamp string value does not conform to ISO 8601 format",
      .str_user_error        = "Jdate or time stamp string value does not conform to ISO 8601 format",
      .oracle_errno          = 40688,
      .oracle_str_error      = "ORA-40688: date or time stamp string value does not conform to ISO 8601 format",
      .oracle_str_user_error = "ORA-40688: date or time stamp string value does not conform to ISO 8601 format",
      .ob_str_error          = "OBE-40688: date or time stamp string value does not conform to ISO 8601 format",
      .ob_str_user_error     = "OBE-40688: date or time stamp string value does not conform to ISO 8601 format"
};
static const _error _error_OB_ERR_VALUE_EXCEEDED_MAX = {
      .error_name            = "OB_ERR_VALUE_EXCEEDED_MAX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "value is out of range",
      .str_user_error        = "%d value is out of range in %d",
      .oracle_errno          = 40459,
      .oracle_str_error      = "ORA-40459: output value too large",
      .oracle_str_user_error = "ORA-40459: output value too large (actual: %d, maximum: %d)",
      .ob_str_error          = "OBE-40459: output value too large",
      .ob_str_user_error     = "OBE-40459: output value too large (actual: %d, maximum: %d)"
};
static const _error _error_OB_ERR_DEFAULT_VALUE_NOT_MATCH = {
      .error_name            = "OB_ERR_DEFAULT_VALUE_NOT_MATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "default value not matching type defined in RETURNING clause",
      .str_user_error        = "default value not matching type defined in RETURNING clause",
      .oracle_errno          = 40452,
      .oracle_str_error      = "ORA-40452: default value not matching type defined in RETURNING clause",
      .oracle_str_user_error = "ORA-40452: default value not matching type defined in RETURNING clause",
      .ob_str_error          = "OBE-40452: default value not matching type defined in RETURNING clause",
      .ob_str_user_error     = "OBE-40452: default value not matching type defined in RETURNING clause"
};
static const _error _error_OB_ERR_BOOL_NOT_CONVERT_NUMBER = {
      .error_name            = "OB_ERR_BOOL_NOT_CONVERT_NUMBER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "cannot convert Boolean value to number",
      .str_user_error        = "cannot convert Boolean value to number",
      .oracle_errno          = 40799,
      .oracle_str_error      = "ORA-40799: cannot convert Boolean value to number",
      .oracle_str_user_error = "ORA-40799: cannot convert Boolean value to number",
      .ob_str_error          = "OBE-40799: cannot convert Boolean value to number",
      .ob_str_user_error     = "OBE-40799: cannot convert Boolean value to number"
};
static const _error _error_OB_ERR_CONVERSION_FAIL = {
      .error_name            = "OB_ERR_CONVERSION_FAIL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON conversion failed",
      .str_user_error        = "JSON conversion failed",
      .oracle_errno          = 40570,
      .oracle_str_error      = "ORA-40570: JSON conversion failed",
      .oracle_str_user_error = "ORA-40570: JSON conversion failed",
      .ob_str_error          = "OBE-40570: JSON conversion failed",
      .ob_str_user_error     = "OBE-40570: JSON conversion failed"
};
static const _error _error_OB_ERR_NOT_OBJ_REF = {
      .error_name            = "OB_ERR_NOT_OBJ_REF",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "not an object or REF",
      .str_user_error        = "not an object or REF",
      .oracle_errno          = 22806,
      .oracle_str_error      = "ORA-22806: not an object or REF",
      .oracle_str_user_error = "ORA-22806: not an object or REF",
      .ob_str_error          = "OBE-22806: not an object or REF",
      .ob_str_user_error     = "OBE-22806: not an object or REF"
};
static const _error _error_OB_ERR_UNSUPPORT_TRUNCATE_TYPE = {
      .error_name            = "OB_ERR_UNSUPPORT_TRUNCATE_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Truncation is not supported with data type in RETURNING clause",
      .str_user_error        = "Truncation is not supported with data type in RETURNING clause",
      .oracle_errno          = 40779,
      .oracle_str_error      = "ORA-40779: Truncation is not supported with data type in RETURNING clause",
      .oracle_str_user_error = "ORA-40779: Truncation is not supported with data type in RETURNING clause",
      .ob_str_error          = "OBE-40779: Truncation is not supported with data type in RETURNING clause",
      .ob_str_user_error     = "OBE-40779: Truncation is not supported with data type in RETURNING clause"
};
static const _error _error_OB_ERR_UNIMPLEMENT_JSON_FEATURE = {
      .error_name            = "OB_ERR_UNIMPLEMENT_JSON_FEATURE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Unimplemented JSON feature",
      .str_user_error        = "Unimplemented JSON feature",
      .oracle_errno          = 40569,
      .oracle_str_error      = "ORA-40569: Unimplemented JSON feature",
      .oracle_str_user_error = "ORA-40569: Unimplemented JSON feature",
      .ob_str_error          = "OBE-40569: Unimplemented JSON feature",
      .ob_str_user_error     = "OBE-40569: Unimplemented JSON feature"
};
static const _error _error_OB_ERR_USAGE_KEYWORD = {
      .error_name            = "OB_ERR_USAGE_KEYWORD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "invalid usage of keyword EXISTS",
      .str_user_error        = "invalid usage of keyword EXISTS",
      .oracle_errno          = 40487,
      .oracle_str_error      = "ORA-40487: invalid usage of keyword EXISTS",
      .oracle_str_user_error = "ORA-40487: invalid usage of keyword EXISTS",
      .ob_str_error          = "OBE-40487: invalid usage of keyword EXISTS",
      .ob_str_user_error     = "OBE-40487: invalid usage of keyword EXISTS"
};
static const _error _error_OB_ERR_INPUT_JSON_TABLE = {
      .error_name            = "OB_ERR_INPUT_JSON_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "invalid input data type for JSON_TABLE",
      .str_user_error        = "invalid input data type for JSON_TABLE",
      .oracle_errno          = 40491,
      .oracle_str_error      = "ORA-40491: invalid input data type for JSON_TABLE",
      .oracle_str_user_error = "ORA-40491: invalid input data type for JSON_TABLE",
      .ob_str_error          = "OBE-40491: invalid input data type for JSON_TABLE",
      .ob_str_user_error     = "OBE-40491: invalid input data type for JSON_TABLE"
};
static const _error _error_OB_ERR_BOOL_CAST_NUMBER = {
      .error_name            = "OB_ERR_BOOL_CAST_NUMBER",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "cannot convert Boolean value to number",
      .str_user_error        = "cannot convert Boolean value to number",
      .oracle_errno          = 40799,
      .oracle_str_error      = "ORA-40799: cannot convert Boolean value to number",
      .oracle_str_user_error = "ORA-40799: cannot convert Boolean value to number",
      .ob_str_error          = "OBE-40799: cannot convert Boolean value to number",
      .ob_str_user_error     = "OBE-40799: cannot convert Boolean value to number"
};
static const _error _error_OB_ERR_NESTED_PATH_DISJUNCT = {
      .error_name            = "OB_ERR_NESTED_PATH_DISJUNCT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON_TABLE nested path expressions not disjunct",
      .str_user_error        = "JSON_TABLE nested path expressions not disjunct",
      .oracle_errno          = 40560,
      .oracle_str_error      = "ORA-40560: JSON_TABLE nested path expressions not disjunct",
      .oracle_str_user_error = "ORA-40560: JSON_TABLE nested path expressions not disjunct",
      .ob_str_error          = "OBE-40560: JSON_TABLE nested path expressions not disjunct",
      .ob_str_user_error     = "OBE-40560: JSON_TABLE nested path expressions not disjunct"
};
static const _error _error_OB_ERR_INVALID_VARIABLE_IN_JSON_PATH = {
      .error_name            = "OB_ERR_INVALID_VARIABLE_IN_JSON_PATH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = " Invalid use of bind variable in SQL/JSON path.",
      .str_user_error        = " Invalid use of bind variable in SQL/JSON path.",
      .oracle_errno          = 40576,
      .oracle_str_error      = "ORA-40576:  Invalid use of bind variable in SQL/JSON path.",
      .oracle_str_user_error = "ORA-40576:  Invalid use of bind variable in SQL/JSON path.",
      .ob_str_error          = "OBE-40576:  Invalid use of bind variable in SQL/JSON path.",
      .ob_str_user_error     = "OBE-40576:  Invalid use of bind variable in SQL/JSON path."
};
static const _error _error_OB_ERR_JSON_KEY_NOT_FOUND = {
      .error_name            = "OB_ERR_JSON_KEY_NOT_FOUND",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "JSON key name not found.",
      .str_user_error        = "JSON key name not found.",
      .oracle_errno          = 40571,
      .oracle_str_error      = "ORA-40571: JSON key name not found.",
      .oracle_str_user_error = "ORA-40571: JSON key name not found.",
      .ob_str_error          = "OBE-40571: JSON key name not found.",
      .ob_str_user_error     = "OBE-40571: JSON key name not found."
};
static const _error _error_OB_ERR_INVALID_DEFAULT_VALUE_PROVIDED = {
      .error_name            = "OB_ERR_INVALID_DEFAULT_VALUE_PROVIDED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Invalid numeric",
      .str_user_error        = "Invalid numeric",
      .oracle_errno          = 40451,
      .oracle_str_error      = "ORA-40451: invalid default value provided",
      .oracle_str_user_error = "ORA-40451: invalid default value provided",
      .ob_str_error          = "OBE-40451: invalid default value provided",
      .ob_str_user_error     = "OBE-40451: invalid default value provided"
};
static const _error _error_OB_ERR_PATH_EXPRESSION_NOT_LITERAL = {
      .error_name            = "OB_ERR_PATH_EXPRESSION_NOT_LITERAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "path expression not a literal",
      .str_user_error        = "path expression not a literal",
      .oracle_errno          = 40454,
      .oracle_str_error      = "ORA-40454: path expression not a literal",
      .oracle_str_user_error = "ORA-40454: path expression not a literal",
      .ob_str_error          = "OBE-40454: path expression not a literal",
      .ob_str_user_error     = "OBE-40454: path expression not a literal"
};
static const _error _error_OB_ERR_INVALID_ARGUMENT_FOR_JSON_CALL = {
      .error_name            = "OB_ERR_INVALID_ARGUMENT_FOR_JSON_CALL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "invalid argument for JSON call",
      .str_user_error        = "invalid argument for %s call",
      .oracle_errno          = 185,
      .oracle_str_error      = "PLS-00185: invalid argument for JSON call",
      .oracle_str_user_error = "PLS-00185: invalid argument for %s call",
      .ob_str_error          = "PLS-00185: invalid argument for JSON call",
      .ob_str_user_error     = "PLS-00185: invalid argument for %s call"
};
static const _error _error_OB_ERR_SCHEMA_HISTORY_EMPTY = {
      .error_name            = "OB_ERR_SCHEMA_HISTORY_EMPTY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Schema history is empty",
      .str_user_error        = "Schema history is empty",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5489, Schema history is empty",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5489, Schema history is empty",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5489, Schema history is empty",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5489, Schema history is empty"
};
static const _error _error_OB_ERR_TABLE_NAME_NOT_IN_LIST = {
      .error_name            = "OB_ERR_TABLE_NAME_NOT_IN_LIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "table name not in FROM list",
      .str_user_error        = "table name not in FROM list",
      .oracle_errno          = 964,
      .oracle_str_error      = "ORA-00964: table name not in FROM list",
      .oracle_str_user_error = "ORA-00964: table name not in FROM list",
      .ob_str_error          = "OBE-00964: table name not in FROM list",
      .ob_str_user_error     = "OBE-00964: table name not in FROM list"
};
static const _error _error_OB_ERR_DEFAULT_NOT_AT_LAST_IN_LIST_PART = {
      .error_name            = "OB_ERR_DEFAULT_NOT_AT_LAST_IN_LIST_PART",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "DEFAULT partition must be last partition specified",
      .str_user_error        = "DEFAULT partition must be last partition specified",
      .oracle_errno          = 14318,
      .oracle_str_error      = "ORA-14318: DEFAULT partition must be last partition specified",
      .oracle_str_user_error = "ORA-14318: DEFAULT partition must be last partition specified",
      .ob_str_error          = "OBE-14318: DEFAULT partition must be last partition specified",
      .ob_str_user_error     = "OBE-14318: DEFAULT partition must be last partition specified"
};
static const _error _error_OB_ERR_MYSQL_CHARACTER_SET_MISMATCH = {
      .error_name            = "OB_ERR_MYSQL_CHARACTER_SET_MISMATCH",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CHARACTER_SET_MISMATCH,
      .sqlstate              = "HY000",
      .str_error             = "Character set cannot be used in conjunction with binary collations in function call",
      .str_user_error        = "Character set '%.*s' cannot be used in conjunction with '%.*s' in regexp function call.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5492, Character set cannot be used in conjunction with binary collations in function call",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5492, Character set '%.*s' cannot be used in conjunction with '%.*s' in regexp function call.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5492, Character set cannot be used in conjunction with binary collations in function call",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5492, Character set '%.*s' cannot be used in conjunction with '%.*s' in regexp function call."
};
static const _error _error_OB_ERR_RENAME_PARTITION_NAME_DUPLICATE = {
      .error_name            = "OB_ERR_RENAME_PARTITION_NAME_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SAME_NAME_PARTITION,
      .sqlstate              = "HY000",
      .str_error             = "Duplicate partition name",
      .str_user_error        = "Duplicate partition name %.*s",
      .oracle_errno          = 14082,
      .oracle_str_error      = "ORA-14082: New partition name must differ from that of any other partition or subpartition of the object.",
      .oracle_str_user_error = "ORA-14082: New partition name %.*s must differ from that of any other partition or subpartition of the object.",
      .ob_str_error          = "OBE-14082: New partition name must differ from that of any other partition or subpartition of the object.",
      .ob_str_user_error     = "OBE-14082: New partition name %.*s must differ from that of any other partition or subpartition of the object."
};
static const _error _error_OB_ERR_RENAME_SUBPARTITION_NAME_DUPLICATE = {
      .error_name            = "OB_ERR_RENAME_SUBPARTITION_NAME_DUPLICATE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SAME_NAME_PARTITION,
      .sqlstate              = "HY000",
      .str_error             = "Duplicate partition name",
      .str_user_error        = "Duplicate partition name %.*s",
      .oracle_errno          = 14263,
      .oracle_str_error      = "ORA-14263: New subpartition name must differ from that of any other partition or subpartition of the object.",
      .oracle_str_user_error = "ORA-14263: New subpartition name %.*s must differ from that of any other partition or subpartition of the object.",
      .ob_str_error          = "OBE-14263: New subpartition name must differ from that of any other partition or subpartition of the object.",
      .ob_str_user_error     = "OBE-14263: New subpartition name %.*s must differ from that of any other partition or subpartition of the object."
};
static const _error _error_OB_ERR_INVALID_WAIT_INTERVAL = {
      .error_name            = "OB_ERR_INVALID_WAIT_INTERVAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "missing or invalid WAIT interval",
      .str_user_error        = "missing or invalid WAIT interval",
      .oracle_errno          = 30005,
      .oracle_str_error      = "ORA-30005: missing or invalid WAIT interval",
      .oracle_str_user_error = "ORA-30005: missing or invalid WAIT interval",
      .ob_str_error          = "OBE-30005: missing or invalid WAIT interval",
      .ob_str_user_error     = "OBE-30005: missing or invalid WAIT interval"
};
static const _error _error_OB_ERR_FUNCTIONAL_INDEX_REF_AUTO_INCREMENT = {
      .error_name            = "OB_ERR_FUNCTIONAL_INDEX_REF_AUTO_INCREMENT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FUNCTIONAL_INDEX_REF_AUTO_INCREMENT,
      .sqlstate              = "HY000",
      .str_error             = "Functional index cannot refer to an auto-increment column.",
      .str_user_error        = "Functional index '%.*s' cannot refer to an auto-increment column.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5496, Functional index cannot refer to an auto-increment column.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5496, Functional index '%.*s' cannot refer to an auto-increment column.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5496, Functional index cannot refer to an auto-increment column.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5496, Functional index '%.*s' cannot refer to an auto-increment column."
};
static const _error _error_OB_ERR_DEPENDENT_BY_FUNCTIONAL_INDEX = {
      .error_name            = "OB_ERR_DEPENDENT_BY_FUNCTIONAL_INDEX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DEPENDENT_BY_FUNCTIONAL_INDEX,
      .sqlstate              = "HY000",
      .str_error             = "Column has a functional index dependency and cannot be dropped or renamed.",
      .str_user_error        = "Column '%.*s' has a functional index dependency and cannot be dropped or renamed.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5497, Column has a functional index dependency and cannot be dropped or renamed.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5497, Column '%.*s' has a functional index dependency and cannot be dropped or renamed.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5497, Column has a functional index dependency and cannot be dropped or renamed.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5497, Column '%.*s' has a functional index dependency and cannot be dropped or renamed."
};
static const _error _error_OB_ERR_FUNCTIONAL_INDEX_ON_LOB = {
      .error_name            = "OB_ERR_FUNCTIONAL_INDEX_ON_LOB",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FUNCTIONAL_INDEX_ON_LOB,
      .sqlstate              = "HY000",
      .str_error             = "Cannot create a functional index on an expression that returns a BLOB or TEXT. Please consider using CAST.",
      .str_user_error        = "Cannot create a functional index on an expression that returns a BLOB or TEXT. Please consider using CAST.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5498, Cannot create a functional index on an expression that returns a BLOB or TEXT. Please consider using CAST.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5498, Cannot create a functional index on an expression that returns a BLOB or TEXT. Please consider using CAST.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5498, Cannot create a functional index on an expression that returns a BLOB or TEXT. Please consider using CAST.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5498, Cannot create a functional index on an expression that returns a BLOB or TEXT. Please consider using CAST."
};
static const _error _error_OB_ERR_FUNCTIONAL_INDEX_ON_FIELD = {
      .error_name            = "OB_ERR_FUNCTIONAL_INDEX_ON_FIELD",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FUNCTIONAL_INDEX_ON_FIELD,
      .sqlstate              = "HY000",
      .str_error             = "Functional index on a column is not supported. Consider using a regular index instead.",
      .str_user_error        = "Functional index on a column is not supported. Consider using a regular index instead.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5499, Functional index on a column is not supported. Consider using a regular index instead.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5499, Functional index on a column is not supported. Consider using a regular index instead.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5499, Functional index on a column is not supported. Consider using a regular index instead.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5499, Functional index on a column is not supported. Consider using a regular index instead."
};
static const _error _error_OB_ERR_GENCOL_LEGIT_CHECK_FAILED = {
      .error_name            = "OB_ERR_GENCOL_LEGIT_CHECK_FAILED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Legitimacy check failed for generated columns.",
      .str_user_error        = "Legitimacy check failed for generated columns.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5500, Legitimacy check failed for generated columns.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5500, Legitimacy check failed for generated columns.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5500, Legitimacy check failed for generated columns.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5500, Legitimacy check failed for generated columns."
};
static const _error _error_OB_ERR_GROUPING_FUNC_WITHOUT_GROUP_BY = {
      .error_name            = "OB_ERR_GROUPING_FUNC_WITHOUT_GROUP_BY",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "GROUPING function only supported with GROUP BY CUBE or ROLLUP",
      .str_user_error        = "GROUPING function only supported with GROUP BY CUBE or ROLLUP",
      .oracle_errno          = 30481,
      .oracle_str_error      = "ORA-30481: GROUPING function only supported with GROUP BY CUBE or ROLLUP",
      .oracle_str_user_error = "ORA-30481: GROUPING function only supported with GROUP BY CUBE or ROLLUP",
      .ob_str_error          = "OBE-30481: GROUPING function only supported with GROUP BY CUBE or ROLLUP",
      .ob_str_user_error     = "OBE-30481: GROUPING function only supported with GROUP BY CUBE or ROLLUP"
};
static const _error _error_OB_ERR_DEPENDENT_BY_PARTITION_FUNC = {
      .error_name            = "OB_ERR_DEPENDENT_BY_PARTITION_FUNC",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_DEPENDENT_BY_PARTITION_FUNC,
      .sqlstate              = "HY000",
      .str_error             = "Column has a partitioning function dependency and cannot be dropped or renamed.",
      .str_user_error        = "Column '%.*s' has a partitioning function dependency and cannot be dropped or renamed.",
      .oracle_errno          = 12984,
      .oracle_str_error      = "ORA-12984: cannot drop partitioning column",
      .oracle_str_user_error = "ORA-12984: cannot drop partitioning column '%.*s'",
      .ob_str_error          = "OBE-12984: cannot drop partitioning column",
      .ob_str_user_error     = "OBE-12984: cannot drop partitioning column '%.*s'"
};
static const _error _error_OB_ERR_VIEW_SELECT_CONTAIN_INTO = {
      .error_name            = "OB_ERR_VIEW_SELECT_CONTAIN_INTO",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_VIEW_SELECT_CLAUSE,
      .sqlstate              = "HY000",
      .str_error             = "View's SELECT contains a 'INTO' clause.",
      .str_user_error        = "View's SELECT contains a 'INTO' clause.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5503, View's SELECT contains a 'INTO' clause.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5503, View's SELECT contains a 'INTO' clause.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5503, View's SELECT contains a 'INTO' clause.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5503, View's SELECT contains a 'INTO' clause."
};
static const _error _error_OB_ERR_DEFAULT_NOT_ALLOWED = {
      .error_name            = "OB_ERR_DEFAULT_NOT_ALLOWED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Virtual column cannot have a default value",
      .str_user_error        = "Virtual column cannot have a default value",
      .oracle_errno          = 54025,
      .oracle_str_error      = "ORA-54025: Virtual column cannot have a default value",
      .oracle_str_user_error = "ORA-54025: Virtual column cannot have a default value",
      .ob_str_error          = "OBE-54025: Virtual column cannot have a default value",
      .ob_str_user_error     = "OBE-54025: Virtual column cannot have a default value"
};
static const _error _error_OB_ERR_MODIFY_REALCOL_TO_GENCOL = {
      .error_name            = "OB_ERR_MODIFY_REALCOL_TO_GENCOL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "Real column cannot have an expression",
      .str_user_error        = "Real column cannot have an expression",
      .oracle_errno          = 54026,
      .oracle_str_error      = "ORA-54026: Real column cannot have an expression",
      .oracle_str_user_error = "ORA-54026: Real column cannot have an expression",
      .ob_str_error          = "OBE-54026: Real column cannot have an expression",
      .ob_str_user_error     = "OBE-54026: Real column cannot have an expression"
};
static const _error _error_OB_ERR_MODIFY_TYPE_OF_GENCOL = {
      .error_name            = "OB_ERR_MODIFY_TYPE_OF_GENCOL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "cannot modify data-type of virtual column",
      .str_user_error        = "cannot modify data-type of virtual column",
      .oracle_errno          = 54027,
      .oracle_str_error      = "ORA-54027: cannot modify data-type of virtual column",
      .oracle_str_user_error = "ORA-54027: cannot modify data-type of virtual column",
      .ob_str_error          = "OBE-54027: cannot modify data-type of virtual column",
      .ob_str_user_error     = "OBE-54027: cannot modify data-type of virtual column"
};
static const _error _error_OB_ERR_WINDOW_FRAME_ILLEGAL = {
      .error_name            = "OB_ERR_WINDOW_FRAME_ILLEGAL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WINDOW_FRAME_ILLEGAL,
      .sqlstate              = "HY000",
      .str_error             = "frame start or end is negative or NULL or of non-integral type",
      .str_user_error        = "Window '%.*s': frame start or end is negative or NULL or of non-integral type",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5507, frame start or end is negative or NULL or of non-integral type",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5507, Window '%.*s': frame start or end is negative or NULL or of non-integral type",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5507, frame start or end is negative or NULL or of non-integral type",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5507, Window '%.*s': frame start or end is negative or NULL or of non-integral type"
};
static const _error _error_OB_ERR_WINDOW_RANGE_FRAME_TEMPORAL_TYPE = {
      .error_name            = "OB_ERR_WINDOW_RANGE_FRAME_TEMPORAL_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WINDOW_RANGE_FRAME_TEMPORAL_TYPE,
      .sqlstate              = "HY000",
      .str_error             = "Window with RANGE frame has ORDER BY expression of datetime type. Only INTERVAL bound value allowed.",
      .str_user_error        = "Window '%.*s' with RANGE frame has ORDER BY expression of datetime type. Only INTERVAL bound value allowed.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5508, Window with RANGE frame has ORDER BY expression of datetime type. Only INTERVAL bound value allowed.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5508, Window '%.*s' with RANGE frame has ORDER BY expression of datetime type. Only INTERVAL bound value allowed.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5508, Window with RANGE frame has ORDER BY expression of datetime type. Only INTERVAL bound value allowed.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5508, Window '%.*s' with RANGE frame has ORDER BY expression of datetime type. Only INTERVAL bound value allowed."
};
static const _error _error_OB_ERR_WINDOW_RANGE_FRAME_NUMERIC_TYPE = {
      .error_name            = "OB_ERR_WINDOW_RANGE_FRAME_NUMERIC_TYPE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WINDOW_RANGE_FRAME_NUMERIC_TYPE,
      .sqlstate              = "HY000",
      .str_error             = "Window with RANGE frame has ORDER BY expression of numeric type. INTERVAL bound value not allowed.",
      .str_user_error        = "Window '%.*s' with RANGE frame has ORDER BY expression of numeric type. INTERVAL bound value not allowed.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5509, Window with RANGE frame has ORDER BY expression of numeric type. INTERVAL bound value not allowed.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5509, Window '%.*s' with RANGE frame has ORDER BY expression of numeric type. INTERVAL bound value not allowed.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5509, Window with RANGE frame has ORDER BY expression of numeric type. INTERVAL bound value not allowed.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5509, Window '%.*s' with RANGE frame has ORDER BY expression of numeric type. INTERVAL bound value not allowed."
};
static const _error _error_OB_ERR_WINDOW_RANGE_BOUND_NOT_CONSTANT = {
      .error_name            = "OB_ERR_WINDOW_RANGE_BOUND_NOT_CONSTANT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WINDOW_RANGE_BOUND_NOT_CONSTANT,
      .sqlstate              = "HY000",
      .str_error             = "Window has a non-constant frame bound.",
      .str_user_error        = "Window '%.*s' has a non-constant frame bound.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5510, Window has a non-constant frame bound.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5510, Window '%.*s' has a non-constant frame bound.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5510, Window has a non-constant frame bound.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5510, Window '%.*s' has a non-constant frame bound."
};
static const _error _error_OB_ERR_DEFAULT_FOR_MODIFYING_VIEWS = {
      .error_name            = "OB_ERR_DEFAULT_FOR_MODIFYING_VIEWS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = "Explicit column default is not supported for modifying views",
      .str_user_error        = "Explicit column default is not supported for modifying views",
      .oracle_errno          = 32575,
      .oracle_str_error      = "ORA-32575: Explicit column default is not supported for modifying views",
      .oracle_str_user_error = "ORA-32575: Explicit column default is not supported for modifying views",
      .ob_str_error          = "OBE-32575: Explicit column default is not supported for modifying views",
      .ob_str_user_error     = "OBE-32575: Explicit column default is not supported for modifying views"
};
static const _error _error_OB_ERR_FK_COLUMN_NOT_NULL = {
      .error_name            = "OB_ERR_FK_COLUMN_NOT_NULL",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_FK_COLUMN_NOT_NULL,
      .sqlstate              = "HY000",
      .str_error             = "Column cannot be NOT NULL: needed in a foreign key constraint SET NULL",
      .str_user_error        = "Column \'%s\' cannot be NOT NULL: needed in a foreign key constraint \'%s\' SET NULL",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5512, Column cannot be NOT NULL: needed in a foreign key constraint SET NULL",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5512, Column \'%s\' cannot be NOT NULL: needed in a foreign key constraint \'%s\' SET NULL",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5512, Column cannot be NOT NULL: needed in a foreign key constraint SET NULL",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5512, Column \'%s\' cannot be NOT NULL: needed in a foreign key constraint \'%s\' SET NULL"
};
static const _error _error_OB_ERR_UNSUPPORTED_FK_SET_NULL_ON_GENERATED_COLUMN = {
      .error_name            = "OB_ERR_UNSUPPORTED_FK_SET_NULL_ON_GENERATED_COLUMN",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_UNSUPPORTED_FK_SET_NULL_ON_GENERATED_COLUMN,
      .sqlstate              = "HY000",
      .str_error             = " Cannot define foreign key with ON DELETE SET NULL clause on a generated column",
      .str_user_error        = " Cannot define foreign key with ON DELETE SET NULL clause on a generated column",
      .oracle_errno          = 54036,
      .oracle_str_error      = "ORA-54036: cannot define referential constraint with ON DELETE SET NULL clause on virtual column",
      .oracle_str_user_error = "ORA-54036: cannot define referential constraint with ON DELETE SET NULL clause on virtual column",
      .ob_str_error          = "OBE-54036: cannot define referential constraint with ON DELETE SET NULL clause on virtual column",
      .ob_str_user_error     = "OBE-54036: cannot define referential constraint with ON DELETE SET NULL clause on virtual column"
};
static const _error _error_OB_JSON_PROCESSING_ERROR = {
      .error_name            = "OB_JSON_PROCESSING_ERROR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "42000",
      .str_error             = " JSON processing error",
      .str_user_error        = " JSON processing error",
      .oracle_errno          = 40444,
      .oracle_str_error      = "ORA-40444:  JSON processing error",
      .oracle_str_user_error = "ORA-40444:  JSON processing error",
      .ob_str_error          = "OBE-40444:  JSON processing error",
      .ob_str_user_error     = "OBE-40444:  JSON processing error"
};
static const _error _error_OB_ERR_TABLE_WITHOUT_ALIAS = {
      .error_name            = "OB_ERR_TABLE_WITHOUT_ALIAS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_TF_MUST_HAVE_ALIAS,
      .sqlstate              = "42000",
      .str_error             = "Every table function must have an alias",
      .str_user_error        = "Every table function must have an alias",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5515, Every table function must have an alias",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5515, Every table function must have an alias",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5515, Every table function must have an alias",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5515, Every table function must have an alias"
};
static const _error _error_OB_ERR_DEPRECATED_SYNTAX = {
      .error_name            = "OB_ERR_DEPRECATED_SYNTAX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DEPRECATED_SYNTAX,
      .sqlstate              = "HY000",
      .str_error             = "This syntax is deprecated and will be removed in a future release",
      .str_user_error        = "%s is deprecated and will be removed in a future release. Please use \'%s\' instead",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5516, This syntax is deprecated and will be removed in a future release",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5516, %s is deprecated and will be removed in a future release. Please use \'%s\' instead",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5516, This syntax is deprecated and will be removed in a future release",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5516, %s is deprecated and will be removed in a future release. Please use \'%s\' instead"
};
static const _error _error_OB_ERR_NON_STRING_NOT_SUPPORT = {
      .error_name            = "OB_ERR_NON_STRING_NOT_SUPPORT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NOT_SUPPORTED_YET,
      .sqlstate              = "42000",
      .str_error             = "This version of MySQL doesn't yet support 'non-string DEFAULT value for a column in a JSON_TABLE expression'",
      .str_user_error        = "This version of MySQL doesn't yet support 'non-string DEFAULT value for a column in a JSON_TABLE expression'",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5517, This version of MySQL doesn't yet support 'non-string DEFAULT value for a column in a JSON_TABLE expression'",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5517, This version of MySQL doesn't yet support 'non-string DEFAULT value for a column in a JSON_TABLE expression'",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5517, This version of MySQL doesn't yet support 'non-string DEFAULT value for a column in a JSON_TABLE expression'",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5517, This version of MySQL doesn't yet support 'non-string DEFAULT value for a column in a JSON_TABLE expression'"
};
static const _error _error_OB_ERR_DEPRECATED_SYNTAX_NO_REP = {
      .error_name            = "OB_ERR_DEPRECATED_SYNTAX_NO_REP",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_WARN_DEPRECATED_SYNTAX_NO_REPLACEMENT,
      .sqlstate              = "HY000",
      .str_error             = "This syntax is deprecated and will be removed in a future release",
      .str_user_error        = "%s is deprecated and will be removed in a future release",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5518, This syntax is deprecated and will be removed in a future release",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5518, %s is deprecated and will be removed in a future release",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5518, This syntax is deprecated and will be removed in a future release",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5518, %s is deprecated and will be removed in a future release"
};
static const _error _error_OB_NOT_MULTIVALUE_SUPPORT = {
      .error_name            = "OB_NOT_MULTIVALUE_SUPPORT",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_NOT_SUPPORTED_YET,
      .sqlstate              = "42000",
      .str_error             = "This version of MySQL doesn't yet support %s",
      .str_user_error        = "This version of MySQL doesn't yet support %s",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5519, This version of MySQL doesn't yet support %s",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5519, This version of MySQL doesn't yet support %s",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5519, This version of MySQL doesn't yet support %s",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5519, This version of MySQL doesn't yet support %s"
};
static const _error _error_OB_ERR_JSON_VALUE_CAST_FUNCTION_INDEX = {
      .error_name            = "OB_ERR_JSON_VALUE_CAST_FUNCTION_INDEX",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_CAST_INDEX_JSON_VALUE,
      .sqlstate              = "42000",
      .str_error             = "Invalid JSON value for CAST for functional index.",
      .str_user_error        = "Invalid JSON value for CAST for functional index.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5520, Invalid JSON value for CAST for functional index.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5520, Invalid JSON value for CAST for functional index.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5520, Invalid JSON value for CAST for functional index.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5520, Invalid JSON value for CAST for functional index."
};
static const _error _error_OB_ERR_JSON_CONTAINER_CAST_SCALAR = {
      .error_name            = "OB_ERR_JSON_CONTAINER_CAST_SCALAR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_ARRAY_CAST_INDEX_SCALAR,
      .sqlstate              = "42000",
      .str_error             = "Cannot store an array or an object in a scalar key part of the index.",
      .str_user_error        = "Cannot store an array or an object in a scalar key part of the index.",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5521, Cannot store an array or an object in a scalar key part of the index.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5521, Cannot store an array or an object in a scalar key part of the index.",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5521, Cannot store an array or an object in a scalar key part of the index.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5521, Cannot store an array or an object in a scalar key part of the index."
};
static const _error _error_OB_ERR_INVALID_IDENTIFIER_JSON_TABLE = {
      .error_name            = "OB_ERR_INVALID_IDENTIFIER_JSON_TABLE",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "22000",
      .str_error             = "invalid identifier used for path expression in JSON_TABLE",
      .str_user_error        = "invalid identifier used for path expression in JSON_TABLE",
      .oracle_errno          = 40680,
      .oracle_str_error      = "ORA-40680: invalid identifier used for path expression in JSON_TABLE",
      .oracle_str_user_error = "ORA-40680: invalid identifier used for path expression in JSON_TABLE",
      .ob_str_error          = "OBE-40680: invalid identifier used for path expression in JSON_TABLE",
      .ob_str_user_error     = "OBE-40680: invalid identifier used for path expression in JSON_TABLE"
};
static const _error _error_OB_ERR_SESSION_VAR_CHANGED = {
      .error_name            = "OB_ERR_SESSION_VAR_CHANGED",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = -1,
      .sqlstate              = "HY000",
      .str_error             = "System variables are different from the old values solidified.",
      .str_user_error        = "System variable '%.*s' is different from the old value solidified for '%.*s'(old value:%.*s).",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5540, System variables are different from the old values solidified.",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5540, System variable '%.*s' is different from the old value solidified for '%.*s'(old value:%.*s).",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5540, System variables are different from the old values solidified.",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5540, System variable '%.*s' is different from the old value solidified for '%.*s'(old value:%.*s)."
};
static const _error _error_OB_ERR_SP_ALREADY_EXISTS = {
      .error_name            = "OB_ERR_SP_ALREADY_EXISTS",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SP_ALREADY_EXISTS,
      .sqlstate              = "42000",
      .str_error             = "procedure/function already exists",
      .str_user_error        = "%s %.*s already exists",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5541, procedure/function already exists",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5541, %s %.*s already exists",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5541, procedure/function already exists",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5541, %s %.*s already exists"
};
static const _error _error_OB_ERR_SP_DOES_NOT_EXIST = {
      .error_name            = "OB_ERR_SP_DOES_NOT_EXIST",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SP_DOES_NOT_EXIST,
      .sqlstate              = "42000",
      .str_error             = "procedure/function does not exist",
      .str_user_error        = "%s %.*s.%.*s does not exist",
      .oracle_errno          = 600,
      .oracle_str_error      = "ORA-00600: internal error code, arguments: -5542, procedure/function does not exist",
      .oracle_str_user_error = "ORA-00600: internal error code, arguments: -5542, %s %.*s.%.*s does not exist",
      .ob_str_error          = "OBE-00600: internal error code, arguments: -5542, procedure/function does not exist",
      .ob_str_user_error     = "OBE-00600: internal error code, arguments: -5542, %s %.*s.%.*s does not exist"
};
static const _error _error_OB_ERR_SP_UNDECLARED_VAR = {
      .error_name            = "OB_ERR_SP_UNDECLARED_VAR",
      .error_cause           = "Internal Error",
      .error_solution        = "Contact OceanBase Support",
      .mysql_errno           = ER_SP_UNDECLARED_VAR,
      .sqlstate              = "42000",
      .str_error             = "Undeclared variable",
      .str_user_error        = "Undeclared variable: %.*s",
      .oracle_errno          = 201,
      .oracle_str_error      = "PLS-00201: identifier must be declared",
      .oracle_str_user_error = "PLS-00201: identifier '%.*s' must be declared",
      .ob_str_error          = "PLS-00201: identifier must be declared",
      .ob_str_user_error     = "PLS-00201: identifier '%.*s' must be declared"
};
static const _error _error_OB_ERR_SP_UNDECLARED_TYPE = {
      .error_name            = "OB_ERR_SP_UNDECLARED_TYPE",
      .error_cause           = "Internal Err