#cross database hint effective
select /*+ log_level(debug)*/ * from hint.t1;
select /*+ log_level('sql.opt:debug')*/ * from hint.t1;
select /*+ leading(ta, tb) use_nl(tb)*/ * from hint.t1 as tb, opt.t1 as ta where tb.a = ta.c1;
select /*+ leading(ta, tb) use_bnl(tb)*/ * from hint.t1 as tb, opt.t1 as ta where tb.a = ta.c1;
#cross database hint ineffective, leading table duplicated
select /*+ leading(t1) use_nl(hint.t1)*/ * from hint.t2, hint.t1, opt.t1 where hint.t2.a = opt.t1.c1;
select /*+ leading(t1) use_bnl(hint.t1)*/ * from hint.t2, hint.t1, opt.t1 where hint.t2.a = opt.t1.c1;
#cross database hint effective. table no duplicated
select /*+ leading(t2, t1) use_merge(t1)*/ * from hint.t2, opt.t1 where t1.c1 = t2.a;
#index int
select /*+ index(hint.t1 idx_t1_a)*/ * from opt.t1, hint.t1 where hint.t1.a = opt.t1.c1;
#full hint
select /*+ full(opt.t1)*/ * from opt.t1, hint.t1 where hint.t1.a = opt.t1.c2;
#ordered hint
select /*+ ordered use_nl(hint.t2 opt.t1)*/ * from (select * from t2) as tb, hint.t2, opt.t1;
select /*+ ordered use_bnl(hint.t2 opt.t1)*/ * from (select * from t2) as tb, hint.t2, opt.t1;
#as tb not exist after rewrite, leading hint ineffective
select /*+ leading(tb, opt.t1) use_nl(hint.t2 opt.t1)*/ * from (select * from t2) as tb, hint.t2, opt.t1;
select /*+ leading(tb, opt.t1) use_bnl(hint.t2, opt.t1)*/ * from (select * from t2) as tb, hint.t2, opt.t1;

#index hint
select * from opt.t1,opt.t2 use index (idx_t1_c2) where opt.t1.c1 = opt.t2.c2;
select /*+ index(t1 idx_t1_c2)*/ * from opt.t1, hint.t1 where hint.t1.a = opt.t1.c2;
select /*+ index(opt.t1 idx_t1_c2)*/ * from opt.t1, hint.t1 where hint.t1.a = opt.t1.c2;
select /*+ index(opt.t1 idx_t1_c2) use_merge(hint.t2, hint.t1)*/ * from opt.t1, hint.t1 where hint.t1.a = opt.t1.c2;
select /*+ index(opt.t1 idx_t1_c2) use_merge(test hint.t2) use_nl(hint.t1)*/ * from opt.t1, hint.t1 where hint.t1.a = opt.t1.c2;
select /*+ index(ta idx_t1_c2) use_merge(test) use_nl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
select /*+ index(ta idx_t1_c2) use_merge(test) use_bnl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
select /*+ index(opt.t1 idx_t1_c2) use_merge(opt.t2) use_nl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
select /*+ index(opt.t1 idx_t1_c2) use_merge(opt.t2) use_bnl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
select /*+ index(opt.t1 idx_test) use_merge(opt.t2) use_nl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
select /*+ index(opt.t1 idx_test) use_merge(opt.t2) use_bnl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
#table tb both in use_merge, use_nl; when tb is right table both MERGE-JON and NL-JOIN path generated.
select /*+ index(opt.t1 idx_test) use_merge(ta tb) use_nl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
#table tb both in use_merge, use_bnl; when tb is right table both MERGE-JON and BNL-JOIN path generated.
select /*+ index(opt.t1 idx_test) use_merge(ta tb) use_bnl(tb)*/ * from opt.t1 as ta, hint.t1 as tb where ta.c1 = tb.a;
#use index more than one, only the first is effective
select * from opt.t1,hint.t1 use index (idx_t1_c2, idx_t1_a) where opt.t1.c1 = hint.t1.a;
select * from opt.t1,hint.t1 use index (idx_t1_a, idx_t1_c2) where opt.t1.c1 = hint.t1.a;
#force index
select * from opt.t1,hint.t1 force index (idx_t1_a, idx_t1_c2) where opt.t1.c1 = hint.t1.a;
select * from opt.t4 force index (idx_t4_c2,idx_t4_c3,idx_t4_c2_c3) where opt.t4.c1 = opt.t4.c2;
#ignore index, all is effective
select * from opt.t4 ignore index (idx_t4_c2,idx_t4_c3,idx_t4_c2_c3) where opt.t4.c1 = opt.t4.c2;
select * from opt.t4 ignore index (idx_t4_c2,idx_t4_c3) where opt.t4.c1 = opt.t4.c2;
select * from opt.t4, hint.t1 ignore index (idx_t4_c2,idx_t4_c3, idx_t1_a) where opt.t4.c1 = hint.t1.a;
select * from opt.t4 as ta, hint.t1 as tb ignore index (idx_t4_c2,idx_t4_c3, idx_t1_a) where ta.c1 = tb.a;
#index not exist, leading hint ineffective @TODO yangze.yz selectivity error
select * from opt.t1 use index(idx_yeti, idx_t1_c2) where opt.t1.c1 = opt.t1.c1;
select * from opt.t4 as ta, hint.t1 as tb ignore index (idx_test, idx_t1_a) where ta.c1 = tb.a;
#subquery
select * from opt.t1 use index(index_t1_c2) where opt.t1.c2 = (select hint.t1.a from hint.t1,opt.t2 use index(idx_t1_a) where opt.t2.c1 = hint.t1.b);
select /*+ idex(yeti idx_t1_c2)*/ * from (select /*+ idex(opt.t4 idx_t4_c2))*/ * from hint.t1, opt.t4 where hint.t1.a = opt.t4.c2) as yeti, opt.t1 where yeti.a = opt.t1.c2;
select /*+ idex(ta idx_t1_c2)*/ * from (select /*+ idex(opt.t4 idx_t4_c2))*/ * from hint.t1, opt.t4 where hint.t1.a = opt.t4.c2) as yeti, opt.t1 as ta where yeti.a = ta.c2;
select /*+ idex(opt.t1 idx_t1_c2)*/ * from (select /*+ idex(opt.t4 idx_t4_c2))*/ * from hint.t1, opt.t4 where hint.t1.a = opt.t4.c2) as yeti, opt.t1 as ta where yeti.a = ta.c2;

#full hint
select /*+ full(opt.t1)*/ * from opt.t1 as ta , opt.t2 as tb where ta.c1 = tb.c1;
select /*+ full(opt.t1 opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c2;
select /*+ full(opt.t1 hint.t2)*/ * from opt.t1, hint.t2 where opt.t1.c1 = hint.t2.b;
select /*+ full(opt.t1) use_merge(ta)*/ * from opt.t1 as ta , opt.t2 as tb where ta.c1 = tb.c1;
select /*+ full(opt.ta) use_merge(ta)*/ * from opt.t1 as ta , opt.t2 as tb where ta.c1 = tb.c1;
select /*+ full(opt.t1 opt.t2) use_merge(opt.t1), use_nl(opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c2;
select /*+ full(opt.t1 opt.t2) use_merge(opt.t1), use_bnl(opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c2;
select /*+ full(opt.t1 hint.t2) use_merge(test), use_nl(opt.t1)*/ * from opt.t1, hint.t2 where opt.t1.c1 = hint.t2.b;
select /*+ full(opt.t1 hint.t2) use_merge(test), use_bnl(opt.t1)*/ * from opt.t1, hint.t2 where opt.t1.c1 = hint.t2.b;

#ordered hint
select /*+ ordered use_merge(ta,tb,tc,td)*/ * from opt.t1 as ta, opt.t2 as tb , hint.t1 as tc, hint.t2 as td where ta.c1 = tc.a and ta.c2 = tb.c1 and tb.c1 = td.b;
select /*+ ordered use_nl(ta tb tc td)*/ * from opt.t1 as ta, opt.t2 as tb , hint.t1 as tc, hint.t2 as td where ta.c1 = tc.a and ta.c2 = tb.c1 and tb.c1 = td.b;
select /*+ ordered use_bnl(ta tb tc td)*/ * from opt.t1 as ta, opt.t2 as tb , hint.t1 as tc, hint.t2 as td where ta.c1 = tc.a and ta.c2 = tb.c1 and tb.c1 = td.b;
#select /*+ ordered use_hash(ta,tb tc td)*/ * from opt.t1 as ta, opt.t2 as tb , hint.t1 as tc, hint.t2 as td where ta.c1 = tc.a and ta.c2 = tb.c1 and tb.c1 = td.b;
select /*+ ordered*/ * from opt.t1 as ta, opt.t2 as tb , hint.t1 as tc, hint.t2 as td where ta.c1 = tc.a and ta.c2 = tb.c1 and tb.c1 = td.b;

#leading hint
select /*+ leading(test, opt.t1 opt.t2) */ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(opt.t1 opt.t1 opt.t2) use_merge(opt.t1), use_nl(opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(opt.t1 opt.t1 opt.t2) use_merge(opt.t1), use_bnl(opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(opt.t1 opt.t2) */ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(opt.t1 opt.t2 ha hb) */ * from opt.t1, opt.t2, hint.t1 as ha, hint.t2 as hb where opt.t1.c1 = opt.t2.c1 and opt.t1.c1 = ha.a and opt.t2.c2 = hb.b;
select /*+ leading(opt.t1 opt.t2 ha hb) use_merge(opt.t1 ha) use_nl(opt.t1 hb)*/ * from opt.t1, opt.t2, hint.t1 as ha, hint.t2 as hb where opt.t1.c1 = opt.t2.c1 and opt.t1.c1 = ha.a and opt.t2.c2 = hb.b;
select /*+ leading(opt.t1 opt.t2 ha hb) use_merge(opt.t1 ha) use_bnl(opt.t1 hb)*/ * from opt.t1, opt.t2, hint.t1 as ha, hint.t2 as hb where opt.t1.c1 = opt.t2.c1 and opt.t1.c1 = ha.a and opt.t2.c2 = hb.b;
select /*+ leading(test, opt.t1 opt.t2) use_merge(test opt.t1 opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(test, opt.t1 opt.t2) use_merge(test opt.t1) use_nl(test opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(test, opt.t1 opt.t2) use_merge(test opt.t1) use_bnl(test opt.t2)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
# duplicate table name, leading hint ineffective
select /*+ leading(opt.t1 opt.t1 opt.t2) use_nl(opt.t1 opt.t3 opt.t5)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(opt.t1 opt.t1 opt.t2) use_bnl(opt.t1 opt.t3 opt.t5)*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
# use_nl():hint syntax error , failed when parser
select /*+ leading(opt.t1 opt.t2) use_nl()*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(opt.t1 opt.t2) use_bnl()*/ * from opt.t1, opt.t2 where opt.t1.c1 = opt.t2.c1;
select /*+ leading(opt.t1 opt.t2 ha hb) use_nl(ta hint.t1 hint.t2 tb)*/ * from opt.t1, opt.t2, hint.t1 as ha, hint.t2 as hb where opt.t1.c1 = opt.t2.c1 and opt.t1.c1 = ha.a and opt.t2.c2 = hb.b;
select /*+ leading(opt.t1 opt.t2 ha hb) use_bnl(ta hint.t1 hint.t2 tb)*/ * from opt.t1, opt.t2, hint.t1 as ha, hint.t2 as hb where opt.t1.c1 = opt.t2.c1 and opt.t1.c1 = ha.a and opt.t2.c2 = hb.b;

#hint with sub-query
select t1.c1, v.c1 from t1, (select t2.c1 from t2, t4) v;
select t1.c1, v.c1 from t1, (select/*+index(t4 primary)*/ t2.c1 from t2, t4) v;
#no rewrite should not influence whether check_and_convert_hint bug:8378105
select/*+no_rewrite*/ t1.c1, v.c1 from t1, (select/*+index(t4 primary)*/ t2.c1 from t2, t4) v;
select t1.c1, v.c1 from t1, (select/*+leading(t2)*/ t2.c1 from t2, t4) v;
select t1.c1, v.c1 from t1, (select/*+read_consistency(weak)*/ t2.c1 from t2, t4) v;
select t1.c1, v.c1 from t1, (select/*+use_nl(t2, t4)*/ t2.c1 from t2, t4 where t2.c1 = t4.c1) v;
(select /*+read_consistency(weak)*/ c1 from t1) union (select c1 from t2);
(select /*+read_consistency(weak)*/ c1 from t1) union (select /*+read_consistency(strong)*/ c1 from t2);

select * from opt.t1 ignore index (primary);
#hint with query-block, for outline generated
#hint qb_name/index
select /*+ index(@a0123456789012345678 t4@a0123456789012345678 idx_t4_c3)*/ * from t1 where c1 in (select/*+qb_name(a0123456789012345678)*/ c1 from t4);
#hint qb_name length larger than MAX_QB_NAME_LENGTH
select /*+ index(@a01234567890123456789 t4@a01234567890123456789 idx_t4_c3)*/ * from t1 where c1 in (select/*+qb_name(a01234567890123456789)*/ c1 from t4);
select /*+ index(@SEL$1 t4  idx_t4_c3)*/ * from t1 where c1 in (select/*+qb_name(yz)*/ c1 from t4);
#hint qb_name/leading
select /*+ leading(@SEL$1 t4  t1)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4) t where t.c1 = t1.c1;
select /*+ leading(@SEL$1 t1  t4)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4) t where t.c1 = t1.c1;
select /*+ leading(@SEL$1 t1@SEL$1  t4@YZ)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4) t where t.c1 = t1.c1;
select /*+ leading(@SEL$1 t4@YZ  t1@SEL$1)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4) t where t.c1 = t1.c1;
#hint qb_name/leading/alias name table_name in hint should be alias name
select /*+ leading(@SEL$1 t_a@YZ  t1@SEL$1)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4 t_a) t where t.c1 = t1.c1;
select /*+ leading(@SEL$1 t4@YZ  t1@SEL$1)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4 t_a) t where t.c1 = t1.c1;
#hint qb_name/leading/use_nl
select /*+ leading(@SEL$1 t4@YZ  t1@SEL$1) use_nl(@SEL$1 t1@SEL$1)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4) t where t.c1 = t1.c1;
#hint qb_name/leading/use_bnl
select /*+ leading(@SEL$1 t4@YZ  t1@SEL$1) use_bnl(@SEL$1 t1@SEL$1)*/ * from t1 , (select/*+qb_name(yz)*/ c1 from t4) t where t.c1 = t1.c1;
#hint qb_name/leading/use_merge
select /*+ leading(@SEL$1 t4@YZ  t1@SEL$1) */ * from t1 , (select/*+qb_name(yz) use_merge(@SEL$1 t1@SEL$1)*/ c1 from t4) t where t.c1 = t1.c1;
#hint with set op
select c1 from t1 union select /*+index(@SEL$1 t1 idx_t1_c2)*/ c1 from t2;
select t1.c1 from t1, t2 where t1.c1 = t2.c1 union select/*+leading(@SEL$1 t1 t2) use_merge(@SEL1 t2@SEL$1)*/ c1 from t2;
#hint with set op 对同一个sub_query指定多个leading失效
select/*+leading(@SEL$1 t2 t1)*/ t1.c1 from t1, t2 where t1.c1 = t2.c1 union select/*+leading(@SEL$1 t1 t2) use_merge(@SEL1 t2@SEL$1)*/ c1 from t2;
(select /*+ leading(@SEL$1 t4@YZ  t1@SEL$1) */ t1.c1 from t1 , (select/*+qb_name(yz) use_merge(@SEL$1 t1@SEL$1)*/ c1 from t4) t where t.c1 = t1.c1) union select c1 from t3;
(select t1.c1 from t1 , (select/*+qb_name(yz)*/ c1 from t4) t where t.c1 = t1.c1) union select/*+leading(@SEL$1 t4@YZ t1@SEL$1) use_merge(@SEL$1 t1@SEL$1)*/ c1 from t3;
#hint subquery in subquery with no rewrite
#no rewrite, can not find t4 in SEL$1
select/*+index(@SEL$1 t4 idx_t4_c2) */t1.c1 from t1 where t1.c1 in (select t4.c1 from t4 group by t4.c2);
select/*+index(@SEL$2 t4 idx_t4_c2) */t1.c1 from t1 where t1.c1 in (select t4.c1 from t4 group by t4.c2);
select/*+index(@SEL$2 t4 idx_t4_c2) */t1.c1 from t1 where t1.c1 in (select/*+index(t4 idx_t4_c3)*/ t4.c1 from t4, (select t5.c1 from t5) t_a where t4.c2 > 1 and t4.c2 < 3 and t_a.c1 = t4.c1 group by t4.c2);
select/*+index(@SEL$2 t4 idx_t4_c2) */t1.c1 from t1 where t1.c1 in (select/*+index(t4 idx_t4_c3)*/ t4.c1 from t4, (select t5.c1 from t5) t_a where t4.c3 > 1 and t4.c3 < 3 and t_a.c1 = t4.c1 group by t4.c2);
select/*+index(@SEL$2 t4 idx_t4_c2) leading(@SEL$2 t5@SEL$3 t4@SEL$2)*/t1.c1 from t1 where t1.c1 in (select t4.c1 from t4, (select t5.c1 from t5) t_a where t_a.c1 = t4.c1 group by t4.c2);
select * from hint.t1 where a in (select * from (select max(t1.a) from hint.t1, hint.t2) as tt);
select   /*+ BEGIN_OUTLINE_DATA USE_NL(@"SEL$3" "hint.t2"@"SEL$3") LEADING(@"SEL$3" "hint.t2"@"SEL$3" "hint.t1"@"SEL$3") END_OUTLINE_DATA */* from hint.t1 where a in (select * from (select max(t1.a) from hint.t1, hint.t2) as tt);
#subquery in subquery
select t1.c1 from t1, (select t2.c1 from t2, (select t3.c1 from t3) t_a where t_a.c1 = t2.c1) t_a1 where t_a1.c1 = t1.c1 and t1.c1 in (select t4.c1 from t4);
select /*+ leading(@SEL$1 t1 t4 t3 t2) index(@SEL$4 t4 idx_t4_c3)*/ t1.c1 from t1, (select t2.c1 from t2, (select t3.c1 from t3) t_a where t_a.c1 = t2.c1) t_a1 where t_a1.c1 = t1.c1 and t1.c1 in (select t4.c1 from t4);
#wrong qb name SEL1 should be SEL$1
select /*+ leading(@SEL1 t1 t4 t3 t2) index(@SEL$4 t4 idx_t4_c3)*/ t1.c1 from t1, (select t2.c1 from t2, (select t3.c1 from t3) t_a where t_a.c1 = t2.c1) t_a1 where t_a1.c1 = t1.c1 and t1.c1 in (select t4.c1 from t4);
select /*+index(@SEL$3 t5@SEL$3 idx_t5_c2) index(@SEL$4 t4 idx_t4_c3)*/ t1.c1 from t1, (select t2.c1 from t2, (select t5.c1 from t5 group by t5.c2) t_a where t_a.c1 = t2.c1) t_a1 where t_a1.c1 = t1.c1 and t1.c1 in (select t4.c1 from t4);
#test index hint
select c2 from t_idx use index(t_c2);
select c120 from t_idx use index (idx_t_idx_c2, idx_t_idx_c3, idx_t_idx_c4, idx_t_idx_c5, idx_t_idx_c6, idx_t_idx_c7, idx_t_idx_c8, idx_t_idx_c9, idx_t_idx_c10, idx_t_idx_c11, idx_t_idx_c12, idx_t_idx_c13, idx_t_idx_c14, idx_t_idx_c15, idx_t_idx_c16, idx_t_idx_c17, idx_t_idx_c18, idx_t_idx_c19, idx_t_idx_c20, idx_t_idx_c21, idx_t_idx_c22, idx_t_idx_c23, idx_t_idx_c24, idx_t_idx_c25, idx_t_idx_c26, idx_t_idx_c27, idx_t_idx_c28, idx_t_idx_c29, idx_t_idx_c30, idx_t_idx_c31, idx_t_idx_c32, idx_t_idx_c33, idx_t_idx_c34, idx_t_idx_c35, idx_t_idx_c36, idx_t_idx_c37, idx_t_idx_c38, idx_t_idx_c39, idx_t_idx_c40, idx_t_idx_c41, idx_t_idx_c42, idx_t_idx_c43, idx_t_idx_c44, idx_t_idx_c45, idx_t_idx_c46, idx_t_idx_c47, idx_t_idx_c48, idx_t_idx_c49, idx_t_idx_c50, idx_t_idx_c51, idx_t_idx_c52, idx_t_idx_c53, idx_t_idx_c54, idx_t_idx_c55, idx_t_idx_c56, idx_t_idx_c57, idx_t_idx_c58, idx_t_idx_c59, idx_t_idx_c60, idx_t_idx_c61, idx_t_idx_c62, idx_t_idx_c63, idx_t_idx_c64, idx_t_idx_c65, idx_t_idx_c66, idx_t_idx_c67, idx_t_idx_c68, idx_t_idx_c69, idx_t_idx_c70, idx_t_idx_c71, idx_t_idx_c72, idx_t_idx_c73, idx_t_idx_c74, idx_t_idx_c75, idx_t_idx_c76, idx_t_idx_c77, idx_t_idx_c78, idx_t_idx_c79, idx_t_idx_c80, idx_t_idx_c81, idx_t_idx_c82, idx_t_idx_c83, idx_t_idx_c84, idx_t_idx_c85, idx_t_idx_c86, idx_t_idx_c87, idx_t_idx_c88, idx_t_idx_c89, idx_t_idx_c90, idx_t_idx_c91, idx_t_idx_c92, idx_t_idx_c93, idx_t_idx_c94, idx_t_idx_c95, idx_t_idx_c96, idx_t_idx_c97, idx_t_idx_c98, idx_t_idx_c99, idx_t_idx_c100, idx_t_idx_c101, idx_t_idx_c102, idx_t_idx_c103, idx_t_idx_c104, idx_t_idx_c105, idx_t_idx_c106, idx_t_idx_c107, idx_t_idx_c108, idx_t_idx_c109, idx_t_idx_c110, idx_t_idx_c111, idx_t_idx_c112, idx_t_idx_c113, idx_t_idx_c114, idx_t_idx_c115, idx_t_idx_c116, idx_t_idx_c117, idx_t_idx_c118, idx_t_idx_c119, idx_t_idx_c120, idx_t_idx_c121, idx_t_idx_c122, idx_t_idx_c123, idx_t_idx_c124, idx_t_idx_c125, idx_t_idx_c126, idx_t_idx_c127, idx_t_idx_c128, idx_t_idx_c129) where c120 = 1;
select c120 from t_idx use index (idx_t_idx_c2, idx_t_idx_c2, idx_t_idx_c3, idx_t_idx_c4, idx_t_idx_c5, idx_t_idx_c6, idx_t_idx_c7, idx_t_idx_c8, idx_t_idx_c9, idx_t_idx_c10, idx_t_idx_c11, idx_t_idx_c12, idx_t_idx_c13, idx_t_idx_c14, idx_t_idx_c15, idx_t_idx_c16, idx_t_idx_c17, idx_t_idx_c18, idx_t_idx_c19, idx_t_idx_c20, idx_t_idx_c21, idx_t_idx_c22, idx_t_idx_c23, idx_t_idx_c24, idx_t_idx_c25, idx_t_idx_c26, idx_t_idx_c27, idx_t_idx_c28, idx_t_idx_c29, idx_t_idx_c30, idx_t_idx_c31, idx_t_idx_c32, idx_t_idx_c33, idx_t_idx_c34, idx_t_idx_c35, idx_t_idx_c36, idx_t_idx_c37, idx_t_idx_c38, idx_t_idx_c39, idx_t_idx_c40, idx_t_idx_c41, idx_t_idx_c42, idx_t_idx_c43, idx_t_idx_c44, idx_t_idx_c45, idx_t_idx_c46, idx_t_idx_c47, idx_t_idx_c48, idx_t_idx_c49, idx_t_idx_c50, idx_t_idx_c51, idx_t_idx_c52, idx_t_idx_c53, idx_t_idx_c54, idx_t_idx_c55, idx_t_idx_c56, idx_t_idx_c57, idx_t_idx_c58, idx_t_idx_c59, idx_t_idx_c60, idx_t_idx_c61, idx_t_idx_c62, idx_t_idx_c63, idx_t_idx_c64, idx_t_idx_c65, idx_t_idx_c66, idx_t_idx_c67, idx_t_idx_c68, idx_t_idx_c69, idx_t_idx_c70, idx_t_idx_c71, idx_t_idx_c72, idx_t_idx_c73, idx_t_idx_c74, idx_t_idx_c75, idx_t_idx_c76, idx_t_idx_c77, idx_t_idx_c78, idx_t_idx_c79, idx_t_idx_c80, idx_t_idx_c81, idx_t_idx_c82, idx_t_idx_c83, idx_t_idx_c84, idx_t_idx_c85, idx_t_idx_c86, idx_t_idx_c87, idx_t_idx_c88, idx_t_idx_c89, idx_t_idx_c90, idx_t_idx_c91, idx_t_idx_c92, idx_t_idx_c93, idx_t_idx_c94, idx_t_idx_c95, idx_t_idx_c96, idx_t_idx_c97, idx_t_idx_c98, idx_t_idx_c99, idx_t_idx_c100, idx_t_idx_c101, idx_t_idx_c102, idx_t_idx_c103, idx_t_idx_c104, idx_t_idx_c105, idx_t_idx_c106, idx_t_idx_c107, idx_t_idx_c108, idx_t_idx_c109, idx_t_idx_c110, idx_t_idx_c111, idx_t_idx_c112, idx_t_idx_c113, idx_t_idx_c114, idx_t_idx_c115, idx_t_idx_c116, idx_t_idx_c117, idx_t_idx_c118, idx_t_idx_c119, idx_t_idx_c120, idx_t_idx_c121, idx_t_idx_c122, idx_t_idx_c123, idx_t_idx_c124, idx_t_idx_c125, idx_t_idx_c126, idx_t_idx_c127, idx_t_idx_c128, idx_t_idx_c129) where c120 = 1;

#use_plan_cache hint not used now,but should not produce error
select /*+use_plan_cache(none)*/ * from hint.t1;
select /*+use_plan_cache(meaningless)*/ * from hint.t1;
select /*+ index(t1 primary) */ * from hint.t1 order by a desc;
#bug 8477262
select min(a) from z1 za where za.a in (select a from z1);
select /*+ INDEX(@SEL$3 opt.z1@SEL$2 z1_b)*/ min(a) from z1 za where za.a in (select a from z1);
#bug 8408303(ignore key influence index hint);
#repair: /*+index(t i)*/ hint will ignore IGNORE HINT
select /*+index(z1 z1_b)*/ * from z1 ignore key(a);
select /*+index(z1 z1_b)*/ * from z1 ignore key(z1_b);
select /*+use_hash(t1,t2) no_use_hash_aggregation*/* from t1 left join t2 using(c2) group by t1.c2 order by t1.c2;
select /*+use_hash(t1,t2) no_use_hash_aggregation*/* from t1 left join t2 using(c2) group by t1.c2 order by t2.c3 limit 3;
select /*+ use_bnl(hint.t2, opt.t1)*/ * from hint.t2, opt.t1 where opt.t1.c2 = hint.t2.a;
# test view merge
select /*+ leading (b a) */ distinct * from hint_t1 a, hint_v1 b;
# test limit push
select /*+read_consistency(weak)*/ * from (select distinct * from hint_t1) as a limit 5;
