// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for BlueprintCustomizationsPartitioningMode.
const (
	BlueprintCustomizationsPartitioningModeAutoLvm BlueprintCustomizationsPartitioningMode = "auto-lvm"

	BlueprintCustomizationsPartitioningModeLvm BlueprintCustomizationsPartitioningMode = "lvm"

	BlueprintCustomizationsPartitioningModeRaw BlueprintCustomizationsPartitioningMode = "raw"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for CustomizationsPartitioningMode.
const (
	CustomizationsPartitioningModeAutoLvm CustomizationsPartitioningMode = "auto-lvm"

	CustomizationsPartitioningModeLvm CustomizationsPartitioningMode = "lvm"

	CustomizationsPartitioningModeRaw CustomizationsPartitioningMode = "raw"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureEap7Rhui ImageTypes = "azure-eap7-rhui"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesAzureSapRhui ImageTypes = "azure-sap-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotBootableContainer ImageTypes = "iot-bootable-container"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesIotSimplifiedInstaller ImageTypes = "iot-simplified-installer"

	ImageTypesLiveInstaller ImageTypes = "live-installer"

	ImageTypesMinimalRaw ImageTypes = "minimal-raw"

	ImageTypesOci ImageTypes = "oci"

	ImageTypesVsphere ImageTypes = "vsphere"

	ImageTypesVsphereOva ImageTypes = "vsphere-ova"

	ImageTypesWsl ImageTypes = "wsl"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"

	UploadTypesOciObjectstorage UploadTypes = "oci.objectstorage"

	UploadTypesPulpOstree UploadTypes = "pulp.ostree"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// Blueprint defines model for Blueprint.
type Blueprint struct {
	// Container images to embed into the final artfact
	Containers     *[]Container             `json:"containers,omitempty"`
	Customizations *BlueprintCustomizations `json:"customizations,omitempty"`
	Description    *string                  `json:"description,omitempty"`

	// The distribution to use for the compose. If left empty the host
	// distro will be used.
	Distro *string `json:"distro,omitempty"`

	// Package groups to be installed
	Groups *[]PackageGroup `json:"groups,omitempty"`

	// An alias for packages, retained for backwards compatability
	Modules *[]Package `json:"modules,omitempty"`
	Name    string     `json:"name"`

	// Packages to be installed
	Packages *[]Package `json:"packages,omitempty"`

	// A semver version number
	Version *string `json:"version,omitempty"`
}

// BlueprintCustomizations defines model for BlueprintCustomizations.
type BlueprintCustomizations struct {
	// Directories to create in the final artifact
	Directories *[]Directory `json:"directories,omitempty"`

	// FIDO device onboard configuration
	Fdo *FDO `json:"fdo,omitempty"`

	// Files to create in the final artifact
	Files *[]BlueprintFile `json:"files,omitempty"`

	// List of filesystem mountpoints to create
	Filesystem *[]BlueprintFilesystem `json:"filesystem,omitempty"`

	// Enable FIPS mode
	Fips *bool `json:"fips,omitempty"`

	// Firewalld configuration
	Firewall *BlueprintFirewall `json:"firewall,omitempty"`

	// List of groups to create
	Group *[]Group `json:"group,omitempty"`

	// Configures the hostname
	Hostname *string `json:"hostname,omitempty"`

	// Ignition configuration
	Ignition *Ignition `json:"ignition,omitempty"`

	// Name of the installation device, currently only useful for the edge-simplified-installer type
	InstallationDevice *string `json:"installation_device,omitempty"`
	Kernel             *Kernel `json:"kernel,omitempty"`

	// Locale configuration
	Locale   *Locale            `json:"locale,omitempty"`
	Openscap *BlueprintOpenSCAP `json:"openscap,omitempty"`

	// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
	// there are one or more mountpoints in which case it will use LVM. 'lvm' always
	// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
	// even when there are one or more mountpoints.
	PartitioningMode *BlueprintCustomizationsPartitioningMode `json:"partitioning_mode,omitempty"`

	// Repositories to write to /etc/yum.repos.d/ in the final image. Note
	// that these are not used at build time.
	Repositories *[]BlueprintRepository `json:"repositories,omitempty"`
	Services     *Services              `json:"services,omitempty"`

	// List of ssh keys
	Sshkey *[]SSHKey `json:"sshkey,omitempty"`

	// Timezone configuration
	Timezone *Timezone `json:"timezone,omitempty"`

	// List of users to create
	User *[]BlueprintUser `json:"user,omitempty"`
}

// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
// there are one or more mountpoints in which case it will use LVM. 'lvm' always
// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
// even when there are one or more mountpoints.
type BlueprintCustomizationsPartitioningMode string

// A custom file to create in the final artifact.
type BlueprintFile struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// BlueprintFilesystem defines model for BlueprintFilesystem.
type BlueprintFilesystem struct {
	// size of the filesystem in bytes
	Minsize    uint64 `json:"minsize"`
	Mountpoint string `json:"mountpoint"`
}

// Firewalld configuration
type BlueprintFirewall struct {
	// List of ports (or port ranges) and protocols to open
	Ports *[]string `json:"ports,omitempty"`

	// Firewalld services to enable or disable
	Services *FirewallServices `json:"services,omitempty"`
	Zones    *[]FirewallZones  `json:"zones,omitempty"`
}

// BlueprintOpenSCAP defines model for BlueprintOpenSCAP.
type BlueprintOpenSCAP struct {
	Datastream *string            `json:"datastream,omitempty"`
	ProfileId  string             `json:"profile_id"`
	Tailoring  *OpenSCAPTailoring `json:"tailoring,omitempty"`
}

// BlueprintRepository defines model for BlueprintRepository.
type BlueprintRepository struct {
	Baseurls   *[]string `json:"baseurls,omitempty"`
	Enabled    *bool     `json:"enabled,omitempty"`
	Filename   *string   `json:"filename,omitempty"`
	Gpgcheck   *bool     `json:"gpgcheck,omitempty"`
	Gpgkeys    *[]string `json:"gpgkeys,omitempty"`
	Id         string    `json:"id"`
	Metalink   *string   `json:"metalink,omitempty"`
	Mirrorlist *string   `json:"mirrorlist,omitempty"`

	// Disables modularity filtering for this repository.
	ModuleHotfixes *bool   `json:"module_hotfixes,omitempty"`
	Name           *string `json:"name,omitempty"`
	Priority       *int    `json:"priority,omitempty"`
	RepoGpgcheck   *bool   `json:"repo_gpgcheck,omitempty"`
	Sslverify      *bool   `json:"sslverify,omitempty"`
}

// BlueprintUser defines model for BlueprintUser.
type BlueprintUser struct {
	Description *string `json:"description,omitempty"`

	// Group id to use instead of the default
	Gid *int `json:"gid,omitempty"`

	// A list of additional groups to add the user to
	Groups *[]string `json:"groups,omitempty"`

	// The user's home directory
	Home *string `json:"home,omitempty"`

	// ssh public key
	Key  *string `json:"key,omitempty"`
	Name string  `json:"name"`

	// If the password starts with $6$, $5$, or $2b$ it will be stored as
	// an encrypted password. Otherwise it will be treated as a plain text
	// password.
	Password *string `json:"password,omitempty"`

	// Login shell to use
	Shell *string `json:"shell,omitempty"`

	// User id to use instead of the default
	Uid *int `json:"uid,omitempty"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Blueprint      *Blueprint      `json:"blueprint,omitempty"`
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name *string `json:"name,omitempty"`

	// Reference to the container to embed
	Source string `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// CustomRepository defines model for CustomRepository.
type CustomRepository struct {
	Baseurl        *[]string `json:"baseurl,omitempty"`
	CheckGpg       *bool     `json:"check_gpg,omitempty"`
	CheckRepoGpg   *bool     `json:"check_repo_gpg,omitempty"`
	Enabled        *bool     `json:"enabled,omitempty"`
	Filename       *string   `json:"filename,omitempty"`
	Gpgkey         *[]string `json:"gpgkey,omitempty"`
	Id             string    `json:"id"`
	Metalink       *string   `json:"metalink,omitempty"`
	Mirrorlist     *string   `json:"mirrorlist,omitempty"`
	ModuleHotfixes *bool     `json:"module_hotfixes,omitempty"`
	Name           *string   `json:"name,omitempty"`
	Priority       *int      `json:"priority,omitempty"`
	SslVerify      *bool     `json:"ssl_verify,omitempty"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Containers *[]Container `json:"containers,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will be used to depsolve and retrieve packages. Additionally,
	// these packages will be saved and imported to the `/etc/yum.repos.d/` directory
	// on the image
	CustomRepositories *[]CustomRepository `json:"custom_repositories,omitempty"`
	Directories        *[]Directory        `json:"directories,omitempty"`

	// FIDO device onboard configuration
	Fdo        *FDO          `json:"fdo,omitempty"`
	Files      *[]File       `json:"files,omitempty"`
	Filesystem *[]Filesystem `json:"filesystem,omitempty"`

	// System FIPS mode setup
	Fips *FIPS `json:"fips,omitempty"`

	// Firewalld configuration
	Firewall *FirewallCustomization `json:"firewall,omitempty"`

	// List of groups to create
	Groups *[]Group `json:"groups,omitempty"`

	// Configures the hostname
	Hostname *string `json:"hostname,omitempty"`

	// Ignition configuration
	Ignition *Ignition `json:"ignition,omitempty"`

	// Name of the installation device, currently only useful for the edge-simplified-installer type
	InstallationDevice *string `json:"installation_device,omitempty"`
	Kernel             *Kernel `json:"kernel,omitempty"`

	// Locale configuration
	Locale   *Locale   `json:"locale,omitempty"`
	Openscap *OpenSCAP `json:"openscap,omitempty"`
	Packages *[]string `json:"packages,omitempty"`

	// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
	// there are one or more mountpoints in which case it will use LVM. 'lvm' always
	// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
	// even when there are one or more mountpoints.
	PartitioningMode *CustomizationsPartitioningMode `json:"partitioning_mode,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Services            *Services     `json:"services,omitempty"`
	Subscription        *Subscription `json:"subscription,omitempty"`

	// Timezone configuration
	Timezone *Timezone `json:"timezone,omitempty"`
	Users    *[]User   `json:"users,omitempty"`
}

// Select how the disk image will be partitioned. 'auto-lvm' will use raw unless
// there are one or more mountpoints in which case it will use LVM. 'lvm' always
// uses LVM, even when there are no extra mountpoints. 'raw' uses raw partitions
// even when there are one or more mountpoints.
type CustomizationsPartitioningMode string

// A custom directory to create in the final artifact.
type Directory struct {
	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the directory as a group name or a gid
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the directory in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the directory
	Path string `json:"path"`

	// Owner of the directory as a user name or a uid
	User *interface{} `json:"user,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// FIDO device onboard configuration
type FDO struct {
	DiMfgStringTypeMacIface *string `json:"di_mfg_string_type_mac_iface,omitempty"`
	DiunPubKeyHash          *string `json:"diun_pub_key_hash,omitempty"`
	DiunPubKeyInsecure      *string `json:"diun_pub_key_insecure,omitempty"`
	DiunPubKeyRootCerts     *string `json:"diun_pub_key_root_certs,omitempty"`
	ManufacturingServerUrl  *string `json:"manufacturing_server_url,omitempty"`
}

// System FIPS mode setup
type FIPS struct {
	// Enables the system FIPS mode
	Enabled *bool `json:"enabled,omitempty"`
}

// A custom file to create in the final artifact.
type File struct {
	// Contents of the file as plain text
	Data *string `json:"data,omitempty"`

	// Ensure that the parent directories exist
	EnsureParents *bool `json:"ensure_parents,omitempty"`

	// Group of the file as a gid or a group name
	Group *interface{} `json:"group,omitempty"`

	// Permissions string for the file in octal format
	Mode *string `json:"mode,omitempty"`

	// Path to the file
	Path string `json:"path"`

	// Owner of the file as a uid or a user name
	User *interface{} `json:"user,omitempty"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	// size of the filesystem in bytes
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// Firewalld configuration
type FirewallCustomization struct {
	// List of ports (or port ranges) and protocols to open
	Ports *[]string `json:"ports,omitempty"`

	// Firewalld services to enable or disable
	Services *FirewallServices `json:"services,omitempty"`
}

// Firewalld services to enable or disable
type FirewallServices struct {
	// List of services to disable
	Disabled *[]string `json:"disabled,omitempty"`

	// List of services to enable
	Enabled *[]string `json:"enabled,omitempty"`
}

// Bind a list of network sources to a zone to restrict traffic from
// those sources based on the settings of the zone.
type FirewallZones struct {
	// name of the zone, if left empty the sources will apply to
	// the default zone.
	Name *string `json:"name,omitempty"`

	// List of sources for the zone
	Sources *[]string `json:"sources,omitempty"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// Group defines model for Group.
type Group struct {
	// Group id of the group to create (optional)
	Gid *int `json:"gid,omitempty"`

	// Name of the group to create
	Name string `json:"name"`
}

// Ignition configuration
type Ignition struct {
	Embedded  *IgnitionEmbedded  `json:"embedded,omitempty"`
	Firstboot *IgnitionFirstboot `json:"firstboot,omitempty"`
}

// IgnitionEmbedded defines model for IgnitionEmbedded.
type IgnitionEmbedded struct {
	Config string `json:"config"`
}

// IgnitionFirstboot defines model for IgnitionFirstboot.
type IgnitionFirstboot struct {
	// Provisioning URL
	Url string `json:"url"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// Size of image, in bytes. When set to 0 the image size is a minimum
	// defined by the image type.
	Size *uint64 `json:"size,omitempty"`

	// Options for a given upload destination.
	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`

	// The type and options for multiple upload targets. Each item defines
	// a separate upload destination with its own options. Multiple
	// different targets as well as multiple targets of the same kind are
	// supported.
	UploadTargets *[]UploadTarget `json:"upload_targets,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error          *ComposeStatusError `json:"error,omitempty"`
	Status         ImageStatusValue    `json:"status"`
	UploadStatus   *UploadStatus       `json:"upload_status,omitempty"`
	UploadStatuses *[]UploadStatus     `json:"upload_statuses,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Kernel defines model for Kernel.
type Kernel struct {
	// Appends arguments to the bootloader kernel command line
	Append *string `json:"append,omitempty"`

	// Name of the kernel to use
	Name *string `json:"name,omitempty"`
}

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// LocalUploadOptions defines model for LocalUploadOptions.
type LocalUploadOptions struct {
	// This is used in combination with the OSBUILD_LOCALSAVE environmental
	// variable on the server to enable saving the compose locally. This
	// is for development use only, and is not available to users.
	LocalSave bool `json:"local_save"`
}

// Locale configuration
type Locale struct {
	// Sets the keyboard layout
	Keyboard *string `json:"keyboard,omitempty"`

	// List of locales to be installed, the first one becomes primary, subsequent ones are secondary
	Languages *[]string `json:"languages,omitempty"`
}

// OCIUploadOptions defines model for OCIUploadOptions.
type OCIUploadOptions map[string]interface{}

// OCIUploadStatus defines model for OCIUploadStatus.
type OCIUploadStatus struct {
	Url string `json:"url"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// A URL which, if set, is used for fetching content. Implies that `url` is set as well,
	// which will be used for metadata only.
	Contenturl *string `json:"contenturl,omitempty"`

	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`

	// Determines whether a valid subscription manager (candlepin) identity is required to
	// access this repository. Consumer certificates will be used as client certificates when
	// fetching metadata and content.
	Rhsm *bool   `json:"rhsm,omitempty"`
	Url  *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// OpenSCAP defines model for OpenSCAP.
type OpenSCAP struct {
	ProfileId string             `json:"profile_id"`
	Tailoring *OpenSCAPTailoring `json:"tailoring,omitempty"`
}

// OpenSCAPTailoring defines model for OpenSCAPTailoring.
type OpenSCAPTailoring struct {
	Selected   *[]string `json:"selected,omitempty"`
	Unselected *[]string `json:"unselected,omitempty"`
}

// Package defines model for Package.
type Package struct {
	// Name of the package to install. File globbing is supported,
	// eg. 'openssh-*'
	Name string `json:"name"`

	// Optional version of the package to install. If left blank the
	// latest available version will be used. Wildcards are supported
	// eg. '4.11.*'
	Version *string `json:"version,omitempty"`
}

// PackageGroup defines model for PackageGroup.
type PackageGroup struct {
	// Package group name
	Name string `json:"name"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// PulpOSTreeUploadOptions defines model for PulpOSTreeUploadOptions.
type PulpOSTreeUploadOptions struct {
	// Basepath for distributing the repository
	Basepath string `json:"basepath"`

	// Repository to import the ostree commit to
	Repository    *string `json:"repository,omitempty"`
	ServerAddress *string `json:"server_address,omitempty"`
}

// PulpOSTreeUploadStatus defines model for PulpOSTreeUploadStatus.
type PulpOSTreeUploadStatus struct {
	RepoUrl string `json:"repo_url"`
}

// Repository configuration.
// At least one of the 'baseurl', 'mirrorlist', 'metalink' properties must
// be specified. If more of them are specified, the order of precedence is
// the same as listed above.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// Enables gpg verification of the repository metadata
	CheckRepoGpg *bool `json:"check_repo_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Disables modularity filtering for this repository.
	ModuleHotfixes *bool `json:"module_hotfixes,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// SSHKey defines model for SSHKey.
type SSHKey struct {
	// Adds the key to the user's authorized_keys file
	Key string `json:"key"`

	// User to configure the ssh key for
	User string `json:"user"`
}

// Services defines model for Services.
type Services struct {
	// List of services to disable by default
	Disabled *[]string `json:"disabled,omitempty"`

	// List of services to enable by default
	Enabled *[]string `json:"enabled,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`

	// Optional flag to use rhc to register the system, which also always enables Insights.
	Rhc       *bool  `json:"rhc,omitempty"`
	ServerUrl string `json:"server_url"`
}

// Timezone configuration
type Timezone struct {
	// List of ntp servers
	Ntpservers *[]string `json:"ntpservers,omitempty"`

	// Name of the timezone, defaults to UTC
	Timezone *string `json:"timezone,omitempty"`
}

// Options for a given upload destination.
// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTarget defines model for UploadTarget.
type UploadTarget struct {
	Type UploadTypes `json:"type"`

	// Options for a given upload destination.
	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions UploadOptions `json:"upload_options"`
}

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9eXPbOJb4V0Fpuyrdv+g+bDlVXbuyfMm3LdmOPUp5IBIiYZEAA4CS5d5891/hIEVK",
	"1JW4e3pmM39MxyKOhwe8h3fjj5xF/YASRATPffojF0AGfSQQM385SP7XRtxiOBCYktyn3DV0EMDERq+5",
	"fA69Qj/wUKr5GHohyn3KVXLfvuVzWPb5GiI2zeVzBPryi2qZz3HLRT6UXcQ0kL9zwTBxVDeO3zLmvgz9",
	"AWKADgEWyOcAE4Cg5QIzYBKaaIAYmnJ5KTyq7Sp4vkUf1dCth+5hu9r2KEFtiT6uJoK2jSWY0LtmNEBM",
	"YAnIEHoc5XNB4qc/cgw5aj0LE+Vz3IUMPU+wcJ+hZdHQbIxZWe7TP3KVaq3e2Nlt7pUr1dyXfE5hInMs",
	"8wNkDE7V2hn6GmKGbDmMgeFL3IwOXpAlZD+9vrvAo9C+Uqjn373AGPAcCgsTxEWhksv/lcvO5ziBAXep",
	"eNa7nYTJnxair4tQZSMsG9Z1aOwKKEJNJSlEQR+nIYI+LpStZq28u1fb3W009hp2fZCFsS1RPLcYOW9+",
	"zRno1n7kCAThwMOWJuEhDD0Rt0uTdGcIOBJAUKA+g1+Fi4DpAhTx/pYHEHiUOHlAB8OQW1AgG9zdnvcJ",
	"5oAhETKC7CLoCA7Qa4AZlEMDHzuuAAMEOKUEMSBcSMCQMkCFixgI1dr6REDmIMGLfdInM1gEC5GclruU",
	"CcTkbCAxGYDE7hOcnhBzIGHn0EcAcjWV/Ds5HZjNNtuiAaUeguTHN3Wz7Vx2FEPmZbPi5BSyUeb4byFD",
	"P3JcsA8dFFPoHNeXGKVDhU2NR2QD1UFuOvBDrvY5JPhrKK8m1dDBY0QAQ5yGzELAYTQMimqL5SRys6iP",
	"hTxJQ0Z91UUuFHEh951BYlMfUILAAHJkA0oABHd3nQOAeZ84iCAmj6HeyBRDUYBlUaxHLSjM9qYXeG6+",
	"RIsMGB1jucgI/GcFfh5MXMSQaqJmkccz9Gy1+AgvkMhuDuYCMQXfCZ3IE+1hLgD0PBCBwT/1iStEwD+V",
	"Sja1eNHHFqOcDkXRon4JkULIS5aHS1Dubcmwuv8eYzT5Xf1UsDxc8KBAXPwXfIt44bOc6Dme5INCuYQ4",
	"+kminlABeIAsPMTIzgMs5I82skMrtSFL8DCPdEkeKJTHKZtRJvuuPl3p47IBuudB6dHQguTWDHOsZsy6",
	"7sJBDMIztheB6hxIkJLNvgOYOmrYzUHVKsBBtV6o1yu1wl7ZahR2KtVaeQc1y3uomgWdQAQSsQIuCYRu",
	"tBlU5ggOMbHVXmsKVTwDXFMmoLfJWYzOocBjVLAxQ5agbFoahsSGPiICenzha8Glk4KgBTl1QYM8h6SG",
	"tYuGjcFOoWLVhoW6DcsFuFOtFsqD8k65Wtuzd+3dtZx3hrHFvV04gWv45zL+nOaQm7CcOSATA2SBsO+F",
	"KGCYiC05t0WJgJgYnSF9XNrRN306uDwFyB9I9k3kLesieSigByATQ2hJISyW635haJj7lPuv0kxFKRkh",
	"vBSPmyXvWSEX1MdvML6HVg0VL7ud7vZtTlDJEDRtzAWji6vuSQlGfsODUJGuoCDkKJYILK00FEFnCDw0",
	"FAD5gZiqTy7lok/0wGCCPU9REl+k7SGyKYOF2l4WAatzxrNUN2skiVR/l2AN5H3JBfQ8ZG+KfDOKZm4Z",
	"+PepHRolLD19iwDoYSMaBXoUnpdCldxLW/08gNZoApnNFZaggAPsYTFVq98GuizAItpZwFcEy1KM/Siu",
	"sqAZI8YzpYEW4MgfIwZMC0CU1pva/t3ibnG3vJbk1xN7e4FYtiD9iM3iLNQdzD5K7FkMQRFLZzHV423I",
	"PhpymoXPoU3X9T86uFItcebxPJI/vxeoMYLlqJngytmmXCA/Qx6Ushodglkb4EvZKqCYiASI3wWMmTQT",
	"pCymcUjgwEPgqHPdBT61UabiMsQMTaDnbQGJ6RCxq+VYmHGr7Va9lEFJJputabQpGWInZIjH3Fg1zOCx",
	"2CE4uhlWQdGJ2inbk2IfitaebTTG1hptJ9kB6A55YIWMISK8KaDEm8rbYRh68eWCbAcVOPYDTwnXhYhl",
	"MSCXMHeLlGw0LnEbZi1whBhBazf0TLcy6o2H1rU/162+5XM0QIRbMNj4yFwFiHTbrWvNsZlQaMXEeVan",
	"MmloyMFQ0II39nPz1oYu8pAlgCsFUn1Lj4zgGl228cjILoIP0UAf9Hd5izM4ASHxEOd9IpT0CxlSmiJl",
	"wKcMpWgVS8EdWy6wIEdS+I3HOb+/KIIPamzoTeCU90nIEZe/5wGSyuvERYoFmSkIBehVMJgcvwg+MDj5",
	"AFRPCVkMPu+TrEGWwGnECxL6ypAAJ7l8TuMvRuWXTN0qoBwvuwFuE18l+U4YFkj+o4SEVZqGflH1L9ql",
	"NK81qv0lFUiiGAr5jUdIEEoeAlCAQYg9Gwjso+Lm8kF8nGLoMm8TjpiktrXDdaN2sg93R2i6nJFx7oIR",
	"mvJNQe12T85QJnRyzW+UrKW2XtTuWz4XcsSWwya//sjNcsezhPFvq0QPdTNmSD9afleX37rbWO/7nFAC",
	"BczWRCTkEWdVo0MOAg/KkdGrWCpILw6mbpb5kSBwsC1pCxrrgbk5ZtyWUWVmpgRdDXOf/rEoiMa/YCKQ",
	"IxH6RcvTWW4YxHzMpXzIgR4gvgIURJgAagmoLgYfihQg5Z16PWu5ARRulgwsXBBra156TYqU/an5fWHE",
	"7EN3NSHai5PGXxjhT/Z6J/TNCcRqhV/WncqZXJY+Wj4m2X4p+WtyPUZowwQMpgLx5DKqlfpuvVnbqTfz",
	"udeCQwsGlBATsVPX+lPEltOKfmkM2VqJP9E5H8O7ZsEz0W2l7D8vLetuNrCM0KSNmwt+AMoEX8531Gfw",
	"q1QIKROAQeIg/puyYgaMCmpRT7ElKS0k0fiPXLX6SVhBLp9rls0/sA8D9c/t3EMbcvpowUmOL3mrNs5s",
	"wiyjEZ5Ur+2YZSz8LBxKye+4YAj62boto/JEGmveIjYg9qj6Yw3wEQC9uMMCbc1mWnngEhfvwmIGkKOQ",
	"eWmczkggshFaNikyZLtQ2wctzdxLNuaixFzkNUvN0mtz53mnXpIjUl6ivJTL5wwv/JQLGc60fM6dDaR0",
	"nyTmUjqPh5aaFJzAsVxkjbK7OoGjBIHkKtcCs2QHfSSgh8koG1M+ZowyXtT2ooBRuR1FypxS1O+/pRD2",
	"e2RPqvbDcrm6A5nl/q4xuAHa9CQe5mIRiBgG+bloISIoV/P/N0Meghz93izo45uYGcr/36nrXxR8+5Cj",
	"q+4msCjr07NLxRC/ZtsluNxUDlRLyLCYSp4tUOIOVa6+6JQuc9YtNycxTOWwiY/xjaRl5ufVx4Nzb4wY",
	"Hk6zPs9bdddQ2525gbcx66yxezpZngEtE2E7MnZKvRNBO7oVI90sn4GRZebKlnZa0SGYAZ+wBkDb1i5B",
	"KS0ImhRZZ0dQNa9sQusuzbII9MwEHziQDUDsWchWmTOkfyn1a2e4FP5TEg3nbgHZ1UajsgdarVarXbt8",
	"g+2K93TQqVz2Dhvyt84lOz47ZBeP+OPFxd0kPIG3rVP/9px23m6H1a8HVfug8Vbe772Wdl6zYFp0GMjl",
	"VLLFP84nlGW5fYxf0jQAXEB5bU+wcMEvO7/kwS+NX/JSdvulOvgl1nIHCHBBmVTWeJ9AAhCx2DQQyI5H",
	"KoIrqZtOcEI5HiAglMxva7FwJqL3SdwvSZPJMBKkBZl5/6qDCVAfzfHMlFWzjrUkn+851ZsaYpNRRPvU",
	"VudnJuGuupAzopCUupD85RbxgBITn+R5G4x6pSC7RUPEELGQkqrn/FB2+jhVqjVUb+zsFlBzb1CoVO1a",
	"AdYbO4V6dWen0ajXy+VyOcW3Q+UUW+OryuJq8epmLrLvX9Sq9ilHnJ5W47Nj/wdhUi/pnDr8XRelvIzK",
	"NJMp3xgQ0sqPJBs2hBb641sWax7RF7zWEElfsFpLttvTALQSFReQ4CHi4l3x4ScH/XFkzKt78eirV4YE",
	"jOwi77UwKqU29GxR38ciM1LgVxdy97eIV8odEMA0z3+HE05LA5hYXmhLUe3y8P62taUjLkbEBtpXAn+3",
	"OjJorRxFqNDhj7MdmvNG53OD2M/+5du85DVI+uA3srtt7/DO8HMnfNVpjiR1qUIz0/2hqIrN8LLSByIb",
	"Rzic77y5/jw/zPeyiQUqSiEgse3vcc9kcUcej7t2udEllE91RVsibTZKFs42hEeibjbQZn1SiLxXodjz",
	"yDcDpRe4mp3p4Q6lVplhD0ECYmVBmNeZU0oY5JnazeLtGTdeAECvRxKM8Zvw0LIQl2sZQuyFTIqZASKS",
	"W8kFJQT/uOECYc1CWxZWtiI6ciHCJIq7iWPploYl6tikLO+NOcaR7Xc2aBTFkzbPqqBDNi2an5RlRs36",
	"SUAnUwPz+PNMz1201zPqgd55F6g2eIityMIYT6rCdNdpyGaBmdJ3tKQfCV1dsS3xfhh9xkrHQ815YylX",
	"UkomqqCToZtCZ8sZdLRmpsy4DjcJXrhNgIhjrod5G4z8PZIMIiFmIcZ3thhKTHymPmPZ2p+JYJ6zU98c",
	"XGYHD8/h5msIp0VMS/7URLKWzH58WoG1+djofLTkzNOmbt4NzJ9/E+unslA9O4GTbaXSnyNzVnabHzKg",
	"GnPKTwvpn24hfTfjJufe84+aLn8oJC0djfpewaTPqwMdDlVYRrJNKsRxFuoOMAFpab0Iei7iqE9SvZOR",
	"n/K2tVHAqTdGJrpfMIzGKB6/CFoxgrxpXoWl8NnnmTEOjk2CAPYDyoQeWzLGfy5EZPxzZunsE8N9Z1xz",
	"M7zOs7sM9M5FEP5LogA39N1tEsa38VDrg/BWjtC57m4TdRc5HlOUtcry/rcKvUuGuv+MyPsbROSlA/Fm",
	"VpuEcz6gXDgM8e1c8T+j+v4WUX0BnEo5+V9y6SkC2vjm65OIyK66AAuOvKFKIJ3qwQhViYFwDLGngpij",
	"1jpykFEqAGV9AsnUpGlKRCcNlioKRarqvymYo4mfORIcDDHy7GjMheVgDrBDKItyNzZinH9CUGIiHWlt",
	"v2TbHwgz3Pxa3TxscHbrLw8ZjEWW74kbRISHDD0HkEXVEFYnLh+q9iCKTwW6I0hINAC94qTemAwA2SCw",
	"cLYaHV0YBxWaIENs/0uiC2dgrQwx3G00vi/EMOlhX4gztDH7zjDDOWzGIYYm4vA9kLlprGFsuHwvq7Jl",
	"9nAxQy1pC5U9YCLjNCOaezOjqKWzQEzzuYGzDbdqyedG/d1s2ap1hgU9Yisb8ReN6nVeND1UNuRSW9gy",
	"MrJzcGVEQ0DJgEK2LkbSxs/+0HnW6H6WQDz70HqWrGrJvuKQPAfh4HmEps8u5O76VphwZIVsg/Hk2X+2",
	"kAnbXDQfQBJKHhoqYOWVhNjz0uIBC4df6S7bIbSro2njDCTAkVB51fMMPLY1rePcOgBMVWuYGzuXaU5e",
	"XMXfP3b9T7zP1tjff8bN/9+Jm18TLv/87xYv/7w0YD7biPIzaH7LoPlvK1DbTYz6XViNwFIeSp23Shmw",
	"dcRvxrXLEzdGZsZWYrzZKAl8CuQRJLbDXeqeWjerbpyedCjkxhERbFn+aynen6I0hi2Qvo+JDWAcoUuQ",
	"mFA2AtrZquNzgdQJ5b8YklBZAggGh0NsKa90nwiXchT3iOvsqGsZCYGJE195cqSsCzPblkgSBjvZMw/w",
	"QqWFaFplKIBB4EmlUdl+4upTs0mXOM1XkGg0fHS3KPU4sVvpXv2wXK5Zuo/6N/pHSf/mQz7Sv3z5X/3L",
	"Rautf/hfHHAkPulf1b/17+tde1ln4bh9/SNO8EFojZBYbjuFREsP8r7t9lqXB63bA9AVlEEHAcuDnIN9",
	"NURxvp6S+aNgZlgai5R9FHou0mreXIRE7AGRTFNVdLNBm/pBKBA4JA4mxt1R7JNeXNxGDTRXbmqChWvk",
	"u+P2NTD+w7yxD2KuLFlpO5UayxQEm3ljVDmQVGGkuA5Vn3wwNUNYAQa4oLc8DLGtd/xDJMmY6aRYIFJQ",
	"b1OnalaEbBGVcon6e6LyT7ymyNqadC8l8Cup3uBTFXaLUQnl39hWo0dlooqgixCIXd4eDe2iQ6ljAku4",
	"PjqqWlAprjZlCnylq0upEIPQE7hgII8rUVke5YiLSEgz9Ed+NUWgouOpD2bc7TeJZkvyLgJgKKgPBbag",
	"503nkYzCLUodZrMRgxe1bhA1l/CqUdInOev4quNZ7JNDaLnRIVFYN35SAGNMxYKlmUZ5J4rgXkGghWEO",
	"IEOf+gSAAvgghc1PfyAfYg/b3z58Ai0C1F8A2jZDnGtVgqGAIa7Ul3guSw4B5pZVBEeUAYO9PPgAPWyh",
	"/0kEE30ompnN/djS/baEQU9thlg2tz8tKHtwAQbB/8Ag4AEVRcd0ivokQVKay7bYMOuPappJuOZQYPuY",
	"8Ewc2NSHmHz6Q/9XTqjIE3RDLBDQv4JfA4Z9yKa/LU7ueXrCKIHG3LRQmL7zGJmR3gcpUn2Ygymb6lYf",
	"zagOnGYOKpcEkmmfRPjtz8mu6sAtnIpcLIxG52HTzcsZPfXTIppz+ZxBcPLHP6XYanzvvl/dL3U3y/Gf",
	"5zMMILcQsSERhQGD2C7UyrVGpbZWSUoMl19XRuw4Uv23EB5WJ5QZtqSNAzOjyq800MP/lplUtr6U5NyA",
	"319MqZNwPG8hQUfd1uiCKtLS1vrCJm7tw6i9DhDgYkCp2LTzUdwhU0hcmGPr4JwhdjYxMKt2q3B9lFzZ",
	"FiBkxgheMzrGXPudwd3t+UahfpnQJSPUtwMMMsvFAlnC2GhnRBsHmS0RfPXPG0SB96aB9gnq1I21bv5u",
	"T7bKKPPyHq7M2C5kbJLlBauvsRGpReZj21ARPLiIRHV6y8nSk7IDlherjwn2Q79PbDRUleUG00Q7Jdek",
	"L5d6da++t7Nb3dtZZmTS4vozDTbKsUhrUrPupvxvtmwt51TisplE6SpKcA08NF9AGCiJTm4E0IvkfQIB",
	"RwFkkjma1jaSGpcWdtUFiwUHdEKiKYrgwozfJzYeKg+TiOaQWsQESe2Yz8CIvhkeqoodj5QpgKE+4WGg",
	"b/wtXN4aVz017tqLNEUlKQKYO6VfImpcdq2iyAm3cfpC7EvaOn3DJD7Ex2CzAdJZiHOdtyDE+XFWIjhK",
	"v0ijb6tMh3xORU7of2qg9b+jssQmHWKBnSWYVGIqOJHTwAkvuLDA3BCbvxL/5DCI/3zTwOgKxQgGu6kv",
	"6T8S/VSQVpycZv6K4kLND3HglpQclfHUseIBHMnzY4lM/TfVAVNRkPcVHHjpoeWHeGL9R/rj/CgMTmbz",
	"UJEZWpbL5zw8TkOguCL0CjoOiFoS6jEPpBo/+1eBjmEun5twL3OLzuIQtG2utkAejQx3mfpdKpVO6COj",
	"2KrIG0qFitRnQMe8qbRByRo9TNLODUK5L34fUmahVdnvy6VAM0GcFj4bWn8p2GgQOpulTJyZBLTvSB6Z",
	"TXuk48zbHg3twj7kS2w0KjI83bNarpbLe+XdYjnT7qA8tdkx8CP6gjMC4OXPbjjYJHUA8tG8tlGvZsnl",
	"ibKnMzhq64vbG/BnU5nNnY04w8qXJXsT5TrPK1jyzjL5YkTlsi4ECBBNnbrlsuGXXTWKHW6CnawzFQVN",
	"pIeUV+6SUrYOWhKabySuxS+CCuhlfZrDgpo0H7/eoh9N0Z3zS2Mo8qq6vfcjtmUVx/rM4Rit92L3XMxj",
	"MyiWupU/SElA2mC5f9c5P3g+v2q3zrut+0OAyBgzSnQZ8T4ZQ4a19yhyR8jDl/AqcTiWukKimrMyD3re",
	"tAgkCOppCim/2WiMPBrIgZX9mRJvmtdWX23+mAUnahbEljwOMbcXCZwsxTnaUiHVndaooyM0VSEti1y1",
	"K+VCzVJ1E+DBKQ3TLvQwM+nRg8QJs5O/I0uoDmZeKMScNz5kJlsRBAbIoj7iwFi+8qqGvlTIiPquLJiA",
	"I4sSG5o8soSJCZHnu27xrndUaP6ob+2q3dnuzC8f4U95scNod5/+yEigQURk6skt9Q6K8mwolxpHIh8T",
	"mzztQyQsVxKGGaUIOlI2Qcb6+c+Qef+UHaT2ZrSLfJ9oV0kq50WpPiZXX9HMEj+cDlLJCJmBRI6FsIrq",
	"habsAPjV7PUnUK7ulOuDqg130F6jPrBr9UFz0KzCZq2BGnB3164OdsrDIfwtr0MrBgwSyy14eIQAizNj",
	"Z+MxF3mztDspLv425w1YbJF9sQ8XU/A36OZyfz1zPEACMV8qi2DiIoMa7WJIPTXhQwIdxMCvFiS2hwJM",
	"fgPYRkRgMdXP4OjzpTymUGkCC0WzQJsSHvqIAUseLpW9O5/ZBDmwPCxJM93GRaRP4rMUnwPJNaODtaQm",
	"1+ZxaPNRlQuE4JqtWLS6ZN+8S67krIRyc5GqGTJpc2mxv79NNb/FARZg5SorQxsJN4+OCMn39Mva4aj2",
	"/rtlc0ev85hyJIJG11ARHGEPAcejg4Fxw8aWkHyfIKcIPqjkGu4W/t+HOb4g/DCzcNfS9wGujN07fh9g",
	"BVzRCxMDD5KRbNUnOps5IXdEw6SemwAP2LMt9RCDujGj5ZjV1IuVSnFhKbViDX6/GT31rsR7bFrquYvF",
	"uDhIoBIDCoJSj/8w3MkaO4um3cwzjAK65MvS9NuE4reo4WHHtxvLPhEoloX/RhbkVWdwzQM42gS3VCPL",
	"ayTEMH6ReAu9QEshPxR4AjnKjr/cN1+0HB6XeDFi++yqyq0qbD5dUdZcpZlonVC/9KbM6pGsoSoSLtHC",
	"n41TWA6+WrWew3O82syDOIfQZXKjStnfSHiMW2ZNd7sZjlLqRLFPWgLIM6HFdcO6PpjCBx/y4MMsF179",
	"ZXLwP4DZGlQEQ58M0MzfrDidSn/TI/qaa6Xd0ZTZOsohYMhCtpLgsM73i1/tk/NKyWRAx5kBZ4kKDX9d",
	"YYatCzFsFv/uBI6prZJ+fm52+GPZa4m4NSvSMOe7vT6WWmCcxSfZzywzUIVLpaXFFGMuyP/tHx53LsH1",
	"8TW4vts/77TB2eEj2D+/ap+pz33SJ/5N53L/uGV1Lbp/2Do4HzYfT0bo7XQH2t7F42QXHh93vFPoiebp",
	"S/W1tF89++h2hp3w9VgE9y+7qE/Ob52Du92dF9hrBPcHDf/o4rQWjBBBtyWr53/9ejO6nN5w93OV3nye",
	"HL7ddQeV9uVFe9g+dkafmzfVPnl7GrGO1WZH5ZvqhJ0NPBja7t1HfA9J64D7lebj4Vc+aLTuaru2uGMX",
	"tZtH+8HZu/34GV8P75u3fXK2/9Ir18b3+1f2RZc/1vbOYZvsdILK1Thodg5pqYMO7x8rX/321XULnpUH",
	"pye1cOjU2yEa8Y+9bp9Mbh56qH3+Gj6d71xdfKZX12eT8cXN8HXgVD4fNMfhU/lMvJSsy5PqKwzLrz5v",
	"hXsnpwEaja+ub1+9Ppl+FS/TpyGj9xgdTYPJkzO+mQhCLpolp3sYlk7ve+yx3Kj6h3e93bY12K2PrJOj",
	"3tHwYuSR0XGpT8rDu3rrFjbK9ZPa60t5JAaoNj6zrj/T66vwbP+en3TH5fLd8WNreo3C6cfmrnVXejx0",
	"L3ZHte792Uuf7KDOkzPFF1fliVd5PD64PbNCbzLie62PoTdyKrQ3qPPam/80vi7vHtPe60O9+gLPGg/d",
	"j5fuE0J90twpf6b37sCqnAXdjy/DJ/rC2aF4al4P7p4+Po6PmrcBsx9a7OVkcDqqnga3Z63XnvvKb1p8",
	"3z2u9En5PHytPsCL/bJT7TSurQv7tGR9faHlpmWxl/3PIX59YLiBw72Lz0Hza6807L5d+tzuOKRZ+vp0",
	"1ie4eRN6w3B3N/zqPpQmojoQBAvnln99cV8vwpfHu/rToO6OxFHTPbsrff68W69+dc8bZ5PWbeumtd8n",
	"4uDo+Onhdmz5h87ZwUXlrNtqPvn3o0Ht1D3vXVTOP+9P4UPFtYjXin63Tk7H0L9/sduNcZ9YvvUR35xe",
	"7e9f7LdbrfoRPjxEJzs+c49OdsN7fnN+cVEtPzasJ5e8PjaPWr6iofbxpHnUnow6fbI/6Rwf3dDTdou3",
	"9/cf263JYfvEOWwf1VuttjO6mfX+ePnYKu3uPwaON+22nh5P3JfpmdsnpY/Dnbfr4f14cFItH36tjTq7",
	"V0f7l2Vy/vnj/l3FD8fdj197Ybf2cM72a37tOPREcHZ7eHp2LvzG4UGfVNjx2+cW7VWmwd5jp3neOrAv",
	"2u2r6UvrhdOHu+bu413Y/lgakBfWQ7fV89ur9nB63d7dedhrNvDVfZ/4je7HAb85mOy2q+fMs1sX9YuD",
	"kE6fKl0sjuFT/ezm/F587B3CSh3zx+5x++WN7l4/Nu9rp1ejRrlPnK8PTrN6WRr41cO37m6vWXs4PBhU",
	"vPFLveONX53O1zPkVCpvnx9fffbYfTo9bQ/Hb8OP3mV3J3x1Tvrk5bV0Wp56T9VzPDhmO8et1vRq7+6B",
	"tZ66k+5F+dB66TUnh23yOuoehNOv/sPkfny5/zk87Nw3r1DtsU8u8F1leHrZ5PbuQcCPXhsXHz/b5ILc",
	"dD+esJfe9dlBzX9gXssmhz3XfrxvvjyNggf3YMprpb09dNUn7qjMzsm0/HI5GcFwWMJ3zStr5/P4YvRy",
	"fntx6jTu9u7Ppqfhw4N4m3wmLxeXjYfbo/2vZ3X+RP2Liz4ZikHvpPKxMR3cPpRatfH+AL7ePlTF7t3b",
	"5Yv1hkbdp0MMzy/3zksn1mm7c1u5OWruNKsHdss7PNqz+2RUdW7wY/emBeFp+fS09XYyvh3dnp6fO2fV",
	"x5tHfHJ5P62K2un0aMgZ9BuTbvvhauheo870fL/3dNonYxZcetcDNOS9vcZub1jdv+yEztsTazfuXw+6",
	"Z6Mn59at3B+Pu50b0p6+jW6mO4d31a/XAX5o7Eke5V53Pj+xM2qd1c7Ou3sl/HZ607v1xMtF6/c++f16",
	"2NvtE3W7HF4erLp6llSfoAw9c+5lX9I/ixCtL9O+0nb1XmXbkyn8mYq+HC/SpXWev7IAJqQiyKVAw4GS",
	"8hNhrap8QJ/8GuAAeZig3zJLCSwENkZV3+iW5TLe1+iXtuuBJWa9DfMjzdNF26lymaJky7Zjr0LkHzYF",
	"2WEoXMrwG7KfR2jKF5PsNqqv3uo+YDG6OqnfNXfrhzbfvyNTMagNJuNbxznxbrzB42dvl1TK470lZecy",
	"c/XudFX6WP3RwdrmCSh5pNK2CNvHZH3YGVceUImnLIVs4/Spd0iDAoNpovp5RrG6qDaRnc2JSEd3qbxL",
	"ftRaaMhQBV7wLYHJPNpzBTXmbD2WwGOdDG+OcypilyOLIVHQDwHEPDIuvJ8BnVQUnzM1zkWFcwO+iwnH",
	"jivS6FmWxkuZA0ki0zEZalAv16r1bFfEBq/+xzbMoQedKDeHuZbOFtNhQon87CidBnqcmro6Zuc56JgV",
	"zbHVZWtKJ6wnS7LOtrUoOWsCsWvxOkenKbzl589ECobEBic2J4u6e4liLFs4daNua9y6RAQaqhUuWCIC",
	"EDVKXWDlIqFMuAXoI4YtWAwo9YpEBFKAyOVzlVWft7rxkgVplhvoo1b5iCcoTnHXa6dY7l23dAjlOSOb",
	"BfcsGinJdONnGuYDQtf26da267KQvrd2jtmL45t2WVItd123jPiPdV0WnOfrOiyzJX/7ks15IqHOwWNE",
	"MqJlVZoa5tFz9gxBT9elUln0YBAKsLhJOvhYBRxIeumTjL3X4SHAR5AYpzj0PJDREOiTx/sEMqQZnxba",
	"FuaFcVvDJceYKiePNnpKgPuEhR7SdbcYGlKG8mCCgAvHcWKkOs1A5fTJ1Q0QgBMY1YPAAmBOPog+CSjn",
	"2ESr+PhV+WR9KCxXW1/NfgBBHSVqSqYc084ye3QiqHqbp0/m4lo3JqkNe8wn5mxBUBv2yK6wvDFtbNh+",
	"iVdAlcjYPhA5DmXeJOvAhHbrtINlZd+N6yg6BF/mjsuWoccsJGRZfHEq0nzhFG69oB9MCsj2oM0N+WXp",
	"RbQ8TrrIa3GAchQOnYwpphYuGoahE1wlAkMvKJq0kEzUbf+K2Ky26A89y7UgRf+tHs3azEesxE4rZFhM",
	"u/IwaATtI8g0VgfqX0eRiHn60JNComophVfdLh5Vyv65b9+UMD+kWXF4OrdVUGN3UNGGOiJAp8DwoooP",
	"t5B5GkovN9cKoOUiUFXxw0pAju1Tk8mkCNVnZRQyfXnpvNM+vOweFqrFctEVvqeFNKFQdtXdV9ObJAoG",
	"VBI3gAFOuIg/5apR6VH54VOuViwXKzldU0ehqWR5lCBe+gPb39S5yiozcIy0C1ZzFVVwABhWAChTMZoe",
	"ElHld/0qAoxCN6PLXj8tk7CTUKZCNGepQypTEFMCFBNCNrKLyfpnHVuDknykSsWoQR8JJVr/I+OZnCjH",
	"KQJeUOCoQgeYKN1QuJFn/VP0HkV04rSSoxnMn/KW1Bc5m35DTG1GtVxOBAma4H7P+A9LL6Z83Ayglddf",
	"AkvqOKcxk8SJPCL1d5zapPIsTtohWsiKgnqxraeu/PlTt0JVLmqElCkOa0D07LU/f/Y7MrOmyRMYICbP",
	"BojPtoak/ldAMiJ0Qua2oPFX7P4dQa+Bij0DKj0MUEuVdrZTLFxRccS8//FF0ggPfR+yqUnkSzIhxbzi",
	"86TGKUV/qEJPWc9jtHWGMwQETaKueRBQuXSsNBGLEm6qqSiD2Bix6OF8rvi9UWkQtKIaZJglFRy+yLiu",
	"KRfRS4KaySAuojcJ34fi069pfUtfn5KZfVvgN5X3nr1jZ229+QhcyPXrlsj+lzEdNnvi6ifn+cl5NuQ8",
	"hmlkcZr3Ep62kJciHK4RlFLvrG0kKsUD/x8TllKYyjhBabz8FJh+sq1/U4FpKf/SimBSasqQX5LPIW/E",
	"TxLM6m/ERf4E2Wv+oem/WvrKepY640ipgn1oMqsRNUAqoUy/b5fN1wR6FSVVDTkNzzxqN+Ze9feaIIs2",
	"v6VubYmWVHXEFQTgmfzl77nFh5hg7iYucbDyDsdidnXrfFXlgvCRgAATfYYxJQAOaChM1DAPPbHqmlfp",
	"1z8v+bWXvHnGOpM05BGIi1hq71WsIGICCNVvxVihB5mp2gd+FS4NHdf4j067V5e/Ff/jCOlYVWh0Isde",
	"dMqzyCj1JPdKWopbbkBOt0iEjHCV1hC/aCmBUTq4YWfRM5aKv5siPnFjiyrCistgmO2LihhBAZLmWPM6",
	"pQ4ShCR6rbIQDVdsrCDF2VPnP+lxLT3OkLWEKFPbvUCY/5m0liaPDYgukR63mubitG9Jcgt0puvHoldo",
	"idRFxBT5IRvYSFeVoSlai03/qvrXKsqI4PxJGOsJI35NfwldRFu5DV38VFJ/Kql/NyV1gTdl8Ts1eFKm",
	"WGAxs1eQFphL1spmTUqq5s6ySI9EO1WU508l/dkask57/B6AQcZPMvvXkJk+6P9+RDZ7UAJ6HoiDzaLT",
	"NCOz9RZtSHTQA7HiwFAN2ay+/mAK1NWZTaib24+Qaf5Dt37tL77Dl26l+gCSv/2k4p9UvA0Vo8UTJCk3",
	"DvJZfkNemSY/eO7n468WFmpAUbxAauVyiOjFr39DuWTlcr7FWQ9ZXOzCPBRA7dDSr1vElRbTIWAwwEVV",
	"xMbFQ51uAgNc0oVOleUBsUL0SklpXFXSylxgmoAOJs6qCbiADvrBacxr3OYhg3iadeN8+fb/AwAA///g",
	"CkGgDrcAAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
