/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the PatcheddebAptRemote type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatcheddebAptRemote{}

// PatcheddebAptRemote A Serializer for AptRemote.
type PatcheddebAptRemote struct {
	// A unique name for this remote.
	Name *string `json:"name,omitempty"`
	// The URL of an external content source.
	Url *string `json:"url,omitempty"`
	// A PEM encoded CA certificate used to validate the server certificate presented by the remote server.
	CaCert NullableString `json:"ca_cert,omitempty"`
	// A PEM encoded client certificate used for authentication.
	ClientCert NullableString `json:"client_cert,omitempty"`
	// A PEM encoded private key used for authentication.
	ClientKey NullableString `json:"client_key,omitempty"`
	// If True, TLS peer validation must be performed.
	TlsValidation *bool `json:"tls_validation,omitempty"`
	// The proxy URL. Format: scheme://host:port
	ProxyUrl NullableString `json:"proxy_url,omitempty"`
	// The username to authenticte to the proxy.
	ProxyUsername NullableString `json:"proxy_username,omitempty"`
	// The password to authenticate to the proxy. Extra leading and trailing whitespace characters are not trimmed.
	ProxyPassword NullableString `json:"proxy_password,omitempty"`
	// The username to be used for authentication when syncing.
	Username NullableString `json:"username,omitempty"`
	// The password to be used for authentication when syncing. Extra leading and trailing whitespace characters are not trimmed.
	Password NullableString `json:"password,omitempty"`
	PulpLabels *map[string]string `json:"pulp_labels,omitempty"`
	// Total number of simultaneous connections. If not set then the default value will be used.
	DownloadConcurrency NullableInt64 `json:"download_concurrency,omitempty"`
	// Maximum number of retry attempts after a download failure. If not set then the default value (3) will be used.
	MaxRetries NullableInt64 `json:"max_retries,omitempty"`
	Policy *Policy762Enum `json:"policy,omitempty"`
	// aiohttp.ClientTimeout.total (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	TotalTimeout NullableFloat64 `json:"total_timeout,omitempty"`
	// aiohttp.ClientTimeout.connect (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	ConnectTimeout NullableFloat64 `json:"connect_timeout,omitempty"`
	// aiohttp.ClientTimeout.sock_connect (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	SockConnectTimeout NullableFloat64 `json:"sock_connect_timeout,omitempty"`
	// aiohttp.ClientTimeout.sock_read (q.v.) for download-connections. The default is null, which will cause the default from the aiohttp library to be used.
	SockReadTimeout NullableFloat64 `json:"sock_read_timeout,omitempty"`
	// Headers for aiohttp.Clientsession
	Headers []map[string]interface{} `json:"headers,omitempty"`
	// Limits requests per second for each concurrent downloader
	RateLimit NullableInt64 `json:"rate_limit,omitempty"`
	// Whitespace separated list of distributions to sync. The distribution is the path from the repository root to the \"Release\" file you want to access. This is often, but not always, equal to either the codename or the suite of the release you want to sync. If the repository you are trying to sync uses \"flat repository format\", the distribution must end with a \"/\". Based on \"/etc/apt/sources.list\" syntax.
	Distributions *string `json:"distributions,omitempty"`
	// Whitespace separatet list of components to sync. If none are supplied, all that are available will be synchronized. Leave blank for repositores using \"flat repository format\".
	Components NullableString `json:"components,omitempty"`
	// Whitespace separated list of architectures to sync If none are supplied, all that are available will be synchronized. A list of valid architecture specification strings can be found by running \"dpkg-architecture -L\". A sync will download the intersection of the list of architectures provided via this field and those provided by the relevant \"Release\" file. Architecture=\"all\" is always synchronized and does not need to be provided here.
	Architectures NullableString `json:"architectures,omitempty"`
	// Sync source packages
	SyncSources *bool `json:"sync_sources,omitempty"`
	// Sync installer packages
	SyncUdebs *bool `json:"sync_udebs,omitempty"`
	// Sync installer files
	SyncInstaller *bool `json:"sync_installer,omitempty"`
	// Gpg public key to verify origin releases against
	Gpgkey NullableString `json:"gpgkey,omitempty"`
	// By default, upstream repositories that declare architectures and corresponding package indices in their Release files without actually publishing them, will fail to synchronize. Set this flag to True to allow the synchronization of such \"partial mirrors\" instead. Alternatively, you could make your remote filter by architectures for which the upstream repository does have indices.
	IgnoreMissingPackageIndices *bool `json:"ignore_missing_package_indices,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PatcheddebAptRemote PatcheddebAptRemote

// NewPatcheddebAptRemote instantiates a new PatcheddebAptRemote object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatcheddebAptRemote() *PatcheddebAptRemote {
	this := PatcheddebAptRemote{}
	var policy Policy762Enum = POLICY762ENUM_IMMEDIATE
	this.Policy = &policy
	return &this
}

// NewPatcheddebAptRemoteWithDefaults instantiates a new PatcheddebAptRemote object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatcheddebAptRemoteWithDefaults() *PatcheddebAptRemote {
	this := PatcheddebAptRemote{}
	var policy Policy762Enum = POLICY762ENUM_IMMEDIATE
	this.Policy = &policy
	return &this
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *PatcheddebAptRemote) SetName(v string) {
	o.Name = &v
}

// GetUrl returns the Url field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetUrl() string {
	if o == nil || IsNil(o.Url) {
		var ret string
		return ret
	}
	return *o.Url
}

// GetUrlOk returns a tuple with the Url field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetUrlOk() (*string, bool) {
	if o == nil || IsNil(o.Url) {
		return nil, false
	}
	return o.Url, true
}

// HasUrl returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasUrl() bool {
	if o != nil && !IsNil(o.Url) {
		return true
	}

	return false
}

// SetUrl gets a reference to the given string and assigns it to the Url field.
func (o *PatcheddebAptRemote) SetUrl(v string) {
	o.Url = &v
}

// GetCaCert returns the CaCert field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetCaCert() string {
	if o == nil || IsNil(o.CaCert.Get()) {
		var ret string
		return ret
	}
	return *o.CaCert.Get()
}

// GetCaCertOk returns a tuple with the CaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetCaCertOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CaCert.Get(), o.CaCert.IsSet()
}

// HasCaCert returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasCaCert() bool {
	if o != nil && o.CaCert.IsSet() {
		return true
	}

	return false
}

// SetCaCert gets a reference to the given NullableString and assigns it to the CaCert field.
func (o *PatcheddebAptRemote) SetCaCert(v string) {
	o.CaCert.Set(&v)
}
// SetCaCertNil sets the value for CaCert to be an explicit nil
func (o *PatcheddebAptRemote) SetCaCertNil() {
	o.CaCert.Set(nil)
}

// UnsetCaCert ensures that no value is present for CaCert, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetCaCert() {
	o.CaCert.Unset()
}

// GetClientCert returns the ClientCert field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetClientCert() string {
	if o == nil || IsNil(o.ClientCert.Get()) {
		var ret string
		return ret
	}
	return *o.ClientCert.Get()
}

// GetClientCertOk returns a tuple with the ClientCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetClientCertOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ClientCert.Get(), o.ClientCert.IsSet()
}

// HasClientCert returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasClientCert() bool {
	if o != nil && o.ClientCert.IsSet() {
		return true
	}

	return false
}

// SetClientCert gets a reference to the given NullableString and assigns it to the ClientCert field.
func (o *PatcheddebAptRemote) SetClientCert(v string) {
	o.ClientCert.Set(&v)
}
// SetClientCertNil sets the value for ClientCert to be an explicit nil
func (o *PatcheddebAptRemote) SetClientCertNil() {
	o.ClientCert.Set(nil)
}

// UnsetClientCert ensures that no value is present for ClientCert, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetClientCert() {
	o.ClientCert.Unset()
}

// GetClientKey returns the ClientKey field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetClientKey() string {
	if o == nil || IsNil(o.ClientKey.Get()) {
		var ret string
		return ret
	}
	return *o.ClientKey.Get()
}

// GetClientKeyOk returns a tuple with the ClientKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetClientKeyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ClientKey.Get(), o.ClientKey.IsSet()
}

// HasClientKey returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasClientKey() bool {
	if o != nil && o.ClientKey.IsSet() {
		return true
	}

	return false
}

// SetClientKey gets a reference to the given NullableString and assigns it to the ClientKey field.
func (o *PatcheddebAptRemote) SetClientKey(v string) {
	o.ClientKey.Set(&v)
}
// SetClientKeyNil sets the value for ClientKey to be an explicit nil
func (o *PatcheddebAptRemote) SetClientKeyNil() {
	o.ClientKey.Set(nil)
}

// UnsetClientKey ensures that no value is present for ClientKey, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetClientKey() {
	o.ClientKey.Unset()
}

// GetTlsValidation returns the TlsValidation field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetTlsValidation() bool {
	if o == nil || IsNil(o.TlsValidation) {
		var ret bool
		return ret
	}
	return *o.TlsValidation
}

// GetTlsValidationOk returns a tuple with the TlsValidation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetTlsValidationOk() (*bool, bool) {
	if o == nil || IsNil(o.TlsValidation) {
		return nil, false
	}
	return o.TlsValidation, true
}

// HasTlsValidation returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasTlsValidation() bool {
	if o != nil && !IsNil(o.TlsValidation) {
		return true
	}

	return false
}

// SetTlsValidation gets a reference to the given bool and assigns it to the TlsValidation field.
func (o *PatcheddebAptRemote) SetTlsValidation(v bool) {
	o.TlsValidation = &v
}

// GetProxyUrl returns the ProxyUrl field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetProxyUrl() string {
	if o == nil || IsNil(o.ProxyUrl.Get()) {
		var ret string
		return ret
	}
	return *o.ProxyUrl.Get()
}

// GetProxyUrlOk returns a tuple with the ProxyUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetProxyUrlOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ProxyUrl.Get(), o.ProxyUrl.IsSet()
}

// HasProxyUrl returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasProxyUrl() bool {
	if o != nil && o.ProxyUrl.IsSet() {
		return true
	}

	return false
}

// SetProxyUrl gets a reference to the given NullableString and assigns it to the ProxyUrl field.
func (o *PatcheddebAptRemote) SetProxyUrl(v string) {
	o.ProxyUrl.Set(&v)
}
// SetProxyUrlNil sets the value for ProxyUrl to be an explicit nil
func (o *PatcheddebAptRemote) SetProxyUrlNil() {
	o.ProxyUrl.Set(nil)
}

// UnsetProxyUrl ensures that no value is present for ProxyUrl, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetProxyUrl() {
	o.ProxyUrl.Unset()
}

// GetProxyUsername returns the ProxyUsername field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetProxyUsername() string {
	if o == nil || IsNil(o.ProxyUsername.Get()) {
		var ret string
		return ret
	}
	return *o.ProxyUsername.Get()
}

// GetProxyUsernameOk returns a tuple with the ProxyUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetProxyUsernameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ProxyUsername.Get(), o.ProxyUsername.IsSet()
}

// HasProxyUsername returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasProxyUsername() bool {
	if o != nil && o.ProxyUsername.IsSet() {
		return true
	}

	return false
}

// SetProxyUsername gets a reference to the given NullableString and assigns it to the ProxyUsername field.
func (o *PatcheddebAptRemote) SetProxyUsername(v string) {
	o.ProxyUsername.Set(&v)
}
// SetProxyUsernameNil sets the value for ProxyUsername to be an explicit nil
func (o *PatcheddebAptRemote) SetProxyUsernameNil() {
	o.ProxyUsername.Set(nil)
}

// UnsetProxyUsername ensures that no value is present for ProxyUsername, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetProxyUsername() {
	o.ProxyUsername.Unset()
}

// GetProxyPassword returns the ProxyPassword field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetProxyPassword() string {
	if o == nil || IsNil(o.ProxyPassword.Get()) {
		var ret string
		return ret
	}
	return *o.ProxyPassword.Get()
}

// GetProxyPasswordOk returns a tuple with the ProxyPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetProxyPasswordOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ProxyPassword.Get(), o.ProxyPassword.IsSet()
}

// HasProxyPassword returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasProxyPassword() bool {
	if o != nil && o.ProxyPassword.IsSet() {
		return true
	}

	return false
}

// SetProxyPassword gets a reference to the given NullableString and assigns it to the ProxyPassword field.
func (o *PatcheddebAptRemote) SetProxyPassword(v string) {
	o.ProxyPassword.Set(&v)
}
// SetProxyPasswordNil sets the value for ProxyPassword to be an explicit nil
func (o *PatcheddebAptRemote) SetProxyPasswordNil() {
	o.ProxyPassword.Set(nil)
}

// UnsetProxyPassword ensures that no value is present for ProxyPassword, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetProxyPassword() {
	o.ProxyPassword.Unset()
}

// GetUsername returns the Username field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetUsername() string {
	if o == nil || IsNil(o.Username.Get()) {
		var ret string
		return ret
	}
	return *o.Username.Get()
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetUsernameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Username.Get(), o.Username.IsSet()
}

// HasUsername returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasUsername() bool {
	if o != nil && o.Username.IsSet() {
		return true
	}

	return false
}

// SetUsername gets a reference to the given NullableString and assigns it to the Username field.
func (o *PatcheddebAptRemote) SetUsername(v string) {
	o.Username.Set(&v)
}
// SetUsernameNil sets the value for Username to be an explicit nil
func (o *PatcheddebAptRemote) SetUsernameNil() {
	o.Username.Set(nil)
}

// UnsetUsername ensures that no value is present for Username, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetUsername() {
	o.Username.Unset()
}

// GetPassword returns the Password field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetPassword() string {
	if o == nil || IsNil(o.Password.Get()) {
		var ret string
		return ret
	}
	return *o.Password.Get()
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetPasswordOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Password.Get(), o.Password.IsSet()
}

// HasPassword returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasPassword() bool {
	if o != nil && o.Password.IsSet() {
		return true
	}

	return false
}

// SetPassword gets a reference to the given NullableString and assigns it to the Password field.
func (o *PatcheddebAptRemote) SetPassword(v string) {
	o.Password.Set(&v)
}
// SetPasswordNil sets the value for Password to be an explicit nil
func (o *PatcheddebAptRemote) SetPasswordNil() {
	o.Password.Set(nil)
}

// UnsetPassword ensures that no value is present for Password, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetPassword() {
	o.Password.Unset()
}

// GetPulpLabels returns the PulpLabels field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetPulpLabels() map[string]string {
	if o == nil || IsNil(o.PulpLabels) {
		var ret map[string]string
		return ret
	}
	return *o.PulpLabels
}

// GetPulpLabelsOk returns a tuple with the PulpLabels field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetPulpLabelsOk() (*map[string]string, bool) {
	if o == nil || IsNil(o.PulpLabels) {
		return nil, false
	}
	return o.PulpLabels, true
}

// HasPulpLabels returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasPulpLabels() bool {
	if o != nil && !IsNil(o.PulpLabels) {
		return true
	}

	return false
}

// SetPulpLabels gets a reference to the given map[string]string and assigns it to the PulpLabels field.
func (o *PatcheddebAptRemote) SetPulpLabels(v map[string]string) {
	o.PulpLabels = &v
}

// GetDownloadConcurrency returns the DownloadConcurrency field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetDownloadConcurrency() int64 {
	if o == nil || IsNil(o.DownloadConcurrency.Get()) {
		var ret int64
		return ret
	}
	return *o.DownloadConcurrency.Get()
}

// GetDownloadConcurrencyOk returns a tuple with the DownloadConcurrency field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetDownloadConcurrencyOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.DownloadConcurrency.Get(), o.DownloadConcurrency.IsSet()
}

// HasDownloadConcurrency returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasDownloadConcurrency() bool {
	if o != nil && o.DownloadConcurrency.IsSet() {
		return true
	}

	return false
}

// SetDownloadConcurrency gets a reference to the given NullableInt64 and assigns it to the DownloadConcurrency field.
func (o *PatcheddebAptRemote) SetDownloadConcurrency(v int64) {
	o.DownloadConcurrency.Set(&v)
}
// SetDownloadConcurrencyNil sets the value for DownloadConcurrency to be an explicit nil
func (o *PatcheddebAptRemote) SetDownloadConcurrencyNil() {
	o.DownloadConcurrency.Set(nil)
}

// UnsetDownloadConcurrency ensures that no value is present for DownloadConcurrency, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetDownloadConcurrency() {
	o.DownloadConcurrency.Unset()
}

// GetMaxRetries returns the MaxRetries field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetMaxRetries() int64 {
	if o == nil || IsNil(o.MaxRetries.Get()) {
		var ret int64
		return ret
	}
	return *o.MaxRetries.Get()
}

// GetMaxRetriesOk returns a tuple with the MaxRetries field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetMaxRetriesOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.MaxRetries.Get(), o.MaxRetries.IsSet()
}

// HasMaxRetries returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasMaxRetries() bool {
	if o != nil && o.MaxRetries.IsSet() {
		return true
	}

	return false
}

// SetMaxRetries gets a reference to the given NullableInt64 and assigns it to the MaxRetries field.
func (o *PatcheddebAptRemote) SetMaxRetries(v int64) {
	o.MaxRetries.Set(&v)
}
// SetMaxRetriesNil sets the value for MaxRetries to be an explicit nil
func (o *PatcheddebAptRemote) SetMaxRetriesNil() {
	o.MaxRetries.Set(nil)
}

// UnsetMaxRetries ensures that no value is present for MaxRetries, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetMaxRetries() {
	o.MaxRetries.Unset()
}

// GetPolicy returns the Policy field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetPolicy() Policy762Enum {
	if o == nil || IsNil(o.Policy) {
		var ret Policy762Enum
		return ret
	}
	return *o.Policy
}

// GetPolicyOk returns a tuple with the Policy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetPolicyOk() (*Policy762Enum, bool) {
	if o == nil || IsNil(o.Policy) {
		return nil, false
	}
	return o.Policy, true
}

// HasPolicy returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasPolicy() bool {
	if o != nil && !IsNil(o.Policy) {
		return true
	}

	return false
}

// SetPolicy gets a reference to the given Policy762Enum and assigns it to the Policy field.
func (o *PatcheddebAptRemote) SetPolicy(v Policy762Enum) {
	o.Policy = &v
}

// GetTotalTimeout returns the TotalTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetTotalTimeout() float64 {
	if o == nil || IsNil(o.TotalTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.TotalTimeout.Get()
}

// GetTotalTimeoutOk returns a tuple with the TotalTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetTotalTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.TotalTimeout.Get(), o.TotalTimeout.IsSet()
}

// HasTotalTimeout returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasTotalTimeout() bool {
	if o != nil && o.TotalTimeout.IsSet() {
		return true
	}

	return false
}

// SetTotalTimeout gets a reference to the given NullableFloat64 and assigns it to the TotalTimeout field.
func (o *PatcheddebAptRemote) SetTotalTimeout(v float64) {
	o.TotalTimeout.Set(&v)
}
// SetTotalTimeoutNil sets the value for TotalTimeout to be an explicit nil
func (o *PatcheddebAptRemote) SetTotalTimeoutNil() {
	o.TotalTimeout.Set(nil)
}

// UnsetTotalTimeout ensures that no value is present for TotalTimeout, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetTotalTimeout() {
	o.TotalTimeout.Unset()
}

// GetConnectTimeout returns the ConnectTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetConnectTimeout() float64 {
	if o == nil || IsNil(o.ConnectTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.ConnectTimeout.Get()
}

// GetConnectTimeoutOk returns a tuple with the ConnectTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetConnectTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.ConnectTimeout.Get(), o.ConnectTimeout.IsSet()
}

// HasConnectTimeout returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasConnectTimeout() bool {
	if o != nil && o.ConnectTimeout.IsSet() {
		return true
	}

	return false
}

// SetConnectTimeout gets a reference to the given NullableFloat64 and assigns it to the ConnectTimeout field.
func (o *PatcheddebAptRemote) SetConnectTimeout(v float64) {
	o.ConnectTimeout.Set(&v)
}
// SetConnectTimeoutNil sets the value for ConnectTimeout to be an explicit nil
func (o *PatcheddebAptRemote) SetConnectTimeoutNil() {
	o.ConnectTimeout.Set(nil)
}

// UnsetConnectTimeout ensures that no value is present for ConnectTimeout, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetConnectTimeout() {
	o.ConnectTimeout.Unset()
}

// GetSockConnectTimeout returns the SockConnectTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetSockConnectTimeout() float64 {
	if o == nil || IsNil(o.SockConnectTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.SockConnectTimeout.Get()
}

// GetSockConnectTimeoutOk returns a tuple with the SockConnectTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetSockConnectTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.SockConnectTimeout.Get(), o.SockConnectTimeout.IsSet()
}

// HasSockConnectTimeout returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasSockConnectTimeout() bool {
	if o != nil && o.SockConnectTimeout.IsSet() {
		return true
	}

	return false
}

// SetSockConnectTimeout gets a reference to the given NullableFloat64 and assigns it to the SockConnectTimeout field.
func (o *PatcheddebAptRemote) SetSockConnectTimeout(v float64) {
	o.SockConnectTimeout.Set(&v)
}
// SetSockConnectTimeoutNil sets the value for SockConnectTimeout to be an explicit nil
func (o *PatcheddebAptRemote) SetSockConnectTimeoutNil() {
	o.SockConnectTimeout.Set(nil)
}

// UnsetSockConnectTimeout ensures that no value is present for SockConnectTimeout, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetSockConnectTimeout() {
	o.SockConnectTimeout.Unset()
}

// GetSockReadTimeout returns the SockReadTimeout field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetSockReadTimeout() float64 {
	if o == nil || IsNil(o.SockReadTimeout.Get()) {
		var ret float64
		return ret
	}
	return *o.SockReadTimeout.Get()
}

// GetSockReadTimeoutOk returns a tuple with the SockReadTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetSockReadTimeoutOk() (*float64, bool) {
	if o == nil {
		return nil, false
	}
	return o.SockReadTimeout.Get(), o.SockReadTimeout.IsSet()
}

// HasSockReadTimeout returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasSockReadTimeout() bool {
	if o != nil && o.SockReadTimeout.IsSet() {
		return true
	}

	return false
}

// SetSockReadTimeout gets a reference to the given NullableFloat64 and assigns it to the SockReadTimeout field.
func (o *PatcheddebAptRemote) SetSockReadTimeout(v float64) {
	o.SockReadTimeout.Set(&v)
}
// SetSockReadTimeoutNil sets the value for SockReadTimeout to be an explicit nil
func (o *PatcheddebAptRemote) SetSockReadTimeoutNil() {
	o.SockReadTimeout.Set(nil)
}

// UnsetSockReadTimeout ensures that no value is present for SockReadTimeout, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetSockReadTimeout() {
	o.SockReadTimeout.Unset()
}

// GetHeaders returns the Headers field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetHeaders() []map[string]interface{} {
	if o == nil || IsNil(o.Headers) {
		var ret []map[string]interface{}
		return ret
	}
	return o.Headers
}

// GetHeadersOk returns a tuple with the Headers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetHeadersOk() ([]map[string]interface{}, bool) {
	if o == nil || IsNil(o.Headers) {
		return nil, false
	}
	return o.Headers, true
}

// HasHeaders returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasHeaders() bool {
	if o != nil && !IsNil(o.Headers) {
		return true
	}

	return false
}

// SetHeaders gets a reference to the given []map[string]interface{} and assigns it to the Headers field.
func (o *PatcheddebAptRemote) SetHeaders(v []map[string]interface{}) {
	o.Headers = v
}

// GetRateLimit returns the RateLimit field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetRateLimit() int64 {
	if o == nil || IsNil(o.RateLimit.Get()) {
		var ret int64
		return ret
	}
	return *o.RateLimit.Get()
}

// GetRateLimitOk returns a tuple with the RateLimit field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetRateLimitOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.RateLimit.Get(), o.RateLimit.IsSet()
}

// HasRateLimit returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasRateLimit() bool {
	if o != nil && o.RateLimit.IsSet() {
		return true
	}

	return false
}

// SetRateLimit gets a reference to the given NullableInt64 and assigns it to the RateLimit field.
func (o *PatcheddebAptRemote) SetRateLimit(v int64) {
	o.RateLimit.Set(&v)
}
// SetRateLimitNil sets the value for RateLimit to be an explicit nil
func (o *PatcheddebAptRemote) SetRateLimitNil() {
	o.RateLimit.Set(nil)
}

// UnsetRateLimit ensures that no value is present for RateLimit, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetRateLimit() {
	o.RateLimit.Unset()
}

// GetDistributions returns the Distributions field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetDistributions() string {
	if o == nil || IsNil(o.Distributions) {
		var ret string
		return ret
	}
	return *o.Distributions
}

// GetDistributionsOk returns a tuple with the Distributions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetDistributionsOk() (*string, bool) {
	if o == nil || IsNil(o.Distributions) {
		return nil, false
	}
	return o.Distributions, true
}

// HasDistributions returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasDistributions() bool {
	if o != nil && !IsNil(o.Distributions) {
		return true
	}

	return false
}

// SetDistributions gets a reference to the given string and assigns it to the Distributions field.
func (o *PatcheddebAptRemote) SetDistributions(v string) {
	o.Distributions = &v
}

// GetComponents returns the Components field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetComponents() string {
	if o == nil || IsNil(o.Components.Get()) {
		var ret string
		return ret
	}
	return *o.Components.Get()
}

// GetComponentsOk returns a tuple with the Components field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetComponentsOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Components.Get(), o.Components.IsSet()
}

// HasComponents returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasComponents() bool {
	if o != nil && o.Components.IsSet() {
		return true
	}

	return false
}

// SetComponents gets a reference to the given NullableString and assigns it to the Components field.
func (o *PatcheddebAptRemote) SetComponents(v string) {
	o.Components.Set(&v)
}
// SetComponentsNil sets the value for Components to be an explicit nil
func (o *PatcheddebAptRemote) SetComponentsNil() {
	o.Components.Set(nil)
}

// UnsetComponents ensures that no value is present for Components, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetComponents() {
	o.Components.Unset()
}

// GetArchitectures returns the Architectures field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetArchitectures() string {
	if o == nil || IsNil(o.Architectures.Get()) {
		var ret string
		return ret
	}
	return *o.Architectures.Get()
}

// GetArchitecturesOk returns a tuple with the Architectures field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetArchitecturesOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Architectures.Get(), o.Architectures.IsSet()
}

// HasArchitectures returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasArchitectures() bool {
	if o != nil && o.Architectures.IsSet() {
		return true
	}

	return false
}

// SetArchitectures gets a reference to the given NullableString and assigns it to the Architectures field.
func (o *PatcheddebAptRemote) SetArchitectures(v string) {
	o.Architectures.Set(&v)
}
// SetArchitecturesNil sets the value for Architectures to be an explicit nil
func (o *PatcheddebAptRemote) SetArchitecturesNil() {
	o.Architectures.Set(nil)
}

// UnsetArchitectures ensures that no value is present for Architectures, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetArchitectures() {
	o.Architectures.Unset()
}

// GetSyncSources returns the SyncSources field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetSyncSources() bool {
	if o == nil || IsNil(o.SyncSources) {
		var ret bool
		return ret
	}
	return *o.SyncSources
}

// GetSyncSourcesOk returns a tuple with the SyncSources field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetSyncSourcesOk() (*bool, bool) {
	if o == nil || IsNil(o.SyncSources) {
		return nil, false
	}
	return o.SyncSources, true
}

// HasSyncSources returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasSyncSources() bool {
	if o != nil && !IsNil(o.SyncSources) {
		return true
	}

	return false
}

// SetSyncSources gets a reference to the given bool and assigns it to the SyncSources field.
func (o *PatcheddebAptRemote) SetSyncSources(v bool) {
	o.SyncSources = &v
}

// GetSyncUdebs returns the SyncUdebs field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetSyncUdebs() bool {
	if o == nil || IsNil(o.SyncUdebs) {
		var ret bool
		return ret
	}
	return *o.SyncUdebs
}

// GetSyncUdebsOk returns a tuple with the SyncUdebs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetSyncUdebsOk() (*bool, bool) {
	if o == nil || IsNil(o.SyncUdebs) {
		return nil, false
	}
	return o.SyncUdebs, true
}

// HasSyncUdebs returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasSyncUdebs() bool {
	if o != nil && !IsNil(o.SyncUdebs) {
		return true
	}

	return false
}

// SetSyncUdebs gets a reference to the given bool and assigns it to the SyncUdebs field.
func (o *PatcheddebAptRemote) SetSyncUdebs(v bool) {
	o.SyncUdebs = &v
}

// GetSyncInstaller returns the SyncInstaller field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetSyncInstaller() bool {
	if o == nil || IsNil(o.SyncInstaller) {
		var ret bool
		return ret
	}
	return *o.SyncInstaller
}

// GetSyncInstallerOk returns a tuple with the SyncInstaller field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetSyncInstallerOk() (*bool, bool) {
	if o == nil || IsNil(o.SyncInstaller) {
		return nil, false
	}
	return o.SyncInstaller, true
}

// HasSyncInstaller returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasSyncInstaller() bool {
	if o != nil && !IsNil(o.SyncInstaller) {
		return true
	}

	return false
}

// SetSyncInstaller gets a reference to the given bool and assigns it to the SyncInstaller field.
func (o *PatcheddebAptRemote) SetSyncInstaller(v bool) {
	o.SyncInstaller = &v
}

// GetGpgkey returns the Gpgkey field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PatcheddebAptRemote) GetGpgkey() string {
	if o == nil || IsNil(o.Gpgkey.Get()) {
		var ret string
		return ret
	}
	return *o.Gpgkey.Get()
}

// GetGpgkeyOk returns a tuple with the Gpgkey field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PatcheddebAptRemote) GetGpgkeyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Gpgkey.Get(), o.Gpgkey.IsSet()
}

// HasGpgkey returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasGpgkey() bool {
	if o != nil && o.Gpgkey.IsSet() {
		return true
	}

	return false
}

// SetGpgkey gets a reference to the given NullableString and assigns it to the Gpgkey field.
func (o *PatcheddebAptRemote) SetGpgkey(v string) {
	o.Gpgkey.Set(&v)
}
// SetGpgkeyNil sets the value for Gpgkey to be an explicit nil
func (o *PatcheddebAptRemote) SetGpgkeyNil() {
	o.Gpgkey.Set(nil)
}

// UnsetGpgkey ensures that no value is present for Gpgkey, not even an explicit nil
func (o *PatcheddebAptRemote) UnsetGpgkey() {
	o.Gpgkey.Unset()
}

// GetIgnoreMissingPackageIndices returns the IgnoreMissingPackageIndices field value if set, zero value otherwise.
func (o *PatcheddebAptRemote) GetIgnoreMissingPackageIndices() bool {
	if o == nil || IsNil(o.IgnoreMissingPackageIndices) {
		var ret bool
		return ret
	}
	return *o.IgnoreMissingPackageIndices
}

// GetIgnoreMissingPackageIndicesOk returns a tuple with the IgnoreMissingPackageIndices field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PatcheddebAptRemote) GetIgnoreMissingPackageIndicesOk() (*bool, bool) {
	if o == nil || IsNil(o.IgnoreMissingPackageIndices) {
		return nil, false
	}
	return o.IgnoreMissingPackageIndices, true
}

// HasIgnoreMissingPackageIndices returns a boolean if a field has been set.
func (o *PatcheddebAptRemote) HasIgnoreMissingPackageIndices() bool {
	if o != nil && !IsNil(o.IgnoreMissingPackageIndices) {
		return true
	}

	return false
}

// SetIgnoreMissingPackageIndices gets a reference to the given bool and assigns it to the IgnoreMissingPackageIndices field.
func (o *PatcheddebAptRemote) SetIgnoreMissingPackageIndices(v bool) {
	o.IgnoreMissingPackageIndices = &v
}

func (o PatcheddebAptRemote) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatcheddebAptRemote) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Url) {
		toSerialize["url"] = o.Url
	}
	if o.CaCert.IsSet() {
		toSerialize["ca_cert"] = o.CaCert.Get()
	}
	if o.ClientCert.IsSet() {
		toSerialize["client_cert"] = o.ClientCert.Get()
	}
	if o.ClientKey.IsSet() {
		toSerialize["client_key"] = o.ClientKey.Get()
	}
	if !IsNil(o.TlsValidation) {
		toSerialize["tls_validation"] = o.TlsValidation
	}
	if o.ProxyUrl.IsSet() {
		toSerialize["proxy_url"] = o.ProxyUrl.Get()
	}
	if o.ProxyUsername.IsSet() {
		toSerialize["proxy_username"] = o.ProxyUsername.Get()
	}
	if o.ProxyPassword.IsSet() {
		toSerialize["proxy_password"] = o.ProxyPassword.Get()
	}
	if o.Username.IsSet() {
		toSerialize["username"] = o.Username.Get()
	}
	if o.Password.IsSet() {
		toSerialize["password"] = o.Password.Get()
	}
	if !IsNil(o.PulpLabels) {
		toSerialize["pulp_labels"] = o.PulpLabels
	}
	if o.DownloadConcurrency.IsSet() {
		toSerialize["download_concurrency"] = o.DownloadConcurrency.Get()
	}
	if o.MaxRetries.IsSet() {
		toSerialize["max_retries"] = o.MaxRetries.Get()
	}
	if !IsNil(o.Policy) {
		toSerialize["policy"] = o.Policy
	}
	if o.TotalTimeout.IsSet() {
		toSerialize["total_timeout"] = o.TotalTimeout.Get()
	}
	if o.ConnectTimeout.IsSet() {
		toSerialize["connect_timeout"] = o.ConnectTimeout.Get()
	}
	if o.SockConnectTimeout.IsSet() {
		toSerialize["sock_connect_timeout"] = o.SockConnectTimeout.Get()
	}
	if o.SockReadTimeout.IsSet() {
		toSerialize["sock_read_timeout"] = o.SockReadTimeout.Get()
	}
	if !IsNil(o.Headers) {
		toSerialize["headers"] = o.Headers
	}
	if o.RateLimit.IsSet() {
		toSerialize["rate_limit"] = o.RateLimit.Get()
	}
	if !IsNil(o.Distributions) {
		toSerialize["distributions"] = o.Distributions
	}
	if o.Components.IsSet() {
		toSerialize["components"] = o.Components.Get()
	}
	if o.Architectures.IsSet() {
		toSerialize["architectures"] = o.Architectures.Get()
	}
	if !IsNil(o.SyncSources) {
		toSerialize["sync_sources"] = o.SyncSources
	}
	if !IsNil(o.SyncUdebs) {
		toSerialize["sync_udebs"] = o.SyncUdebs
	}
	if !IsNil(o.SyncInstaller) {
		toSerialize["sync_installer"] = o.SyncInstaller
	}
	if o.Gpgkey.IsSet() {
		toSerialize["gpgkey"] = o.Gpgkey.Get()
	}
	if !IsNil(o.IgnoreMissingPackageIndices) {
		toSerialize["ignore_missing_package_indices"] = o.IgnoreMissingPackageIndices
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatcheddebAptRemote) UnmarshalJSON(bytes []byte) (err error) {
	varPatcheddebAptRemote := _PatcheddebAptRemote{}

	if err = json.Unmarshal(bytes, &varPatcheddebAptRemote); err == nil {
		*o = PatcheddebAptRemote(varPatcheddebAptRemote)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "url")
		delete(additionalProperties, "ca_cert")
		delete(additionalProperties, "client_cert")
		delete(additionalProperties, "client_key")
		delete(additionalProperties, "tls_validation")
		delete(additionalProperties, "proxy_url")
		delete(additionalProperties, "proxy_username")
		delete(additionalProperties, "proxy_password")
		delete(additionalProperties, "username")
		delete(additionalProperties, "password")
		delete(additionalProperties, "pulp_labels")
		delete(additionalProperties, "download_concurrency")
		delete(additionalProperties, "max_retries")
		delete(additionalProperties, "policy")
		delete(additionalProperties, "total_timeout")
		delete(additionalProperties, "connect_timeout")
		delete(additionalProperties, "sock_connect_timeout")
		delete(additionalProperties, "sock_read_timeout")
		delete(additionalProperties, "headers")
		delete(additionalProperties, "rate_limit")
		delete(additionalProperties, "distributions")
		delete(additionalProperties, "components")
		delete(additionalProperties, "architectures")
		delete(additionalProperties, "sync_sources")
		delete(additionalProperties, "sync_udebs")
		delete(additionalProperties, "sync_installer")
		delete(additionalProperties, "gpgkey")
		delete(additionalProperties, "ignore_missing_package_indices")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatcheddebAptRemote struct {
	value *PatcheddebAptRemote
	isSet bool
}

func (v NullablePatcheddebAptRemote) Get() *PatcheddebAptRemote {
	return v.value
}

func (v *NullablePatcheddebAptRemote) Set(val *PatcheddebAptRemote) {
	v.value = val
	v.isSet = true
}

func (v NullablePatcheddebAptRemote) IsSet() bool {
	return v.isSet
}

func (v *NullablePatcheddebAptRemote) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatcheddebAptRemote(val *PatcheddebAptRemote) *NullablePatcheddebAptRemote {
	return &NullablePatcheddebAptRemote{value: val, isSet: true}
}

func (v NullablePatcheddebAptRemote) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatcheddebAptRemote) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


