# *Percona XtraBackup* 2.4.21


* **Date**

    November 12, 2020



* **Installation**

    [Installing Percona XtraBackup](https://www.percona.com/doc/percona-xtrabackup/2.4/installation.html)


Percona XtraBackup enables MySQL backups without blocking user queries, making it ideal
for companies with large data sets and mission-critical applications that cannot tolerate
long periods of downtime. Offered free as an open source solution, it drives down backup
costs while providing unique features for MySQL backups.

## New Features

* [PXB-2112](https://jira.percona.com/browse/PXB-2112): xbcloud: support `storage_class` option with `--storage=s3` (Thanks to user rluisr for reporting this issue)

## Improvements

* [PXB-2254](https://jira.percona.com/browse/PXB-2254): Redesign `--lock-ddl-per-table`

* [PXB-2252](https://jira.percona.com/browse/PXB-2252): Introduce debug option to print the redo log records scanned and applied

## Bugs Fixed

* [PXB-793](https://jira.percona.com/browse/PXB-793): Fix syntax error when executing `--lock-ddl-per-table` queries

* [PXB-2165](https://jira.percona.com/browse/PXB-2165): Modify xbcloud to store backups using s3 access key parameters if AWS access key env variables are set

* [PXB-2164](https://jira.percona.com/browse/PXB-2164): Modify xbcloud to return the error when the backup doesn’t exist in s3 bucket

* [PXB-953](https://jira.percona.com/browse/PXB-953): Improve stdout for the end of usage of `--lock-ddl-per-table`

* [PXB-2279](https://jira.percona.com/browse/PXB-2279): Xbcloud: Upload failed: backup is incomplete (Thanks to user mrmainnet for reporting this issue)

* [PXB-2127](https://jira.percona.com/browse/PXB-2127): Modify xbcloud to upload backups with empty database to min.io storage (Thanks to user hartland for reporting this issue)

* [PXB-2275](https://jira.percona.com/browse/PXB-2275): Modify backup processing to add validations if an encrypted table is created

* [PXB-2272](https://jira.percona.com/browse/PXB-2272): Fixed Regexp from `is_tmp_table` doesn’t account for all temporary tables

* [PXB-2257](https://jira.percona.com/browse/PXB-2257): fixed `--lock-ddl-per-table` to properly close database connection

* [PXB-2249](https://jira.percona.com/browse/PXB-2249): Verify perl binary exists before completing version check

* [PXB-2239](https://jira.percona.com/browse/PXB-2239): Partitioned table is not restored correctly when partitions are changed during backup

* [PXB-2238](https://jira.percona.com/browse/PXB-2238): Provide binary tarball with shared libs and glibc suffix & minimal tarballs

* [PXB-2216](https://jira.percona.com/browse/PXB-2216): Verify encryption version when opening tables to avoid changing encryption version

* [PXB-2202](https://jira.percona.com/browse/PXB-2202): Modify Xbcloud to display an error when xtrabackup fails to create a backup

* [PXB-2198](https://jira.percona.com/browse/PXB-2198): Modify xbcloud delete to return the error when the backup doesn’t exist in s3 bucket
