/* Generated by re2c 0.13.5 */
/*
 * phpdbg_lexer.l
 */

#include "phpdbg.h"
#include "phpdbg_cmd.h"

#include "phpdbg_parser.h"

#define LEX(v) (PHPDBG_G(lexer).v)

#define YYCTYPE unsigned char
#define YYSETCONDITION(x) LEX(state) = x;
#define YYGETCONDITION() LEX(state)
#define YYCURSOR LEX(cursor)
#define YYMARKER LEX(marker)
#define YYCTXMARKER LEX(ctxmarker)
#define yyleng LEX(len)
#define yytext ((char*) LEX(text))
#undef YYDEBUG
#define YYDEBUG(a, b)
#define YYFILL(n)

#define NORMAL 0
#define PRE_RAW 1
#define RAW 2
#define INITIAL 3

ZEND_EXTERN_MODULE_GLOBALS(phpdbg)

void phpdbg_init_lexer (phpdbg_param_t *stack, char *input) {
	PHPDBG_G(parser_stack) = stack;

	YYSETCONDITION(INITIAL);

	LEX(text) = YYCURSOR = (unsigned char *) input;
	LEX(len) = strlen(input);
}

static int unescape_string(char *s) {
	switch (*s) {
		case '\'':
		case '\"': {
			char start = *s;
			size_t off = 1;
			do {
				if (s[off] == '\\') {
					off++;
				}
				*s = s[off];
			} while ((++s)[off] != start);
			return off + 1;
		}
	}

	return 0;
}

int phpdbg_lex (phpdbg_param_t* yylval) {

restart:
	LEX(text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 2) {
		if (YYGETCONDITION() < 1) {
			goto yyc_NORMAL;
		} else {
			goto yyc_PRE_RAW;
		}
	} else {
		if (YYGETCONDITION() < 3) {
			goto yyc_RAW;
		} else {
			goto yyc_INITIAL;
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(4);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy8;
					goto yy13;
				} else {
					if (yych <= '\t') goto yy2;
					if (yych <= '\n') goto yy8;
					goto yy13;
				}
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy13;
				} else {
					if (yych <= ' ') goto yy4;
					if (yych <= '"') goto yy13;
					goto yy7;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy13;
					goto yy9;
				} else {
					if (yych <= 'Q') goto yy13;
					if (yych <= 'R') goto yy12;
					goto yy10;
				}
			} else {
				if (yych <= 'q') {
					if (yych == 'e') goto yy9;
					goto yy13;
				} else {
					if (yych <= 'r') goto yy11;
					if (yych <= 's') goto yy10;
					goto yy13;
				}
			}
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 128) {
			goto yy4;
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(NORMAL);

	YYCURSOR = LEX(text);
	goto restart;
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(5, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy4;
		}
		YYDEBUG(6, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'V') goto yy24;
		if (yych == 'v') goto yy24;
		goto yy3;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy20;
		if (yych == 'h') goto yy20;
		goto yy3;
yy11:
		YYDEBUG(11, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy17;
			} else {
				if (yych == '\r') goto yy17;
				goto yy3;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= ' ') goto yy17;
				if (yych <= 'T') goto yy3;
				goto yy14;
			} else {
				if (yych == 'u') goto yy14;
				goto yy3;
			}
		}
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy14;
		if (yych == 'u') goto yy14;
		goto yy3;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy16;
		if (yych == 'n') goto yy16;
yy15:
		YYDEBUG(15, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy3;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych != '\t') goto yy15;
		} else {
			if (yych <= '\r') goto yy17;
			if (yych != ' ') goto yy15;
		}
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy17;
		} else {
			if (yych <= '\r') goto yy17;
			if (yych == ' ') goto yy17;
		}
		YYDEBUG(19, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_RUN;
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych != '\t') goto yy15;
		} else {
			if (yych <= '\r') goto yy21;
			if (yych != ' ') goto yy15;
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(22, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy21;
		} else {
			if (yych <= '\r') goto yy21;
			if (yych == ' ') goto yy21;
		}
		YYDEBUG(23, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_SHELL;
}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych != '\t') goto yy15;
		} else {
			if (yych <= '\r') goto yy25;
			if (yych != ' ') goto yy15;
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy25;
		} else {
			if (yych <= '\r') goto yy25;
			if (yych == ' ') goto yy25;
		}
		YYDEBUG(27, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_EVAL;
}
	}
/* *********************************** */
yyc_NORMAL:
	{
		static const unsigned char yybm[] = {
			/* table 1 .. 8: 0 */
			  0, 242, 242, 242, 242, 242, 242, 242, 
			242, 160,   0, 242, 242, 160, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			160, 242,  50, 160, 242, 242, 242, 194, 
			242, 242, 242, 242, 242, 242, 243, 242, 
			251, 251, 251, 251, 251, 251, 251, 251, 
			251, 251, 160, 242, 242, 242, 242, 242, 
			242, 254, 254, 254, 254, 254, 254, 246, 
			246, 246, 246, 246, 246, 246, 246, 246, 
			246, 246, 246, 246, 246, 246, 246, 246, 
			246, 246, 246, 242,   2, 242, 242, 242, 
			242, 254, 254, 254, 254, 254, 254, 246, 
			246, 246, 246, 246, 246, 246, 246, 246, 
			246, 246, 246, 246, 246, 246, 246, 246, 
			246, 246, 246, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			242, 242, 242, 242, 242, 242, 242, 242, 
			/* table 9 .. 10: 256 */
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128,  64,   0, 128, 128,  64, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			 64, 128,   0,   0, 128, 128, 128,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(28, *YYCURSOR);
		YYFILL(11);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 64) {
			goto yy30;
		}
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case '\n':	goto yy35;
		case '"':	goto yy43;
		case '#':	goto yy33;
		case '\'':	goto yy45;
		case '-':	goto yy37;
		case '.':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy46;
		case '0':	goto yy49;
		case ':':	goto yy40;
		case 'D':
		case 'd':	goto yy50;
		case 'E':
		case 'e':	goto yy51;
		case 'F':
		case 'f':	goto yy52;
		case 'I':
		case 'i':	goto yy39;
		case 'N':
		case 'n':	goto yy53;
		case 'O':
		case 'o':	goto yy54;
		case 'T':
		case 't':	goto yy55;
		case 'Y':
		case 'y':	goto yy56;
		case 'Z':	goto yy57;
		case 'z':	goto yy58;
		default:	goto yy41;
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(31, *YYCURSOR);
		if (yybm[256+yych] & 64) {
			goto yy30;
		}
		YYDEBUG(32, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy33:
		YYDEBUG(33, *YYCURSOR);
		YYCTXMARKER = YYCURSOR + 1;
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '.') {
			if (yych <= ',') goto yy34;
			if (yych <= '-') goto yy145;
			goto yy146;
		} else {
			if (yych <= '/') goto yy34;
			if (yych <= '9') goto yy146;
		}
yy34:
		YYDEBUG(34, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy35:
		YYDEBUG(35, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(36, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy46;
		}
		if (yych == 'r') goto yy135;
		goto yy42;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng - unescape_string(yytext));
	yylval->len = yyleng;
	return T_ID;
}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy131;
		if (yych == 'f') goto yy131;
		goto yy42;
yy40:
		YYDEBUG(40, *YYCURSOR);
		YYCTXMARKER = YYCURSOR + 1;
		yych = *++YYCURSOR;
		if (yych == ':') goto yy129;
		if (yych == '\\') goto yy67;
		goto yy127;
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy42:
		YYDEBUG(42, *YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy41;
		}
		if (yych == '"') goto yy61;
		if (yych <= '#') goto yy38;
		if (yych <= '9') goto yy61;
		goto yy60;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy61;
		goto yy119;
yy44:
		YYDEBUG(44, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy34;
				} else {
					goto yy38;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy48;
				} else {
					goto yy75;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy106;
				} else {
					goto yy66;
				}
			} else {
				goto yy141;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy61;
		goto yy108;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy46;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy48;
				if (yych <= 0x08) goto yy41;
			} else {
				if (yych == '\r') goto yy48;
				if (yych <= 0x1F) goto yy41;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy41;
				if (yych <= '"') goto yy61;
				if (yych >= '$') goto yy41;
			} else {
				if (yych <= '\'') goto yy61;
				if (yych == ':') goto yy60;
				goto yy41;
			}
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = atoi(yytext);
	return T_DIGITS;
}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy46;
		}
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy48;
				if (yych <= 0x08) goto yy42;
				goto yy48;
			} else {
				if (yych == '\r') goto yy48;
				goto yy42;
			}
		} else {
			if (yych <= '#') {
				if (yych <= ' ') goto yy48;
				if (yych <= '"') goto yy42;
				goto yy48;
			} else {
				if (yych == 'x') goto yy103;
				goto yy42;
			}
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy97;
		if (yych == 'i') goto yy97;
		goto yy42;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy92;
		if (yych == 'n') goto yy92;
		goto yy42;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy89;
		if (yych == 'a') goto yy89;
		goto yy42;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy86;
		if (yych == 'o') goto yy86;
		goto yy42;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych == 'F') goto yy85;
			if (yych <= 'M') goto yy42;
			goto yy80;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy42;
				goto yy85;
			} else {
				if (yych == 'n') goto yy80;
				goto yy42;
			}
		}
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy83;
		if (yych == 'r') goto yy83;
		goto yy42;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy79;
		if (yych == 'e') goto yy79;
		goto yy42;
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy76;
		goto yy42;
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != 'e') goto yy42;
		YYDEBUG(59, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'n') goto yy70;
		goto yy42;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy64;
		if (yych == '\\') goto yy67;
		goto yy44;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy62:
		YYDEBUG(62, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy61;
		}
		if (yych <= '9') goto yy44;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '/') goto yy44;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '/') goto yy44;
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_PROTO;
}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy38;
				if (yych <= 0x08) goto yy67;
				goto yy38;
			} else {
				if (yych == '\r') goto yy38;
				if (yych <= 0x1F) goto yy67;
				goto yy38;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy67;
				if (yych <= '#') goto yy38;
				goto yy67;
			} else {
				if (yych <= '\'') goto yy38;
				if (yych != ':') goto yy67;
			}
		}
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\\') goto yy67;
		goto yy44;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != 'd') goto yy42;
		YYDEBUG(71, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '_') goto yy42;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy73;
		}
		goto yy42;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy73;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy75;
				if (yych <= 0x08) goto yy41;
			} else {
				if (yych == '\r') goto yy75;
				if (yych <= 0x1F) goto yy41;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy41;
				if (yych <= '"') goto yy61;
				if (yych >= '$') goto yy41;
			} else {
				if (yych <= '\'') goto yy61;
				if (yych == ':') goto yy60;
				goto yy41;
			}
		}
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, OP_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_OPCODE;
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != 'N') goto yy42;
		YYDEBUG(77, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != 'D') goto yy42;
		YYDEBUG(78, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy72;
		goto yy42;
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy80;
		if (yych != 's') goto yy42;
yy80:
		YYDEBUG(80, *YYCURSOR);
		YYCTXMARKER = YYCURSOR + 1;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy81;
			if (yych <= 0x08) goto yy42;
			if (yych >= '\v') goto yy42;
		} else {
			if (yych <= '\r') goto yy81;
			if (yych != ' ') goto yy42;
		}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 1;
	return T_TRUTHY;
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy84;
		if (yych != 'u') goto yy42;
yy84:
		YYDEBUG(84, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy80;
		if (yych == 'e') goto yy80;
		goto yy42;
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy86;
		if (yych != 'f') goto yy42;
yy86:
		YYDEBUG(86, *YYCURSOR);
		YYCTXMARKER = YYCURSOR + 1;
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy87;
			if (yych <= 0x08) goto yy42;
			if (yych >= '\v') goto yy42;
		} else {
			if (yych <= '\r') goto yy87;
			if (yych != ' ') goto yy42;
		}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(88, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 0;
	return T_FALSY;
}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy90;
		if (yych != 'l') goto yy42;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy91;
		if (yych != 's') goto yy42;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy86;
		if (yych == 'e') goto yy86;
		goto yy42;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy93;
		if (yych != 'a') goto yy42;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy94;
		if (yych != 'b') goto yy42;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy95;
		if (yych != 'l') goto yy42;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy96;
		if (yych != 'e') goto yy42;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy80;
		if (yych == 'd') goto yy80;
		goto yy42;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy98;
		if (yych != 's') goto yy42;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy99;
		if (yych != 'a') goto yy42;
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy100;
		if (yych != 'b') goto yy42;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy101;
		if (yych != 'l') goto yy42;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy102;
		if (yych != 'e') goto yy42;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy86;
		if (yych == 'd') goto yy86;
		goto yy42;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy104;
		}
		goto yy42;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(105, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy104;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy106;
				if (yych <= 0x08) goto yy41;
			} else {
				if (yych == '\r') goto yy106;
				if (yych <= 0x1F) goto yy41;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy41;
				if (yych <= '"') goto yy61;
				if (yych >= '$') goto yy41;
			} else {
				if (yych <= '\'') goto yy61;
				if (yych == ':') goto yy60;
				goto yy41;
			}
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, ADDR_PARAM);
	yylval->addr = strtoul(yytext, 0, 16);
	return T_ADDR;
}
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy108:
		YYDEBUG(108, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy107;
		}
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy44;
			if (yych >= '\n') goto yy44;
		} else {
			if (yych <= '&') goto yy109;
			if (yych <= '\'') goto yy117;
			if (yych <= '[') goto yy111;
			goto yy112;
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy110:
		YYDEBUG(110, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy109;
		}
		if (yych <= '&') goto yy44;
		if (yych <= '\'') goto yy114;
		goto yy115;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy113;
		goto yy110;
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy44;
				if (yych <= 0x08) goto yy61;
				if (yych <= '\n') goto yy44;
				goto yy61;
			} else {
				if (yych <= '\r') goto yy44;
				if (yych == ' ') goto yy44;
				goto yy61;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '#') goto yy44;
				if (yych == '\'') goto yy107;
				goto yy61;
			} else {
				if (yych <= ':') goto yy63;
				if (yych == '\\') goto yy107;
				goto yy61;
			}
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy116;
		goto yy110;
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy38;
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\'') goto yy109;
		if (yych == '\\') goto yy109;
		goto yy44;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy66;
		if (yych == '\n') goto yy66;
		goto yy110;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy38;
				goto yy62;
			} else {
				if (yych <= '\n') goto yy38;
				if (yych <= '\f') goto yy62;
				goto yy38;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy62;
				goto yy38;
			} else {
				if (yych == '#') goto yy38;
				goto yy62;
			}
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy119:
		YYDEBUG(119, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy118;
		}
		if (yych <= '!') {
			if (yych <= 0x00) goto yy44;
			if (yych == '\n') goto yy44;
		} else {
			if (yych <= '"') goto yy117;
			if (yych <= '#') goto yy120;
			if (yych <= '[') goto yy122;
			goto yy123;
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy121:
		YYDEBUG(121, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy120;
		}
		if (yych <= '!') goto yy44;
		if (yych <= '"') goto yy114;
		goto yy125;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy124;
		goto yy121;
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy44;
				if (yych <= 0x08) goto yy61;
				goto yy44;
			} else {
				if (yych == '\r') goto yy44;
				if (yych <= 0x1F) goto yy61;
				goto yy44;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '!') goto yy61;
				if (yych <= '"') goto yy118;
				if (yych <= '#') goto yy44;
				goto yy61;
			} else {
				if (yych <= ':') goto yy63;
				if (yych == '\\') goto yy118;
				goto yy61;
			}
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy126;
		goto yy121;
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '"') goto yy120;
		if (yych == '\\') goto yy120;
		goto yy44;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy66;
		if (yych == '\n') goto yy66;
		goto yy121;
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_COLON;
}
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_DCOLON;
}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych != '\t') goto yy42;
		} else {
			if (yych <= '\r') goto yy132;
			if (yych != ' ') goto yy42;
		}
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(133, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy132;
		} else {
			if (yych <= '\r') goto yy132;
			if (yych == ' ') goto yy132;
		}
		YYDEBUG(134, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_IF;
}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych != '\t') goto yy42;
			} else {
				if (yych <= '\r') goto yy136;
				if (yych <= 0x1F) goto yy42;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy42;
				if (yych <= '-') goto yy138;
				goto yy139;
			} else {
				if (yych <= '/') goto yy42;
				if (yych <= '9') goto yy139;
				goto yy42;
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(137, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych == '\t') goto yy136;
				goto yy44;
			} else {
				if (yych <= '\r') goto yy136;
				if (yych <= 0x1F) goto yy44;
				goto yy136;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy44;
				if (yych <= '-') goto yy142;
				goto yy143;
			} else {
				if (yych <= '/') goto yy44;
				if (yych <= '9') goto yy143;
				goto yy44;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '.') goto yy139;
		if (yych <= '/') goto yy42;
		if (yych >= ':') goto yy42;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyaccept = 6;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(140, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy141;
				if (yych <= 0x08) goto yy41;
				if (yych >= '\v') goto yy41;
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy41;
				} else {
					if (yych <= ' ') goto yy141;
					if (yych <= '!') goto yy41;
					goto yy61;
				}
			}
		} else {
			if (yych <= '-') {
				if (yych <= '#') goto yy141;
				if (yych == '\'') goto yy61;
				goto yy41;
			} else {
				if (yych <= '/') {
					if (yych <= '.') goto yy139;
					goto yy41;
				} else {
					if (yych <= '9') goto yy139;
					if (yych <= ':') goto yy60;
					goto yy41;
				}
			}
		}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy143;
		if (yych <= '/') goto yy44;
		if (yych >= ':') goto yy44;
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(144, *YYCURSOR);
		if (yych == '.') goto yy143;
		if (yych <= '/') goto yy141;
		if (yych <= '9') goto yy143;
		goto yy141;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy146;
		if (yych <= '/') goto yy44;
		if (yych >= ':') goto yy44;
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		if (yych == '.') goto yy146;
		if (yych <= '/') goto yy148;
		if (yych <= '9') goto yy146;
yy148:
		YYDEBUG(148, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_POUND;
}
	}
/* *********************************** */
yyc_PRE_RAW:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,   0,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0, 128,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(149, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy157;
				if (yych <= 0x08) goto yy159;
			} else {
				if (yych <= '\n') goto yy157;
				if (yych <= '\f') goto yy159;
			}
		} else {
			if (yych <= '"') {
				if (yych == ' ') goto yy153;
				goto yy159;
			} else {
				if (yych <= '#') goto yy156;
				if (yych == '-') goto yy158;
				goto yy159;
			}
		}
		YYDEBUG(151, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 64) {
			goto yy153;
		}
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);

	YYCURSOR = LEX(text);
	goto restart;
}
yy153:
		YYDEBUG(153, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(154, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy153;
		}
		YYDEBUG(155, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy152;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy152;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'r') goto yy160;
		goto yy152;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy152;
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy164;
		}
		if (yych <= '\r') {
			if (yych == '\t') goto yy160;
			if (yych >= '\r') goto yy160;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy160;
			} else {
				if (yych == '-') goto yy163;
			}
		}
yy162:
		YYDEBUG(162, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy152;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy164;
		}
		goto yy162;
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(165, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy164;
		}
		YYDEBUG(166, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
	}
/* *********************************** */
yyc_RAW:
	{
		static const unsigned char yybm[] = {
			  0, 232, 232, 232, 232, 232, 232, 232, 
			232, 236,   0, 232, 232, 236, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			236, 232,  32, 224, 232, 232, 232, 128, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232,  16, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
		};
		YYDEBUG(167, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy169;
		}
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy174;
				goto yy176;
			} else {
				if (yych <= '\n') goto yy174;
				if (yych <= '!') goto yy176;
				goto yy180;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy172;
				if (yych <= '&') goto yy176;
				goto yy182;
			} else {
				if (yych == '\\') goto yy178;
				goto yy176;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy169;
		}
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych >= 0x01) goto yy176;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy176;
				goto yy180;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy171;
				if (yych <= '&') goto yy176;
				goto yy182;
			} else {
				if (yych == '\\') goto yy178;
				goto yy176;
			}
		}
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrdup(yytext);
	yylval->len = yyleng;
	return T_INPUT;
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(173, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy174:
		YYDEBUG(174, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(175, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(177, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy176;
		}
		if (yych == '"') goto yy180;
		if (yych <= '#') goto yy171;
		if (yych <= '[') goto yy182;
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(179, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy178;
		}
		if (yych <= '!') {
			if (yych <= 0x00) goto yy171;
			if (yych == '\n') goto yy171;
			goto yy176;
		} else {
			if (yych <= '"') goto yy210;
			if (yych == '\'') goto yy192;
			goto yy176;
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy206;
		}
		if (yych >= '\\') goto yy208;
yy181:
		YYDEBUG(181, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy171;
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy183;
		}
		if (yych <= '[') goto yy181;
		goto yy185;
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy183;
		}
		if (yych <= '&') goto yy181;
		if (yych <= '\'') goto yy176;
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(186, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy183;
		}
		if (yych <= '&') goto yy181;
		if (yych >= '(') goto yy185;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy171;
				goto yy187;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy187;
				goto yy191;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy183;
				if (yych <= '&') goto yy187;
				goto yy192;
			} else {
				if (yych != '\\') goto yy187;
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= 0x00) goto yy171;
			if (yych == '\n') goto yy171;
			goto yy187;
		} else {
			if (yych <= '"') goto yy202;
			if (yych == '\\') goto yy189;
			goto yy187;
		}
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		if (yych <= '!') goto yy181;
		if (yych <= '"') goto yy183;
		if (yych <= '[') goto yy193;
		goto yy197;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy171;
				goto yy187;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy187;
				goto yy191;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy183;
				if (yych <= '&') goto yy187;
				goto yy182;
			} else {
				if (yych == '\\') goto yy189;
				goto yy187;
			}
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy171;
				goto yy193;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy193;
				goto yy210;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy206;
				if (yych <= '&') goto yy193;
				goto yy205;
			} else {
				if (yych == '\\') goto yy211;
				goto yy193;
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		if (yych <= '!') goto yy181;
		if (yych <= '"') goto yy187;
		if (yych <= '[') goto yy193;
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(198, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		if (yych <= '!') goto yy181;
		if (yych >= '\\') goto yy197;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy171;
				goto yy199;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy199;
				goto yy202;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy195;
				if (yych <= '&') goto yy199;
			} else {
				if (yych == '\\') goto yy203;
				goto yy199;
			}
		}
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy171;
				goto yy199;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy199;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy195;
				if (yych <= '&') goto yy199;
				goto yy205;
			} else {
				if (yych == '\\') goto yy203;
				goto yy199;
			}
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy171;
				goto yy199;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy199;
				goto yy191;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy195;
				if (yych <= '&') goto yy199;
				goto yy201;
			} else {
				if (yych != '\\') goto yy199;
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy171;
			if (yych <= '\t') goto yy199;
			goto yy171;
		} else {
			if (yych == '\\') goto yy203;
			goto yy199;
		}
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy195;
		}
		if (yych <= '!') goto yy181;
		if (yych <= '"') goto yy187;
		if (yych >= '\\') goto yy197;
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(207, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy206;
		}
		if (yych <= '!') goto yy181;
		if (yych <= '"') goto yy176;
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy206;
		}
		if (yych <= '!') goto yy181;
		if (yych <= '"') goto yy193;
		goto yy208;
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy171;
				goto yy193;
			} else {
				if (yych <= '\n') goto yy171;
				if (yych <= '!') goto yy193;
				goto yy180;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy206;
				if (yych <= '&') goto yy193;
				goto yy205;
			} else {
				if (yych != '\\') goto yy193;
			}
		}
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x00) goto yy171;
			if (yych == '\n') goto yy171;
			goto yy193;
		} else {
			if (yych <= '\'') goto yy201;
			if (yych == '\\') goto yy211;
			goto yy193;
		}
	}
}

}
