/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.tks;

import com.fasterxml.jackson.databind.JsonNode;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.group.GroupClient;
import com.netscape.certsrv.selftests.SelfTestClient;
import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.certsrv.user.UserClient;
import com.netscape.cmsutil.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class TKSClient
extends SubsystemClient {
    public TKSClient(PKIClient client) throws Exception {
        super(client, "tks");
        this.init();
    }

    public void init() throws Exception {
        this.addClient(new GroupClient(this));
        this.addClient(new SelfTestClient(this.client, this.name));
        this.addClient(new TPSConnectorClient(this.client, this.name));
        this.addClient(new UserClient(this));
    }

    public void importTransportCert(URI secdomainURI, String transportNickname, String transportCert, String sessionID) throws Exception {
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"name", (Object)transportNickname);
        content.putSingle((Object)"xmlOutput", (Object)"true");
        content.putSingle((Object)"sessionID", (Object)sessionID);
        content.putSingle((Object)"auth_hostname", (Object)secdomainURI.getHost());
        content.putSingle((Object)"auth_port", (Object)("" + secdomainURI.getPort()));
        content.putSingle((Object)"certificate", (Object)transportCert);
        String path = "tks/admin/tks/importTransportCert";
        String response = this.client.post(path, (MultivaluedMap<String, String>)content, String.class);
        logger.debug("TKSClient: Response: " + response);
        if (response == null || response.equals("")) {
            logger.error("TKSClient: No response");
            throw new IOException("No response");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        JSONObject jsonObj = new JSONObject(bis);
        JsonNode responseNode = jsonObj.getJsonNode().get("Response");
        String status = responseNode.get("Status").asText();
        logger.debug("TKSClient: Status: " + status);
        if (status.equals(AUTH_FAILURE)) {
            throw new EAuthException(AUTH_FAILURE);
        }
        if (!status.equals(SUCCESS)) {
            String error = jsonObj.getJsonNode().get("Error").asText();
            throw new IOException(error);
        }
        logger.debug("TKSClient: Installed transport cert");
    }
}

