/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.profile.ProfileCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestProfileShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRequestProfileShowCLI.class);
    public CACertRequestCLI certRequestCLI;

    public CACertRequestProfileShowCLI(CACertRequestCLI certRequestCLI) {
        super("profile-show", "Get Enrollment template", (CLI)certRequestCLI);
        this.certRequestCLI = certRequestCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Profile ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output filename");
        option.setArgName("filename");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing Profile ID.");
        }
        String profileId = cmdArgs[0];
        String filename = null;
        if (cmd.hasOption("output") && ((filename = cmd.getOptionValue("output")) == null || filename.trim().length() == 0)) {
            throw new Exception("Missing output file name.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certRequestCLI.getCertClient();
        CertEnrollmentRequest request = certClient.getEnrollmentTemplate(profileId);
        MainCLI.printMessage("Enrollment Template for Profile \"" + profileId + "\"");
        if (filename != null) {
            ProfileCLI.saveEnrollmentTemplateToFile(filename, request);
        } else {
            ProfileCLI.printEnrollmentTemplate(request);
        }
    }
}

