/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.client;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.client.ClientCLI;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertValidateCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ClientCertValidateCLI.class);
    public ClientCLI clientCLI;

    public ClientCertValidateCLI(ClientCLI clientCLI) {
        super("cert-validate", "Validate certificate", (CLI)clientCLI);
        this.clientCLI = clientCLI;
    }

    public void createOptions() {
        Option option = new Option(null, "certusage", true, "Certificate usage: CheckAllUsages, SSLClient, SSLServer, SSLServerWithStepUp, SSLCA, EmailSigner, EmailRecipient, ObjectSigner, UserCertImport, VerifyCA, ProtectedObjectSigner, StatusResponder, AnyCA, IPsec.");
        option.setArgName("certusage");
        this.options.addOption(option);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " nickname", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("Invalid number of arguments.");
        }
        String nickname = cmdArgs[0];
        String certusage = cmd.getOptionValue("certusage");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        if (certusage == null) {
            Set usages = CertUtil.getCertificateUsages((String)nickname);
            System.out.println("Cert usages: " + StringUtils.join((Iterable)usages, (String)", "));
            return;
        }
        try {
            CertUtil.verifyCertificateUsage((String)nickname, (String)certusage);
            System.out.println("Certificate is valid");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }
}

