/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs11;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs11.PKCS11KeyCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.Key;
import java.security.KeyStore;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.provider.java.security.JSSLoadStoreParameter;

public class PKCS11KeyRemoveCLI
extends CommandCLI {
    public PKCS11KeyCLI keyCLI;

    public PKCS11KeyRemoveCLI(PKCS11KeyCLI keyCLI) {
        super("del", "Remove PKCS #11 key", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <Key ID>", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing key ID.");
        }
        String alias = cmdArgs[0];
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        String tokenName = this.getConfig().getTokenName();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
        KeyStore ks = KeyStore.getInstance("pkcs11");
        ks.load((KeyStore.LoadStoreParameter)new JSSLoadStoreParameter(token));
        Key key = ks.getKey(alias, null);
        if (key == null) {
            throw new Exception("Key not found: " + alias);
        }
        ks.deleteEntry(alias);
    }
}

