/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs12;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs12.PKCS12CertCLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.netscape.security.pkcs.PKCS12;
import org.mozilla.jss.netscape.security.pkcs.PKCS12Util;
import org.mozilla.jss.util.Password;

public class PKCS12CertImportCLI
extends CommandCLI {
    public PKCS12CertCLI certCLI;

    public PKCS12CertImportCLI(PKCS12CertCLI certCLI) {
        super("import", "Import certificate into PKCS #12 file", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <nickname> [OPTIONS...]", this.options);
        System.out.println();
        System.out.println("Supported certificate encryption algorithms:");
        for (PBEAlgorithm algorithm : PKCS12Util.SUPPORTED_CERT_ENCRYPTIONS) {
            if (algorithm == null) {
                System.out.println(" - none");
                continue;
            }
            System.out.println(" - " + algorithm);
        }
        System.out.println();
        System.out.println("Supported key encryption algorithms:");
        for (PBEAlgorithm algorithm : PKCS12Util.SUPPORTED_KEY_ENCRYPTIONS) {
            if (algorithm == null) {
                System.out.println(" - none");
                continue;
            }
            System.out.println(" - " + algorithm);
        }
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs12-file", true, "PKCS #12 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password", true, "PKCS #12 password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "pkcs12-password-file", true, "PKCS #12 password file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "friendly-name", true, "Friendly name for the certificate in PKCS #12");
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option(null, "cert-encryption", true, "Certificate encryption algorithm (default: none).");
        option.setArgName("algorithm");
        this.options.addOption(option);
        option = new Option(null, "key-encryption", true, "Key encryption algorithm (default: " + PKCS12Util.DEFAULT_KEY_ENCRYPTION_NAME + ").");
        option.setArgName("algorithm");
        this.options.addOption(option);
        this.options.addOption(null, "append", false, "Import into an existing PKCS #12 file");
        this.options.addOption(null, "no-trust-flags", false, "Do not include trust flags");
        this.options.addOption(null, "no-key", false, "Do not include private key");
        this.options.addOption(null, "no-chain", false, "Do not include certificate chain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String passwordFile;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length == 0) {
            throw new Exception("Missing certificate nickname.");
        }
        String nickname = cmdArgs[0];
        String filename = cmd.getOptionValue("pkcs12-file");
        if (filename == null) {
            throw new Exception("Missing PKCS #12 file.");
        }
        String passwordString = cmd.getOptionValue("pkcs12-password");
        if (passwordString == null && (passwordFile = cmd.getOptionValue("pkcs12-password-file")) != null) {
            try (BufferedReader in = new BufferedReader(new FileReader(passwordFile));){
                passwordString = in.readLine();
            }
        }
        if (passwordString == null) {
            throw new Exception("Missing PKCS #12 password.");
        }
        String friendlyName = cmd.getOptionValue("friendly-name");
        String certEncryption = cmd.getOptionValue("cert-encryption");
        String keyEncryption = cmd.getOptionValue("key-encryption");
        boolean append = cmd.hasOption("append");
        boolean includeTrustFlags = !cmd.hasOption("no-trust-flags");
        boolean includeKey = !cmd.hasOption("no-key");
        boolean includeChain = !cmd.hasOption("no-chain");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        Password password = new Password(passwordString.toCharArray());
        try {
            PKCS12Util util = new PKCS12Util();
            if (certEncryption != null) {
                util.setCertEncryption(certEncryption);
            }
            if (keyEncryption != null) {
                util.setKeyEncryption(keyEncryption);
            }
            util.setTrustFlagsEnabled(includeTrustFlags);
            PKCS12 pkcs12 = append && new File(filename).exists() ? util.loadFromFile(filename, password) : new PKCS12();
            util.loadCertFromNSS(pkcs12, nickname, includeKey, includeChain, friendlyName);
            util.storeIntoFile(pkcs12, filename, password);
        }
        finally {
            password.clear();
        }
        MainCLI.printMessage("Imported certificate \"" + nickname + "\"");
    }
}

