/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs7;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs7.PKCS7CLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7ImportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(PKCS7ImportCLI.class);
    public PKCS7CLI pkcs7CLI;

    public PKCS7ImportCLI(PKCS7CLI pkcs7CLI) {
        super("import", "Import PKCS #7 file into NSS database", (CLI)pkcs7CLI);
        this.pkcs7CLI = pkcs7CLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] [nickname]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs7", true, "PKCS #7 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "input-file", true, "DEPRECATED: PKCS #7 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "trust", true, "Trust flags");
        option.setArgName("flags");
        this.options.addOption(option);
        option = new Option(null, "trust-flags", true, "DEPRECATED: Trust flags");
        option.setArgName("flags");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String input;
        String trustFlags;
        String[] cmdArgs = cmd.getArgs();
        String nickname = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String filename = cmd.getOptionValue("pkcs7");
        if (filename == null && (filename = cmd.getOptionValue("input-file")) != null) {
            logger.warn("The --input-file has been deprecated. Use --pkcs7 instead.");
        }
        if ((trustFlags = cmd.getOptionValue("trust")) == null && (trustFlags = cmd.getOptionValue("trust-flags")) != null) {
            logger.warn("The --trust-flags has been deprecated. Use --trust instead.");
        }
        if (filename == null) {
            logger.info("Loading PKCS #7 data from standard input");
            input = IOUtils.toString((InputStream)System.in, (String)"UTF-8").trim();
        } else {
            logger.info("Loading PKCS #7 data from " + filename);
            input = new String(Files.readAllBytes(Paths.get(filename, new String[0]))).trim();
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKCS7 pkcs7 = new PKCS7(input);
        for (X509Certificate cert : pkcs7.getCertificates()) {
            logger.info("- " + cert.getSubjectDN());
        }
        CryptoUtil.importPKCS7((PKCS7)pkcs7, (String)nickname, (String)trustFlags);
    }
}

