/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.io.IOException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.dogtagpki.acme.database.ACMEDatabase;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ACMEManagedService
public class ACMERequestFilter
implements ContainerRequestFilter {
    public static Logger logger = LoggerFactory.getLogger(ACMERequestFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ACMEEngine engine = ACMEEngine.getInstance();
        ACMEDatabase database = engine.getDatabase();
        Boolean enabled = null;
        try {
            enabled = database.getEnabled();
        }
        catch (Exception e) {
            throw new IOException("Unable to access ACME database: " + e.getMessage(), e);
        }
        if (enabled == null) {
            enabled = engine.isEnabled();
        }
        if (!enabled.booleanValue()) {
            logger.info("ACMERequestFilter: ACME service is disabled");
            throw new ServiceUnavailableException("ACME service is disabled");
        }
    }
}

