/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.config;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.cmscore.dbs.Database;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.config.ConfigRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDatabase
extends Database<ConfigRecord> {
    public static Logger logger = LoggerFactory.getLogger(ConfigDatabase.class);
    TPSEngine engine = TPSEngine.getInstance();
    TPSEngineConfig configStore = this.engine.getConfig();

    public ConfigDatabase() throws EBaseException {
        super("Configuration");
    }

    public String createFilter(ConfigRecord record, String key) {
        String pattern = record.getPattern();
        if (key == null) {
            return pattern;
        }
        return pattern.replace("$name", key);
    }

    public Collection<ConfigRecord> findRecords(String filter) throws Exception {
        logger.debug("ConfigDatabase.findRecords()");
        ArrayList<ConfigRecord> result = new ArrayList<ConfigRecord>();
        LinkedHashSet<String> configIDs = new LinkedHashSet<String>();
        configIDs.add("Generals");
        String list = this.configStore.get("target.configure.list");
        if (list != null) {
            configIDs.addAll(Arrays.asList(list.split(",")));
        }
        if ((list = this.configStore.get("target.agent_approve.list")) != null) {
            configIDs.addAll(Arrays.asList(list.split(",")));
        }
        for (String configID : configIDs) {
            if (filter != null && !configID.contains(filter)) continue;
            ConfigRecord configData = this.getRecord(configID);
            result.add(configData);
        }
        return result;
    }

    public ConfigRecord getRecord(String configID) throws Exception {
        logger.debug("ConfigDatabase.getRecord(\"" + configID + "\")");
        ConfigRecord record = new ConfigRecord();
        record.setID(configID);
        String displayName = this.configStore.get("target." + configID + ".displayname");
        if (StringUtils.isEmpty((CharSequence)displayName)) {
            throw new ResourceNotFoundException("Configuration " + configID + " not found.");
        }
        record.setDisplayName(displayName);
        String pattern = this.configStore.get("target." + configID + ".pattern");
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            throw new ResourceNotFoundException("Missing pattern for " + configID + " configuration.");
        }
        record.setPattern(pattern.replace("\\|", "|"));
        String list = this.configStore.get("target." + configID + ".list");
        if (!StringUtils.isEmpty((CharSequence)list)) {
            record.setKeys(Arrays.asList(list.split(",")));
        }
        return record;
    }

    public void updateRecord(String configID, ConfigRecord newRecord) throws Exception {
        logger.debug("ConfigDatabase.updateRecord(\"" + configID + "\")");
        this.configStore.put("target." + configID + ".displayname", newRecord.getDisplayName());
        this.configStore.put("target." + configID + ".pattern", newRecord.getPattern());
        this.configStore.put("target." + configID + ".list", StringUtils.join(newRecord.getKeys(), (String)","));
        this.configStore.commit(true);
    }

    public Map<String, String> getProperties(ConfigRecord record, String key) throws EBaseException {
        logger.debug("ConfigDatabase.getProperties(\"" + record.getID() + "\", \"" + key + "\")");
        if (key != null && !record.containsKey(key)) {
            throw new ResourceNotFoundException("Entry does not exist: " + key);
        }
        TreeMap<String, String> properties = new TreeMap<String, String>();
        String filter = this.createFilter(record, key);
        Map map = this.configStore.getProperties();
        for (String name : map.keySet()) {
            if (!name.matches(filter)) continue;
            String value = (String)map.get(name);
            properties.put(name, value);
        }
        return properties;
    }

    public void validateProperties(ConfigRecord record, String key, Map<String, String> properties) throws Exception {
        logger.debug("ConfigDatabase.validateProperties(\"" + record.getID() + "\")");
        String filter = this.createFilter(record, key);
        for (String name : properties.keySet()) {
            if (name.matches(filter)) continue;
            logger.error("Property " + name + " doesn't match filter " + filter + ".");
            throw new BadRequestException("Invalid property: " + name);
        }
    }

    public void addProperties(ConfigRecord record, String key, Map<String, String> properties) throws Exception {
        logger.debug("ConfigDatabase.addProperties(\"" + record.getID() + "\")");
        for (String name : properties.keySet()) {
            String value = properties.get(name);
            this.configStore.put(name, value);
        }
    }

    public void removeProperties(ConfigRecord record, String key) throws Exception {
        logger.debug("ConfigDatabase.removeProperties(\"" + record.getID() + "\")");
        Map<String, String> oldProperties = this.getProperties(record, key);
        for (String name : oldProperties.keySet()) {
            this.configStore.remove(name);
        }
    }

    public void commit() throws Exception {
        logger.debug("ConfigDatabase.commit()");
        this.configStore.commit(true);
    }
}

