/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.SerialNumber;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceRenewal
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceRenewal.class);
    private CAService mService;

    public ServiceRenewal(CAService service) {
        this.mService = service;
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        int l;
        X509CertInfo[] certinfos = request.getExtDataInCertInfoArray("CERT_INFO");
        if (certinfos == null || certinfos[0] == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CERT_REQUEST_NOT_FOUND", (Object[])new Object[]{request.getRequestId().toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        X509CertImpl[] issuedCerts = new X509CertImpl[certinfos.length];
        for (int j = 0; j < issuedCerts.length; ++j) {
            issuedCerts[j] = null;
        }
        String[] svcerrors = new String[certinfos.length];
        for (int k = 0; k < svcerrors.length; ++k) {
            svcerrors[k] = null;
        }
        String rid = request.getRequestId().toString();
        for (int i = 0; i < certinfos.length; ++i) {
            try {
                String renewed;
                String message;
                SerialNumber serialnum = null;
                try {
                    CertificateSerialNumber serialno = (CertificateSerialNumber)certinfos[i].get("serialNumber");
                    if (serialno == null) {
                        logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NULL_SERIAL_NUMBER", (Object[])new Object[0]));
                        throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
                    }
                    serialnum = (SerialNumber)serialno.get("number");
                }
                catch (IOException e) {
                    message = CMS.getLogMessage((String)"CMSCORE_CA_ERROR_GET_CERT", (Object[])new Object[]{e.toString()});
                    logger.error(message, (Throwable)e);
                    throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
                }
                catch (CertificateException e) {
                    message = CMS.getLogMessage((String)"CMSCORE_CA_ERROR_GET_CERT", (Object[])new Object[]{e.toString()});
                    logger.error(message, (Throwable)e);
                    throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
                }
                if (serialnum == null) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_CA_ERROR_GET_CERT", (Object[])new Object[]{""}));
                    throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_RENEWREQ", (String[])new String[0]));
                }
                BigInt serialnumBigInt = serialnum.getNumber();
                BigInteger oldSerialNo = serialnumBigInt.toBigInteger();
                CertRecord certRecord = cr.readCertificateRecord(oldSerialNo);
                if (certRecord == null) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NOT_FROM_CA", (Object[])new Object[]{oldSerialNo.toString()}));
                    svcerrors[i] = new ECAException(CMS.getUserMessage((String)"CMS_CA_CANT_FIND_CERT_SERIAL", (String[])new String[]{oldSerialNo.toString()})).toString();
                    continue;
                }
                String certStatus = certRecord.getStatus();
                if (certStatus.equals("REVOKED") || certStatus.equals("REVOKED_EXPIRED")) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_CA_RENEW_REVOKED", (Object[])new Object[]{oldSerialNo.toString()}));
                    svcerrors[i] = new ECAException(CMS.getUserMessage((String)"CMS_CA_CANNOT_RENEW_REVOKED_CERT", (String[])new String[]{"0x" + oldSerialNo.toString(16)})).toString();
                    continue;
                }
                MetaInfo metaInfo = certRecord.getMetaInfo();
                if (metaInfo != null && (renewed = (String)metaInfo.get("renewedCertSerialNo")) != null) {
                    BigInteger serial = new BigInteger(renewed);
                    X509CertImpl cert = cr.getX509Certificate(serial);
                    if (cert == null) {
                        logger.error(CMS.getLogMessage((String)"CMSCORE_CA_MISSING_RENEWED", (Object[])new Object[]{serial.toString()}));
                        svcerrors[i] = new ECAException(CMS.getUserMessage((String)"CMS_CA_ERROR_GETTING_RENEWED_CERT", (String[])new String[]{oldSerialNo.toString(), serial.toString()})).toString();
                        continue;
                    }
                    CertRecord cRecord = cr.readCertificateRecord(serial);
                    if (cRecord == null) {
                        logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NOT_FROM_CA", (Object[])new Object[]{serial.toString()}));
                        svcerrors[i] = new ECAException(CMS.getUserMessage((String)"CMS_CA_CANT_FIND_CERT_SERIAL", (String[])new String[]{serial.toString()})).toString();
                        continue;
                    }
                    String status = cRecord.getStatus();
                    if (status.equals("REVOKED") || status.equals("REVOKED_EXPIRED")) {
                        logger.debug("It is already revoked or Expired !!!");
                    } else {
                        logger.debug("It is still new !!!");
                        issuedCerts[i] = cert;
                        continue;
                    }
                }
                issuedCerts[i] = this.mService.issueX509Cert(rid, certinfos[i], true, oldSerialNo);
                this.mService.storeX509Cert(rid, issuedCerts[i], true, oldSerialNo);
                continue;
            }
            catch (ECAException e) {
                svcerrors[i] = e.toString();
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_CANNOT_RENEW", (Object[])new Object[]{Integer.toString(i), request.getRequestId().toString()}), (Throwable)e);
            }
        }
        request.setExtData("issuedCerts", issuedCerts);
        for (l = svcerrors.length - 1; l >= 0 && svcerrors[l] == null; --l) {
        }
        if (l >= 0) {
            request.setExtData("serviceErrors", svcerrors);
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_NO_RENEW", (Object[])new Object[]{request.getRequestId().toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_RENEW_FAILED", (String[])new String[0]));
        }
        return true;
    }
}

