/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.DNSName;
import org.mozilla.jss.netscape.security.x509.EDIPartyName;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.IPAddressName;
import org.mozilla.jss.netscape.security.x509.IssuerAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.OIDName;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RFC822Name;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSIssuerAlternativeNameExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSIssuerAlternativeNameExtension.class);
    private static final String PROP_RFC822_NAME = "rfc822Name";
    private static final String PROP_DNS_NAME = "dNSName";
    private static final String PROP_DIR_NAME = "directoryName";
    private static final String PROP_EDI_NAME = "ediPartyName";
    private static final String PROP_URI_NAME = "URI";
    private static final String PROP_IP_NAME = "iPAddress";
    private static final String PROP_OID_NAME = "OID";
    private static final String PROP_OTHER_NAME = "otherName";

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        IssuerAlternativeNameExtension issuerAltNameExt = null;
        GeneralNames names = null;
        try {
            names = (GeneralNames)((IssuerAlternativeNameExtension)ext).get("issuer_name");
            issuerAltNameExt = new IssuerAlternativeNameExtension(Boolean.valueOf(critical), names);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_ALT_NAME_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return issuerAltNameExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        IssuerAlternativeNameExtension issuerAltNameExt = null;
        int numNames = 0;
        try {
            numNames = config.getInteger("numNames", 0);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_INVALID_NUM_NAMES", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (numNames > 0) {
            GeneralNames names = new GeneralNames();
            for (int i = 0; i < numNames; ++i) {
                String nameType = null;
                try {
                    nameType = config.getString("nameType" + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_UNDEFINED_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_INVALID_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                if (nameType == null || nameType.length() <= 0) continue;
                String name = null;
                try {
                    name = config.getString("name" + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_UNDEFINED_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_INVALID_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                if (name == null || name.length() <= 0) continue;
                if (nameType.equalsIgnoreCase(PROP_DIR_NAME)) {
                    try {
                        X500Name dirName = new X500Name(name);
                        names.addElement((Object)dirName);
                    }
                    catch (IOException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_500NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                    continue;
                }
                if (nameType.equalsIgnoreCase(PROP_RFC822_NAME)) {
                    RFC822Name rfc822Name = new RFC822Name(name);
                    names.addElement((Object)rfc822Name);
                    continue;
                }
                if (nameType.equalsIgnoreCase(PROP_DNS_NAME)) {
                    DNSName dnsName = new DNSName(name);
                    names.addElement((Object)dnsName);
                    continue;
                }
                if (nameType.equalsIgnoreCase(PROP_EDI_NAME)) {
                    EDIPartyName ediName = new EDIPartyName(name);
                    names.addElement((Object)ediName);
                    continue;
                }
                if (nameType.equalsIgnoreCase(PROP_URI_NAME)) {
                    URIName uriName = new URIName(name);
                    names.addElement((Object)uriName);
                    continue;
                }
                if (nameType.equalsIgnoreCase(PROP_IP_NAME)) {
                    IPAddressName ipName = new IPAddressName(name);
                    names.addElement((Object)ipName);
                    continue;
                }
                if (nameType.equalsIgnoreCase(PROP_OID_NAME)) {
                    ObjectIdentifier oid = new ObjectIdentifier(name);
                    OIDName oidNmae = new OIDName(oid);
                    names.addElement((Object)oidNmae);
                    continue;
                }
                if (nameType.equalsIgnoreCase(PROP_OTHER_NAME)) {
                    try {
                        byte[] val = Utils.base64decode((String)name);
                        DerValue derVal = new DerValue((InputStream)new ByteArrayInputStream(val));
                        GeneralName generalName = new GeneralName(derVal);
                        names.addElement((Object)generalName);
                    }
                    catch (IOException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_INVALID_OTHER_NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                    continue;
                }
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_INVALID_TYPE", (Object[])new Object[]{nameType, ""}));
            }
            if (names.size() > 0) {
                try {
                    issuerAltNameExt = new IssuerAlternativeNameExtension(Boolean.valueOf(critical), names);
                }
                catch (IOException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_ISSUER_ALT_NAME_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
            }
        }
        return issuerAltNameExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.IssuerAlternativeName_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
        int i;
        int numNames = 0;
        try {
            numNames = config.getInteger("numNames", 0);
        }
        catch (EBaseException e) {
            logger.warn("Invalid numNames property for CRL IssuerAlternativeName extension: " + e.getMessage(), (Throwable)e);
        }
        nvp.put((Object)"numNames", (Object)String.valueOf(numNames));
        for (i = 0; i < numNames; ++i) {
            String nameType = null;
            try {
                nameType = config.getString("nameType" + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn("Undefined nameType" + i + " property for CRL IssuerAlternativeName extension: " + e.getMessage(), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn("Invalid nameType" + i + " property for CRL IssuerAlternativeName extension: " + e.getMessage(), (Throwable)e);
            }
            if (nameType != null && nameType.length() > 0) {
                nvp.put((Object)("nameType" + i), (Object)nameType);
            } else {
                nvp.put((Object)("nameType" + i), (Object)"");
            }
            String name = null;
            try {
                name = config.getString("name" + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn("Undefined name" + i + " property for CRL IssuerAlternativeName extension: " + e.getMessage(), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn("Invalid name" + i + " property for CRL IssuerAlternativeName extension: " + e.getMessage(), (Throwable)e);
            }
            if (name != null && name.length() > 0) {
                nvp.put((Object)("name" + i), (Object)name);
                continue;
            }
            nvp.put((Object)("name" + i), (Object)"");
        }
        if (numNames < 3) {
            for (i = numNames; i < 3; ++i) {
                nvp.put((Object)("nameType" + i), (Object)"");
                nvp.put((Object)("name" + i), (Object)"");
            }
        }
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Issuer Alternative Name CRL extension.", "critical;boolean;Set criticality for Issuer Alternative Name CRL extension.", "numNames;number;Set number of alternative names for the CRL issuer.", "nameType0;choice(rfc822Name,directoryName,dNSName,ediPartyName,URI,iPAddress,OID,otherName);Select Issuer Alternative Name type.", "name0;string;Enter Issuer Alternative Name corresponding to the selected name type.", "nameType1;choice(rfc822Name,directoryName,dNSName,ediPartyName,URI,iPAddress,OID,otherName);Select Issuer Alternative Name type.", "name1;string;Enter Issuer Alternative Name corresponding to the selected name type.", "nameType2;choice(rfc822Name,directoryName,dNSName,ediPartyName,URI,iPAddress,OID,otherName);Select Issuer Alternative Name type.", "name2;string;Enter Issuer Alternative Name corresponding to the selected name type.", "HELP_TOKEN;configuration-ca-edit-crlextension-issueralternativename", "HELP_TEXT;The issuer alternative names extension allows additional identities to be associated with the issuer of the CRL."};
        return params;
    }
}

