/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(GenericExtDefault.class);
    public static final String CONFIG_CRITICAL = "genericExtCritical";
    public static final String CONFIG_OID = "genericExtOID";
    public static final String CONFIG_DATA = "genericExtData";
    public static final String VAL_CRITICAL = "genericExtCritical";
    public static final String VAL_DATA = "genericExtData";

    public GenericExtDefault() {
        this.addValueName("genericExtCritical");
        this.addValueName("genericExtData");
        this.addConfigName("genericExtCritical");
        this.addConfigName(CONFIG_OID);
        this.addConfigName("genericExtData");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("genericExtCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_OID)) {
            return new Descriptor("string", null, "Comment Here...", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OID", (String[])new String[0]));
        }
        if (name.equals("genericExtData")) {
            return new Descriptor("string", null, "Comment Here...", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EXT_VALUE", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("genericExtCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("genericExtData")) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EXT_VALUE", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (info == null) {
            logger.error("GenericExtDefault: setValue() info == null");
            throw new EPropertyException("GenericExtDefault: setValue() info == null");
        }
        try {
            Extension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ObjectIdentifier oid = new ObjectIdentifier(this.getConfig(CONFIG_OID));
            ext = this.getExtension(oid.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("genericExtCritical")) {
                ext = this.getExtension(oid.toString(), info);
                if (ext == null) {
                    return;
                }
                boolean val = Boolean.valueOf(value);
                ext.setCritical(val);
            } else if (name.equals("genericExtData")) {
                ext = this.getExtension(oid.toString(), info);
                if (ext == null) {
                    return;
                }
                byte[] data = this.getBytes(value);
                ext.setExtensionValue(data);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(ext.getExtensionId().toString(), ext, info);
        }
        catch (EProfileException e) {
            logger.error("GenericExtDefault: setValue() " + e.getMessage(), (Throwable)e);
            throw new EPropertyException("GenericExtDefault: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("GenericExtDefault: setValue() " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        Extension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (info == null) {
            logger.error("GenericExtDefault : getValue(): info == null");
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"GenericExtDefault : getValue(): info == null", (String[])new String[0]));
        }
        ObjectIdentifier oid = new ObjectIdentifier(this.getConfig(CONFIG_OID));
        ext = this.getExtension(oid.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("genericExtCritical")) {
            ext = this.getExtension(oid.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals("genericExtData")) {
            ext = this.getExtension(oid.toString(), info);
            if (ext == null) {
                return "";
            }
            byte[] data = ext.getExtensionValue();
            if (data == null) {
                return "";
            }
            return this.toStr(data);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("genericExtCritical"), this.getConfig(CONFIG_OID), this.getConfig("genericExtData")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_GENERIC_EXT", (String[])params);
    }

    public String toStr(byte[] data) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) < 16) {
                b.append("0");
            }
            b.append(Integer.toString(data[i] & 0xFF, 16));
        }
        return b.toString();
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        Extension ext = this.createExtension(request);
        this.addExtension(ext.getExtensionId().toString(), ext, info);
    }

    public Extension createExtension(Request request) {
        Extension ext = null;
        try (DerOutputStream out = new DerOutputStream();){
            boolean critical = this.getConfigBoolean("genericExtCritical");
            ObjectIdentifier oid = new ObjectIdentifier(this.getConfig(CONFIG_OID));
            byte[] data = null;
            data = request == null ? this.getBytes(this.getConfig("genericExtData")) : this.getBytes(this.mapPattern(request, this.getConfig("genericExtData")));
            out.putOctetString(data);
            ext = new Extension(oid, critical, out.toByteArray());
        }
        catch (Exception e) {
            logger.warn("GenericExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

