/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.profile.input.SerialNumRenewInput;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cms.servlet.cert.CertProcessor;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.SSLClientCertProvider;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.registry.PluginInfo;
import com.netscape.cmscore.registry.PluginRegistry;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewalProcessor
extends CertProcessor {
    public static Logger logger = LoggerFactory.getLogger(RenewalProcessor.class);

    public RenewalProcessor(String id, Locale locale) {
        super(id, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> processRenewal(CertEnrollmentRequest data, HttpServletRequest request, AuthCredentials credentials) throws Exception {
        try {
            if (logger.isDebugEnabled()) {
                HashMap params = data.toParams();
                this.printParameterValues(params);
            }
            logger.debug("RenewalProcessor: processRenewal()");
            CAEngine engine = CAEngine.getInstance();
            this.startTiming("enrollment");
            request.setAttribute("reqType", (Object)"renewal");
            String renewProfileId = this.profileID == null ? data.getProfileId() : this.profileID;
            logger.debug("RenewalProcessor: profile: " + renewProfileId);
            Profile renewProfile = this.ps.getProfile(renewProfileId);
            if (renewProfile == null) {
                logger.error(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)renewProfileId)}));
                throw new BadRequestDataException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)renewProfileId)}));
            }
            if (!this.ps.isProfileEnable(renewProfileId)) {
                logger.error("RenewalProcessor: Profile " + renewProfileId + " not enabled");
                throw new BadRequestDataException("Profile " + renewProfileId + " not enabled");
            }
            BigInteger certSerial = null;
            CertId serial = data.getSerialNum();
            if (serial != null) {
                logger.debug("RenewalProcessor: serial number: " + serial);
                certSerial = serial.toBigInteger();
            }
            if (certSerial == null) {
                PluginRegistry registry = engine.getPluginRegistry();
                for (com.netscape.certsrv.profile.ProfileInput input : data.getInputs()) {
                    String inputId = input.getId();
                    if (inputId == null) {
                        throw new BadRequestException("Missing input ID");
                    }
                    String classId = input.getClassId();
                    if (classId == null) {
                        throw new BadRequestException("Missing class ID in input " + inputId);
                    }
                    PluginInfo pluginInfo = registry.getPluginInfo("profileInput", classId);
                    if (pluginInfo == null) {
                        throw new BadRequestException("Unregistered class ID " + classId + " in input " + inputId);
                    }
                    String className = pluginInfo.getClassName();
                    if (!SerialNumRenewInput.class.getName().equals(className)) continue;
                    logger.debug("RenewalProcessor: found SerialNumRenewInput");
                    ProfileAttribute attribute = input.getAttribute("serial_num");
                    if (attribute == null) {
                        throw new BadRequestException("Missing attribute serial_num in input " + inputId);
                    }
                    String value = attribute.getValue();
                    logger.debug("RenewalProcessor: profile input serial_num value: " + value);
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    serial = new CertId(value);
                    certSerial = serial.toBigInteger();
                    break;
                }
            }
            if (certSerial == null) {
                if (!request.isSecure()) {
                    throw new BadRequestException("Missing serial number");
                }
                logger.debug("RenewalProcessor: get serial number from client certificate");
                certSerial = this.getSerialNumberFromCert(request);
            }
            logger.debug("processRenewal: serial number of cert to renew:" + certSerial.toString());
            CertRecord rec = this.certdb.readCertificateRecord(certSerial);
            if (rec == null) {
                logger.error("processRenewal: cert record not found for serial number " + certSerial);
                throw new EBaseException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            }
            if (rec.getStatus().equals("REVOKED") || rec.getStatus().equals("REVOKED_EXPIRED")) {
                logger.error("processRenewal: cert found to be revoked. Serial number: " + certSerial);
                throw new BadRequestDataException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_CA_CANNOT_RENEW_REVOKED_CERT", (String[])new String[0]));
            }
            X509CertImpl origCert = rec.getCertificate();
            if (origCert == null) {
                logger.error("processRenewal: original cert not found in cert record for serial number " + certSerial);
                throw new EBaseException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            }
            Date origNotAfter = origCert.getNotAfter();
            logger.debug("processRenewal: origNotAfter =" + origNotAfter.toString());
            String origSubjectDN = origCert.getSubjectName().getName();
            logger.debug("processRenewal: orig subj dn =" + origSubjectDN);
            Request origReq = this.getOriginalRequest(certSerial, rec);
            if (origReq == null) {
                logger.error("processRenewal: original request not found");
                throw new EBaseException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            }
            String profileId = origReq.getExtDataInString("profileId");
            logger.debug("RenewalSubmitter: renewal original profileId=" + profileId);
            String aidString = origReq.getExtDataInString("req_authority_id");
            Integer origSeqNum = origReq.getExtDataInInteger("req_seq_num");
            Profile profile = this.ps.getProfile(profileId);
            if (profile == null) {
                logger.error(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
                throw new EBaseException(CMS.getUserMessage((Locale)this.locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
            }
            if (!this.ps.isProfileEnable(profileId)) {
                logger.error("RenewalSubmitter: Profile " + profileId + " not enabled");
                throw new BadRequestDataException("Profile " + profileId + " not enabled");
            }
            HashMap<String, String> ctx = new HashMap<String, String>();
            if (aidString != null) {
                ctx.put("req_authority_id", aidString);
            }
            AuthManager authenticator = this.ps.getProfileAuthenticator(renewProfile);
            AuthManager origAuthenticator = this.ps.getProfileAuthenticator(profile);
            if (authenticator != null) {
                logger.debug("RenewalSubmitter: authenticator " + authenticator.getName() + " found");
                this.setCredentialsIntoContext(request, credentials, authenticator, ctx);
            }
            if (origAuthenticator != null) {
                logger.debug("RenewalSubmitter: for renewal, original authenticator " + origAuthenticator.getName() + " found");
                this.setCredentialsIntoContext(request, credentials, origAuthenticator, ctx);
            }
            logger.debug("processRenewal: set original Inputs into profile Context");
            this.setInputsIntoContext(origReq, profile, ctx, this.locale);
            ctx.put("renewal", "true");
            ctx.put("renewProfileId", renewProfileId);
            ctx.put("renewal_seq_num", origSeqNum.toString());
            SessionContext context = SessionContext.getContext();
            context.put((Object)"profileContext", ctx);
            context.put((Object)"sslClientCertProvider", (Object)new SSLClientCertProvider(request));
            logger.debug("RenewalSubmitter: set sslClientCertProvider");
            if (origSubjectDN != null) {
                context.put((Object)"origSubjectDN", (Object)origSubjectDN);
            }
            AuthToken authToken = null;
            if (authenticator != null) {
                authToken = this.authenticate(request, origReq, authenticator, context, true, credentials);
            } else {
                AuthToken latentToken;
                AuthzToken authzToken;
                Principal principal = request.getUserPrincipal();
                if (renewProfileId.equals("caManualRenewal") && principal instanceof PKIPrincipal && (authzToken = this.authorize("DirAclAuthz", latentToken = ((PKIPrincipal)principal).getAuthToken(), "certServer.ca.certrequests", "execute")) != null) {
                    authToken = latentToken;
                }
            }
            this.authorize(profileId, renewProfile, authToken);
            this.startTiming("request_population");
            Request[] reqs = profile.createRequests(ctx, this.locale);
            this.populateRequests(data, true, this.locale, origNotAfter, origSubjectDN, origReq, profileId, profile, ctx, authenticator, authToken, reqs);
            this.endTiming("request_population");
            String errorCode = this.submitRequests(this.locale, profile, authToken, reqs);
            String errorReason = null;
            ArrayList<String> errors = new ArrayList<String>();
            if (errorCode != null) {
                for (Request req : reqs) {
                    String error = req.getError(this.locale);
                    if (error == null) continue;
                    String code = req.getErrorCode(this.locale);
                    errors.add(this.codeToReason(this.locale, code, error, req.getRequestId()));
                }
                errorReason = StringUtils.join(errors, (char)'\n');
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("requests", reqs);
            ret.put("errorCode", errorCode);
            ret.put("errorReason", errorReason);
            ret.put("profile", profile);
            logger.debug("RenewalSubmitter: done serving");
            this.endTiming("enrollment");
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
        finally {
            SessionContext.releaseContext();
            this.endAllEvents();
        }
    }

    private BigInteger getSerialNumberFromCert(HttpServletRequest request) throws EBaseException {
        SSLClientCertProvider sslCCP = new SSLClientCertProvider(request);
        X509Certificate[] certs = sslCCP.getClientCertificateChain();
        if (certs == null || certs.length == 0) {
            logger.error("RenewalProcessor: missing SSL client certificate chain");
            throw new BadRequestException("Missing SSL client certificate chain");
        }
        logger.debug("RenewalProcessor: has SSL client cert chain");
        X509Certificate clientCert = null;
        for (X509Certificate cert : certs) {
            logger.debug("RenewalProcessor: cert " + cert.getSubjectDN());
            clientCert = cert;
            byte[] extBytes = clientCert.getExtensionValue("2.5.29.19");
            if (extBytes == null) {
                logger.debug("RenewalProcessor: found leaf cert");
                break;
            }
            logger.debug("RenewalProcessor: found cert having BasicConstraints ext");
            try {
                BasicConstraintsExtension bce = new BasicConstraintsExtension(Boolean.valueOf(true), (Object)extBytes);
                if (((Boolean)bce.get("is_ca")).booleanValue()) continue;
                logger.debug("RenewalProcessor: found CA cert in chain");
                break;
            }
            catch (Exception e) {
                logger.error("RenewalProcessor: Invalid certificate extension:" + e.getMessage(), (Throwable)e);
                throw new BadRequestException("Invalid certificate extension: " + e.getMessage(), (Throwable)e);
            }
        }
        return clientCert.getSerialNumber();
    }

    private void setInputsIntoContext(Request request, Profile profile, Map<String, String> ctx, Locale locale) {
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                Enumeration<String> inputNames = profileInput.getValueNames();
                while (inputNames.hasMoreElements()) {
                    String inputName = inputNames.nextElement();
                    String inputValue = "";
                    logger.debug("RenewalSubmitter: setInputsIntoContext() getting input name= " + inputName);
                    try {
                        inputValue = profileInput.getValue(inputName, locale, request);
                    }
                    catch (Exception e) {
                        logger.warn("RenewalSubmitter: setInputsIntoContext() getvalue() failed: " + e.getMessage(), (Throwable)e);
                    }
                    if (inputValue != null) {
                        logger.debug("RenewalSubmitter: setInputsIntoContext() setting value in ctx:" + inputValue);
                        ctx.put(inputName, inputValue);
                        continue;
                    }
                    logger.warn("RenewalSubmitter: setInputsIntoContext() value null");
                }
            }
        }
    }
}

