/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.cert.CrossCertPairSubsystem;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePair
implements ASN1Value {
    public static Logger logger = LoggerFactory.getLogger(CertificatePair.class);
    private byte[] mForward;
    private byte[] mReverse;
    private static final Tag TAG = SEQUENCE.TAG;

    public CertificatePair(X509Certificate cert1, X509Certificate cert2) throws EBaseException {
        if (cert1 == null || cert2 == null) {
            throw new EBaseException("CertificatePair: both certs can not be null");
        }
        logger.debug("CertifiatePair: in CertificatePair()");
        boolean rightOrder = this.certOrders(cert1, cert2);
        try {
            if (!rightOrder) {
                this.mForward = cert2.getEncoded();
                this.mReverse = cert1.getEncoded();
            } else {
                this.mForward = cert1.getEncoded();
                this.mReverse = cert2.getEncoded();
            }
        }
        catch (CertificateException e) {
            throw new EBaseException("CertificatePair: constructor failed:" + e.toString());
        }
    }

    public CertificatePair(byte[] cert1, byte[] cert2) throws EBaseException {
        if (cert1 == null || cert2 == null) {
            throw new EBaseException("CertificatePair: both certs can not be null");
        }
        boolean rightOrder = this.certOrders(cert1, cert2);
        if (!rightOrder) {
            this.mForward = cert2;
            this.mReverse = cert1;
        } else {
            this.mForward = cert1;
            this.mReverse = cert2;
        }
    }

    private boolean certOrders(X509Certificate c1, X509Certificate c2) throws EBaseException {
        logger.debug("CertifiatePair: in certOrders() with X509Cert");
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        X509CertImpl caCert = ca.getCACert();
        logger.debug("CertifiatePair: got this caCert");
        byte[] caCertBytes = caCert.getPublicKey().getEncoded();
        if (caCertBytes == null) {
            logger.error("CertifiatePair: cacert public key bytes null");
            throw new EBaseException("CertificatePair: certOrders() fails to get this CA's signing certificate public key encoded");
        }
        logger.debug("CertifiatePair: got cacert public key bytes length=" + caCertBytes.length);
        byte[] c1Bytes = c1.getPublicKey().getEncoded();
        if (c1Bytes == null) {
            logger.error("CertifiatePair: c1 cert public key bytes length null");
            throw new EBaseException("CertificatePair::certOrders() public key bytes are of length null");
        }
        logger.debug("CertifiatePair: got c1 public key bytes length=" + c1Bytes.length);
        byte[] c2Bytes = c2.getPublicKey().getEncoded();
        if (c2Bytes != null) {
            logger.debug("CertifiatePair: got c2 public key bytes length=" + c2Bytes.length);
        } else {
            logger.debug("CertifiatePair: c2 cert public key bytes length null");
        }
        if (this.byteArraysAreEqual(c1Bytes, caCertBytes)) {
            logger.debug("CertifiatePair: c1 has same public key as this ca");
            return true;
        }
        if (this.byteArraysAreEqual(c2Bytes, caCertBytes)) {
            logger.debug("CertifiatePair: c2 has same public key as this ca");
            return false;
        }
        logger.error("CertifiatePair: neither c1 nor c2 public key matches with this ca");
        throw new EBaseException("CertificatePair: need correct forward and reverse relationship to construct CertificatePair");
    }

    public boolean byteArraysAreEqual(byte[] a, byte[] b) {
        logger.debug("CertifiatePair: in byteArraysAreEqual()");
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            logger.debug("CertifiatePair: exiting byteArraysAreEqual(): false");
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            logger.debug("CertifiatePair: exiting byteArraysAreEqual(): false");
            return false;
        }
        logger.debug("CertifiatePair: exiting byteArraysAreEqual(): true");
        return true;
    }

    private boolean certOrders(byte[] cert1, byte[] cert2) throws EBaseException {
        logger.debug("CertifiatePair: in certOrders() with byte[]");
        CAEngine engine = CAEngine.getInstance();
        CrossCertPairSubsystem ccps = (CrossCertPairSubsystem)engine.getSubsystem("CrossCertPair");
        X509Certificate c1 = null;
        X509Certificate c2 = null;
        try {
            c1 = ccps.byteArray2X509Cert(cert1);
            c2 = ccps.byteArray2X509Cert(cert2);
        }
        catch (CertificateException e) {
            throw new EBaseException("CertificatePair: certOrders() failed:" + e.toString());
        }
        return this.certOrders(c1, c2);
    }

    public void encode(OutputStream os) throws IOException {
        this.encode(TAG, os);
    }

    public void encode(Tag implicitTag, OutputStream os) throws IOException {
        ANY any;
        SEQUENCE seq = new SEQUENCE();
        if (this.mForward != null) {
            try {
                any = new ANY(this.mForward);
                seq.addElement((ASN1Value)any);
            }
            catch (InvalidBERException e) {
                logger.warn("CertifiatePair: encode error:" + e.toString());
            }
        }
        if (this.mReverse != null) {
            try {
                any = new ANY(this.mReverse);
                seq.addElement((ASN1Value)any);
            }
            catch (InvalidBERException e) {
                logger.warn("CertifiatePair: encode error:" + e.toString());
            }
        }
        seq.encode(implicitTag, os);
    }

    public Tag getTag() {
        return TAG;
    }
}

