/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.cli;

import com.netscape.certsrv.cert.CertSearchRequest;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cms.servlet.cert.FilterBuilder;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.security.SecureRandomConfig;
import com.netscape.cmscore.security.SecureRandomFactory;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.dogtagpki.util.logging.PKILogger;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertFindCLI.class);

    public CACertFindCLI(CLI parent) {
        super("find", "Find certificates in CA", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "status", true, "Certificate status: VALID, INVALID, REVOKED, EXPIRED, REVOKED_EXPIRED");
        option.setArgName("status");
        this.options.addOption(option);
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        CertSearchRequest searchRequest = new CertSearchRequest();
        if (cmd.hasOption("status")) {
            searchRequest.setStatus(cmd.getOptionValue("status"));
        }
        FilterBuilder builder = new FilterBuilder(searchRequest);
        String filter = builder.buildFilter();
        logger.info("- filter: " + filter);
        int size = 20;
        String instanceDir = CMS.getInstanceDir();
        TomcatJSS tomcatjss = TomcatJSS.getInstance();
        tomcatjss.loadConfig();
        tomcatjss.init();
        String subsystem = this.parent.getParent().getName();
        String confDir = instanceDir + File.separator + subsystem + File.separator + "conf";
        String configFile = confDir + File.separator + "CS.cfg";
        logger.info("Loading " + configFile);
        FileConfigStorage storage = new FileConfigStorage(configFile);
        CAEngineConfig cs = new CAEngineConfig((ConfigStorage)storage);
        cs.load();
        DatabaseConfig dbConfig = cs.getDatabaseConfig();
        LDAPConfig ldapConfig = dbConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        SecureRandomConfig secureRandomConfig = cs.getJssSubsystemConfig().getSecureRandomConfig();
        SecureRandom secureRandom = SecureRandomFactory.create((SecureRandomConfig)secureRandomConfig);
        DBSubsystem dbSubsystem = new DBSubsystem();
        dbSubsystem.setEngineConfig((EngineConfig)cs);
        dbSubsystem.init(dbConfig, ldapConfig, socketConfig, passwordStore);
        CAConfig caConfig = cs.getCAConfig();
        logger.info("Initializing cert repository");
        int increment = caConfig.getInteger("certdbInc", 5);
        logger.info("- increment: " + increment);
        try {
            CertificateRepository certificateRepository = new CertificateRepository(secureRandom, dbSubsystem);
            certificateRepository.init();
            CertRecordList list = certificateRepository.findCertRecordsInList(filter, null, "serialno", size);
            int total = list.getSize();
            for (int i = 0; i < total; ++i) {
                String revokedBy;
                if (i > 0) {
                    System.out.println();
                }
                CertRecord record = list.getCertRecord(i);
                CertId id = new CertId(record.getSerialNumber());
                X509CertImpl cert = record.getCertificate();
                System.out.println("  Serial Number: " + id.toHexString());
                System.out.println("  Subject DN: " + cert.getSubjectDN());
                System.out.println("  Issuer DN: " + cert.getIssuerDN());
                System.out.println("  Status: " + record.getStatus());
                System.out.println("  Not Valid Before: " + cert.getNotBefore());
                System.out.println("  Not Valid After: " + cert.getNotAfter());
                System.out.println("  Issued On: " + record.getCreateTime());
                System.out.println("  Issued By: " + record.getIssuedBy());
                Date revokedOn = record.getRevokedOn();
                if (revokedOn != null) {
                    System.out.println("  Revoked On: " + revokedOn);
                }
                if ((revokedBy = record.getRevokedBy()) == null) continue;
                System.out.println("  Revoked By: " + revokedBy);
            }
        }
        finally {
            dbSubsystem.shutdown();
        }
    }
}

