/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.cmscore.apps.CMS;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dogtagpki.common.AppInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="apps")
public class AppService {
    private static Logger logger = LoggerFactory.getLogger(AppService.class);
    @Context
    ServletContext context;

    public AppInfo getAppInfo(String id) {
        String path = "/" + id;
        ServletContext ctx = this.context.getContext(path);
        if (ctx == null) {
            return null;
        }
        if (!path.equals(ctx.getContextPath())) {
            return null;
        }
        String displayName = ctx.getServletContextName();
        AppInfo info = new AppInfo();
        info.setID(id);
        info.setName(displayName);
        info.setPath(path);
        return info;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getApplications() throws Exception {
        logger.info("PKI applications:");
        ArrayList<AppInfo> apps = new ArrayList<AppInfo>();
        File instanceDir = new File(CMS.getInstanceDir());
        File confDir = new File(instanceDir, "conf");
        Object[] appConfDirs = confDir.listFiles(File::isDirectory);
        Arrays.sort(appConfDirs);
        for (Object appConfDir : appConfDirs) {
            String id = ((File)appConfDir).getName();
            AppInfo info = this.getAppInfo(id);
            if (info == null) continue;
            logger.info("- ID: " + info.getID());
            logger.info("  Name: " + info.getName());
            logger.info("  Path: " + info.getPath());
            apps.add(info);
        }
        Response.ResponseBuilder builder = Response.ok();
        builder.entity(apps);
        return builder.build();
    }
}

