/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.key.KeyRecordParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.kra.KRAEngine;

public class ConfirmRecoverBySerial
extends CMSServlet {
    private static final long serialVersionUID = 2221819191344494389L;
    private static final String INFO = "recoverBySerial";
    private static final String TPL_FILE = "confirmRecoverBySerial.template";
    private static final String IN_SERIALNO = "serialNumber";
    private static final String OUT_SERIALNO = "serialNumber";
    private static final String OUT_OP = "op";
    private static final String OUT_SERVICE_URL = "serviceURL";
    private static final String OUT_M = "noOfRequiredAgents";
    private static final String OUT_ERROR = "errorDetails";
    private KeyRepository mKeyDB;
    private KeyRecoveryAuthority mRecoveryService;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/kra/confirmRecoverBySerial.template";
        KRAEngine engine = KRAEngine.getInstance();
        this.mRecoveryService = engine.getKRA();
        this.mKeyDB = this.mRecoveryService.getKeyRepository();
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        this.authenticate(cmsReq);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        BigInteger seqNum = BigInteger.ZERO;
        try {
            if (req.getParameter("serialNumber") != null) {
                seqNum = new BigInteger(req.getParameter("serialNumber"));
            }
            resp.setHeader("pragma", "no-cache");
            this.process(header, seqNum, req, locale[0]);
        }
        catch (NumberFormatException e) {
            header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }

    private void process(ArgBlock header, BigInteger seq, HttpServletRequest req, Locale locale) {
        try {
            header.addBigIntegerValue("serialNumber", seq, 10);
            header.addIntegerValue(OUT_M, this.mRecoveryService.getNoOfRequiredAgents());
            header.addStringValue(OUT_OP, req.getParameter(OUT_OP));
            header.addStringValue(OUT_SERVICE_URL, req.getRequestURI());
            KeyRecord rec = this.mKeyDB.readKeyRecord(seq);
            KeyRecordParser.fillRecordIntoArg((KeyRecord)rec, (ArgBlock)header);
        }
        catch (EBaseException e) {
            header.addStringValue(OUT_ERROR, e.toString(locale));
        }
    }
}

