/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.common.AbstractAgentProxy;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class AgentForwardedChannel
extends AbstractClientChannel {
    public static final String MESSAGE_POLL_FREQUENCY = "agent-fwd-channel-message-poll-time";
    public static final long DEFAULT_MESSAGE_POLL_FREQUENCY = TimeUnit.MINUTES.toMillis(2L);
    private final Queue<Buffer> messages = new ArrayBlockingQueue<Buffer>(10);
    private final Buffer receiveBuffer = new ByteArrayBuffer();

    public AgentForwardedChannel(String channelType) {
        super(channelType);
        this.addCloseFutureListener(f -> {
            Queue<Buffer> queue = this.messages;
            synchronized (queue) {
                this.messages.notifyAll();
            }
        });
    }

    public SshAgent getAgent() {
        AbstractAgentProxy rtn = new AbstractAgentProxy(null){
            private final AtomicBoolean open;
            {
                this.open = new AtomicBoolean(true);
            }

            @Override
            public boolean isOpen() {
                return this.open.get();
            }

            @Override
            protected Buffer request(Buffer buffer) throws IOException {
                return AgentForwardedChannel.this.request(buffer);
            }

            @Override
            public void close() throws IOException {
                if (this.open.getAndSet(false)) {
                    AgentForwardedChannel.this.close(false);
                    super.close();
                }
            }
        };
        String chType = PropertyResolverUtils.getString(this.getSession(), "agent-fw-auth-type");
        rtn.setChannelType(chType);
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer request(Buffer buffer) throws IOException {
        int reqLen = buffer.available();
        Queue<Buffer> queue = this.messages;
        synchronized (queue) {
            OutputStream outputStream2 = this.getInvertedIn();
            outputStream2.write(buffer.array(), buffer.rpos(), reqLen);
            outputStream2.flush();
            Window wLocal = this.getLocalWindow();
            wLocal.consumeAndCheck(reqLen);
            return this.waitForMessageBuffer();
        }
    }

    protected Buffer waitForMessageBuffer() throws IOException {
        Session session = this.getSession();
        long idleTimeout = PropertyResolverUtils.getLongProperty(session, MESSAGE_POLL_FREQUENCY, DEFAULT_MESSAGE_POLL_FREQUENCY);
        if (idleTimeout <= 0L) {
            idleTimeout = DEFAULT_MESSAGE_POLL_FREQUENCY;
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        int count = 1;
        while (true) {
            if (this.isClosing() || !this.isOpen()) {
                throw new SshException("Channel is being closed");
            }
            if (!this.messages.isEmpty()) {
                return this.messages.poll();
            }
            if (traceEnabled) {
                this.log.trace("waitForMessageBuffer({}) wait iteration #{}", (Object)this, (Object)count);
            }
            try {
                this.messages.wait(idleTimeout);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException("Interrupted while waiting for messages at iteration #" + count).initCause(e);
            }
            ++count;
        }
    }

    @Override
    protected void doOpen() throws IOException {
        ValidateUtils.checkTrue(!StreamingChannel.Streaming.Async.equals((Object)this.streaming), "Asynchronous streaming isn't supported yet on this channel");
        this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        ByteArrayBuffer message = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(new ByteArrayBuffer(data, off, (int)len));
            if (this.receiveBuffer.available() >= 4) {
                off = this.receiveBuffer.rpos();
                len = this.receiveBuffer.getInt();
                this.receiveBuffer.rpos(off);
                if ((long)this.receiveBuffer.available() >= 4L + len) {
                    message = new ByteArrayBuffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (message != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(message);
                this.messages.notifyAll();
            }
        }
    }
}

