/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.sonar.api.batch.rule.LoadedActiveRule;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.GetRequest;

public class DefaultActiveRulesLoader
implements ActiveRulesLoader {
    private static final String RULES_SEARCH_URL = "/api/rules/search.protobuf?f=repo,name,severity,lang,internalKey,templateKey,params,actives,createdAt,updatedAt,deprecatedKeys&activation=true";
    private final ScannerWsClient wsClient;

    public DefaultActiveRulesLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public List<LoadedActiveRule> load(String qualityProfileKey) {
        LinkedList<LoadedActiveRule> ruleList = new LinkedList<LoadedActiveRule>();
        int page = 1;
        int pageSize = 500;
        long loaded = 0L;
        while (true) {
            GetRequest getRequest = new GetRequest(DefaultActiveRulesLoader.getUrl(qualityProfileKey, page, pageSize));
            Rules.SearchResponse response = DefaultActiveRulesLoader.loadFromStream(this.wsClient.call(getRequest).contentStream());
            List<LoadedActiveRule> pageRules = DefaultActiveRulesLoader.readPage(response);
            ruleList.addAll(pageRules);
            if (response.getTotal() <= (loaded += response.getPs())) break;
            ++page;
        }
        return ruleList;
    }

    private static String getUrl(String qualityProfileKey, int page, int pageSize) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append(RULES_SEARCH_URL);
        builder.append("&qprofile=").append(ScannerUtils.encodeForUrl(qualityProfileKey));
        builder.append("&ps=").append(pageSize);
        builder.append("&p=").append(page);
        return builder.toString();
    }

    private static Rules.SearchResponse loadFromStream(InputStream is) {
        try {
            Rules.SearchResponse searchResponse = Rules.SearchResponse.parseFrom(is);
            return searchResponse;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load quality profiles", e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private static List<LoadedActiveRule> readPage(Rules.SearchResponse response) {
        LinkedList<LoadedActiveRule> loadedRules = new LinkedList<LoadedActiveRule>();
        List<Rules.Rule> rulesList = response.getRulesList();
        Map<String, Rules.ActiveList> actives = response.getActives().getActivesMap();
        for (Rules.Rule r : rulesList) {
            Rules.ActiveList activeList = actives.get(r.getKey());
            if (activeList == null) {
                throw MessageException.of("Elasticsearch indices have become inconsistent. Consider re-indexing. Check documentation for more information https://docs.sonarqube.org/latest/setup/troubleshooting");
            }
            Rules.Active active = activeList.getActiveList(0);
            LoadedActiveRule loadedRule = new LoadedActiveRule();
            loadedRule.setRuleKey(RuleKey.parse(r.getKey()));
            loadedRule.setName(r.getName());
            loadedRule.setSeverity(active.getSeverity());
            loadedRule.setCreatedAt(DateUtils.dateToLong(DateUtils.parseDateTime(active.getCreatedAt())));
            loadedRule.setUpdatedAt(DateUtils.dateToLong(DateUtils.parseDateTime(active.getUpdatedAt())));
            loadedRule.setLanguage(r.getLang());
            loadedRule.setInternalKey(r.getInternalKey());
            if (r.hasTemplateKey()) {
                RuleKey templateRuleKey = RuleKey.parse(r.getTemplateKey());
                loadedRule.setTemplateRuleKey(templateRuleKey.rule());
            }
            HashMap<String, String> params = new HashMap<String, String>();
            for (Rules.Rule.Param param : r.getParams().getParamsList()) {
                params.put(param.getKey(), param.getDefaultValue());
            }
            for (Rules.Active.Param param : active.getParamsList()) {
                params.put(param.getKey(), param.getValue());
            }
            loadedRule.setParams(params);
            loadedRule.setDeprecatedKeys(r.getDeprecatedKeys().getDeprecatedKeyList().stream().map(RuleKey::parse).collect(Collectors.toSet()));
            loadedRules.add(loadedRule);
        }
        return loadedRules;
    }
}

