/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.kubernetes.plugin;

import java.io.IOException;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.iac.common.yaml.YamlSensor;
import org.sonar.iac.kubernetes.checks.KubernetesCheckList;
import org.sonar.iac.kubernetes.plugin.KubernetesLanguage;

public class KubernetesSensor
extends YamlSensor {
    private static final String DIRECTIVE_IN_COMMENT = "#.*\\{\\{";
    private static final String DIRECTIVE_IN_SINGLE_QUOTE = "'[^']*\\{\\{[^']*'";
    private static final String DIRECTIVE_IN_DOUBLE_QUOTE = "\"[^\"]*\\{\\{[^\"]*\"";
    private static final String CODEFRESH_VARIABLES = "\\{\\{[\\w\\s]+}}";
    private static final Pattern HELM_DIRECTIVE_IN_COMMENT_OR_STRING = Pattern.compile("(" + String.join((CharSequence)"|", "#.*\\{\\{", "'[^']*\\{\\{[^']*'", "\"[^\"]*\\{\\{[^\"]*\"", "\\{\\{[\\w\\s]+}}") + ")");

    public KubernetesSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, KubernetesLanguage language) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, (Language)language, KubernetesCheckList.checks());
    }

    @Override
    protected String repositoryKey() {
        return "kubernetes";
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.kubernetes.activate";
    }

    @Override
    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        return new KubernetesFilePredicate();
    }

    static class KubernetesFilePredicate
    implements FilePredicate {
        private static final Set<String> IDENTIFIER = Set.of("apiVersion", "kind", "metadata", "spec");
        private static final Logger LOG = Loggers.get(KubernetesFilePredicate.class);

        KubernetesFilePredicate() {
        }

        public boolean apply(InputFile inputFile) {
            return KubernetesFilePredicate.hasKubernetesObjectStructure(inputFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean hasKubernetesObjectStructure(InputFile inputFile) {
            int identifierCount = 0;
            try (Scanner scanner = new Scanner(inputFile.inputStream(), inputFile.charset().name());){
                boolean atLeastOneCompleteObject = false;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (IDENTIFIER.stream().anyMatch(line::startsWith)) {
                        ++identifierCount;
                    } else if ("---".equals(line)) {
                        identifierCount = 0;
                    } else if (line.contains("{{") && !HELM_DIRECTIVE_IN_COMMENT_OR_STRING.matcher(line).find()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (identifierCount != 4) continue;
                    atLeastOneCompleteObject = true;
                }
                boolean bl = atLeastOneCompleteObject;
                return bl;
            }
            catch (IOException e) {
                LOG.error(String.format("Unable to read file: %s.", inputFile.uri()));
                LOG.error(e.getMessage());
                return false;
            }
        }
    }
}

