/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.ExternalIssuesSensor;
import org.sonar.plugins.python.TextReportReader;

public class PylintSensor
extends ExternalIssuesSensor {
    private static final Logger LOG = Loggers.get(PylintSensor.class);
    public static final String LINTER_NAME = "Pylint";
    public static final String LINTER_KEY = "pylint";
    public static final String REPORT_PATH_KEY = "sonar.python.pylint.reportPaths";

    @Override
    protected void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) throws IOException {
        List<TextReportReader.Issue> issues = new TextReportReader(0).parse(reportPath, context.fileSystem());
        issues.forEach(i -> this.saveIssue(context, (TextReportReader.Issue)i, unresolvedInputFiles, LINTER_KEY));
    }

    @Override
    protected boolean shouldExecute(Configuration conf) {
        return conf.hasKey(REPORT_PATH_KEY) || conf.hasKey("sonar.python.pylint.reportPath");
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String linterName() {
        return LINTER_NAME;
    }

    @Override
    protected Logger logger() {
        return LOG;
    }
}

