/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;

@Rule(key="S3403")
public class SillyIdentityCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, ctx -> {
            InferredType right;
            IsExpression isExpression = (IsExpression)ctx.syntaxNode();
            InferredType left = isExpression.leftOperand().type();
            if (!(left.isIdentityComparableWith(right = isExpression.rightOperand().type()) || left.canOnlyBe("NoneType") || right.canOnlyBe("NoneType"))) {
                Token notToken = isExpression.notToken();
                String operator = notToken == null ? "is" : "is not";
                String result = notToken == null ? "False" : "True";
                Token lastToken = notToken == null ? isExpression.operator() : notToken;
                ctx.addIssue(isExpression.operator(), lastToken, String.format("Remove this \"%s\" check; it will always be %s.", operator, result));
            }
        });
    }
}

