/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.metrics.FileLinesVisitor;

@Rule(key="S138")
public class TooManyLinesInFunctionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "This %1$s \"%2$s\" has %3$d lines of code, which is greater than the %4$d authorized. Split it into smaller %1$ss.";
    private static final int DEFAULT = 100;
    @RuleProperty(key="max", description="Maximum authorized lines of code in a function", defaultValue="100")
    public int max = 100;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            FunctionLineVisitor visitor = new FunctionLineVisitor();
            visitor.scan(functionDef.body());
            Set<Integer> linesOfCode = visitor.linesOfCode;
            Set<Integer> linesOfDocstring = FileLinesVisitor.countDocstringLines(functionDef.docstring());
            for (Integer line : linesOfDocstring) {
                linesOfCode.remove(line);
            }
            if (linesOfCode.size() > this.max) {
                ctx.addIssue(functionDef.name(), this.getIssueMessage(functionDef, linesOfCode.size()));
            }
        });
    }

    private String getIssueMessage(FunctionDef functionDef, int numberOfLines) {
        String type = functionDef.isMethodDefinition() ? "method" : "function";
        return String.format(MESSAGE, type, functionDef.name().name(), numberOfLines, this.max);
    }

    private static class FunctionLineVisitor {
        private final Set<Integer> linesOfCode = new HashSet<Integer>();

        private FunctionLineVisitor() {
        }

        private void scan(Tree element) {
            ArrayDeque<Tree> stack = new ArrayDeque<Tree>();
            stack.push(element);
            while (!stack.isEmpty()) {
                Tree currentElement = (Tree)stack.pop();
                if (currentElement.is(Tree.Kind.TOKEN)) {
                    this.linesOfCode.addAll(FileLinesVisitor.tokenLineNumbers((Token)currentElement));
                }
                currentElement.children().stream().filter(Objects::nonNull).forEach(stack::push);
            }
        }
    }
}

