/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AsPattern;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.CaseBlock;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ClassPattern;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionClause;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.ExecStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FormatSpecifier;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.GroupPattern;
import org.sonar.plugins.python.api.tree.Guard;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.ImportStatement;
import org.sonar.plugins.python.api.tree.KeywordPattern;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.LiteralPattern;
import org.sonar.plugins.python.api.tree.MappingPattern;
import org.sonar.plugins.python.api.tree.MatchStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NonlocalStatement;
import org.sonar.plugins.python.api.tree.PassStatement;
import org.sonar.plugins.python.api.tree.Pattern;
import org.sonar.plugins.python.api.tree.PrintStatement;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.SequencePattern;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.StarPattern;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.python.DocstringExtractor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.parser.FStringParser;
import org.sonar.python.tree.AliasedNameImpl;
import org.sonar.python.tree.AnnotatedAssignmentImpl;
import org.sonar.python.tree.ArgListImpl;
import org.sonar.python.tree.AsPatternImpl;
import org.sonar.python.tree.AssertStatementImpl;
import org.sonar.python.tree.AssignmentExpressionImpl;
import org.sonar.python.tree.AssignmentStatementImpl;
import org.sonar.python.tree.AwaitExpressionImpl;
import org.sonar.python.tree.BinaryExpressionImpl;
import org.sonar.python.tree.BreakStatementImpl;
import org.sonar.python.tree.CallExpressionImpl;
import org.sonar.python.tree.CapturePatternImpl;
import org.sonar.python.tree.CaseBlockImpl;
import org.sonar.python.tree.ClassDefImpl;
import org.sonar.python.tree.ClassPatternImpl;
import org.sonar.python.tree.CompoundAssignmentStatementImpl;
import org.sonar.python.tree.ComprehensionExpressionImpl;
import org.sonar.python.tree.ComprehensionForImpl;
import org.sonar.python.tree.ComprehensionIfImpl;
import org.sonar.python.tree.ConditionalExpressionImpl;
import org.sonar.python.tree.ContinueStatementImpl;
import org.sonar.python.tree.DecoratorImpl;
import org.sonar.python.tree.DelStatementImpl;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.DictionaryLiteralImpl;
import org.sonar.python.tree.DottedNameImpl;
import org.sonar.python.tree.DoubleStarPatternImpl;
import org.sonar.python.tree.EllipsisExpressionImpl;
import org.sonar.python.tree.ElseClauseImpl;
import org.sonar.python.tree.ExceptClauseImpl;
import org.sonar.python.tree.ExceptGroupJumpInstructionsCheck;
import org.sonar.python.tree.ExecStatementImpl;
import org.sonar.python.tree.ExpressionListImpl;
import org.sonar.python.tree.ExpressionStatementImpl;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.FinallyClauseImpl;
import org.sonar.python.tree.ForStatementImpl;
import org.sonar.python.tree.FormatSpecifierImpl;
import org.sonar.python.tree.FormattedExpressionImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.GlobalStatementImpl;
import org.sonar.python.tree.GroupPatternImpl;
import org.sonar.python.tree.GuardImpl;
import org.sonar.python.tree.IfStatementImpl;
import org.sonar.python.tree.ImportFromImpl;
import org.sonar.python.tree.ImportNameImpl;
import org.sonar.python.tree.InExpressionImpl;
import org.sonar.python.tree.IsExpressionImpl;
import org.sonar.python.tree.KeyValuePairImpl;
import org.sonar.python.tree.KeyValuePatternImpl;
import org.sonar.python.tree.KeywordPatternImpl;
import org.sonar.python.tree.LambdaExpressionImpl;
import org.sonar.python.tree.ListLiteralImpl;
import org.sonar.python.tree.LiteralPatternImpl;
import org.sonar.python.tree.MappingPatternImpl;
import org.sonar.python.tree.MatchStatementImpl;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.tree.NoneExpressionImpl;
import org.sonar.python.tree.NonlocalStatementImpl;
import org.sonar.python.tree.NumericLiteralImpl;
import org.sonar.python.tree.OrPatternImpl;
import org.sonar.python.tree.ParameterImpl;
import org.sonar.python.tree.ParameterListImpl;
import org.sonar.python.tree.ParenthesizedExpressionImpl;
import org.sonar.python.tree.PassStatementImpl;
import org.sonar.python.tree.PrintStatementImpl;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.QualifiedExpressionImpl;
import org.sonar.python.tree.RaiseStatementImpl;
import org.sonar.python.tree.RegularArgumentImpl;
import org.sonar.python.tree.ReprExpressionImpl;
import org.sonar.python.tree.ReturnStatementImpl;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SequencePatternImpl;
import org.sonar.python.tree.SetLiteralImpl;
import org.sonar.python.tree.SliceExpressionImpl;
import org.sonar.python.tree.SliceItemImpl;
import org.sonar.python.tree.SliceListImpl;
import org.sonar.python.tree.StarPatternImpl;
import org.sonar.python.tree.StatementListImpl;
import org.sonar.python.tree.StatementWithSeparator;
import org.sonar.python.tree.StringElementImpl;
import org.sonar.python.tree.StringLiteralImpl;
import org.sonar.python.tree.SubscriptionExpressionImpl;
import org.sonar.python.tree.TokenImpl;
import org.sonar.python.tree.TryStatementImpl;
import org.sonar.python.tree.TupleImpl;
import org.sonar.python.tree.TupleParameterImpl;
import org.sonar.python.tree.TypeAnnotationImpl;
import org.sonar.python.tree.UnaryExpressionImpl;
import org.sonar.python.tree.UnpackingExpressionImpl;
import org.sonar.python.tree.ValuePatternImpl;
import org.sonar.python.tree.WhileStatementImpl;
import org.sonar.python.tree.WildcardPatternImpl;
import org.sonar.python.tree.WithStatementImpl;
import org.sonar.python.tree.YieldExpressionImpl;
import org.sonar.python.tree.YieldStatementImpl;

public class PythonTreeMaker {
    private static final FStringParser F_STRING_PARSER = new FStringParser();

    public FileInput fileInput(AstNode astNode) {
        List<Statement> statements = PythonTreeMaker.getStatements(astNode).stream().map(this::statement).collect(Collectors.toList());
        StatementListImpl statementList = statements.isEmpty() ? null : new StatementListImpl(statements);
        Token endOfFile = PythonTreeMaker.toPyToken(astNode.getFirstChild(GenericTokenType.EOF).getToken());
        FileInputImpl pyFileInputTree = new FileInputImpl(statementList, endOfFile, DocstringExtractor.extractDocstring(statementList));
        this.setParents(pyFileInputTree);
        pyFileInputTree.accept(new ExceptGroupJumpInstructionsCheck());
        return pyFileInputTree;
    }

    public static void recognitionException(int line, String message) {
        throw new RecognitionException(line, "Parse error at line " + line + ": " + message + ".");
    }

    private static Token toPyToken(@Nullable com.sonar.sslr.api.Token token) {
        if (token == null) {
            return null;
        }
        return new TokenImpl(token);
    }

    private static List<Token> toPyToken(List<com.sonar.sslr.api.Token> tokens) {
        return tokens.stream().map(TokenImpl::new).collect(Collectors.toList());
    }

    public void setParents(Tree root) {
        for (Tree child : root.children()) {
            if (child == null) continue;
            ((PyTree)child).setParent(root);
            this.setParents(child);
        }
    }

    private Statement statement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        if (astNode.is(PythonGrammar.IF_STMT)) {
            return this.ifStatement(astNode);
        }
        if (astNode.is(PythonGrammar.PASS_STMT)) {
            return this.passStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.PRINT_STMT)) {
            return this.printStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.EXEC_STMT)) {
            return this.execStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.ASSERT_STMT)) {
            return this.assertStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.DEL_STMT)) {
            return this.delStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.RETURN_STMT)) {
            return this.returnStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.YIELD_STMT)) {
            return this.yieldStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.RAISE_STMT)) {
            return this.raiseStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.BREAK_STMT)) {
            return this.breakStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.CONTINUE_STMT)) {
            return this.continueStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.FUNCDEF)) {
            return this.funcDefStatement(astNode);
        }
        if (astNode.is(PythonGrammar.CLASSDEF)) {
            return this.classDefStatement(astNode);
        }
        if (astNode.is(PythonGrammar.IMPORT_STMT)) {
            return this.importStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.FOR_STMT)) {
            return this.forStatement(astNode);
        }
        if (astNode.is(PythonGrammar.WHILE_STMT)) {
            return this.whileStatement(astNode);
        }
        if (astNode.is(PythonGrammar.GLOBAL_STMT)) {
            return this.globalStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.NONLOCAL_STMT)) {
            return this.nonlocalStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.EXPRESSION_STMT) && astNode.hasDirectChildren(PythonGrammar.ANNASSIGN)) {
            return this.annotatedAssignment(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.EXPRESSION_STMT) && astNode.hasDirectChildren(PythonPunctuator.ASSIGN)) {
            return this.assignment(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.EXPRESSION_STMT) && astNode.hasDirectChildren(PythonGrammar.AUGASSIGN)) {
            return this.compoundAssignment(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.EXPRESSION_STMT)) {
            return this.expressionStatement(statementWithSeparator);
        }
        if (astNode.is(PythonGrammar.TRY_STMT)) {
            return this.tryStatement(astNode);
        }
        if (astNode.is(PythonGrammar.ASYNC_STMT) && astNode.hasDirectChildren(PythonGrammar.FOR_STMT)) {
            return this.forStatement(astNode);
        }
        if (astNode.is(PythonGrammar.ASYNC_STMT) && astNode.hasDirectChildren(PythonGrammar.WITH_STMT)) {
            return this.withStatement(astNode);
        }
        if (astNode.is(PythonGrammar.WITH_STMT)) {
            return this.withStatement(astNode);
        }
        if (astNode.is(PythonGrammar.MATCH_STMT)) {
            return this.matchStatement(astNode);
        }
        throw new IllegalStateException("Statement " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    public AnnotatedAssignment annotatedAssignment(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode annAssign = astNode.getFirstChild(PythonGrammar.ANNASSIGN);
        AstNode colonTokenNode = annAssign.getFirstChild(PythonPunctuator.COLON);
        Expression variable = this.exprListOrTestList(astNode.getFirstChild(PythonGrammar.TESTLIST_STAR_EXPR));
        Expression annotation = this.expression(annAssign.getFirstChild(PythonGrammar.TEST));
        AstNode equalTokenNode = annAssign.getFirstChild(PythonPunctuator.ASSIGN);
        Token equalToken = null;
        Expression assignedValue = null;
        if (equalTokenNode != null) {
            equalToken = PythonTreeMaker.toPyToken(equalTokenNode.getToken());
            assignedValue = this.expression(equalTokenNode.getNextSibling());
        }
        TypeAnnotationImpl typeAnnotation = new TypeAnnotationImpl(PythonTreeMaker.toPyToken(colonTokenNode.getToken()), annotation, Tree.Kind.VARIABLE_TYPE_ANNOTATION);
        return new AnnotatedAssignmentImpl(variable, typeAnnotation, equalToken, assignedValue, separators);
    }

    private StatementList getStatementListFromSuite(AstNode suite) {
        return new StatementListImpl(this.getStatementsFromSuite(suite));
    }

    private List<Statement> getStatementsFromSuite(AstNode astNode) {
        if (astNode.is(PythonGrammar.SUITE)) {
            List<StatementWithSeparator> statements = PythonTreeMaker.getStatements(astNode);
            if (statements.isEmpty()) {
                List<StatementWithSeparator> statementsWithSeparators = PythonTreeMaker.getStatementsWithSeparators(astNode);
                return statementsWithSeparators.stream().map(this::statement).collect(Collectors.toList());
            }
            return statements.stream().map(this::statement).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<StatementWithSeparator> getStatements(AstNode astNode) {
        List<AstNode> statements = astNode.getChildren(PythonGrammar.STATEMENT);
        ArrayList<StatementWithSeparator> statementsWithSeparators = new ArrayList<StatementWithSeparator>();
        for (AstNode stmt : statements) {
            if (stmt.hasDirectChildren(PythonGrammar.STMT_LIST)) {
                List<StatementWithSeparator> statementList = PythonTreeMaker.getStatementsWithSeparators(stmt);
                statementsWithSeparators.addAll(statementList);
                continue;
            }
            StatementWithSeparator compoundStmt = new StatementWithSeparator(stmt.getFirstChild(PythonGrammar.COMPOUND_STMT).getFirstChild(), null);
            statementsWithSeparators.add(compoundStmt);
        }
        return statementsWithSeparators;
    }

    private static List<StatementWithSeparator> getStatementsWithSeparators(AstNode stmt) {
        ArrayList<StatementWithSeparator> statementsWithSeparators = new ArrayList<StatementWithSeparator>();
        AstNode stmtListNode = stmt.getFirstChild(PythonGrammar.STMT_LIST);
        AstNode newLine = stmt.getFirstChild(PythonTokenType.NEWLINE);
        List<AstNode> children = stmtListNode.getChildren();
        int nbChildren = children.size();
        for (int i = 0; i < nbChildren; i += 2) {
            boolean isLastStmt;
            AstNode current = children.get(i);
            AstNode separator = current.getNextSibling();
            AstNode newLineForSeparator = null;
            boolean bl = isLastStmt = nbChildren - i <= 2;
            if (isLastStmt) {
                newLineForSeparator = newLine;
            }
            statementsWithSeparators.add(new StatementWithSeparator(current.getFirstChild(), new Separators(separator, newLineForSeparator)));
        }
        return statementsWithSeparators;
    }

    public PrintStatement printStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        List<Expression> expressions = this.expressionsFromTest(astNode);
        Separators separators = statementWithSeparator.separator();
        return new PrintStatementImpl(PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expressions, separators);
    }

    public ExecStatement execStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Expression expression = this.expression(astNode.getFirstChild(PythonGrammar.EXPR));
        List<Expression> expressions = this.expressionsFromTest(astNode);
        Separators separators = statementWithSeparator.separator();
        if (expressions.isEmpty()) {
            return new ExecStatementImpl(PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expression, separators);
        }
        Token inToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.IN).getToken());
        Expression globalsExpression = expressions.get(0);
        Token commaToken = null;
        Expression localsExpression = null;
        if (expressions.size() == 2) {
            commaToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.COMMA).getToken());
            localsExpression = expressions.get(1);
        }
        return new ExecStatementImpl(PythonTreeMaker.toPyToken(astNode.getTokens().get(0)), expression, inToken, globalsExpression, commaToken, localsExpression, separators);
    }

    public AssertStatement assertStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        List<Expression> expressions = this.expressionsFromTest(stmt);
        Expression condition = expressions.get(0);
        Expression message = null;
        if (expressions.size() > 1) {
            message = expressions.get(1);
        }
        return new AssertStatementImpl(PythonTreeMaker.toPyToken(stmt.getTokens()).get(0), condition, message, separators);
    }

    public PassStatement passStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new PassStatementImpl(PythonTreeMaker.toPyToken(stmt.getTokens()).get(0), separators);
    }

    public DelStatement delStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        List<Expression> expressionTrees = this.expressionsFromExprList(stmt.getFirstChild(PythonGrammar.EXPRLIST));
        return new DelStatementImpl(PythonTreeMaker.toPyToken(stmt.getTokens()).get(0), expressionTrees, separators);
    }

    public ReturnStatement returnStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode testListNode = astNode.getFirstChild(PythonGrammar.TESTLIST_STAR_EXPR);
        List<Expression> expressionTrees = Collections.emptyList();
        List<Token> commas = Collections.emptyList();
        if (testListNode != null) {
            expressionTrees = this.expressionsFromTestListStarExpr(testListNode);
            commas = PythonTreeMaker.punctuators(testListNode, PythonPunctuator.COMMA);
        }
        return new ReturnStatementImpl(PythonTreeMaker.toPyToken(astNode.getTokens()).get(0), expressionTrees, commas, separators);
    }

    public YieldStatement yieldStatement(StatementWithSeparator statementWithSeparator) {
        AstNode stmt = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new YieldStatementImpl(this.yieldExpression(stmt.getFirstChild(PythonGrammar.YIELD_EXPR)), separators);
    }

    public YieldExpression yieldExpression(AstNode astNode) {
        Token yieldKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.YIELD).getToken());
        AstNode nodeContainingExpression = astNode;
        AstNode fromKeyword = astNode.getFirstChild(PythonKeyword.FROM);
        if (fromKeyword == null) {
            nodeContainingExpression = astNode.getFirstChild(PythonGrammar.TESTLIST_STAR_EXPR);
        }
        List<Expression> expressionTrees = Collections.emptyList();
        if (nodeContainingExpression != null) {
            expressionTrees = this.expressionsFromTestListStarExpr(nodeContainingExpression);
        }
        return new YieldExpressionImpl(yieldKeyword, fromKeyword == null ? null : PythonTreeMaker.toPyToken(fromKeyword.getToken()), expressionTrees);
    }

    public RaiseStatement raiseStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode fromKeyword = astNode.getFirstChild(PythonKeyword.FROM);
        List<Object> expressions = new ArrayList<AstNode>();
        AstNode fromExpression = null;
        if (fromKeyword != null) {
            expressions.add(astNode.getFirstChild(PythonGrammar.TEST));
            fromExpression = astNode.getLastChild(PythonGrammar.TEST);
        } else {
            expressions = astNode.getChildren(PythonGrammar.TEST);
        }
        List<Expression> expressionTrees = expressions.stream().map(this::expression).collect(Collectors.toList());
        return new RaiseStatementImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.RAISE).getToken()), expressionTrees, fromKeyword == null ? null : PythonTreeMaker.toPyToken(fromKeyword.getToken()), fromExpression == null ? null : this.expression(fromExpression), separators);
    }

    public BreakStatement breakStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new BreakStatementImpl(PythonTreeMaker.toPyToken(astNode.getToken()), separators);
    }

    public ContinueStatement continueStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        return new ContinueStatementImpl(PythonTreeMaker.toPyToken(astNode.getToken()), separators);
    }

    public ImportStatement importStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode importStmt = astNode.getFirstChild();
        if (importStmt.is(PythonGrammar.IMPORT_NAME)) {
            return PythonTreeMaker.importName(importStmt, separators);
        }
        return PythonTreeMaker.importFromStatement(importStmt, separators);
    }

    private static ImportName importName(AstNode astNode, Separators separators) {
        Token importKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.IMPORT).getToken());
        List<AliasedName> aliasedNames = astNode.getFirstChild(PythonGrammar.DOTTED_AS_NAMES).getChildren(PythonGrammar.DOTTED_AS_NAME).stream().map(PythonTreeMaker::aliasedName).collect(Collectors.toList());
        return new ImportNameImpl(importKeyword, aliasedNames, separators);
    }

    private static ImportFrom importFromStatement(AstNode astNode, Separators separators) {
        Token importKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.IMPORT).getToken());
        Token fromKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.FROM).getToken());
        List<Token> dottedPrefixForModule = PythonTreeMaker.punctuators(astNode, PythonPunctuator.DOT);
        AstNode moduleNode = astNode.getFirstChild(PythonGrammar.DOTTED_NAME);
        DottedName moduleName = null;
        if (moduleNode != null) {
            moduleName = PythonTreeMaker.dottedName(moduleNode);
        }
        AstNode importAsnames = astNode.getFirstChild(PythonGrammar.IMPORT_AS_NAMES);
        List aliasedImportNames = null;
        boolean isWildcardImport = true;
        if (importAsnames != null) {
            aliasedImportNames = importAsnames.getChildren(PythonGrammar.IMPORT_AS_NAME).stream().map(PythonTreeMaker::aliasedName).collect(Collectors.toList());
            isWildcardImport = false;
        }
        Token wildcard = null;
        if (isWildcardImport) {
            wildcard = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.MUL).getToken());
        }
        return new ImportFromImpl(fromKeyword, dottedPrefixForModule, moduleName, importKeyword, aliasedImportNames, wildcard, separators);
    }

    private static AliasedName aliasedName(AstNode astNode) {
        DottedName dottedName;
        AstNode asKeyword = astNode.getFirstChild(PythonKeyword.AS);
        if (astNode.is(PythonGrammar.DOTTED_AS_NAME)) {
            dottedName = PythonTreeMaker.dottedName(astNode.getFirstChild(PythonGrammar.DOTTED_NAME));
        } else {
            AstNode importedName = astNode.getFirstChild(PythonGrammar.NAME);
            dottedName = new DottedNameImpl(Collections.singletonList(PythonTreeMaker.name(importedName)));
        }
        if (asKeyword == null) {
            return new AliasedNameImpl(dottedName);
        }
        return new AliasedNameImpl(PythonTreeMaker.toPyToken(asKeyword.getToken()), dottedName, PythonTreeMaker.name(astNode.getLastChild(PythonGrammar.NAME)));
    }

    private static DottedName dottedName(AstNode astNode) {
        List<Name> names = astNode.getChildren(PythonGrammar.NAME).stream().map(PythonTreeMaker::name).collect(Collectors.toList());
        return new DottedNameImpl(names);
    }

    public GlobalStatement globalStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        Token globalKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.GLOBAL).getToken());
        List<Name> variables = astNode.getChildren(PythonGrammar.NAME).stream().map(PythonTreeMaker::variable).collect(Collectors.toList());
        return new GlobalStatementImpl(globalKeyword, variables, separators);
    }

    public NonlocalStatement nonlocalStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        Token nonlocalKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.NONLOCAL).getToken());
        List<Name> variables = astNode.getChildren(PythonGrammar.NAME).stream().map(PythonTreeMaker::variable).collect(Collectors.toList());
        return new NonlocalStatementImpl(nonlocalKeyword, variables, separators);
    }

    public IfStatement ifStatement(AstNode astNode) {
        Token ifToken = PythonTreeMaker.toPyToken(astNode.getTokens().get(0));
        AstNode condition = astNode.getFirstChild(PythonGrammar.NAMED_EXPR_TEST);
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.COLON).getToken());
        AstNode suite = astNode.getFirstChild(PythonGrammar.SUITE);
        StatementList body = this.getStatementListFromSuite(suite);
        AstNode elseSuite = astNode.getLastChild(PythonGrammar.SUITE);
        ElseClause elseClause = null;
        if (elseSuite.getPreviousSibling().getPreviousSibling().is(PythonKeyword.ELSE)) {
            elseClause = this.elseClause(elseSuite);
        }
        List<IfStatement> elifBranches = astNode.getChildren(PythonKeyword.ELIF).stream().map(this::elifStatement).collect(Collectors.toList());
        return new IfStatementImpl(ifToken, this.expression(condition), colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), elifBranches, elseClause);
    }

    private IfStatement elifStatement(AstNode astNode) {
        Token elifToken = PythonTreeMaker.toPyToken(astNode.getToken());
        AstNode condition = astNode.getNextSibling();
        AstNode colon = condition.getNextSibling();
        AstNode suite = colon.getNextSibling();
        StatementList body = this.getStatementListFromSuite(suite);
        Token colonToken = PythonTreeMaker.toPyToken(colon.getToken());
        return new IfStatementImpl(elifToken, this.expression(condition), colonToken, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite));
    }

    private ElseClause elseClause(AstNode astNode) {
        Token elseToken = PythonTreeMaker.toPyToken(astNode.getPreviousSibling().getPreviousSibling().getToken());
        Token colon = PythonTreeMaker.toPyToken(astNode.getPreviousSibling().getToken());
        StatementList body = this.getStatementListFromSuite(astNode);
        return new ElseClauseImpl(elseToken, colon, PythonTreeMaker.suiteNewLine(astNode), PythonTreeMaker.suiteIndent(astNode), body, PythonTreeMaker.suiteDedent(astNode));
    }

    public FunctionDef funcDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(PythonGrammar.DECORATORS);
        List<Decorator> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(PythonGrammar.DECORATOR).stream().map(this::decorator).collect(Collectors.toList());
        }
        Name name = PythonTreeMaker.name(astNode.getFirstChild(PythonGrammar.FUNCNAME).getFirstChild(PythonGrammar.NAME));
        ParameterListImpl parameterList = null;
        AstNode typedArgListNode = astNode.getFirstChild(PythonGrammar.TYPEDARGSLIST);
        if (typedArgListNode != null) {
            List<AnyParameter> arguments = typedArgListNode.getChildren(PythonGrammar.TFPDEF, PythonPunctuator.MUL, PythonPunctuator.DIV).stream().map(this::parameter).filter(Objects::nonNull).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(typedArgListNode, PythonPunctuator.COMMA);
            parameterList = new ParameterListImpl(arguments, commas);
        }
        AstNode suite = astNode.getFirstChild(PythonGrammar.SUITE);
        StatementList body = this.getStatementListFromSuite(suite);
        AstNode defNode = astNode.getFirstChild(PythonKeyword.DEF);
        Token asyncToken = null;
        AstNode defPreviousSibling = defNode.getPreviousSibling();
        if (defPreviousSibling != null && defPreviousSibling.getToken().getValue().equals("async")) {
            asyncToken = PythonTreeMaker.toPyToken(defPreviousSibling.getToken());
        }
        Token lPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.LPARENTHESIS).getToken());
        Token rPar = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.RPARENTHESIS).getToken());
        TypeAnnotationImpl returnType = null;
        AstNode returnTypeNode = astNode.getFirstChild(PythonGrammar.FUN_RETURN_ANNOTATION);
        if (returnTypeNode != null) {
            List<AstNode> children = returnTypeNode.getChildren();
            returnType = new TypeAnnotationImpl(PythonTreeMaker.toPyToken(children.get(0).getToken()), PythonTreeMaker.toPyToken(children.get(1).getToken()), this.expression(children.get(2)));
        }
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.COLON).getToken());
        return new FunctionDefImpl(decorators, asyncToken, PythonTreeMaker.toPyToken(defNode.getToken()), name, lPar, parameterList, rPar, returnType, colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), PythonTreeMaker.isMethodDefinition(astNode), DocstringExtractor.extractDocstring(body));
    }

    private Decorator decorator(AstNode astNode) {
        Token atToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.AT).getToken());
        Expression expression = this.expression(astNode.getFirstChild(PythonGrammar.NAMED_EXPR_TEST));
        Token newLineToken = astNode.getFirstChild(PythonTokenType.NEWLINE) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonTokenType.NEWLINE).getToken());
        return new DecoratorImpl(atToken, expression, newLineToken);
    }

    private static boolean isMethodDefinition(AstNode node) {
        AstNode parent;
        for (parent = node.getParent(); parent != null && !parent.is(PythonGrammar.CLASSDEF, PythonGrammar.FUNCDEF); parent = parent.getParent()) {
        }
        return parent != null && parent.is(PythonGrammar.CLASSDEF);
    }

    public ClassDef classDefStatement(AstNode astNode) {
        AstNode decoratorsNode = astNode.getFirstChild(PythonGrammar.DECORATORS);
        List<Decorator> decorators = Collections.emptyList();
        if (decoratorsNode != null) {
            decorators = decoratorsNode.getChildren(PythonGrammar.DECORATOR).stream().map(this::decorator).collect(Collectors.toList());
        }
        Name name = PythonTreeMaker.name(astNode.getFirstChild(PythonGrammar.CLASSNAME).getFirstChild(PythonGrammar.NAME));
        ArgList args = null;
        AstNode leftPar = astNode.getFirstChild(PythonPunctuator.LPARENTHESIS);
        if (leftPar != null) {
            args = this.argList(astNode.getFirstChild(PythonGrammar.ARGLIST));
        }
        AstNode suite = astNode.getFirstChild(PythonGrammar.SUITE);
        StatementList body = this.getStatementListFromSuite(suite);
        Token classToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.CLASS).getToken());
        AstNode rightPar = astNode.getFirstChild(PythonPunctuator.RPARENTHESIS);
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.COLON).getToken());
        return new ClassDefImpl(decorators, classToken, name, leftPar != null ? PythonTreeMaker.toPyToken(leftPar.getToken()) : null, args, rightPar != null ? PythonTreeMaker.toPyToken(rightPar.getToken()) : null, colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), DocstringExtractor.extractDocstring(body));
    }

    private static Name name(AstNode astNode) {
        return new NameImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild(GenericTokenType.IDENTIFIER).getToken()), astNode.getParent().is(PythonGrammar.ATOM));
    }

    private static Name variable(AstNode astNode) {
        return new NameImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild(GenericTokenType.IDENTIFIER).getToken()), true);
    }

    public ForStatement forStatement(AstNode astNode) {
        AstNode forStatementNode = astNode;
        Token asyncToken = null;
        if (astNode.is(PythonGrammar.ASYNC_STMT)) {
            asyncToken = PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken());
            forStatementNode = astNode.getFirstChild(PythonGrammar.FOR_STMT);
        }
        Token forKeyword = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(PythonKeyword.FOR).getToken());
        Token inKeyword = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(PythonKeyword.IN).getToken());
        Token colon = PythonTreeMaker.toPyToken(forStatementNode.getFirstChild(PythonPunctuator.COLON).getToken());
        List<Expression> expressions = this.expressionsFromExprList(forStatementNode.getFirstChild(PythonGrammar.EXPRLIST));
        List<Expression> testExpressions = this.expressionsFromTest(forStatementNode.getFirstChild(PythonGrammar.TESTLIST));
        AstNode firstSuite = forStatementNode.getFirstChild(PythonGrammar.SUITE);
        StatementList body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = forStatementNode.getLastChild(PythonGrammar.SUITE);
        ElseClause elseClause = firstSuite == lastSuite ? null : this.elseClause(lastSuite);
        return new ForStatementImpl(forKeyword, expressions, inKeyword, testExpressions, colon, PythonTreeMaker.suiteNewLine(firstSuite), PythonTreeMaker.suiteIndent(firstSuite), body, PythonTreeMaker.suiteDedent(firstSuite), elseClause, asyncToken);
    }

    public WhileStatementImpl whileStatement(AstNode astNode) {
        Token whileKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.WHILE).getToken());
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.COLON).getToken());
        Expression condition = this.expression(astNode.getFirstChild(PythonGrammar.NAMED_EXPR_TEST));
        AstNode firstSuite = astNode.getFirstChild(PythonGrammar.SUITE);
        StatementList body = this.getStatementListFromSuite(firstSuite);
        AstNode lastSuite = astNode.getLastChild(PythonGrammar.SUITE);
        ElseClause elseClause = firstSuite == lastSuite ? null : this.elseClause(lastSuite);
        return new WhileStatementImpl(whileKeyword, condition, colon, PythonTreeMaker.suiteNewLine(firstSuite), PythonTreeMaker.suiteIndent(firstSuite), body, PythonTreeMaker.suiteDedent(firstSuite), elseClause);
    }

    public ExpressionStatement expressionStatement(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        List<Expression> expressions = astNode.getFirstChild(PythonGrammar.TESTLIST_STAR_EXPR).getChildren(PythonGrammar.TEST, PythonGrammar.STAR_EXPR).stream().map(this::expression).collect(Collectors.toList());
        return new ExpressionStatementImpl(expressions, separators);
    }

    public AssignmentStatement assignment(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        ArrayList<Token> assignTokens = new ArrayList<Token>();
        ArrayList<ExpressionList> lhsExpressions = new ArrayList<ExpressionList>();
        List<AstNode> assignNodes = astNode.getChildren(PythonPunctuator.ASSIGN);
        for (AstNode assignNode : assignNodes) {
            assignTokens.add(PythonTreeMaker.toPyToken(assignNode.getToken()));
            lhsExpressions.add(this.expressionList(assignNode.getPreviousSibling()));
        }
        AstNode assignedValueNode = assignNodes.get(assignNodes.size() - 1).getNextSibling();
        Expression assignedValue = assignedValueNode.is(PythonGrammar.YIELD_EXPR) ? this.yieldExpression(assignedValueNode) : this.exprListOrTestList(assignedValueNode);
        return new AssignmentStatementImpl(assignTokens, lhsExpressions, assignedValue, separators);
    }

    public CompoundAssignmentStatement compoundAssignment(StatementWithSeparator statementWithSeparator) {
        AstNode astNode = statementWithSeparator.statement();
        Separators separators = statementWithSeparator.separator();
        AstNode augAssignNodes = astNode.getFirstChild(PythonGrammar.AUGASSIGN);
        Expression lhsExpression = this.exprListOrTestList(augAssignNodes.getPreviousSibling());
        AstNode rhsAstNode = augAssignNodes.getNextSibling();
        Expression rhsExpression = rhsAstNode.is(PythonGrammar.YIELD_EXPR) ? this.yieldExpression(rhsAstNode) : this.exprListOrTestList(rhsAstNode);
        return new CompoundAssignmentStatementImpl(lhsExpression, PythonTreeMaker.toPyToken(augAssignNodes.getToken()), rhsExpression, separators);
    }

    private ExpressionList expressionList(AstNode astNode) {
        if (astNode.is(PythonGrammar.TESTLIST_STAR_EXPR, PythonGrammar.TESTLIST_COMP)) {
            List<Expression> expressions = astNode.getChildren(PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.TEST, PythonGrammar.STAR_EXPR).stream().map(this::expression).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(astNode, PythonPunctuator.COMMA);
            return new ExpressionListImpl(expressions, commas);
        }
        return new ExpressionListImpl(Collections.singletonList(this.expression(astNode)), Collections.emptyList());
    }

    public TryStatement tryStatement(AstNode astNode) {
        Token tryKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.TRY).getToken());
        Token colon = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.COLON).getToken());
        AstNode firstSuite = astNode.getFirstChild(PythonGrammar.SUITE);
        StatementList body = this.getStatementListFromSuite(firstSuite);
        List<ExceptClause> exceptClauseTrees = astNode.getChildren(PythonGrammar.EXCEPT_CLAUSE).stream().map(except -> {
            AstNode suite = except.getNextSibling().getNextSibling();
            return this.exceptClause((AstNode)except, this.getStatementListFromSuite(suite));
        }).collect(Collectors.toList());
        this.checkExceptClauses(exceptClauseTrees);
        FinallyClauseImpl finallyClause = null;
        AstNode finallyNode = astNode.getFirstChild(PythonKeyword.FINALLY);
        if (finallyNode != null) {
            Token finallyColon = PythonTreeMaker.toPyToken(finallyNode.getNextSibling().getToken());
            AstNode finallySuite = finallyNode.getNextSibling().getNextSibling();
            StatementList finallyBody = this.getStatementListFromSuite(finallySuite);
            finallyClause = new FinallyClauseImpl(PythonTreeMaker.toPyToken(finallyNode.getToken()), finallyColon, PythonTreeMaker.suiteNewLine(finallySuite), PythonTreeMaker.suiteIndent(finallySuite), finallyBody, PythonTreeMaker.suiteDedent(finallySuite));
        }
        ElseClause elseClauseTree = null;
        AstNode elseNode = astNode.getFirstChild(PythonKeyword.ELSE);
        if (elseNode != null) {
            elseClauseTree = this.elseClause(elseNode.getNextSibling().getNextSibling());
        }
        return new TryStatementImpl(tryKeyword, colon, PythonTreeMaker.suiteNewLine(firstSuite), PythonTreeMaker.suiteIndent(firstSuite), body, PythonTreeMaker.suiteDedent(firstSuite), exceptClauseTrees, finallyClause, elseClauseTree);
    }

    public void checkExceptClauses(List<ExceptClause> excepts) {
        if (excepts.isEmpty()) {
            return;
        }
        Tree.Kind firstExceptKind = excepts.get(0).getKind();
        for (ExceptClause except : excepts) {
            if (firstExceptKind != except.getKind()) {
                PythonTreeMaker.recognitionException(except.exceptKeyword().line(), "Try statement cannot contain both except and except* clauses");
            }
            if (!except.is(Tree.Kind.EXCEPT_GROUP_CLAUSE) || except.exception() != null) continue;
            PythonTreeMaker.recognitionException(except.exceptKeyword().line(), "except* clause must specify the type of the expected exception");
        }
    }

    public WithStatement withStatement(AstNode astNode) {
        AstNode withStmtNode = astNode;
        Token asyncKeyword = null;
        if (astNode.is(PythonGrammar.ASYNC_STMT)) {
            withStmtNode = astNode.getFirstChild(PythonGrammar.WITH_STMT);
            asyncKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken());
        }
        List<WithItem> withItems = this.withItems(withStmtNode.getChildren(PythonGrammar.WITH_ITEM));
        AstNode lParens = withStmtNode.getFirstChild(PythonPunctuator.LPARENTHESIS);
        Token openParens = lParens == null ? null : PythonTreeMaker.toPyToken(lParens.getToken());
        List<Token> commas = PythonTreeMaker.punctuators(withStmtNode, PythonPunctuator.COMMA);
        AstNode suite = withStmtNode.getFirstChild(PythonGrammar.SUITE);
        Token withKeyword = PythonTreeMaker.toPyToken(withStmtNode.getToken());
        Token colon = PythonTreeMaker.toPyToken(suite.getPreviousSibling().getToken());
        AstNode rParens = withStmtNode.getFirstChild(PythonPunctuator.RPARENTHESIS);
        Token closeParens = rParens == null ? null : PythonTreeMaker.toPyToken(rParens.getToken());
        StatementList body = this.getStatementListFromSuite(suite);
        return new WithStatementImpl(withKeyword, openParens, withItems, commas, closeParens, colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite), asyncKeyword);
    }

    private List<WithItem> withItems(List<AstNode> withItems) {
        return withItems.stream().map(this::withItem).collect(Collectors.toList());
    }

    private WithItem withItem(AstNode withItem) {
        AstNode testNode = withItem.getFirstChild(PythonGrammar.TEST);
        Expression test = this.expression(testNode);
        AstNode asNode = testNode.getNextSibling();
        Expression expr = null;
        Token as = null;
        if (asNode != null) {
            as = PythonTreeMaker.toPyToken(asNode.getToken());
            expr = this.expression(withItem.getFirstChild(PythonGrammar.EXPR));
        }
        return new WithStatementImpl.WithItemImpl(test, as, expr);
    }

    private ExceptClause exceptClause(AstNode except, StatementList body) {
        Token colon = PythonTreeMaker.toPyToken(except.getNextSibling().getToken());
        AstNode suite = except.getNextSibling().getNextSibling();
        Token exceptKeyword = PythonTreeMaker.toPyToken(except.getFirstChild(PythonKeyword.EXCEPT).getToken());
        Token star = except.getFirstChild(PythonPunctuator.MUL) == null ? null : PythonTreeMaker.toPyToken(except.getFirstChild(PythonPunctuator.MUL).getToken());
        Token indent = suite.getFirstChild(PythonTokenType.INDENT) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(PythonTokenType.INDENT).getToken());
        Token newLine = suite.getFirstChild(PythonTokenType.INDENT) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(PythonTokenType.NEWLINE).getToken());
        Token dedent = suite.getFirstChild(PythonTokenType.DEDENT) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(PythonTokenType.DEDENT).getToken());
        AstNode exceptionNode = except.getFirstChild(PythonGrammar.TEST);
        if (exceptionNode == null) {
            return new ExceptClauseImpl(exceptKeyword, star, colon, newLine, indent, body, dedent);
        }
        AstNode asNode = except.getFirstChild(PythonKeyword.AS);
        AstNode commaNode = except.getFirstChild(PythonPunctuator.COMMA);
        if (asNode != null || commaNode != null) {
            Expression exceptionInstance = this.expression(except.getLastChild(PythonGrammar.TEST));
            Token asNodeToken = asNode != null ? PythonTreeMaker.toPyToken(asNode.getToken()) : null;
            Token commaNodeToken = commaNode != null ? PythonTreeMaker.toPyToken(commaNode.getToken()) : null;
            return new ExceptClauseImpl(exceptKeyword, star, colon, newLine, indent, body, dedent, this.expression(exceptionNode), asNodeToken, commaNodeToken, exceptionInstance);
        }
        return new ExceptClauseImpl(exceptKeyword, star, colon, newLine, indent, body, dedent, this.expression(exceptionNode));
    }

    public MatchStatement matchStatement(AstNode matchStmt) {
        Token matchKeyword = PythonTreeMaker.toPyToken(matchStmt.getTokens().get(0));
        AstNode subjectExpr = matchStmt.getFirstChild(PythonGrammar.SUBJECT_EXPR);
        Token colon = PythonTreeMaker.toPyToken(matchStmt.getFirstChild(PythonPunctuator.COLON).getToken());
        Token newLine = PythonTreeMaker.toPyToken(matchStmt.getFirstChild(PythonTokenType.NEWLINE).getToken());
        Token indent = PythonTreeMaker.toPyToken(matchStmt.getFirstChild(PythonTokenType.INDENT).getToken());
        List<CaseBlock> caseBlocks = matchStmt.getChildren(PythonGrammar.CASE_BLOCK).stream().map(this::caseBlock).collect(Collectors.toList());
        Token dedent = PythonTreeMaker.toPyToken(matchStmt.getFirstChild(PythonTokenType.DEDENT).getToken());
        return new MatchStatementImpl(matchKeyword, this.expression(subjectExpr), colon, newLine, indent, caseBlocks, dedent);
    }

    public CaseBlock caseBlock(AstNode caseBlock) {
        Token caseKeyword = PythonTreeMaker.toPyToken(caseBlock.getTokens().get(0));
        AstNode patternOrSequence = caseBlock.getFirstChild(PythonGrammar.PATTERNS).getFirstChild();
        Pattern pattern = patternOrSequence.is(PythonGrammar.PATTERN) ? PythonTreeMaker.pattern(patternOrSequence.getFirstChild()) : PythonTreeMaker.sequencePattern(patternOrSequence);
        Guard guard = null;
        AstNode guardNode = caseBlock.getFirstChild(PythonGrammar.GUARD);
        if (guardNode != null) {
            guard = this.guard(guardNode);
        }
        Token colon = PythonTreeMaker.toPyToken(caseBlock.getFirstChild(PythonPunctuator.COLON).getToken());
        AstNode suite = caseBlock.getFirstChild(PythonGrammar.SUITE);
        StatementList body = this.getStatementListFromSuite(suite);
        return new CaseBlockImpl(caseKeyword, pattern, guard, colon, PythonTreeMaker.suiteNewLine(suite), PythonTreeMaker.suiteIndent(suite), body, PythonTreeMaker.suiteDedent(suite));
    }

    public Guard guard(AstNode guardNode) {
        Token ifKeyword = PythonTreeMaker.toPyToken(guardNode.getTokens().get(0));
        Expression condition = this.expression(guardNode.getFirstChild(PythonGrammar.NAMED_EXPR_TEST));
        return new GuardImpl(ifKeyword, condition);
    }

    public static Pattern pattern(AstNode pattern) {
        if (pattern.is(PythonGrammar.OR_PATTERN)) {
            return PythonTreeMaker.orPattern(pattern);
        }
        return PythonTreeMaker.asPattern(pattern);
    }

    private static Pattern orPattern(AstNode pattern) {
        List<Token> separators = PythonTreeMaker.punctuators(pattern, PythonPunctuator.OR);
        if (separators.isEmpty()) {
            return PythonTreeMaker.closedPattern(pattern.getFirstChild(PythonGrammar.CLOSED_PATTERN));
        }
        List<Pattern> patterns = pattern.getChildren(PythonGrammar.CLOSED_PATTERN).stream().map(PythonTreeMaker::closedPattern).collect(Collectors.toList());
        return new OrPatternImpl(patterns, separators);
    }

    private static AsPattern asPattern(AstNode asPattern) {
        Pattern pattern = PythonTreeMaker.orPattern(asPattern.getFirstChild(PythonGrammar.OR_PATTERN));
        Token asKeyword = PythonTreeMaker.toPyToken(asPattern.getFirstChild(PythonKeyword.AS).getToken());
        CapturePatternImpl alias = new CapturePatternImpl(PythonTreeMaker.name(asPattern.getFirstChild(PythonGrammar.CAPTURE_PATTERN).getFirstChild()));
        return new AsPatternImpl(pattern, asKeyword, alias);
    }

    public static Pattern closedPattern(AstNode closedPattern) {
        AstNode astNode = closedPattern.getFirstChild();
        if (astNode.is(PythonGrammar.LITERAL_PATTERN)) {
            return PythonTreeMaker.literalPattern(astNode);
        }
        if (astNode.is(PythonGrammar.CAPTURE_PATTERN)) {
            return new CapturePatternImpl(PythonTreeMaker.name(astNode.getFirstChild()));
        }
        if (astNode.is(PythonGrammar.SEQUENCE_PATTERN)) {
            return PythonTreeMaker.sequencePattern(astNode);
        }
        if (astNode.is(PythonGrammar.GROUP_PATTERN)) {
            return PythonTreeMaker.groupPattern(astNode);
        }
        if (astNode.is(PythonGrammar.WILDCARD_PATTERN)) {
            return PythonTreeMaker.wildcardPattern(astNode);
        }
        if (astNode.is(PythonGrammar.CLASS_PATTERN)) {
            return PythonTreeMaker.classPattern(astNode);
        }
        if (astNode.is(PythonGrammar.VALUE_PATTERN)) {
            return new ValuePatternImpl((QualifiedExpression)PythonTreeMaker.nameOrAttr(astNode.getFirstChild()));
        }
        if (astNode.is(PythonGrammar.MAPPING_PATTERN)) {
            return PythonTreeMaker.mappingPattern(astNode);
        }
        throw new IllegalStateException(String.format("Pattern %s not recognized.", astNode.getName()));
    }

    private static GroupPattern groupPattern(AstNode groupPattern) {
        Token leftPar = PythonTreeMaker.toPyToken(groupPattern.getFirstChild(PythonPunctuator.LPARENTHESIS).getToken());
        Pattern pattern = PythonTreeMaker.pattern(groupPattern.getFirstChild(PythonGrammar.PATTERN).getFirstChild());
        Token rightPar = PythonTreeMaker.toPyToken(groupPattern.getFirstChild(PythonPunctuator.RPARENTHESIS).getToken());
        return new GroupPatternImpl(leftPar, pattern, rightPar);
    }

    private static ClassPattern classPattern(AstNode classPattern) {
        Expression nameOrAttr = PythonTreeMaker.nameOrAttr(classPattern.getFirstChild(PythonGrammar.NAME_OR_ATTR));
        Token leftPar = PythonTreeMaker.punctuators(classPattern, PythonPunctuator.LPARENTHESIS).get(0);
        ArrayList<Token> commas = new ArrayList<Token>();
        List<Pattern> patterns = PythonTreeMaker.patternArgs(classPattern.getFirstChild(PythonGrammar.PATTERN_ARGS), commas);
        PythonTreeMaker.checkPositionalAndKeywordArgumentsConstraint(patterns);
        Token rightPar = PythonTreeMaker.punctuators(classPattern, PythonPunctuator.RPARENTHESIS).get(0);
        return new ClassPatternImpl(nameOrAttr, leftPar, patterns, commas, rightPar);
    }

    private static void checkPositionalAndKeywordArgumentsConstraint(List<Pattern> patterns) {
        boolean positionalArgs = true;
        for (Pattern pattern : patterns) {
            if (pattern.is(Tree.Kind.KEYWORD_PATTERN)) {
                positionalArgs = false;
                continue;
            }
            if (positionalArgs) continue;
            int line = pattern.firstToken().line();
            PythonTreeMaker.recognitionException(line, "Positional patterns follow keyword patterns");
        }
    }

    private static List<Pattern> patternArgs(@Nullable AstNode patternArgs, List<Token> commas) {
        if (patternArgs == null) {
            return Collections.emptyList();
        }
        commas.addAll(PythonTreeMaker.punctuators(patternArgs, PythonPunctuator.COMMA));
        return patternArgs.getChildren(PythonGrammar.PATTERN_ARG).stream().map(arg -> PythonTreeMaker.patternArg(arg.getFirstChild())).collect(Collectors.toList());
    }

    private static Pattern patternArg(AstNode patternArg) {
        if (patternArg.is(PythonGrammar.KEYWORD_PATTERN)) {
            return PythonTreeMaker.keywordPattern(patternArg);
        }
        return PythonTreeMaker.pattern(patternArg.getFirstChild());
    }

    private static KeywordPattern keywordPattern(AstNode keywordPattern) {
        Name name = PythonTreeMaker.name(keywordPattern.getFirstChild(PythonGrammar.NAME));
        Token equalToken = PythonTreeMaker.punctuators(keywordPattern, PythonPunctuator.ASSIGN).get(0);
        Pattern pattern = PythonTreeMaker.pattern(keywordPattern.getFirstChild(PythonGrammar.PATTERN).getFirstChild());
        return new KeywordPatternImpl(name, equalToken, pattern);
    }

    private static Expression nameOrAttr(AstNode nameOrAttr) {
        List<Token> dots = PythonTreeMaker.punctuators(nameOrAttr, PythonPunctuator.DOT);
        List<AstNode> names = nameOrAttr.getChildren(PythonGrammar.NAME);
        if (dots.isEmpty()) {
            return PythonTreeMaker.variable(names.get(0));
        }
        HasSymbol qualifier = PythonTreeMaker.variable(names.get(0));
        for (int i = 1; i < names.size(); ++i) {
            Name name = PythonTreeMaker.name(names.get(i));
            qualifier = new QualifiedExpressionImpl(name, (Expression)((Object)qualifier), dots.get(i - 1));
        }
        return qualifier;
    }

    private static SequencePattern sequencePattern(AstNode sequencePattern) {
        AstNode leftDelimiter = sequencePattern.getFirstChild(PythonPunctuator.LPARENTHESIS, PythonPunctuator.LBRACKET);
        AstNode rightDelimiter = sequencePattern.getFirstChild(PythonPunctuator.RPARENTHESIS, PythonPunctuator.RBRACKET);
        ArrayList<Token> commas = new ArrayList<Token>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (leftDelimiter == null) {
            PythonTreeMaker.addPatternsAndCommasFromSequencePattern(sequencePattern, commas, patterns);
            return new SequencePatternImpl(null, patterns, commas, null);
        }
        if (leftDelimiter.is(PythonPunctuator.LPARENTHESIS)) {
            AstNode openSequencePattern = sequencePattern.getFirstChild(PythonGrammar.OPEN_SEQUENCE_PATTERN);
            if (openSequencePattern != null) {
                PythonTreeMaker.addPatternsAndCommasFromSequencePattern(openSequencePattern, commas, patterns);
            }
        } else {
            PythonTreeMaker.addPatternsAndCommasFromMaybeSequencePattern(sequencePattern.getFirstChild(PythonGrammar.MAYBE_SEQUENCE_PATTERN), patterns, commas);
        }
        return new SequencePatternImpl(PythonTreeMaker.toPyToken(leftDelimiter.getToken()), patterns, commas, PythonTreeMaker.toPyToken(rightDelimiter.getToken()));
    }

    private static void addPatternsAndCommasFromSequencePattern(AstNode sequencePattern, List<Token> commas, List<Pattern> patterns) {
        commas.add(PythonTreeMaker.toPyToken(sequencePattern.getFirstChild(PythonPunctuator.COMMA).getToken()));
        patterns.add(PythonTreeMaker.maybeStarPattern(sequencePattern.getFirstChild(PythonGrammar.MAYBE_STAR_PATTERN)));
        PythonTreeMaker.addPatternsAndCommasFromMaybeSequencePattern(sequencePattern.getFirstChild(PythonGrammar.MAYBE_SEQUENCE_PATTERN), patterns, commas);
    }

    private static void addPatternsAndCommasFromMaybeSequencePattern(@Nullable AstNode maybeSequencePattern, List<Pattern> patterns, List<Token> commas) {
        if (maybeSequencePattern == null) {
            return;
        }
        patterns.addAll(maybeSequencePattern.getChildren(PythonGrammar.MAYBE_STAR_PATTERN).stream().map(PythonTreeMaker::maybeStarPattern).collect(Collectors.toList()));
        commas.addAll(PythonTreeMaker.punctuators(maybeSequencePattern, PythonPunctuator.COMMA));
    }

    private static Pattern maybeStarPattern(AstNode maybeStarPattern) {
        AstNode astNode = maybeStarPattern.getFirstChild();
        if (astNode.is(PythonGrammar.STAR_PATTERN)) {
            return PythonTreeMaker.starPattern(astNode);
        }
        return PythonTreeMaker.pattern(astNode.getFirstChild());
    }

    private static StarPattern starPattern(AstNode starPattern) {
        Token starToken = PythonTreeMaker.toPyToken(starPattern.getFirstChild(PythonPunctuator.MUL).getToken());
        AstNode capturePattern = starPattern.getFirstChild(PythonGrammar.CAPTURE_PATTERN);
        PyTree pattern = capturePattern != null ? new CapturePatternImpl(PythonTreeMaker.name(capturePattern.getFirstChild())) : PythonTreeMaker.wildcardPattern(starPattern.getFirstChild(PythonGrammar.WILDCARD_PATTERN));
        return new StarPatternImpl(starToken, (Pattern)((Object)pattern));
    }

    private static WildcardPatternImpl wildcardPattern(AstNode wildcardPattern) {
        return new WildcardPatternImpl(PythonTreeMaker.toPyToken(wildcardPattern.getFirstChild().getToken()));
    }

    private static MappingPattern mappingPattern(AstNode astNode) {
        Token lCurlyBrace = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.LCURLYBRACE).getToken());
        Token rCurlyBrace = PythonTreeMaker.toPyToken(astNode.getLastChild(PythonPunctuator.RCURLYBRACE).getToken());
        AstNode itemsPattern = astNode.getFirstChild(PythonGrammar.ITEMS_PATTERN);
        AstNode doubleStarPattern = astNode.getFirstChild(PythonGrammar.DOUBLE_STAR_PATTERN);
        if (itemsPattern == null && doubleStarPattern == null) {
            return new MappingPatternImpl(lCurlyBrace, Collections.emptyList(), Collections.emptyList(), rCurlyBrace);
        }
        ArrayList<Token> commas = new ArrayList<Token>();
        ArrayList<Pattern> keyValuePatterns = new ArrayList<Pattern>();
        if (itemsPattern != null) {
            commas.addAll(PythonTreeMaker.punctuators(itemsPattern, PythonPunctuator.COMMA));
            List<AstNode> children = itemsPattern.getChildren();
            for (AstNode currentChild : children) {
                if (!currentChild.is(PythonGrammar.KEY_VALUE_PATTERN)) continue;
                List<AstNode> kVChildren = currentChild.getChildren();
                AstNode keyNode = kVChildren.get(0);
                Pattern keyPattern = keyNode.is(PythonGrammar.LITERAL_PATTERN) ? PythonTreeMaker.literalPattern(keyNode) : new ValuePatternImpl((QualifiedExpression)PythonTreeMaker.nameOrAttr(keyNode.getFirstChild()));
                keyValuePatterns.add(new KeyValuePatternImpl(keyPattern, PythonTreeMaker.toPyToken(kVChildren.get(1).getToken()), PythonTreeMaker.pattern(kVChildren.get(2).getFirstChild())));
            }
        }
        commas.addAll(PythonTreeMaker.punctuators(astNode, PythonPunctuator.COMMA));
        if (doubleStarPattern != null) {
            Token doubleStarToken = PythonTreeMaker.toPyToken(doubleStarPattern.getFirstChild(PythonPunctuator.MUL_MUL).getToken());
            CapturePatternImpl capturePattern = new CapturePatternImpl(PythonTreeMaker.name(doubleStarPattern.getFirstChild(PythonGrammar.CAPTURE_PATTERN).getFirstChild()));
            keyValuePatterns.add(new DoubleStarPatternImpl(doubleStarToken, capturePattern));
        }
        return new MappingPatternImpl(lCurlyBrace, commas, keyValuePatterns, rCurlyBrace);
    }

    private static LiteralPattern literalPattern(AstNode literalPattern) {
        Tree.Kind literalKind = literalPattern.hasDirectChildren(PythonGrammar.COMPLEX_NUMBER, PythonGrammar.SIGNED_NUMBER) ? Tree.Kind.NUMERIC_LITERAL_PATTERN : (literalPattern.hasDirectChildren(PythonTokenType.STRING) ? Tree.Kind.STRING_LITERAL_PATTERN : (literalPattern.hasDirectChildren(PythonKeyword.NONE) ? Tree.Kind.NONE_LITERAL_PATTERN : Tree.Kind.BOOLEAN_LITERAL_PATTERN));
        List<Token> tokens = literalPattern.getTokens().stream().map(PythonTreeMaker::toPyToken).collect(Collectors.toList());
        return new LiteralPatternImpl(tokens, literalKind);
    }

    private List<Expression> expressionsFromTest(AstNode astNode) {
        return astNode.getChildren(PythonGrammar.TEST).stream().map(this::expression).collect(Collectors.toList());
    }

    private List<Expression> expressionsFromTestListStarExpr(AstNode astNode) {
        return astNode.getChildren(PythonGrammar.TEST, PythonGrammar.STAR_EXPR).stream().map(this::expression).collect(Collectors.toList());
    }

    private List<Expression> expressionsFromExprList(AstNode firstChild) {
        return firstChild.getChildren(PythonGrammar.EXPR, PythonGrammar.STAR_EXPR).stream().map(this::expression).collect(Collectors.toList());
    }

    private Expression exprListOrTestList(AstNode exprListOrTestList) {
        List<Expression> expressions = exprListOrTestList.getChildren(PythonGrammar.EXPR, PythonGrammar.STAR_EXPR, PythonGrammar.TEST).stream().map(this::expression).collect(Collectors.toList());
        List<AstNode> commas = exprListOrTestList.getChildren(PythonPunctuator.COMMA);
        if (commas.isEmpty()) {
            return (Expression)expressions.get(0);
        }
        List<Token> commaTokens = PythonTreeMaker.toPyToken(commas.stream().map(AstNode::getToken).collect(Collectors.toList()));
        return new TupleImpl(null, expressions, commaTokens, null);
    }

    public Expression expression(AstNode astNode) {
        if (astNode.is(PythonGrammar.ATOM) && astNode.getFirstChild().is(PythonPunctuator.LBRACKET)) {
            return this.listLiteral(astNode);
        }
        if (astNode.is(PythonGrammar.ATOM) && astNode.getFirstChild().is(PythonPunctuator.LPARENTHESIS)) {
            return this.parenthesized(astNode);
        }
        if (astNode.is(PythonGrammar.ATOM) && astNode.getFirstChild().is(PythonPunctuator.LCURLYBRACE)) {
            return this.dictOrSetLiteral(astNode);
        }
        if (astNode.is(PythonGrammar.ATOM) && astNode.getFirstChild().is(PythonPunctuator.BACKTICK)) {
            return this.repr(astNode);
        }
        if (astNode.is(PythonGrammar.ATOM) && astNode.getFirstChild().is(PythonTokenType.STRING)) {
            return this.stringLiteral(astNode);
        }
        if (astNode.is(PythonGrammar.ATOM) && astNode.getChildren().size() == 1) {
            return this.expression(astNode.getFirstChild());
        }
        if (astNode.is(PythonGrammar.TEST) && astNode.hasDirectChildren(PythonKeyword.IF)) {
            return this.conditionalExpression(astNode);
        }
        if (astNode.is(PythonTokenType.NUMBER)) {
            return PythonTreeMaker.numericLiteral(astNode);
        }
        if (astNode.is(PythonGrammar.YIELD_EXPR)) {
            return this.yieldExpression(astNode);
        }
        if (astNode.is(PythonGrammar.NAME)) {
            return PythonTreeMaker.name(astNode);
        }
        if (astNode.is(PythonGrammar.NAMED_EXPR_TEST) && astNode.hasDirectChildren(PythonPunctuator.WALRUS_OPERATOR)) {
            return this.assignmentExpression(astNode);
        }
        if (astNode.is(PythonGrammar.EXPR, PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.TEST, PythonGrammar.TEST_NOCOND)) {
            if (astNode.getChildren().size() == 1) {
                return this.expression(astNode.getFirstChild());
            }
            return this.binaryExpression(astNode);
        }
        if (astNode.is(PythonGrammar.A_EXPR, PythonGrammar.M_EXPR, PythonGrammar.SHIFT_EXPR, PythonGrammar.AND_EXPR, PythonGrammar.OR_EXPR, PythonGrammar.XOR_EXPR, PythonGrammar.AND_TEST, PythonGrammar.OR_TEST, PythonGrammar.COMPARISON)) {
            return this.binaryExpression(astNode);
        }
        if (astNode.is(PythonGrammar.POWER)) {
            return this.powerExpression(astNode);
        }
        if (astNode.is(PythonGrammar.LAMBDEF, PythonGrammar.LAMBDEF_NOCOND)) {
            return this.lambdaExpression(astNode);
        }
        if (astNode.is(PythonGrammar.FACTOR, PythonGrammar.NOT_TEST)) {
            return new UnaryExpressionImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken()), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(PythonGrammar.STAR_EXPR)) {
            return new UnpackingExpressionImpl(PythonTreeMaker.toPyToken(astNode.getToken()), this.expression(astNode.getLastChild()));
        }
        if (astNode.is(PythonKeyword.NONE)) {
            return new NoneExpressionImpl(PythonTreeMaker.toPyToken(astNode.getToken()));
        }
        if (astNode.is(PythonGrammar.ELLIPSIS)) {
            return new EllipsisExpressionImpl(PythonTreeMaker.toPyToken(astNode.getTokens()));
        }
        if (astNode.is(PythonGrammar.TESTLIST_STAR_EXPR)) {
            return this.exprListOrTestList(astNode);
        }
        if (astNode.is(PythonGrammar.STAR_NAMED_EXPRESSIONS)) {
            return this.starNamedExpressions(astNode);
        }
        if (astNode.is(PythonGrammar.SUBJECT_EXPR, PythonGrammar.STAR_NAMED_EXPRESSION)) {
            return this.expression(astNode.getFirstChild());
        }
        throw new IllegalStateException("Expression " + astNode.getType() + " not correctly translated to strongly typed AST");
    }

    private Expression starNamedExpressions(AstNode astNode) {
        List<Expression> expressions = astNode.getChildren(PythonGrammar.STAR_NAMED_EXPRESSION).stream().map(this::expression).collect(Collectors.toList());
        List<AstNode> commas = astNode.getChildren(PythonPunctuator.COMMA);
        if (!commas.isEmpty()) {
            List<Token> commaTokens = PythonTreeMaker.toPyToken(commas.stream().map(AstNode::getToken).collect(Collectors.toList()));
            return new TupleImpl(null, expressions, commaTokens, null);
        }
        return (Expression)expressions.get(0);
    }

    private Expression assignmentExpression(AstNode astNode) {
        AstNode nameNode = astNode.getFirstChild(PythonGrammar.TEST);
        Expression nameExpression = this.expression(nameNode);
        if (!nameExpression.is(Tree.Kind.NAME)) {
            int line = nameNode.getTokenLine();
            PythonTreeMaker.recognitionException(line, "The left-hand side of an assignment expression must be a name");
        }
        Name name = (Name)nameExpression;
        AstNode operatorNode = astNode.getFirstChild(PythonPunctuator.WALRUS_OPERATOR);
        Token operatorToken = PythonTreeMaker.toPyToken(operatorNode.getToken());
        Expression expression = this.expression(astNode.getLastChild(PythonGrammar.TEST));
        return new AssignmentExpressionImpl(name, operatorToken, expression);
    }

    private Expression repr(AstNode astNode) {
        Token openingBacktick = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.BACKTICK).getToken());
        Token closingBacktick = PythonTreeMaker.toPyToken(astNode.getLastChild(PythonPunctuator.BACKTICK).getToken());
        List<Expression> expressions = astNode.getChildren(PythonGrammar.TEST).stream().map(this::expression).collect(Collectors.toList());
        List<Token> commas = PythonTreeMaker.punctuators(astNode, PythonPunctuator.COMMA);
        ExpressionListImpl expressionListTree = new ExpressionListImpl(expressions, commas);
        return new ReprExpressionImpl(openingBacktick, expressionListTree, closingBacktick);
    }

    private static List<Token> punctuators(AstNode astNode, PythonPunctuator punctuator) {
        return PythonTreeMaker.toPyToken(astNode.getChildren(punctuator).stream().map(AstNode::getToken).collect(Collectors.toList()));
    }

    private Expression dictOrSetLiteral(AstNode astNode) {
        Token lCurlyBrace = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.LCURLYBRACE).getToken());
        Token rCurlyBrace = PythonTreeMaker.toPyToken(astNode.getLastChild(PythonPunctuator.RCURLYBRACE).getToken());
        AstNode dictOrSetMaker = astNode.getFirstChild(PythonGrammar.DICTORSETMAKER);
        if (dictOrSetMaker == null) {
            return new DictionaryLiteralImpl(lCurlyBrace, Collections.emptyList(), Collections.emptyList(), rCurlyBrace);
        }
        AstNode compForNode = dictOrSetMaker.getFirstChild(PythonGrammar.COMP_FOR);
        if (compForNode != null) {
            ComprehensionFor compFor = this.compFor(compForNode);
            AstNode colon = dictOrSetMaker.getFirstChild(PythonPunctuator.COLON);
            if (colon != null) {
                Expression keyExpression = this.expression(dictOrSetMaker.getFirstChild(PythonGrammar.TEST));
                Expression valueExpression = this.expression(dictOrSetMaker.getLastChild(PythonGrammar.TEST));
                return new DictCompExpressionImpl(lCurlyBrace, keyExpression, PythonTreeMaker.toPyToken(colon.getToken()), valueExpression, compFor, rCurlyBrace);
            }
            Expression resultExpression = this.expression(dictOrSetMaker.getFirstChild(PythonGrammar.TEST, PythonGrammar.STAR_EXPR));
            return new ComprehensionExpressionImpl(Tree.Kind.SET_COMPREHENSION, lCurlyBrace, resultExpression, compFor, rCurlyBrace);
        }
        List<Token> commas = PythonTreeMaker.punctuators(dictOrSetMaker, PythonPunctuator.COMMA);
        if (dictOrSetMaker.hasDirectChildren(PythonPunctuator.COLON) || dictOrSetMaker.hasDirectChildren(PythonPunctuator.MUL_MUL)) {
            ArrayList<DictionaryLiteralElement> dictionaryLiteralElements = new ArrayList<DictionaryLiteralElement>();
            List<AstNode> children = dictOrSetMaker.getChildren();
            int index = 0;
            while (index < children.size()) {
                AstNode currentChild = children.get(index);
                if (currentChild.is(PythonPunctuator.MUL_MUL)) {
                    dictionaryLiteralElements.add(new UnpackingExpressionImpl(PythonTreeMaker.toPyToken(currentChild.getToken()), this.expression(children.get(index + 1))));
                    index += 3;
                    continue;
                }
                dictionaryLiteralElements.add(new KeyValuePairImpl(this.expression(currentChild), PythonTreeMaker.toPyToken(children.get(index + 1).getToken()), this.expression(children.get(index + 2))));
                index += 4;
            }
            return new DictionaryLiteralImpl(lCurlyBrace, commas, (List<DictionaryLiteralElement>)dictionaryLiteralElements, rCurlyBrace);
        }
        List<Expression> expressions = dictOrSetMaker.getChildren(PythonGrammar.TEST, PythonGrammar.STAR_EXPR).stream().map(this::expression).collect(Collectors.toList());
        return new SetLiteralImpl(lCurlyBrace, expressions, commas, rCurlyBrace);
    }

    private Expression parenthesized(AstNode atom) {
        Token lPar = PythonTreeMaker.toPyToken(atom.getFirstChild().getToken());
        Token rPar = PythonTreeMaker.toPyToken(atom.getLastChild().getToken());
        AstNode yieldNode = atom.getFirstChild(PythonGrammar.YIELD_EXPR);
        if (yieldNode != null) {
            return new ParenthesizedExpressionImpl(lPar, this.expression(yieldNode), rPar);
        }
        AstNode testListComp = atom.getFirstChild(PythonGrammar.TESTLIST_COMP);
        if (testListComp == null) {
            return new TupleImpl(lPar, Collections.emptyList(), Collections.emptyList(), rPar);
        }
        AstNode compFor = testListComp.getFirstChild(PythonGrammar.COMP_FOR);
        if (compFor != null) {
            return new ComprehensionExpressionImpl(Tree.Kind.GENERATOR_EXPR, lPar, this.expression(testListComp.getFirstChild()), this.compFor(compFor), rPar);
        }
        ExpressionList expressionList = this.expressionList(testListComp);
        List<AstNode> commas = testListComp.getChildren(PythonPunctuator.COMMA);
        if (commas.isEmpty()) {
            Expression expression = expressionList.expressions().get(0);
            return new ParenthesizedExpressionImpl(lPar, expression, rPar);
        }
        List<Token> commaTokens = PythonTreeMaker.toPyToken(commas.stream().map(AstNode::getToken).collect(Collectors.toList()));
        return new TupleImpl(lPar, expressionList.expressions(), commaTokens, rPar);
    }

    private ConditionalExpression conditionalExpression(AstNode astNode) {
        List<AstNode> children = astNode.getChildren();
        Expression trueExpression = this.expression(children.get(0));
        Token ifToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.IF).getToken());
        Expression condition = this.expression(children.get(2));
        Token elseToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.ELSE).getToken());
        Expression falseExpression = this.expression(children.get(4));
        return new ConditionalExpressionImpl(trueExpression, ifToken, condition, elseToken, falseExpression);
    }

    private Expression powerExpression(AstNode astNode) {
        AstNode powerOperator;
        Expression expr = this.expression(astNode.getFirstChild(PythonGrammar.ATOM));
        for (AstNode trailer : astNode.getChildren(PythonGrammar.TRAILER)) {
            expr = this.withTrailer(expr, trailer);
        }
        if (astNode.getFirstChild().is(GenericTokenType.IDENTIFIER)) {
            expr = new AwaitExpressionImpl(PythonTreeMaker.toPyToken(astNode.getFirstChild().getToken()), expr);
        }
        if ((powerOperator = astNode.getFirstChild(PythonPunctuator.MUL_MUL)) != null) {
            expr = new BinaryExpressionImpl(expr, PythonTreeMaker.toPyToken(powerOperator.getToken()), this.expression(powerOperator.getNextSibling()));
        }
        return expr;
    }

    private Expression withTrailer(Expression expr, AstNode trailer) {
        AstNode firstChild = trailer.getFirstChild();
        if (firstChild.is(PythonPunctuator.LPARENTHESIS)) {
            AstNode argListNode = trailer.getFirstChild(PythonGrammar.ARGLIST);
            ArgList argumentList = this.argList(argListNode);
            if (argumentList != null) {
                PythonTreeMaker.checkGeneratorExpressionInArgument(argumentList.arguments());
            }
            Token leftPar = PythonTreeMaker.toPyToken(firstChild.getToken());
            Token rightPar = PythonTreeMaker.toPyToken(trailer.getFirstChild(PythonPunctuator.RPARENTHESIS).getToken());
            return new CallExpressionImpl(expr, argumentList, leftPar, rightPar);
        }
        if (firstChild.is(PythonPunctuator.LBRACKET)) {
            Token leftBracket = PythonTreeMaker.toPyToken(trailer.getFirstChild(PythonPunctuator.LBRACKET).getToken());
            Token rightBracket = PythonTreeMaker.toPyToken(trailer.getFirstChild(PythonPunctuator.RBRACKET).getToken());
            return this.subscriptionOrSlicing(expr, leftBracket, trailer.getFirstChild(PythonGrammar.SUBSCRIPTLIST), rightBracket);
        }
        Name name = PythonTreeMaker.name(trailer.getFirstChild(PythonGrammar.NAME));
        return new QualifiedExpressionImpl(name, expr, PythonTreeMaker.toPyToken(trailer.getFirstChild(PythonPunctuator.DOT).getToken()));
    }

    private Expression subscriptionOrSlicing(Expression expr, Token leftBracket, AstNode subscriptList, Token rightBracket) {
        ArrayList<Tree> slices = new ArrayList<Tree>();
        for (AstNode subscript : subscriptList.getChildren(PythonGrammar.SUBSCRIPT)) {
            AstNode colon = subscript.getFirstChild(PythonPunctuator.COLON);
            if (colon == null) {
                slices.add(this.expression(subscript.getFirstChild(PythonGrammar.NAMED_EXPR_TEST)));
                continue;
            }
            slices.add(this.sliceItem(subscript));
        }
        if (slices.stream().anyMatch(s -> Tree.Kind.SLICE_ITEM.equals((Object)s.getKind()))) {
            List<Token> separators = PythonTreeMaker.punctuators(subscriptList, PythonPunctuator.COMMA);
            SliceListImpl sliceList = new SliceListImpl(slices, separators);
            return new SliceExpressionImpl(expr, leftBracket, sliceList, rightBracket);
        }
        List<Expression> expressions = slices.stream().map(Expression.class::cast).collect(Collectors.toList());
        List<Token> commas = PythonTreeMaker.punctuators(subscriptList, PythonPunctuator.COMMA);
        ExpressionListImpl subscripts = new ExpressionListImpl(expressions, commas);
        return new SubscriptionExpressionImpl(expr, leftBracket, subscripts, rightBracket);
    }

    SliceItem sliceItem(AstNode subscript) {
        AstNode boundSeparator = subscript.getFirstChild(PythonPunctuator.COLON);
        Expression lowerBound = this.sliceBound(boundSeparator.getPreviousSibling());
        Expression upperBound = this.sliceBound(boundSeparator.getNextSibling());
        AstNode strideNode = subscript.getFirstChild(PythonGrammar.SLICEOP);
        Token strideSeparator = strideNode == null ? null : PythonTreeMaker.toPyToken(strideNode.getToken());
        Expression stride = null;
        if (strideNode != null && strideNode.hasDirectChildren(PythonGrammar.TEST)) {
            stride = this.expression(strideNode.getLastChild());
        }
        return new SliceItemImpl(lowerBound, PythonTreeMaker.toPyToken(boundSeparator.getToken()), upperBound, strideSeparator, stride);
    }

    @CheckForNull
    private Expression sliceBound(@Nullable AstNode node) {
        if (node == null || !node.is(PythonGrammar.TEST)) {
            return null;
        }
        return this.expression(node);
    }

    private Expression listLiteral(AstNode astNode) {
        ExpressionList elements;
        Token leftBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.LBRACKET).getToken());
        Token rightBracket = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.RBRACKET).getToken());
        AstNode testListComp = astNode.getFirstChild(PythonGrammar.TESTLIST_COMP);
        if (testListComp != null) {
            AstNode compForNode = testListComp.getFirstChild(PythonGrammar.COMP_FOR);
            if (compForNode != null) {
                Expression resultExpression = this.expression(testListComp.getFirstChild(PythonGrammar.NAMED_EXPR_TEST, PythonGrammar.STAR_EXPR));
                return new ComprehensionExpressionImpl(Tree.Kind.LIST_COMPREHENSION, leftBracket, resultExpression, this.compFor(compForNode), rightBracket);
            }
            elements = this.expressionList(testListComp);
        } else {
            elements = new ExpressionListImpl(Collections.emptyList(), Collections.emptyList());
        }
        return new ListLiteralImpl(leftBracket, elements, rightBracket);
    }

    private ComprehensionFor compFor(AstNode compFor) {
        Expression expression = this.exprListOrTestList(compFor.getFirstChild(PythonGrammar.EXPRLIST));
        AstNode forSSLRToken = compFor.getFirstChild(PythonKeyword.FOR);
        Token asyncToken = null;
        AstNode previousSibling = forSSLRToken.getPreviousSibling();
        if (previousSibling != null) {
            asyncToken = PythonTreeMaker.toPyToken(previousSibling.getToken());
        }
        Token forToken = PythonTreeMaker.toPyToken(forSSLRToken.getToken());
        Token inToken = PythonTreeMaker.toPyToken(compFor.getFirstChild(PythonKeyword.IN).getToken());
        Expression iterable = this.exprListOrTestList(compFor.getFirstChild(PythonGrammar.TESTLIST));
        ComprehensionClause nested = this.compClause(compFor.getFirstChild(PythonGrammar.COMP_ITER));
        return new ComprehensionForImpl(asyncToken, forToken, expression, inToken, iterable, nested);
    }

    @CheckForNull
    private ComprehensionClause compClause(@Nullable AstNode node) {
        if (node == null) {
            return null;
        }
        AstNode child = node.getFirstChild();
        if (child.is(PythonGrammar.COMP_FOR)) {
            return this.compFor(child);
        }
        Expression condition = this.expression(child.getFirstChild(PythonGrammar.TEST_NOCOND));
        ComprehensionClause nestedClause = this.compClause(child.getFirstChild(PythonGrammar.COMP_ITER));
        Token ifToken = PythonTreeMaker.toPyToken(child.getFirstChild(PythonKeyword.IF).getToken());
        return new ComprehensionIfImpl(ifToken, condition, nestedClause);
    }

    @CheckForNull
    private ArgList argList(@Nullable AstNode argList) {
        if (argList != null) {
            List<Argument> arguments = argList.getChildren(PythonGrammar.ARGUMENT).stream().map(this::argument).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(argList, PythonPunctuator.COMMA);
            return new ArgListImpl(arguments, commas);
        }
        return null;
    }

    private static void checkGeneratorExpressionInArgument(List<Argument> arguments) {
        List nonParenthesizedGeneratorExpressions = arguments.stream().filter(arg -> arg.is(Tree.Kind.REGULAR_ARGUMENT)).map(RegularArgument.class::cast).filter(arg -> arg.expression().is(Tree.Kind.GENERATOR_EXPR) && !arg.expression().firstToken().value().equals("(")).collect(Collectors.toList());
        if (!nonParenthesizedGeneratorExpressions.isEmpty() && arguments.size() > 1) {
            int line = ((Argument)nonParenthesizedGeneratorExpressions.get(0)).firstToken().line();
            PythonTreeMaker.recognitionException(line, "Generator expression must be parenthesized if not sole argument");
        }
    }

    public Argument argument(AstNode astNode) {
        Token star;
        AstNode compFor = astNode.getFirstChild(PythonGrammar.COMP_FOR);
        if (compFor != null) {
            Expression expression = this.expression(astNode.getFirstChild());
            ComprehensionExpressionImpl comprehension = new ComprehensionExpressionImpl(Tree.Kind.GENERATOR_EXPR, null, expression, this.compFor(compFor), null);
            return new RegularArgumentImpl(comprehension);
        }
        AstNode walrusOperator = astNode.getFirstChild(PythonPunctuator.WALRUS_OPERATOR);
        if (walrusOperator != null) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)this.assignmentExpression(astNode);
            return new RegularArgumentImpl(assignmentExpression);
        }
        AstNode assign = astNode.getFirstChild(PythonPunctuator.ASSIGN);
        Token token = star = astNode.getFirstChild(PythonPunctuator.MUL) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.MUL).getToken());
        if (star == null) {
            star = astNode.getFirstChild(PythonPunctuator.MUL_MUL) == null ? null : PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.MUL_MUL).getToken());
        }
        Expression arg = this.expression(astNode.getLastChild(PythonGrammar.TEST));
        if (assign != null) {
            AstNode nameNode = astNode.getFirstChild(PythonGrammar.TEST).getFirstChild(PythonGrammar.ATOM).getFirstChild(PythonGrammar.NAME);
            return new RegularArgumentImpl(PythonTreeMaker.name(nameNode), PythonTreeMaker.toPyToken(assign.getToken()), arg);
        }
        return star == null ? new RegularArgumentImpl(arg) : new UnpackingExpressionImpl(star, arg);
    }

    private Expression binaryExpression(AstNode astNode) {
        List<AstNode> children = astNode.getChildren();
        Expression result = this.expression(children.get(0));
        for (int i = 1; i < astNode.getNumberOfChildren(); i += 2) {
            Token notToken;
            AstNode operator = children.get(i);
            Expression rightOperand = this.expression(operator.getNextSibling());
            AstNode not = operator.getFirstChild(PythonKeyword.NOT);
            Token token = notToken = not == null ? null : PythonTreeMaker.toPyToken(not.getToken());
            result = PythonKeyword.IN.equals(operator.getLastToken().getType()) ? new InExpressionImpl(result, notToken, PythonTreeMaker.toPyToken(operator.getLastToken()), rightOperand) : (PythonKeyword.IS.equals(operator.getToken().getType()) ? new IsExpressionImpl(result, PythonTreeMaker.toPyToken(operator.getToken()), notToken, rightOperand) : new BinaryExpressionImpl(result, PythonTreeMaker.toPyToken(operator.getToken()), rightOperand));
        }
        return result;
    }

    public LambdaExpression lambdaExpression(AstNode astNode) {
        Token lambdaKeyword = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonKeyword.LAMBDA).getToken());
        Token colonToken = PythonTreeMaker.toPyToken(astNode.getFirstChild(PythonPunctuator.COLON).getToken());
        Expression body = this.expression(astNode.getFirstChild(PythonGrammar.TEST, PythonGrammar.TEST_NOCOND));
        AstNode varArgsListNode = astNode.getFirstChild(PythonGrammar.VARARGSLIST);
        ParameterListImpl argListTree = null;
        if (varArgsListNode != null) {
            List<AnyParameter> parameters = varArgsListNode.getChildren(PythonGrammar.FPDEF, PythonGrammar.NAME, PythonPunctuator.MUL, PythonPunctuator.DIV).stream().map(this::parameter).filter(Objects::nonNull).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(varArgsListNode, PythonPunctuator.COMMA);
            argListTree = new ParameterListImpl(parameters, commas);
        }
        return new LambdaExpressionImpl(lambdaKeyword, colonToken, body, argListTree);
    }

    private AnyParameter parameter(AstNode parameter) {
        if (parameter.is(PythonPunctuator.DIV)) {
            return new ParameterImpl(PythonTreeMaker.toPyToken(parameter.getToken()));
        }
        if (parameter.is(PythonPunctuator.MUL)) {
            if (parameter.getNextSibling() == null || parameter.getNextSibling().is(PythonPunctuator.COMMA)) {
                return new ParameterImpl(PythonTreeMaker.toPyToken(parameter.getToken()));
            }
            return null;
        }
        AstNode prevSibling = parameter.getPreviousSibling();
        if (parameter.is(PythonGrammar.NAME)) {
            return new ParameterImpl(PythonTreeMaker.toPyToken(prevSibling.getToken()), PythonTreeMaker.name(parameter), null, null, null);
        }
        AstNode paramList = parameter.getFirstChild(PythonGrammar.TFPLIST, PythonGrammar.FPLIST);
        if (paramList != null) {
            List<AnyParameter> params = paramList.getChildren(PythonGrammar.TFPDEF, PythonGrammar.FPDEF).stream().map(this::parameter).collect(Collectors.toList());
            List<Token> commas = PythonTreeMaker.punctuators(paramList, PythonPunctuator.COMMA);
            return new TupleParameterImpl(PythonTreeMaker.toPyToken(parameter.getFirstChild(PythonPunctuator.LPARENTHESIS).getToken()), params, commas, PythonTreeMaker.toPyToken(parameter.getFirstChild(PythonPunctuator.RPARENTHESIS).getToken()));
        }
        Token starOrStarStar = null;
        if (prevSibling != null && prevSibling.is(PythonPunctuator.MUL, PythonPunctuator.MUL_MUL)) {
            starOrStarStar = PythonTreeMaker.toPyToken(prevSibling.getToken());
        }
        Name name = PythonTreeMaker.name(parameter.getFirstChild(PythonGrammar.NAME));
        AstNode nextSibling = parameter.getNextSibling();
        Token assignToken = null;
        Expression defaultValue = null;
        if (nextSibling != null && nextSibling.is(PythonPunctuator.ASSIGN)) {
            assignToken = PythonTreeMaker.toPyToken(nextSibling.getToken());
            defaultValue = this.expression(nextSibling.getNextSibling());
        }
        TypeAnnotationImpl typeAnnotation = null;
        AstNode testNode = parameter.getFirstChild(PythonGrammar.TEST);
        if (testNode != null) {
            Token colonToken = PythonTreeMaker.toPyToken(parameter.getFirstChild(PythonPunctuator.COLON).getToken());
            typeAnnotation = new TypeAnnotationImpl(colonToken, this.expression(testNode), Tree.Kind.PARAMETER_TYPE_ANNOTATION);
        }
        return new ParameterImpl(starOrStarStar, name, typeAnnotation, assignToken, defaultValue);
    }

    private static Expression numericLiteral(AstNode astNode) {
        return new NumericLiteralImpl(PythonTreeMaker.toPyToken(astNode.getToken()));
    }

    private Expression stringLiteral(AstNode astNode) {
        ArrayList<StringElement> elements = new ArrayList<StringElement>();
        for (AstNode elementNode : astNode.getChildren(PythonTokenType.STRING)) {
            com.sonar.sslr.api.Token token = elementNode.getToken();
            StringElementImpl element = new StringElementImpl(PythonTreeMaker.toPyToken(token));
            if (element.isInterpolated()) {
                F_STRING_PARSER.fStringExpressions(token).forEach(expressionNode -> element.addFormattedExpression(this.formattedExpression((AstNode)expressionNode)));
            }
            elements.add(element);
        }
        return new StringLiteralImpl(elements);
    }

    private FormatSpecifier formatSpecifier(AstNode expressionNode) {
        AstNode formatSpecifierNode = expressionNode.getFirstChild(PythonGrammar.FORMAT_SPECIFIER);
        if (formatSpecifierNode == null) {
            return null;
        }
        Token columnToken = PythonTreeMaker.toPyToken(formatSpecifierNode.getFirstChild(PythonPunctuator.COLON).getToken());
        List<FormattedExpression> nestedExpressions = formatSpecifierNode.getChildren(PythonGrammar.FORMATTED_EXPR).stream().map(this::formattedExpression).collect(Collectors.toList());
        return new FormatSpecifierImpl(columnToken, nestedExpressions);
    }

    private FormattedExpression formattedExpression(AstNode expressionNode) {
        Expression exp = this.expression(expressionNode.getFirstChild(PythonGrammar.TEST));
        AstNode equalNode = expressionNode.getFirstChild(PythonPunctuator.ASSIGN);
        Token equalToken = equalNode == null ? null : PythonTreeMaker.toPyToken(equalNode.getToken());
        FormatSpecifier formatSpecifier = this.formatSpecifier(expressionNode);
        return new FormattedExpressionImpl(exp, equalToken, formatSpecifier);
    }

    private static Token suiteIndent(AstNode suite) {
        return suite.getFirstChild(PythonTokenType.INDENT) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(PythonTokenType.INDENT).getToken());
    }

    private static Token suiteNewLine(AstNode suite) {
        return suite.getFirstChild(PythonTokenType.INDENT) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(PythonTokenType.NEWLINE).getToken());
    }

    private static Token suiteDedent(AstNode suite) {
        return suite.getFirstChild(PythonTokenType.DEDENT) == null ? null : PythonTreeMaker.toPyToken(suite.getFirstChild(PythonTokenType.DEDENT).getToken());
    }
}

