/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum EncryptOption {
    False,
    No,
    Optional,
    True,
    Mandatory,
    Strict;


    static EncryptOption valueOfString(String value) throws SQLServerException {
        EncryptOption option = null;
        String val = value.toLowerCase(Locale.US);
        if (val.equalsIgnoreCase(False.toString()) || val.equalsIgnoreCase(No.toString()) || val.equalsIgnoreCase(Optional.toString())) {
            option = False;
        } else if (val.equalsIgnoreCase(True.toString()) || val.equalsIgnoreCase(Mandatory.toString())) {
            option = True;
        } else if (val.equalsIgnoreCase(Strict.toString())) {
            option = Strict;
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidConnectionSetting"));
            Object[] msgArgs = new Object[]{"EncryptOption", value};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        return option;
    }

    static boolean isValidEncryptOption(String option) {
        for (EncryptOption t : EncryptOption.values()) {
            if (!option.equalsIgnoreCase(t.toString())) continue;
            return true;
        }
        return false;
    }
}

