/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="XPathCheck")
public class XPathCheck
extends SonarXmlCheck {
    private static final Logger LOG = Loggers.get(XPathCheck.class);
    public static final String RULE_KEY = "XPathCheck";
    @RuleProperty(key="expression", description="The XPath query", type="TEXT")
    private String expression;
    @RuleProperty(key="filePattern", description="The files to be validated using Ant-style matching patterns")
    private String filePattern;
    @RuleProperty(key="message", description="The issue message", defaultValue="The XPath expression matches this piece of code")
    private String message;

    @Override
    public void scanFile(XmlFile file) {
        block7: {
            if (!this.isFileIncluded(file)) {
                return;
            }
            XPathExpression xPathExpression = this.getXPathExpression(file);
            boolean xPathRequiresNamespaces = this.expression.contains(":") || this.expression.contains("namespace-uri");
            Document document = xPathRequiresNamespaces ? file.getNamespaceAwareDocument() : file.getNamespaceUnawareDocument();
            try {
                NodeList nodes = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    this.reportIssue(nodes.item(i), this.getMessage());
                }
            }
            catch (XPathExpressionException nodeSetException) {
                try {
                    Boolean result = (Boolean)xPathExpression.evaluate(document, XPathConstants.BOOLEAN);
                    if (Boolean.TRUE.equals(result)) {
                        this.reportIssueOnFile(this.getMessage(), Collections.emptyList());
                    }
                }
                catch (XPathExpressionException booleanException) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug(String.format("[%s] Unable to evaluate XPath expression '%s' on file %s", this.ruleKey(), this.expression, this.inputFile().toString()));
                    LOG.error("Xpath exception:", (Throwable)booleanException);
                }
            }
        }
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        if (this.message != null && !this.message.trim().isEmpty()) {
            return this.message;
        }
        return "Change this XML node to not match: " + this.expression;
    }

    private XPathExpression getXPathExpression(XmlFile file) {
        XPathExpression xPathExpression;
        XPath xpath = XPathFactory.newInstance().newXPath();
        PrefixResolver resolver = new PrefixResolver(file.getDocument().getDocumentElement());
        xpath.setNamespaceContext(new DocumentNamespaceContext(resolver));
        try {
            xPathExpression = xpath.compile(this.expression);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Failed to compile XPath expression based on user-provided parameter [" + this.expression + "]", e);
        }
        return xPathExpression;
    }

    private boolean isFileIncluded(XmlFile file) {
        return this.filePattern == null || WildcardPattern.create((String)this.filePattern).match(file.getInputFile().absolutePath());
    }

    private static class PrefixResolver {
        Node mContext;

        public PrefixResolver(Node xpathExpressionContext) {
            this.mContext = xpathExpressionContext;
        }

        public String getNamespaceForPrefix(String prefix) {
            return this.getNamespaceForPrefix(prefix, this.mContext);
        }

        @CheckForNull
        public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            for (Node current = namespaceContext; current != null; current = current.getParentNode()) {
                if (current.getNodeName().indexOf(prefix + ":") == 0) {
                    return current.getNamespaceURI();
                }
                NamedNodeMap attributes = current.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    if (!prefix.equals(PrefixResolver.extractPrefixFromAttribute(attr))) continue;
                    return attr.getNodeValue();
                }
            }
            return null;
        }

        @CheckForNull
        private static String extractPrefixFromAttribute(Node attr) {
            String attrName = attr.getNodeName();
            if (attrName.startsWith("xmlns:")) {
                return attrName.substring(attrName.indexOf(58) + 1);
            }
            return null;
        }
    }

    private static final class DocumentNamespaceContext
    implements NamespaceContext {
        private final PrefixResolver resolver;

        private DocumentNamespaceContext(PrefixResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.resolver.getNamespaceForPrefix(prefix);
        }

        @Override
        public String getPrefix(String uri) {
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String val) {
            return null;
        }
    }
}

