/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.ejb;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;

@Rule(key="S3282")
@DeprecatedRuleKey(repositoryKey="java", ruleKey="S3282")
public class InterceptorExclusionsCheck
extends SimpleXPathBasedCheck {
    private XPathExpression notDefaultInterceptorBindingsExpression = this.getXPathExpression("ejb-jar/assembly-descriptor/interceptor-binding[ejb-name!=\"*\"]");
    private XPathExpression exclusionsExpression = this.getXPathExpression("*[self::exclude-default-interceptors[text()=\"true\"] or self::exclude-class-interceptors[text()=\"true\"]]");

    @Override
    public void scanFile(XmlFile xmlFile) {
        this.evaluateAsList(this.notDefaultInterceptorBindingsExpression, xmlFile.getNamespaceUnawareDocument()).forEach(this::checkExclusions);
    }

    private void checkExclusions(Node interceptorBinding) {
        this.evaluateAsList(this.exclusionsExpression, interceptorBinding).forEach(node -> this.reportIssue((Node)node, "Move this exclusion into the class as an annotation."));
    }
}

