/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.util.Collection;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.SafeMath;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterator;

public interface ByteCollection
extends ByteIterable,
Collection<Byte> {
    @Override
    public ByteIterator iterator();

    @Override
    public boolean add(byte var1);

    public boolean contains(byte var1);

    public boolean rem(byte var1);

    @Override
    @Deprecated
    default public boolean add(Byte key) {
        return this.add((byte)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Byte)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Byte)key);
    }

    public byte[] toByteArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Byte> filter2) {
        return this.removeIf((int key) -> filter2.test(SafeMath.safeIntToByte(key)));
    }

    default public boolean removeIf(IntPredicate filter2) {
        Objects.requireNonNull(filter2);
        boolean removed = false;
        ByteIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter2.test(each.nextByte())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }
}

