/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.AbstractInvokeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactoryProviderForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.ExplicitReceiverScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.InvokeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerData;
import org.jetbrains.kotlin.resolve.scopes.receivers.DetailedReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/InvokeTowerProcessor;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractInvokeTowerProcessor;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "name", "Lorg/jetbrains/kotlin/name/Name;", "factoryProviderForInvoke", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/DetailedReceiver;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;Lorg/jetbrains/kotlin/resolve/scopes/receivers/DetailedReceiver;)V", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "createInvokeProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "variableCandidate", "(Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;)Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "mayDataBeApplicable", "", "data", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;", "recordLookups", "", "skippedData", "", "resolution"})
public final class InvokeTowerProcessor<C extends Candidate>
extends AbstractInvokeTowerProcessor<C> {
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final Name name;

    public InvokeTowerProcessor(@NotNull ImplicitScopeTower scopeTower, @NotNull Name name, @NotNull CandidateFactoryProviderForInvoke<C> factoryProviderForInvoke, @Nullable DetailedReceiver explicitReceiver) {
        Intrinsics.checkNotNullParameter(scopeTower, "scopeTower");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(factoryProviderForInvoke, "factoryProviderForInvoke");
        super(factoryProviderForInvoke, ScopeTowerProcessorsKt.createVariableAndObjectProcessor$default(scopeTower, name, factoryProviderForInvoke.factoryForVariable(false), explicitReceiver, false, 16, null));
        this.scopeTower = scopeTower;
        this.name = name;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final Name getName() {
        return this.name;
    }

    @Override
    @Nullable
    protected ScopeTowerProcessor<C> createInvokeProcessor(@NotNull C variableCandidate) {
        Intrinsics.checkNotNullParameter(variableCandidate, "variableCandidate");
        Pair pair = this.getFactoryProviderForInvoke().factoryForInvoke(variableCandidate, false);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        ReceiverValueWithSmartCastInfo variableReceiver = pair2.component1();
        CandidateFactory invokeContext = pair2.component2();
        return new ExplicitReceiverScopeTowerProcessor(this.scopeTower, invokeContext, variableReceiver, createInvokeProcessor.1.INSTANCE);
    }

    @Override
    protected boolean mayDataBeApplicable(@NotNull TowerData data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return Intrinsics.areEqual(data2, TowerData.Empty.INSTANCE) || data2 instanceof TowerData.TowerLevel;
    }

    @Override
    public void recordLookups(@NotNull Collection<? extends TowerData> skippedData, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(skippedData, "skippedData");
        Intrinsics.checkNotNullParameter(name, "name");
        this.getVariableProcessor().recordLookups(skippedData, name);
        if (!this.hasInvokeProcessors()) {
            return;
        }
        Iterable $this$forEach$iv = skippedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TowerData it = (TowerData)element$iv;
            boolean bl = false;
            if (!(it instanceof TowerData.TowerLevel)) continue;
            ((TowerData.TowerLevel)it).getLevel().recordLookup(OperatorNameConventions.INVOKE);
        }
    }
}

