/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.checks.HardcodedCredentialsCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S2068")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J,\u0010!\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\u0004*\u00020'H\u0002J\f\u0010(\u001a\u00020)*\u00020\u0015H\u0002J\u001c\u0010*\u001a\u00020\u000e*\u00020\u00102\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u0004H\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedCredentialsCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "credentialWords", "", "getCredentialWords", "()Ljava/lang/String;", "setCredentialWords", "(Ljava/lang/String;)V", "literalPatterns", "Lkotlin/sequences/Sequence;", "Lkotlin/text/Regex;", "variablePatterns", "checkVariable", "", "ctx", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "variable", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "variableName", "value", "Lorg/jetbrains/kotlin/psi/KtElement;", "toPatterns", "suffix", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "checkAssignedValue", "matchResult", "Lkotlin/text/MatchResult;", "regex", "leftHand", "identifier", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNotEmptyString", "", "report", "tree", "matchName", "Companion", "sonar-kotlin-plugin"})
public final class HardcodedCredentialsCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd,passphrase")
    @NotNull
    private String credentialWords = "password,passwd,pwd,passphrase";
    @Nullable
    private Sequence<Regex> variablePatterns;
    @Nullable
    private Sequence<Regex> literalPatterns;
    @NotNull
    private static final String DEFAULT_VALUE = "password,passwd,pwd,passphrase";
    @NotNull
    private static final Regex URI_PREFIX = new Regex("^\\w{1,8}://");

    @NotNull
    public final String getCredentialWords() {
        return this.credentialWords;
    }

    public final void setCredentialWords(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.credentialWords = string2;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull KotlinFileContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EQ) && !Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.PLUSEQ)) break block1;
            KtExpression left = expression2.getLeft();
            Object object = left;
            if (object != null && (object = this.identifier((KtExpression)object)) != null) {
                Object it = object;
                boolean bl = false;
                PsiElement psiElement = left;
                KtExpression ktExpression = expression2.getRight();
                Intrinsics.checkNotNull(ktExpression);
                this.checkVariable(context, psiElement, (String)it, ktExpression);
            }
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property, @NotNull KotlinFileContext context) {
        block0: {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(context, "context");
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression == null) break block0;
            KtExpression it = ktExpression;
            boolean bl = false;
            PsiElement psiElement = property.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            String string2 = property.getName();
            Intrinsics.checkNotNull(string2);
            this.checkVariable(context, psiElement, string2, it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @NotNull KotlinFileContext context) {
        String content2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        String string2 = content2 = !expression2.hasInterpolation() ? this.asConstant(expression2) : "";
        if (HardcodedCredentialsCheck.Companion.isURIWithCredentials(content2)) {
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, context, expression2, "Review this hard-coded URL, which may contain a credential.", null, null, 12, null);
        } else {
            void $this$forEach$iv;
            Sequence sequence2 = SequencesKt.filter(SequencesKt.map(SequencesKt.mapNotNull(this.literalPatterns(), (Function1)new Function1<Regex, MatchResult>(content2){
                final /* synthetic */ String $content;
                {
                    this.$content = $content;
                    super(1);
                }

                @Nullable
                public final MatchResult invoke(@NotNull Regex regex) {
                    Intrinsics.checkNotNullParameter(regex, "regex");
                    return Regex.find$default(regex, this.$content, 0, 2, null);
                }
            }), visitStringTemplateExpression.2.INSTANCE), (Function1)new Function1<String, Boolean>(content2){
                final /* synthetic */ String $content;
                {
                    this.$content = $content;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String match) {
                    Intrinsics.checkNotNullParameter(match, "match");
                    return !org.sonarsource.kotlin.checks.HardcodedCredentialsCheck$Companion.access$isQuery(HardcodedCredentialsCheck.Companion, this.$content, match);
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String credential = (String)element$iv;
                boolean bl = false;
                this.report(context, expression2, credential);
            }
        }
    }

    private final boolean isNotEmptyString(KtElement $this$isNotEmptyString) {
        return $this$isNotEmptyString instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)$this$isNotEmptyString).hasInterpolation() && ((CharSequence)this.asConstant((KtStringTemplateExpression)$this$isNotEmptyString)).length() > 0;
    }

    private final void report(KotlinFileContext $this$report, PsiElement tree, String matchName) {
        AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, $this$report, tree, "\"" + matchName + "\" detected here, make sure this is not a hard-coded credential.", null, null, 12, null);
    }

    private final void checkAssignedValue(KotlinFileContext $this$checkAssignedValue, MatchResult matchResult, Regex regex, PsiElement leftHand, String value2) {
        if (!regex.containsMatchIn(value2)) {
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            Intrinsics.checkNotNull(matchGroup);
            this.report($this$checkAssignedValue, leftHand, matchGroup.getValue());
        }
    }

    private final String identifier(KtExpression $this$identifier) {
        String string2;
        KtExpression ktExpression = $this$identifier;
        if (ktExpression instanceof KtNameReferenceExpression) {
            string2 = ((KtNameReferenceExpression)$this$identifier).getReferencedName();
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression2 = ((KtDotQualifiedExpression)$this$identifier).getSelectorExpression();
            string2 = ktExpression2 != null ? this.identifier(ktExpression2) : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVariable(KotlinFileContext ctx, PsiElement variable2, String variableName, KtElement value2) {
        if (this.isNotEmptyString(value2)) {
            void $this$forEach$iv;
            Sequence sequence2 = SequencesKt.mapNotNull(this.variablePatterns(), (Function1)new Function1<Regex, Pair<? extends MatchResult, ? extends Regex>>(variableName){
                final /* synthetic */ String $variableName;
                {
                    this.$variableName = $variableName;
                    super(1);
                }

                @Nullable
                public final Pair<MatchResult, Regex> invoke(@NotNull Regex regex) {
                    Pair<MatchResult, Regex> pair;
                    Intrinsics.checkNotNullParameter(regex, "regex");
                    MatchResult matchResult = Regex.find$default(regex, this.$variableName, 0, 2, null);
                    if (matchResult != null) {
                        MatchResult it = matchResult;
                        boolean bl = false;
                        pair = TuplesKt.to(it, regex);
                    } else {
                        pair = null;
                    }
                    return pair;
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                MatchResult matcher = (MatchResult)pair.component1();
                Regex regex = (Regex)pair.component2();
                Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
                this.checkAssignedValue(ctx, matcher, regex, variable2, this.asConstant((KtStringTemplateExpression)value2));
            }
        }
    }

    private final Sequence<Regex> variablePatterns() {
        Sequence<Regex> sequence2 = this.variablePatterns;
        if (sequence2 == null) {
            sequence2 = this.toPatterns("");
        }
        return sequence2;
    }

    private final Sequence<Regex> literalPatterns() {
        Sequence<Regex> sequence2 = this.literalPatterns;
        if (sequence2 == null) {
            sequence2 = this.toPatterns("=\\S");
        }
        return sequence2;
    }

    private final Sequence<Regex> toPatterns(String suffix) {
        String[] stringArray = new String[]{","};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.credentialWords, stringArray, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull(stringArray2, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return SequencesKt.map(SequencesKt.map(ArraysKt.asSequence(stringArray2), toPatterns.1.INSTANCE), (Function1)new Function1<String, Regex>(suffix){
            final /* synthetic */ String $suffix;
            {
                this.$suffix = $suffix;
                super(1);
            }

            @NotNull
            public final Regex invoke(@NotNull String word) {
                Intrinsics.checkNotNullParameter(word, "word");
                return new Regex("(" + word + ")" + this.$suffix, RegexOption.IGNORE_CASE);
            }
        });
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/checks/HardcodedCredentialsCheck$Companion;", "", "()V", "DEFAULT_VALUE", "", "URI_PREFIX", "Lkotlin/text/Regex;", "isQuery", "", "value", "match", "isURIWithCredentials", "stringLiteral", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isURIWithCredentials(String stringLiteral) {
            if (URI_PREFIX.containsMatchIn(stringLiteral)) {
                try {
                    String userInfo = new URI(stringLiteral).getUserInfo();
                    if (userInfo != null) {
                        String[] stringArray = new String[]{":"};
                        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)userInfo, stringArray, false, 0, 6, null);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        Intrinsics.checkNotNull(stringArray2, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        String[] parts2 = stringArray2;
                        return parts2.length > 1 && !Intrinsics.areEqual(parts2[0], parts2[1]) && (parts2.length != 2 || !(((CharSequence)parts2[1]).length() == 0));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return false;
        }

        private final boolean isQuery(String value2, String match) {
            String string2 = value2.substring(StringsKt.indexOf$default((CharSequence)value2, match, 0, false, 6, null) + match.length());
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            String followingString = string2;
            return StringsKt.startsWith$default(followingString, "=?", false, 2, null) || StringsKt.startsWith$default(followingString, "=%", false, 2, null) || StringsKt.startsWith$default(followingString, "=:", false, 2, null) || StringsKt.startsWith$default(followingString, "={", false, 2, null) || Intrinsics.areEqual(followingString, "='");
        }

        public static final /* synthetic */ boolean access$isQuery(Companion $this, String value2, String match) {
            return $this.isQuery(value2, match);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

