/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.hostbased.UserAuthHostBasedFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.NamedFactoriesListParseResult;
import org.apache.sshd.common.util.GenericUtils;

public enum BuiltinUserAuthFactories implements NamedFactory<UserAuthFactory>
{
    PASSWORD(UserAuthPasswordFactory.INSTANCE),
    PUBLICKEY(UserAuthPublicKeyFactory.INSTANCE),
    KBINTERACTIVE(UserAuthKeyboardInteractiveFactory.INSTANCE),
    HOSTBASED(UserAuthHostBasedFactory.INSTANCE);

    public static final Set<BuiltinUserAuthFactories> VALUES;
    private final UserAuthFactory factory;

    private BuiltinUserAuthFactories(UserAuthFactory factory2) {
        this.factory = Objects.requireNonNull(factory2, "No delegate factory instance");
    }

    @Override
    public UserAuthFactory create() {
        return this.factory;
    }

    @Override
    public String getName() {
        return this.factory.getName();
    }

    public static UserAuthFactory fromFactoryName(String name) {
        Factory factory2 = NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
        if (factory2 == null) {
            return null;
        }
        return (UserAuthFactory)factory2.create();
    }

    public static ParseResult parseFactoriesList(String factories) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.split(factories, ','));
    }

    public static ParseResult parseFactoriesList(String ... factories) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.isEmpty((Object[])factories) ? Collections.emptyList() : Arrays.asList(factories));
    }

    public static ParseResult parseFactoriesList(Collection<String> factories) {
        if (GenericUtils.isEmpty(factories)) {
            return ParseResult.EMPTY;
        }
        ArrayList<UserAuthFactory> resolved = new ArrayList<UserAuthFactory>(factories.size());
        List<String> unknown = Collections.emptyList();
        for (String name : factories) {
            UserAuthFactory c = BuiltinUserAuthFactories.resolveFactory(name);
            if (c != null) {
                resolved.add(c);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<UserAuthFactory>)resolved, unknown);
    }

    public static UserAuthFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        return BuiltinUserAuthFactories.fromFactoryName(name);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinUserAuthFactories.class));
    }

    public static class ParseResult
    extends NamedFactoriesListParseResult<UserAuth, UserAuthFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<UserAuthFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

