/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.NetworkChannel;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class Nio2Service
extends AbstractInnerCloseable
implements IoService {
    public static final Map<Property<?>, AbstractMap.SimpleImmutableEntry<SocketOption<?>, Object>> CONFIGURABLE_OPTIONS;
    protected final Map<Long, IoSession> sessions;
    protected final AtomicBoolean disposing = new AtomicBoolean();
    protected final PropertyResolver propertyResolver;
    private final IoHandler handler;
    private final AsynchronousChannelGroup group;
    private final ExecutorService executor;
    private IoServiceEventListener eventListener;

    protected Nio2Service(PropertyResolver propertyResolver, IoHandler handler, AsynchronousChannelGroup group, ExecutorService resumeTasks) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating {}", (Object)this.getClass().getSimpleName());
        }
        this.propertyResolver = Objects.requireNonNull(propertyResolver, "No property resolver provided");
        this.handler = Objects.requireNonNull(handler, "No I/O handler provided");
        this.group = Objects.requireNonNull(group, "No async. channel group provided");
        this.executor = Objects.requireNonNull(resumeTasks, "No executor for resuming suspended sessions provided");
        this.sessions = new ConcurrentHashMap<Long, IoSession>();
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    protected AsynchronousChannelGroup getChannelGroup() {
        return this.group;
    }

    protected ExecutorService getExecutorService() {
        return this.executor;
    }

    public IoHandler getIoHandler() {
        return this.handler;
    }

    public void dispose() {
        try {
            if (this.disposing.getAndSet(true)) {
                this.log.warn("dispose({}) already disposing", (Object)this);
            }
            Duration maxWait = Closeable.getMaxCloseWaitTime(this.propertyResolver);
            boolean successful = this.close(true).await(maxWait, new CancelOption[0]);
            if (!successful) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait);
            }
        }
        catch (IOException e) {
            this.warn("dispose({}) {} while stopping service: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().parallel(this.toString(), this.sessions.values()).build();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public void sessionClosed(Nio2Session session) {
        this.unmapSession(session.getId());
    }

    protected void unmapSession(Long sessionId) {
        if (sessionId != null) {
            IoSession ioSession = this.sessions.remove(sessionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug("unmapSession(id={}): {}", (Object)sessionId, (Object)ioSession);
            }
        }
    }

    protected <S extends NetworkChannel> S setSocketOptions(S socket) throws IOException {
        Set<SocketOption<?>> supported = socket.supportedOptions();
        if (GenericUtils.isEmpty(supported)) {
            return socket;
        }
        for (Map.Entry<Property<?>, AbstractMap.SimpleImmutableEntry<SocketOption<?>, Object>> ce : CONFIGURABLE_OPTIONS.entrySet()) {
            Property<?> property = ce.getKey();
            Map.Entry defConfig = ce.getValue();
            SocketOption option = (SocketOption)defConfig.getKey();
            this.setOption(socket, property, option, defConfig.getValue());
        }
        return socket;
    }

    protected <T> boolean setOption(NetworkChannel socket, Property<?> property, SocketOption<T> option, T defaultValue) throws IOException {
        String valStr = this.propertyResolver.getString(property.getName());
        T val = defaultValue;
        if (!GenericUtils.isEmpty(valStr)) {
            Class<T> type = option.type();
            if (type == Integer.class) {
                val = type.cast(Integer.valueOf(valStr));
            } else if (type == Boolean.class) {
                val = type.cast(Boolean.valueOf(valStr));
            } else {
                throw new IllegalStateException("Unsupported socket option type (" + type + ") " + property + "=" + valStr);
            }
        }
        if (val == null) {
            return false;
        }
        Set<SocketOption<?>> supported = socket.supportedOptions();
        if (GenericUtils.isEmpty(supported) || !supported.contains(option)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unsupported socket option ({}) to set using {}={}", option, property, val);
            }
            return false;
        }
        try {
            socket.setOption(option, val);
            if (this.log.isDebugEnabled()) {
                this.log.debug("setOption({})[{}] from property={}", option, val, property);
            }
            return true;
        }
        catch (IOException | RuntimeException e) {
            this.log.warn("setOption({}): unable to set socket option {} via {}={}: {}", socket, option, property, val, e.toString());
            return false;
        }
    }

    static {
        LinkedHashMap<Property<Comparable<Boolean>>, AbstractMap.SimpleImmutableEntry<SocketOption<Comparable<Boolean>>, Object>> map = new LinkedHashMap<Property<Comparable<Boolean>>, AbstractMap.SimpleImmutableEntry<SocketOption<Comparable<Boolean>>, Object>>();
        map.put(CoreModuleProperties.SOCKET_KEEPALIVE, new AbstractMap.SimpleImmutableEntry<SocketOption<Boolean>, Object>(StandardSocketOptions.SO_KEEPALIVE, null));
        map.put(CoreModuleProperties.SOCKET_LINGER, new AbstractMap.SimpleImmutableEntry<SocketOption<Integer>, Object>(StandardSocketOptions.SO_LINGER, null));
        map.put(CoreModuleProperties.SOCKET_RCVBUF, new AbstractMap.SimpleImmutableEntry<SocketOption<Integer>, Object>(StandardSocketOptions.SO_RCVBUF, null));
        map.put(CoreModuleProperties.SOCKET_REUSEADDR, new AbstractMap.SimpleImmutableEntry<SocketOption<Boolean>, Boolean>(StandardSocketOptions.SO_REUSEADDR, true));
        map.put(CoreModuleProperties.SOCKET_SNDBUF, new AbstractMap.SimpleImmutableEntry<SocketOption<Integer>, Object>(StandardSocketOptions.SO_SNDBUF, null));
        map.put(CoreModuleProperties.TCP_NODELAY, new AbstractMap.SimpleImmutableEntry<SocketOption<Boolean>, Object>(StandardSocketOptions.TCP_NODELAY, null));
        CONFIGURABLE_OPTIONS = Collections.unmodifiableMap(map);
    }
}

