/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.PathScanningMatcher;

public class DirectoryScanner
extends PathScanningMatcher {
    protected Path basedir;

    public DirectoryScanner() {
    }

    public DirectoryScanner(Path dir) {
        this(dir, Collections.emptyList());
    }

    public DirectoryScanner(Path dir, String ... includes) {
        this(dir, GenericUtils.isEmpty(includes) ? Collections.emptyList() : Arrays.asList(includes));
    }

    public DirectoryScanner(Path dir, Collection<String> includes) {
        this.setBasedir(dir);
        this.setIncludes(includes);
    }

    public void setBasedir(Path basedir) {
        this.basedir = Objects.requireNonNull(basedir, "No base directory provided");
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Collection<Path> scan() throws IOException, IllegalStateException {
        return this.scan(LinkedList::new);
    }

    public <C extends Collection<Path>> C scan(Supplier<? extends C> factory2) throws IOException, IllegalStateException {
        String curSep;
        Path dir = this.getBasedir();
        if (dir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new IllegalStateException("basedir " + dir + " does not exist");
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalStateException("basedir " + dir + " is not a directory");
        }
        if (GenericUtils.isEmpty(this.getIncludes())) {
            throw new IllegalStateException("No includes set for " + dir);
        }
        FileSystem fs = dir.getFileSystem();
        String fsSep = fs.getSeparator();
        if (!Objects.equals(fsSep, curSep = this.getSeparator())) {
            throw new IllegalStateException("Mismatched separator - expected=" + curSep + ", actual=" + fsSep);
        }
        return (C)this.scandir(dir, dir, (Collection)factory2.get());
    }

    protected <C extends Collection<Path>> C scandir(Path rootDir, Path dir, C filesList) throws IOException {
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            for (Path p : ds) {
                Path rel = rootDir.relativize(p);
                String name = rel.toString();
                if (Files.isDirectory(p, new LinkOption[0])) {
                    if (this.isIncluded(name)) {
                        filesList.add((Path)p);
                        this.scandir(rootDir, p, filesList);
                        continue;
                    }
                    if (!this.couldHoldIncluded(name)) continue;
                    this.scandir(rootDir, p, filesList);
                    continue;
                }
                if (!Files.isRegularFile(p, new LinkOption[0]) || !this.isIncluded(name)) continue;
                filesList.add((Path)p);
            }
        }
        return filesList;
    }
}

