/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.MessageFormatting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.NewMessageFormatting;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueFlow;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssueLocation;
import org.sonar.api.batch.sensor.issue.internal.DefaultMessageFormatting;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.Preconditions;

public abstract class AbstractDefaultIssue<T extends AbstractDefaultIssue>
extends DefaultStorable {
    protected IssueLocation primaryLocation;
    protected List<DefaultIssueFlow> flows = new ArrayList<DefaultIssueFlow>();
    protected DefaultInputProject project;

    public AbstractDefaultIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(storage);
        this.project = project;
    }

    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    public List<Issue.Flow> flows() {
        return Collections.unmodifiableList(this.flows);
    }

    public NewIssueLocation newLocation() {
        return new DefaultIssueLocation();
    }

    public T at(NewIssueLocation primaryLocation) {
        Preconditions.checkArgument(primaryLocation != null, "Cannot use a location that is null");
        Preconditions.checkState(this.primaryLocation == null, "at() already called");
        this.primaryLocation = this.rewriteLocation((DefaultIssueLocation)primaryLocation);
        Preconditions.checkArgument(this.primaryLocation.inputComponent() != null, "Cannot use a location with no input component");
        return (T)this;
    }

    public T addLocation(NewIssueLocation secondaryLocation) {
        this.flows.add(new DefaultIssueFlow(List.of(this.rewriteLocation((DefaultIssueLocation)secondaryLocation)), NewIssue.FlowType.UNDEFINED, null));
        return (T)this;
    }

    public T addFlow(Iterable<NewIssueLocation> locations) {
        return this.addFlow(locations, NewIssue.FlowType.UNDEFINED, null);
    }

    public T addFlow(Iterable<NewIssueLocation> flowLocations, NewIssue.FlowType type, @Nullable String flowDescription) {
        Preconditions.checkArgument(type != null, "Type can't be null");
        ArrayList<IssueLocation> flowAsList = new ArrayList<IssueLocation>();
        for (NewIssueLocation issueLocation : flowLocations) {
            flowAsList.add(this.rewriteLocation((DefaultIssueLocation)issueLocation));
        }
        this.flows.add(new DefaultIssueFlow(flowAsList, type, flowDescription));
        return (T)this;
    }

    private DefaultIssueLocation rewriteLocation(DefaultIssueLocation location) {
        InputComponent component = location.inputComponent();
        Optional<Object> dirOrModulePath = Optional.empty();
        if (component instanceof DefaultInputDir) {
            DefaultInputDir dirComponent = (DefaultInputDir)component;
            dirOrModulePath = Optional.of(this.project.getBaseDir().relativize(dirComponent.path()));
        } else if (component instanceof DefaultInputModule && !Objects.equals(this.project.key(), component.key())) {
            DefaultInputModule moduleComponent = (DefaultInputModule)component;
            dirOrModulePath = Optional.of(this.project.getBaseDir().relativize(moduleComponent.getBaseDir()));
        }
        if (dirOrModulePath.isPresent()) {
            String path = PathUtils.sanitize(((Path)dirOrModulePath.get()).toString());
            DefaultIssueLocation fixedLocation = new DefaultIssueLocation();
            fixedLocation.on(this.project);
            StringBuilder fullMessage = new StringBuilder();
            Object prefixMessage = path != null && !path.isEmpty() ? "[" + path + "] " : "";
            fullMessage.append((String)prefixMessage);
            fullMessage.append(location.message());
            List paddedFormattings = location.messageFormattings().stream().map(arg_0 -> AbstractDefaultIssue.lambda$rewriteLocation$0((String)prefixMessage, arg_0)).collect(Collectors.toList());
            fixedLocation.message(fullMessage.toString(), paddedFormattings);
            return fixedLocation;
        }
        return location;
    }

    private static NewMessageFormatting padMessageFormatting(MessageFormatting messageFormatting, int length) {
        return new DefaultMessageFormatting().type(messageFormatting.type()).start(messageFormatting.start() + length).end(messageFormatting.end() + length);
    }

    private static /* synthetic */ NewMessageFormatting lambda$rewriteLocation$0(String prefixMessage, MessageFormatting m) {
        return AbstractDefaultIssue.padMessageFormatting(m, prefixMessage.length());
    }
}

