/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

class DurationLabel {
    private DurationLabel() {
    }

    public static Result label(long durationInMillis) {
        double nbSeconds = (double)durationInMillis / 1000.0;
        double nbMinutes = nbSeconds / 60.0;
        double nbHours = nbMinutes / 60.0;
        double nbDays = nbHours / 24.0;
        double nbYears = nbDays / 365.0;
        return DurationLabel.getMessage(nbSeconds, nbMinutes, nbHours, nbDays, nbYears);
    }

    private static Result getMessage(double nbSeconds, double nbMinutes, double nbHours, double nbDays, double nbYears) {
        if (nbSeconds < 45.0) {
            return DurationLabel.message("seconds");
        }
        if (nbSeconds < 90.0) {
            return DurationLabel.message("minute");
        }
        if (nbMinutes < 45.0) {
            return DurationLabel.message("minutes", Math.round(nbMinutes));
        }
        if (nbMinutes < 90.0) {
            return DurationLabel.message("hour");
        }
        if (nbHours < 24.0) {
            return DurationLabel.message("hours", Math.round(nbHours));
        }
        if (nbHours < 48.0) {
            return DurationLabel.message("day");
        }
        if (nbDays < 30.0) {
            return DurationLabel.message("days", (long)Math.floor(nbDays));
        }
        if (nbDays < 60.0) {
            return DurationLabel.message("month");
        }
        if (nbDays < 365.0) {
            return DurationLabel.message("months", (long)Math.floor(nbDays / 30.0));
        }
        if (nbYears < 2.0) {
            return DurationLabel.message("year");
        }
        return DurationLabel.message("years", (long)Math.floor(nbYears));
    }

    private static Result message(String key) {
        return DurationLabel.message(key, null);
    }

    private static Result message(String key, @Nullable Long value) {
        String durationPrefix = "duration.";
        return new Result(durationPrefix + key, value);
    }

    static class Result {
        private String key;
        private Long value;

        public Result(String key, @Nullable Long value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        @CheckForNull
        public Long value() {
            return this.value;
        }
    }
}

