/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.Uuids;

public class DefaultIssueComment
implements Serializable {
    private String issueKey;
    private String userUuid;
    private Date createdAt;
    private Date updatedAt;
    private String key;
    private String markdownText;
    private boolean isNew;

    public static DefaultIssueComment create(String issueKey, @Nullable String userUuid, String markdownText) {
        DefaultIssueComment comment = new DefaultIssueComment();
        comment.setIssueKey(issueKey);
        comment.setKey(Uuids.create());
        Date now = new Date();
        comment.setUserUuid(userUuid);
        comment.setMarkdownText(markdownText);
        comment.setCreatedAt(now).setUpdatedAt(now);
        comment.setNew(true);
        return comment;
    }

    public String markdownText() {
        return this.markdownText;
    }

    public DefaultIssueComment setMarkdownText(String s) {
        this.markdownText = s;
        return this;
    }

    public String issueKey() {
        return this.issueKey;
    }

    public DefaultIssueComment setIssueKey(String s) {
        this.issueKey = s;
        return this;
    }

    public String key() {
        return this.key;
    }

    public DefaultIssueComment setKey(String key) {
        this.key = key;
        return this;
    }

    @CheckForNull
    public String userUuid() {
        return this.userUuid;
    }

    public DefaultIssueComment setUserUuid(@Nullable String userUuid) {
        this.userUuid = userUuid;
        return this;
    }

    public Date createdAt() {
        return this.createdAt;
    }

    public DefaultIssueComment setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Date updatedAt() {
        return this.updatedAt;
    }

    public DefaultIssueComment setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public DefaultIssueComment setNew(boolean b) {
        this.isNew = b;
        return this;
    }
}

