/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FieldDiffs
implements Serializable {
    private static final String CHAR_TO_ESCAPE = "|,{}=:";
    private static final String ASSIGNEE = "assignee";
    private static final String ENCODING_PREFIX = "{base64:";
    private static final String ENCODING_SUFFIX = "}";
    private static final String WEBHOOK_SOURCE = "webhookSource";
    private static final String EXTERNAL_USER_KEY = "externalUser";
    private final Map<String, Diff> diffs = new LinkedHashMap<String, Diff>();
    private String issueKey = null;
    private String userUuid = null;
    private Date creationDate = null;
    private String externalUser = null;
    private String webhookSource = null;

    public Map<String, Diff> diffs() {
        if (this.diffs.containsKey(ASSIGNEE)) {
            LinkedHashMap<String, Diff> result = new LinkedHashMap<String, Diff>(this.diffs);
            result.put(ASSIGNEE, this.decode((Diff)result.get(ASSIGNEE)));
            return result;
        }
        return this.diffs;
    }

    public Diff get(String field) {
        if (field.equals(ASSIGNEE)) {
            return this.decode(this.diffs.get(ASSIGNEE));
        }
        return this.diffs.get(field);
    }

    public Optional<String> userUuid() {
        return Optional.ofNullable(this.userUuid);
    }

    public FieldDiffs setUserUuid(@Nullable String s) {
        this.userUuid = s;
        return this;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public FieldDiffs setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public Optional<String> issueKey() {
        return Optional.ofNullable(this.issueKey);
    }

    public FieldDiffs setIssueKey(@Nullable String issueKey) {
        this.issueKey = issueKey;
        return this;
    }

    public Optional<String> externalUser() {
        return Optional.ofNullable(this.externalUser);
    }

    public FieldDiffs setExternalUser(@Nullable String externalUser) {
        this.externalUser = externalUser;
        return this;
    }

    public Optional<String> webhookSource() {
        return Optional.ofNullable(this.webhookSource);
    }

    public FieldDiffs setWebhookSource(@Nullable String webhookSource) {
        this.webhookSource = webhookSource;
        return this;
    }

    public FieldDiffs setDiff(String field, @Nullable Serializable oldValue, @Nullable Serializable newValue) {
        Diff<Serializable> diff = this.diffs.get(field);
        if (field.equals(ASSIGNEE)) {
            oldValue = FieldDiffs.encodeField(oldValue);
            newValue = FieldDiffs.encodeField(newValue);
        }
        if (diff == null) {
            diff = new Diff<Serializable>(oldValue, newValue);
            this.diffs.put(field, diff);
        } else {
            diff.setNewValue(newValue);
        }
        return this;
    }

    public String toEncodedString() {
        return this.serialize(true);
    }

    public String toString() {
        return this.serialize(false);
    }

    private String serialize(boolean shouldEncode) {
        ArrayList<CallSite> serializedStrings = new ArrayList<CallSite>();
        if (StringUtils.isNotBlank(this.webhookSource)) {
            serializedStrings.add((CallSite)((Object)("webhookSource=" + this.webhookSource)));
        }
        if (StringUtils.isNotBlank(this.externalUser)) {
            serializedStrings.add((CallSite)((Object)("externalUser=" + this.externalUser)));
        }
        this.diffs.entrySet().stream().map(entry -> FieldDiffs.serializeKeyValuePair(shouldEncode, (String)entry.getKey(), (Diff)entry.getValue())).forEach(serializedStrings::add);
        return StringUtils.join(serializedStrings, ",");
    }

    private static String serializeKeyValuePair(boolean shouldEncode, String key, Diff values2) {
        String serializedValues = shouldEncode ? values2.toEncodedString() : values2.toString();
        return key + "=" + serializedValues;
    }

    public static FieldDiffs parse(@Nullable String s) {
        FieldDiffs diffs = new FieldDiffs();
        if (Strings.isNullOrEmpty(s)) {
            return diffs;
        }
        for (String field : s.split(",")) {
            if (field.isEmpty()) continue;
            String[] keyValues = field.split("=", 2);
            String key = keyValues[0];
            if (keyValues.length == 2) {
                String values2 = keyValues[1];
                if (EXTERNAL_USER_KEY.equals(key)) {
                    diffs.setExternalUser(StringUtils.trimToNull(values2));
                    continue;
                }
                if (WEBHOOK_SOURCE.equals(key)) {
                    diffs.setWebhookSource(StringUtils.trimToNull(values2));
                    continue;
                }
                FieldDiffs.addDiff(diffs, key, values2);
                continue;
            }
            diffs.setDiff(key, null, null);
        }
        return diffs;
    }

    private static void addDiff(FieldDiffs diffs, String key, String values2) {
        int split = values2.indexOf(124);
        if (split > -1) {
            diffs.setDiff(key, (Serializable)((Object)Strings.emptyToNull(values2.substring(0, split))), (Serializable)((Object)Strings.emptyToNull(values2.substring(split + 1))));
        } else {
            diffs.setDiff(key, null, (Serializable)((Object)Strings.emptyToNull(values2)));
        }
    }

    Diff decode(Diff encoded) {
        return new Diff<Serializable>(FieldDiffs.decodeField(encoded.oldValue), FieldDiffs.decodeField(encoded.newValue));
    }

    private static Serializable decodeField(@Nullable Serializable field) {
        if (field == null || !FieldDiffs.isEncoded(field)) {
            return field;
        }
        String encodedField = field.toString();
        String value = encodedField.substring(ENCODING_PREFIX.length(), encodedField.indexOf(ENCODING_SUFFIX));
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }

    private static Serializable encodeField(@Nullable Serializable field) {
        if (field == null || !FieldDiffs.shouldEncode(field.toString())) {
            return field;
        }
        return ENCODING_PREFIX + Base64.getEncoder().encodeToString(field.toString().getBytes(StandardCharsets.UTF_8)) + ENCODING_SUFFIX;
    }

    private static boolean shouldEncode(String field) {
        return !field.isEmpty() && !FieldDiffs.isEncoded((Serializable)((Object)field)) && FieldDiffs.containsCharToEscape((Serializable)((Object)field));
    }

    private static boolean containsCharToEscape(Serializable s) {
        return StringUtils.containsAny(s.toString(), CHAR_TO_ESCAPE);
    }

    private static boolean isEncoded(Serializable field) {
        return field.toString().startsWith(ENCODING_PREFIX) && field.toString().endsWith(ENCODING_SUFFIX);
    }

    public static class Diff<T extends Serializable>
    implements Serializable {
        private T oldValue;
        private T newValue;

        public Diff(@Nullable T oldValue, @Nullable T newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @CheckForNull
        public T oldValue() {
            return this.oldValue;
        }

        @CheckForNull
        public Long oldValueLong() {
            return Diff.toLong(this.oldValue);
        }

        @CheckForNull
        public T newValue() {
            return this.newValue;
        }

        @CheckForNull
        public Long newValueLong() {
            return Diff.toLong(this.newValue);
        }

        void setNewValue(@Nullable T t) {
            this.newValue = t;
        }

        @CheckForNull
        private static Long toLong(@Nullable Serializable value) {
            if (value != null && !"".equals(value)) {
                try {
                    return Long.valueOf((String)((Object)value));
                }
                catch (ClassCastException e) {
                    return (Long)value;
                }
            }
            return null;
        }

        private String toEncodedString() {
            return this.serialize(true);
        }

        public String toString() {
            return this.serialize(false);
        }

        private String serialize(boolean shouldEncode) {
            StringBuilder sb = new StringBuilder();
            if (this.oldValue != null) {
                sb.append(shouldEncode ? this.oldValue : FieldDiffs.decodeField(this.oldValue));
                sb.append('|');
            }
            if (this.newValue != null) {
                sb.append(shouldEncode ? this.newValue : FieldDiffs.decodeField(this.newValue));
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Diff diff = (Diff)o;
            return Objects.equals(this.oldValue, diff.oldValue) && Objects.equals(this.newValue, diff.newValue);
        }

        public int hashCode() {
            return Objects.hash(this.oldValue, this.newValue);
        }
    }
}

