/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import java.util.Collection;
import java.util.List;
import org.sonar.core.issue.tracking.BlockHashSequence;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.core.issue.tracking.Trackable;

public abstract class LazyInput<ISSUE extends Trackable>
implements Input<ISSUE> {
    private List<ISSUE> issues;
    private LineHashSequence lineHashSeq;
    private BlockHashSequence blockHashSeq;

    @Override
    public LineHashSequence getLineHashSequence() {
        if (this.lineHashSeq == null) {
            this.lineHashSeq = this.loadLineHashSequence();
        }
        return this.lineHashSeq;
    }

    @Override
    public BlockHashSequence getBlockHashSequence() {
        if (this.blockHashSeq == null) {
            this.blockHashSeq = BlockHashSequence.create(this.getLineHashSequence());
        }
        return this.blockHashSeq;
    }

    @Override
    public Collection<ISSUE> getIssues() {
        if (this.issues == null) {
            this.issues = this.loadIssues();
        }
        return this.issues;
    }

    protected abstract LineHashSequence loadLineHashSequence();

    protected abstract List<ISSUE> loadIssues();
}

