/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import com.google.gson.annotations.SerializedName;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.sarif.Rule;

public class Driver {
    @SerializedName(value="name")
    private final String name;
    @SerializedName(value="organization")
    private final String organization;
    @SerializedName(value="semanticVersion")
    private final String semanticVersion;
    @SerializedName(value="rules")
    private final Set<Rule> rules;

    private Driver(String name, @Nullable String organization, @Nullable String semanticVersion, Set<Rule> rules) {
        this.name = name;
        this.organization = organization;
        this.semanticVersion = semanticVersion;
        this.rules = Set.copyOf(rules);
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    @CheckForNull
    public String getSemanticVersion() {
        return this.semanticVersion;
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    public static DriverBuilder builder() {
        return new DriverBuilder();
    }

    public static final class DriverBuilder {
        private String name;
        private String organization;
        private String semanticVersion;
        private Set<Rule> rules;

        private DriverBuilder() {
        }

        public DriverBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DriverBuilder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public DriverBuilder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public DriverBuilder rules(Set<Rule> rules) {
            this.rules = rules;
            return this;
        }

        public Driver build() {
            return new Driver(this.name, this.organization, this.semanticVersion, this.rules);
        }
    }
}

