/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class UtcDateUtils {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ").withZone(ZoneOffset.UTC);

    private UtcDateUtils() {
    }

    public static String formatDateTime(Date date) {
        return formatter.format(date.toInstant());
    }

    public static Date parseDateTime(String s) {
        try {
            return Date.from(OffsetDateTime.parse(s, formatter).toInstant());
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Fail to parse date: " + s, e);
        }
    }
}

