/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.sonar.duplications.detector.suffixtree.Edge;
import org.sonar.duplications.detector.suffixtree.Node;
import org.sonar.duplications.detector.suffixtree.SuffixTree;
import org.sonar.duplications.detector.suffixtree.TextSet;

public final class Search {
    private final SuffixTree tree;
    private final TextSet text;
    private final Collector reporter;
    private final List<Integer> list = new ArrayList<Integer>();
    private final List<Node> innerNodes = new ArrayList<Node>();
    private static final Comparator<Node> DEPTH_COMPARATOR = (o1, o2) -> o2.depth - o1.depth;

    private Search(SuffixTree tree, TextSet text, Collector reporter) {
        this.tree = tree;
        this.text = text;
        this.reporter = reporter;
    }

    public static void perform(TextSet text, Collector reporter) {
        new Search(SuffixTree.create(text), text, reporter).compute();
    }

    private void compute() {
        this.dfs();
        Collections.sort(this.innerNodes, DEPTH_COMPARATOR);
        this.visitInnerNodes();
    }

    private void dfs() {
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.add(this.tree.getRootNode());
        while (!stack.isEmpty()) {
            Node node = (Node)stack.removeLast();
            node.startSize = this.list.size();
            if (node.getEdges().isEmpty()) {
                this.list.add(node.depth);
                node.endSize = this.list.size();
                continue;
            }
            if (!node.equals(this.tree.getRootNode())) {
                this.innerNodes.add(node);
            }
            for (Edge edge : node.getEdges()) {
                Node endNode = edge.getEndNode();
                endNode.depth = node.depth + edge.getSpan() + 1;
                stack.addLast(endNode);
            }
        }
        ListIterator<Node> iterator2 = this.innerNodes.listIterator(this.innerNodes.size());
        while (iterator2.hasPrevious()) {
            Node node = iterator2.previous();
            int max = -1;
            for (Edge edge : node.getEdges()) {
                max = Math.max(edge.getEndNode().endSize, max);
            }
            node.endSize = max;
        }
    }

    private void visitInnerNodes() {
        for (Node node : this.innerNodes) {
            if (!this.containsOrigin(node)) continue;
            this.report(node);
        }
    }

    private boolean containsOrigin(Node node) {
        for (int i = node.startSize; i < node.endSize; ++i) {
            int start = this.tree.text.length() - this.list.get(i);
            int end = start + node.depth;
            if (!this.text.isInsideOrigin(end)) continue;
            return true;
        }
        return false;
    }

    private void report(Node node) {
        this.reporter.startOfGroup(node.endSize - node.startSize, node.depth);
        for (int i = node.startSize; i < node.endSize; ++i) {
            int start = this.tree.text.length() - this.list.get(i);
            int end = start + node.depth;
            this.reporter.part(start, end);
        }
        this.reporter.endOfGroup();
    }

    public static abstract class Collector {
        abstract void startOfGroup(int var1, int var2);

        abstract void part(int var1, int var2);

        abstract void endOfGroup();
    }
}

