/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.analysis;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.impl.utils.DefaultTempFolder;
import org.sonar.api.utils.TempFolder;
import org.springframework.context.annotation.Bean;

public class AnalysisTempFolderProvider {
    static final String TMP_NAME = ".sonartmp";

    @Bean(value={"AnalysisTempFolder"})
    public TempFolder provide(DefaultInputProject project) {
        Path workingDir = project.getWorkDir();
        Path tempDir = workingDir.normalize().resolve(TMP_NAME);
        try {
            Files.deleteIfExists(tempDir);
            Files.createDirectories(tempDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create root temp directory " + tempDir, e);
        }
        return new DefaultTempFolder(tempDir.toFile(), true);
    }
}

